/* ethos-manager.h
 *
 * Copyright (C) 2009 Christian Hergert <chris@dronelabs.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston MA 
 * 02110-1301 USA
 */

#ifndef __ETHOS_MANAGER_H__
#define __ETHOS_MANAGER_H__

#include <glib-object.h>

#include "ethos-plugin.h"
#include "ethos-plugin-info.h"

G_BEGIN_DECLS

#define ETHOS_TYPE_MANAGER		(ethos_manager_get_type ())
#define ETHOS_MANAGER(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), ETHOS_TYPE_MANAGER, EthosManager))
#define ETHOS_MANAGER_CONST(obj)	(G_TYPE_CHECK_INSTANCE_CAST ((obj), ETHOS_TYPE_MANAGER, EthosManager const))
#define ETHOS_MANAGER_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass),  ETHOS_TYPE_MANAGER, EthosManagerClass))
#define ETHOS_IS_MANAGER(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), ETHOS_TYPE_MANAGER))
#define ETHOS_IS_MANAGER_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass),  ETHOS_TYPE_MANAGER))
#define ETHOS_MANAGER_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  ETHOS_TYPE_MANAGER, EthosManagerClass))

typedef struct _EthosManager		EthosManager;
typedef struct _EthosManagerClass	EthosManagerClass;
typedef struct _EthosManagerPrivate	EthosManagerPrivate;

struct _EthosManager
{
	GObject parent;

	EthosManagerPrivate *priv;
};

struct _EthosManagerClass
{
	GObjectClass parent_class;

	void     (*initialized)     (EthosManager     *manager);
	gboolean (*load_plugin)     (EthosManager     *manager,
	                             EthosPlugin      *plugin,
	                             GError          **error);
	gboolean (*unload_plugin)   (EthosManager     *manager,
	                             EthosPlugin      *plugin,
	                             GError          **error);
	void     (*plugin_loaded)   (EthosManager     *manager,
	                             EthosPluginInfo  *plugin_info);
	void     (*plugin_unloaded) (EthosManager     *manager,
	                             EthosPluginInfo  *plugin_info);

	void     (*reserved1)       (void);
	void     (*reserved2)       (void);
	void     (*reserved3)       (void);
	void     (*reserved4)       (void);
	void     (*reserved5)       (void);
	void     (*reserved6)       (void);
	void     (*reserved7)       (void);
	void     (*reserved8)       (void);
};

GType                  ethos_manager_get_type           (void) G_GNUC_CONST;
EthosManager*          ethos_manager_new                (void);
EthosManager*          ethos_manager_new_full           (const gchar      *app_name,
                                                         gchar           **plugin_dirs);
void                   ethos_manager_initialize         (EthosManager     *manager);
void                   ethos_manager_unload             (EthosManager     *manager);
gboolean               ethos_manager_load_plugin        (EthosManager     *manager,
                                                         EthosPluginInfo  *plugin_info,
                                                         GError          **error);
gboolean               ethos_manager_unload_plugin      (EthosManager     *manager,
                                                         EthosPluginInfo  *plugin_info,
                                                         GError          **error);
GList*                 ethos_manager_get_plugin_info    (EthosManager     *manager);
EthosPlugin*           ethos_manager_get_plugin         (EthosManager     *manager,
                                                         EthosPluginInfo  *plugin_info);
GList*                 ethos_manager_get_plugin_loaders (EthosManager     *manager);
G_CONST_RETURN gchar** ethos_manager_get_plugin_dirs    (EthosManager     *manager);
void                   ethos_manager_set_plugin_dirs    (EthosManager     *manager,
                                                         gchar           **plugin_dirs);
G_CONST_RETURN gchar*  ethos_manager_get_app_name       (EthosManager     *manager);
void                   ethos_manager_set_app_name       (EthosManager     *manager,
                                                         const gchar      *app_name);

G_END_DECLS

#endif /* __ETHOS_MANAGER_H__ */
