% COSH COSH Hyperbolic Cosine Function
% 
% Usage
% 
% Computes the hyperbolic cosine of the argument.
% The syntax for its use is
% 
%    y = cosh(x)
% 

% Copyright (c) 2002-2007 Samit Basu
% Licensed under the GPL

function y = cosh(x)
  if (nargin == 0 || ~isnumeric(x))
    error('cosh expects a numeric input');
  end
  y = (exp(x)+exp(-x))/2;
  
