/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;

public class ParallelReader
extends IndexReader {
    private List readers = new ArrayList();
    private SortedMap fieldToReader = new TreeMap();
    private Map readerToFields = new HashMap();
    private List storedFieldReaders = new ArrayList();
    private int maxDoc;
    private int numDocs;
    private boolean hasDeletions;

    public ParallelReader() throws IOException {
        super(null);
    }

    public void add(IndexReader reader) throws IOException {
        this.add(reader, false);
    }

    public void add(IndexReader reader, boolean ignoreStoredFields) throws IOException {
        if (this.readers.size() == 0) {
            this.maxDoc = reader.maxDoc();
            this.numDocs = reader.numDocs();
            this.hasDeletions = reader.hasDeletions();
        }
        if (reader.maxDoc() != this.maxDoc) {
            throw new IllegalArgumentException("All readers must have same maxDoc: " + this.maxDoc + "!=" + reader.maxDoc());
        }
        if (reader.numDocs() != this.numDocs) {
            throw new IllegalArgumentException("All readers must have same numDocs: " + this.numDocs + "!=" + reader.numDocs());
        }
        Collection fields = reader.getFieldNames(IndexReader.FieldOption.ALL);
        this.readerToFields.put(reader, fields);
        Iterator i = fields.iterator();
        while (i.hasNext()) {
            String field = (String)i.next();
            if (this.fieldToReader.get(field) != null) continue;
            this.fieldToReader.put(field, reader);
        }
        if (!ignoreStoredFields) {
            this.storedFieldReaders.add(reader);
        }
        this.readers.add(reader);
    }

    public int numDocs() {
        return this.numDocs;
    }

    public int maxDoc() {
        return this.maxDoc;
    }

    public boolean hasDeletions() {
        return this.hasDeletions;
    }

    public boolean isDeleted(int n) {
        if (this.readers.size() > 0) {
            return ((IndexReader)this.readers.get(0)).isDeleted(n);
        }
        return false;
    }

    protected void doDelete(int n) throws IOException {
        for (int i = 0; i < this.readers.size(); ++i) {
            ((IndexReader)this.readers.get(i)).deleteDocument(n);
        }
        this.hasDeletions = true;
    }

    protected void doUndeleteAll() throws IOException {
        for (int i = 0; i < this.readers.size(); ++i) {
            ((IndexReader)this.readers.get(i)).undeleteAll();
        }
        this.hasDeletions = false;
    }

    public Document document(int n, FieldSelector fieldSelector) throws IOException {
        Document result = new Document();
        for (int i = 0; i < this.storedFieldReaders.size(); ++i) {
            boolean include;
            IndexReader reader = (IndexReader)this.storedFieldReaders.get(i);
            boolean bl = include = fieldSelector == null;
            if (!include) {
                Iterator it = ((Collection)this.readerToFields.get(reader)).iterator();
                while (it.hasNext()) {
                    if (fieldSelector.accept((String)it.next()) == FieldSelectorResult.NO_LOAD) continue;
                    include = true;
                    break;
                }
            }
            if (!include) continue;
            Iterator fieldIterator = reader.document(n, fieldSelector).getFields().iterator();
            while (fieldIterator.hasNext()) {
                result.add((Fieldable)fieldIterator.next());
            }
        }
        return result;
    }

    public TermFreqVector[] getTermFreqVectors(int n) throws IOException {
        ArrayList<TermFreqVector> results = new ArrayList<TermFreqVector>();
        Iterator i = this.fieldToReader.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String field = (String)e.getKey();
            IndexReader reader = (IndexReader)e.getValue();
            TermFreqVector vector = reader.getTermFreqVector(n, field);
            if (vector == null) continue;
            results.add(vector);
        }
        return results.toArray(new TermFreqVector[results.size()]);
    }

    public TermFreqVector getTermFreqVector(int n, String field) throws IOException {
        IndexReader reader = (IndexReader)this.fieldToReader.get(field);
        return reader == null ? null : reader.getTermFreqVector(n, field);
    }

    public boolean hasNorms(String field) throws IOException {
        IndexReader reader = (IndexReader)this.fieldToReader.get(field);
        return reader == null ? false : reader.hasNorms(field);
    }

    public byte[] norms(String field) throws IOException {
        IndexReader reader = (IndexReader)this.fieldToReader.get(field);
        return reader == null ? null : reader.norms(field);
    }

    public void norms(String field, byte[] result, int offset) throws IOException {
        IndexReader reader = (IndexReader)this.fieldToReader.get(field);
        if (reader != null) {
            reader.norms(field, result, offset);
        }
    }

    protected void doSetNorm(int n, String field, byte value) throws IOException {
        IndexReader reader = (IndexReader)this.fieldToReader.get(field);
        if (reader != null) {
            reader.doSetNorm(n, field, value);
        }
    }

    public TermEnum terms() throws IOException {
        return new ParallelTermEnum();
    }

    public TermEnum terms(Term term) throws IOException {
        return new ParallelTermEnum(term);
    }

    public int docFreq(Term term) throws IOException {
        IndexReader reader = (IndexReader)this.fieldToReader.get(term.field());
        return reader == null ? 0 : reader.docFreq(term);
    }

    public TermDocs termDocs(Term term) throws IOException {
        return new ParallelTermDocs(term);
    }

    public TermDocs termDocs() throws IOException {
        return new ParallelTermDocs();
    }

    public TermPositions termPositions(Term term) throws IOException {
        return new ParallelTermPositions(term);
    }

    public TermPositions termPositions() throws IOException {
        return new ParallelTermPositions();
    }

    protected void doCommit() throws IOException {
        for (int i = 0; i < this.readers.size(); ++i) {
            ((IndexReader)this.readers.get(i)).commit();
        }
    }

    protected synchronized void doClose() throws IOException {
        for (int i = 0; i < this.readers.size(); ++i) {
            ((IndexReader)this.readers.get(i)).close();
        }
    }

    public Collection getFieldNames(IndexReader.FieldOption fieldNames) {
        HashSet fieldSet = new HashSet();
        for (int i = 0; i < this.readers.size(); ++i) {
            IndexReader reader = (IndexReader)this.readers.get(i);
            Collection names = reader.getFieldNames(fieldNames);
            fieldSet.addAll(names);
        }
        return fieldSet;
    }

    private class ParallelTermPositions
    extends ParallelTermDocs
    implements TermPositions {
        public ParallelTermPositions() {
        }

        public ParallelTermPositions(Term term) throws IOException {
            this.seek(term);
        }

        public void seek(Term term) throws IOException {
            IndexReader reader = (IndexReader)ParallelReader.this.fieldToReader.get(term.field());
            this.termDocs = reader != null ? reader.termPositions(term) : null;
        }

        public int nextPosition() throws IOException {
            return ((TermPositions)this.termDocs).nextPosition();
        }
    }

    private class ParallelTermDocs
    implements TermDocs {
        protected TermDocs termDocs;

        public ParallelTermDocs() {
        }

        public ParallelTermDocs(Term term) throws IOException {
            this.seek(term);
        }

        public int doc() {
            return this.termDocs.doc();
        }

        public int freq() {
            return this.termDocs.freq();
        }

        public void seek(Term term) throws IOException {
            IndexReader reader = (IndexReader)ParallelReader.this.fieldToReader.get(term.field());
            this.termDocs = reader != null ? reader.termDocs(term) : null;
        }

        public void seek(TermEnum termEnum) throws IOException {
            this.seek(termEnum.term());
        }

        public boolean next() throws IOException {
            if (this.termDocs == null) {
                return false;
            }
            return this.termDocs.next();
        }

        public int read(int[] docs, int[] freqs) throws IOException {
            if (this.termDocs == null) {
                return 0;
            }
            return this.termDocs.read(docs, freqs);
        }

        public boolean skipTo(int target) throws IOException {
            if (this.termDocs == null) {
                return false;
            }
            return this.termDocs.skipTo(target);
        }

        public void close() throws IOException {
            if (this.termDocs != null) {
                this.termDocs.close();
            }
        }
    }

    private class ParallelTermEnum
    extends TermEnum {
        private String field;
        private Iterator fieldIterator;
        private TermEnum termEnum;

        public ParallelTermEnum() throws IOException {
            this.field = (String)ParallelReader.this.fieldToReader.firstKey();
            if (this.field != null) {
                this.termEnum = ((IndexReader)ParallelReader.this.fieldToReader.get(this.field)).terms();
            }
        }

        public ParallelTermEnum(Term term) throws IOException {
            this.field = term.field();
            IndexReader reader = (IndexReader)ParallelReader.this.fieldToReader.get(this.field);
            if (reader != null) {
                this.termEnum = reader.terms(term);
            }
        }

        public boolean next() throws IOException {
            if (this.termEnum == null) {
                return false;
            }
            if (this.termEnum.next() && this.termEnum.term().field() == this.field) {
                return true;
            }
            this.termEnum.close();
            if (this.fieldIterator == null) {
                this.fieldIterator = ParallelReader.this.fieldToReader.tailMap(this.field).keySet().iterator();
                this.fieldIterator.next();
            }
            while (this.fieldIterator.hasNext()) {
                this.field = (String)this.fieldIterator.next();
                this.termEnum = ((IndexReader)ParallelReader.this.fieldToReader.get(this.field)).terms(new Term(this.field, ""));
                Term term = this.termEnum.term();
                if (term != null && term.field() == this.field) {
                    return true;
                }
                this.termEnum.close();
            }
            return false;
        }

        public Term term() {
            if (this.termEnum == null) {
                return null;
            }
            return this.termEnum.term();
        }

        public int docFreq() {
            if (this.termEnum == null) {
                return 0;
            }
            return this.termEnum.docFreq();
        }

        public void close() throws IOException {
            if (this.termEnum != null) {
                this.termEnum.close();
            }
        }
    }
}

