/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.spans.Spans;

class SpanScorer
extends Scorer {
    private Spans spans;
    private Weight weight;
    private byte[] norms;
    private float value;
    private boolean firstTime = true;
    private boolean more = true;
    private int doc;
    private float freq;

    SpanScorer(Spans spans, Weight weight, Similarity similarity, byte[] norms) throws IOException {
        super(similarity);
        this.spans = spans;
        this.norms = norms;
        this.weight = weight;
        this.value = weight.getValue();
        this.doc = -1;
    }

    public boolean next() throws IOException {
        if (this.firstTime) {
            this.more = this.spans.next();
            this.firstTime = false;
        }
        return this.setFreqCurrentDoc();
    }

    public boolean skipTo(int target) throws IOException {
        if (this.firstTime) {
            this.more = this.spans.skipTo(target);
            this.firstTime = false;
        }
        if (!this.more) {
            return false;
        }
        if (this.spans.doc() < target) {
            this.more = this.spans.skipTo(target);
        }
        return this.setFreqCurrentDoc();
    }

    private boolean setFreqCurrentDoc() throws IOException {
        if (!this.more) {
            return false;
        }
        this.doc = this.spans.doc();
        this.freq = 0.0f;
        while (this.more && this.doc == this.spans.doc()) {
            int matchLength = this.spans.end() - this.spans.start();
            this.freq += this.getSimilarity().sloppyFreq(matchLength);
            this.more = this.spans.next();
        }
        return this.more || this.freq != 0.0f;
    }

    public int doc() {
        return this.doc;
    }

    public float score() throws IOException {
        float raw = this.getSimilarity().tf(this.freq) * this.value;
        return raw * Similarity.decodeNorm(this.norms[this.doc]);
    }

    public Explanation explain(int doc) throws IOException {
        Explanation tfExplanation = new Explanation();
        this.skipTo(doc);
        float phraseFreq = this.doc() == doc ? this.freq : 0.0f;
        tfExplanation.setValue(this.getSimilarity().tf(phraseFreq));
        tfExplanation.setDescription("tf(phraseFreq=" + phraseFreq + ")");
        return tfExplanation;
    }
}

