/*
 *  Copyright (C) 2006  MakeHuman Project
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *  
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 *  File   : Size.h
 *  Project: MakeHuman <info@makehuman.org>, http://www.makehuman.org/
 *  Library: MHGUI
 *
 *  For individual developers look into the AUTHORS file.
 *   
 */

#ifndef SIZE_H
#define SIZE_H 1

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#include <stdint.h>

namespace mhgui {

/*!
 * Trivial class which stores a size in integer notation. 
 * This is supposed to be used by the GUI.
 */

class Size
{
public:
     Size (int32_t inWidth, int32_t inHeight);
     Size (const Size& inSize);                
    
    ~Size () {}

    Size& operator= (const Size& inRHS);

    bool operator== (const Size& inSize) const;

    bool isEmpty() const { return ((mWidth == 0) && (mHeight == 0));}

    int32_t getWidth ()  const {return mWidth;}
    int32_t getHeight() const {return mHeight;}

    void resizeBy(const Size& inSize);

/* ==========================================================================
 * Members
 * ========================================================================== */
private:
    int32_t    mWidth, mHeight;

/* ==========================================================================
 * Static Methods
 * ========================================================================== */
public:

/* ==========================================================================
 * Static Members
 * ========================================================================== */
public:
}; // class Size

/* ==========================================================================
 * Inlines & Templates
 * ========================================================================== */
/* ========================================================================== */
/**
 */
/* ========================================================================== */
inline Size::Size(int32_t inWidth, int32_t inHeight)  
: mWidth (inWidth),
  mHeight(inHeight) 
{
}

/* ========================================================================== */
/**
 */
/* ========================================================================== */
inline Size::Size(const Size& inSize)                
: mWidth (inSize.mWidth), 
  mHeight(inSize.mHeight) 
{
}

/* ========================================================================== */
/**
 */
/* ========================================================================== */
inline Size& Size::operator= (const Size& inRHS) 
{ 
    mWidth  = inRHS.mWidth; 
    mHeight = inRHS.mHeight; 
    return *this;
}

/* ========================================================================== */
/**
 */
/* ========================================================================== */
inline bool Size::operator== (const Size& inSize) const
{ 
    if (this == &inSize)  // The same object?
        return true;

    return (mWidth  == inSize.mWidth && 
            mHeight == inSize.mHeight);
}

/* ========================================================================== */
/**
 */
/* ========================================================================== */
inline void Size::resizeBy(const Size& inSize)
{
    mWidth += inSize.mWidth; mHeight += inSize.mHeight;
}

} // namespace mhgui

#endif // SIZE_H
