# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

"""
Create a splash Screen
"""

__maintainer__ = 'Benjamin Kampmann <benjamin@fluendo.com>'

import pkg_resources
from elisa.core.utils import locale_helper

# not unicode: pycairo doesn't support it (see below)
LOGO_PATH = pkg_resources.resource_filename('elisa.core', 'data/splash.png')

# not unicode: but it is converted later on (see below). Kept as it is
# for consistency.
LOGO_PATH_SQUARE = pkg_resources.resource_filename('elisa.core',
                                                   'data/splash.png')

try:
    import gtk
    import cairo
except ImportError:
    SplashScreen = None
else:
    class SplashScreen(gtk.Window):
        """
        GTK-Based SplashScreen
        """
        def on_expose(self, window, event, surface):
            cr = window.window.cairo_create()
            cr.set_operator(cairo.OPERATOR_SOURCE)
            cr.set_source_rgba(1.0, 1.0, 1.0, 0.0)
            cr.paint()
            cr.set_source_surface(surface)
            cr.paint()
            return True

        def __init__(self):
            gtk.Window.__init__(self,gtk.WINDOW_POPUP)

            self.set_decorated(False)
            self.set_position(gtk.WIN_POS_CENTER_ALWAYS)
            try:
                gtk.window_set_auto_startup_notification(False)
            except:
                # Only available in pygtk 2.2 and above, so we don't want
                # to fail if it does not exist
                pass

            # Take responsibility for drawing the window background 
            self.set_app_paintable(True)

            screen = self.get_screen()

            if screen.is_composited():
                # pycairo doesn't support unicode so LOGO_PATH needs
                # to remain a byte string.
                surface = cairo.ImageSurface.create_from_png(LOGO_PATH)
                width, height = surface.get_width(), surface.get_height()

                rgba_colormap = screen.get_rgba_colormap()
                self.set_colormap(rgba_colormap)
                self.connect("expose-event", self.on_expose, surface)
            else:
                # gdk-pixbuf supports unicode, so it's safe to decode
                # the logo path to system encoding and use the
                # resulting unicode string.
                logo_path = LOGO_PATH_SQUARE.decode(locale_helper.system_encoding())
                pixbuf = gtk.gdk.pixbuf_new_from_file(logo_path)
                pixmap, mask = pixbuf.render_pixmap_and_mask()
                width, height = pixmap.get_size()

                self.realize()
                self.window.set_back_pixmap(pixmap, False)
                if mask is not None:
                    self.shape_combine_mask(mask, 0, 0)

            # Resize the window to fit the image size
            self.resize(width, height)
