# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Benjamin Kampmann <benjamin@fluendo.com>

"""
models for the filtered shares
"""

from elisa.core.components.model import Model

class FilteredSharesModel(Model):
    """
    The filtered shares model is the result merging and filtering multiple
    network services.

    @ivar filter: the filter to apply
    @type filter: C{set}
    @ivar services: matching the filter
    @type services: C{list} of
            L{elisa.plugins.base.models.network.NetworkServiceModel}s
    """
    def __init__(self):
        super(FilteredSharesModel, self).__init__()
        self.filter = None
        self.services = []

