# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Olivier Tilloy <olivier@fluendo.com>

from twisted.trial.unittest import TestCase

from elisa.core.media_uri import MediaUri

from elisa.plugins.discogs.discogs_api import SERVER, API_KEY, \
                                              generate_api_request


class TestDiscogsAPI(TestCase):

    def test_generate_api_request(self):
        path = u'/artist/Dream+Theater'
        expected = MediaUri('%s%s?f=xml&api_key=%s' % (SERVER, path, API_KEY))
        self.failUnlessEqual(generate_api_request(path), expected)

