# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

"""
Messages for device arrival/removal
"""

from elisa.core.components.message import Message

class NewDeviceDetected(Message):
    """
    Sent over the L{elisa.core.bus.Bus} when a new device is detected. At this
    point we know everything necessary about the device. Each device has a
    unique ID to identify it.

    @ivar udi:      the unique id for that certain device
    @type udi:      C{str}
    @ivar model:    representing the new found device
    @type model:    C{elisa.plugins.base.models.volume.DeviceModel}
    """
    def __init__(self, udi=None):
        self.udi = udi
        self.model = None

class NewUnknownDevice(Message):
    """
    Message sent when any device is plugged in. This allows the UI to
    react immediately when the user plugged in a new device and show some nice
    animation or something.

    @ivar udi: the unique id for that certain device
    @type udi: C{str}
    """
    def __init__(self, udi=None):
        self.udi = udi

class DeviceRemoved(Message):
    """
    When a Device is removed this message is sent over the
    L{elisa.core.bus.Bus}. The UI should update immediately.

    @ivar udi:      the unique id for that certain device
    @type udi:      C{str}
    """
    def __init__(self, udi=None):
        self.udi = udi
