#
# This script was written by Xue Yong Zhi<xueyong@udel.edu>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(11340);
 script_bugtraq_id(2222);
 script_version ("$Revision: 1.6 $");
 script_cve_id("CVE-2001-0259");
 
 name["english"] = "SSH Secure-RPC Weak Encrypted Authentication";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SSH server might allow a local user to recover a SUN-DES-1 
passphrase.

Description :

The remote host is running a version of SSH Communications Security SSH 
comprised between versions 1.2.27 and 1.2.30.
 
With Secure-RPC, this version can allow local attackers to recover a SUN-DES-1 
magic phrase generated by another user, which the attacker can use to decrypt 
that user's private key file.

Solution :

Download and install the newest version of this software.

Risk factor :

Low / CVSS Base Score : 3 
(AV:R/AC:H/Au:NR/C:P/A:N/I:N/B:C)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the remote SSH version";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2003 Xue Yong Zhi");
 family["english"] = "Gain a shell remotely";
 script_family(english:family["english"]);
 script_dependencie("ssh_detect.nasl");
 script_require_ports("Services/ssh", 22);
 exit(0);
}

#
# The script code starts here
#

include("backport.inc");
port = get_kb_item("Services/ssh");
if(!port)port = 22;

banner = get_kb_item("SSH/banner/" + port );
if ( ! banner ) exit(0);

banner = get_backport_banner(banner:banner);

#Looking for SSH product version number  < 1.2.30
if(ereg(string:banner, pattern:"SSH-.*-1\.2\.([1-2][0-9]|30)[^0-9]*$", icase:TRUE))security_note(port);

