# -*- mode: python; coding: utf-8 -*-
#
# Pigment Python tools
#
# Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

"""
Pigment utility module
"""

import math

PI, PI2 = math.pi, math.pi/2.0


def clamp(x, low, high):
    """Clamp a value in the range [low, high].
    """
    return max(low, min(high, x))


def lerp(a, b, factor):
    """Linear interpolation applied on a number.
    """
    return clamp(factor, 0.0, 1.0) * (b - a) + a

def serp(a, b, factor):
    """Sinusoidal interpolation applied on a number
    """
    return math.sin(clamp(factor, 0.0, 1.0)*PI2) * (b - a) + a

def lerp_seq(a, b, factor):
    """Linear interpolation applied on sequence like list or tuple.
    """
    diff = map(lambda x,y: x-y,  b, a)
    mult = map(lambda x: clamp(factor, 0.0, 1.0)*x, diff)
    return tuple (map(lambda x,y: x+y, mult, a))
