# -*- encoding: utf-8 -*-

Gem::Specification.new do |s|
  s.name = %q{icalendar}
  s.version = "1.1.0"

  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.authors = ["Sean Dague"]
  s.autorequire = %q{icalendar}
  s.date = %q{2009-01-28}
  s.description = %q{Implements the iCalendar specification (RFC-2445) in Ruby.  This allows for the generation and parsing of .ics files, which are used by a variety of calendaring applications.}
  s.email = %q{sean@dague.net}
  s.extra_rdoc_files = ["README", "COPYING", "GPL"]
  s.files = ["test/calendar_test.rb", "test/parameter_test.rb", "test/interactive.rb", "test/conversions_test.rb", "test/component_test.rb", "test/parser_test.rb", "test/read_write.rb", "test/fixtures", "test/fixtures/single_event.ics", "test/fixtures/folding.ics", "test/fixtures/simplecal.ics", "test/fixtures/life.ics", "test/component", "test/component/timezone_test.rb", "test/component/todo_test.rb", "test/component/event_test.rb", "test/coverage", "test/coverage/STUB", "lib/icalendar", "lib/icalendar/parameter.rb", "lib/icalendar/component.rb", "lib/icalendar/base.rb", "lib/icalendar/parser.rb", "lib/icalendar/tzinfo.rb", "lib/icalendar/calendar.rb", "lib/icalendar/component", "lib/icalendar/component/alarm.rb", "lib/icalendar/component/todo.rb", "lib/icalendar/component/event.rb", "lib/icalendar/component/journal.rb", "lib/icalendar/component/timezone.rb", "lib/icalendar/component/freebusy.rb", "lib/icalendar/conversions.rb", "lib/icalendar/helpers.rb", "lib/meta.rb", "lib/icalendar.rb", "lib/hash_attrs.rb", "docs/rfcs", "docs/rfcs/rfc2446.pdf", "docs/rfcs/rfc2426.pdf", "docs/rfcs/itip_notes.txt", "docs/rfcs/rfc2447.pdf", "docs/rfcs/rfc2425.pdf", "docs/rfcs/rfc2445.pdf", "docs/rfcs/rfc3283.txt", "docs/api", "docs/api/STUB", "examples/single_event.ics", "examples/parse_cal.rb", "examples/create_cal.rb", "Rakefile", "README", "COPYING", "GPL"]
  s.homepage = %q{http://icalendar.rubyforge.org/}
  s.rdoc_options = ["--main", "README"]
  s.require_paths = ["lib"]
  s.rubygems_version = %q{1.3.5}
  s.summary = %q{A ruby implementation of the iCalendar specification (RFC-2445).}

  if s.respond_to? :specification_version then
    current_version = Gem::Specification::CURRENT_SPECIFICATION_VERSION
    s.specification_version = 2

    if Gem::Version.new(Gem::RubyGemsVersion) >= Gem::Version.new('1.2.0') then
    else
    end
  else
  end
end
