/* -----------------------------------------------------------------------------
 * See the LICENSE file for information on copyright, usage and redistribution
 * of SWIG, and the README file for authors - http://www.swig.org/release.html.
 *
 * guilemain.i
 *
 * The main functions for a user augmented guile
 * version that can handle wrapped calls as generated by SWIG
 * ----------------------------------------------------------------------------- */

%{
#include <libguile.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Debugger interface (don't change the order of the following lines) */
#define GDB_TYPE SCM
#include <libguile/gdb_interface.h>
GDB_INTERFACE;

static void
inner_main(void *closure, int argc, char **argv)
{
#ifdef SWIGINIT
  SWIGINIT
#else
  SWIG_init();			/* SWIG init function */
#endif
  scm_shell(argc, argv);	/* scheme interpreter */
  /* never reached: scm_shell will perform an exit */
}

#ifdef __cplusplus
}
#endif

int
main(int argc, char **argv)
{
  /* put any default initialisation code here: e.g. exit handlers */
  scm_boot_guile(argc, argv, inner_main, 0); /* make a stack entry for the
						garbage collector */
  return 0; /* never reached, but avoids a warning */
}
%}
