#
# Program: tnumidx.pl
# For: Translate page Thai numbers in LaTeX's .idx format to Arabic 
#      and back from Arabic to Thai numbers
# Date: 2001-12-17 mo
# Use: 
#    mv thaitest.idx thaitest.id
#    perl tnumidx.pl -e < thaitest.id > thaitest.idx
#    makeindex thaitest
#    mv thaitest.ind thaitest.in
#    perl tnumidx.pl -d < thaitest.in > thaitest.ind
#

if ($ARGV[0] eq '-e') { # if progoptions

while (<STDIN>) { # while encode-file
  chomp $_;
  
  $_=~m/(^.+){([-]+)}$/;
  $firstpart=$1;
  $arabicnum=$2;
  $arabicnum=~tr/[-]/[0-9]/;
  
  print "$firstpart\{$arabicnum\}\n";
} # endwhile encode-file

} elsif ($ARGV[0] eq '-d') { # elsif progoptions

while (<STDIN>) { # while decode-file
  chomp $_;

  # searching for ", 22-29" or ", 30" patterns
  #  or ', ' at the end of line
  if ( "$_" =~ m/([^,]+)((, \d+(-\d+)?)+)/ || "$_" =~ m/, $/ ) {
    # Some entry contains multilines this form "23, 34, " and has a new line.
    # This is for rejoining them.
    $remain=$_;
    while (substr($remain, length($remain)-2) eq ", ") {
      $_=<STDIN>;
      chomp $_;
      s/^\s+//;
      $remain=$remain.$_;
    }
    $tail="";

    # Each page specified element do from end of line backward.
    # Making sure that it's not something like: LaTeX 3, 22, 23
    # The format may be 22, 23--25, 11 
    @words = split /, /, $remain;
    for ($i=$#words;$i>=1;$i--) {
      if ($words[$i] =~ m/^([0-9]+)(--([0-9]+))?$/) {
        $words[$i] =~ tr/[0-9]/[-]/;
      } 
    }

    $remain = join ', ', @words;

    print "$remain\n";
  } else {
    print "$_\n";
  }
} # endwhile decode-file

} # endif progoptions
