/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.paul;

import de.tu_darmstadt.sp.paul.PDFObject;
import de.tu_darmstadt.sp.paul.PDFParser;
import de.tu_darmstadt.sp.paul.PDFReference;
import de.tu_darmstadt.sp.paul.PDFReferenceContainer;
import de.tu_darmstadt.sp.paul.PDFWriter;
import de.tu_darmstadt.sp.paul.ParseException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class PDFArray
extends PDFReferenceContainer
implements Cloneable {
    List content;
    boolean resolved;

    public PDFArray() {
        this.content = new ArrayList(5);
        this.resolved = false;
    }

    public PDFArray(PDFArray other) {
        this.content = new ArrayList(other.content);
        this.resolved = other.resolved;
        this.direct = other.direct;
    }

    public void add(int index, PDFObject obj) {
        this.content.add(index, obj);
    }

    public void add(PDFObject obj) {
        this.content.add(obj);
    }

    protected Object clone() {
        return new PDFArray(this);
    }

    protected boolean deepEquiv(PDFReferenceContainer obj, Map compared) {
        ListIterator myIter = this.content.listIterator();
        ListIterator otherIter = ((PDFArray)obj).content.listIterator();
        while (myIter.hasNext() && otherIter.hasNext()) {
            PDFObject myNext = (PDFObject)myIter.next();
            PDFObject otherNext = (PDFObject)otherIter.next();
            if (!(myNext instanceof PDFReferenceContainer ? !((PDFReferenceContainer)myNext).dfsEquiv(otherNext, compared) : !myNext.equiv(otherNext))) continue;
            return false;
        }
        return (myIter.hasNext() || otherIter.hasNext()) ^ true;
    }

    public PDFObject get(int index) {
        return (PDFObject)this.content.get(index);
    }

    void getReferenced(PDFWriter writer) {
        ListIterator<PDFReference> iter = this.content.listIterator();
        writer.markVisited(this);
        while (iter.hasNext()) {
            PDFObject current = (PDFObject)iter.next();
            if (!current.isDirect()) {
                iter.set(writer.getPDFRefFor(current));
            }
            if (writer.isVisited(current)) continue;
            current.getReferenced(writer);
        }
    }

    public ListIterator listIterator() {
        return Collections.unmodifiableList(this.content).listIterator();
    }

    public PDFObject remove(int index) {
        return (PDFObject)this.content.remove(index);
    }

    void removeReferences(PDFWriter writer) {
        ListIterator<PDFObject> iter = this.content.listIterator();
        writer.markVisited(this);
        while (iter.hasNext()) {
            PDFObject current = (PDFObject)iter.next();
            if (current instanceof PDFReference) {
                current = ((PDFReference)current).getContent();
                iter.set(current);
            }
            if (writer.isVisited(current)) continue;
            current.removeReferences(writer);
        }
    }

    void resolveReferences(PDFParser parser) throws ParseException, IOException {
        if (this.resolved) {
            return;
        }
        this.resolved = true;
        int max = this.content.size();
        int i = 0;
        while (i < max) {
            if (this.content.get(i) instanceof PDFReference) {
                PDFObject obj = parser.getObj((PDFReference)this.content.get(i));
                this.content.set(i, obj);
            } else {
                parser.resolveObject((PDFObject)this.content.get(i));
            }
            ++i;
        }
    }

    public int size() {
        return this.content.size();
    }

    public String toString() {
        return "Array of " + Integer.toString(this.content.size()) + " elements\n";
    }

    public void write(Writer out) throws IOException {
        ListIterator iter = this.content.listIterator();
        out.write(91);
        out.write(32);
        while (iter.hasNext()) {
            PDFObject current = (PDFObject)iter.next();
            current.write(out);
            out.write(32);
        }
        out.write(93);
    }
}

