/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.paul;

import de.tu_darmstadt.sp.paul.PDFDictionary;
import de.tu_darmstadt.sp.paul.PDFParser;
import de.tu_darmstadt.sp.paul.PDFParserException;
import de.tu_darmstadt.sp.paul.PDFWriter;
import de.tu_darmstadt.sp.util.BufferedRandomFileInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StreamTokenizer;

public class PDFFile {
    private PDFDictionary trailer;
    private BufferedRandomFileInputStream inFile;

    public PDFFile() {
    }

    public PDFFile(PDFDictionary trailer) {
        this.trailer = trailer;
    }

    public PDFFile(File file) throws IOException {
        this.inFile = new BufferedRandomFileInputStream(file);
    }

    public PDFFile(String fileName) throws IOException {
        this.inFile = new BufferedRandomFileInputStream(fileName);
    }

    public void close() throws IOException {
        if (this.inFile != null) {
            this.inFile.close();
        }
    }

    public PDFDictionary getTrailer() {
        return this.trailer;
    }

    public void read() throws IOException {
        if (this.inFile == null) {
            throw new RuntimeException("No input file.");
        }
        StreamTokenizer st = new StreamTokenizer(new InputStreamReader(this.inFile));
        if (st.nextToken() != 37 || st.nextToken() != -3 || !st.sval.startsWith("PDF")) {
            throw new PDFParserException("%PDF missing");
        }
        this.inFile.seek(this.inFile.length() - 1L);
        while (this.inFile.read() != 115) {
            this.inFile.seek(this.inFile.getFilePointer() - 2L);
        }
        this.inFile.seek(this.inFile.getFilePointer() - 1L);
        st = new StreamTokenizer(new InputStreamReader(this.inFile));
        st.nextToken();
        st.sval.equals("startxref");
        st.nextToken();
        int startxref = (int)st.nval;
        if (st.nextToken() != 37 || st.nextToken() != 37 || st.nextToken() != -3 || !st.sval.equals("EOF")) {
            throw new PDFParserException("%%EOF missing, found: " + st.sval);
        }
        PDFParser parser = new PDFParser(this.inFile, startxref);
        this.trailer = parser.getTrailer();
    }

    public void write(File file) throws IOException {
        this.write(new BufferedOutputStream(new FileOutputStream(file)));
    }

    public void write(OutputStream out) throws IOException {
        PDFWriter w = new PDFWriter(out, this.trailer);
        w.doWrite();
    }

    public void write(String fileName) throws IOException {
        this.write(new File(fileName));
    }
}

