<?php // -*- coding:utf-8 -*-
// Parameters:

// lang=xx    : only translates language 'xx',
//              if not given all languages are translated

// comments   : generate all comments (equal to close&module)

// close      : look for similar strings that are already translated and
//              generate a comment if a 'match' is made

// module     : generate comments that describe in which .php and/or .tpl
//              module(s) a certain string was found (useful for checking
//              translations in context)

// patch      : looks for the file 'language.patch' in the same directory
//              as the corresponding language.php and overrides any strings
//              in language.php - good if a user does not agree with
//              some translations or if only changes are sent to the maintainer

// spelling   : generates a file 'spellcheck_me.txt' that contains the
//              words used in the translation. It is then easy to check this
//              file for spelling errors (corrections must be done in
//              'language.php, however)

// groupwrite : Sets the generated files permissions to allow the generated
//              language.php also be group writable. This is good for
//              translators if they do not have root access to tiki but
//              are in the same group as the webserver. Please remember
//              to have write access removed when translation is finished
//              for security reasons. (Run script again without this
//              parameter)

// Examples:
// http://www.neonchart.com/get_strings.php?lang=sv
// Will translate language 'sv' and (almost) avoiding comment generation

// http://www.neonchart.com/get_strings.php?lang=sv&comments
// Will translate language 'sv' and generate all possible comments.
// This is the most usefull mode when working on a translation.

// http://www.neonchart.com/get_strings.php?lang=sv&nohelp&nosections
// These options will only provide the minimal amout of comments.
// Usefull mode when preparing a translation for distribution.

// http://www.neonchart.com/get_strings.php?nohelp&nosections
// Prepare all languages for release


// ### Note for translators about translation of text ending with punctuation
// ###
// ### The current list of concerned punctuation can be found in 'lib/init/tra.php'
// ### On 2009-03-02, it is: (':', '!', ';', '.', ',', '?')
// ### For clarity, we explain here only for colons: ':' but it is the same for the rest
// ###
// ### Short version: it is not a problem that string "Login:" has no translation. Only "Login" needs to be translated.
// ###
// ### Technical justification:
// ### If a string ending with colon needs translating (like "{tr}Login:{/tr}")
// ### then TikiWiki tries to translate 'Login' and ':' separately.
// ### This allows to have only one translation for "{tr}Login{/tr}" and "{tr}Login:{/tr}"
// ### and it still allows to translate ":" as "&nbsp;:" for languages that
// ### need it (like french)

$lang=Array(
// ### Start of unused words
// ### Please remove manually!
// ### N.B. Legitimate strings may be marked// ### as unused!
// ### Please see http://tikiwiki.org/tiki-index.php?page=UnusedWords for further info
"save_to" => "shrani_v",
"DATE-of" => "Date-of",
"Jan" => "Jan",
"Feb" => "Feb",
"Mar" => "Mar",
"Apr" => "Apr",
"Jun" => "Jun",
"Jul" => "Jul",
"Aug" => "Aug",
"Sep" => "Sep",
"Oct" => "Okt",
"Nov" => "Nov",
"Dec" => "Dec",
"Your post has not been posted" => "Prispevek ni bil poslan",
"Missing title or body when trying to post a comment" => "MManjka naslov in telo besedila ko si poskusil poslati komentar",
"The text in RED is" => "Besedilo v RED je",
"Role" => "Vloga",
"Process %d has been activated" => "Proces %s je bil aktiviran",
"Process %d has been deactivated" => "Proces %s je bil deaktiviran",
"Process %s %s imported" => "Proces %s je bil uvožen",
"Process %s removed" => "Proces %s je bil odstranjen",
"Process %s has been updated" => "Proces %s je bil osvežen",
"Process %s has been created" => "Proces %s je bil ustvarjen",
"Charts" => "Grafikoni",
"Cannot write to this file: " => "Ne morem zapisati v to datoteko: ",
"Newsletter subscription information at " => "Informacije za naročilo biltena pri ",
"Forums last topics" => "Zadnji prispevki na forumu",
"Last seen on " => "Zadnjič videno na ",
"cannot be found" => "ne najdem",
"An error occured in a database query!" => "Napaka se je pojavila pri poizvedbi podatkovne baze!",
"games" => "igre",
"drawing not found" => "nisem našel risbe",
"You are not allowed to upload this type of file." => "Nimate dovoljenja naložiti ta tip datoteke.",
"You must select a file." => "Izbrati moraš datoteko.",
"Altering database table failed" => "Spreminjanje datoteke ni uspelo",
"__WARNING__: No such module \$plugin! " => "__OPOZORILO__: Ni takega modula \$plugin! ",
"(unchanged)" => "(nespremenjeno)",
"Use Google Maps." => "Uporabi Google Maps.",
"Remaining:" => "Ostane:",
"Old:" => "Star",
"New:" => "Nov:",
"Changes" => "Spremembe",
"since" => "od",
"new submissions" => "Nove uklonitve",
"new sites" => "Nove strani",
"new calendar events" => "Novi dogodki v koledarju",
" on " => " na ",
"Show Categories" => "Pokaži kategorije",
"Hide Categories" => "Skrij kategorije",
"Hold down CTRL to select multiple categories" => "Za izbiro več kategorij pritisni in drži Ctrl.",
"categorize this object" => "Kategoriziraj ta objekt",
"Uncheck the above checkbox to uncategorize this page/object" => "Odstrani kljukico v zgornjem kvadratku za nekategorizacijo te strani/objekta",
"Quicktags" => "Hitre značke",
"any file" => "katerakoli datoteka",
"podcast (audio)" => "podcast (audio)",
"podcast (video)" => "podcast (video)",
"This Gallery is Public" => "Ta galerija je javna",
"The files can be locked at download:" => "Datoteke lahko zaklenemo pri nalaganju:",
"Perhaps you were looking for:" => "Verjetno iščete:",
"Put tags separated by spaces. For tags with more than one word, use no spaces and put words together." => "Dodaj značke ločene s presledki. Za značke z več kot eno besedo, ne uporabi presledkov, pač pa besede združi kako drugače (npr: ključna_beseda).",
"Loading" => "nalaganje",
"Tiki User Account Activated" => "Uporabniški račun je aktiviran.",
"best regards" => "pozdravi",
"your Tikiwiki" => "tvoj Tikiwiki",
"Tiki User Registration Request" => "Zahteva Tiki uporabnika za registracijo",
"Tiki email notification" => "Tiki e-poštno obvestilo",
"you or someone registered this email address at" => "registrirali ste se (ali pa kdo drug v vašem imenu) s tem e-naslovom na",
"Your Tiki information registration" => "Vaša Tiki registracijska informacija",
"Your registration" => "Vaša Tiki registracijska informacija",
"Wiki page %s changed" => "Wiki stran %s se je spremenila",
"RSS modules" => "RSS moduli",
"QuickTags" => "Hitre značke",
"External wikis" => "Zunanji wikiji",
"Menu" => "Meni",
"Games" => "Igre",
"MyMenu" => "Moj meni",
"MyTiki home" => "Moj Tiki dom",
"Newsreader" => "Bralnik novic",
"My files" => "Moje datoteke",
"User menu" => "Uporabniški meni",
"Mini calendar" => "Mini koledar",
"My watches" => "Moje opazovane strani",
"WfMenu" => "WfMenu",
"Workflow" => "Delovni tok",
"Admin processes" => "Proces administriranja",
"Monitor processes" => "Opazuj procese",
"Monitor activities" => "Opazuj aktivnosti",
"Monitor instances" => "Opazuj primere (instances)",
"User processes" => "User processes",
"User activities" => "Aktivnosti uporabnika",
"User instances" => "Uporabnikovi primeri (instances)",
"FriendsMenu" => "Meni prijateljev",
"User list" => "Seznam uporabnikov",
"WikiMenu" => "Wiki meni",
"Dump" => "Odlagališče",
"Send pages" => "Pošlji strani",
"Received pages" => "Prejete strani",
"GalMenu" => "GalMeni",
"System gallery" => "Sistem galerij",
"View submissions" => "Poglej predložene članke",
"New article" => "Nov članek",
"Send articles" => "Pošlji članke",
"List blogs" => "Seznam blogov",
"Create/Edit blog" => "Ustvari/Uredi blog",
"Admin posts" => "Administriraj prispevke",
"ForMenu" => "ForMenu",
"DirMenu" => "DirMenu",
"Submit a new link" => "Predloži novo povezavo",
"Browse directory" => "Prebrskaj direktorij",
"Admin directory" => "Administriraj direktorij",
"FileGalMenu" => "FileGalMenu",
"Admin FAQs" => "Administriraj vprašanja in odgovore (FAQs)",
"Layer management" => "Upravljanje ravni (Layer management)",
"QuizMenu" => "Kviz meni",
"List quizzes" => "Seznam kvizov",
"Admin quiz" => "Administriraj kvize",
"ShtMenu" => "ShtMenu",
"TrkMenu" => "TrkMenu",
"List trackers" => "Seznam sledilnikov",
"Admin trackers" => "Administriraj sledilnike",
"SrvMenu" => "SrvMenu",
"Send newsletters" => "Pošlji biltene",
"Send events" => "Pošlji dogodke",
"Admin events" => "Administriraj dogodke",
"EphMenu" => "EphMeni",
"Ephemerides" => "Preglednice(Ephemerides)",
"Ephemerides Admin" => "Preglednice (Ephemerides) Admin",
"ChartMenu" => "Meni grafikona",
"Charts Admin" => "Grafikoni Admin",
"AdmMenu" => "AdmMeni",
"Admin home" => "Admin domov",
"Drawings" => "Risbe",
"Edit languages" => "Uredite jezike",
"Mods Admin" => "Mods Admin",
"UsrMenu" => "UsrMenu",
"Click here to manage your personal menu" => "Klikni tu za upravljanje osebnega menija",
"\$module_title" => "\$module_title",
"TikiWiki Assistant" => "Tikiwiki pomočnik",
" on blogpost " => " na blogih ",
"Recently visited pages" => "Recently visited pages",
"\$modcattitle" => "\$modcattitle",
"Last `\$module_rows` Sites" => "Zadnji `\$module_rows` strani",
"Last Sites" => "Zadnje strani",
"Directory Stats" => "Statistika direktorija",
"Sites to validate" => "Strani za preverjanje veljavnosti",
"Visited links" => "Obiskane povezave",
"Top \$module_rows Sites" => "Najboljše \$module_rows strani",
"Top Sites" => "Najboljše strani",
"Top `\$module_rows` topics" => "Top `\$module_rows` topics",
"Last `\$module_rows` forum posts" => "Zadnji `\$module_rows` prispevki v forumu",
"Last `\$module_rows` forum topics" => "Zadnje `\$module_rows` teme v forumu",
"Folksonomy" => "Folksonomija",
"More Like This" => "Več takih",
"Last `\$module_rows` actions" => "Zadnji `\$module_rows` akcije",
"Last `\$module_rows` articles" => "Zadnji `\$module_rows` članki",
"Last articles" => "Zadnji članki",
"Last `\$module_rows` blog posts" => "Zadnji `\$module_rows` blogovski prispevki",
"\$type" => "\$tip",
"Last `\$module_rows` Created blogs" => "Zadnji `\$module_rows` ustvarjeni blogi",
"Last `\$module_rows` Created FAQs" => "Zadnja `\$module_rows` ustvarjena vprašanja in odgovori (FAQs)",
"Last galleries" => "Zadnje galerije",
"Paramaters" => "Parametri",
"applicable for this item" => "ki se nanašajo na to postavko",
"I forgot my pass" => "Pozabil sem geslo",
"New Messages" => "Nova sporočila",
"New Message" => "Novo sporočilo",
"click to show/hide" => "Klikni za: prikaz/skrivanje",
"The Next Event" => "Naslednji dogodek",
"No Upcoming Events" => "Ni prihajajočih dogodkov",
"Whats related" => "Kaj se nanaša",
"Last `\$module_rows` wiki comments" => "Zadnji `\$module_rows` wiki komentarji",
" on page " => " na strani ",
"show structures" => "prikaži strukture",
"hide structures" => "skrij strukture",
"Are you sure you want to remove this module?" => "Ste prepričani, da želite odstraniti ta modul?",
"Last Modification:" => "Zadnja sprememba:",
"For" => "Za",
"Location: " => "Lokacija: ",
"{\$atts_cnt} files attached" => "{\$atts_cnt} pripetih datotek",
"pass" => "geslo",
"Page generated in" => "Stran vzpostavljena v",
"sent" => "pošlji",
"Homework" => "Domača naloga",
"Assignments" => "Dodelitve (Assignments)",
"Backups" => "Varnostne kopije",
"{|} Files Attached" => "{|} pripete datoteke",
"Favorites" => "Priljubljene",
"home" => "Domov",
"chat" => "Klepet",
"contact us" => "Pokliči nas",
"Member list" => "Seznam članov",
"dump" => "Odpad",
"rankings" => "Najboljši",
"orphan pages" => "Osirotele strani",
"sandbox" => "Peskovnik",
"received pages" => "Prejete strani",
"structures" => "Strukture",
"Articles Home" => "Članki domov",
"Create/Edit Blog" => "Ustvari/uredi blog",
"Browse Directory" => "Prebrskaj direktorij",
"Back to Homepage" => "Nazaj na domačo stran",
"Edit Summary" => "Uredi povzetek",
"Minor" => "Manjše",
"RSS Trackers" => "RSS sledilniki",
"left/right" => "levo/desno",
"Quick edit a Wiki page" => "Hitro urejanje wiki strani",
"Language: " => "Jezik: ",
"This is" => "To je",
"Tiki community" => "Tiki skupnost",
"Sort posts by:" => "Sortiraj prispevke po:",
"read more" => "preberi več",
"Show/Hide Left Modules" => "Pokaži/Skrij leve module",
"Show/Hide Right Modules" => "Pokaži/Skrij desne module",
"Last update from CVS" => "Zadnja posodobitev iz CVS",
"Translate in" => "Prevedi v",
"babelfish it" => "babelfish it",
"Welcome to" => "Dobrodošli v",
"Design by" => "Dizajniral",
"Creation date" => "Datum ustvarjanja",
"Last modification time" => "Čas zadnje spremembe",
"Calendar manual selection of time/date" => "Ročna izbira časa/datuma v koledarju",
"JsCalendar" => "JsCalendar",
"if no jscalendar" => "če ni jscalendar",
"Article comments settings" => "Nastavitve komentiranja člankov",
"Fields to display on page" => "Polja prikazana na strani",
"Expire Date" => "Končni datum",
"Minimum username length" => "Minimalna dolžina uporabniškega imena",
"Maximum username length" => "Maksimalna dolžina uporabniškega imena",
"Force lowercase username" => "Forsiraj malo pisavo za uporabniško ime",
"Minimum password length" => "Minimalna dolžina gesla",
"Password invalid after days" => "Geslo bo neveljavno po (dneh)",
"-1 for never" => "-1 za nikoli",
"Remember me feature" => "Zapomni se me značilnost",
"Remember me name" => "Zapomni si moje ime",
"Default group: " => "Default group: ",
"Template Viewing" => "Pregled tem",
"Site Logo" => "Logo strani",
"Allow Smileys" => "Dovoli smejkote",
"Show quicktags over textareas (instead on left side)" => "Pokaži hitre značke (quicktags) preko tekstovnega področja (namesto na levi strani)",
"Default number of rows (wiki)" => "Privzeto število vrstic (wiki)",
"Default number of rows (comments)" => "Privzeto število vrstic (komentarji)",
"Default number of rows (forum)" => "Privzeto število vrstic (forum)",
"Default number of rows (forum replies)" => "Privzeto število vrstic (odgovori v forumu)",
"Create a Tag for the Current Wiki" => "Ustvari značko za ta wiki",
"Tag name:" => "Ime značke:",
"Restore the Wiki" => "Obnovi wiki",
"restore" => "obnovi",
"Remove a Tag" => "Odstranite značko",
"Wiki Comments Settings" => "Nastavitve wiki komentarjev",
"List displayed by default" => "Privzeto prikazan seznam",
"Wiki attachments:" => "Wiki priponke:",
"Use database to store files:" => "Uporabi podatkovno bazo za shranjevanje datotek:",
"Use a directory to store files:" => "Uporabi direktorij za shranjevanje datotek:",
"Wiki Administration" => "Wiki Administration",
"Wiki Home Page" => "Wiki domača stran",
"Wiki Discussion" => "Wiki razprava",
"No forums" => "Ni forumov",
"Wiki Link Format" => "Format wiki povezave",
"latin" => "latinsko",
"english" => "angleško",
"Comment length:" => "Dolžina komentarja:",
"Text size:" => "Velikost besedila:",
"Wiki Features" => "Wiki funkcije",
"Sandbox:" => "Peskovnik:",
"View source:" => "Poglej vir:",
"List pages:" => "Seznam strani:",
"Backlinks:" => "Backlinks:",
"Similar:" => "Podobno:",
"Rankings:" => "Najboljši:",
"Undo:" => "Razveljavi:",
"Save Draft:" => "Shrani osnutek:",
"Use templates:" => "Uporabi predloge:",
"Footnotes:" => "Opombe v nogi:",
"Use WikiWords:" => "Uporabi wiki besede:",
"Open page as structure:" => "Odpri stran kot strukturo:",
"Make structure from page:" => "Naredi strukturo iz strani:",
"Categorize structure pages together:" => "Kategoriziraj strukturne strani skupaj:",
"User's Page:" => "Uporabnikova stran:",
"Edit section:" => "Uredite sekcijo:",
"Wiki History" => "Wiki zgodovina",
"Maximum number of versions for history:" => "Maksimalno število verzij za zgodovino:",
"Wiki Watch" => "Wiki opazovanje",
"More Links" => "Več povezav",
"Create/edit Calendars" => "Ustvari/uredi koledarje",
"Admin Categories tpl" => "Adminstriraj predloge kategorij",
"browse the category system" => "prebrskaj sistem kategorij",
"Assign permissions automatically" => "Določi dovoljenja avtomatično",
"recommended for best performance" => "priporočeno za najboljšo učinkovitost",
"image gal" => "image gal",
"file gal" => "file gal",
"Admin chart items" => "Administriraj diagram postavke",
"charts" => "diagrami",
"Edit Chart" => "Uredi diagram (chart)",
"Chart items" => "Predmeti diagrama",
"No items defined yet" => "Še ni definiranih predmetov",
"Admin charts" => "Administriraj diagrame charts",
"Admin Charts Template" => "Administriraj predloge diagramov",
"Add or edit a chart" => "Dodaj ali uredi diagram",
"All items" => "Vse postavke (items)",
"Top 10 items" => "Najboljših 10 predmetov",
"Top 20 items" => "Najboljših 20 predmetov",
"Top 40 items" => "Najboljših 40 predmetov",
"Top 50 items" => "Najboljših 50 predmetov",
"Top 100 items" => "Najboljših 100 predmetov",
"Top 250 items" => "Najboljših 250 predmetov",
"Voting system" => "Volilni sistem",
"Admin Forums Template" => "Administriraj predloge forumov",
"no display" => "brez prikaza",
"Add new rule" => "Dodaj novo pravilo",
"Admin Modules Template" => "Administriraj predloge modulov",
"Assign Module" => "Določi modul",
"Admin Quicktags" => "Administracija hitrih značk (Quicktags)",
"Create/Edit QuickTags" => "Ustvari/Uredi hitre značke (QuickTags)",
"Quicktags category filter" => "Filter kategorij hitrih značk (QuickTags)",
"Path to the tag icon" => "Pot do ikone za značko",
"Admin structures template" => "Administratorjevi strukturne predloge",
"Edit survey questions" => "Uredite anketna vprašanja",
"this survey stats" => "statistika te ankete",
"Create/edit questions for survey" => "Ustvari/uredi vprašanja za anketo",
"Admin Topics Template" => "Administriraj predloge tem",
"Active?" => "Aktivne?",
"Create item" => "Ustvari postavko",
"Members List" => "Seznam članov",
"User must already exist." => "Uporabnik mora že obstajati.",
"Admin Users Template" => "Adminisrtriraj uporabnikove predloge",
"Updated users" => "Posodobljeni uporabniki",
"Rejected users" => "Zavrnjeni uporabniki",
"Edit Account Settings" => "Uredite nastavitve računa",
"Assign to Groups" => "Določi v skupine",
"Again" => "Ponovno",
"User must change his password at first login" => "Uporabnik mora spremeniti geslo pri prvi prijavi",
"Approve page changes in staging" => "Odobri nove strani v postavitvi",
"Assign permissions to group" => "Določi dovoljenja skupini",
"Help for Assigning Permissions" => "Pomoč za pripisovanje dovoljenj",
"Assign User {\$assign_user} to Groups" => "Določi uporabnika {\$assign_user} v skupine",
"Default Group" => "Privzeta skupina",
"Browse gallery" => "Prebrskaj galerijo",
"Upload from disk" => "Naloži z diska",
"Browse file gallery" => "Prebrskaj galerijo datotek",
"The TikiWiki community" => "Skupnost TikiWiki",
"Browsing Gallery" => "Brskanje po galeriji",
"Browsing Image" => "Brskaj po slikah",
"Zoom" => "Povečaj",
"Config Calendars" => "Konfigurirajte koledarje",
"Focus:" => "Fokus:",
"Edit Article" => "Uredi članek",
"creates a title bar" => "ustvari naslovno vrstico",
"Wiki File Attachments" => "Wiki priponke datotek",
"bold" => "bold",
"wiki link'" => "wiki povezava'",
"Your edit session will expire in 1 minute. You must PREVIEW or SAVE your work now, to avoid losing your edits." => "Urejanje bo poteklo v 1 minuti. Klikni <strong>Predogled</strong> ali <strong>Shrani</strong>, da bi spet pognal uro od začetka.",
"This edit session will expire in {\$edittimeout} minutes" => "Urejanje bo poteklo v {\$edittimeout} minutah",
"back to forum" => "nazaj na forum",
"galleries tpl" => "galerijski tpl",
"Tiki cannot find a database connection" => "Tiki ne more najti povezave do podatkovne baze",
"Database type" => "Tip podatkovne baze",
"Database name" => "Ime podatkovne baze",
"Create a file gallery" => "Ustvari podatkovno galerijo",
"/" => "/",
"Upload a game" => "Naloži igro",
"Upload a new game" => "Naloži novo igro",
"Edit game" => "Uredi igro",
"User Calendar Doc" => "Uporabniški Calendar Doc",
"User Calendar Preferences Doc tpl" => "Uporabnikove koledarske izb. nastavitve Doc tpl",
"My Contacts" => "Moji stiki",
"My Wiki Pages" => "Moje wiki strani",
"My Galleries" => "Moje galerije",
"My Tracker Items" => "Moj postavke sledilnikov",
"My Messages" => "Moja sporočila",
"My Tasks" => "Mojzadolžitve",
"View Permissions" => "Poglej dovoljenja",
"Perms Help" => "Pomoč za dovoljenja",
"Preview of version" => "Predogled verzije",
"Source of version" => "Vir verzije",
"Updated from" => "Posodobljena iz",
"Used to update" => "Uporabljena za posodobitev",
"Received Articles" => "Prejeti članki",
"received articles tpl" => "prejeti članki tpl",
"Help on Communication Center" => "Pomoč o komunikacijskem centru",
"received pages tpl" => "prejete strani tpl",
"NOTE: Make sure to whitelist this domain to prevent registration emails being canned by your spam filter!" => "Vstavi svoj aktivni e-naslov.",
"Return to HomePage" => "Nazaj na domačo stran",
"return to wikipage" => "Nazaj na wiki stran",
"Rename page" => "Preimenuj stran",
"to_version" => "na verzijo",
"Upload big files (e.g. PodCast files) here:" => "Naloži velike datoteke (npr. PodCast datoteke) tukaj:",
"File Title" => "Naslov datoteke",
"Batch upload" => "Paketno nalaganje",
"Unzip all zip files" => "Razširi (unzip) stisnjene datoteke",
"Maximum amount of downloads" => "Maksimalna količina naloženega",
"Author if not the file creator" => "Avtor, če ni ustvarjalec datoteke",
"Image Gallery tpl" => "Galerija slik tpl",
" or upload a local image from your disk" => " ali naloži lokalno sliko s tvojega diska",
"Note: Maximum image size is limited to" => "Opomba: Maksimalna velikost slike je omejena na",
"User Assigned Modules" => "Moduli, ki jih je določil uporabnik",
"User Assigned Modules tpl" => "Predloge, ki jih je določil uporabnik",
"Current folder" => "Trenutna mapa",
"a URL" => "URL",
"Edit User Contacts Preferences" => "Uredi uporabnikove izbire za kontakte",
"This user is your friend" => "Ta uporabnik je prijatelj",
"Your personal Wiki Page" => "Tvoja osebna wiki stran",
"Current password (required)" => "Trenutno geslo (zahtevano)",
"watched events" => "opazovani dogodki",
"Watch language wiki page creations" => "Opazuj ustvarjanje jezikovnih wiki strani",
"Add watch" => "Dodaj opazovanje",
"No articles." => "Ni člankov.",
"View All" => "Poglej vse",
"Minor Edit" => "Manjše urejanje",
"RSS settings" => "RSS nastavitve",
"You have mistyped the anti-bot verification code; please try again. " => "Narobe si vtipkal anti-bot verifikacijsko kodo. Prosim, poskusi še enkrat.",
"%s - Version %d of this page has been saved by %s." => "%s - Verzijo %d te strani je shranil %s.",
"Delete those pages:" => "Odstrani te strani:",
"mail adress" => "e-naslov",
"A password and your IP address reminder email has been sent " => "E-pošta z geslom in namig za IP naslov sta bila poslana ",
"to the email " => "na e-naslov ",
" successfully sent" => " uspešno poslano",
" not sent" => " ni poslano",
"Invalid password.  Your current password is required to change administrative information" => "Neveljavno geslo. V vašem trenutnem geslu je treba zamenjati administrativne informacije",
"Your account request have been stored and will be activated by the admin as soon as possible." => "Your account request has been stored and will be activated by the admin as soon as possible.",
"Tiki Logo" => "Tiki Logo",
"Admin Menu" => "Administratorski meni",
"Chat" => "Klepet",
"Current events" => "Trenutni dogodki",
"No avatar." => "Brez avatarja.",
"RSS Feeds" => "RSS viri",
"User informations" => "Informacije uporabnika",
"Group informations" => "Intormacije skupine",
"You need to activate user and/or group trackers" => "Aktivirati morate uporabnikove in/ali skupinske sledilnike",
"Email This Post" => "Pošlji e-pošto tega zapisa",
"Send blog post" => "Pošlji blogovske prispevke",
"A link to this post was sent to the following addresses:" => "Povezava na prispevek je bila poslana na ta naslov:",
"Send post to this addresses" => "Pošlji prispevek na ta naslov",
"List of email addresses separated by commas" => "Seznam e-naslovov ločen z vejicami",
"Compose Message" => "Sestavi sporočilo",
"Separate multiple usernames with a comma (&nbsp;,&nbsp;)." => "Loči uporabniška imena z vejicami (&nbsp;,&nbsp;).",
"Prevent flooding" => "Prepreči poplavo",
"Minimum time between posts" => "Minimalni čas med prispevki",
"Moderator user" => "Moderator uporabnik",
"Moderator group" => "Moderator skupina",
"Only allow replies to the first message (flat forum)" => "Dovoli samo odgovore na prvo sporočilo (plosek forum)",
"Send this forums posts to this email" => "Pošlji prispevke s tega foruma na ta e-naslov",
"Prune unreplied messages after" => "Oklesti neodgovorjena sporočila po",
"Prune old messages after" => "Oklesti stara sporočila po",
"POP3 server" => "POP3 strežnik",
"Max attachment size (bytes)" => "maksimalna velikost priponk(bajti)",
"Default ordering for topics" => "Privzeta ureditev tem",
"Topics per page" => "Teme na stran",
"Assign Perms to this Group" => "Določi dovoljenja za to skupino",
"Assign permissions to category" => "Določi dovoljenja kategoriji",
"Remove from this Category Only" => "Odstrani samo iz te kategorije",
"Remove from this Category &amp; all its Children" => "Odstrani samo iz te kategorije &amp; in njenih otrok",
"Assign permissions" => "Določi dovoljenja",
"to group" => "skupini",
"Your registration code:" => "Vaša registracijska koda:",
"Registration code" => "Registracijska koda",
// ### end of unused words

// ### start of untranslated words
// ### uncomment value pairs as you translate
// "This script cannot be called directly" => "This script cannot be called directly",
// "The copyright management feature is not enabled" => "The copyright management feature is not enabled",
// "Copyright management" => "Copyright management",
// "No page indicated" => "No page indicated",
// "You must supply all the information, including title and year" => "You must supply all the information, including title and year",
// "Tiki was unable to retrieve login data from the database " => "Tiki was unable to retrieve login data from the database ",
// "The following error message was returned" => "The following error message was returned",
// "Things to check" => "Things to check",
// "Are your database login credentials correct" => "Are your database login credentials correct",
// "Did you complete the <a href='tiki-install.php' >Tiki Installer" => "Did you complete the <a href='tiki-install.php' >Tiki Installer",
// "Please see <a href=\"http://doc.tikiwiki.org/\">the documentation</a> for more information" => "Please see <a href=\"http://doc.tikiwiki.org/\">the documentation</a> for more information",
// "This feature is for admins only" => "This feature is for admins only",
// "Slideshow" => "Slideshow",
// "Default View" => "Default View",
// "Afghanistan" => "Afghanistan",
// "Aland Islands" => "Aland Islands",
// "Albania" => "Albania",
// "Algeria" => "Algeria",
// "American Samoa" => "American Samoa",
// "Andorra" => "Andorra",
// "Angola" => "Angola",
// "Anguilla" => "Anguilla",
// "Antigua" => "Antigua",
// "Argentina" => "Argentina",
// "Armenia" => "Armenia",
// "Aruba" => "Aruba",
// "Australia" => "Australia",
// "Austria" => "Austria",
// "Azerbaijan" => "Azerbaijan",
// "Bahamas" => "Bahamas",
// "Bahrain" => "Bahrain",
// "Bangladesh" => "Bangladesh",
// "Barbados" => "Barbados",
// "Belarus" => "Belarus",
// "Belgium" => "Belgium",
// "Belize" => "Belize",
// "Benin" => "Benin",
// "Bermuda" => "Bermuda",
// "Bhutan" => "Bhutan",
// "Bolivia" => "Bolivia",
// "Bosnia and Herzegovina" => "Bosnia and Herzegovina",
// "Botswana" => "Botswana",
// "Bouvet Island" => "Bouvet Island",
// "Brazil" => "Brazil",
// "British Indian Ocean Territory" => "British Indian Ocean Territory",
// "British Virgin Islands" => "British Virgin Islands",
// "Brunei" => "Brunei",
// "Bulgaria" => "Bulgaria",
// "Burkina Faso" => "Burkina Faso",
// "Burundi" => "Burundi",
// "Cambodia" => "Cambodia",
// "Cameroon" => "Cameroon",
// "Canada" => "Canada",
// "Cape Verde" => "Cape Verde",
// "Catalan Countries" => "Catalan Countries",
// "Cayman Islands" => "Cayman Islands",
// "Central African Republic" => "Central African Republic",
// "Chad" => "Chad",
// "Chile" => "Chile",
// "China" => "China",
// "Christmas Island" => "Christmas Island",
// "Cocos Islands" => "Cocos Islands",
// "Colombia" => "Colombia",
// "Comoros" => "Comoros",
// "Congo" => "Congo",
// "Congo Democratic" => "Congo Democratic",
// "Cook Islands" => "Cook Islands",
// "Costa Rica" => "Costa Rica",
// "Croatia" => "Croatia",
// "Cuba" => "Cuba",
// "Cyprus" => "Cyprus",
// "Czech Republic" => "Czech Republic",
// "Denmark" => "Denmark",
// "Djibouti" => "Djibouti",
// "Dominica" => "Dominica",
// "Dominican Republic" => "Dominican Republic",
// "Ecuador" => "Ecuador",
// "Egypt" => "Egypt",
// "El Salvador" => "El Salvador",
// "Equatorial Guinea" => "Equatorial Guinea",
// "Eritrea" => "Eritrea",
// "Estonia" => "Estonia",
// "Ethiopia" => "Ethiopia",
// "Europe" => "Europe",
// "Falkland Islands" => "Falkland Islands",
// "Faroe Islands" => "Faroe Islands",
// "Federated States of Micronesia" => "Federated States of Micronesia",
// "Fiji" => "Fiji",
// "Finland" => "Finland",
// "France" => "France",
// "French Guiana" => "French Guiana",
// "French Polynesia" => "French Polynesia",
// "French Southern Territories" => "French Southern Territories",
// "Gabon" => "Gabon",
// "Gambia" => "Gambia",
// "Georgia" => "Georgia",
// "Germany" => "Germany",
// "Ghana" => "Ghana",
// "Gibraltar" => "Gibraltar",
// "Greece" => "Greece",
// "Greenland" => "Greenland",
// "Grenada" => "Grenada",
// "Guadeloupe" => "Guadeloupe",
// "Guam" => "Guam",
// "Guatemala" => "Guatemala",
// "Guernsey" => "Guernsey",
// "Guinea" => "Guinea",
// "Guinea Bissau" => "Guinea Bissau",
// "Guyana" => "Guyana",
// "Haiti" => "Haiti",
// "Heard Island and McDonald Islands" => "Heard Island and McDonald Islands",
// "Honduras" => "Honduras",
// "Hong Kong" => "Hong Kong",
// "Hungary" => "Hungary",
// "Iceland" => "Iceland",
// "India" => "India",
// "Indonesia" => "Indonesia",
// "Iran" => "Iran",
// "Iraq" => "Iraq",
// "Ireland" => "Ireland",
// "Isle of Man" => "Isle of Man",
// "Israel" => "Israel",
// "Italy" => "Italy",
// "Ivory Coast" => "Ivory Coast",
// "Jamaica" => "Jamaica",
// "Japan" => "Japan",
// "Jersey" => "Jersey",
// "Jordan" => "Jordan",
// "Kazakstan" => "Kazakstan",
// "Kenya" => "Kenya",
// "Kiribati" => "Kiribati",
// "Kuwait" => "Kuwait",
// "Kyrgyzstan" => "Kyrgyzstan",
// "Laos" => "Laos",
// "Latvia" => "Latvia",
// "Lebanon" => "Lebanon",
// "Lesotho" => "Lesotho",
// "Liberia" => "Liberia",
// "Libya" => "Libya",
// "Liechtenstein" => "Liechtenstein",
// "Lithuania" => "Lithuania",
// "Luxemburg" => "Luxemburg",
// "Macao" => "Macao",
// "Macedonia" => "Macedonia",
// "Madagascar" => "Madagascar",
// "Malawi" => "Malawi",
// "Malaysia" => "Malaysia",
// "Maldives" => "Maldives",
// "Mali" => "Mali",
// "Malta" => "Malta",
// "Marshall Islands" => "Marshall Islands",
// "Martinique" => "Martinique",
// "Mauritania" => "Mauritania",
// "Mauritius" => "Mauritius",
// "Mayotte" => "Mayotte",
// "Mexico" => "Mexico",
// "Moldova" => "Moldova",
// "Monaco" => "Monaco",
// "Mongolia" => "Mongolia",
// "Montenegro" => "Montenegro",
// "Montserrat" => "Montserrat",
// "Morocco" => "Morocco",
// "Mozambique" => "Mozambique",
// "Myanmar" => "Myanmar",
// "Namibia" => "Namibia",
// "Nauru" => "Nauru",
// "Nepal" => "Nepal",
// "Netherlands" => "Netherlands",
// "Netherlands Antilles" => "Netherlands Antilles",
// "New Caledonia" => "New Caledonia",
// "New Zealand" => "New Zealand",
// "Nicaragua" => "Nicaragua",
// "Niger" => "Niger",
// "Nigeria" => "Nigeria",
// "Niue" => "Niue",
// "None" => "None",
// "Norfolk Island" => "Norfolk Island",
// "Northern Mariana Islands" => "Northern Mariana Islands",
// "North Korea" => "North Korea",
// "Norway" => "Norway",
// "Oman" => "Oman",
// "Other" => "Other",
// "Pakistan" => "Pakistan",
// "Palau" => "Palau",
// "Palestine" => "Palestine",
// "Panama" => "Panama",
// "Papua New Guinea" => "Papua New Guinea",
// "Paraguay" => "Paraguay",
// "Peru" => "Peru",
// "Philippines" => "Philippines",
// "Pitcairn" => "Pitcairn",
// "Poland" => "Poland",
// "Portugal" => "Portugal",
// "Puerto Rico" => "Puerto Rico",
// "Quatar" => "Quatar",
// "Republic of Macedonia" => "Republic of Macedonia",
// "Reunion" => "Reunion",
// "Romania" => "Romania",
// "Russia" => "Russia",
// "Rwanda" => "Rwanda",
// "Saint Helena" => "Saint Helena",
// "Saint Kitts and Nevis" => "Saint Kitts and Nevis",
// "Saint Lucia" => "Saint Lucia",
// "Saint Pierre and Miquelon" => "Saint Pierre and Miquelon",
// "Samoa" => "Samoa",
// "San Marino" => "San Marino",
// "Sao Tome and Principe" => "Sao Tome and Principe",
// "Saudi Arabia" => "Saudi Arabia",
// "Senegal" => "Senegal",
// "Serbia" => "Serbia",
// "Seychelles" => "Seychelles",
// "Sierra Leone" => "Sierra Leone",
// "Singapore" => "Singapore",
// "Slovakia" => "Slovakia",
// "Slovenia" => "Slovenia",
// "Solomon Islands" => "Solomon Islands",
// "Somalia" => "Somalia",
// "South Africa" => "South Africa",
// "South Georgia and South Sandwich Islands" => "South Georgia and South Sandwich Islands",
// "South Korea" => "South Korea",
// "Spain" => "Spain",
// "Sri Lanka" => "Sri Lanka",
// "St Vincent Grenadines" => "St Vincent Grenadines",
// "Sudan" => "Sudan",
// "Surinam" => "Surinam",
// "Svalbard and Jan Mayen" => "Svalbard and Jan Mayen",
// "Swaziland" => "Swaziland",
// "Sweden" => "Sweden",
// "Switzerland" => "Switzerland",
// "Syria" => "Syria",
// "Taiwan" => "Taiwan",
// "Tajikistan" => "Tajikistan",
// "Tanzania" => "Tanzania",
// "Thailand" => "Thailand",
// "Timor-Leste" => "Timor-Leste",
// "Togo" => "Togo",
// "Tokelau" => "Tokelau",
// "Tonga" => "Tonga",
// "Trinidad Tobago" => "Trinidad Tobago",
// "Tunisia" => "Tunisia",
// "Turkey" => "Turkey",
// "Turkmenistan" => "Turkmenistan",
// "Turks and Caicos Islands" => "Turks and Caicos Islands",
// "Tuvalu" => "Tuvalu",
// "Uganda" => "Uganda",
// "Ukraine" => "Ukraine",
// "United Arab Emirates" => "United Arab Emirates",
// "United Kingdom" => "United Kingdom",
// "United Nations Organization" => "United Nations Organization",
// "United States" => "United States",
// "United States Minor Outlying Islands" => "United States Minor Outlying Islands",
// "Uruguay" => "Uruguay",
// "US Virgin Islands" => "US Virgin Islands",
// "Uzbekistan" => "Uzbekistan",
// "Vanuatu" => "Vanuatu",
// "Vatican" => "Vatican",
// "Venezuela" => "Venezuela",
// "Viet Nam" => "Viet Nam",
// "Wales" => "Wales",
// "Wallis and Futuna" => "Wallis and Futuna",
// "Western Sahara" => "Western Sahara",
// "World" => "World",
// "Yemen" => "Yemen",
// "Yugoslavia" => "Yugoslavia",
// "Zambia" => "Zambia",
// "Zimbabwe" => "Zimbabwe",
// "MySQL Improved (mysqli). Requires MySQL 4.1+" => "MySQL Improved (mysqli). Requires MySQL 4.1+",
// "MySQL classic (mysql)" => "MySQL classic (mysql)",
// "PostgreSQL" => "PostgreSQL",
// "Email address not valid, test mail not sent" => "Email address not valid, test mail not sent",
// "Email address empty and \"copy\" checkbox not set, test mail not sent" => "Email address empty and \"copy\" checkbox not set, test mail not sent",
// "Test mail from Tiki installer " => "Test mail from Tiki installer ",
// "Tiki version" => "Tiki version",
// "PHP version" => "PHP version",
// "Server" => "Server",
// "Congratulations!\n\nYour server can send emails.\n\n" => "Congratulations!\n\nYour server can send emails.\n\n",
// "Slovene" => "Slovene",
// "Arabic" => "Arabic",
// "Catalan" => "Catalan",
// "Simplified Chinese" => "Simplified Chinese",
// "Chinese" => "Chinese",
// "Czech" => "Czech",
// "Danish" => "Danish",
// "German" => "German",
// "English" => "English",
// "English British" => "English British",
// "Spanish" => "Spanish",
// "Greek" => "Greek",
// "Farsi" => "Farsi",
// "Finnish" => "Finnish",
// "Fijian" => "Fijian",
// "French" => "French",
// "Galician" => "Galician",
// "Hebrew" => "Hebrew",
// "Croatian" => "Croatian",
// "Italian" => "Italian",
// "Japanese" => "Japanese",
// "Korean" => "Korean",
// "Hungarian" => "Hungarian",
// "Dutch" => "Dutch",
// "Norwegian" => "Norwegian",
// "Polish" => "Polish",
// "Português" => "Português",
// "Brazilian Portuguese" => "Brazilian Portuguese",
// "Russian" => "Russian",
// "Pijin Solomon" => "Pijin Solomon",
// "Slovak" => "Slovak",
// "Serbian" => "Serbian",
// "Serbian Latin" => "Serbian Latin",
// "Swedish" => "Swedish",
// "Tuvaluan" => "Tuvaluan",
// "Traditional Chinese" => "Traditional Chinese",
// "Ukrainian" => "Ukrainian",
// "All Day" => "All Day",
// "Invalid filename (using filters for filenames)" => "Invalid filename (using filters for filenames)",
// "Please wait %d seconds between posts" => "Please wait %d seconds between posts",
// "You have to enter a title and text" => "You have to enter a title and text",
// "Invalid Email" => "Invalid Email",
// "Your message has been queued for approval and will be posted after a moderator approves it" => "Your message has been queued for approval and will be posted after a moderator approves it",
// "This forum is locked" => "This forum is locked",
// "This thread is locked" => "This thread is locked",
// "Those comments are locked" => "Those comments are locked",
// "WikiDiff::apply: line count mismatch: %s != %s" => "WikiDiff::apply: line count mismatch: %s != %s",
// "WikiDiff::_check: failed" => "WikiDiff::_check: failed",
// "WikiDiff::_check: edit sequence is non-optimal" => "WikiDiff::_check: edit sequence is non-optimal",
// "WikiDiff Okay: LCS = %s" => "WikiDiff Okay: LCS = %s",
// "Newsletter subscription information at" => "Newsletter subscription information at",
// "The global quota has been reached" => "The global quota has been reached",
// "The quota has been reached in" => "The quota has been reached in",
// "File gallery quota exceeded" => "File gallery quota exceeded",
// "Number of files transfered to the database" => "Number of files transfered to the database",
// "Number of files transfered to the file system" => "Number of files transfered to the file system",
// "Cannot read to this file" => "Cannot read to this file",
// "This is an approximation based on your server memory limit" => "This is an approximation based on your server memory limit",
// "This is the value of your server's PHP '%s' setting" => "This is the value of your server's PHP '%s' setting",
// "You are alerted by the server " => "You are alerted by the server ",
// "You can check the modifications at : " => "You can check the modifications at : ",
// "You are alerted of a change on " => "You are alerted of a change on ",
// "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>" => "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>",
// "unlink failed" => "unlink failed",
// "The uploaded file exceeds the upload_max_filesize directive in php.ini" => "The uploaded file exceeds the upload_max_filesize directive in php.ini",
// "The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form" => "The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form",
// "The uploaded file was only partially uploaded. Please try again" => "The uploaded file was only partially uploaded. Please try again",
// "No file was uploaded" => "No file was uploaded",
// "Missing a temporary folder" => "Missing a temporary folder",
// "Failed to write file to disk" => "Failed to write file to disk",
// "File upload stopped by extension" => "File upload stopped by extension",
// "Invalid file mime type" => "Invalid file mime type",
// "XML file does not validate against the Mediawiki XML schema" => "XML file does not validate against the Mediawiki XML schema",
// "No valid ogr2ogr executable" => "No valid ogr2ogr executable",
// "Could not create \$tdo.mif in data directory" => "Could not create \$tdo.mif in data directory",
// "Could not create \$tdo.mid in data directory" => "Could not create \$tdo.mid in data directory",
// "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it" => "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it",
// "File %s is not a valid archive" => "File %s is not a valid archive",
// "Impossible to open %s : %s" => "Impossible to open %s : %s",
// "The content retrieved at %s is not a list of mods" => "The content retrieved at %s is not a list of mods",
// "Can't chdir to '%s'" => "Can't chdir to '%s'",
// "%s impossible to remove" => "%s impossible to remove",
// "Description not available" => "Description not available",
// "Module Title" => "Module Title",
// "Title to display at the top of the box" => "Title to display at the top of the box",
// "No box" => "No box",
// "Show only the content" => "Show only the content",
// "Decorations" => "Decorations",
// "Show module decorations" => "Show module decorations",
// "No title" => "No title",
// "Show module title" => "Show module title",
// "Perspective" => "Perspective",
// "Only display the module if in one of the listed perspectives. Semi-colon separated" => "Only display the module if in one of the listed perspectives. Semi-colon separated",
// "Module only applicable for the specified languages. Languages are defined as two character language codes. Multiple values can be separated by semi-colons" => "Module only applicable for the specified languages. Languages are defined as two character language codes. Multiple values can be separated by semi-colons",
// "Module only applicable for the specified sections. Multiple values can be separated by semi-colons" => "Module only applicable for the specified sections. Multiple values can be separated by semi-colons",
// "Page filter" => "Page filter",
// "Module only applicable on the specified page names. Multiple values can be separated by semi-colons" => "Module only applicable on the specified page names. Multiple values can be separated by semi-colons",
// "No Page" => "No Page",
// "Module not applicable on the specified page names. Multiple values can be separated by semi-colons" => "Module not applicable on the specified page names. Multiple values can be separated by semi-colons",
// "Theme" => "Theme",
// "Module enabled or disabled depending on the theme. Specified themes can be either included or excluded. Theme names prefixed by \\\"!\\\" are in the exclusion list. Multiple values can be separated by semi-colons" => "Module enabled or disabled depending on the theme. Specified themes can be either included or excluded. Theme names prefixed by \\\"!\\\" are in the exclusion list. Multiple values can be separated by semi-colons",
// "Module only available based on the relationship of the user with the wiki page. Either only creators (y) or only non-creators (n) will see the module" => "Module only available based on the relationship of the user with the wiki page. Either only creators (y) or only non-creators (n) will see the module",
// "Contributor" => "Contributor",
// "Module only available based on the relationship of the user with the wiki page. Either only contributors (y) or only non-contributors (n) will see the module" => "Module only available based on the relationship of the user with the wiki page. Either only contributors (y) or only non-contributors (n) will see the module",
// "Flip" => "Flip",
// "Users can shade module" => "Users can shade module",
// "No numbers" => "No numbers",
// "If set to \"y\", the module will not number list items" => "If set to \"y\", the module will not number list items",
// "Number of rows, or items, to display" => "Number of rows, or items, to display",
// "Default: 10" => "Default: 10",
// "section edit" => "section edit",
// "Users accept internal messages by default" => "Users accept internal messages by default",
// "Users can opt-out internal messages" => "Users can opt-out internal messages",
// "Publication date" => "Publication date",
// "Expiration date" => "Expiration date",
// "Rating" => "Rating",
// "Default number per page" => "Default number per page",
// "Default Ordering" => "Default Ordering",
// "Points" => "Points",
// "Default article image width" => "Default article image width",
// "0 for original image size" => "0 for original image size",
// "Default article image height" => "Default article image height",
// "Authentication method" => "Authentication method",
// "Multiple authentication backends are supported by Tikiwiki. The default value is to use the internal user database" => "Multiple authentication backends are supported by Tikiwiki. The default value is to use the internal user database",
// "Tiki" => "Tiki",
// "Tiki and OpenID" => "Tiki and OpenID",
// "Tiki and PAM" => "Tiki and PAM",
// "Tiki and LDAP" => "Tiki and LDAP",
// "CAS (Central Authentication Service)" => "CAS (Central Authentication Service)",
// "Shibboleth" => "Shibboleth",
// "Web Server" => "Web Server",
// "Available languages" => "Available languages",
// "By default, all languages supported by tikiwiki are available on multilingual sites. This option allows to limit the languages to a subset" => "By default, all languages supported by tikiwiki are available on multilingual sites. This option allows to limit the languages to a subset",
// "Blog title (asc)" => "Blog title (asc)",
// "Number of posts (desc)" => "Number of posts (desc)",
// "Visits (desc)" => "Visits (desc)",
// "Activity (desc)" => "Activity (desc)",
// "Link to user information" => "Link to user information",
// "User avatar" => "User avatar",
// "Blogues" => "Blogues",
// "Categories used in templates (TPL)" => "Categories used in templates (TPL)",
// "Exclude these categories" => "Exclude these categories",
// "Users can change site language" => "Users can change site language",
// "Allow users to change the language of the menus and labels" => "Allow users to change the language of the menus and labels",
// "Spell checking" => "Spell checking",
// "Allow anonymous visitors to use the \"Contact Us\" feature" => "Allow anonymous visitors to use the \"Contact Us\" feature",
// "Contact user" => "Contact user",
// "Count admin pageviews" => "Count admin pageviews",
// "Default charset for sending mail" => "Default charset for sending mail",
// "utf-8" => "utf-8",
// "iso-8859-1" => "iso-8859-1",
// "default mapfile" => "default mapfile",
// "Article RSS Description" => "Article RSS Description",
// "Description to be published as part of the RSS feed for articles" => "Description to be published as part of the RSS feed for articles",
// "Show Country Flag" => "Show Country Flag",
// "Show the country flag" => "Show the country flag",
// "Enable cool sites" => "Enable cool sites",
// "'),\n\t\t\t'type' => 'flag" => "'),\n\t\t\t'type' => 'flag",
// "Validate URLs" => "Validate URLs",
// "Number of columns per page when listing directory categories" => "Number of columns per page when listing directory categories",
// "6" => "6",
// "Links per page" => "Links per page",
// "'),\n\t\t\t'type' => 'text" => "'),\n\t\t\t'type' => 'text",
// "Method to Open Directory Links" => "Method to Open Directory Links",
// "Method to open directory links" => "Method to open directory links",
// "replace current window" => "replace current window",
// "new window" => "new window",
// "inline frame" => "inline frame",
// "PHP errors visible to admin only" => "PHP errors visible to admin only",
// "For development purposes, it\\'s better to display errors for all users. However, in production settings, they should only be displayed to administrators" => "For development purposes, it\\'s better to display errors for all users. However, in production settings, they should only be displayed to administrators",
// "PHP Error reporting level" => "PHP Error reporting level",
// "Level from which errors should be reported" => "Level from which errors should be reported",
// "No error reporting" => "No error reporting",
// "Report all PHP errors except strict" => "Report all PHP errors except strict",
// "Report all PHP errors" => "Report all PHP errors",
// "Report all PHP errors except notices" => "Report all PHP errors except notices",
// "Default number of comments per page" => "Default number of comments per page",
// "Comments default ordering" => "Comments default ordering",
// "Question and Answer prefix on Answers" => "Question and Answer prefix on Answers",
// "Q and A" => "Q and A",
// "Question ID" => "Question ID",
// "Collaboratively authored documents with history of changes" => "Collaboratively authored documents with history of changes",
// "Online diaries or journals" => "Online diaries or journals",
// "Collections of graphic images for viewing or downloading (photo album)" => "Collections of graphic images for viewing or downloading (photo album)",
// "Machine Translation (by Google Translate)" => "Machine Translation (by Google Translate)",
// "Uses Google Translate to translate the content of wiki pages to other languages" => "Uses Google Translate to translate the content of wiki pages to other languages",
// "Experimental. This feature is still under development" => "Experimental. This feature is still under development",
// "Database & form generator" => "Database & form generator",
// "Online discussions on a variety of topics. Threaded or flat" => "Online discussions on a variety of topics. Threaded or flat",
// "Computer files, videos or software for downloading. With check-in & check-out (lock)" => "Computer files, videos or software for downloading. With check-in & check-out (lock)",
// "Articles can be used for date-specific news and announcements. You can configure articles to automatically publish and expire at specific times or to require that submissions be approved before becoming \"live.\"" => "Articles can be used for date-specific news and announcements. You can configure articles to automatically publish and expire at specific times or to require that submissions be approved before becoming \"live.\"",
// "Brief list of votable options; appears in module (left or right column)" => "Brief list of votable options; appears in module (left or right column)",
// "Content mailed to registered users" => "Content mailed to registered users",
// "Events calendar with public, private and group channels" => "Events calendar with public, private and group channels",
// "Banners" => "Banners",
// "Insert, track, and manage advertising banners" => "Insert, track, and manage advertising banners",
// "Global category system. Items of different types (wiki pages, articles, tracker items, etc) can be added to one or many categories. Categories can have permissions" => "Global category system. Items of different types (wiki pages, articles, tracker items, etc) can be added to one or many categories. Categories can have permissions",
// "Score is a game to motivate participants to increase their contribution by comparing to other users" => "Score is a game to motivate participants to increase their contribution by comparing to other users",
// "Enables searching for content on the website" => "Enables searching for content on the website",
// "Allows to set tags on pages and various objects within the website and generate tag cloud navigation patterns" => "Allows to set tags on pages and various objects within the website and generate tag cloud navigation patterns",
// "Action Log" => "Action Log",
// "Allows to keep track of what users are doing and produce reports on a per-user or per-category basis" => "Allows to keep track of what users are doing and produce reports on a per-user or per-category basis",
// "Allows users to specify the type of contribution they are making while editing objects. The contributions are then displayed as color-coded in history and other reports" => "Allows users to specify the type of contribution they are making while editing objects. The contributions are then displayed as color-coded in history and other reports",
// "Multilingual" => "Multilingual",
// "Enables internationalization features and multilingual support for then entire site" => "Enables internationalization features and multilingual support for then entire site",
// "Frequently asked questions and answers" => "Frequently asked questions and answers",
// "Questionnaire with multiple choice or open ended question" => "Questionnaire with multiple choice or open ended question",
// "User-submitted Web links" => "User-submitted Web links",
// "Quizzes " => "Quizzes ",
// "Timed questionnaire with recorded scores" => "Timed questionnaire with recorded scores",
// "Simple menu system which can optionally add an external web page in an iframe" => "Simple menu system which can optionally add an external web page in an iframe",
// "The Copyright Management System (or ©MS) is a way of licensing your content" => "The Copyright Management System (or ©MS) is a way of licensing your content",
// "Multimedia" => "Multimedia",
// "The applet is designed to read MP3 or FLV file" => "The applet is designed to read MP3 or FLV file",
// "Experimental. This feature is not actively maintained" => "Experimental. This feature is not actively maintained",
// "Quick comment (graffiti) box. Like a group chat, but not in real time" => "Quick comment (graffiti) box. Like a group chat, but not in real time",
// "Navigable, interactive maps with user-selectable layers" => "Navigable, interactive maps with user-selectable layers",
// "Requires mapserver" => "Requires mapserver",
// "Interactive use of Google Maps" => "Interactive use of Google Maps",
// "Live support system" => "Live support system",
// "One-on-one chatting with customer" => "One-on-one chatting with customer",
// "Tell a Friend" => "Tell a Friend",
// "Add a link \"Email this page\" in all the pages" => "Add a link \"Email this page\" in all the pages",
// "Static and dynamic HTML content" => "Static and dynamic HTML content",
// "HTML can be used in wiki pages. This is a separate feature" => "HTML can be used in wiki pages. This is a separate feature",
// "Contact Us" => "Contact Us",
// "Basic form from visitor to admin" => "Basic form from visitor to admin",
// "Minichat" => "Minichat",
// "Real-time group text chatting" => "Real-time group text chatting",
// "Comments Moderation " => "Comments Moderation ",
// "An admin must validate a comment before it is visible" => "An admin must validate a comment before it is visible",
// "Comments Locking" => "Comments Locking",
// "Comments can be closed (no new comments)" => "Comments can be closed (no new comments)",
// "Allow posting of comments as Anonymous" => "Allow posting of comments as Anonymous",
// "Permit anonymous visitors to add a comment without needing to create an account" => "Permit anonymous visitors to add a comment without needing to create an account",
// "Display page description" => "Display page description",
// "Display the page description below the heading when viewing the page" => "Display the page description below the heading when viewing the page",
// "Display page title" => "Display page title",
// "Display the page name at the top of each page. If not enabled, the content must be structured to contain a header" => "Display the page name at the top of each page. If not enabled, the content must be structured to contain a header",
// "Display page ID" => "Display page ID",
// "Display the internal page ID when viewing the page" => "Display the internal page ID when viewing the page",
// "Individual wiki cache" => "Individual wiki cache",
// "Allow users to change the duration of the cache on a per-page basis" => "Allow users to change the duration of the cache on a per-page basis",
// "JS Calendar" => "JS Calendar",
// "JavaScript popup date selector" => "JavaScript popup date selector",
// "PHPLayers" => "PHPLayers",
// "PhpLayers Dynamic menus" => "PhpLayers Dynamic menus",
// "Output should be HTMLPurified" => "Output should be HTMLPurified",
// "This enable HTPMPurifier on outputs to filter remaining security problems like XSS" => "This enable HTPMPurifier on outputs to filter remaining security problems like XSS",
// "Full Screen" => "Full Screen",
// "Allow users to activate fullscreen mode" => "Allow users to activate fullscreen mode",
// "Css Menus" => "Css Menus",
// "Css Menus (suckerfish)" => "Css Menus (suckerfish)",
// "Shadowbox" => "Shadowbox",
// "Quick Permission Assignment" => "Quick Permission Assignment",
// "Quickperms allow to define classes of privileges and grant them to roles on objects" => "Quickperms allow to define classes of privileges and grant them to roles on objects",
// "HTML Purifier" => "HTML Purifier",
// "Ajax" => "Ajax",
// "Mobile" => "Mobile",
// "Morcego 3D browser" => "Morcego 3D browser",
// "Mindmap" => "Mindmap",
// "Print Indexed" => "Print Indexed",
// "Search engine friendly url" => "Search engine friendly url",
// "SpreadSheet" => "SpreadSheet",
// "Ajax auto-save" => "Ajax auto-save",
// "Save draft" => "Save draft",
// "Requires AJAX (experimental)" => "Requires AJAX (experimental)",
// "Kaltura" => "Kaltura",
// "Users can identify other users as their friends" => "Users can identify other users as their friends",
// "Neglected feature" => "Neglected feature",
// "Banning system" => "Banning system",
// "Action calendar" => "Action calendar",
// "Referer Stats" => "Referer Stats",
// "Redirect On Error" => "Redirect On Error",
// "Redirect to a similar wiki page if an exact match is not found" => "Redirect to a similar wiki page if an exact match is not found",
// "Communications (send/receive objects)" => "Communications (send/receive objects)",
// "Custom Home" => "Custom Home",
// "User Preferences Screen" => "User Preferences Screen",
// "User Notepad" => "User Notepad",
// "User Bookmarks" => "User Bookmarks",
// "User Contacts" => "User Contacts",
// "Group Watches" => "Group Watches",
// "Daily Reports for User Watches" => "Daily Reports for User Watches",
// "User Watches Translations" => "User Watches Translations",
// "User Tasks" => "User Tasks",
// "User Messages" => "User Messages",
// "User Levels" => "User Levels",
// "Group Alert" => "Group Alert",
// "XMLRPC API" => "XMLRPC API",
// "Debugger Console" => "Debugger Console",
// "TikiTests" => "TikiTests",
// "Use Minified Scripts" => "Use Minified Scripts",
// "These JavaScript files have been previously minified and are stable. They make pages quicker to load than their non-minified versions" => "These JavaScript files have been previously minified and are stable. They make pages quicker to load than their non-minified versions",
// "Check for updates automatically" => "Check for updates automatically",
// "TikiWiki will check for updates when you access the main Administration page" => "TikiWiki will check for updates when you access the main Administration page",
// "Use PEAR::Date library" => "Use PEAR::Date library",
// "Require confirmation if possible CSRF detected" => "Require confirmation if possible CSRF detected",
// "Protect against CSRF with a ticket" => "Protect against CSRF with a ticket",
// "Detect browser language" => "Detect browser language",
// "Lookup the user\\'s preferred language through browser preferences" => "Lookup the user\\'s preferred language through browser preferences",
// "Show pages in user\\'s preferred language" => "Show pages in user\\'s preferred language",
// "When accessing a page which has an equivalent in the user\\'s preferred language, favor the translated page" => "When accessing a page which has an equivalent in the user\\'s preferred language, favor the translated page",
// "Changing the page language also changes the site language" => "Changing the page language also changes the site language",
// "Translation assistant" => "Translation assistant",
// "Track translation operations between pages" => "Track translation operations between pages",
// "Urgent translation notifications" => "Urgent translation notifications",
// "Allow to flag changes as urgent, leading translations to be marked with a notice visible to all users" => "Allow to flag changes as urgent, leading translations to be marked with a notice visible to all users",
// "Incomplete translation notice" => "Incomplete translation notice",
// "When a page is translated to a new language, a notice will be automatically be inserted into the page to indicate that the translation is not yet complete" => "When a page is translated to a new language, a notice will be automatically be inserted into the page to indicate that the translation is not yet complete",
// "Structures to lookup equivalent pages in other languages. May cause performance problems on larger structures" => "Structures to lookup equivalent pages in other languages. May cause performance problems on larger structures",
// "Display all languages in a single page" => "Display all languages in a single page",
// "List all languages as a language option in the page language drop list to see all languages at once" => "List all languages as a language option in the page language drop list to see all languages at once",
// "GZip output" => "GZip output",
// "Help System" => "Help System",
// "Translation URLs" => "Translation URLs",
// "Show clickable URLs to translate the page to another language using Babel Fish website" => "Show clickable URLs to translate the page to another language using Babel Fish website",
// "Translation icons" => "Translation icons",
// "Show clickable icons to translate the page to another language using Babelfish website" => "Show clickable icons to translate the page to another language using Babelfish website",
// "Also known as emoticons" => "Also known as emoticons",
// "Dynamic Content System" => "Dynamic Content System",
// "Bloc of content which can be reused and programmed (timed)" => "Bloc of content which can be reused and programmed (timed)",
// "Use File Galleries to store pictures" => "Use File Galleries to store pictures",
// "External link icon" => "External link icon",
// "Semantic links" => "Semantic links",
// "Going beyond Backlinks, allows to define some semantic relationships between wiki pages" => "Going beyond Backlinks, allows to define some semantic relationships between wiki pages",
// "Web Services" => "Web Services",
// "Can consume webservices in JSON or YAML" => "Can consume webservices in JSON or YAML",
// "Display menus as folders" => "Display menus as folders",
// "Breadcrumbs" => "Breadcrumbs",
// "Anonymous editors must enter anti-bot code (CAPTCHA)" => "Anonymous editors must enter anti-bot code (CAPTCHA)",
// "Protect email against spam" => "Protect email against spam",
// "Anonymous voting" => "Anonymous voting",
// "Allow re-voting" => "Allow re-voting",
// "Comments" => "Comments",
// "Search engine friendly url Postfilter" => "Search engine friendly url Postfilter",
// "Display article title in the sefurl" => "Display article title in the sefurl",
// "Display blog title in the sefurl" => "Display blog title in the sefurl",
// "Show module controls" => "Show module controls",
// "Perspectives" => "Perspectives",
// "Permits to override preferences" => "Permits to override preferences",
// "Search and replace" => "Search and replace",
// "Permits find and replace of content in the edit box" => "Permits find and replace of content in the edit box",
// "Submissions" => "Submissions",
// "Specify notification emails when creating articles" => "Specify notification emails when creating articles",
// "Category path" => "Category path",
// "Show category objects" => "Show category objects",
// "Use PHPLayers for category browser" => "Use PHPLayers for category browser",
// "Ignore category viewing restrictions" => "Ignore category viewing restrictions",
// "Screencasts" => "Screencasts",
// "Allow to upload screencasts from wiki edit. Screencasts can be uploaded locally or on a WebDAV share" => "Allow to upload screencasts from wiki edit. Screencasts can be uploaded locally or on a WebDAV share",
// "Screencasts upload location" => "Screencasts upload location",
// "Local path or webdav path to the file upload location" => "Local path or webdav path to the file upload location",
// "Trailing slash required" => "Trailing slash required",
// "Screencasts HTTP prefix" => "Screencasts HTTP prefix",
// "Prefix to use for the files when generating a link to it" => "Prefix to use for the files when generating a link to it",
// "Screencast upload type" => "Screencast upload type",
// "Mode used to upload files. WebDav is used to upload to remote servers" => "Mode used to upload files. WebDav is used to upload to remote servers",
// "Local" => "Local",
// "Webdav" => "Webdav",
// "Screencasts authentication user" => "Screencasts authentication user",
// "When using webdav to upload files, used as the username of the authentication credentials" => "When using webdav to upload files, used as the username of the authentication credentials",
// "Screencasts authentication password" => "Screencasts authentication password",
// "When using webdav to upload files, used as the password of the authentication credentials" => "When using webdav to upload files, used as the password of the authentication credentials",
// "Screencasts max file size" => "Screencasts max file size",
// "Maximum file size used for screencasts" => "Maximum file size used for screencasts",
// "Value provided in bytes" => "Value provided in bytes",
// "Page List" => "Page List",
// "The pagelist feature allows to maintain lists of pages and their associated score and priority" => "The pagelist feature allows to maintain lists of pages and their associated score and priority",
// "Database search" => "Database search",
// "Referer Search Highlighting" => "Referer Search Highlighting",
// "Ignore individual object permissions" => "Ignore individual object permissions",
// "Object filter" => "Object filter",
// "Search box" => "Search box",
// "Pertinence" => "Pertinence",
// "Last modified date" => "Last modified date",
// "Blog-level" => "Blog-level",
// "Batch uploading" => "Batch uploading",
// "Accept wiki syntax" => "Accept wiki syntax",
// "Topic archiving" => "Topic archiving",
// "Quick jumps" => "Quick jumps",
// "Replies are empty" => "Replies are empty",
// "First post of a thread can have an empty body" => "First post of a thread can have an empty body",
// "Forum name search" => "Forum name search",
// "Forum content search" => "Forum content search",
// "Topic content search" => "Topic content search",
// "Use Tiki (database-independent) search" => "Use Tiki (database-independent) search",
// "Use database (full-text) search" => "Use database (full-text) search",
// "Store password as plain text" => "Store password as plain text",
// "Admins can search for features in the admin panels" => "Admins can search for features in the admin panels",
// "Encryption method" => "Encryption method",
// "tikihash (old)" => "tikihash (old)",
// "Display 'MyTiki' in the application menu" => "Display 'MyTiki' in the application menu",
// "Show user's contribution on the user information page" => "Show user's contribution on the user information page",
// "Permission to all (not just any) of an object's categories is required for access" => "Permission to all (not just any) of an object's categories is required for access",
// "Require file author's name for anonymous uploads" => "Require file author's name for anonymous uploads",
// "Add a Powered by Tiki link on your site's footer" => "Add a Powered by Tiki link on your site's footer",
// "Podcast directory" => "Podcast directory",
// "The server must be able to read/write the directory" => "The server must be able to read/write the directory",
// "Required for podcasts" => "Required for podcasts",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols",
// "The server must be able to read the directory" => "The server must be able to read the directory",
// "The directory can be outside the web space" => "The directory can be outside the web space",
// "Prevent download if score becomes negative" => "Prevent download if score becomes negative",
// "Allow download limit per file" => "Allow download limit per file",
// "Allow same file to be uploaded more than once" => "Allow same file to be uploaded more than once",
// "Never" => "Never",
// "Must match" => "Must match",
// "Cannot match" => "Cannot match",
// "Quota for all the files and archives" => "Quota for all the files and archives",
// "(0 for illimitted)" => "(0 for illimitted)",
// "Quota can be defined for each file gallery" => "Quota can be defined for each file gallery",
// "Default quota for each new gallery" => "Default quota for each new gallery",
// "Show quota bar in the list page" => "Show quota bar in the list page",
// "Uploaded filenames must match regex" => "Uploaded filenames must match regex",
// "Manage thread defaults per-forum" => "Manage thread defaults per-forum",
// "Display thread configuration bar" => "Display thread configuration bar",
// "Display thread configuration bar only when number of posts exceed" => "Display thread configuration bar only when number of posts exceed",
// "Keep settings for all forums during the user session" => "Keep settings for all forums during the user session",
// "Default style" => "Default style",
// "Default sort mode" => "Default sort mode",
// "Posts per day" => "Posts per day",
// "Description length" => "Description length",
// "Do not prefix messages titles by 'Re: '" => "Do not prefix messages titles by 'Re: '",
// "Default ordering" => "Default ordering",
// "Creation Date (asc)" => "Creation Date (asc)",
// "Creation Date (desc)" => "Creation Date (desc)",
// "Threads (desc)" => "Threads (desc)",
// "Last post (desc)" => "Last post (desc)",
// "Name (desc)" => "Name (desc)",
// "Name (asc)" => "Name (asc)",
// "Multilingual tags" => "Multilingual tags",
// "Permits translation management of tags" => "Permits translation management of tags",
// "Browser title" => "Browser title",
// "Label visible in the browser\\'s title bar on all pages. Also appears in search engines" => "Label visible in the browser\\'s title bar on all pages. Also appears in search engines",
// "Validate new user registrations by email" => "Validate new user registrations by email",
// "Upon registration, the new user will receive an email containing a link to confirm validity" => "Upon registration, the new user will receive an email containing a link to confirm validity",
// "Home page" => "Home page",
// "Landing page used for the wiki when no page is specified. The page will be created if it does not exist" => "Landing page used for the wiki when no page is specified. The page will be created if it does not exist",
// "Use group homepages" => "Use group homepages",
// "Go to group homepage only if login from default homepage" => "Go to group homepage only if login from default homepage",
// "Default language" => "Default language",
// "Site language used when no other language is specified by the user" => "Site language used when no other language is specified by the user",
// "Cache external pages" => "Cache external pages",
// "Cache external images" => "Cache external images",
// "Temporary directory" => "Temporary directory",
// "Help URL" => "Help URL",
// "The default help system may not be complete. You can help with the TikiWiki documentation" => "The default help system may not be complete. You can help with the TikiWiki documentation",
// "License page" => "License page",
// "Submit notice" => "Submit notice",
// "Full path to gdaltindex" => "Full path to gdaltindex",
// "Full path to ogr2ogr" => "Full path to ogr2ogr",
// "Map Zone" => "Map Zone",
// "[-180 180]" => "[-180 180]",
// "[0 360]" => "[0 360]",
// "Display modules to all groups always" => "Display modules to all groups always",
// "Hide anonymous-only modules from registered users" => "Hide anonymous-only modules from registered users",
// "Maximum number of articles on articles home page" => "Maximum number of articles on articles home page",
// "Url to go when clicking on a username" => "Url to go when clicking on a username",
// "Default: " => "Default: ",
// "Remind/forgot password" => "Remind/forgot password",
// "If passwords <em>are not</em> plain text, reset instructions will be emailed to the user" => "If passwords <em>are not</em> plain text, reset instructions will be emailed to the user",
// "If passwords <em>are stored</em> as plain text, the password will be emailed to the user" => "If passwords <em>are stored</em> as plain text, the password will be emailed to the user",
// "Use database for translation" => "Use database for translation",
// "Verify for available translations in the database" => "Verify for available translations in the database",
// "Language inclusion threshold" => "Language inclusion threshold",
// "When the number of languages is restricted on the site, and is below this number, all languages will be added to the preferred language list, even if unspecified by the user. However, priority will be given to the specified languages" => "When the number of languages is restricted on the site, and is below this number, all languages will be added to the preferred language list, even if unspecified by the user. However, priority will be given to the specified languages",
// "Maximum average server load threshold in the last minute" => "Maximum average server load threshold in the last minute",
// "Log mail in Tiki logs" => "Log mail in Tiki logs",
// "Add HTML comment at start and end of each Smarty template (TPL)" => "Add HTML comment at start and end of each Smarty template (TPL)",
// "Log SQL" => "Log SQL",
// "Log queries using more than (seconds)" => "Log queries using more than (seconds)",
// "This may impact performance" => "This may impact performance",
// "Mail end of line" => "Mail end of line",
// "CRLF (standard)" => "CRLF (standard)",
// "LF (some Unix MTA)" => "LF (some Unix MTA)",
// "full path to mapfiles" => "full path to mapfiles",
// "Wiki Page for Help" => "Wiki Page for Help",
// "Wiki Page for Comments" => "Wiki Page for Comments",
// "Memcache" => "Memcache",
// "Enable connection to memcached servers to store temporary information" => "Enable connection to memcached servers to store temporary information",
// "Requires the PHP memcache extension" => "Requires the PHP memcache extension",
// "Memcache flags" => "Memcache flags",
// "Configuration switches for memcache connection" => "Configuration switches for memcache connection",
// "Memcache servers" => "Memcache servers",
// "Server list which may be accessed. For each server, the address, port and weight must be specified" => "Server list which may be accessed. For each server, the address, port and weight must be specified",
// "One per line. address:port (weight)" => "One per line. address:port (weight)",
// "Memcache key prefix" => "Memcache key prefix",
// "When the memcache cluster is used by multiple applications, using unique prefixes for each of them helps avoiding conflicts" => "When the memcache cluster is used by multiple applications, using unique prefixes for each of them helps avoiding conflicts",
// "Memcache expiration" => "Memcache expiration",
// "Duration for which the data will be kept" => "Duration for which the data will be kept",
// "Cache wiki data in memcache" => "Cache wiki data in memcache",
// "Cache wiki output in memcache" => "Cache wiki output in memcache",
// "Cache forum output in memcache" => "Cache forum output in memcache",
// "Allow users to define icons for menus entries" => "Allow users to define icons for menus entries",
// "Default path for the icons" => "Default path for the icons",
// "Maximum mailbox size (messages, 0=unlimited)" => "Maximum mailbox size (messages, 0=unlimited)",
// "Maximum mail archive size (messages, 0=unlimited)" => "Maximum mail archive size (messages, 0=unlimited)",
// "Maximum sent box size (messages, 0=unlimited)" => "Maximum sent box size (messages, 0=unlimited)",
// "Keywords" => "Keywords",
// "Include freetags" => "Include freetags",
// "Use thread title instead" => "Use thread title instead",
// "Use image title instead" => "Use image title instead",
// "Use individual page description for Wiki pages instead" => "Use individual page description for Wiki pages instead",
// "geo.position" => "geo.position",
// "geo.region" => "geo.region",
// "geo.placename" => "geo.placename",
// "Meta robots" => "Meta robots",
// "Revisit after" => "Revisit after",
// "Multi-domain" => "Multi-domain",
// "Allows to map domain names to perspectives and simulate multiple domains hosted on the same instance" => "Allows to map domain names to perspectives and simulate multiple domains hosted on the same instance",
// "Multi-domain Configuration" => "Multi-domain Configuration",
// "Comma-separated values mapping the domain name to the perspective ID" => "Comma-separated values mapping the domain name to the perspective ID",
// "One domain per line. Comma separated with perspective ID" => "One domain per line. Comma separated with perspective ID",
// "Wiki buttons" => "Wiki buttons",
// "Page description, icons, backlinks, .." => "Page description, icons, backlinks, ..",
// "Top " => "Top ",
// "Bottom" => "Bottom",
// "Neither" => "Neither",
// "Show objects" => "Show objects",
// "Host" => "Host",
// "Proxy host" => "Proxy host",
// "Port" => "Port",
// "Proxy port" => "Proxy port",
// "Quantify change size" => "Quantify change size",
// "In addition to tracking the changes, track the change size and display the approximate up-to-date-ness of the page" => "In addition to tracking the changes, track the change size and display the approximate up-to-date-ness of the page",
// "Record untranslated strings" => "Record untranslated strings",
// "Keep track of the unsuccessful attemps to translate strings" => "Keep track of the unsuccessful attemps to translate strings",
// "Restrict supported languages" => "Restrict supported languages",
// "Limit the languages made available on the site" => "Limit the languages made available on the site",
// "Refresh mode" => "Refresh mode",
// "Random" => "Random",
// "Refresh rate" => "Refresh rate",
// "Minimum length of search word" => "Minimum length of search word",
// "Max. number of words containing a syllable" => "Max. number of words containing a syllable",
// "Max. age in hours of syllable search cache" => "Max. age in hours of syllable search cache",
// "LRU list purging rate" => "LRU list purging rate",
// "LRU list length" => "LRU list length",
// "Parse the results" => "Parse the results",
// "Sender email" => "Sender email",
// "Email address that will be used as the sender for outgoing emails" => "Email address that will be used as the sender for outgoing emails",
// "Session storage location" => "Session storage location",
// "Select where the session information should be stored. Memcache sessions require memcache to be configured" => "Select where the session information should be stored. Memcache sessions require memcache to be configured",
// "Default (from php.ini)" => "Default (from php.ini)",
// "Session lifetime" => "Session lifetime",
// "Value provided in minutes" => "Value provided in minutes",
// "Silent session" => "Silent session",
// "Do not automatically start sessions" => "Do not automatically start sessions",
// "Session cookie name" => "Session cookie name",
// "Session cookie name used instead of the PHP default configuration" => "Session cookie name used instead of the PHP default configuration",
// "Display available translations" => "Display available translations",
// "Close site (except for those with permission)" => "Close site (except for those with permission)",
// "Message to display" => "Message to display",
// "Locations (breadcrumbs)" => "Locations (breadcrumbs)",
// "Choices" => "Choices",
// "Site title location" => "Site title location",
// "Location of the site title in the browser title bar relative to the current page\\'s descriptor" => "Location of the site title in the browser title bar relative to the current page\\'s descriptor",
// "After" => "After",
// "Before" => "Before",
// "Browser title display mode" => "Browser title display mode",
// "When breadcrumbs are used, method in which the browser title should be displayed" => "When breadcrumbs are used, method in which the browser title should be displayed",
// "Most specific first" => "Most specific first",
// "Least specific first (site)" => "Least specific first (site)",
// "Current only" => "Current only",
// "Include smarty notices in PHP error report" => "Include smarty notices in PHP error report",
// "In most cases, smarty notices can be safely ignored. However, they may be useful in the development process when strange issues occur" => "In most cases, smarty notices can be safely ignored. However, they may be useful in the development process when strange issues occur",
// "Smarty Security" => "Smarty Security",
// "Do not allow php code in smarty templates" => "Do not allow php code in smarty templates",
// "Check frequency" => "Check frequency",
// "Each day" => "Each day",
// "Each week" => "Each week",
// "Each month" => "Each month",
// "Minify javascript" => "Minify javascript",
// "Compress javascript files used in the page into a single file to be distributed statically. Changes to javascript files will require cache to be cleared" => "Compress javascript files used in the page into a single file to be distributed statically. Changes to javascript files will require cache to be cleared",
// "Use Jquery autocomplete user selector for better performance when number of users exceed" => "Use Jquery autocomplete user selector for better performance when number of users exceed",
// "Close site when server load is above the threshold  (except for those with permission)" => "Close site when server load is above the threshold  (except for those with permission)",
// "Use proxy" => "Use proxy",
// "Show user\\'s real name instead of login (when possible)" => "Show user\\'s real name instead of login (when possible)",
// "Display UserTracker information on the user information page" => "Display UserTracker information on the user information page",
// "Users can configure modules" => "Users can configure modules",
// "Users can shade modules" => "Users can shade modules",
// "Module decides" => "Module decides",
// "Allow viewing HTML mails" => "Allow viewing HTML mails",
// "500Kb" => "500Kb",
// "1Mb" => "1Mb",
// "1.5Mb" => "1.5Mb",
// "2Mb" => "2Mb",
// "2.5Mb" => "2.5Mb",
// "3Mb" => "3Mb",
// "Include a flag by each e-mail to quickly flag/un-flag them" => "Include a flag by each e-mail to quickly flag/un-flag them",
// "Wiki link format" => "Wiki link format",
// "Character set used when detecting wiki links within pages" => "Character set used when detecting wiki links within pages",
// "Complete" => "Complete",
// "Latin" => "Latin",
// "Display by default only pages in current language" => "Display by default only pages in current language",
// "In Wiki page lists, display by default only pages in current language" => "In Wiki page lists, display by default only pages in current language",
// "Display page version" => "Display page version",
// "Display the page version information when viewing the page" => "Display the page version information when viewing the page",
// "Page name display stripper" => "Page name display stripper",
// "Character to use as a delimiter in the page name. The portion of the name after this character will not be displayed" => "Character to use as a delimiter in the page name. The portion of the name after this character will not be displayed",
// "Wiki author list style" => "Wiki author list style",
// "Changes the list format used to display the authors of the page" => "Changes the list format used to display the authors of the page",
// "Creator & Author" => "Creator & Author",
// "Business style" => "Business style",
// "Collaborative style" => "Collaborative style",
// "none (disabled)" => "none (disabled)",
// "Specify wiki author list style per page" => "Specify wiki author list style per page",
// "Allows to modify the style in which the author list is displayed on a per-page basis" => "Allows to modify the style in which the author list is displayed on a per-page basis",
// "Wiki action bar location" => "Wiki action bar location",
// "Buttons: Save, Preview, Cancel, .." => "Buttons: Save, Preview, Cancel, ..",
// "Wiki navigation bar location" => "Wiki navigation bar location",
// "When using the ...page... page break wiki syntax" => "When using the ...page... page break wiki syntax",
// "Wiki top line location" => "Wiki top line location",
// "Cache wiki pages (global)" => "Cache wiki pages (global)",
// "Enable page cache globally for wiki pages" => "Enable page cache globally for wiki pages",
// "Allow comments per page" => "Allow comments per page",
// "Enable control for comments on wiki pages individually" => "Enable control for comments on wiki pages individually",
// "Disable" => "Disable",
// "Enable (default On)" => "Enable (default On)",
// "Enable (default Off)" => "Enable (default Off)",
// "Enable edit plugin icons" => "Enable edit plugin icons",
// "Permits editing of a plugin, via a popup form, without needing to edit the whole page" => "Permits editing of a plugin, via a popup form, without needing to edit the whole page",
// "Enable wiki 3D browser" => "Enable wiki 3D browser",
// "Load page on navigation" => "Load page on navigation",
// "Browser height" => "Browser height",
// "Navigation depth" => "Navigation depth",
// "Node size" => "Node size",
// "Text size" => "Text size",
// "Spring (connection) size" => "Spring (connection) size",
// "Existing page node color" => "Existing page node color",
// "Missing page node color" => "Missing page node color",
// "Camera distance adjusted relative to nearest node" => "Camera distance adjusted relative to nearest node",
// "Camera distance" => "Camera distance",
// "Field of view" => "Field of view",
// "Feed animation interval (milisecs)" => "Feed animation interval (milisecs)",
// "Friction constant" => "Friction constant",
// "Elastic constant" => "Elastic constant",
// "Eletrostatic constant" => "Eletrostatic constant",
// "Node mass" => "Node mass",
// "Node charge" => "Node charge",
// "Enable plugin %0" => "Enable plugin %0",
// "Inline plugin %0 (hide plugin edit icon)" => "Inline plugin %0 (hide plugin edit icon)",
// "When inlined, the plugin edit icon will not appear" => "When inlined, the plugin edit icon will not appear",
// "... and is displayed by default" => "... and is displayed by default",
// "Reopen with the same editor" => "Reopen with the same editor",
// "Content is parsed like wiki page" => "Content is parsed like wiki page",
// "Content is partially parsed" => "Content is partially parsed",
// "Toolbar skin" => "Toolbar skin",
// "Default" => "Default",
// "Office 2003" => "Office 2003",
// "Silver" => "Silver",
// "Nothing was changed, please check profile for errors" => "Nothing was changed, please check profile for errors",
// "An error occurred: " => "An error occurred: ",
// "Applying profile" => "Applying profile",
// "Added (or modified)" => "Added (or modified)",
// "Preference set" => "Preference set",
// "Group changed (or modified)" => "Group changed (or modified)",
// "User %0 was added to %1" => "User %0 was added to %1",
// "Created by profile installer" => "Created by profile installer",
// "Page updated by profile installer" => "Page updated by profile installer",
// "No name" => "No name",
// "Bad object" => "Bad object",
// "uploaded the file" => "uploaded the file",
// "change" => "change",
// "changes" => "changes",
// "No changes" => "No changes",
// "Yesterday" => "Yesterday",
// "more changes of the same type.." => "more changes of the same type..",
// "changed the picture gallery" => "changed the picture gallery",
// "uploaded the picture" => "uploaded the picture",
// "onto" => "onto",
// "removed the picture" => "removed the picture",
// "edited the wikipage" => "edited the wikipage",
// "this history" => "this history",
// "all history" => "all history",
// "edited the file gallery" => "edited the file gallery",
// "removed the file" => "removed the file",
// "added the \".\$change['data']['objectType']).\" <a href=\"\$tikiUrl/\".\$change['data']['objectUrl'].\"\">\".\$change['data']['objectName'].\"</a> \".tra(\"to the category" => "added the \".\$change['data']['objectType']).\" <a href=\"\$tikiUrl/\".\$change['data']['objectUrl'].\"\">\".\$change['data']['objectName'].\"</a> \".tra(\"to the category",
// "removed the \".\$change['data']['objectType']).\" <a href=\"\$tikiUrl/\".\$change['data']['objectUrl'].\"\">\".\$change['data']['objectName'].\"</a> \".tra(\"from the category" => "removed the \".\$change['data']['objectType']).\" <a href=\"\$tikiUrl/\".\$change['data']['objectUrl'].\"\">\".\$change['data']['objectName'].\"</a> \".tra(\"from the category",
// "created the subcategory" => "created the subcategory",
// "removed the subcategory" => "removed the subcategory",
// "edited the category" => "edited the category",
// "removed the article" => "removed the article",
// "created the article" => "created the article",
// "edited the article" => "edited the article",
// "replied to the blog" => "replied to the blog",
// "created the topic" => "created the topic",
// "at forum" => "at forum",
// "replied" => "replied",
// "to the topic" => "to the topic",
// "Nothing has happened" => "Nothing has happened",
// "Wiki Comment" => "Wiki Comment",
// "Calendar item" => "Calendar item",
// "_HOMEPAGE_CONTENT_" => "_HOMEPAGE_CONTENT_",
// "You are not in group of friends to have the content of this block displayed for you" => "You are not in group of friends to have the content of this block displayed for you",
// "Smarty block.display.php: Missing error param" => "Smarty block.display.php: Missing error param",
// "<!-- jq smarty plugin inactive: feature_jquery off -->" => "<!-- jq smarty plugin inactive: feature_jquery off -->",
// "tip" => "tip",
// "comment" => "comment",
// "warning" => "warning",
// "note" => "note",
// "errors" => "errors",
// "information" => "information",
// "Tab View" => "Tab View",
// "No Tabs" => "No Tabs",
// "If you want the saved version instead of this autosaved one" => "If you want the saved version instead of this autosaved one",
// "AutoSave" => "AutoSave",
// "You must PREVIEW or SAVE your work now, to avoid losing your edits" => "You must PREVIEW or SAVE your work now, to avoid losing your edits",
// "Your edit session has expired" => "Your edit session has expired",
// "You are about to leave this page. Changes since your last save will be lost. Are you sure you want to exit this page" => "You are about to leave this page. Changes since your last save will be lost. Are you sure you want to exit this page",
// "character(s) too long - please edit it" => "character(s) too long - please edit it",
// "Preference name not specified" => "Preference name not specified",
// "Preference %0 is not defined" => "Preference %0 is not defined",
// "No rows found" => "No rows found",
// "{treetable}: Number of items in _checkboxColumnIndex doesn not match items in _checkbox" => "{treetable}: Number of items in _checkboxColumnIndex doesn not match items in _checkbox",
// "{treetable}: Number of items in _checkboxTitles doesn not match items in _checkbox" => "{treetable}: Number of items in _checkboxTitles doesn not match items in _checkbox",
// "Toggle sections" => "Toggle sections",
// "Text cut here" => "Text cut here",
// "Last seen on" => "Last seen on",
// "Yes" => "Yes",
// "Permission denied: the specified wiki page cannot be used as Smarty template resource" => "Permission denied: the specified wiki page cannot be used as Smarty template resource",
// "First day of week: Sunday (its ID is 0) - translators you need to localize this string" => "First day of week: Sunday (its ID is 0) - translators you need to localize this string",
// "You have to make %d choice(s) for the question" => "You have to make %d choice(s) for the question",
// "You have to make at least %d choice(s) for the question" => "You have to make at least %d choice(s) for the question",
// "You have to make less than %d choice(s) for the question" => "You have to make less than %d choice(s) for the question",
// "You have to choose at least %d choice(s) for the question" => "You have to choose at least %d choice(s) for the question",
// "Foo" => "Foo",
// "Sample plugin" => "Sample plugin",
// "Face" => "Face",
// "Font family to use" => "Font family to use",
// "As defined by CSS" => "As defined by CSS",
// "Page '%0' cannot be found" => "Page '%0' cannot be found",
// "Permission denied. You cannot view this section" => "Permission denied. You cannot view this section",
// "For the security of your password direct access to the feed is only available via https" => "For the security of your password direct access to the feed is only available via https",
// "Help link" => "Help link",
// "Edit Plugin" => "Edit Plugin",
// "smiling" => "smiling",
// "sad" => "sad",
// "grinning" => "grinning",
// "confused" => "confused",
// "cool" => "cool",
// "crying" => "crying",
// "frightened" => "frightened",
// "evil stuff" => "evil stuff",
// "exclamation mark " => "exclamation mark ",
// "frowning" => "frowning",
// "light bulb" => "light bulb",
// "idea " => "idea ",
// "LOL" => "LOL",
// "laughing out loud " => "laughing out loud ",
// "mad" => "mad",
// "mr. green laughing" => "mr. green laughing",
// "The file was uploaded with success" => "The file was uploaded with success",
// "No file was uploaded. Was a file selected " => "No file was uploaded. Was a file selected ",
// "A temporary folder is missing" => "A temporary folder is missing",
// "Unknown error" => "Unknown error",
// "Flash player not available" => "Flash player not available",
// "__WARNING__: Plugin disabled \$plugin" => "__WARNING__: Plugin disabled \$plugin",
// "__WARNING__: No such module \$plugin" => "__WARNING__: No such module \$plugin",
// "Sea Surfing (CSRF) detected. Operation blocked" => "Sea Surfing (CSRF) detected. Operation blocked",
// "Bold" => "Bold",
// "pics/icons/text_bold.png" => "pics/icons/text_bold.png",
// "Italic" => "Italic",
// "pics/icons/text_italic.png" => "pics/icons/text_italic.png",
// "Strikethrough" => "Strikethrough",
// "pics/icons/text_strikethrough.png" => "pics/icons/text_strikethrough.png",
// "Non-parsed" => "Non-parsed",
// "pics/icons/noparse.png" => "pics/icons/noparse.png",
// "Align Center" => "Align Center",
// "pics/icons/text_align_center.png" => "pics/icons/text_align_center.png",
// "Horizontal Bar" => "Horizontal Bar",
// "pics/icons/page.png" => "pics/icons/page.png",
// "Page Break" => "Page Break",
// "lib/fckeditor_tiki/fckeditor-icons/Pagebreak.gif" => "lib/fckeditor_tiki/fckeditor-icons/Pagebreak.gif",
// "Block Quote" => "Block Quote",
// "pics/icons/box.png" => "pics/icons/box.png",
// "pics/icons/book.png" => "pics/icons/book.png",
// "Unordered List" => "Unordered List",
// "pics/icons/text_list_bullets.png" => "pics/icons/text_list_bullets.png",
// "Ordered List" => "Ordered List",
// "pics/icons/text_list_numbers.png" => "pics/icons/text_list_numbers.png",
// "Special Characters" => "Special Characters",
// "lib/fckeditor_tiki/fckeditor-icons/Specialchar.gif" => "lib/fckeditor_tiki/fckeditor-icons/Specialchar.gif",
// "img/smiles/icon_smile.gif" => "img/smiles/icon_smile.gif",
// "Foreground color" => "Foreground color",
// "pics/icons/palette.png" => "pics/icons/palette.png",
// "Background Color" => "Background Color",
// "pics/icons/palette_bg.png" => "pics/icons/palette_bg.png",
// "Wiki Link" => "Wiki Link",
// "pics/icons/page_link.png" => "pics/icons/page_link.png",
// "External Link" => "External Link",
// "pics/icons/world_link.png" => "pics/icons/world_link.png",
// "pics/icons/table.png" => "pics/icons/table.png",
// "Table Builder" => "Table Builder",
// "pics/icons/find.png" => "pics/icons/find.png",
// "Find Text" => "Find Text",
// "pics/icons/text_replace.png" => "pics/icons/text_replace.png",
// "Text Replace" => "Text Replace",
// "Full Screen Edit" => "Full Screen Edit",
// "pics/icons/arrow_in.png" => "pics/icons/arrow_in.png",
// "pics/icons/arrow_out.png" => "pics/icons/arrow_out.png",
// "Choose or upload images" => "Choose or upload images",
// "pics/icons/pictures.png" => "pics/icons/pictures.png",
// "Switch Editor (wiki or WYSIWYG)" => "Switch Editor (wiki or WYSIWYG)",
// "pics/icons/pencil_go.png" => "pics/icons/pencil_go.png",
// "Admin Toolbars" => "Admin Toolbars",
// "View the tracker item at" => "View the tracker item at",
// "prepend" => "prepend",
// "append" => "append",
// "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a one-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append,max,autocomplete</strong>\n\t\t\t\t<dt>Example: 0,80,\$,,80\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible length of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[autocomplete]</strong> if y autocomplete while typing;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a one-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append,max,autocomplete</strong>\n\t\t\t\t<dt>Example: 0,80,\$,,80\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible length of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[autocomplete]</strong> if y autocomplete while typing;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a multi-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>toolbars,width,height,max,listmax,wordmax</strong>\n\t\t\t\t<dt>Example: 0,80,5,30,200\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[toolbars]</strong> enables toolbars if a 1 is specified;\n\t\t\t\t<dd><strong>[width]</strong> is the width of the box, in chars;\n\t\t\t\t<dd><strong>[height]</strong> is the number of visible lines in the box;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[listmax]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd><strong>[wordmax]</strong> will alert if word count exceeded with a positive number (1+) or display a word count with a negative number (-1);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a multi-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>toolbars,width,height,max,listmax,wordmax</strong>\n\t\t\t\t<dt>Example: 0,80,5,30,200\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[toolbars]</strong> enables toolbars if a 1 is specified;\n\t\t\t\t<dd><strong>[width]</strong> is the width of the box, in chars;\n\t\t\t\t<dd><strong>[height]</strong> is the number of visible lines in the box;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[listmax]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd><strong>[wordmax]</strong> will alert if word count exceeded with a positive number (1+) or display a word count with a negative number (-1);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a checkbox field for yes/no, on/off input.\n\t\t\t\t<dt>Usage: <strong>samerow</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field on the same row if a 1 is specified.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a checkbox field for yes/no, on/off input.\n\t\t\t\t<dt>Usage: <strong>samerow</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field on the same row if a 1 is specified.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a one-line field for numeric input only.  Prepend or append values may be alphanumeric.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append</strong>\n\t\t\t\t<dt>Example: 0,60,,hours\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible size of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a one-line field for numeric input only.  Prepend or append values may be alphanumeric.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append</strong>\n\t\t\t\t<dt>Example: 0,60,,hours\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible size of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to select only from a specified set of options in a drop-down bar.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to select only from a specified set of options in a drop-down bar.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>",
// "drop down with other textfield" => "drop down with other textfield",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to select from a specified set of options in a drop-down bar, or provide an alternate selection in a one-line text field.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to select from a specified set of options in a drop-down bar, or provide an alternate selection in a one-line text field.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>",
// "radio buttons" => "radio buttons",
// "<dl>\n\t\t\t\t<dt>Function: Provides a multiple-choice-style set of options from which a user may only choose one.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list of items]</strong> is the list of all values you want in the set, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear as the one selected.\n\t\t\t\t<dd>If first option is &lt;br&gt;, options will be separated with a carriaage return\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a multiple-choice-style set of options from which a user may only choose one.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list of items]</strong> is the list of all values you want in the set, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear as the one selected.\n\t\t\t\t<dd>If first option is &lt;br&gt;, options will be separated with a carriaage return\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usernames.\n\t\t\t\t<dt>Usage: <strong>auto-assign,email_notify</strong>\n\t\t\t\t<dt>Example: 1,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1, or will set the selection to the user who last modified the item if set to 2, or will give the choice between all the users for other values;\n\t\t\t\t<dd><strong>[email_notify]</strong> will send an email to the assigned user when the item is saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usernames.\n\t\t\t\t<dt>Usage: <strong>auto-assign,email_notify</strong>\n\t\t\t\t<dt>Example: 1,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1, or will set the selection to the user who last modified the item if set to 2, or will give the choice between all the users for other values;\n\t\t\t\t<dd><strong>[email_notify]</strong> will send an email to the assigned user when the item is saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usergroups.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the field to the usergroup of the creator if set to 1, or will set the selection to the group of the user who last modified the item if set to 2, or will give the choice between all the groups for other values;\n\t\t\t\t<dd>if the user does not have a default group set, the first group the user belongs to will be chosen, otherwise Registered group will be used.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usergroups.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the field to the usergroup of the creator if set to 1, or will set the selection to the group of the user who last modified the item if set to 2, or will give the choice between all the groups for other values;\n\t\t\t\t<dd>if the user does not have a default group set, the first group the user belongs to will be chosen, otherwise Registered group will be used.\n\t\t\t\t</dl>",
// "IP selector" => "IP selector",
// "<dl>\n\t\t\t\t<dt>Function: Provides a field for entering an IP address.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-populate the field with the IP address of the user who created the item if set to 1, or will set the field to the IP of the user who last modified the item if set to 2, or will be a free IP for other values.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a field for entering an IP address.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-populate the field with the IP address of the user who created the item if set to 1, or will set the field to the IP of the user who last modified the item if set to 2, or will be a free IP for other values.\n\t\t\t\t</dl>",
// "page selector" => "page selector",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from the list of pages.\n\t\t\t\t<dt>Usage: <strong>auto-assign, size, create</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1\n\t\t\t\t<dd><strong>[size]</strong> is the visible input length of the field in characters (<=0 not limited);\n\t\t\t\t<dd><strong>[create]</strong>: will create the page if not exits copy of the page with name value of this param.which pagename is the value of this param\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from the list of pages.\n\t\t\t\t<dt>Usage: <strong>auto-assign, size, create</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1\n\t\t\t\t<dd><strong>[size]</strong> is the visible input length of the field in characters (<=0 not limited);\n\t\t\t\t<dd><strong>[create]</strong>: will create the page if not exits copy of the page with name value of this param.which pagename is the value of this param\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of countries.\n\t\t\t\t<dt>Usage: <strong>name_flag,sort</strong>\n\t\t\t\t<dt>Example: 1,0\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[name_flag]</strong> default is 0 and will display both the country name and its flag, 1 will display only the country name, while 2 will show only the country flag;\n\t\t\t\t<dd><strong>[sortorder]</strong> specifies the order the country list should be displayed in, where 0 is the default and sorts according to the translated name, and 1 sorts according to the english name;\n\t\t\t\t<dd>if the country names are translated and option 1 is selected for the sort order, the countries will still appear translated, but will merely be in english order.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of countries.\n\t\t\t\t<dt>Usage: <strong>name_flag,sort</strong>\n\t\t\t\t<dt>Example: 1,0\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[name_flag]</strong> default is 0 and will display both the country name and its flag, 1 will display only the country name, while 2 will show only the country flag;\n\t\t\t\t<dd><strong>[sortorder]</strong> specifies the order the country list should be displayed in, where 0 is the default and sorts according to the translated name, and 1 sorts according to the english name;\n\t\t\t\t<dd>if the country names are translated and option 1 is selected for the sort order, the countries will still appear translated, but will merely be in english order.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides drop-down options to accurately select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime,startyear,endyear,blankdate</strong>\n\t\t\t\t<dt>Example: d,2000,,blank\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\";\n\t\t\t\t<dd><strong>[startyear]</strong> allows you to specify a custom first year in the date range (eg. 1987), default is current year;\n\t\t\t\t<dd><strong>[endyear]</strong> allows you to specify a custom end year in the date range (eg. 2020), default is 4 years from now;\n\t\t\t\t<dd><strong>[blankdate]</strong> when set to \"blank\" will default the initial date field to an empty date, and allow selection of empty dates;\n\t\t\t\t<dd>blankdate is overridden if the field isMandatory;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dt>Example: \"d,2000,2009,blank\"\n\t\t\t\t<dd>sets a date only field from 2000 through 2009, allowing blank dates.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides drop-down options to accurately select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime,startyear,endyear,blankdate</strong>\n\t\t\t\t<dt>Example: d,2000,,blank\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\";\n\t\t\t\t<dd><strong>[startyear]</strong> allows you to specify a custom first year in the date range (eg. 1987), default is current year;\n\t\t\t\t<dd><strong>[endyear]</strong> allows you to specify a custom end year in the date range (eg. 2020), default is 4 years from now;\n\t\t\t\t<dd><strong>[blankdate]</strong> when set to \"blank\" will default the initial date field to an empty date, and allow selection of empty dates;\n\t\t\t\t<dd>blankdate is overridden if the field isMandatory;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dt>Example: \"d,2000,2009,blank\"\n\t\t\t\t<dd>sets a date only field from 2000 through 2009, allowing blank dates.\n\t\t\t\t</dl>",
// "jscalendar" => "jscalendar",
// "<dl>\n\t\t\t\t<dt>Function: Provides a javascript graphical date selector to select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime</strong>\n\t\t\t\t<dt>Example: dt\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\".\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a javascript graphical date selector to select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime</strong>\n\t\t\t\t<dt>Example: dt\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\".\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows user to upload an image into the tracker item.\n\t\t\t\t<dt>Usage: <strong>xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale,shadowBox</strong>\n\t\t\t\t<dt>Example: 30,30,100,100,1000,item\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[xListSize]</strong> sets the pixel width of the image in the list view;\n\t\t\t\t<dd><strong>[yListSize]</strong> sets the pixel height of the image in the list view;\n\t\t\t\t<dd><strong>[xDetailSize]</strong> sets the pixel width of the image in the item view;\n\t\t\t\t<dd><strong>[yDetailSize]</strong> sets the pixel height of the image in the item view;\n\t\t\t\t<dd><strong>[uploadLimitScale]</strong> sets the maximum total size of the image, in pixels (width or height);\n\t\t\t\t<dd><strong>[shadowbox]</strong> actives a shadowbox(if feature on) = \\'item\\': to use the same shadowbox for an item, =\\'individual\\': to use a shadowbox only for this image, other value= to set the group of images of the shadowbox ;\n\t\t\t\t<dd>images are stored in img/trackers;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows user to upload an image into the tracker item.\n\t\t\t\t<dt>Usage: <strong>xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale,shadowBox</strong>\n\t\t\t\t<dt>Example: 30,30,100,100,1000,item\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[xListSize]</strong> sets the pixel width of the image in the list view;\n\t\t\t\t<dd><strong>[yListSize]</strong> sets the pixel height of the image in the list view;\n\t\t\t\t<dd><strong>[xDetailSize]</strong> sets the pixel width of the image in the item view;\n\t\t\t\t<dd><strong>[yDetailSize]</strong> sets the pixel height of the image in the item view;\n\t\t\t\t<dd><strong>[uploadLimitScale]</strong> sets the maximum total size of the image, in pixels (width or height);\n\t\t\t\t<dd><strong>[shadowbox]</strong> actives a shadowbox(if feature on) = \\'item\\': to use the same shadowbox for an item, =\\'individual\\': to use a shadowbox only for this image, other value= to set the group of images of the shadowbox ;\n\t\t\t\t<dd>images are stored in img/trackers;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: ?\n\t\t\t\t<dt>Usage: <strong>label,post,tiki-index.php,page:fieldname,highlight=test</strong>\n\t\t\t\t<dt>Example:\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[label]</strong> needs explanation;\n\t\t\t\t<dd><strong>[post]</strong> needs explanation;\n\t\t\t\t<dd><strong>[tiki-index.php]</strong> needs explanation;\n\t\t\t\t<dd><strong>[page:fieldname]</strong> needs explanation;\n\t\t\t\t<dd><strong>[highlight=test]</strong> needs explanation;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: ?\n\t\t\t\t<dt>Usage: <strong>label,post,tiki-index.php,page:fieldname,highlight=test</strong>\n\t\t\t\t<dt>Example:\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[label]</strong> needs explanation;\n\t\t\t\t<dd><strong>[post]</strong> needs explanation;\n\t\t\t\t<dd><strong>[tiki-index.php]</strong> needs explanation;\n\t\t\t\t<dd><strong>[page:fieldname]</strong> needs explanation;\n\t\t\t\t<dd><strong>[highlight=test]</strong> needs explanation;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: will display trhe field name as a html header h2;\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: will display trhe field name as a html header h2;\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows insertion of a static block of text into a tracker to augment input fields. (non-editable)\n\t\t\t\t<dt>Usage: <strong>wikiparse,max</strong>\n\t\t\t\t<dt>Example: 1,20\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[wikiparse]</strong> will allow wiki syntax to be parsed if set to 1, otherwise default is 0 to only support line-breaks;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows insertion of a static block of text into a tracker to augment input fields. (non-editable)\n\t\t\t\t<dt>Usage: <strong>wikiparse,max</strong>\n\t\t\t\t<dt>Example: 1,20\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[wikiparse]</strong> will allow wiki syntax to be parsed if set to 1, otherwise default is 0 to only support line-breaks;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows one or more categories under a main category to be assigned to the tracker item.\n\t\t\t\t<dt>Usage: <strong>parentId,inputtype,selectall</strong>\n\t\t\t\t<dt>Example: 12,radio,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[parentId]</strong> is the ID of the main category, categories in the list will be children of this;\n\t\t\t\t<dd><strong>[inputtype]</strong> is one of [d|m|radio|checkbox], where d is a drop-down list, m is a multiple-selection drop-down list, radio and checkbox are self-explanatory;\n\t\t\t\t<dd><strong>[selectall]</strong> will provide a checkbox to automatically select all categories in the list if set to 1, default is 0;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows one or more categories under a main category to be assigned to the tracker item.\n\t\t\t\t<dt>Usage: <strong>parentId,inputtype,selectall</strong>\n\t\t\t\t<dt>Example: 12,radio,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[parentId]</strong> is the ID of the main category, categories in the list will be children of this;\n\t\t\t\t<dd><strong>[inputtype]</strong> is one of [d|m|radio|checkbox], where d is a drop-down list, m is a multiple-selection drop-down list, radio and checkbox are self-explanatory;\n\t\t\t\t<dd><strong>[selectall]</strong> will provide a checkbox to automatically select all categories in the list if set to 1, default is 0;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "item link" => "item link",
// "<dl>\n\t\t\t\t<dt>Function: Provides a way to choose a value from another tracker (eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldId,linkToItem,displayedFieldsList</strong>\n\t\t\t\t<dt>Example: 3,5,1,6|8\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldId]</strong> is the field in [trackerId] from which you can select a value among all the field values of the items of [trackerId];\n\t\t\t\t<dd><strong>[linkToItem]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to the item in the other tracker;\n\t\t\t\t<dd><strong>[displayedFieldsList]</strong> is a list of fields in [trackerId] to display instead of [fieldId], multiple fields can be separated with a |;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a way to choose a value from another tracker (eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldId,linkToItem,displayedFieldsList</strong>\n\t\t\t\t<dt>Example: 3,5,1,6|8\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldId]</strong> is the field in [trackerId] from which you can select a value among all the field values of the items of [trackerId];\n\t\t\t\t<dd><strong>[linkToItem]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to the item in the other tracker;\n\t\t\t\t<dd><strong>[displayedFieldsList]</strong> is a list of fields in [trackerId] to display instead of [fieldId], multiple fields can be separated with a |;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "items list" => "items list",
// "<dl>\n\t\t\t\t<dt>Function: Displays a list of field values from another tracker that has a relation with this tracker(eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldIdThere,fieldIdHere,displayFieldIdThere,linkToItems</strong>\n\t\t\t\t<dt>Example: 5,3,4,10|11\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldIdThere]</strong> is the field (multiple fields can be separated with a \":\") you want to link with;\n\t\t\t\t<dd><strong>[fieldIdHere]</strong> is the field in this tracker you want to link with;\n\t\t\t\t<dd><strong>[displayFieldIdThere]</strong> the field(s) in [trackerId] you want to display, multiple fields can be separated by \"|\";\n\t\t\t\t<dd><strong>[linkToItems]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to that values item in the other tracker;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Displays a list of field values from another tracker that has a relation with this tracker(eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldIdThere,fieldIdHere,displayFieldIdThere,linkToItems</strong>\n\t\t\t\t<dt>Example: 5,3,4,10|11\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldIdThere]</strong> is the field (multiple fields can be separated with a \":\") you want to link with;\n\t\t\t\t<dd><strong>[fieldIdHere]</strong> is the field in this tracker you want to link with;\n\t\t\t\t<dd><strong>[displayFieldIdThere]</strong> the field(s) in [trackerId] you want to display, multiple fields can be separated by \"|\";\n\t\t\t\t<dd><strong>[linkToItems]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to that values item in the other tracker;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "dynamic items list" => "dynamic items list",
// "<dl>\n\t\t\t\t<dt>Function: Dynamically updates a selection list based on linked data from another tracker.\n\t\t\t\t<dt>Usage: <strong>trackerId,filterFieldIdThere,filterFieldIdHere,listFieldIdThere,statusThere</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the ID of the tracker to link with;\n\t\t\t\t<dd><strong>[filterFieldIdThere]</strong> is the field you want to link with in that tracker;\n\t\t\t\t<dd><strong>[filterFieldIdHere]</strong> is the field you want to link with in the current tracker;\n\t\t\t\t<dd><strong>[listFieldIdThere]</strong> is the field ID you wish to pull the selection list from, based on the value selected in fiterFieldIdHere matching field(s) in filterFieldIdThere;\n\t\t\t\t<dd><strong>[statusThere]</strong> restricts values appearing in the list to those coming from records in the other tracker that meet specified statuses of [o|p|c] or in combination (op, opc);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Dynamically updates a selection list based on linked data from another tracker.\n\t\t\t\t<dt>Usage: <strong>trackerId,filterFieldIdThere,filterFieldIdHere,listFieldIdThere,statusThere</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the ID of the tracker to link with;\n\t\t\t\t<dd><strong>[filterFieldIdThere]</strong> is the field you want to link with in that tracker;\n\t\t\t\t<dd><strong>[filterFieldIdHere]</strong> is the field you want to link with in the current tracker;\n\t\t\t\t<dd><strong>[listFieldIdThere]</strong> is the field ID you wish to pull the selection list from, based on the value selected in fiterFieldIdHere matching field(s) in filterFieldIdThere;\n\t\t\t\t<dd><strong>[statusThere]</strong> restricts values appearing in the list to those coming from records in the other tracker that meet specified statuses of [o|p|c] or in combination (op, opc);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an email address with option of making it active.\n\t\t\t\t<dt>Usage: <strong>link,watchopen,watchpending,watchclosed</strong>\n\t\t\t\t<dt>Example: 0,o\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[link]</strong> may be one of [0|1|2] and specifies how to display the email address, defaulting to 0 as plain text, 1 as an encoded hex mailto link, or 2 as a standard mailto link;\n\t\t\t\t<dd><strong>[watchopen]</strong> if set to \"o\" will email the address every time the status of the item changes to open;\n\t\t\t\t<dd><strong>[watchpending]</strong> if set to \"p\" will email the address every time the status of the item changes to pending;\n\t\t\t\t<dd><strong>[watchclosed]</strong> if set to \"c\" will email the address every time the status of the item changes to closed;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an email address with option of making it active.\n\t\t\t\t<dt>Usage: <strong>link,watchopen,watchpending,watchclosed</strong>\n\t\t\t\t<dt>Example: 0,o\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[link]</strong> may be one of [0|1|2] and specifies how to display the email address, defaulting to 0 as plain text, 1 as an encoded hex mailto link, or 2 as a standard mailto link;\n\t\t\t\t<dd><strong>[watchopen]</strong> if set to \"o\" will email the address every time the status of the item changes to open;\n\t\t\t\t<dd><strong>[watchpending]</strong> if set to \"p\" will email the address every time the status of the item changes to pending;\n\t\t\t\t<dd><strong>[watchclosed]</strong> if set to \"c\" will email the address every time the status of the item changes to closed;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "url" => "url",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an url in a wiki syntax.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an url in a wiki syntax.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Will play MP3 or FLV files, as specified, in a player.\n\t\t\t\t<dt>Usage: <strong>source,xSize,ySize</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[source]</strong> is one of [0|1|2|3|4|5] where 0 is default and will support a URL in the file gallery for MP3, 1 for URL in file gallery for FLV, 2 for URL in file gallery of either MP3 or FLV, 3 to upload an MP3 file to be played, 4 to upload an FLV file to be played, 5 to upload either an MP3 or FLV file;\n\t\t\t\t<dd><strong>[xSize]</strong> is the width in pixels of the player applet (default 200);\n\t\t\t\t<dd><strong>[ySize]</strong> is the height in pixels of the player applet (default 100);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dd>this is best-used as a tracker item that is not generally editable and you want a specific file played;\n\t\t\t\t\tedit the tracker item and provide the URL for the file you wish to play.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Will play MP3 or FLV files, as specified, in a player.\n\t\t\t\t<dt>Usage: <strong>source,xSize,ySize</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[source]</strong> is one of [0|1|2|3|4|5] where 0 is default and will support a URL in the file gallery for MP3, 1 for URL in file gallery for FLV, 2 for URL in file gallery of either MP3 or FLV, 3 to upload an MP3 file to be played, 4 to upload an FLV file to be played, 5 to upload either an MP3 or FLV file;\n\t\t\t\t<dd><strong>[xSize]</strong> is the width in pixels of the player applet (default 200);\n\t\t\t\t<dd><strong>[ySize]</strong> is the height in pixels of the player applet (default 100);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dd>this is best-used as a tracker item that is not generally editable and you want a specific file played;\n\t\t\t\t\tedit the tracker item and provide the URL for the file you wish to play.\n\t\t\t\t</dl>",
// "auto-increment" => "auto-increment",
// "<dl>\n\t\t\t\t<dt>Function: Allows an incrementing value field, or itemId field. (non-editable)\n\t\t\t\t<dt>Usage: <strong>start,prepend,append,itemId</strong>\n\t\t\t\t<dt>Example: 1,,,itemId\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[start]</strong> is the starting value for the field, defaults to 1;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed after the field;\n\t\t\t\t<dd><strong>[itemId]</strong> if set to \"itemId\" will set this field to match the value of the actual database itemId field value;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows an incrementing value field, or itemId field. (non-editable)\n\t\t\t\t<dt>Usage: <strong>start,prepend,append,itemId</strong>\n\t\t\t\t<dt>Example: 1,,,itemId\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[start]</strong> is the starting value for the field, defaults to 1;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed after the field;\n\t\t\t\t<dd><strong>[itemId]</strong> if set to \"itemId\" will set this field to match the value of the actual database itemId field value;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allow registered users to subscribe themselves to a tracker item (think Evite.com).\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Use this field as you would to have people sign up for an event. It is best if the tracker is only editable by its creator or the admin.  To set the max number of subscribers, edit the tracker item and put the number at the beginning of the field.\n\t\t\t\t<dt>Example:\n\t\t\t\t<dd>Old field may have \"#\" or \"#2[0]\" in it.  Making it \"20#2[0]\" will set the max number to 20.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allow registered users to subscribe themselves to a tracker item (think Evite.com).\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Use this field as you would to have people sign up for an event. It is best if the tracker is only editable by its creator or the admin.  To set the max number of subscribers, edit the tracker item and put the number at the beginning of the field.\n\t\t\t\t<dt>Example:\n\t\t\t\t<dd>Old field may have \"#\" or \"#2[0]\" in it.  Making it \"20#2[0]\" will set the max number to 20.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Use Google Maps.\n\t\t\t\t<dt>Will display a Google Maps around a point.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Use Google Maps.\n\t\t\t\t<dt>Will display a Google Maps around a point.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: System only.\n\t\t\t\t<dt>Usage: None\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Needs a description.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: System only.\n\t\t\t\t<dt>Usage: None\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Needs a description.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a computed value based on numeric field values.\n\t\t\t\t<dt>Usage: <strong>formula</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[formula]</strong> is the formula you wish to compute, using numeric values, operators \"+ - * / ( )\", and tracker fields identified with a leading #;\n\t\t\t\t<dt>Example: \"#3*(#4+5)\"\n\t\t\t\t<dd>adds the numeric value in item 4 by 5, and multiplies it by the numeric value in item 3.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a computed value based on numeric field values.\n\t\t\t\t<dt>Usage: <strong>formula</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[formula]</strong> is the formula you wish to compute, using numeric values, operators \"+ - * / ( )\", and tracker fields identified with a leading #;\n\t\t\t\t<dt>Example: \"#3*(#4+5)\"\n\t\t\t\t<dd>adds the numeric value in item 4 by 5, and multiplies it by the numeric value in item 3.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows user preference changes from a tracker.\n\t\t\t\t<dt>Usage: <strong>type</strong>\n\t\t\t\t<dt>Example: password\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[type]</strong> if value is password, will allow to change the user password, if value is email, will display/allow to change the user email;\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows user preference changes from a tracker.\n\t\t\t\t<dt>Usage: <strong>type</strong>\n\t\t\t\t<dt>Example: password\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[type]</strong> if value is password, will allow to change the user password, if value is email, will display/allow to change the user email;\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a file to be attached to the tracker item.\n\t\t\t\t<dt>Usage: <strong>listview</strong>\n\t\t\t\t<dt>Example: nu\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[listview]</strong> may be one of [n|t|s|u|m] on their own or in any combination (n, t, ns, nts), allowing you to see the attachment in the item list view as its name (n), its type (t), its size (n), the username of the uploader (u), or the mediaplayer plugin(m);\n\t\t\t\tnote that this option will cost an extra query to the database for each attachment and can severely impact performance with several attachments.\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a file to be attached to the tracker item.\n\t\t\t\t<dt>Usage: <strong>listview</strong>\n\t\t\t\t<dt>Example: nu\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[listview]</strong> may be one of [n|t|s|u|m] on their own or in any combination (n, t, ns, nts), allowing you to see the attachment in the item list view as its name (n), its type (t), its size (n), the username of the uploader (u), or the mediaplayer plugin(m);\n\t\t\t\tnote that this option will cost an extra query to the database for each attachment and can severely impact performance with several attachments.\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "in group" => "in group",
// "<dl>\n\t\t\t\t<dt>Function: Allows to display if a item user is in a group and when he was assigned to the group (needs a user selector field)\n\t\t\t\t<dt>Usage: <strong>groupName,date</strong>\n\t\t\t\t<dt>Example: Members,date\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>GroupName</strong> Group to test. <strong>date</strong> displays the date the user was assigned in the group (if known), otherwise will display yes/no.\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows to display if a item user is in a group and when he was assigned to the group (needs a user selector field)\n\t\t\t\t<dt>Usage: <strong>groupName,date</strong>\n\t\t\t\t<dt>Example: Members,date\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>GroupName</strong> Group to test. <strong>date</strong> displays the date the user was assigned in the group (if known), otherwise will display yes/no.\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "Mailbox uninitialised??" => "Mailbox uninitialised??",
// "No mail body found" => "No mail body found",
// "User-Agent Info" => "User-Agent Info",
// "Displays various information about the client" => "Displays various information about the client",
// "Info" => "Info",
// "Info required - IP|SVRSW|BROWSER" => "Info required - IP|SVRSW|BROWSER",
// "Anchor Link" => "Anchor Link",
// "Creates a link to an anchor within a page. Anchors can be created using the ANAME plugin" => "Creates a link to an anchor within a page. Anchors can be created using the ANAME plugin",
// "Anchor link label" => "Anchor link label",
// "The anchor name as defined in the ANAME plugin" => "The anchor name as defined in the ANAME plugin",
// "The name of the wiki page containing the anchor" => "The name of the wiki page containing the anchor",
// "Creates a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which specifies the location and name of the anchor" => "Creates a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which specifies the location and name of the anchor",
// "Anchor Name" => "Anchor Name",
// "Inserts an anchor in the wiki page. Anchors can be linked to using the ALINK plugin" => "Inserts an anchor in the wiki page. Anchors can be linked to using the ALINK plugin",
// "The name of the anchor" => "The name of the anchor",
// "Creates an anchor in a wiki page. Use in conjunction with the ALINK plugin, which specifies a link to the anchor" => "Creates an anchor in a wiki page. Use in conjunction with the ALINK plugin, which specifies a link to the anchor",
// "Image Annotation" => "Image Annotation",
// "Autogenerated content. Leave blank initially" => "Autogenerated content. Leave blank initially",
// "Absolute URL to the image or relative path from tikiwiki root" => "Absolute URL to the image or relative path from tikiwiki root",
// "Width" => "Width",
// "Image width" => "Image width",
// "Height" => "Height",
// "Image height" => "Image height",
// "Alignment" => "Alignment",
// "Image alignment. Possible values: left, right, center" => "Image alignment. Possible values: left, right, center",
// "Image annotations changed" => "Image annotations changed",
// "Displays an image and enables users to define zones to highlight information on the image" => "Displays an image and enables users to define zones to highlight information on the image",
// "Includes an article\\'s content within the page" => "Includes an article\\'s content within the page",
// "The article field to display. Default field is Heading" => "The article field to display. Default field is Heading",
// "Article ID" => "Article ID",
// "The article to display. If no value is provided, most recent article will be used" => "The article to display. If no value is provided, most recent article will be used",
// "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~" => "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~",
// "Id is optional. If not given, last article is used. Default field is heading" => "Id is optional. If not given, last article is used. Default field is heading",
// "Article List" => "Article List",
// "Inserts a list of articles in the page" => "Inserts a list of articles in the page",
// "Articles displayed" => "Articles displayed",
// "The number of articles to display in the list" => "The number of articles to display in the list",
// "Topics expression" => "Topics expression",
// "Topic ID expression" => "Topic ID expression",
// "Type expression" => "Type expression",
// "Category ID" => "Category ID",
// "The ID of the category to list from" => "The ID of the category to list from",
// "The article language to list" => "The article language to list",
// "Sort order" => "Sort order",
// "The column and order of the sort in columnName_asc or columnName_desc format. Defaults to \"publishDate_desc\" (other column examples are \"title\", \"lang\", \"authorName\" & \"topicName\")" => "The column and order of the sort in columnName_asc or columnName_desc format. Defaults to \"publishDate_desc\" (other column examples are \"title\", \"lang\", \"authorName\" & \"topicName\")",
// "Quiet" => "Quiet",
// "Whether to not report when there are no articles" => "Whether to not report when there are no articles",
// "Title only" => "Title only",
// "Whether to only show the title of the articles" => "Whether to only show the title of the articles",
// "Show body" => "Show body",
// "Whether to only show the body of the articles or just the heading" => "Whether to only show the body of the articles or just the heading",
// "Starting article" => "Starting article",
// "The article number that the list should start with" => "The article number that the list should start with",
// "Start date" => "Start date",
// "Earliest date to select articles from" => "Earliest date to select articles from",
// "End date" => "End date",
// "Latest date to select articles from" => "Latest date to select articles from",
// "Override Dates" => "Override Dates",
// "Whether obey article type\\'s \"show before publish\" and \"show after expiry\" settings" => "Whether obey article type\\'s \"show before publish\" and \"show after expiry\" settings",
// "Container class" => "Container class",
// "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_articles\")" => "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_articles\")",
// "Includes articles listing into a wiki page" => "Includes articles listing into a wiki page",
// "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc), quiet=>y|n, titleonly=>y|n}{ARTICLES}~/np~" => "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc), quiet=>y|n, titleonly=>y|n}{ARTICLES}~/np~",
// "Bullets" => "Bullets",
// "Inline" => "Inline",
// "Number" => "Number",
// "Show icon" => "Show icon",
// "No such attachment on this page" => "No such attachment on this page",
// "Displays an attachment or a list of them" => "Displays an attachment or a list of them",
// "Gives the name of the attached file to link to" => "Gives the name of the attached file to link to",
// "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages" => "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages",
// "Shows the description as the link text instead of the file name" => "Shows the description as the link text instead of the file name",
// "Makes the list of attachments a bulleted list" => "Makes the list of attachments a bulleted list",
// "Says that this file is an image, and should be displayed inline using the img tag" => "Says that this file is an image, and should be displayed inline using the img tag",
// "Makes the text between the {ATTACH} tags the link text instead of the file name or description" => "Makes the text between the {ATTACH} tags the link text instead of the file name or description",
// "Shows all attachments from the whole wiki" => "Shows all attachments from the whole wiki",
// "Gives the number, in the list of attachments, of the attachment to link to" => "Gives the number, in the list of attachments, of the attachment to link to",
// "Gives the actual id of the attachment to link in. You probably should never use this" => "Gives the actual id of the attachment to link in. You probably should never use this",
// "Puts the number of downloads in the alt comment" => "Puts the number of downloads in the alt comment",
// "The wiki page the avatar will link to" => "The wiki page the avatar will link to",
// "Float" => "Float",
// "left|right" => "left|right",
// "Displays a link that allows to go back in the browser history" => "Displays a link that allows to go back in the browser history",
// "Insert back link on wiki page" => "Insert back link on wiki page",
// "List all pages linking to the specified page" => "List all pages linking to the specified page",
// "The page links will point to. Default value is the current page" => "The page links will point to. Default value is the current page",
// "Displayed information" => "Displayed information",
// "Pipe separated list of fields to display. ex: hits|user" => "Pipe separated list of fields to display. ex: hits|user",
// "Excluded pages" => "Excluded pages",
// "Pipe separated list of pages to be excluded from the listing. ex: HomePage|Sandbox" => "Pipe separated list of pages to be excluded from the listing. ex: HomePage|Sandbox",
// "Include Self" => "Include Self",
// "1|0" => "1|0",
// "No Header" => "No Header",
// "List all pages that link to specific pages" => "List all pages that link to specific pages",
// "Banner" => "Banner",
// "Insert a banner" => "Insert a banner",
// "Zone" => "Zone",
// "Target" => "Target",
// "missing parameter" => "missing parameter",
// "Blog List" => "Blog List",
// "Use BLOGLIST to include posts from a blog" => "Use BLOGLIST to include posts from a blog",
// "Blog ID" => "Blog ID",
// "Numeric value" => "Numeric value",
// "Items" => "Items",
// "Maximum number of entries to list" => "Maximum number of entries to list",
// "Simple list" => "Simple list",
// "Show simple list of date, title and author (default=y) or formatted list of blog posts (n)" => "Show simple list of date, title and author (default=y) or formatted list of blog posts (n)",
// "Earliest date to select posts from" => "Earliest date to select posts from",
// "Latest date to select posts from" => "Latest date to select posts from",
// "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_bloglist\")" => "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_bloglist\")",
// "where Id is the blog Id and Items is the max number of posts to display" => "where Id is the blog Id and Items is the max number of posts to display",
// "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~" => "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~",
// "Box" => "Box",
// "Insert theme-styled box on wiki page" => "Insert theme-styled box on wiki page",
// "Box title" => "Box title",
// "Displayed above the content" => "Displayed above the content",
// "Background color" => "Background color",
// "As defined by CSS, name or Hex code" => "As defined by CSS, name or Hex code",
// "Box width" => "Box width",
// "In pixels or percentage. Default value is 100%" => "In pixels or percentage. Default value is 100%",
// "Text Alignment" => "Text Alignment",
// "Float Position" => "Float Position",
// "for box with width less than 100%, make text wrap around the box" => "for box with width less than 100%, make text wrap around the box",
// "CSS Class" => "CSS Class",
// "Apply custom CSS class to the box" => "Apply custom CSS class to the box",
// "Includes a calendar and/or a list of calendar events" => "Includes a calendar and/or a list of calendar events",
// "Calendar filter" => "Calendar filter",
// "If set to a calendar identifier, restricts the events displayed to those in the specified calendar" => "If set to a calendar identifier, restricts the events displayed to those in the specified calendar",
// "View type" => "View type",
// "Determines how to show events" => "Determines how to show events",
// "Possible values" => "Possible values",
// "\"table\" shows events in a calendar" => "\"table\" shows events in a calendar",
// "Default value" => "Default value",
// "Calendar view type time span" => "Calendar view type time span",
// "If in calendar (or \"table\") view type, determines the time span displayed by the calendar" => "If in calendar (or \"table\") view type, determines the time span displayed by the calendar",
// "View the navigation bar" => "View the navigation bar",
// "Decide or not to show the navigation bar" => "Decide or not to show the navigation bar",
// "Includes a calendar" => "Includes a calendar",
// "~np~{CALENDAR(calendarId=>1)}{CALENDAR}" => "~np~{CALENDAR(calendarId=>1)}{CALENDAR}",
// "Id is optional. If not given, all calendars viewable by default are used" => "Id is optional. If not given, all calendars viewable by default are used",
// "Category IDs" => "Category IDs",
// "List of category IDs separated by + signs. ex: 1+2+3. Default will use category of the current page" => "List of category IDs separated by + signs. ex: 1+2+3. Default will use category of the current page",
// "Types" => "Types",
// "List of object types to include in the list separated by plus signs. ex: article+blog+faq+fgal+forum+igal+newsletter+event+poll+quiz+survey+tracker+wiki+img" => "List of object types to include in the list separated by plus signs. ex: article+blog+faq+fgal+forum+igal+newsletter+event+poll+quiz+survey+tracker+wiki+img",
// "Sort Order" => "Sort Order",
// "fieldName_asc|fieldName_desc, valid fields: type, created, name, hits, shuffle" => "fieldName_asc|fieldName_desc, valid fields: type, created, name, hits, shuffle",
// "Split" => "Split",
// "And" => "And",
// "With sub-categories" => "With sub-categories",
// "Show object name" => "Show object name",
// "Show type" => "Show type",
// "Insert list of items with the current/given category in the wiki page" => "Insert list of items with the current/given category in the wiki page",
// "Category Orphans" => "Category Orphans",
// "Display Tiki objects that have not been categorized" => "Display Tiki objects that have not been categorized",
// "Objects" => "Objects",
// "wiki|article|blog|faq|fgal|forum|igal|newsletter|poll|quizz|survey|tracker" => "wiki|article|blog|faq|fgal|forum|igal|newsletter|poll|quizz|survey|tracker",
// "Category Path" => "Category Path",
// "Separator" => "Separator",
// "String used to separate the categories in the path. Default character is >" => "String used to separate the categories in the path. Default character is >",
// "Display top category" => "Display top category",
// "yes|no, default to no" => "yes|no, default to no",
// "Insert the full category path for each category that this wiki page belongs to" => "Insert the full category path for each category that this wiki page belongs to",
// "Center" => "Center",
// "Centers the plugin content in the wiki page" => "Centers the plugin content in the wiki page",
// "Displays a chart from TikiSheet. This plugin can be generated by the TikiSheet chart tool" => "Displays a chart from TikiSheet. This plugin can be generated by the TikiSheet chart tool",
// "Chart caption" => "Chart caption",
// "Sheet ID" => "Sheet ID",
// "Data sheet ID" => "Data sheet ID",
// "Chart Type" => "Chart Type",
// "BarStackGraphic|MultibarGraphic|MultilineGraphic|PieChartGraphic" => "BarStackGraphic|MultibarGraphic|MultilineGraphic|PieChartGraphic",
// "Chart Width" => "Chart Width",
// "Width in pixels" => "Width in pixels",
// "Chart Height" => "Chart Height",
// "Height in pixels" => "Height in pixels",
// "Value series" => "Value series",
// "Required for pie charts" => "Required for pie charts",
// "Independant series" => "Independant series",
// "Required for types other than pie chart" => "Required for types other than pie chart",
// "Dependant series" => "Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y2' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y2' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y3' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y3' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y4' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y4' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'color' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Colors" => "'),\n\t\t\t),\n\t\t\t'color' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Colors",
// "List of colors to use" => "List of colors to use",
// "Styles" => "Styles",
// "List of styles to use" => "List of styles to use",
// "Labels" => "Labels",
// "Labels for the series or values in the legend" => "Labels for the series or values in the legend",
// "Chart as PostScript" => "Chart as PostScript",
// "Code" => "Code",
// "Displays a snippet of code" => "Displays a snippet of code",
// "Caption" => "Caption",
// "Code snippet label" => "Code snippet label",
// "Word Wrap" => "Word Wrap",
// "0|1, Enable word wrapping on the code to avoid breaking the layout" => "0|1, Enable word wrapping on the code to avoid breaking the layout",
// "Colors" => "Colors",
// "Syntax highlighting to use. May not be used with line numbers. Available: php, html, sql, javascript, css, java, c, doxygen, delphi, .." => "Syntax highlighting to use. May not be used with line numbers. Available: php, html, sql, javascript, css, java, c, doxygen, delphi, ..",
// "Line numbers" => "Line numbers",
// "0|1, may not be used with colors" => "0|1, may not be used with colors",
// "Wiki syntax" => "Wiki syntax",
// "0|1, parse wiki syntax within the code snippet" => "0|1, parse wiki syntax within the code snippet",
// "Right to left" => "Right to left",
// "0|1, switch the text display from left to right to right to left" => "0|1, switch the text display from left to right to right to left",
// "Content is HTML" => "Content is HTML",
// "0|1, display the content as is instead of escaping HTML special chars" => "0|1, display the content as is instead of escaping HTML special chars",
// "note: colors and ln are exclusive" => "note: colors and ln are exclusive",
// "Dynamic Content" => "Dynamic Content",
// "Includes content from the dynamic content system" => "Includes content from the dynamic content system",
// "Content ID" => "Content ID",
// "Also known as fortune cookies or taglines" => "Also known as fortune cookies or taglines",
// "Insert copyright notices" => "Insert copyright notices",
// "Pattern to display the copyright in. May contain ~title~, ~year~ and ~authors~" => "Pattern to display the copyright in. May contain ~title~, ~year~ and ~authors~",
// "Countdown" => "Countdown",
// "Displays a countdown from now until the specified date" => "Displays a countdown from now until the specified date",
// "Text to append to the countdown" => "Text to append to the countdown",
// "Target date. Multiple formats accepted" => "Target date. Multiple formats accepted",
// "Locate Time" => "Locate Time",
// "on|off" => "on|off",
// "Items to show" => "Items to show",
// "Select: d=days, h=hours, m=minuts, s=seconds. Enter multiple values as: dhms. If blank, all items are shown" => "Select: d=days, h=hours, m=minuts, s=seconds. Enter multiple values as: dhms. If blank, all items are shown",
// "Show time since event" => "Show time since event",
// "If y, will display amount of time since the event (default). If n will simply display that the event is over" => "If y, will display amount of time since the event (default). If n will simply display that the event is over",
// "since " => "since ",
// "until " => "until ",
// " is over" => " is over",
// "Data Channel" => "Data Channel",
// "Displays a form to trigger data channels" => "Displays a form to trigger data channels",
// "List of fields to display. One field per line. Comma delimited: fieldname,label" => "List of fields to display. One field per line. Comma delimited: fieldname,label",
// "Channel Name" => "Channel Name",
// "Name of the channel as registered by the administrator" => "Name of the channel as registered by the administrator",
// "DBReport" => "DBReport",
// "Run a database report" => "Run a database report",
// "report definition" => "report definition",
// "Full DSN" => "Full DSN",
// "A full DSN (Data Source Name) connection string. eg: mysql://user:pass@server/database" => "A full DSN (Data Source Name) connection string. eg: mysql://user:pass@server/database",
// "Wiki DSN name" => "Wiki DSN name",
// "The name of a DSN connection defined by the Wiki administrator" => "The name of a DSN connection defined by the Wiki administrator",
// "0|1, parse wiki syntax within the report" => "0|1, parse wiki syntax within the report",
// "Debug" => "Debug",
// "0|1, display the parsed report definition" => "0|1, display the parsed report definition",
// "Missing db or dsn parameter" => "Missing db or dsn parameter",
// "You do not have permission to use this DSN" => "You do not have permission to use this DSN",
// "No DSN connection string found" => "No DSN connection string found",
// "Div" => "Div",
// "div|span|pre|b|i|tt|p|blockquote" => "div|span|pre|b|i|tt|p|blockquote",
// "Span" => "Span",
// "Pre" => "Pre",
// "Teletype" => "Teletype",
// "Paragraph" => "Paragraph",
// "Block quote" => "Block quote",
// "left|right|center|justify" => "left|right|center|justify",
// "Justify" => "Justify",
// "Float position" => "Float position",
// "left|right, for box with width less than 100%, make text wrap around the box" => "left|right, for box with width less than 100%, make text wrap around the box",
// "Determine how other elements can wrap around the element" => "Determine how other elements can wrap around the element",
// "Apply custom CSS class to the div" => "Apply custom CSS class to the div",
// "HTML id" => "HTML id",
// "Sets the div\\'s id attribute, as defined by HTML" => "Sets the div\\'s id attribute, as defined by HTML",
// "Insert a division block, span, blockquote or other text formatting on wiki page" => "Insert a division block, span, blockquote or other text formatting on wiki page",
// "Definition List" => "Definition List",
// "One entry per line. Each line is in \"Term: Definition\" format" => "One entry per line. Each line is in \"Term: Definition\" format",
// "Creates a definition list" => "Creates a definition list",
// "term" => "term",
// "definition" => "definition",
// "one definition per line" => "one definition per line",
// "Equation" => "Equation",
// "Renders an equation written in LaTeX syntax as an image" => "Renders an equation written in LaTeX syntax as an image",
// "equation" => "equation",
// "Percentage of increase from normal size. 100 produces the default size. 200 produces an image twice as large" => "Percentage of increase from normal size. 100 produces the default size. 200 produces an image twice as large",
// "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size" => "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size",
// "Includes the list of events from a calendar in the page" => "Includes the list of events from a calendar in the page",
// "Calendar ID" => "Calendar ID",
// "Numeric" => "Numeric",
// "Maximum days" => "Maximum days",
// "Maximum Rows" => "Maximum Rows",
// "Datetime" => "Datetime",
// "0|1" => "0|1",
// "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage" => "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage",
// "Upcoming events" => "Upcoming events",
// "Fade" => "Fade",
// "Displays a label. On click, the block of content will fade in and fade out" => "Displays a label. On click, the block of content will fade in and fade out",
// "Wiki syntax containing the text to display" => "Wiki syntax containing the text to display",
// "Label to display on first display" => "Label to display on first display",
// "Unspecified label" => "Unspecified label",
// "Fancy List" => "Fancy List",
// "One item per line starting with anything followed by \")\"" => "One item per line starting with anything followed by \")\"",
// "Use div" => "Use div",
// "Use div instead of ol" => "Use div instead of ol",
// "Class" => "Class",
// "CSS class for the fancylist" => "CSS class for the fancylist",
// "Creates a fancy-looking list" => "Creates a fancy-looking list",
// "num" => "num",
// "item text" => "item text",
// "one item per line" => "one item per line",
// "Fancy Table" => "Fancy Table",
// "Rows separated by >> in the header; for the table body, one row per line. Cells separated by | in both cases" => "Rows separated by >> in the header; for the table body, one row per line. Cells separated by | in both cases",
// "Heading row" => "Heading row",
// "Header rows of the table. Use >> to separate multiple rows" => "Header rows of the table. Use >> to separate multiple rows",
// "Heading CSS class" => "Heading CSS class",
// "CSS class to apply to the heading row" => "CSS class to apply to the heading row",
// "Header horizontal align" => "Header horizontal align",
// "Horizonatal alignments for header cells separated by |. Choices: left, right, center, justify" => "Horizonatal alignments for header cells separated by |. Choices: left, right, center, justify",
// "Header vertical align" => "Header vertical align",
// "Vertical alignments for header cells separated by |. Choices: top, middle, bottom, baseline" => "Vertical alignments for header cells separated by |. Choices: top, middle, bottom, baseline",
// "Column sort" => "Column sort",
// "Pre-sorted columns" => "Pre-sorted columns",
// "Bracketed numbers for column number and sort direction (0 = ascending, 1 = descending), for example: [0,0],[1,0]" => "Bracketed numbers for column number and sort direction (0 = ascending, 1 = descending), for example: [0,0],[1,0]",
// "Column widths" => "Column widths",
// "Column widths followed by px for pixels or % for percentages. Each column separated by |" => "Column widths followed by px for pixels or % for percentages. Each column separated by |",
// "Cell horizontal align" => "Cell horizontal align",
// "Table body column horizonatal alignments separated by |. Choices: left, right, center, justify" => "Table body column horizonatal alignments separated by |. Choices: left, right, center, justify",
// "Cell vertical align" => "Cell vertical align",
// "Table body column vertical alignments separated by |. Choices: top, middle, bottom, baseline" => "Table body column vertical alignments separated by |. Choices: top, middle, bottom, baseline",
// "The feature must be activated" => "The feature must be activated",
// "Displays the data using the Tikiwiki odd/even table style" => "Displays the data using the Tikiwiki odd/even table style",
// "cells" => "cells",
// "heads and cells separated by |" => "heads and cells separated by |",
// "Displays a link to an attachment to a wiki page and can display an image attachment. " => "Displays a link to an attachment to a wiki page and can display an image attachment. ",
// "Gallery ID" => "Gallery ID",
// "sort" => "sort",
// "name_asc" => "name_asc",
// "Shows ID" => "Shows ID",
// "Shows Icon" => "Shows Icon",
// "Shows Name" => "Shows Name",
// "Shows Filename" => "Shows Filename",
// "Shows Size" => "Shows Size",
// "Shows Description" => "Shows Description",
// "Shows Creation Date" => "Shows Creation Date",
// "Shows Hits" => "Shows Hits",
// "Shows Locked by" => "Shows Locked by",
// "Shows Modification Date" => "Shows Modification Date",
// "Shows Author" => "Shows Author",
// "Shows Creator" => "Shows Creator",
// "Shows Parent Gallery Name" => "Shows Parent Gallery Name",
// "Shows Number of Files" => "Shows Number of Files",
// "Shows the slideshow of a gallery" => "Shows the slideshow of a gallery",
// "List files in a file gallery (with a category) or in a category or a file gallery od this category" => "List files in a file gallery (with a category) or in a category or a file gallery od this category",
// "Displays a list of files from the File Gallery" => "Displays a list of files from the File Gallery",
// "Flash video" => "Flash video",
// "Displays a Flash (.swf) file in the wiki page" => "Displays a Flash (.swf) file in the wiki page",
// "Movie URL" => "Movie URL",
// "Complete URL to the movie to include. e.g. files/test.swf" => "Complete URL to the movie to include. e.g. files/test.swf",
// "Default width: 425" => "Default width: 425",
// "Default height: 350" => "Default height: 350",
// "Quality" => "Quality",
// "Flash video quality. Default value: high" => "Flash video quality. Default value: high",
// "Missing parameter movie to the plugin flash" => "Missing parameter movie to the plugin flash",
// "Footnote" => "Footnote",
// "Inserts a superscripted footnote number next to text and takes in footnote as parameter" => "Inserts a superscripted footnote number next to text and takes in footnote as parameter",
// "The footnote" => "The footnote",
// "Footnotearea" => "Footnotearea",
// "Inserts a section for collected footnotes in the wiki page" => "Inserts a section for collected footnotes in the wiki page",
// "Download box for a file on ftp server" => "Download box for a file on ftp server",
// "ftp" => "ftp",
// "file name" => "file name",
// "Ftp Server Name" => "Ftp Server Name",
// "Ftp User name" => "Ftp User name",
// "Ftp password" => "Ftp password",
// "Download button label" => "Download button label",
// "Connection failed" => "Connection failed",
// "failed" => "failed",
// "Gauge" => "Gauge",
// "Displays a graphical gauge" => "Displays a graphical gauge",
// "description" => "description",
// "Value" => "Value",
// "current value (REQUIRED)" => "current value (REQUIRED)",
// "Maximum Value" => "Maximum Value",
// "Maximum possible value. Default: 100" => "Maximum possible value. Default: 100",
// "Label displayed on the left side of the gauge" => "Label displayed on the left side of the gauge",
// "Color" => "Color",
// "Bar width in pixels" => "Bar width in pixels",
// "Label Width" => "Label Width",
// "Width in pixels allocated to the label" => "Width in pixels allocated to the label",
// "Display Percentage" => "Display Percentage",
// "true|false, if true then a percentage of the maximum is displayed" => "true|false, if true then a percentage of the maximum is displayed",
// "Display Value" => "Display Value",
// "true|false, if the numeric value is displayed" => "true|false, if the numeric value is displayed",
// "Bar height in pixels" => "Bar height in pixels",
// "Displays a graphical GAUGE" => "Displays a graphical GAUGE",
// "Google Analytics" => "Google Analytics",
// "Add the tracking code for Google Analytics" => "Add the tracking code for Google Analytics",
// "Account number" => "Account number",
// "The account number for the site" => "The account number for the site",
// "googledoc" => "googledoc",
// "Leave this empty" => "Leave this empty",
// "type" => "type",
// "Type of Google document" => "Type of Google document",
// "key" => "key",
// "Google doc key - for example: pXsHENf1bGGY92X1iEeJJI" => "Google doc key - for example: pXsHENf1bGGY92X1iEeJJI",
// "Name of iframe" => "Name of iframe",
// "Size of frame, use instead of width and height, they will fit the Google presentations sizes exactly. It can be small|medium|large" => "Size of frame, use instead of width and height, they will fit the Google presentations sizes exactly. It can be small|medium|large",
// "Pixels or %" => "Pixels or %",
// "Margin Height" => "Margin Height",
// "Pixels" => "Pixels",
// "Margin Width" => "Margin Width",
// "Scrolling" => "Scrolling",
// "editLink" => "editLink",
// "Required parameter \"type\" missing" => "Required parameter \"type\" missing",
// "Required parameter \"key\" missing" => "Required parameter \"key\" missing",
// "Displays a Google document" => "Displays a Google document",
// "Wiki text to display if conditions are met. The body may contain {ELSE}. Text after the marker will be displayed to users not matching the condition" => "Wiki text to display if conditions are met. The body may contain {ELSE}. Text after the marker will be displayed to users not matching the condition",
// "Allowed User Friends" => "Allowed User Friends",
// "Pipe separated list of users whose friends are allowed to view the block. ex: admin|johndoe|foo" => "Pipe separated list of users whose friends are allowed to view the block. ex: admin|johndoe|foo",
// "Allowed Groups" => "Allowed Groups",
// "Pipe separated list of groups allowed to view the block. ex: Admins|Developers" => "Pipe separated list of groups allowed to view the block. ex: Admins|Developers",
// "Denied Groups" => "Denied Groups",
// "Pipe separated list of groups denied from viewing the block. ex: Anonymous|Managers" => "Pipe separated list of groups denied from viewing the block. ex: Anonymous|Managers",
// "Display wiki text if user is in one of listed groups or group of friends" => "Display wiki text if user is in one of listed groups or group of friends",
// "Display wiki text if user is in one of listed groups" => "Display wiki text if user is in one of listed groups",
// "GroupMailCore" => "GroupMailCore",
// "Displays GroupMail functions on a wiki page. Usually set up using a plugin alias created by the GroupMail profile" => "Displays GroupMail functions on a wiki page. Usually set up using a plugin alias created by the GroupMail profile",
// "From Email" => "From Email",
// "Email address to report" => "Email address to report",
// "Tracker Id" => "Tracker Id",
// "Id of GroupMail Logs tracker (set up in alias by profile)" => "Id of GroupMail Logs tracker (set up in alias by profile)",
// "From Field Id" => "From Field Id",
// "Id of GroupMail Logs tracker field (usually set up in alias by profile)" => "Id of GroupMail Logs tracker field (usually set up in alias by profile)",
// "operator Field Id" => "operator Field Id",
// "subject Field Id" => "subject Field Id",
// "message Field Id" => "message Field Id",
// "content Field Id" => "content Field Id",
// "account Field Id" => "account Field Id",
// "datetime Field Id" => "datetime Field Id",
// "Displays GroupMail functions on a wiki page" => "Displays GroupMail functions on a wiki page",
// "Group Stats" => "Group Stats",
// "groups" => "groups",
// "Groups separated by " => "Groups separated by ",
// "Show Percentage" => "Show Percentage",
// "Show Bar" => "Show Bar",
// "Displays some stat about group belonging" => "Displays some stat about group belonging",
// "HTML" => "HTML",
// "Include literal HTML in a Wiki page" => "Include literal HTML in a Wiki page",
// "0|1, parse wiki syntax within the html code" => "0|1, parse wiki syntax within the html code",
// "Include literal HTML" => "Include literal HTML",
// "Iframe" => "Iframe",
// "name" => "name",
// "Frame title" => "Frame title",
// "iframe" => "iframe",
// "Displays an iframe" => "Displays an iframe",
// " (experimental - possible successor to img in 5.0)" => " (experimental - possible successor to img in 5.0)",
// "File ID" => "File ID",
// "Numeric ID of an image in a File Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required" => "Numeric ID of an image in a File Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required",
// "Numeric ID of an image in an Image Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required" => "Numeric ID of an image in an Image Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required",
// "Image Source" => "Image Source",
// "Full URL to the image to display. \"fileId\", \"id\" or \"src\" required" => "Full URL to the image to display. \"fileId\", \"id\" or \"src\" required",
// "Maximum height or width in pixels (largest dimension is scaled).\tIf no scalesize is given one will be attempted from default or given height or width.  If scale does not match a defined scale for the gallery the full sized image is downloaded" => "Maximum height or width in pixels (largest dimension is scaled).\tIf no scalesize is given one will be attempted from default or given height or width.  If scale does not match a defined scale for the gallery the full sized image is downloaded",
// "Alias: lnk. Location the image should point to" => "Alias: lnk. Location the image should point to",
// "Link Relation" => "Link Relation",
// "\"rel\" attribute to add to the link" => "\"rel\" attribute to add to the link",
// "Link title" => "Link title",
// "Title text" => "Title text",
// "Image alt text" => "Image alt text",
// "Alternate text to display if impossible to load the image" => "Alternate text to display if impossible to load the image",
// "Alias:imalign. Image alignment in the page. (left, right)" => "Alias:imalign. Image alignment in the page. (left, right)",
// "Whether to block items from flowing next to image from the top or bottom. (top,bottom,both,none)" => "Whether to block items from flowing next to image from the top or bottom. (top,bottom,both,none)",
// "Image description to display on the page" => "Image description to display on the page",
// "Image Map" => "Image Map",
// "Name of the image map to use for the image" => "Name of the image map to use for the image",
// "CSS class to apply to the image'.\"'\".'s img tag. (Usually used in configuration rather than on individual images.)" => "CSS class to apply to the image'.\"'\".'s img tag. (Usually used in configuration rather than on individual images.)",
// "CSS Style" => "CSS Style",
// "CSS styling to apply to the plugin (usually used in configuration rather than on individual images)" => "CSS styling to apply to the plugin (usually used in configuration rather than on individual images)",
// "Border options" => "Border options",
// "Border configuration.  Values \"on\" and \"off\" control visibility, or else specify CSS styling options" => "Border configuration.  Values \"on\" and \"off\" control visibility, or else specify CSS styling options",
// "Description options" => "Description options",
// "Description configuration.\tValues \"on\" and \"off\" control visibility, or else specify CSS styling options. (Usually used in configuration rather than on individual images.)" => "Description configuration.\tValues \"on\" and \"off\" control visibility, or else specify CSS styling options. (Usually used in configuration rather than on individual images.)",
// "Default configuration" => "Default configuration",
// "Default configuration definitions. (Usually used in configuration rather than on individual images.)" => "Default configuration definitions. (Usually used in configuration rather than on individual images.)",
// "Mandatory configuration" => "Mandatory configuration",
// "Mandatory configuration definitions. (Usually used in configuration rather than on individual images.)" => "Mandatory configuration definitions. (Usually used in configuration rather than on individual images.)",
// "Display an image using configured format. Allows presentation of all images to be changed without having to alter existing content" => "Display an image using configured format. Allows presentation of all images to be changed without having to alter existing content",
// "Display an image" => "Display an image",
// "Display images" => "Display images",
// "Image source" => "Image source",
// "Full URL to the image to display. \"id\", \"fileId\", \"attId\" or \"src\" required" => "Full URL to the image to display. \"id\", \"fileId\", \"attId\" or \"src\" required",
// "Numeric ID of an image in an Image Gallery (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required" => "Numeric ID of an image in an Image Gallery (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required",
// "Numeric ID of an image in a File Gallery (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required" => "Numeric ID of an image in a File Gallery (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required",
// "Attachment ID" => "Attachment ID",
// "Numeric ID of an image attached to a wiki page (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required" => "Numeric ID of an image attached to a wiki page (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required",
// "Makes the image a thumbnail that enlarges to full size when clicked or moused over (unless \"link\" is set to another target). \"browse\" and \"browsepopup\" only work with image gallery and \"download\" only works with file gallery" => "Makes the image a thumbnail that enlarges to full size when clicked or moused over (unless \"link\" is set to another target). \"browse\" and \"browsepopup\" only work with image gallery and \"download\" only works with file gallery",
// "Full size image appears when thumbnail is clicked" => "Full size image appears when thumbnail is clicked",
// "Mouseover" => "Mouseover",
// "Full size image will pop up while cursor is over the thumbnail (and disappear when not)" => "Full size image will pop up while cursor is over the thumbnail (and disappear when not)",
// "Mouseover (Sticky)" => "Mouseover (Sticky)",
// "Full size image will pop up once cursor passes over thumbnail and will remain up unless cursor passes over full size popup" => "Full size image will pop up once cursor passes over thumbnail and will remain up unless cursor passes over full size popup",
// "Popup" => "Popup",
// "Full size image will open in a separate winow or tab (depending on browser settings) when thumbnail is clicked" => "Full size image will open in a separate winow or tab (depending on browser settings) when thumbnail is clicked",
// "Image gallery browse window for the image will open when the thumbnail is clicked if the image is in a Tiki image gallery" => "Image gallery browse window for the image will open when the thumbnail is clicked if the image is in a Tiki image gallery",
// "Browse Popup" => "Browse Popup",
// "Same as \"browse\" except that the page opens in a new window or tab" => "Same as \"browse\" except that the page opens in a new window or tab",
// "Download dialog box will appear for file gallery images when thumbnail is clicked" => "Download dialog box will appear for file gallery images when thumbnail is clicked",
// "Enlarge button" => "Enlarge button",
// "Button for enlarging image" => "Button for enlarging image",
// "Enter a url to the address the image should link to. Not needed if thumb parameter is set; overrides thumb setting" => "Enter a url to the address the image should link to. Not needed if thumb parameter is set; overrides thumb setting",
// "Link relation" => "Link relation",
// "Enter \"box\" for colorbox effect (like shadowbox and lightbox) or appropriate syntax for link relation" => "Enter \"box\" for colorbox effect (like shadowbox and lightbox) or appropriate syntax for link relation",
// "Image map" => "Image map",
// "Maximum image size" => "Maximum image size",
// "Maximum height or width in pixels (largest dimension is scaled). Overrides height and width settings" => "Maximum height or width in pixels (largest dimension is scaled). Overrides height and width settings",
// "Align image" => "Align image",
// "Aligns the image itself. If the image is inside a box (because of other settings), use the align parameter to align the box" => "Aligns the image itself. If the image is inside a box (because of other settings), use the align parameter to align the box",
// "Image style" => "Image style",
// "Enter \"border\" to place a dark gray border around the image. Otherwise enter CSS styling syntax for other style effects" => "Enter \"border\" to place a dark gray border around the image. Otherwise enter CSS styling syntax for other style effects",
// "Align image block" => "Align image block",
// "Aligns the box containing the image" => "Aligns the box containing the image",
// "Image block style" => "Image block style",
// "Enter \"border\" to place a dark gray border frame around the image. Otherwise enter CSS styling syntax for other style effects" => "Enter \"border\" to place a dark gray border frame around the image. Otherwise enter CSS styling syntax for other style effects",
// "Description style" => "Description style",
// "Enter \"right\" or \"left\" to align text accordingly. Otherwise enter CSS styling syntax for other style effects" => "Enter \"right\" or \"left\" to align text accordingly. Otherwise enter CSS styling syntax for other style effects",
// "Wrapping control" => "Wrapping control",
// "Control how other items wrap around the image" => "Control how other items wrap around the image",
// "CSS class" => "CSS class",
// "CSS class to apply to the image" => "CSS class to apply to the image",
// "Image caption. \"desc\" or \"name\" for tiki images, \"idesc\" or \"ititle\" for iptc data, otherwise enter your own description" => "Image caption. \"desc\" or \"name\" for tiki images, \"idesc\" or \"ititle\" for iptc data, otherwise enter your own description",
// "Alternate text" => "Alternate text",
// "Alternate text that displays when image does not load" => "Alternate text that displays when image does not load",
// "Default config settings" => "Default config settings",
// "Default configuration settings (usually set by admin)" => "Default configuration settings (usually set by admin)",
// "Mandatory admin setting" => "Mandatory admin setting",
// "Mandatory configuration settings (usually set by admin)" => "Mandatory configuration settings (usually set by admin)",
// "File not found" => "File not found",
// "File is not an image" => "File is not an image",
// "Server does not support image manipulation" => "Server does not support image manipulation",
// "''No image specified. Either the fileId, attId, id, or src parameter must be specified.''" => "''No image specified. Either the fileId, attId, id, or src parameter must be specified.''",
// "''Use one and only one of the following parameters: fileId, attId, id, or src.''" => "''Use one and only one of the following parameters: fileId, attId, id, or src.''",
// "Include" => "Include",
// "Include a page\\'s content" => "Include a page\\'s content",
// "Page Name" => "Page Name",
// "Wiki page name to include" => "Wiki page name to include",
// "When only a portion of the page should be included, specify the marker from which inclusion should start" => "When only a portion of the page should be included, specify the marker from which inclusion should start",
// "When only a portion of the page should be included, specify the marker at which inclusion should end" => "When only a portion of the page should be included, specify the marker at which inclusion should end",
// "Include a page" => "Include a page",
// "Invite" => "Invite",
// "Invite an email in groups" => "Invite an email in groups",
// "Confirmation message after posting form" => "Confirmation message after posting form",
// "Including group" => "Including group",
// "Default group" => "Default group",
// "Group from the item group selector / creator field" => "Group from the item group selector / creator field",
// "Following mandatory fields are missing" => "Following mandatory fields are missing",
// "Email address" => "Email address",
// "Jabber" => "Jabber",
// "Runs a Java applet to access a local Jabber service" => "Runs a Java applet to access a local Jabber service",
// "Applet height in pixels" => "Applet height in pixels",
// "'),\n\t\t\t\t'description' => tra('Applet width in pixels" => "'),\n\t\t\t\t'description' => tra('Applet width in pixels",
// "'),\n\t\t\t\t'description' => tra('jabber.org" => "'),\n\t\t\t\t'description' => tra('jabber.org",
// "Default Color" => "Default Color",
// "255,255,255" => "255,255,255",
// "JQuery" => "JQuery",
// "Insert JQuery javascript code. Requires feature_jquery" => "Insert JQuery javascript code. Requires feature_jquery",
// " (experimental - may change in future versions)" => " (experimental - may change in future versions)",
// "JQuery Code" => "JQuery Code",
// "NotOnReady" => "NotOnReady",
// "NoJQuery" => "NoJQuery",
// "Optional markup for when feature_jquery is off" => "Optional markup for when feature_jquery is off",
// "Insert JQuery javascript code" => "Insert JQuery javascript code",
// "jquery code e.g. \$jq(\"img\\" => "jquery code e.g. \$jq(\"img\\",
// "Do not execute on document ready (execute inline)" => "Do not execute on document ready (execute inline)",
// "Javascript" => "Javascript",
// "Insert a javascript file or/and some javascript code" => "Insert a javascript file or/and some javascript code",
// "javascript code" => "javascript code",
// "Javascript filename" => "Javascript filename",
// "Kaltura video" => "Kaltura video",
// "Displays a KALTURA video on the wiki page" => "Displays a KALTURA video on the wiki page",
// "Kaltura Entry Id" => "Kaltura Entry Id",
// "List of languages for which the block is displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs" => "List of languages for which the block is displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs",
// "Not Language" => "Not Language",
// "List of languages for which the block is not displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs" => "List of languages for which the block is not displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs",
// "Displays the text only if the language matchs" => "Displays the text only if the language matchs",
// "Page name to display information of. Default value is current page" => "Page name to display information of. Default value is current page",
// "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given" => "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given",
// "Result Offset" => "Result Offset",
// "Result number at which the listing should start" => "Result number at which the listing should start",
// "Result Count" => "Result Count",
// "Number of results displayed in the list" => "Number of results displayed in the list",
// "Initial" => "Initial",
// "txt" => "txt",
// "Show Name Only" => "Show Name Only",
// "Structure Head" => "Structure Head",
// "Show Page Alias" => "Show Page Alias",
// "Two letter language code to filter pages listed" => "Two letter language code to filter pages listed",
// "Orphan Language" => "Orphan Language",
// "Two letter language code to filter pages listed. Only pages not available in the provided language will be listed" => "Two letter language code to filter pages listed. Only pages not available in the provided language will be listed",
// "Load Translations" => "Load Translations",
// "user or pipe separated list of two letter language codes for additional languages to display. If the language parameter is not defined, the first element of this list will be used as the primary filter" => "user or pipe separated list of two letter language codes for additional languages to display. If the language parameter is not defined, the first element of this list will be used as the primary filter",
// "Exact Match" => "Exact Match",
// "Related to Find" => "Related to Find",
// "Only Orphan Pages" => "Only Orphan Pages",
// "For List Pages" => "For List Pages",
// "List Progress" => "List Progress",
// "Indicates the internationalization progress of the page list" => "Indicates the internationalization progress of the page list",
// "List Name" => "List Name",
// "Name of the list as configured in the page list admin panel" => "Name of the list as configured in the page list admin panel",
// "Limit" => "Limit",
// "Maximum amount of results to display" => "Maximum amount of results to display",
// "Filter to apply to the page list" => "Filter to apply to the page list",
// "Score Limit" => "Score Limit",
// "Value used as the denominator for the score" => "Value used as the denominator for the score",
// "articles" => "articles",
// "List Directory" => "List Directory",
// "Full path to the server-local directory" => "Full path to the server-local directory",
// "URL Prefix" => "URL Prefix",
// ".ext" => ".ext",
// "Maximum amount of files to display" => "Maximum amount of files to display",
// "Map" => "Map",
// "Displays a map" => "Displays a map",
// "Map File" => "Map File",
// "Extents" => "Extents",
// "Feature disabled" => "Feature disabled",
// "Mayan Calendars Info" => "Mayan Calendars Info",
// "Convert date from Gregorian to Mayan Calendars: Tzolkin, Haab, Long Count" => "Convert date from Gregorian to Mayan Calendars: Tzolkin, Haab, Long Count",
// "You must use the variable substitution.<br/>'.\n                             'LongCount: %baktun%, %katun%, %tun%, %winal%, %kin%;<br/>'.\n                             'Tzolkin: %tzolkin13%, %tzolkin20%, %tzolkin20name%;<br/>'.\n                             'Haab: %haabkin%, %haabwinal%, %haabwinalname%;<br/>'.\n                             'Misc: %longkin%, %julianday%.<br/><br/>'.\n                             'Example: template \"%baktun%.%katun%.%tun%.%winal%.%kin%, %tzolkin13% %tzolkin20name%, %haabkin% %haabwinalname%\" for 22.05.2009 will return 12.19.16.6.11, 8 CHUEN, 9 SIP.<br/>'.\n                             'Default template: %baktun%.%katun%.%tun%.%winal%.%kin% %tzolkin13% %tzolkin20name% %haabkin% %haabwinalname%" => "You must use the variable substitution.<br/>'.\n                             'LongCount: %baktun%, %katun%, %tun%, %winal%, %kin%;<br/>'.\n                             'Tzolkin: %tzolkin13%, %tzolkin20%, %tzolkin20name%;<br/>'.\n                             'Haab: %haabkin%, %haabwinal%, %haabwinalname%;<br/>'.\n                             'Misc: %longkin%, %julianday%.<br/><br/>'.\n                             'Example: template \"%baktun%.%katun%.%tun%.%winal%.%kin%, %tzolkin13% %tzolkin20name%, %haabkin% %haabwinalname%\" for 22.05.2009 will return 12.19.16.6.11, 8 CHUEN, 9 SIP.<br/>'.\n                             'Default template: %baktun%.%katun%.%tun%.%winal%.%kin% %tzolkin13% %tzolkin20name% %haabkin% %haabwinalname%",
// "Gregorian date" => "Gregorian date",
// "Gregorian date for convert. Format: DD.MM.YYYY. Default: Today date" => "Gregorian date for convert. Format: DD.MM.YYYY. Default: Today date",
// "Mayan Calendars" => "Mayan Calendars",
// " is not a valid date format. should be dd.mm.yyyy" => " is not a valid date format. should be dd.mm.yyyy",
// "Inline Flash mp3 and flv Player" => "Inline Flash mp3 and flv Player",
// "Mediaplayer" => "Mediaplayer",
// "MP3 URL" => "MP3 URL",
// "Complete URL to the mp3 to include" => "Complete URL to the mp3 to include",
// "FLV URL" => "FLV URL",
// "Complete URL to the flv to include" => "Complete URL to the flv to include",
// "One of" => "One of",
// "Member List" => "Member List",
// "Lists the members of selected groups and allows to add or remove members if permissions are granted" => "Lists the members of selected groups and allows to add or remove members if permissions are granted",
// "List of groups to handle through the interface. Colon separated" => "List of groups to handle through the interface. Colon separated",
// "Mini Quiz" => "Mini Quiz",
// "Displays a miniquiz" => "Displays a miniquiz",
// "Instructions::Feedback" => "Instructions::Feedback",
// "Tracker ID" => "Tracker ID",
// "Insert Module" => "Insert Module",
// "Module name as known in Tikiwiki" => "Module name as known in Tikiwiki",
// "Decoration" => "Decoration",
// "Max" => "Max",
// "np" => "np",
// "notitle" => "notitle",
// "Please choose a module" => "Please choose a module",
// "to be used as argument" => "to be used as argument",
// "Displays a module inline in a wiki page" => "Displays a module inline in a wiki page",
// "Displays a module inline in a wiki page. More parameters can be added, not supported by UI" => "Displays a module inline in a wiki page. More parameters can be added, not supported by UI",
// "Sorry, no such module" => "Sorry, no such module",
// "Monospace" => "Monospace",
// "Font" => "Font",
// "Font name as known in browsers" => "Font name as known in browsers",
// "Displays the data using a monospace font" => "Displays the data using a monospace font",
// "Create a mouseover feature on some text" => "Create a mouseover feature on some text",
// "Mouseover text if param label exists. Page text if text param exists" => "Mouseover text if param label exists. Page text if text param exists",
// "Text displayed on the page. The body is the mouseover content" => "Text displayed on the page. The body is the mouseover content",
// "Destination link when mouseover text is clicked. Use http:// for external links" => "Destination link when mouseover text is clicked. Use http:// for external links",
// "Text" => "Text",
// "DEPRECATED" => "DEPRECATED",
// "Text displayed on the mouseover. The body contains the text of the page" => "Text displayed on the mouseover. The body contains the text of the page",
// "Mouseover box width. Default: 400px" => "Mouseover box width. Default: 400px",
// "Mouseover box height. Default: 200px" => "Mouseover box height. Default: 200px",
// "Offset X" => "Offset X",
// "Shifts the overlay to the right by the specified number of pixels relative to the cursor. Default: 5px" => "Shifts the overlay to the right by the specified number of pixels relative to the cursor. Default: 5px",
// "Offset Y" => "Offset Y",
// "Shifts the overlay lower by the specified number of pixels relative to the cursor. Default: 0px" => "Shifts the overlay lower by the specified number of pixels relative to the cursor. Default: 0px",
// "Parse Body" => "Parse Body",
// "y|n, parse the body of the plugin as wiki content. (Default to y)" => "y|n, parse the body of the plugin as wiki content. (Default to y)",
// "Background color of the popup" => "Background color of the popup",
// "'),\n\t\t\t\t'filter' => 'striptags" => "'),\n\t\t\t\t'filter' => 'striptags",
// "Text color in the popup" => "Text color in the popup",
// "Sticky" => "Sticky",
// "Padding" => "Padding",
// "Effect" => "Effect",
// "Effect speed" => "Effect speed",
// "No label specified" => "No label specified",
// "MWTable" => "MWTable",
// "fancy" => "fancy",
// "true|false" => "true|false",
// "wiki_classes" => "wiki_classes",
// "Displays the data using (sort of) MediaWiki syntax" => "Displays the data using (sort of) MediaWiki syntax",
// "Displays a table using MediaWiki syntax" => "Displays a table using MediaWiki syntax",
// "MySpace" => "MySpace",
// "MySpace Page" => "MySpace Page",
// "Displays a MySpace Flash mp3 playlist in the wiki page" => "Displays a MySpace Flash mp3 playlist in the wiki page",
// "Object Hits" => "Object Hits",
// "Object ID" => "Object ID",
// "Object Type" => "Object Type",
// "Displays object hit info by object and days" => "Displays object hit info by object and days",
// "List pages part of a named list" => "List pages part of a named list",
// "Offset" => "Offset",
// "Pagination start element" => "Pagination start element",
// "list parameter missing or doesn\\'t exist" => "list parameter missing or doesn\\'t exist",
// "% of page hits" => "% of page hits",
// "Page Hits" => "Page Hits",
// "Picture" => "Picture",
// "Search for images uploaded by users" => "Search for images uploaded by users",
// " (deprecated - scheduled to be removed or changed significantly)" => " (deprecated - scheduled to be removed or changed significantly)",
// "Filename or full path to file" => "Filename or full path to file",
// "Plugin Manager" => "Plugin Manager",
// "Multiple values separated with | can be used" => "Multiple values separated with | can be used",
// "Displays a list of plugins available in this wiki" => "Displays a list of plugins available in this wiki",
// "No version indicated" => "No version indicated",
// "No arguments indicated" => "No arguments indicated",
// "Poll ID" => "Poll ID",
// "Displays the output of a poll, fields are indicated with numeric ids" => "Displays the output of a poll, fields are indicated with numeric ids",
// "missing poll ID for plugin POLL" => "missing poll ID for plugin POLL",
// "Profile Installer" => "Profile Installer",
// "Adds controls required to install a profile" => "Adds controls required to install a profile",
// "Domain" => "Domain",
// "Profile repository domain. Default value is profiles.tikiwiki.org" => "Profile repository domain. Default value is profiles.tikiwiki.org",
// "Profile Name" => "Profile Name",
// "Name of the profile" => "Name of the profile",
// "Profile plugin only available to administrators" => "Profile plugin only available to administrators",
// "Profile %0/%1 not found" => "Profile %0/%1 not found",
// "Proposal" => "Proposal",
// "Provides a widget for users to vote on a proposal and view the current decision" => "Provides a widget for users to vote on a proposal and view the current decision",
// "The list of votes cast. One vote per line. Either 0, +1 or -1 followed by a username" => "The list of votes cast. One vote per line. Either 0, +1 or -1 followed by a username",
// "Accept proposal" => "Accept proposal",
// "Still undecided" => "Still undecided",
// "Reject proposal" => "Reject proposal",
// "Displays a proposal acceptance widget" => "Displays a proposal acceptance widget",
// "Short description of the proposal to vote on. Will be displayed above the result table" => "Short description of the proposal to vote on. Will be displayed above the result table",
// "Quote" => "Quote",
// "Quoted text" => "Quoted text",
// "Reply to" => "Reply to",
// "Name of the quoted person" => "Name of the quoted person",
// "wrote" => "wrote",
// "Quote text by surrounding the text with a box, like the [QUOTE] BBCode" => "Quote text by surrounding the text with a box, like the [QUOTE] BBCode",
// "Random Dynamic Content" => "Random Dynamic Content",
// "Includes random content from the dynamic content system" => "Includes random content from the dynamic content system",
// "User List (showing Real Name)" => "User List (showing Real Name)",
// " (experimental, should be merged with UserList in Tiki5)" => " (experimental, should be merged with UserList in Tiki5)",
// "Login Filter" => "Login Filter",
// "String to use between elements of the list" => "String to use between elements of the list",
// "Maximum" => "Maximum",
// "Result limit" => "Result limit",
// "Layout" => "Layout",
// "Exclude" => "Exclude",
// "Displays a list of users showing their real name" => "Displays a list of users showing their real name",
// "Displays a list of registered users showing their Real Names" => "Displays a list of registered users showing their Real Names",
// "Redirect" => "Redirect",
// "Redirect the user to a wiki page or generic URL" => "Redirect the user to a wiki page or generic URL",
// "Wiki page name to redirect to" => "Wiki page name to redirect to",
// "Complete URL, internal or external" => "Complete URL, internal or external",
// "Redirects you to another wiki page" => "Redirects you to another wiki page",
// "Regular Expression" => "Regular Expression",
// "Takes regex expressions and parses the content between REGEX tags and replaces the text" => "Takes regex expressions and parses the content between REGEX tags and replaces the text",
// "Page name containing the regular expression" => "Page name containing the regular expression",
// "Takes regex expressions and parses the content between the REGEX tags and replaces the text" => "Takes regex expressions and parses the content between the REGEX tags and replaces the text",
// "Displays a comment, tip, note or warning box" => "Displays a comment, tip, note or warning box",
// "remarks text" => "remarks text",
// "Remarks Box" => "Remarks Box",
// "Label displayed above the remark" => "Label displayed above the remark",
// "Highlight" => "Highlight",
// "Icon ID" => "Icon ID",
// "y|n Show close button (default y)" => "y|n Show close button (default y)",
// "Width (e.g. 100% or 250px - default \"\")" => "Width (e.g. 100% or 250px - default \"\")",
// "RSS Feed" => "RSS Feed",
// "Inserts an RSS feed output" => "Inserts an RSS feed output",
// "IDs" => "IDs",
// "List of feed IDs separated by colons. ex: feedId:feedId2" => "List of feed IDs separated by colons. ex: feedId:feedId2",
// "Number of results displayed" => "Number of results displayed",
// "You need to specify a RSS Id" => "You need to specify a RSS Id",
// "RSS Id incorrect" => "RSS Id incorrect",
// "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage",
// "Screencast" => "Screencast",
// "Display a screencast uploaded on the page" => "Display a screencast uploaded on the page",
// "Label to use as a replacement to the default text" => "Label to use as a replacement to the default text",
// "ID as provided automatically during the upload" => "ID as provided automatically during the upload",
// "Insert Screencast" => "Insert Screencast",
// "Screencast ID wasn't specified or doesn't exist" => "Screencast ID wasn't specified or doesn't exist",
// "Watch a video of these instructions" => "Watch a video of these instructions",
// "SourceForge" => "SourceForge",
// "aid?" => "aid?",
// "adit?" => "adit?",
// "groupid?" => "groupid?",
// "Automatically creates a link to the appropriate SourceForge object" => "Automatically creates a link to the appropriate SourceForge object",
// "Insert a ShareThis button from www.sharethis.com" => "Insert a ShareThis button from www.sharethis.com",
// "sharethis" => "sharethis",
// "Display a social networking tool" => "Display a social networking tool",
// "Send services" => "Send services",
// "By default, email, aim and sms are available. Input one or two of the services separated by a | to limit the choice of send services" => "By default, email, aim and sms are available. Input one or two of the services separated by a | to limit the choice of send services",
// "First post services shown" => "First post services shown",
// "Input a list of post services (like facebook, myspace, digg, etc.) separated by a | to customize the services that are shown in the opening panel of the widget" => "Input a list of post services (like facebook, myspace, digg, etc.) separated by a | to customize the services that are shown in the opening panel of the widget",
// "Rotate image" => "Rotate image",
// "A value of y will cause the button icon to rotate every 3 seconds between a few icons, cycling through twice before stopping" => "A value of y will cause the button icon to rotate every 3 seconds between a few icons, cycling through twice before stopping",
// "Button text" => "Button text",
// "Custom link text for the button" => "Custom link text for the button",
// "Header title" => "Header title",
// "Optional header title text for the widget" => "Optional header title text for the widget",
// "Header background" => "Header background",
// "HTML color code (not color name) for the background color for the header if an optional header title is used" => "HTML color code (not color name) for the background color for the header if an optional header title is used",
// "Header text color" => "Header text color",
// "HTML color code (not color name) for the header text if an optional header title is used" => "HTML color code (not color name) for the header text if an optional header title is used",
// "Link text color for services" => "Link text color for services",
// "HTML color code (not color name) for the link text for all send and post services shown in the widget" => "HTML color code (not color name) for the link text for all send and post services shown in the widget",
// "Pop-up" => "Pop-up",
// "A value of true will cause the widget to show in a pop-up window" => "A value of true will cause the widget to show in a pop-up window",
// "Embedded elements" => "Embedded elements",
// "A value of true will allow embedded elements (like flash) to be seen while iframe is loading" => "A value of true will allow embedded elements (like flash) to be seen while iframe is loading",
// "Sheet" => "Sheet",
// "Displays the content of a spreadsheet in the page" => "Displays the content of a spreadsheet in the page",
// "Sheet Heading" => "Sheet Heading",
// "Internal ID of the TikiSheet" => "Internal ID of the TikiSheet",
// "New sheet in page: " => "New sheet in page: ",
// "Incomplete call to plugin: No target sheet" => "Incomplete call to plugin: No target sheet",
// "Create new sheet" => "Create new sheet",
// "TikiSheet" => "TikiSheet",
// "Edit Sheet" => "Edit Sheet",
// "Show Pages" => "Show Pages",
// "Search criteria" => "Search criteria",
// "Maximum amount of results displayed" => "Maximum amount of results displayed",
// "name|desc" => "name|desc",
// "Skype" => "Skype",
// "Name or number to call or chat with" => "Name or number to call or chat with",
// "Snarf" => "Snarf",
// "Include the content of a remote HTTP page. Regular expression selecting the content portion to include must be specified" => "Include the content of a remote HTTP page. Regular expression selecting the content portion to include must be specified",
// "Full URL to the page to include" => "Full URL to the page to include",
// "PCRE compliant regular expression" => "PCRE compliant regular expression",
// "Regular Expression Part" => "Regular Expression Part",
// "ex: \$1" => "ex: \$1",
// "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace" => "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace",
// "This data is put in a CODE caption" => "This data is put in a CODE caption",
// "Missing url parameter for SNARF plugin" => "Missing url parameter for SNARF plugin",
// "Sorts the plugin content in the wiki page" => "Sorts the plugin content in the wiki page",
// "Data to sort, one entry per line" => "Data to sort, one entry per line",
// "asc|desc|shuffle" => "asc|desc|shuffle",
// "Split a page into rows and columns" => "Split a page into rows and columns",
// "Join Columns" => "Join Columns",
// "Generate the colspan attribute if columns are missing" => "Generate the colspan attribute if columns are missing",
// "Fixed Size" => "Fixed Size",
// "Generate the width attribute on the columns" => "Generate the width attribute on the columns",
// "Column Size" => "Column Size",
// "Editable" => "Editable",
// "Display edit icon for each section" => "Display edit icon for each section",
// "Custom class" => "Custom class",
// "add a class to customize the design" => "add a class to customize the design",
// "row1col1" => "row1col1",
// "row1col2" => "row1col2",
// "row2col1" => "row2col1",
// "row2col2" => "row2col2",
// "SQL" => "SQL",
// "Run a sql query" => "Run a sql query",
// "sql query" => "sql query",
// "DNS Name" => "DNS Name",
// "ADODB DNS" => "ADODB DNS",
// "Missing db param" => "Missing db param",
// "Stat" => "Stat",
// "Displays some stats" => "Displays some stats",
// "separated by " => "separated by ",
// "Parent Id" => "Parent Id",
// "Added last hour" => "Added last hour",
// "Added last 24 hours" => "Added last 24 hours",
// "Added since the beginning of the day" => "Added since the beginning of the day",
// "Added(a) or viewed(v) since the beginning of the day" => "Added(a) or viewed(v) since the beginning of the day",
// "Added last 7 days" => "Added last 7 days",
// "Added(a) or viewed(v) last 7 days" => "Added(a) or viewed(v) last 7 days",
// "Added since the beginning of the week" => "Added since the beginning of the week",
// "Added(a) or viewed(v) since the beginning of the week" => "Added(a) or viewed(v) since the beginning of the week",
// "Added last month" => "Added last month",
// "Added(a) or viewed(v) last month" => "Added(a) or viewed(v) last month",
// "Added since the beginning of the month" => "Added since the beginning of the month",
// "Added(a) or viewed(v) since the beginning of the month" => "Added(a) or viewed(v) since the beginning of the month",
// "Added last year" => "Added last year",
// "Added(a) or viewed(v) last year" => "Added(a) or viewed(v) last year",
// "Added since the beginning of the year" => "Added since the beginning of the year",
// "Added(a) or viewed(v) since the beginning of the year" => "Added(a) or viewed(v) since the beginning of the year",
// "Subscript" => "Subscript",
// "Displays text in subscript" => "Displays text in subscript",
// "Subscribe or unsubscribe to a group" => "Subscribe or unsubscribe to a group",
// "Subscribe Group" => "Subscribe Group",
// "Group Name" => "Group Name",
// "As known in Tikiwiki" => "As known in Tikiwiki",
// "Subscribe Text" => "Subscribe Text",
// "Subscribe text, containing %s as the placeholder for the group name" => "Subscribe text, containing %s as the placeholder for the group name",
// "Unsubscribe Text" => "Unsubscribe Text",
// "Unsubscribe text, containing %s as the placeholder for the group name" => "Unsubscribe text, containing %s as the placeholder for the group name",
// "Subscribe Action" => "Subscribe Action",
// "Subscribe button label, containing %s as the placeholder for the group name" => "Subscribe button label, containing %s as the placeholder for the group name",
// "Unsubscribe Action" => "Unsubscribe Action",
// "Unsubscribe button label, containing %s as the placeholder for the group name" => "Unsubscribe button label, containing %s as the placeholder for the group name",
// "Subscribe Groups" => "Subscribe Groups",
// "Show subscribe box" => "Show subscribe box",
// "Show default setting and buttons" => "Show default setting and buttons",
// "Show group description" => "Show group description",
// "Colon separated list of groups" => "Colon separated list of groups",
// "Url" => "Url",
// "After changing default" => "After changing default",
// "Superscript" => "Superscript",
// "Displays text in superscript (exponent)" => "Displays text in superscript (exponent)",
// "Displays text in superscript" => "Displays text in superscript",
// "Wiki Page to redirect the user after his vote" => "Wiki Page to redirect the user after his vote",
// "Displays a survey" => "Displays a survey",
// "Tabs" => "Tabs",
// "Provides tabs built using the smarty tabset block" => "Provides tabs built using the smarty tabset block",
// "Tabs content separated by /////" => "Tabs content separated by /////",
// "Tabset name" => "Tabset name",
// "Unique tabset name (if you want it to remember its last state). Ex: user_profile_tabs" => "Unique tabset name (if you want it to remember its last state). Ex: user_profile_tabs",
// "Tab titles" => "Tab titles",
// "Pipe separated list of tab titles. Ex: tab 1|tab 2|tab 3" => "Pipe separated list of tab titles. Ex: tab 1|tab 2|tab 3",
// "Displays a set of tabs" => "Displays a set of tabs",
// "No tab title specified. At least one has to be set to make the tabs appear" => "No tab title specified. At least one has to be set to make the tabs appear",
// "Tag" => "Tag",
// "Displays the text between an html tag" => "Displays the text between an html tag",
// "Tag Name" => "Tag Name",
// "Any valid HTML tag, span by default" => "Any valid HTML tag, span by default",
// "Equivalent to the style attribute of an HTML tag" => "Equivalent to the style attribute of an HTML tag",
// "Displays text between HTML tags" => "Displays text between HTML tags",
// "Displays the thumbnail for an image" => "Displays the thumbnail for an image",
// "File ID from the file gallery" => "File ID from the file gallery",
// "Image ID from the image gallery" => "Image ID from the image gallery",
// "URL to the image" => "URL to the image",
// "Maximum Size" => "Maximum Size",
// "Maximum width or height for the image" => "Maximum width or height for the image",
// "Floating" => "Floating",
// "Link target of the image" => "Link target of the image",
// "No image specified" => "No image specified",
// "Title Search" => "Title Search",
// "Search wiki page titles" => "Search wiki page titles",
// "Search Criteria" => "Search Criteria",
// "Portion of a page name" => "Portion of a page name",
// "hits|user" => "hits|user",
// "Pipe-separated list of page names to exclude from results" => "Pipe-separated list of page names to exclude from results",
// "Search the titles of all pages in this wiki" => "Search the titles of all pages in this wiki",
// "No pages found for title search" => "No pages found for title search",
// "One page found for title search" => "One page found for title search",
// "pages found for title search" => "pages found for title search",
// "Table of Contents (Structure)" => "Table of Contents (Structure)",
// "Displays the table of contents for the current structure\\'s subtree as part of the page content" => "Displays the table of contents for the current structure\\'s subtree as part of the page content",
// "Maximum Depth" => "Maximum Depth",
// "Maximum number of levels to display. On very large structures, this should be limited" => "Maximum number of levels to display. On very large structures, this should be limited",
// "By default, structure for the current page will be displayed. Alternate structure may be provided" => "By default, structure for the current page will be displayed. Alternate structure may be provided",
// "asc|desc" => "asc|desc",
// "Show Description" => "Show Description",
// "0|1, show the page description instead of the page name" => "0|1, show the page description instead of the page name",
// "Show Numbering" => "Show Numbering",
// "0|1, display the section numbers or not" => "0|1, display the section numbers or not",
// "plain|fancy" => "plain|fancy",
// "Top Friends" => "Top Friends",
// "List top-scoring users" => "List top-scoring users",
// "Maximum result count" => "Maximum result count",
// "Public" => "Public",
// "Translate a string using Tikiwiki translation table" => "Translate a string using Tikiwiki translation table",
// "string" => "string",
// "Translate a string" => "Translate a string",
// "Fields" => "Fields",
// "Colon-separated list of field IDs to be displayed. Example: 2:4:5" => "Colon-separated list of field IDs to be displayed. Example: 2:4:5",
// "Label on the submit button" => "Label on the submit button",
// "Show Title" => "Show Title",
// "Show Mandatory" => "Show Mandatory",
// "Embedded" => "Embedded",
// "template" => "template",
// "URL used for the field links" => "URL used for the field links",
// "Url target" => "Url target",
// "Values" => "Values",
// "Colon-separated list of values" => "Colon-separated list of values",
// "Note that plugin arguments can be enclosed with double quotes \"; this allows them to contain , or " => "Note that plugin arguments can be enclosed with double quotes \"; this allows them to contain , or ",
// "preview" => "preview",
// "Label for the reset button, to return all fields to their default values" => "Label for the reset button, to return all fields to their default values",
// "user|page" => "user|page",
// "itemId" => "itemId",
// "itemId if you want to edit an item" => "itemId if you want to edit an item",
// "Template File" => "Template File",
// "Name of the template used to display the tracker items" => "Name of the template used to display the tracker items",
// "Name of the wiki page containing the template to display the tracker items" => "Name of the wiki page containing the template to display the tracker items",
// "New Status" => "New Status",
// "Default status applied to newly created items" => "Default status applied to newly created items",
// "Width of first column " => "Width of first column ",
// "Specify the width in pixels or percentage of the first column in the tracker form" => "Specify the width in pixels or percentage of the first column in the tracker form",
// "Incorrect fieldId" => "Incorrect fieldId",
// "Following fields are incorrect" => "Following fields are incorrect",
// "Displays an input form for tracker submit" => "Displays an input form for tracker submit",
// "You do not have permission to insert an item" => "You do not have permission to insert an item",
// "You do not have permission to modify an item" => "You do not have permission to modify an item",
// "Fields marked with a * are mandatory" => "Fields marked with a * are mandatory",
// "Filters" => "Filters",
// "Display List" => "Display List",
// "Line" => "Line",
// "Tracker Filter" => "Tracker Filter",
// "notice" => "notice",
// "tracker field type not processed yet" => "tracker field type not processed yet",
// "Filters the items of a tracker, fields are indicated with numeric ids" => "Filters the items of a tracker, fields are indicated with numeric ids",
// "Tracker Item Field" => "Tracker Item Field",
// "Wiki text containing an {ELSE} marker" => "Wiki text containing an {ELSE} marker",
// "Item ID" => "Item ID",
// "Field ID" => "Field ID",
// "Colon separated list of field IDs" => "Colon separated list of field IDs",
// "o|p|c|op|oc|pc|opc" => "o|p|c|op|oc|pc|opc",
// "Value to compare against" => "Value to compare against",
// "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)" => "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)",
// "Tracker List" => "Tracker List",
// "Displays the output of a tracker content, fields are indicated with numeric ids" => "Displays the output of a tracker content, fields are indicated with numeric ids",
// "Notice" => "Notice",
// "Colon-separated list of fields to display on click. Example: 6:7" => "Colon-separated list of fields to display on click. Example: 6:7",
// "Sticky Popup" => "Sticky Popup",
// "Show Links" => "Show Links",
// "shownbitems" => "shownbitems",
// "Show Initials" => "Show Initials",
// "Show Status" => "Show Status",
// "Show Creation Date" => "Show Creation Date",
// "Show Last Modification" => "Show Last Modification",
// "Show Field Name" => "Show Field Name",
// "Show Item Rank" => "Show Item Rank",
// "Status Filter" => "Status Filter",
// "Which item status to list. o = open, p = pending, c = closed" => "Which item status to list. o = open, p = pending, c = closed",
// "Sort Mode" => "Sort Mode",
// "Maximum number of items" => "Maximum number of items",
// "Show pagination" => "Show pagination",
// "Filter Field" => "Filter Field",
// "Colon separated list of fields to allow filtering on" => "Colon separated list of fields to allow filtering on",
// "Filter Value" => "Filter Value",
// "Exact Value" => "Exact Value",
// "Checkbox" => "Checkbox",
// "goIfOne" => "goIfOne",
// "More URL" => "More URL",
// "More Url" => "More Url",
// "Select automatically the item of the current user or the page" => "Select automatically the item of the current user or the page",
// "View User" => "View User",
// "Item ID separated with " => "Item ID separated with ",
// "List of items Ids" => "List of items Ids",
// "link url" => "link url",
// "Left Deliminator" => "Left Deliminator",
// "Right Deliminator" => "Right Deliminator",
// "Mode" => "Mode",
// "If y, value will be truncated" => "If y, value will be truncated",
// "Export Button" => "Export Button",
// "Compute" => "Compute",
// "Sum or average all the values of a field  and displays it at the bottom of the table" => "Sum or average all the values of a field  and displays it at the bottom of the table",
// "fieldId" => "fieldId",
// "Show nothing if no items" => "Show nothing if no items",
// "incorrect filterfield" => "incorrect filterfield",
// "Error in tracker ID" => "Error in tracker ID",
// "No field indicated" => "No field indicated",
// "Displays a button to link to a page with a tracker plugin with prefilled tracker fields" => "Displays a button to link to a page with a tracker plugin with prefilled tracker fields",
// "Tracker Prefill" => "Tracker Prefill",
// "Tracker page name" => "Tracker page name",
// "Button label" => "Button label",
// "Field 1" => "Field 1",
// "Value 1" => "Value 1",
// "Content of the field" => "Content of the field",
// "Field 2" => "Field 2",
// "Value 2" => "Value 2",
// "Field 3" => "Field 3",
// "Value 3" => "Value 3",
// "Field 4" => "Field 4",
// "Value 4" => "Value 4",
// "Field 5" => "Field 5",
// "Value 5" => "Value 5",
// "Tracker Stats" => "Tracker Stats",
// "Show link to tiki-view_tracker" => "Show link to tiki-view_tracker",
// "Displays some stat of a tracker content, fields are indicated with numeric ids" => "Displays some stat of a tracker content, fields are indicated with numeric ids",
// "incorrect fieldId" => "incorrect fieldId",
// "Tracker Timeline" => "Tracker Timeline",
// "Timeline view of a tracker, can be used to display event schedules or gantt charts" => "Timeline view of a tracker, can be used to display event schedules or gantt charts",
// "Title Field" => "Title Field",
// "Tracker Field ID containing the item title" => "Tracker Field ID containing the item title",
// "Summary Field" => "Summary Field",
// "Tracker Field ID containing the summary of the item. The summary will be displayed on the timeline when the item is focused" => "Tracker Field ID containing the summary of the item. The summary will be displayed on the timeline when the item is focused",
// "Start Date" => "Start Date",
// "Tracker Field ID containing the element start date. The field must be a datetime/jscalendar field" => "Tracker Field ID containing the element start date. The field must be a datetime/jscalendar field",
// "End Date" => "End Date",
// "Tracker Field ID containing the element end date. The field must be a datetime/jscalendar field" => "Tracker Field ID containing the element end date. The field must be a datetime/jscalendar field",
// "Element Group" => "Element Group",
// "Tracker Field ID containing the element\\'s group. Elements of a same group are displayed on the same row" => "Tracker Field ID containing the element\\'s group. Elements of a same group are displayed on the same row",
// "Lower Bound" => "Lower Bound",
// "Date from which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format" => "Date from which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format",
// "Upper Bound" => "Upper Bound",
// "Date until which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format" => "Date until which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format",
// "Primary Scale Unit" => "Primary Scale Unit",
// "hour, day, week, month or year (default to hour)" => "hour, day, week, month or year (default to hour)",
// "Secondary Scale Unit" => "Secondary Scale Unit",
// "hour, day, week, month, year or empty (default to empty)" => "hour, day, week, month, year or empty (default to empty)",
// "Link Group Name" => "Link Group Name",
// "Convert the group name to a link. (y|n)" => "Convert the group name to a link. (y|n)",
// "Page Link Field" => "Page Link Field",
// "Tracker Field ID containing the page name for item details" => "Tracker Field ID containing the page name for item details",
// "Missing parameter: %0" => "Missing parameter: %0",
// "Start date after end date" => "Start date after end date",
// "Translated" => "Translated",
// "Links to a translated content" => "Links to a translated content",
// "[url] or ((wikiname)) or ((inter:interwiki)) (use wiki syntax)" => "[url] or ((wikiname)) or ((inter:interwiki)) (use wiki syntax)",
// "Two letter language code of the language, ex: fr" => "Two letter language code of the language, ex: fr",
// "Country name, ex: France" => "Country name, ex: France",
// "User Count" => "User Count",
// "Displays the number of registered users" => "Displays the number of registered users",
// "Group name" => "Group name",
// "Display the user\\'s real name instead of login name" => "Display the user\\'s real name instead of login name",
// "Userpref" => "Userpref",
// "Display wiki text if user has a pref set to a value" => "Display wiki text if user has a pref set to a value",
// "Split the text in parts visible only under some conditions" => "Split the text in parts visible only under some conditions",
// "Block of text separated by ---(version x)--- markers. Text before the first marker is used by default" => "Block of text separated by ---(version x)--- markers. Text before the first marker is used by default",
// "Navigation" => "Navigation",
// "Displays a navigation box that allows users to select a specific version to display" => "Displays a navigation box that allows users to select a specific version to display",
// "Display the current version name as the title. Note: Do not work when nav=>y" => "Display the current version name as the title. Note: Do not work when nav=>y",
// "Specifies version label to show when displaying the page for the first time. e.g. \\'Default\\'" => "Specifies version label to show when displaying the page for the first time. e.g. \\'Default\\'",
// "This is the default text" => "This is the default text",
// "(version 3)" => "(version 3)",
// "This is version 3 info" => "This is version 3 info",
// "(version 2)" => "(version 2)",
// "This is version 2 info" => "This is version 2 info",
// "(version 1)" => "(version 1)",
// "This is version 1 info" => "This is version 1 info",
// "Show Stats" => "Show Stats",
// "Show Stats After" => "Show Stats After",
// "Show Creator" => "Show Creator",
// "Wanted Pages" => "Wanted Pages",
// "Custom level regex. A custom filter for wanted pages to be listed (only used when level=>custom).\n\t\tpossible values: a valid regex-expression (PCRE)" => "Custom level regex. A custom filter for wanted pages to be listed (only used when level=>custom).\n\t\tpossible values: a valid regex-expression (PCRE)",
// "Ignore" => "Ignore",
// "Split By" => "Split By",
// "Skip Extension" => "Skip Extension",
// "Collect" => "Collect",
// "Lists ''wanted'' Wiki pages: " => "Lists ''wanted'' Wiki pages: ",
// "Page-Pattern" => "Page-Pattern",
// "Custom-Level-Regex" => "Custom-Level-Regex",
// "__key__ | __default__ | __comments__\n" => "__key__ | __default__ | __comments__\n",
// "empty string" => "empty string",
// "A wildcard pattern of originating pages to be ignored" => "A wildcard pattern of originating pages to be ignored",
// "(refer to PHP function fnmatch() for details)\n" => "(refer to PHP function fnmatch() for details)\n",
// "The character, by which ignored patterns are separated" => "The character, by which ignored patterns are separated",
// "possible values: characters\n" => "possible values: characters\n",
// "Whether to include external wikis in the list" => "Whether to include external wikis in the list",
// "possible values: " => "possible values: ",
// "Collect either originating or wanted pages in a cell and display them in the second column" => "Collect either originating or wanted pages in a cell and display them in the second column",
// "Switch-on debug output with details about the items" => "Switch-on debug output with details about the items",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell",
// "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex" => "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex",
// "A custom filter for wanted pages to be listed (only used when level=>custom)" => "A custom filter for wanted pages to be listed (only used when level=>custom)",
// "a valid regex-expression (PCRE)" => "a valid regex-expression (PCRE)",
// "Lists ''wanted'' wiki pages" => "Lists ''wanted'' wiki pages",
// "A wildcard pattern of originating pages to be ignored. (refer to PHP fuction fnmatch() for details)" => "A wildcard pattern of originating pages to be ignored. (refer to PHP fuction fnmatch() for details)",
// "The character, by which ignored patterns are separated. possible values: characters" => "The character, by which ignored patterns are separated. possible values: characters",
// "Whether to include external wikis in the list. possible values" => "Whether to include external wikis in the list. possible values",
// "Collect either originating or wanted pages in a cell and display them in the second column. possible values" => "Collect either originating or wanted pages in a cell and display them in the second column. possible values",
// "Switch-on debug output with details about the items. possible values" => "Switch-on debug output with details about the items. possible values",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell. possible values" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell. possible values",
// "non-valid custom regex" => "non-valid custom regex",
// ", " => ", ",
// "dash-WikiWord" => "dash-WikiWord",
// "WikiWord" => "WikiWord",
// "not in level" => "not in level",
// "End of debug output" => "End of debug output",
// "Referenced By Page" => "Referenced By Page",
// "Web Service" => "Web Service",
// "Obtains and display remote information exposed in JSON or YAML. The plugin can be used to display registered or unregistered services. Registered services may use more parameters not defined in this interface" => "Obtains and display remote information exposed in JSON or YAML. The plugin can be used to display registered or unregistered services. Registered services may use more parameters not defined in this interface",
// "Template to apply to the data provided. Template format uses smarty templating engine using double brackets as delimiter. Output must provide wiki syntax. Body can be sent to a parameter instead by using the bodyname parameter" => "Template to apply to the data provided. Template format uses smarty templating engine using double brackets as delimiter. Output must provide wiki syntax. Body can be sent to a parameter instead by using the bodyname parameter",
// "Complete service URL" => "Complete service URL",
// "Service Name" => "Service Name",
// "Registered service name" => "Registered service name",
// "Template Name" => "Template Name",
// "For use with registered services, name of the template to be used to display the service output. This parameter will be ignored if a body is provided" => "For use with registered services, name of the template to be used to display the service output. This parameter will be ignored if a body is provided",
// "Body as Parameter" => "Body as Parameter",
// "Name of the argument to send the body as for services with complex input. Named service required for this to be useful" => "Name of the argument to send the body as for services with complex input. Named service required for this to be useful",
// "Unknown Template" => "Unknown Template",
// "Unknown Service" => "Unknown Service",
// "Missing parameters" => "Missing parameters",
// "Youtube" => "Youtube",
// "Display youtube video in a wiki page" => "Display youtube video in a wiki page",
// "URL to the Youtube video" => "URL to the Youtube video",
// "quality" => "quality",
// "Missing parameter movie to the youtube plugin" => "Missing parameter movie to the youtube plugin",
// "Cannot create aliased page" => "Cannot create aliased page",
// "You attempted to create the following page" => "You attempted to create the following page",
// "That page is an alias for the following pages" => "That page is an alias for the following pages",
// "If you want to create the page, you must first edit each the pages above, and remove the alias link it may contain. This link should look something like this" => "If you want to create the page, you must first edit each the pages above, and remove the alias link it may contain. This link should look something like this",
// "Can't parse HTML data - no grammar file" => "Can't parse HTML data - no grammar file",
// "Removed version \$version" => "Removed version \$version",
// "Changed actual version to \$version" => "Changed actual version to \$version",
// "Plugin " => "Plugin ",
// "Semantic token already exists" => "Semantic token already exists",
// "Invalid semantic token name" => "Invalid semantic token name",
// "Semantic token not found" => "Semantic token not found",
// "ERROR: Either the subject or body must be non-empty" => "ERROR: Either the subject or body must be non-empty",
// "User %s does not have the permission" => "User %s does not have the permission",
// "The message has been sent to" => "The message has been sent to",
// "The message will be sent to" => "The message will be sent to",
// "ERROR: No valid users to send the message" => "ERROR: No valid users to send the message",
// "User %s does not want to receive messages" => "User %s does not want to receive messages",
// "Sent box is full. Archive or delete some sent messages first if you want to send more messages" => "Sent box is full. Archive or delete some sent messages first if you want to send more messages",
// "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'" => "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'",
// "User %s can not receive messages, mailbox is full" => "User %s can not receive messages, mailbox is full",
// "User %s can not receive messages" => "User %s can not receive messages",
// "Invalid user: %s" => "Invalid user: %s",
// "Message will be sent to: " => "Message will be sent to: ",
// "Archive is full. Delete some messages from archive first" => "Archive is full. Delete some messages from archive first",
// "No more messages" => "No more messages",
// "Displays a calendar of system events, such as wiki page modifications, forum posts and article publications. Days with events show links to the action calendar page" => "Displays a calendar of system events, such as wiki page modifications, forum posts and article publications. Days with events show links to the action calendar page",
// "Item types filter" => "Item types filter",
// "If set to a list of item types, restricts the items displayed to those of one of these types. Each set is a comma-separated list of item type codes" => "If set to a list of item types, restricts the items displayed to those of one of these types. Each set is a comma-separated list of item type codes",
// "Possible item type values" => "Possible item type values",
// "Google AdSense" => "Google AdSense",
// "Displays a text/image Google AdSense advertisement. This module should be updated to support new Google code" => "Displays a text/image Google AdSense advertisement. This module should be updated to support new Google code",
// "Advertisement channel, as optionally provided by Google" => "Advertisement channel, as optionally provided by Google",
// "As provided by Google. Format: \"pub-xxxxxxxxxxxxxxxx\"" => "As provided by Google. Format: \"pub-xxxxxxxxxxxxxxxx\"",
// "Global banner format as provided by Google. For example: \"display=468*60_as\"" => "Global banner format as provided by Google. For example: \"display=468*60_as\"",
// "Background color, as optionally provided by Google" => "Background color, as optionally provided by Google",
// "Border color, as optionally provided by Google" => "Border color, as optionally provided by Google",
// "Link color, as optionally provided by Google" => "Link color, as optionally provided by Google",
// "Text color, as optionally provided by Google" => "Text color, as optionally provided by Google",
// "URL color, as optionally provided by Google" => "URL color, as optionally provided by Google",
// "Article archives" => "Article archives",
// "Shows links to the published articles for each month" => "Shows links to the published articles for each month",
// "If set to \"y\", displays a button labelled \"More...\" that links to a paginated view of the selected articles" => "If set to \"y\", displays a button labelled \"More...\" that links to a paginated view of the selected articles",
// "Default: \"n\"" => "Default: \"n\"",
// "Category filter" => "Category filter",
// "If set to a category identifier, only consider the articles in the specified category" => "If set to a category identifier, only consider the articles in the specified category",
// "Example value: 13" => "Example value: 13",
// "Not set by default" => "Not set by default",
// "Topic filter (by names)" => "Topic filter (by names)",
// "If set to a list of article topic names separated by plus signs, only consider the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not considered" => "If set to a list of article topic names separated by plus signs, only consider the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not considered",
// "Example values" => "Example values",
// "Topic filter (by identifiers)" => "Topic filter (by identifiers)",
// "If set to a list of article topic identifiers separated by plus signs, only consider the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not considered" => "If set to a list of article topic identifiers separated by plus signs, only consider the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not considered",
// "Example values: 13, !13, 1+3, !1+5+7" => "Example values: 13, !13, 1+3, !1+5+7",
// "Types filter" => "Types filter",
// "If set to a list of article type names separated by plus signs, only consider the articles of the specified types. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles of the specified article types are not considered" => "If set to a list of article type names separated by plus signs, only consider the articles of the specified types. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles of the specified article types are not considered",
// "Example values: Event, !Event, Event+Review, !Event+Classified+Article" => "Example values: Event, !Event, Event+Review, !Event+Classified+Article",
// "Language filter" => "Language filter",
// "If set to a language code, only consider the articles in the specified language" => "If set to a language code, only consider the articles in the specified language",
// "Article Topics" => "Article Topics",
// "Lists all article topics with links to their articles" => "Lists all article topics with links to their articles",
// "Lists the specified number of published articles in the specified order" => "Lists the specified number of published articles in the specified order",
// "Show publication time" => "Show publication time",
// "If set to \"y\", article publication times are shown" => "If set to \"y\", article publication times are shown",
// "Show creation time" => "Show creation time",
// "If set to \"y\", article creation times are shown" => "If set to \"y\", article creation times are shown",
// "Show rating selector" => "Show rating selector",
// "If set to \"y\", offers the user to filter articles based on a minimum and a maximum rating" => "If set to \"y\", offers the user to filter articles based on a minimum and a maximum rating",
// "If set, displays an image for each article if one applies, with the given width (in pixels). The article\\'s own image is used, with a fallback to the article\\'s topic image" => "If set, displays an image for each article if one applies, with the given width (in pixels). The article\\'s own image is used, with a fallback to the article\\'s topic image",
// "If set to a category identifier, only lists the articles in the specified category" => "If set to a category identifier, only lists the articles in the specified category",
// "If set to a list of article topic names separated by plus signs, only lists the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not listed" => "If set to a list of article topic names separated by plus signs, only lists the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not listed",
// "If set to a list of article topic identifiers separated by plus signs, only lists the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not listed" => "If set to a list of article topic identifiers separated by plus signs, only lists the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not listed",
// "If set to a list of article type names separated by plus signs, only lists the articles of the specified types. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles of the specified article types are not listed" => "If set to a list of article type names separated by plus signs, only lists the articles of the specified types. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles of the specified article types are not listed",
// "If set to a language code, only lists the articles in the specified language" => "If set to a language code, only lists the articles in the specified language",
// "Specifies how the articles should be sorted" => "Specifies how the articles should be sorted",
// "Possible values include created and created_asc (equivalent), created_desc, author, rating, topicId, lang and title. Unless \"_desc\" is specified, the sort is ascending. \"created\" sorts on article creation date" => "Possible values include created and created_asc (equivalent), created_desc, author, rating, topicId, lang and title. Unless \"_desc\" is specified, the sort is ascending. \"created\" sorts on article creation date",
// "If set to an integer, offsets the articles list by the given number. For example, if the module was otherwise set to list the 10 articles most recently published, setting the offset to 10 would make the module list the 11th to 20th articles in descending order of publication time instead" => "If set to an integer, offsets the articles list by the given number. For example, if the module was otherwise set to list the 10 articles most recently published, setting the offset to 10 would make the module list the 11th to 20th articles in descending order of publication time instead",
// "If set to \"y\", displays a button labelled \"More\" that links to a paginated view of the selected articles" => "If set to \"y\", displays a button labelled \"More\" that links to a paginated view of the selected articles",
// "Absolute URL" => "Absolute URL",
// "If set to \"y\", some of the links use an absolute URL instead of a relative one. This can avoid broken links if the module is to be sent in a newsletter, for example" => "If set to \"y\", some of the links use an absolute URL instead of a relative one. This can avoid broken links if the module is to be sent in a newsletter, for example",
// "TikiWiki assistant" => "TikiWiki assistant",
// "Displays an assistant to guide new Tiki admins" => "Displays an assistant to guide new Tiki admins",
// "Last blog post comments" => "Last blog post comments",
// "Displays the specified number of the blog post comments most recently added" => "Displays the specified number of the blog post comments most recently added",
// "More in tooltips" => "More in tooltips",
// "If set to \"y\", the post on which a comment is made is not displayed in the module box, but instead moved in the item\\'s tooltip" => "If set to \"y\", the post on which a comment is made is not displayed in the module box, but instead moved in the item\\'s tooltip",
// "No date" => "No date",
// "If set to \"y\", the date at which comments were posted is not displayed in the module box" => "If set to \"y\", the date at which comments were posted is not displayed in the module box",
// "Last visited pages" => "Last visited pages",
// "Displays the last Wiki pages visited by the user" => "Displays the last Wiki pages visited by the user",
// "Maximum length" => "Maximum length",
// "Maximum number of characters in page names allowed before truncating" => "Maximum number of characters in page names allowed before truncating",
// "Includes a calendar or a list of calendar events" => "Includes a calendar or a list of calendar events",
// "Displayed month (relative)" => "Displayed month (relative)",
// "Distance in month to the month to display. A distance of -1 would display the previous month. Setting this option implies a calendar view type with a month time span" => "Distance in month to the month to display. A distance of -1 would display the previous month. Setting this option implies a calendar view type with a month time span",
// "Displays links to categories as a tree" => "Displays links to categories as a tree",
// "Object type filter" => "Object type filter",
// "Object type filter to apply when accessing a linked category. Example values" => "Object type filter to apply when accessing a linked category. Example values",
// "Deep" => "Deep",
// "Show subcategories objects when accessing a linked category. Possible values: on (default), off" => "Show subcategories objects when accessing a linked category. Possible values: on (default), off",
// "PHP Layers menu style" => "PHP Layers menu style",
// "Sets the menu style if PHP Layers is enabled. Possible values: tree (default), vert, horiz, plain, phptree" => "Sets the menu style if PHP Layers is enabled. Possible values: tree (default), vert, horiz, plain, phptree",
// "Limits displayed categories to a subtree of categories starting with the category with the given ID. Example value: 11. Default: 0 (don\\'t limit display)" => "Limits displayed categories to a subtree of categories starting with the category with the given ID. Example value: 11. Default: 0 (don\\'t limit display)",
// "Category Transitions" => "Category Transitions",
// "Displays controls to trigger category transitions and change the page\\'s state according to predefined rules" => "Displays controls to trigger category transitions and change the page\\'s state according to predefined rules",
// "Change Category" => "Change Category",
// "Enables to categorize an object" => "Enables to categorize an object",
// "Category identifier" => "Category identifier",
// "Changes the root of the displayed categories from default \"TOP\" to the category with the given identifier" => "Changes the root of the displayed categories from default \"TOP\" to the category with the given identifier",
// "Note that the root category is not displayed" => "Note that the root category is not displayed",
// "Defaults to 0 (root)" => "Defaults to 0 (root)",
// "No top" => "No top",
// "In non-detailed view, disallow uncategorizing. Example value: 1" => "In non-detailed view, disallow uncategorizing. Example value: 1",
// "Display path" => "Display path",
// "Instead of category names, diplay their path in the category tree starting from the category root defined" => "Instead of category names, diplay their path in the category tree starting from the category root defined",
// "Example value: 1" => "Example value: 1",
// "Multiple categories" => "Multiple categories",
// "If set to \"n\", only allows categorizing in one category (from those displayed)" => "If set to \"n\", only allows categorizing in one category (from those displayed)",
// "String to display on the button to submit new categories, when multiple categories is enabled. Default value: Categorize" => "String to display on the button to submit new categories, when multiple categories is enabled. Default value: Categorize",
// "Shy" => "Shy",
// "If set to \"y\", the module is not shown on pages which are not already categorized.' . \" \" . tra('Not set by default" => "If set to \"y\", the module is not shown on pages which are not already categorized.' . \" \" . tra('Not set by default",
// "Detailed" => "Detailed",
// "If set to \"y\", shows a list of categories in which the object is. If deletion is not disabled, it is done with the list" => "If set to \"y\", shows a list of categories in which the object is. If deletion is not disabled, it is done with the list",
// "If set to \"n\", the detailed list of categories will not offer to unassign a category" => "If set to \"n\", the detailed list of categories will not offer to unassign a category",
// "If set to \"y\", allow to assign new categories" => "If set to \"y\", allow to assign new categories",
// "Example values: y, n" => "Example values: y, n",
// "Default value: y" => "Default value: y",
// "Default value: n" => "Default value: n",
// "Image URL not in category" => "Image URL not in category",
// "Very particular parameter. If both this and \"Image URL in the category\" are set and the root category contains a single child category, the module only displays an image with this URL if the object is not in the category" => "Very particular parameter. If both this and \"Image URL in the category\" are set and the root category contains a single child category, the module only displays an image with this URL if the object is not in the category",
// "Example value" => "Example value",
// "Image URL in category" => "Image URL in category",
// "Very particular parameter. If both this and \"Image URL not in the category\" are set and the root category contains a single child category, the module only displays an image with this URL if the object is in the category" => "Very particular parameter. If both this and \"Image URL not in the category\" are set and the root category contains a single child category, the module only displays an image with this URL if the object is in the category",
// "Categorize %s" => "Categorize %s",
// "Displays the number of pages received (via Communications)" => "Displays the number of pages received (via Communications)",
// "Last directory sites" => "Last directory sites",
// "Displays the specified number of the directory sites most recently added" => "Displays the specified number of the directory sites most recently added",
// "Directory category identifier" => "Directory category identifier",
// "If set to a directory category identifier, only displays the sites in the specified directory category" => "If set to a directory category identifier, only displays the sites in the specified directory category",
// "If set to \"y\", displays a button labelled \"More\" that links to the directory" => "If set to \"y\", displays a button labelled \"More\" that links to the directory",
// "Directory statistics" => "Directory statistics",
// "Displays statistics about the directory, including the number of sites validated and to validate, the number of categories, of searches and of visited links" => "Displays statistics about the directory, including the number of sites validated and to validate, the number of categories, of searches and of visited links",
// "Top directory sites" => "Top directory sites",
// "Displays the specified number of the directory sites from most visited to least visited" => "Displays the specified number of the directory sites from most visited to least visited",
// "Displays the site\\'s first featured links" => "Displays the site\\'s first featured links",
// "Displays links to file galleries" => "Displays links to file galleries",
// "Best rated topics" => "Best rated topics",
// "Displays the specified number of the forum topics with the best ratings" => "Displays the specified number of the forum topics with the best ratings",
// "Displays the latest forum posts" => "Displays the latest forum posts",
// "If set to \"y\", only displays topics" => "If set to \"y\", only displays topics",
// "Displays the specified number of the forums with the most comments" => "Displays the specified number of the forums with the most comments",
// "Displays the specified number of the forum topics with the most reads" => "Displays the specified number of the forum topics with the most reads",
// "Displays the specified number of the forums with the most visits" => "Displays the specified number of the forums with the most visits",
// "Freetags editor" => "Freetags editor",
// "Shows current freetags and enables to add and remove some if permissions allow" => "Shows current freetags and enables to add and remove some if permissions allow",
// "Freetags Wiki" => "Freetags Wiki",
// "Displays current freetags on wiki pages and enables to add tags if permissions allow" => "Displays current freetags on wiki pages and enables to add tags if permissions allow",
// "Similar freetags" => "Similar freetags",
// "Shows wiki pages with similar freetags" => "Shows wiki pages with similar freetags",
// "Similar pages" => "Similar pages",
// "Shows the most popular freetags. More popularity is indicated by a larger font" => "Shows the most popular freetags. More popularity is indicated by a larger font",
// "Display type" => "Display type",
// "If set to \"cloud\", links are displayed as a cloud" => "If set to \"cloud\", links are displayed as a cloud",
// "Default: \"list\"" => "Default: \"list\"",
// "Maximum elements" => "Maximum elements",
// "If set to a number, limits the number of tags displayed" => "If set to a number, limits the number of tags displayed",
// "User preferred tags" => "User preferred tags",
// "Displays to registered users the freetags they prefer, based on the number of objects they added the tag to. More preference is indicated by a larger font" => "Displays to registered users the freetags they prefer, based on the number of objects they added the tag to. More preference is indicated by a larger font",
// "Displays a simple form to search on Google. By default, search results are limited to those on the Tiki site" => "Displays a simple form to search on Google. By default, search results are limited to those on the Tiki site",
// "Groups emulation" => "Groups emulation",
// "Enables temporarily changing one\\'s group memberships to see how users in fewer groups experience the site" => "Enables temporarily changing one\\'s group memberships to see how users in fewer groups experience the site",
// "Emulate Groups" => "Emulate Groups",
// "Displays the specified number of last actions" => "Displays the specified number of last actions",
// "Show user" => "Show user",
// "If set to \"y\", user names are displayed in the module box" => "If set to \"y\", user names are displayed in the module box",
// "Show date" => "Show date",
// "If set to \"y\", action dates are displayed in the module box" => "If set to \"y\", action dates are displayed in the module box",
// "Maximum number of characters in action descriptions before truncating" => "Maximum number of characters in action descriptions before truncating",
// "Lists the specified number of blogs posts from newest to oldest" => "Lists the specified number of blogs posts from newest to oldest",
// "If set to \"y\", the date of posts is not displayed in the module box" => "If set to \"y\", the date of posts is not displayed in the module box",
// "Blog identifier" => "Blog identifier",
// "If set to a blog identifier, restricts the blog posts to those in the identified blog" => "If set to a blog identifier, restricts the blog posts to those in the identified blog",
// "Last category objects" => "Last category objects",
// "Lists the specified number of objects of the given type in the given category, starting from the most recently created" => "Lists the specified number of objects of the given type in the given category, starting from the most recently created",
// "Identifier of the category from which objects are listed. Objects merely in child categories will not be displayed" => "Identifier of the category from which objects are listed. Objects merely in child categories will not be displayed",
// "Maximum number of characters in object names allowed before truncating" => "Maximum number of characters in object names allowed before truncating",
// "Type of the objects to list. Example values" => "Type of the objects to list. Example values",
// "no object here yet" => "no object here yet",
// "Displays the specified number of blogs from newest to oldest" => "Displays the specified number of blogs from newest to oldest",
// "Displays the specified number of FAQs from newest to oldest" => "Displays the specified number of FAQs from newest to oldest",
// "Displays the specified number of quizzes from newest to oldest" => "Displays the specified number of quizzes from newest to oldest",
// "Last modified file galleries" => "Last modified file galleries",
// "Displays the specified number of file galleries, starting from the most recently modified" => "Displays the specified number of file galleries, starting from the most recently modified",
// "List the specified number of files, starting from the most recently added" => "List the specified number of files, starting from the most recently added",
// "Gallery identifiers" => "Gallery identifiers",
// "If set to a set of file gallery identifiers, restricts the files to those in the identified galleries. The value is a colon-separated sequence of integers" => "If set to a set of file gallery identifiers, restricts the files to those in the identified galleries. The value is a colon-separated sequence of integers",
// "Example value: 13, 2:13, 1:2:3:5:6" => "Example value: 13, 2:13, 1:2:3:5:6",
// "Last modified image galleries" => "Last modified image galleries",
// "Displays the specified number of image galleries, starting from the most recently modified" => "Displays the specified number of image galleries, starting from the most recently modified",
// "List the specified number of images, starting from the most recently added" => "List the specified number of images, starting from the most recently added",
// "Gallery identifier" => "Gallery identifier",
// "If set to an image gallery identifier, restricts the images to those in the identified gallery" => "If set to an image gallery identifier, restricts the images to those in the identified gallery",
// "Link content" => "Link content",
// "Display the links as image names or thumbnails" => "Display the links as image names or thumbnails",
// "Possible values: \"names\" or \"thumbnails\". Default value: \"names\"" => "Possible values: \"names\" or \"thumbnails\". Default value: \"names\"",
// "Last modified events" => "Last modified events",
// "Displays the specified number of calendar events, starting from the most recently modified" => "Displays the specified number of calendar events, starting from the most recently modified",
// "Calendar identifier" => "Calendar identifier",
// "If set to a calendar identifier, restricts the events to those in the identified calendar" => "If set to a calendar identifier, restricts the events to those in the identified calendar",
// "Maximum number of characters in event names allowed before truncating" => "Maximum number of characters in event names allowed before truncating",
// "Lists the specified number of pages, starting from the most recently modified" => "Lists the specified number of pages, starting from the most recently modified",
// "Link target" => "Link target",
// "Target URL of the \"...more\" link at the bottom of the module" => "Target URL of the \"...more\" link at the bottom of the module",
// "Last Modified blogs" => "Last Modified blogs",
// "Displays the specified number of blogs, starting from the most recently modified" => "Displays the specified number of blogs, starting from the most recently modified",
// "Last submissions" => "Last submissions",
// "Lists the specified number of article submissions from newest to oldest" => "Lists the specified number of article submissions from newest to oldest",
// "Last tracker comments" => "Last tracker comments",
// "Lists the specified number of tracker comments (optionally restricting to those in a specific tracker or tracker item) starting from the most recently posted" => "Lists the specified number of tracker comments (optionally restricting to those in a specific tracker or tracker item) starting from the most recently posted",
// "Tracker identifier" => "Tracker identifier",
// "If set to a tracker identifier, only displays the comments on the given tracker" => "If set to a tracker identifier, only displays the comments on the given tracker",
// "Item identifier" => "Item identifier",
// "If set to an item identifier, only displays the comments on the given item" => "If set to an item identifier, only displays the comments on the given item",
// "Last tracker items" => "Last tracker items",
// "Displays the value of a field of the specified number of tracker items. If the specified tracker has no main field, either Field name or Field identifier is required" => "Displays the value of a field of the specified number of tracker items. If the specified tracker has no main field, either Field name or Field identifier is required",
// "Identifier of the tracker from which items are listed" => "Identifier of the tracker from which items are listed",
// "Field identifier" => "Field identifier",
// "Identifier of the field from which values are listed. If Field name is set, this parameter is ignored" => "Identifier of the field from which values are listed. If Field name is set, this parameter is ignored",
// "Field name" => "Field name",
// "Name of the field from which values are listed" => "Name of the field from which values are listed",
// "Example value: age" => "Example value: age",
// "Specifies how the items should be sorted" => "Specifies how the items should be sorted",
// "Possible values include created and created_asc (equivalent), created_desc, status, lastModif, createdBy and lastModifBy. Unless \"_desc\" is specified, the sort is ascending. \"created\" sorts on item creation date. \"lastModif\" sorts on the last modification date of items. \"lastModif_desc\" sorts in descending order of last modification date" => "Possible values include created and created_asc (equivalent), created_desc, status, lastModif, createdBy and lastModifBy. Unless \"_desc\" is specified, the sort is ascending. \"created\" sorts on item creation date. \"lastModif\" sorts on the last modification date of items. \"lastModif_desc\" sorts in descending order of last modification date",
// "Status filter" => "Status filter",
// "If set, limits the listed items to those with the given statuses. Values are combinations of \"o\" (open), \"p\" (pending) and \"c\" (closed). Possible values" => "If set, limits the listed items to those with the given statuses. Values are combinations of \"o\" (open), \"p\" (pending) and \"c\" (closed). Possible values",
// "Unable to determine which field to show. Tracker identifier may be invalid, or the tracker has no main field and neither Field identifier nor Field name were set" => "Unable to determine which field to show. Tracker identifier may be invalid, or the tracker has no main field and neither Field identifier nor Field name were set",
// "You do not have permission to view this tracker" => "You do not have permission to view this tracker",
// "Last Modified Items" => "Last Modified Items",
// "Last Validated FAQs Questions" => "Last Validated FAQs Questions",
// "Displays the specified number of validated questions FAQs from newest to oldest" => "Displays the specified number of validated questions FAQs from newest to oldest",
// "Faq identifier" => "Faq identifier",
// "If set to a faq identifier, restricts the chosen questions to those in the identified faq" => "If set to a faq identifier, restricts the chosen questions to those in the identified faq",
// "Number of characters to display" => "Number of characters to display",
// "Displays information about the specified number of users in decreasing order of last login time" => "Displays information about the specified number of users in decreasing order of last login time",
// "Show avatars" => "Show avatars",
// "If set to \"y\", show user avatars" => "If set to \"y\", show user avatars",
// "Maximum number of characters in user names allowed before truncating" => "Maximum number of characters in user names allowed before truncating",
// "Tells users whether a live support operator is present and allows them to request support if possible. If the user is an operator, links to the operator console" => "Tells users whether a live support operator is present and allows them to request support if possible. If the user is an operator, links to the operator console",
// "Login box" => "Login box",
// "Input size" => "Input size",
// "Number of characters for username and password input fields" => "Number of characters for username and password input fields",
// "Logo" => "Logo",
// "Site logo, title and subtitle" => "Site logo, title and subtitle",
// "Menu page" => "Menu page",
// "Displays a Wiki page" => "Displays a Wiki page",
// "Page to display in the menu. Example value: HomePage" => "Page to display in the menu. Example value: HomePage",
// "Unread inter-user messages" => "Unread inter-user messages",
// "Displays to users their number of new inter-user messages and a link to their message box" => "Displays to users their number of new inter-user messages and a link to their message box",
// "Small live chat box" => "Small live chat box",
// "Channels" => "Channels",
// "List of chat channels. Channel names are separated by a comma (\",\")" => "List of chat channels. Channel names are separated by a comma (\",\")",
// "By default, a single channel named \"default\" exists" => "By default, a single channel named \"default\" exists",
// "Months links" => "Months links",
// "Links to the objects of a given type for the current month and those preceding it" => "Links to the objects of a given type for the current month and those preceding it",
// "Type of objects to link to" => "Type of objects to link to",
// "\"blogs\" for blog posts, \"cms\" for published articles" => "\"blogs\" for blog posts, \"cms\" for published articles",
// "Object identifier" => "Object identifier",
// "Identifier of an object with children to link to" => "Identifier of an object with children to link to",
// "This is required for the blog Object type" => "This is required for the blog Object type",
// "For example, an identifier of 3 and a blogs Object type will show links to the blog posts in the blog with identifier 3" => "For example, an identifier of 3 and a blogs Object type will show links to the blog posts in the blog with identifier 3",
// "List by month" => "List by month",
// "Waiting Submissions" => "Waiting Submissions",
// "Displays the number of article submissions waiting examination and a link to the list" => "Displays the number of article submissions waiting examination and a link to the list",
// "Displays the specified number of old articles (which do not show on articles home page anymore)" => "Displays the specified number of old articles (which do not show on articles home page anymore)",
// "Enables to change current perspective" => "Enables to change current perspective",
// "Quick Edit" => "Quick Edit",
// "Enables to quickly create or edit Wiki pages" => "Enables to quickly create or edit Wiki pages",
// "Template identifier" => "Template identifier",
// "If set to a template identifier, the specified template is used for creating new Wiki pages" => "If set to a template identifier, the specified template is used for creating new Wiki pages",
// "If set, send the form to the given location (relative to Tiki\\'s root) for processing" => "If set, send the form to the given location (relative to Tiki\\'s root) for processing",
// "SUBMIT label" => "SUBMIT label",
// "The label on the button to submit the form" => "The label on the button to submit the form",
// "Size attribute (horizontal, in characters) of the text input field for page names" => "Size attribute (horizontal, in characters) of the text input field for page names",
// "Optional heading to display at the top of the module\\'s content" => "Optional heading to display at the top of the module\\'s content",
// "If set to a category identifier, pages created through the module are automatically categorized in the specified category" => "If set to a category identifier, pages created through the module are automatically categorized in the specified category",
// "Random image" => "Random image",
// "Displays a random image" => "Displays a random image",
// "If set to an image gallery identifier, restricts the chosen images to those in the identified gallery" => "If set to an image gallery identifier, restricts the chosen images to those in the identified gallery",
// "Show link" => "Show link",
// "If set to \"n\", the image thumbnail does not link to the image" => "If set to \"n\", the image thumbnail does not link to the image",
// "Default: \"y\"" => "Default: \"y\"",
// "Show name" => "Show name",
// "If set to \"y\", the name of the image is displayed" => "If set to \"y\", the name of the image is displayed",
// "If set to \"y\", the description of the image is displayed" => "If set to \"y\", the description of the image is displayed",
// "Random Pages" => "Random Pages",
// "Displays the specified number of random wiki pages" => "Displays the specified number of random wiki pages",
// "New user registrationmore tiki-re" => "New user registrationmore tiki-re",
// "Feeds List" => "Feeds List",
// "List of feeds available on this site" => "List of feeds available on this site",
// "Search Box" => "Search Box",
// "Advanced search (for wiki, articles, blogs etc)" => "Advanced search (for wiki, articles, blogs etc)",
// "Search Box (new)" => "Search Box (new)",
// "Search Wiki Page" => "Search Wiki Page",
// "Search for a wiki page by name" => "Search for a wiki page by name",
// "Search Wiki Page (new)" => "Search Wiki Page (new)",
// "Lists the relationships known for the Wiki page displayed. For each relation type contained in the page, it lists all the pages it links to or gets linked from" => "Lists the relationships known for the Wiki page displayed. For each relation type contained in the page, it lists all the pages it links to or gets linked from",
// "The shoutbox is a quick messaging tool. Messages reload each time the page changes. Anyone with the right permission can see all messages. Another permission allows to send messages" => "The shoutbox is a quick messaging tool. Messages reload each time the page changes. Anyone with the right permission can see all messages. Another permission allows to send messages",
// "Tooltip" => "Tooltip",
// "If set to \"1\", displays message post dates and times as tooltips instead of showing directly in the module content" => "If set to \"1\", displays message post dates and times as tooltips instead of showing directly in the module content",
// "Label on the button to post a message" => "Label on the button to post a message",
// "Wait label" => "Wait label",
// "Label on the button to post a message when the message is being posted if AJAX is enabled" => "Label on the button to post a message when the message is being posted if AJAX is enabled",
// "Maximum messages shown" => "Maximum messages shown",
// "Number of messages to display" => "Number of messages to display",
// "Please wait.." => "Please wait..",
// "Since last visit (simple)" => "Since last visit (simple)",
// "Displays to logged in users the number of new or updated objects since their last login date and time" => "Displays to logged in users the number of new or updated objects since their last login date and time",
// "Since last visit" => "Since last visit",
// "Displays to logged in users new or updated objects since a point in time, by default their last login date and time" => "Displays to logged in users new or updated objects since a point in time, by default their last login date and time",
// "Show users" => "Show users",
// "If set to \"n\", do not show new users" => "If set to \"n\", do not show new users",
// "Show trackers" => "Show trackers",
// "If set to \"n\", do not show tracker changes" => "If set to \"n\", do not show tracker changes",
// "Calendar focus" => "Calendar focus",
// "Unless set to \"ignore\", the module changes the reference point in time from the user\\'s last login date and time to a day where users browse to using the calendar" => "Unless set to \"ignore\", the module changes the reference point in time from the user\\'s last login date and time to a day where users browse to using the calendar",
// "Since your last visit.." => "Since your last visit..",
// "updated tracker items" => "updated tracker items",
// "Switch Language" => "Switch Language",
// "Displays a language picker to change the language of the site" => "Displays a language picker to change the language of the site",
// "Display mode" => "Display mode",
// "Changes how the list of languages is displayed. Possible values are droplist, flags and words. Defaults to droplist" => "Changes how the list of languages is displayed. Possible values are droplist, flags and words. Defaults to droplist",
// "Prefix" => "Prefix",
// "Changes the default displayed prefix from \\\"Site Language:\\\"" => "Changes the default displayed prefix from \\\"Site Language:\\\"",
// "Switch theme" => "Switch theme",
// "Enables to quickly change the theme" => "Enables to quickly change the theme",
// "Terminology" => "Terminology",
// "Support for multilingual terminology" => "Support for multilingual terminology",
// "Tiki Tests" => "Tiki Tests",
// "Tiki test suite helper" => "Tiki test suite helper",
// "Displays the specified number of blogs with links to them, from the most active one to the least" => "Displays the specified number of blogs with links to them, from the most active one to the least",
// "Blog activity measurement can be more or less accurate" => "Blog activity measurement can be more or less accurate",
// "Top articles" => "Top articles",
// "Lists the specified number of articles with links to them, from the most visited one to the least" => "Lists the specified number of articles with links to them, from the most visited one to the least",
// "Displays the specified number of file galleries with links to them, starting with the one with most hits" => "Displays the specified number of file galleries with links to them, starting with the one with most hits",
// "Top files" => "Top files",
// "Displays the specified number of files with links to them, starting with the one with most hits" => "Displays the specified number of files with links to them, starting with the one with most hits",
// "Top Forum Posters" => "Top Forum Posters",
// "Displays the specified number of users who posted to forums, starting with the one having most posts" => "Displays the specified number of users who posted to forums, starting with the one having most posts",
// "Top image galleries" => "Top image galleries",
// "Displays the specified number of image galleries with links to them, starting with the one with most hits" => "Displays the specified number of image galleries with links to them, starting with the one with most hits",
// "Top Images" => "Top Images",
// "Displays the specified number of images with links to them, from the most visited one to the least" => "Displays the specified number of images with links to them, from the most visited one to the least",
// "Top Objects" => "Top Objects",
// "Displays the specified number of objects, starting with the one having the most hits" => "Displays the specified number of objects, starting with the one having the most hits",
// "Top Pages" => "Top Pages",
// "Displays the specified number of wiki pages with links to them, starting with the one having the most hits" => "Displays the specified number of wiki pages with links to them, starting with the one having the most hits",
// "Top Quizzes" => "Top Quizzes",
// "Displays the specified number of quizzes with links to them, starting with the one having the most hits" => "Displays the specified number of quizzes with links to them, starting with the one having the most hits",
// "Displays the specified number of blogs with links to them, from the most visited one to the least" => "Displays the specified number of blogs with links to them, from the most visited one to the least",
// "Top Visited FAQs" => "Top Visited FAQs",
// "Displays the specified number of FAQs with links to them, from the most visited one to the least" => "Displays the specified number of FAQs with links to them, from the most visited one to the least",
// "Page translation" => "Page translation",
// "Links to versions of the wiki page being viewed in other languages, distinguishing between better, equivalent or worse translations. Optionally displays the up-to-dateness of the translation being viewed" => "Links to versions of the wiki page being viewed in other languages, distinguishing between better, equivalent or worse translations. Optionally displays the up-to-dateness of the translation being viewed",
// "Reference language" => "Reference language",
// "If set to a language code, restricts the localized pages shown to the reference page, unless that page is being displayed" => "If set to a language code, restricts the localized pages shown to the reference page, unless that page is being displayed",
// "Lists the specified number of calendar events, ordered by their start date" => "Lists the specified number of calendar events, ordered by their start date",
// "Calendars filter" => "Calendars filter",
// "If set to a list of calendar identifiers, restricts the events to those in the identified calendars. Identifiers are separated by vertical bars (\"|\"), commas (\",\") or colons (\":\")" => "If set to a list of calendar identifiers, restricts the events to those in the identified calendars. Identifiers are separated by vertical bars (\"|\"), commas (\",\") or colons (\":\")",
// "Maximum days in the future" => "Maximum days in the future",
// "Maximum distance to event start dates in days (looking forward)" => "Maximum distance to event start dates in days (looking forward)",
// "Maximum days in the past" => "Maximum days in the past",
// "Maximum distance to event end dates in days (looking backward)" => "Maximum distance to event end dates in days (looking backward)",
// "cellpadding" => "cellpadding",
// "cellspacing" => "cellspacing",
// "If set to \"y\", event descriptions are displayed" => "If set to \"y\", event descriptions are displayed",
// "Show end date and time" => "Show end date and time",
// "If set to \"y\", event end dates and times are displayed, when appropriate" => "If set to \"y\", event end dates and times are displayed, when appropriate",
// "Use custom calendar background colors" => "Use custom calendar background colors",
// "If set to \"y\", events are displayed with their calendar\\'s custom background color (if one is set)" => "If set to \"y\", events are displayed with their calendar\\'s custom background color (if one is set)",
// "Show information in tooltips" => "Show information in tooltips",
// "If set to \"n\", event tooltips will not display event information" => "If set to \"n\", event tooltips will not display event information",
// "Date format" => "Date format",
// "Format to use for most dates. See <a href=\"http://www.php.net/manual/en/function.strftime.php\">strftime() documentation</a>" => "Format to use for most dates. See <a href=\"http://www.php.net/manual/en/function.strftime.php\">strftime() documentation</a>",
// "site preference for short date format followed by site preference for short time format" => "site preference for short date format followed by site preference for short time format",
// "If set to an integer, event names are allowed that number of characters as a maximum before being truncated" => "If set to an integer, event names are allowed that number of characters as a maximum before being truncated",
// "User Blogs" => "User Blogs",
// "Displays to registered users their blogs" => "Displays to registered users their blogs",
// "Lightweight interface to user bookmarks, enabling to view them concisely, do some manipulations and bookmark the page being viewed" => "Lightweight interface to user bookmarks, enabling to view them concisely, do some manipulations and bookmark the page being viewed",
// "User image galleries" => "User image galleries",
// "Displays to registered users their image galleries" => "Displays to registered users their image galleries",
// "Displays to registered users the specified number of wiki pages which they were the last to edit" => "Displays to registered users the specified number of wiki pages which they were the last to edit",
// "Lightweight interface to user tasks, enabling to view them concisely and do some manipulations" => "Lightweight interface to user tasks, enabling to view them concisely and do some manipulations",
// "The task title must have at least 3 characters" => "The task title must have at least 3 characters",
// "Lists the public user tasks of a chosen group, with links to tasks" => "Lists the public user tasks of a chosen group, with links to tasks",
// "User-Group Tracker" => "User-Group Tracker",
// "User and Group tracker links" => "User and Group tracker links",
// "Displays the specified number of users and their score, starting from the one with the highest score" => "Displays the specified number of users and their score, starting from the one with the highest score",
// "Webmail Inbox" => "Webmail Inbox",
// "Displays Webmail Inbox" => "Displays Webmail Inbox",
// "Account Id" => "Account Id",
// "Webmail account identifier (if not set uses user\\'s current account)" => "Webmail account identifier (if not set uses user\\'s current account)",
// "GroupMail: Group (e.g. \"Help Team\")" => "GroupMail: Group (e.g. \"Help Team\")",
// "GroupMail: Tracker Id (to store GroupMail activity)" => "GroupMail: Tracker Id (to store GroupMail activity)",
// "GroupMail: From Field (Id of field in tracker to store email From header)" => "GroupMail: From Field (Id of field in tracker to store email From header)",
// "Subject Field Id" => "Subject Field Id",
// "GroupMail: Subject Field (Id of field in tracker to store email Subject header)" => "GroupMail: Subject Field (Id of field in tracker to store email Subject header)",
// "Message Field Id" => "Message Field Id",
// "GroupMail: Message Field (Id of field in tracker to store email message identifier)" => "GroupMail: Message Field (Id of field in tracker to store email message identifier)",
// "Content Field Id" => "Content Field Id",
// "GroupMail: Content Field (Id of field in tracker to store email message body content)" => "GroupMail: Content Field (Id of field in tracker to store email message body content)",
// "Account Field Id" => "Account Field Id",
// "GroupMail: Account Field (Id of field in tracker to store Webmail account name)" => "GroupMail: Account Field (Id of field in tracker to store Webmail account name)",
// "DateTime Field Id" => "DateTime Field Id",
// "GroupMail: Date Time Field (Id of field in tracker to store email sent timestamp)" => "GroupMail: Date Time Field (Id of field in tracker to store email sent timestamp)",
// "Operator Field Id" => "Operator Field Id",
// "GroupMail: Operator Field (Id of field in tracker to store operator name (username))" => "GroupMail: Operator Field (Id of field in tracker to store operator name (username))",
// "Maximum number of characters in subjects allowed before truncating" => "Maximum number of characters in subjects allowed before truncating",
// "Webmail error" => "Webmail error",
// "No accounts set up (or no current account set)" => "No accounts set up (or no current account set)",
// "Wiki Page" => "Wiki Page",
// "What is related" => "What is related",
// "Lists objects which share a category with the viewed object" => "Lists objects which share a category with the viewed object",
// "Online users" => "Online users",
// "Displays information about users currently logged in" => "Displays information about users currently logged in",
// "Content to display" => "Content to display",
// "Display the number of users logged in, the list of users logged in, or both" => "Display the number of users logged in, the list of users logged in, or both",
// "Possible values: \"count\", \"list\" or \"both\". Default value: \"both\"" => "Possible values: \"count\", \"list\" or \"both\". Default value: \"both\"",
// "Cluster mode" => "Cluster mode",
// "If set to \"1\", separate users based on which host/server they logged on" => "If set to \"1\", separate users based on which host/server they logged on",
// "Last comments" => "Last comments",
// "Lists the specified number of comments starting from the most recently posted" => "Lists the specified number of comments starting from the most recently posted",
// "If set to \"y\", the name of the object on which a comment is made is not displayed in the module box, but instead moved in the item\\'s tooltip" => "If set to \"y\", the name of the object on which a comment is made is not displayed in the module box, but instead moved in the item\\'s tooltip",
// "Type of the objects from which comments will be listed. Possible values" => "Type of the objects from which comments will be listed. Possible values",
// "Last article comments" => "Last article comments",
// "YouTube" => "YouTube",
// "Displays YouTube videos and/or a link to a YouTube user\\'s page" => "Displays YouTube videos and/or a link to a YouTube user\\'s page",
// "Video identifiers" => "Video identifiers",
// "List of YouTube videos identifiers to display. Identifiers are separated by a comma (\",\")" => "List of YouTube videos identifiers to display. Identifiers are separated by a comma (\",\")",
// "YouTube user identifier" => "YouTube user identifier",
// "If set to a YouTube user identifier, display a link to the videos of this user" => "If set to a YouTube user identifier, display a link to the videos of this user",
// "Width of each video in pixels" => "Width of each video in pixels",
// "Height of each video in pixels" => "Height of each video in pixels",
// "Videos on YouTube" => "Videos on YouTube",
// "Invalid server key" => "Invalid server key",
// "Cookie not found" => "Cookie not found",
// "Can create/admin calendars" => "Can create/admin calendars",
// "Can add events in the calendar" => "Can add events in the calendar",
// "Can change events in the calendar" => "Can change events in the calendar",
// "Can browse the calendar" => "Can browse the calendar",
// "Can view events details" => "Can view events details",
// "Can view Tikiwiki tools calendar" => "Can view Tikiwiki tools calendar",
// "Administrator, can create channels remove channels etc" => "Administrator, can create channels remove channels etc",
// "Can use the chat system" => "Can use the chat system",
// "Can admin the cms" => "Can admin the cms",
// "Can approve submissions" => "Can approve submissions",
// "Can admin article topics" => "Can admin article topics",
// "Can admin article types" => "Can admin article types",
// "Can read article headings" => "Can read article headings",
// "Submited articles automatically approved" => "Submited articles automatically approved",
// "Can edit articles" => "Can edit articles",
// "Can edit submissions" => "Can edit submissions",
// "Can read articles" => "Can read articles",
// "Can remove articles" => "Can remove articles",
// "Can remove submissions" => "Can remove submissions",
// "Can submit articles" => "Can submit articles",
// "Can read a topic (Applies only to individual topic perms)" => "Can read a topic (Applies only to individual topic perms)",
// "Can admin contributions" => "Can admin contributions",
// "Can admin the directory" => "Can admin the directory",
// "Can admin directory categories" => "Can admin directory categories",
// "Can admin directory sites" => "Can admin directory sites",
// "Submited links are valid" => "Submited links are valid",
// "Can submit sites to the directory" => "Can submit sites to the directory",
// "Can validate submited links" => "Can validate submited links",
// "Can use the directory" => "Can use the directory",
// "Can admin faqs" => "Can admin faqs",
// "Can suggest faq questions" => "Can suggest faq questions",
// "Can view faqs" => "Can view faqs",
// "Administrator, can manage users groups and permissions, Hotwords and all the weblog features" => "Administrator, can manage users groups and permissions, Hotwords and all the weblog features",
// "Can admin users" => "Can admin users",
// "Can access site when closed" => "Can access site when closed",
// "Administrator, can admin banners" => "Administrator, can admin banners",
// "Can ban users or ips" => "Can ban users or ips",
// "Can admin the dynamic content system" => "Can admin the dynamic content system",
// "Can admin integrator repositories and rules" => "Can admin integrator repositories and rules",
// "Can admin mail-in accounts" => "Can admin mail-in accounts",
// "Can edit object permissions" => "Can edit object permissions",
// "Can admin external feeds" => "Can admin external feeds",
// "Can clean cache" => "Can clean cache",
// "Can create new css suffixed with -user" => "Can create new css suffixed with -user",
// "Can remove association between two pages in a translation set" => "Can remove association between two pages in a translation set",
// "Can admin cookies" => "Can admin cookies",
// "Can edit translations and create new languages" => "Can edit translations and create new languages",
// "Can edit menu" => "Can edit menu",
// "Can edit menu option" => "Can edit menu option",
// "Can edit site templates" => "Can edit site templates",
// "Can search" => "Can search",
// "Can report a link to the webmaster" => "Can report a link to the webmaster",
// "Can subscribe to groups" => "Can subscribe to groups",
// "Can send a link to a friend" => "Can send a link to a friend",
// "Can use HTML in pages" => "Can use HTML in pages",
// "Can view action log" => "Can view action log",
// "Can view action log for users of his own groups" => "Can view action log for users of his own groups",
// "Can view integrated repositories" => "Can view integrated repositories",
// "Can view referer stats" => "Can view referer stats",
// "Can view site stats" => "Can view site stats",
// "Can view site templates" => "Can view site templates",
// "Can admin blogs" => "Can admin blogs",
// "Can assign perms to blog" => "Can assign perms to blog",
// "Can post to a blog" => "Can post to a blog",
// "Can create a blog" => "Can create a blog",
// "Can read blogs" => "Can read blogs",
// "Can admin file galleries" => "Can admin file galleries",
// "Can assign perms to file gallery" => "Can assign perms to file gallery",
// "Can use Directory Batch Load" => "Can use Directory Batch Load",
// "Can upload zip files with files" => "Can upload zip files with files",
// "Can create file galleries" => "Can create file galleries",
// "Can download files" => "Can download files",
// "Can edit a gallery file" => "Can edit a gallery file",
// "Can list file galleries" => "Can list file galleries",
// "Can upload files" => "Can upload files",
// "Can view file galleries explorer" => "Can view file galleries explorer",
// "Can view file galleries path" => "Can view file galleries path",
// "Can view file galleries" => "Can view file galleries",
// "Can admin forums" => "Can admin forums",
// "Can attach to forum posts" => "Can attach to forum posts",
// "Auto approve forum posts" => "Auto approve forum posts",
// "Can edit own forum posts" => "Can edit own forum posts",
// "Can post in forums" => "Can post in forums",
// "Can start threads in forums" => "Can start threads in forums",
// "Can read forums" => "Can read forums",
// "Can report msgs to moderator" => "Can report msgs to moderator",
// "Can vote comments in forums" => "Can vote comments in forums",
// "Can admin freetags" => "Can admin freetags",
// "Can admin Image Galleries" => "Can admin Image Galleries",
// "Can assign perms to image gallery" => "Can assign perms to image gallery",
// "Can upload zip files with images" => "Can upload zip files with images",
// "Can create image galleries" => "Can create image galleries",
// "Can tag objects" => "Can tag objects",
// "Can list image galleries" => "Can list image galleries",
// "Can unassign tags from an object" => "Can unassign tags from an object",
// "Can upload images" => "Can upload images",
// "Can browse freetags" => "Can browse freetags",
// "Can view image galleries" => "Can view image galleries",
// "Can admin newsletters" => "Can admin newsletters",
// "Can subscribe many e-mails at once (requires tiki_p_subscribe email)" => "Can subscribe many e-mails at once (requires tiki_p_subscribe email)",
// "Can send newsletters" => "Can send newsletters",
// "Can subscribe any email to newsletters" => "Can subscribe any email to newsletters",
// "Can subscribe to newsletters" => "Can subscribe to newsletters",
// "Can list newsletters" => "Can list newsletters",
// "Can admin polls" => "Can admin polls",
// "Can view poll results" => "Can view poll results",
// "Can vote polls" => "Can vote polls",
// "Can view poll voters" => "Can view poll voters",
// "Can admin toolbars" => "Can admin toolbars",
// "Can admin quizzes" => "Can admin quizzes",
// "Can take quizzes" => "Can take quizzes",
// "Can view quiz stats" => "Can view quiz stats",
// "Can view user quiz results" => "Can view user quiz results",
// "Can admin sheet" => "Can admin sheet",
// "Can create and edit sheets" => "Can create and edit sheets",
// "Can view sheet" => "Can view sheet",
// "Can view sheet history" => "Can view sheet history",
// "Can admin shoutbox (Edit/remove msgs)" => "Can admin shoutbox (Edit/remove msgs)",
// "Can post messages in shoutbox" => "Can post messages in shoutbox",
// "Can view shoutbox" => "Can view shoutbox",
// "Can admin surveys" => "Can admin surveys",
// "Can take surveys" => "Can take surveys",
// "Can view survey stats" => "Can view survey stats",
// "Can admin trackers" => "Can admin trackers",
// "Can attach files to tracker items" => "Can attach files to tracker items",
// "Can insert comments for tracker items" => "Can insert comments for tracker items",
// "Can view tracker items comments" => "Can view tracker items comments",
// "Can create new items for trackers" => "Can create new items for trackers",
// "Can list trackers" => "Can list trackers",
// "Can change tracker items" => "Can change tracker items",
// "Can change tracker pending items" => "Can change tracker pending items",
// "Can change tracker closed items" => "Can change tracker closed items",
// "Can view rating result for tracker items" => "Can view rating result for tracker items",
// "Can vote a rating for tracker items" => "Can vote a rating for tracker items",
// "Can view trackers" => "Can view trackers",
// "Can view trackers closed items" => "Can view trackers closed items",
// "Can view trackers pending items" => "Can view trackers pending items",
// "Can watch tracker" => "Can watch tracker",
// "Can export tracker items" => "Can export tracker items",
// "Can admin the wiki" => "Can admin the wiki",
// "Can assign perms to wiki pages" => "Can assign perms to wiki pages",
// "Can edit pages" => "Can edit pages",
// "Can edit copyright notices" => "Can edit copyright notices",
// "Can edit dynamic variables" => "Can edit dynamic variables",
// "Can create and edit structures" => "Can create and edit structures",
// "Can export wiki pages using the export feature" => "Can export wiki pages using the export feature",
// "Can lock pages" => "Can lock pages",
// "Can save as minor edit" => "Can save as minor edit",
// "Can remove" => "Can remove",
// "Can rename pages" => "Can rename pages",
// "Can rollback pages" => "Can rollback pages",
// "Can upload pictures to wiki pages" => "Can upload pictures to wiki pages",
// "Can use the page as a tracker template" => "Can use the page as a tracker template",
// "Can view page/pages" => "Can view page/pages",
// "Can watch structure" => "Can watch structure",
// "Can admin attachments to wiki pages" => "Can admin attachments to wiki pages",
// "Can add and change ratings on wiki pages" => "Can add and change ratings on wiki pages",
// "Can attach files to wiki pages" => "Can attach files to wiki pages",
// "Can view wiki attachments and download" => "Can view wiki attachments and download",
// "Can view wiki comments" => "Can view wiki comments",
// "Can view wiki history" => "Can view wiki history",
// "Can view rating of wiki pages" => "Can view rating of wiki pages",
// "Can view source of wiki pages" => "Can view source of wiki pages",
// "Can participate to rating of wiki pages" => "Can participate to rating of wiki pages",
// "Can view similar wiki pages" => "Can view similar wiki pages",
// "Can admin received articles" => "Can admin received articles",
// "Can admin received pages" => "Can admin received pages",
// "Can send articles to other sites" => "Can send articles to other sites",
// "Can send articles to this site" => "Can send articles to this site",
// "Can send pages to this site" => "Can send pages to this site",
// "Can send pages to other sites" => "Can send pages to other sites",
// "Can admin the TikiTests" => "Can admin the TikiTests",
// "Can edit TikiTests" => "Can edit TikiTests",
// "Can replay the TikiTests" => "Can replay the TikiTests",
// "Can cache user bookmarks" => "Can cache user bookmarks",
// "Can configure modules" => "Can configure modules",
// "Can create user bookmarks" => "Can create user bookmarks",
// "Can use the mini event calendar" => "Can use the mini event calendar",
// "Can use the notepad" => "Can use the notepad",
// "Can admin public tasks" => "Can admin public tasks",
// "Can use tasks" => "Can use tasks",
// "Can receive tasks from other users" => "Can receive tasks from other users",
// "Can send tasks to other users" => "Can send tasks to other users",
// "Can upload personal files" => "Can upload personal files",
// "Can create items in personal menu" => "Can create items in personal menu",
// "Can broadcast messages to all user" => "Can broadcast messages to all user",
// "Can broadcast messages to groups" => "Can broadcast messages to groups",
// "Can use the messaging system" => "Can use the messaging system",
// "Can admin comments" => "Can admin comments",
// "Can edit all comments" => "Can edit all comments",
// "Can post new comments" => "Can post new comments",
// "Can read comments" => "Can read comments",
// "Can delete comments" => "Can delete comments",
// "Can vote comments" => "Can vote comments",
// "Can admin content templates" => "Can admin content templates",
// "Can edit content templates" => "Can edit content templates",
// "Can use content templates" => "Can use content templates",
// "Can edit HTML pages" => "Can edit HTML pages",
// "Can view HTML pages" => "Can view HTML pages",
// "Can list registered users" => "Can list registered users",
// "Admin live support system" => "Admin live support system",
// "Can use live support system" => "Can use live support system",
// "Can create new mapfile" => "Can create new mapfile",
// "Can delete mapfiles" => "Can delete mapfiles",
// "Can edit mapfiles" => "Can edit mapfiles",
// "Can view mapfiles" => "Can view mapfiles",
// "Can view contents of mapfiles" => "Can view contents of mapfiles",
// "Can use webmail" => "Can use webmail",
// "Can use group webmail" => "Can use group webmail",
// "Can administrate group webmail accounts" => "Can administrate group webmail accounts",
// "Can use personal webmail accounts" => "Can use personal webmail accounts",
// "Can administrate personal webmail accounts" => "Can administrate personal webmail accounts",
// "Can view unapproved plugin details" => "Can view unapproved plugin details",
// "Can execute unapproved plugin" => "Can execute unapproved plugin",
// "Can approve plugin execution" => "Can approve plugin execution",
// "Trust all user inputs (no security checks)" => "Trust all user inputs (no security checks)",
// "View page backlinks" => "View page backlinks",
// "Can admin mail notifications" => "Can admin mail notifications",
// "Can invite user in groups" => "Can invite user in groups",
// "Can delete his own account" => "Can delete his own account",
// "Can use the Tiki Importer" => "Can use the Tiki Importer",
// "Can admin categories" => "Can admin categories",
// "Can see the category in a listing" => "Can see the category in a listing",
// "Can change the categories on the object" => "Can change the categories on the object",
// "Can add objects in the category" => "Can add objects in the category",
// "Can remove objects from the category" => "Can remove objects from the category",
// "Can create new categories" => "Can create new categories",
// "Can view the perspective" => "Can view the perspective",
// "Can view the group" => "Can view the group",
// "Can view the group members" => "Can view the group members",
// "Can add group members" => "Can add group members",
// "Can remove group members" => "Can remove group members",
// "Can join or leave the group" => "Can join or leave the group",
// "Can trigger the transition between two states" => "Can trigger the transition between two states",
// "Can admin kaltura feature" => "Can admin kaltura feature",
// "Can upload video on kaltura server" => "Can upload video on kaltura server",
// "Can edit information of kaltura entry" => "Can edit information of kaltura entry",
// "Can create kaltura remix video" => "Can create kaltura remix video",
// "Can delete kaltura entry" => "Can delete kaltura entry",
// "Can download kaltura entry" => "Can download kaltura entry",
// "Can list kaltura entries" => "Can list kaltura entries",
// "Can view kaltura entry" => "Can view kaltura entry",
// "Can upload screencasts to wiki pages" => "Can upload screencasts to wiki pages",
// "tiki release" => "tiki release",
// "feature version checks" => "feature version checks",
// "tiki needs upgrade" => "tiki needs upgrade",
// "tiki version last check" => "tiki version last check",
// "tiki version check frequency" => "tiki version check frequency",
// "lastUpdatePrefs" => "lastUpdatePrefs",
// "feature print indexed" => "feature print indexed",
// "groups are emulated" => "groups are emulated",
// "feature wiki" => "feature wiki",
// "default wiki diff style" => "default wiki diff style",
// "feature backlinks" => "feature backlinks",
// "feature dump" => "feature dump",
// "feature history" => "feature history",
// "feature lastChanges" => "feature lastChanges",
// "feature likePages" => "feature likePages",
// "feature listPages" => "feature listPages",
// "feature listorphanPages" => "feature listorphanPages",
// "feature listorphanStructure" => "feature listorphanStructure",
// "feature page title" => "feature page title",
// "feature sandbox" => "feature sandbox",
// "feature warn on edit" => "feature warn on edit",
// "feature wiki 1like redirection" => "feature wiki 1like redirection",
// "feature wiki allowhtml" => "feature wiki allowhtml",
// "feature wiki argvariable" => "feature wiki argvariable",
// "feature wiki attachments" => "feature wiki attachments",
// "feature wiki comments" => "feature wiki comments",
// "feature wiki description" => "feature wiki description",
// "feature wiki discuss" => "feature wiki discuss",
// "feature wiki export" => "feature wiki export",
// "feature wiki structure" => "feature wiki structure",
// "feature wiki import page" => "feature wiki import page",
// "feature wiki footnotes" => "feature wiki footnotes",
// "feature wiki icache" => "feature wiki icache",
// "feature wiki import html" => "feature wiki import html",
// "feature wiki mindmap" => "feature wiki mindmap",
// "feature wiki monosp" => "feature wiki monosp",
// "feature wiki multiprint" => "feature wiki multiprint",
// "feature wiki notepad" => "feature wiki notepad",
// "feature wiki make structure" => "feature wiki make structure",
// "feature wiki open as structure" => "feature wiki open as structure",
// "feature wiki pageid" => "feature wiki pageid",
// "feature wiki paragraph formatting" => "feature wiki paragraph formatting",
// "feature wiki paragraph formatting add br" => "feature wiki paragraph formatting add br",
// "feature wiki pictures" => "feature wiki pictures",
// "feature wiki plurals" => "feature wiki plurals",
// "feature wiki print" => "feature wiki print",
// "feature wiki protect email" => "feature wiki protect email",
// "feature wiki rankings" => "feature wiki rankings",
// "feature wiki ratings" => "feature wiki ratings",
// "feature wiki replace" => "feature wiki replace",
// "feature wiki show hide before" => "feature wiki show hide before",
// "feature wiki tables" => "feature wiki tables",
// "feature wiki templates" => "feature wiki templates",
// "feature wiki undo" => "feature wiki undo",
// "feature wiki userpage" => "feature wiki userpage",
// "feature wiki userpage prefix" => "feature wiki userpage prefix",
// "feature wiki usrlock" => "feature wiki usrlock",
// "feature wiki feedback polls" => "feature wiki feedback polls",
// "feature wiki save draft" => "feature wiki save draft",
// "feature wikiwords" => "feature wikiwords",
// "feature wikiwords usedash" => "feature wikiwords usedash",
// "feature wiki pagealias" => "feature wiki pagealias",
// "mailin autocheck" => "mailin autocheck",
// "mailin autocheckFreq" => "mailin autocheckFreq",
// "mailin autocheckLast" => "mailin autocheckLast",
// "page bar position" => "page bar position",
// "warn on edit time" => "warn on edit time",
// "wikiHomePage" => "wikiHomePage",
// "wikiLicensePage" => "wikiLicensePage",
// "wikiSubmitNotice" => "wikiSubmitNotice",
// "wiki authors style" => "wiki authors style",
// "wiki authors style by page" => "wiki authors style by page",
// "wiki dft list pages lang to current" => "wiki dft list pages lang to current",
// "wiki show version" => "wiki show version",
// "wiki bot bar" => "wiki bot bar",
// "wiki cache" => "wiki cache",
// "wiki comments default ordering" => "wiki comments default ordering",
// "wiki comments displayed default" => "wiki comments displayed default",
// "wiki comments per page" => "wiki comments per page",
// "wiki comments allow per page" => "wiki comments allow per page",
// "wiki creator admin" => "wiki creator admin",
// "wiki feature copyrights" => "wiki feature copyrights",
// "wiki forum id" => "wiki forum id",
// "wiki left column" => "wiki left column",
// "wiki list backlinks" => "wiki list backlinks",
// "wiki list comment" => "wiki list comment",
// "wiki list comment len" => "wiki list comment len",
// "wiki list description" => "wiki list description",
// "wiki list description len" => "wiki list description len",
// "wiki list creator" => "wiki list creator",
// "wiki list hits" => "wiki list hits",
// "wiki list lastmodif" => "wiki list lastmodif",
// "wiki list lastver" => "wiki list lastver",
// "wiki list links" => "wiki list links",
// "wiki list name" => "wiki list name",
// "wiki list name len" => "wiki list name len",
// "wiki list size" => "wiki list size",
// "wiki list status" => "wiki list status",
// "wiki list user" => "wiki list user",
// "wiki list versions" => "wiki list versions",
// "wiki list language" => "wiki list language",
// "wiki list categories" => "wiki list categories",
// "wiki list categories path" => "wiki list categories path",
// "wiki list id" => "wiki list id",
// "wiki list sortorder" => "wiki list sortorder",
// "wiki list sortdirection" => "wiki list sortdirection",
// "wiki pagealias tokens" => "wiki pagealias tokens",
// "wiki page regex" => "wiki page regex",
// "wiki page separator" => "wiki page separator",
// "wiki page navigation bar" => "wiki page navigation bar",
// "wiki actions bar" => "wiki actions bar",
// "wiki pagename strip" => "wiki pagename strip",
// "wiki right column" => "wiki right column",
// "wiki top bar" => "wiki top bar",
// "wiki topline position" => "wiki topline position",
// "wiki uses slides" => "wiki uses slides",
// "wiki watch author" => "wiki watch author",
// "wiki watch comments" => "wiki watch comments",
// "wiki watch editor" => "wiki watch editor",
// "wiki watch minor" => "wiki watch minor",
// "feature wiki history full" => "feature wiki history full",
// "feature wiki categorize structure" => "feature wiki categorize structure",
// "feature wiki watch structure" => "feature wiki watch structure",
// "feature wikiapproval" => "feature wikiapproval",
// "wikiapproval prefix" => "wikiapproval prefix",
// "wikiapproval hideprefix" => "wikiapproval hideprefix",
// "wikiapproval delete staging" => "wikiapproval delete staging",
// "wikiapproval master group" => "wikiapproval master group",
// "wikiapproval staging category" => "wikiapproval staging category",
// "wikiapproval approved category" => "wikiapproval approved category",
// "wikiapproval outofsync category" => "wikiapproval outofsync category",
// "wikiapproval block editapproved" => "wikiapproval block editapproved",
// "wikiapproval sync categories" => "wikiapproval sync categories",
// "wikiapproval update freetags" => "wikiapproval update freetags",
// "wikiapproval combine freetags" => "wikiapproval combine freetags",
// "wiki edit section" => "wiki edit section",
// "wiki edit section level" => "wiki edit section level",
// "wiki edit icons toggle" => "wiki edit icons toggle",
// "wiki edit plugin" => "wiki edit plugin",
// "wiki validate plugin" => "wiki validate plugin",
// "wiki edit minor" => "wiki edit minor",
// "feature pagelist" => "feature pagelist",
// "wikiplugin agentinfo" => "wikiplugin agentinfo",
// "wikiplugin alink" => "wikiplugin alink",
// "wikiplugin aname" => "wikiplugin aname",
// "wikiplugin annotation" => "wikiplugin annotation",
// "wikiplugin article" => "wikiplugin article",
// "wikiplugin articles" => "wikiplugin articles",
// "wikiplugin attach" => "wikiplugin attach",
// "wikiplugin avatar" => "wikiplugin avatar",
// "wikiplugin back" => "wikiplugin back",
// "wikiplugin backlinks" => "wikiplugin backlinks",
// "wikiplugin banner" => "wikiplugin banner",
// "wikiplugin bloglist" => "wikiplugin bloglist",
// "wikiplugin box" => "wikiplugin box",
// "wikiplugin calendar" => "wikiplugin calendar",
// "wikiplugin category" => "wikiplugin category",
// "wikiplugin catorphans" => "wikiplugin catorphans",
// "wikiplugin catpath" => "wikiplugin catpath",
// "wikiplugin center" => "wikiplugin center",
// "wikiplugin chart" => "wikiplugin chart",
// "wikiplugin code" => "wikiplugin code",
// "wikiplugin content" => "wikiplugin content",
// "wikiplugin cookie" => "wikiplugin cookie",
// "wikiplugin copyright" => "wikiplugin copyright",
// "wikiplugin countdown" => "wikiplugin countdown",
// "wikiplugin datachannel" => "wikiplugin datachannel",
// "wikiplugin dbreport" => "wikiplugin dbreport",
// "wikiplugin div" => "wikiplugin div",
// "wikiplugin dl" => "wikiplugin dl",
// "wikiplugin draw" => "wikiplugin draw",
// "wikiplugin equation" => "wikiplugin equation",
// "wikiplugin events" => "wikiplugin events",
// "wikiplugin fade" => "wikiplugin fade",
// "wikiplugin fancylist" => "wikiplugin fancylist",
// "wikiplugin fancytable" => "wikiplugin fancytable",
// "wikiplugin file" => "wikiplugin file",
// "wikiplugin files" => "wikiplugin files",
// "wikiplugin flash" => "wikiplugin flash",
// "wikiplugin footnote" => "wikiplugin footnote",
// "wikiplugin footnotearea" => "wikiplugin footnotearea",
// "wikiplugin ftp" => "wikiplugin ftp",
// "wikiplugin gauge" => "wikiplugin gauge",
// "wikiplugin googleanalytics" => "wikiplugin googleanalytics",
// "wikiplugin googledoc" => "wikiplugin googledoc",
// "wikiplugin group" => "wikiplugin group",
// "wikiplugin groupmailcore" => "wikiplugin groupmailcore",
// "wikiplugin groupstat" => "wikiplugin groupstat",
// "wikiplugin html" => "wikiplugin html",
// "wikiplugin iframe" => "wikiplugin iframe",
// "wikiplugin img" => "wikiplugin img",
// "wikiplugin image" => "wikiplugin image",
// "wikiplugin include" => "wikiplugin include",
// "wikiplugin invite" => "wikiplugin invite",
// "wikiplugin jabber" => "wikiplugin jabber",
// "wikiplugin js" => "wikiplugin js",
// "wikiplugin jq" => "wikiplugin jq",
// "wikiplugin lang" => "wikiplugin lang",
// "wikiplugin lastmod" => "wikiplugin lastmod",
// "wikiplugin listpages" => "wikiplugin listpages",
// "wikiplugin listprogress" => "wikiplugin listprogress",
// "wikiplugin lsdir" => "wikiplugin lsdir",
// "wikiplugin map" => "wikiplugin map",
// "wikiplugin mcalendar" => "wikiplugin mcalendar",
// "wikiplugin mediaplayer" => "wikiplugin mediaplayer",
// "wikiplugin memberlist" => "wikiplugin memberlist",
// "wikiplugin miniquiz" => "wikiplugin miniquiz",
// "wikiplugin module" => "wikiplugin module",
// "wikiplugin mono" => "wikiplugin mono",
// "wikiplugin mouseover" => "wikiplugin mouseover",
// "wikiplugin mwtable" => "wikiplugin mwtable",
// "wikiplugin myspace" => "wikiplugin myspace",
// "wikiplugin objecthits" => "wikiplugin objecthits",
// "wikiplugin pagelist" => "wikiplugin pagelist",
// "wikiplugin picture" => "wikiplugin picture",
// "wikiplugin pluginmanager" => "wikiplugin pluginmanager",
// "wikiplugin poll" => "wikiplugin poll",
// "wikiplugin profile" => "wikiplugin profile",
// "wikiplugin proposal" => "wikiplugin proposal",
// "wikiplugin quote" => "wikiplugin quote",
// "wikiplugin rcontent" => "wikiplugin rcontent",
// "wikiplugin realnamelist" => "wikiplugin realnamelist",
// "wikiplugin redirect" => "wikiplugin redirect",
// "wikiplugin regex" => "wikiplugin regex",
// "wikiplugin remarksbox" => "wikiplugin remarksbox",
// "wikiplugin rss" => "wikiplugin rss",
// "wikiplugin screencast" => "wikiplugin screencast",
// "wikiplugin sf" => "wikiplugin sf",
// "wikiplugin share" => "wikiplugin share",
// "wikiplugin sharethis" => "wikiplugin sharethis",
// "wikiplugin sheet" => "wikiplugin sheet",
// "wikiplugin showpages" => "wikiplugin showpages",
// "wikiplugin skype" => "wikiplugin skype",
// "wikiplugin snarf" => "wikiplugin snarf",
// "wikiplugin sort" => "wikiplugin sort",
// "wikiplugin split" => "wikiplugin split",
// "wikiplugin sql" => "wikiplugin sql",
// "wikiplugin stat" => "wikiplugin stat",
// "wikiplugin sub" => "wikiplugin sub",
// "wikiplugin subscribegroup" => "wikiplugin subscribegroup",
// "wikiplugin subscribegroups" => "wikiplugin subscribegroups",
// "wikiplugin sup" => "wikiplugin sup",
// "wikiplugin survey" => "wikiplugin survey",
// "wikiplugin tag" => "wikiplugin tag",
// "wikiplugin tabs" => "wikiplugin tabs",
// "wikiplugin thumb" => "wikiplugin thumb",
// "wikiplugin titlesearch" => "wikiplugin titlesearch",
// "wikiplugin toc" => "wikiplugin toc",
// "wikiplugin topfriends" => "wikiplugin topfriends",
// "wikiplugin trackerfilter" => "wikiplugin trackerfilter",
// "wikiplugin trackeritemfield" => "wikiplugin trackeritemfield",
// "wikiplugin trackerlist" => "wikiplugin trackerlist",
// "wikiplugin trackertimeline" => "wikiplugin trackertimeline",
// "wikiplugin tracker" => "wikiplugin tracker",
// "wikiplugin trackerprefill" => "wikiplugin trackerprefill",
// "wikiplugin trackerstat" => "wikiplugin trackerstat",
// "wikiplugin translated" => "wikiplugin translated",
// "wikiplugin tr" => "wikiplugin tr",
// "wikiplugin usercount" => "wikiplugin usercount",
// "wikiplugin userlist" => "wikiplugin userlist",
// "wikiplugin userpref" => "wikiplugin userpref",
// "wikiplugin versions" => "wikiplugin versions",
// "wikiplugin vote" => "wikiplugin vote",
// "wikiplugin wantedpages" => "wikiplugin wantedpages",
// "wikiplugin webservice" => "wikiplugin webservice",
// "wikiplugin youtube" => "wikiplugin youtube",
// "wikiplugininline agentinfo" => "wikiplugininline agentinfo",
// "wikiplugininline alink" => "wikiplugininline alink",
// "wikiplugininline aname" => "wikiplugininline aname",
// "wikiplugininline annotation" => "wikiplugininline annotation",
// "wikiplugininline article" => "wikiplugininline article",
// "wikiplugininline articles" => "wikiplugininline articles",
// "wikiplugininline attach" => "wikiplugininline attach",
// "wikiplugininline avatar" => "wikiplugininline avatar",
// "wikiplugininline back" => "wikiplugininline back",
// "wikiplugininline backlinks" => "wikiplugininline backlinks",
// "wikiplugininline banner" => "wikiplugininline banner",
// "wikiplugininline bloglist" => "wikiplugininline bloglist",
// "wikiplugininline box" => "wikiplugininline box",
// "wikiplugininline calendar" => "wikiplugininline calendar",
// "wikiplugininline category" => "wikiplugininline category",
// "wikiplugininline catorphans" => "wikiplugininline catorphans",
// "wikiplugininline catpath" => "wikiplugininline catpath",
// "wikiplugininline center" => "wikiplugininline center",
// "wikiplugininline chart" => "wikiplugininline chart",
// "wikiplugininline code" => "wikiplugininline code",
// "wikiplugininline content" => "wikiplugininline content",
// "wikiplugininline cookie" => "wikiplugininline cookie",
// "wikiplugininline copyright" => "wikiplugininline copyright",
// "wikiplugininline countdown" => "wikiplugininline countdown",
// "wikiplugininline datachannel" => "wikiplugininline datachannel",
// "wikiplugininline dbreport" => "wikiplugininline dbreport",
// "wikiplugininline div" => "wikiplugininline div",
// "wikiplugininline dl" => "wikiplugininline dl",
// "wikiplugininline draw" => "wikiplugininline draw",
// "wikiplugininline equation" => "wikiplugininline equation",
// "wikiplugininline events" => "wikiplugininline events",
// "wikiplugininline fade" => "wikiplugininline fade",
// "wikiplugininline fancylist" => "wikiplugininline fancylist",
// "wikiplugininline fancytable" => "wikiplugininline fancytable",
// "wikiplugininline file" => "wikiplugininline file",
// "wikiplugininline files" => "wikiplugininline files",
// "wikiplugininline flash" => "wikiplugininline flash",
// "wikiplugininline footnote" => "wikiplugininline footnote",
// "wikiplugininline footnotearea" => "wikiplugininline footnotearea",
// "wikiplugininline ftp" => "wikiplugininline ftp",
// "wikiplugininline gauge" => "wikiplugininline gauge",
// "wikiplugininline googleanalytics" => "wikiplugininline googleanalytics",
// "wikiplugininline googledoc" => "wikiplugininline googledoc",
// "wikiplugininline group" => "wikiplugininline group",
// "wikiplugininline groupmailcore" => "wikiplugininline groupmailcore",
// "wikiplugininline groupstat" => "wikiplugininline groupstat",
// "wikiplugininline html" => "wikiplugininline html",
// "wikiplugininline iframe" => "wikiplugininline iframe",
// "wikiplugininline img" => "wikiplugininline img",
// "wikiplugininline image" => "wikiplugininline image",
// "wikiplugininline include" => "wikiplugininline include",
// "wikiplugininline invite" => "wikiplugininline invite",
// "wikiplugininline jabber" => "wikiplugininline jabber",
// "wikiplugininline js" => "wikiplugininline js",
// "wikiplugininline jq" => "wikiplugininline jq",
// "wikiplugininline lang" => "wikiplugininline lang",
// "wikiplugininline lastmod" => "wikiplugininline lastmod",
// "wikiplugininline listpages" => "wikiplugininline listpages",
// "wikiplugininline listprogress" => "wikiplugininline listprogress",
// "wikiplugininline lsdir" => "wikiplugininline lsdir",
// "wikiplugininline map" => "wikiplugininline map",
// "wikiplugininline mcalendar" => "wikiplugininline mcalendar",
// "wikiplugininline mediaplayer" => "wikiplugininline mediaplayer",
// "wikiplugininline memberlist" => "wikiplugininline memberlist",
// "wikiplugininline miniquiz" => "wikiplugininline miniquiz",
// "wikiplugininline module" => "wikiplugininline module",
// "wikiplugininline mono" => "wikiplugininline mono",
// "wikiplugininline mouseover" => "wikiplugininline mouseover",
// "wikiplugininline mwtable" => "wikiplugininline mwtable",
// "wikiplugininline myspace" => "wikiplugininline myspace",
// "wikiplugininline objecthits" => "wikiplugininline objecthits",
// "wikiplugininline pagelist" => "wikiplugininline pagelist",
// "wikiplugininline picture" => "wikiplugininline picture",
// "wikiplugininline pluginmanager" => "wikiplugininline pluginmanager",
// "wikiplugininline poll" => "wikiplugininline poll",
// "wikiplugininline profile" => "wikiplugininline profile",
// "wikiplugininline proposal" => "wikiplugininline proposal",
// "wikiplugininline quote" => "wikiplugininline quote",
// "wikiplugininline rcontent" => "wikiplugininline rcontent",
// "wikiplugininline realnamelist" => "wikiplugininline realnamelist",
// "wikiplugininline redirect" => "wikiplugininline redirect",
// "wikiplugininline regex" => "wikiplugininline regex",
// "wikiplugininline remarksbox" => "wikiplugininline remarksbox",
// "wikiplugininline rss" => "wikiplugininline rss",
// "wikiplugininline screencast" => "wikiplugininline screencast",
// "wikiplugininline sf" => "wikiplugininline sf",
// "wikiplugininline share" => "wikiplugininline share",
// "wikiplugininline sharethis" => "wikiplugininline sharethis",
// "wikiplugininline sheet" => "wikiplugininline sheet",
// "wikiplugininline showpages" => "wikiplugininline showpages",
// "wikiplugininline skype" => "wikiplugininline skype",
// "wikiplugininline snarf" => "wikiplugininline snarf",
// "wikiplugininline sort" => "wikiplugininline sort",
// "wikiplugininline split" => "wikiplugininline split",
// "wikiplugininline sql" => "wikiplugininline sql",
// "wikiplugininline stat" => "wikiplugininline stat",
// "wikiplugininline sub" => "wikiplugininline sub",
// "wikiplugininline subscribegroup" => "wikiplugininline subscribegroup",
// "wikiplugininline subscribegroups" => "wikiplugininline subscribegroups",
// "wikiplugininline sup" => "wikiplugininline sup",
// "wikiplugininline survey" => "wikiplugininline survey",
// "wikiplugininline tag" => "wikiplugininline tag",
// "wikiplugininline tabs" => "wikiplugininline tabs",
// "wikiplugininline thumb" => "wikiplugininline thumb",
// "wikiplugininline titlesearch" => "wikiplugininline titlesearch",
// "wikiplugininline toc" => "wikiplugininline toc",
// "wikiplugininline topfriends" => "wikiplugininline topfriends",
// "wikiplugininline trackerfilter" => "wikiplugininline trackerfilter",
// "wikiplugininline trackeritemfield" => "wikiplugininline trackeritemfield",
// "wikiplugininline trackerlist" => "wikiplugininline trackerlist",
// "wikiplugininline trackertimeline" => "wikiplugininline trackertimeline",
// "wikiplugininline tracker" => "wikiplugininline tracker",
// "wikiplugininline trackerprefill" => "wikiplugininline trackerprefill",
// "wikiplugininline trackerstat" => "wikiplugininline trackerstat",
// "wikiplugininline translated" => "wikiplugininline translated",
// "wikiplugininline tr" => "wikiplugininline tr",
// "wikiplugininline usercount" => "wikiplugininline usercount",
// "wikiplugininline userlist" => "wikiplugininline userlist",
// "wikiplugininline userpref" => "wikiplugininline userpref",
// "wikiplugininline versions" => "wikiplugininline versions",
// "wikiplugininline vote" => "wikiplugininline vote",
// "wikiplugininline wantedpages" => "wikiplugininline wantedpages",
// "wikiplugininline webservice" => "wikiplugininline webservice",
// "wikiplugininline youtube" => "wikiplugininline youtube",
// "webservice consume defaultcache" => "webservice consume defaultcache",
// "feature webservices" => "feature webservices",
// "feature semantic" => "feature semantic",
// "feature wysiwyg" => "feature wysiwyg",
// "wysiwyg optional" => "wysiwyg optional",
// "wysiwyg default" => "wysiwyg default",
// "wysiwyg memo" => "wysiwyg memo",
// "wysiwyg wiki parsed" => "wysiwyg wiki parsed",
// "wysiwyg wiki semi parsed" => "wysiwyg wiki semi parsed",
// "wysiwyg toolbar skin" => "wysiwyg toolbar skin",
// "wiki feature 3d" => "wiki feature 3d",
// "wiki 3d width" => "wiki 3d width",
// "wiki 3d height" => "wiki 3d height",
// "wiki 3d navigation depth" => "wiki 3d navigation depth",
// "wiki 3d feed animation interval" => "wiki 3d feed animation interval",
// "wiki 3d existing page color" => "wiki 3d existing page color",
// "wiki 3d missing page color" => "wiki 3d missing page color",
// "feature blogs" => "feature blogs",
// "blog list order" => "blog list order",
// "home blog" => "home blog",
// "feature blog rankings" => "feature blog rankings",
// "feature blog comments" => "feature blog comments",
// "blog comments default ordering" => "blog comments default ordering",
// "blog comments per page" => "blog comments per page",
// "feature blogposts comments" => "feature blogposts comments",
// "blog list user" => "blog list user",
// "blog list title" => "blog list title",
// "blog list title len" => "blog list title len",
// "blog list description" => "blog list description",
// "blog list created" => "blog list created",
// "blog list lastmodif" => "blog list lastmodif",
// "blog list posts" => "blog list posts",
// "blog list visits" => "blog list visits",
// "blog list activity" => "blog list activity",
// "feature blog mandatory category" => "feature blog mandatory category",
// "feature blog heading" => "feature blog heading",
// "feature file galleries" => "feature file galleries",
// "home file gallery" => "home file gallery",
// "fgal root id" => "fgal root id",
// "fgal use db" => "fgal use db",
// "fgal batch dir" => "fgal batch dir",
// "fgal match regex" => "fgal match regex",
// "fgal nmatch regex" => "fgal nmatch regex",
// "fgal use dir" => "fgal use dir",
// "fgal podcast dir" => "fgal podcast dir",
// "feature file galleries comments" => "feature file galleries comments",
// "file galleries comments default ordering" => "file galleries comments default ordering",
// "file galleries comments per page" => "file galleries comments per page",
// "feature file galleries batch" => "feature file galleries batch",
// "feature file galleries rankings" => "feature file galleries rankings",
// "fgal enable auto indexing" => "fgal enable auto indexing",
// "fgal asynchronous indexing" => "fgal asynchronous indexing",
// "fgal allow duplicates" => "fgal allow duplicates",
// "fgal sort mode" => "fgal sort mode",
// "feature file galleries author" => "feature file galleries author",
// "fgal list id" => "fgal list id",
// "fgal list type" => "fgal list type",
// "fgal list name" => "fgal list name",
// "fgal list description" => "fgal list description",
// "fgal list size" => "fgal list size",
// "fgal list created" => "fgal list created",
// "fgal list lastModif" => "fgal list lastModif",
// "fgal list creator" => "fgal list creator",
// "fgal list author" => "fgal list author",
// "fgal list last user" => "fgal list last user",
// "fgal list comment" => "fgal list comment",
// "fgal list files" => "fgal list files",
// "fgal list hits" => "fgal list hits",
// "fgal list lockedby" => "fgal list lockedby",
// "fgal show path" => "fgal show path",
// "fgal show explorer" => "fgal show explorer",
// "fgal show slideshow" => "fgal show slideshow",
// "fgal default view" => "fgal default view",
// "fgal limit hits per file" => "fgal limit hits per file",
// "fgal prevent negative score" => "fgal prevent negative score",
// "fgal quota" => "fgal quota",
// "fgal quota per fgal" => "fgal quota per fgal",
// "fgal quota default" => "fgal quota default",
// "fgal quota show" => "fgal quota show",
// "feature galleries" => "feature galleries",
// "feature gal batch" => "feature gal batch",
// "feature gal slideshow" => "feature gal slideshow",
// "home gallery" => "home gallery",
// "gal use db" => "gal use db",
// "gal use lib" => "gal use lib",
// "gal match regex" => "gal match regex",
// "gal nmatch regex" => "gal nmatch regex",
// "gal use dir" => "gal use dir",
// "gal batch dir" => "gal batch dir",
// "feature gal rankings" => "feature gal rankings",
// "feature image galleries comments" => "feature image galleries comments",
// "image galleries comments default order" => "image galleries comments default order",
// "image galleries comments per page" => "image galleries comments per page",
// "gal list name" => "gal list name",
// "gal list parent" => "gal list parent",
// "gal list description" => "gal list description",
// "gal list created" => "gal list created",
// "gal list lastmodif" => "gal list lastmodif",
// "gal list user" => "gal list user",
// "gal list imgs" => "gal list imgs",
// "gal list visits" => "gal list visits",
// "feature image gallery mandatory category" => "feature image gallery mandatory category",
// "preset galleries info" => "preset galleries info",
// "gal image mouseover" => "gal image mouseover",
// "ProgressBarPlay" => "ProgressBarPlay",
// "ProgressBarLoad" => "ProgressBarLoad",
// "ProgressBarButton" => "ProgressBarButton",
// "ProgressBar" => "ProgressBar",
// "VolumeOn" => "VolumeOn",
// "VolumeOff" => "VolumeOff",
// "VolumeButton" => "VolumeButton",
// "Button" => "Button",
// "ButtonPressed" => "ButtonPressed",
// "ButtonOver" => "ButtonOver",
// "ButtonInfo" => "ButtonInfo",
// "ButtonInfoPressed" => "ButtonInfoPressed",
// "ButtonInfoOver" => "ButtonInfoOver",
// "ButtonInfoText" => "ButtonInfoText",
// "ID3" => "ID3",
// "PlayTime" => "PlayTime",
// "TotalTime" => "TotalTime",
// "PanelDisplay" => "PanelDisplay",
// "AlertMesg" => "AlertMesg",
// "PreloadDelay" => "PreloadDelay",
// "VideoHeight" => "VideoHeight",
// "VideoLength" => "VideoLength",
// "URLAppend" => "URLAppend",
// "LimitedMsg" => "LimitedMsg",
// "MaxPlay" => "MaxPlay",
// "MultimediaGalerie" => "MultimediaGalerie",
// "MultimediaDefaultLength" => "MultimediaDefaultLength",
// "MultimediaDefaultHeight" => "MultimediaDefaultHeight",
// "feature forums" => "feature forums",
// "home forum" => "home forum",
// "feature forum rankings" => "feature forum rankings",
// "feature forum parse" => "feature forum parse",
// "feature forum topics archiving" => "feature forum topics archiving",
// "feature forum replyempty" => "feature forum replyempty",
// "feature forum quickjump" => "feature forum quickjump",
// "feature forums allow thread titles" => "feature forums allow thread titles",
// "feature forum content search" => "feature forum content search",
// "feature forums name search" => "feature forums name search",
// "forums ordering" => "forums ordering",
// "forum list topics" => "forum list topics",
// "forum list posts" => "forum list posts",
// "forum list ppd" => "forum list ppd",
// "forum list lastpost" => "forum list lastpost",
// "forum list visits" => "forum list visits",
// "forum list desc" => "forum list desc",
// "forum list description len" => "forum list description len",
// "feature forum local search" => "feature forum local search",
// "feature forum local tiki search" => "feature forum local tiki search",
// "forum thread defaults by forum" => "forum thread defaults by forum",
// "forum thread user settings" => "forum thread user settings",
// "forum thread user settings threshold" => "forum thread user settings threshold",
// "forum thread user settings keep" => "forum thread user settings keep",
// "forum comments per page" => "forum comments per page",
// "forum comments no title prefix" => "forum comments no title prefix",
// "forum thread style" => "forum thread style",
// "forum thread sort mode" => "forum thread sort mode",
// "forum match regex" => "forum match regex",
// "feature articles" => "feature articles",
// "feature submissions" => "feature submissions",
// "feature cms rankings" => "feature cms rankings",
// "feature cms print" => "feature cms print",
// "feature cms emails" => "feature cms emails",
// "art list title" => "art list title",
// "art list title len" => "art list title len",
// "art list topic" => "art list topic",
// "art list date" => "art list date",
// "art list author" => "art list author",
// "art list rating" => "art list rating",
// "art list reads" => "art list reads",
// "art list size" => "art list size",
// "art list expire" => "art list expire",
// "art list img" => "art list img",
// "art list type" => "art list type",
// "art list visible" => "art list visible",
// "art view type" => "art view type",
// "art view title" => "art view title",
// "art view topic" => "art view topic",
// "art view date" => "art view date",
// "art view author" => "art view author",
// "art view reads" => "art view reads",
// "art view size" => "art view size",
// "art view img" => "art view img",
// "art list lang" => "art list lang",
// "feature article comments" => "feature article comments",
// "article comments default ordering" => "article comments default ordering",
// "article comments per page" => "article comments per page",
// "article image size x" => "article image size x",
// "article image size y" => "article image size y",
// "feature cms templates" => "feature cms templates",
// "cms bot bar" => "cms bot bar",
// "cms left column" => "cms left column",
// "cms right column" => "cms right column",
// "cms top bar" => "cms top bar",
// "cms spellcheck" => "cms spellcheck",
// "art home title" => "art home title",
// "feature trackers" => "feature trackers",
// "t use db" => "t use db",
// "t use dir" => "t use dir",
// "groupTracker" => "groupTracker",
// "userTracker" => "userTracker",
// "trk with mirror tables" => "trk with mirror tables",
// "trackerCreatorGroupName" => "trackerCreatorGroupName",
// "tracker jquery user selector threshold" => "tracker jquery user selector threshold",
// "feature userlevels" => "feature userlevels",
// "userlevels" => "userlevels",
// "userbreadCrumb" => "userbreadCrumb",
// "user assigned modules" => "user assigned modules",
// "user flip modules" => "user flip modules",
// "user show realnames" => "user show realnames",
// "feature mytiki" => "feature mytiki",
// "feature userPreferences" => "feature userPreferences",
// "feature user bookmarks" => "feature user bookmarks",
// "feature tasks" => "feature tasks",
// "w use db" => "w use db",
// "w use dir" => "w use dir",
// "w displayed default" => "w displayed default",
// "uf use db" => "uf use db",
// "uf use dir" => "uf use dir",
// "userfiles quota" => "userfiles quota",
// "feature usermenu" => "feature usermenu",
// "feature minical" => "feature minical",
// "feature notepad" => "feature notepad",
// "feature userfiles" => "feature userfiles",
// "feature community gender" => "feature community gender",
// "feature community mouseover" => "feature community mouseover",
// "feature community mouseover name" => "feature community mouseover name",
// "feature community mouseover gender" => "feature community mouseover gender",
// "feature community mouseover picture" => "feature community mouseover picture",
// "feature community mouseover friends" => "feature community mouseover friends",
// "feature community mouseover score" => "feature community mouseover score",
// "feature community mouseover country" => "feature community mouseover country",
// "feature community mouseover email" => "feature community mouseover email",
// "feature community mouseover lastlogin" => "feature community mouseover lastlogin",
// "feature community mouseover distance" => "feature community mouseover distance",
// "feature community list name" => "feature community list name",
// "feature community list score" => "feature community list score",
// "feature community list country" => "feature community list country",
// "feature community list distance" => "feature community list distance",
// "feature community friends permission" => "feature community friends permission",
// "feature community friends permission dep" => "feature community friends permission dep",
// "change language" => "change language",
// "change theme" => "change theme",
// "login is email" => "login is email",
// "validateUsers" => "validateUsers",
// "validateEmail" => "validateEmail",
// "forgotPass" => "forgotPass",
// "change password" => "change password",
// "available languages" => "available languages",
// "available styles" => "available styles",
// "lowercase username" => "lowercase username",
// "username pattern" => "username pattern",
// "max username length" => "max username length",
// "min username length" => "min username length",
// "users prefs allowMsgs" => "users prefs allowMsgs",
// "users prefs country" => "users prefs country",
// "users prefs diff versions" => "users prefs diff versions",
// "users prefs display timezone" => "users prefs display timezone",
// "users prefs email is public" => "users prefs email is public",
// "users prefs homePage" => "users prefs homePage",
// "users prefs lat" => "users prefs lat",
// "users prefs lon" => "users prefs lon",
// "users prefs mess archiveAfter" => "users prefs mess archiveAfter",
// "users prefs mess maxRecords" => "users prefs mess maxRecords",
// "users prefs mess sendReadStatus" => "users prefs mess sendReadStatus",
// "users prefs minPrio" => "users prefs minPrio",
// "users prefs mytiki blogs" => "users prefs mytiki blogs",
// "users prefs mytiki articles" => "users prefs mytiki articles",
// "users prefs mytiki gals" => "users prefs mytiki gals",
// "users prefs mytiki items" => "users prefs mytiki items",
// "users prefs mytiki msgs" => "users prefs mytiki msgs",
// "users prefs mytiki pages" => "users prefs mytiki pages",
// "users prefs mytiki tasks" => "users prefs mytiki tasks",
// "users prefs mytiki forum topics" => "users prefs mytiki forum topics",
// "users prefs mytiki forum replies" => "users prefs mytiki forum replies",
// "users prefs realName" => "users prefs realName",
// "users prefs gender" => "users prefs gender",
// "users prefs show mouseover user info" => "users prefs show mouseover user info",
// "users prefs tasks maxRecords" => "users prefs tasks maxRecords",
// "users prefs user dbl" => "users prefs user dbl",
// "users prefs user information" => "users prefs user information",
// "users prefs userbreadCrumb" => "users prefs userbreadCrumb",
// "users prefs mailCharset" => "users prefs mailCharset",
// "users prefs mailCurrentAccount" => "users prefs mailCurrentAccount",
// "validateRegistration" => "validateRegistration",
// "validator emails" => "validator emails",
// "url after validation" => "url after validation",
// "urlOnUsername" => "urlOnUsername",
// "feature messages" => "feature messages",
// "messu mailbox size" => "messu mailbox size",
// "messu archive size" => "messu archive size",
// "messu sent size" => "messu sent size",
// "allowmsg by default" => "allowmsg by default",
// "allowmsg is optional" => "allowmsg is optional",
// "feature freetags" => "feature freetags",
// "freetags browse show cloud" => "freetags browse show cloud",
// "freetags cloud colors" => "freetags cloud colors",
// "freetags preload random search" => "freetags preload random search",
// "freetags browse amount tags in cloud" => "freetags browse amount tags in cloud",
// "freetags browse amount tags suggestion" => "freetags browse amount tags suggestion",
// "freetags normalized valid chars" => "freetags normalized valid chars",
// "freetags lowercase only" => "freetags lowercase only",
// "freetags feature 3d" => "freetags feature 3d",
// "freetags 3d width" => "freetags 3d width",
// "freetags 3d height" => "freetags 3d height",
// "freetags 3d navigation depth" => "freetags 3d navigation depth",
// "freetags 3d feed animation interval" => "freetags 3d feed animation interval",
// "freetags 3d existing page color" => "freetags 3d existing page color",
// "freetags 3d missing page color" => "freetags 3d missing page color",
// "freetags 3d autoload" => "freetags 3d autoload",
// "freetags 3d camera distance" => "freetags 3d camera distance",
// "freetags 3d elastic constant" => "freetags 3d elastic constant",
// "freetags 3d eletrostatic constant" => "freetags 3d eletrostatic constant",
// "freetags 3d fov" => "freetags 3d fov",
// "freetags 3d friction constant" => "freetags 3d friction constant",
// "freetags 3d node charge" => "freetags 3d node charge",
// "freetags 3d node mass" => "freetags 3d node mass",
// "freetags 3d node size" => "freetags 3d node size",
// "freetags 3d spring size" => "freetags 3d spring size",
// "freetags 3d text size" => "freetags 3d text size",
// "freetags 3d adjust camera" => "freetags 3d adjust camera",
// "freetags multilingual" => "freetags multilingual",
// "morelikethis algorithm" => "morelikethis algorithm",
// "morelikethis basic mincommon" => "morelikethis basic mincommon",
// "freetags show middle" => "freetags show middle",
// "feature search stats" => "feature search stats",
// "feature search" => "feature search",
// "feature search fulltext" => "feature search fulltext",
// "feature search show forbidden obj" => "feature search show forbidden obj",
// "feature search show forbidden cat" => "feature search show forbidden cat",
// "feature search show object filter" => "feature search show object filter",
// "feature search show search box" => "feature search show search box",
// "feature search show visit count" => "feature search show visit count",
// "feature search show pertinence" => "feature search show pertinence",
// "feature search show object type" => "feature search show object type",
// "feature search show last modification" => "feature search show last modification",
// "search refresh index mode" => "search refresh index mode",
// "search parsed snippet" => "search parsed snippet",
// "feature search preferences" => "feature search preferences",
// "feature webmail" => "feature webmail",
// "webmail max attachment" => "webmail max attachment",
// "webmail view html" => "webmail view html",
// "feature contacts" => "feature contacts",
// "feature faqs" => "feature faqs",
// "feature faq comments" => "feature faq comments",
// "faq comments per page" => "faq comments per page",
// "faq comments default ordering" => "faq comments default ordering",
// "faq prefix" => "faq prefix",
// "feature quizzes" => "feature quizzes",
// "feature polls" => "feature polls",
// "feature poll comments" => "feature poll comments",
// "feature poll anonymous" => "feature poll anonymous",
// "poll comments default ordering" => "poll comments default ordering",
// "poll comments per page" => "poll comments per page",
// "poll list categories" => "poll list categories",
// "poll list objects" => "poll list objects",
// "feature poll revote" => "feature poll revote",
// "feature surveys" => "feature surveys",
// "feature featuredLinks" => "feature featuredLinks",
// "feature directory" => "feature directory",
// "directory columns" => "directory columns",
// "directory links per page" => "directory links per page",
// "directory open links" => "directory open links",
// "directory validate urls" => "directory validate urls",
// "directory cool sites" => "directory cool sites",
// "directory country flag" => "directory country flag",
// "feature calendar" => "feature calendar",
// "feature default calendars" => "feature default calendars",
// "calendar sticky popup" => "calendar sticky popup",
// "default calendars" => "default calendars",
// "calendar view mode" => "calendar view mode",
// "calendar view tab" => "calendar view tab",
// "calendar firstDayofWeek" => "calendar firstDayofWeek",
// "calendar timespan" => "calendar timespan",
// "feature jscalendar" => "feature jscalendar",
// "feature action calendar" => "feature action calendar",
// "calendar start year" => "calendar start year",
// "calendar end year" => "calendar end year",
// "calendar list begins focus" => "calendar list begins focus",
// "feature cal manual time" => "feature cal manual time",
// "server timezone" => "server timezone",
// "long date format" => "long date format",
// "long time format" => "long time format",
// "short date format" => "short date format",
// "short time format" => "short time format",
// "display field order" => "display field order",
// "rss forums" => "rss forums",
// "rss forum" => "rss forum",
// "rss directories" => "rss directories",
// "rss articles" => "rss articles",
// "rss blogs" => "rss blogs",
// "rss image galleries" => "rss image galleries",
// "rss file galleries" => "rss file galleries",
// "rss wiki" => "rss wiki",
// "rss image gallery" => "rss image gallery",
// "rss file gallery" => "rss file gallery",
// "rss blog" => "rss blog",
// "rss tracker" => "rss tracker",
// "rss trackers" => "rss trackers",
// "rss calendar" => "rss calendar",
// "rss mapfiles" => "rss mapfiles",
// "rss cache time" => "rss cache time",
// "title rss forums" => "title rss forums",
// "title rss forum" => "title rss forum",
// "title rss directories" => "title rss directories",
// "title rss articles" => "title rss articles",
// "title rss blogs" => "title rss blogs",
// "title rss image galleries" => "title rss image galleries",
// "title rss file galleries" => "title rss file galleries",
// "title rss wiki" => "title rss wiki",
// "title rss image gallery" => "title rss image gallery",
// "title rss file gallery" => "title rss file gallery",
// "title rss blog" => "title rss blog",
// "title rss tracker" => "title rss tracker",
// "title rss trackers" => "title rss trackers",
// "title rss calendar" => "title rss calendar",
// "title rss mapfiles" => "title rss mapfiles",
// "max rss forums" => "max rss forums",
// "max rss forum" => "max rss forum",
// "max rss directories" => "max rss directories",
// "max rss articles" => "max rss articles",
// "max rss blogs" => "max rss blogs",
// "max rss image galleries" => "max rss image galleries",
// "max rss file galleries" => "max rss file galleries",
// "max rss wiki" => "max rss wiki",
// "max rss image gallery" => "max rss image gallery",
// "max rss file gallery" => "max rss file gallery",
// "max rss blog" => "max rss blog",
// "max rss mapfiles" => "max rss mapfiles",
// "max rss tracker" => "max rss tracker",
// "max rss trackers" => "max rss trackers",
// "max rss calendar" => "max rss calendar",
// "summary rss blogs" => "summary rss blogs",
// "rssfeed default version" => "rssfeed default version",
// "rssfeed language" => "rssfeed language",
// "rssfeed editor" => "rssfeed editor",
// "rssfeed webmaster" => "rssfeed webmaster",
// "rssfeed creator" => "rssfeed creator",
// "rssfeed css" => "rssfeed css",
// "rssfeed publisher" => "rssfeed publisher",
// "rssfeed img" => "rssfeed img",
// "rss basic auth" => "rss basic auth",
// "feature maps" => "feature maps",
// "map path" => "map path",
// "default map" => "default map",
// "map help" => "map help",
// "map comments" => "map comments",
// "gdaltindex" => "gdaltindex",
// "ogr2ogr" => "ogr2ogr",
// "mapzone" => "mapzone",
// "feature gmap" => "feature gmap",
// "gmap defaultx" => "gmap defaultx",
// "gmap defaulty" => "gmap defaulty",
// "gmap defaultz" => "gmap defaultz",
// "gmap key" => "gmap key",
// "allowRegister" => "allowRegister",
// "eponymousGroups" => "eponymousGroups",
// "useRegisterPasscode" => "useRegisterPasscode",
// "registerPasscode" => "registerPasscode",
// "rememberme" => "rememberme",
// "remembertime" => "remembertime",
// "feature clear passwords" => "feature clear passwords",
// "feature crypt passwords" => "feature crypt passwords",
// "feature challenge" => "feature challenge",
// "min user length" => "min user length",
// "min pass length" => "min pass length",
// "pass chr num" => "pass chr num",
// "pass due" => "pass due",
// "email due" => "email due",
// "unsuccessful logins" => "unsuccessful logins",
// "rnd num reg" => "rnd num reg",
// "generate password" => "generate password",
// "auth method" => "auth method",
// "auth pear" => "auth pear",
// "auth ldap url" => "auth ldap url",
// "auth pear host" => "auth pear host",
// "auth pear port" => "auth pear port",
// "auth ldap scope" => "auth ldap scope",
// "auth ldap basedn" => "auth ldap basedn",
// "auth ldap userdn" => "auth ldap userdn",
// "auth ldap userattr" => "auth ldap userattr",
// "auth ldap useroc" => "auth ldap useroc",
// "auth ldap groupdn" => "auth ldap groupdn",
// "auth ldap groupattr" => "auth ldap groupattr",
// "auth ldap groupnameatr" => "auth ldap groupnameatr",
// "auth ldap groupdescatr" => "auth ldap groupdescatr",
// "auth ldap usergroupattr" => "auth ldap usergroupattr",
// "auth ldap groupgroupattr" => "auth ldap groupgroupattr",
// "auth ldap groupoc" => "auth ldap groupoc",
// "auth ldap memberattr" => "auth ldap memberattr",
// "auth ldap memberisdn" => "auth ldap memberisdn",
// "auth ldap adminuser" => "auth ldap adminuser",
// "auth ldap adminpass" => "auth ldap adminpass",
// "auth ldap version" => "auth ldap version",
// "auth ldap nameattr" => "auth ldap nameattr",
// "auth ldap countryattr" => "auth ldap countryattr",
// "auth ldap emailattr" => "auth ldap emailattr",
// "ldap create user tiki" => "ldap create user tiki",
// "ldap create user ldap" => "ldap create user ldap",
// "ldap skip admin" => "ldap skip admin",
// "auth ldap permit tiki users" => "auth ldap permit tiki users",
// "auth ldap debug" => "auth ldap debug",
// "auth ldap ssl" => "auth ldap ssl",
// "auth ldap starttls" => "auth ldap starttls",
// "auth ldap type" => "auth ldap type",
// "auth ldap syncuserattr" => "auth ldap syncuserattr",
// "auth ldap syncgroupattr" => "auth ldap syncgroupattr",
// "https login" => "https login",
// "feature show stay in ssl mode" => "feature show stay in ssl mode",
// "feature switch ssl mode" => "feature switch ssl mode",
// "https port" => "https port",
// "http port" => "http port",
// "login url" => "login url",
// "login scr" => "login scr",
// "register url" => "register url",
// "error url" => "error url",
// "highlight group" => "highlight group",
// "cookie path" => "cookie path",
// "cookie domain" => "cookie domain",
// "cookie name" => "cookie name",
// "user tracker infos" => "user tracker infos",
// "desactive login autocomplete" => "desactive login autocomplete",
// "permission denied login box" => "permission denied login box",
// "permission denied url" => "permission denied url",
// "feature intertiki" => "feature intertiki",
// "feature intertiki server" => "feature intertiki server",
// "feature intertiki slavemode" => "feature intertiki slavemode",
// "interlist" => "interlist",
// "feature intertiki mymaster" => "feature intertiki mymaster",
// "feature intertiki import preferences" => "feature intertiki import preferences",
// "feature intertiki import groups" => "feature intertiki import groups",
// "known hosts" => "known hosts",
// "tiki key" => "tiki key",
// "intertiki logfile" => "intertiki logfile",
// "intertiki errfile" => "intertiki errfile",
// "feature intertiki sharedcookie" => "feature intertiki sharedcookie",
// "search lru length" => "search lru length",
// "search lru purge rate" => "search lru purge rate",
// "search max syllwords" => "search max syllwords",
// "search min wordlength" => "search min wordlength",
// "search refresh rate" => "search refresh rate",
// "search syll age" => "search syll age",
// "feature categories" => "feature categories",
// "feature categoryobjects" => "feature categoryobjects",
// "feature categorypath" => "feature categorypath",
// "feature category reinforce" => "feature category reinforce",
// "feature category use phplayers" => "feature category use phplayers",
// "categorypath excluded" => "categorypath excluded",
// "categories used in tpl" => "categories used in tpl",
// "category jail" => "category jail",
// "expanded category jail" => "expanded category jail",
// "expanded category jail key" => "expanded category jail key",
// "feature html pages" => "feature html pages",
// "feature filegals manager" => "feature filegals manager",
// "feature contact" => "feature contact",
// "contact user" => "contact user",
// "contact anon" => "contact anon",
// "mail crlf" => "mail crlf",
// "feature detect language" => "feature detect language",
// "feature homePage if bl missing" => "feature homePage if bl missing",
// "record untranslated" => "record untranslated",
// "feature best language" => "feature best language",
// "feature translation" => "feature translation",
// "feature urgent translation" => "feature urgent translation",
// "feature translation incomplete notice" => "feature translation incomplete notice",
// "lang use db" => "lang use db",
// "language" => "language",
// "feature babelfish" => "feature babelfish",
// "feature babelfish logo" => "feature babelfish logo",
// "quantify changes" => "quantify changes",
// "feature sync language" => "feature sync language",
// "show available translations" => "show available translations",
// "language inclusion threshold" => "language inclusion threshold",
// "metatag keywords" => "metatag keywords",
// "metatag threadtitle" => "metatag threadtitle",
// "metatag imagetitle" => "metatag imagetitle",
// "metatag freetags" => "metatag freetags",
// "metatag description" => "metatag description",
// "metatag pagedesc" => "metatag pagedesc",
// "metatag author" => "metatag author",
// "metatag geoposition" => "metatag geoposition",
// "metatag georegion" => "metatag georegion",
// "metatag geoplacename" => "metatag geoplacename",
// "metatag robots" => "metatag robots",
// "metatag revisitafter" => "metatag revisitafter",
// "head extra js" => "head extra js",
// "keep versions" => "keep versions",
// "feature custom home" => "feature custom home",
// "site crumb seper" => "site crumb seper",
// "site nav seper" => "site nav seper",
// "feature sitemycode" => "feature sitemycode",
// "sitemycode" => "sitemycode",
// "sitemycode publish" => "sitemycode publish",
// "feature sitelogo" => "feature sitelogo",
// "sitelogo bgcolor" => "sitelogo bgcolor",
// "sitelogo bgstyle" => "sitelogo bgstyle",
// "sitelogo align" => "sitelogo align",
// "sitelogo title" => "sitelogo title",
// "sitelogo src" => "sitelogo src",
// "sitelogo alt" => "sitelogo alt",
// "feature siteloc" => "feature siteloc",
// "feature sitenav" => "feature sitenav",
// "sitenav" => "sitenav",
// "feature sitead" => "feature sitead",
// "sitead" => "sitead",
// "sitead publish" => "sitead publish",
// "feature breadcrumbs" => "feature breadcrumbs",
// "feature siteloclabel" => "feature siteloclabel",
// "feature sitesearch" => "feature sitesearch",
// "feature site login" => "feature site login",
// "feature sitemenu" => "feature sitemenu",
// "feature topbar version" => "feature topbar version",
// "feature topbar debug" => "feature topbar debug",
// "feature topbar id menu" => "feature topbar id menu",
// "feature topbar custom code" => "feature topbar custom code",
// "feature sitetitle" => "feature sitetitle",
// "feature sitedesc" => "feature sitedesc",
// "feature bot logo" => "feature bot logo",
// "feature endbody code" => "feature endbody code",
// "feature custom html head content" => "feature custom html head content",
// "users prefs theme" => "users prefs theme",
// "feature left column" => "feature left column",
// "feature right column" => "feature right column",
// "feature top bar" => "feature top bar",
// "feature bot bar" => "feature bot bar",
// "feature bot bar icons" => "feature bot bar icons",
// "feature bot bar debug" => "feature bot bar debug",
// "feature bot bar rss" => "feature bot bar rss",
// "feature bot bar power by tw" => "feature bot bar power by tw",
// "maxRecords" => "maxRecords",
// "maxArticles" => "maxArticles",
// "maxVersions" => "maxVersions",
// "feature view tpl" => "feature view tpl",
// "slide style" => "slide style",
// "site favicon" => "site favicon",
// "site favicon type" => "site favicon type",
// "style" => "style",
// "style option" => "style option",
// "site style" => "site style",
// "site style option" => "site style option",
// "use context menu icon" => "use context menu icon",
// "use context menu text" => "use context menu text",
// "feature site report" => "feature site report",
// "feature site send link" => "feature site send link",
// "feature layoutshadows" => "feature layoutshadows",
// "main shadow start" => "main shadow start",
// "main shadow end" => "main shadow end",
// "header shadow start" => "header shadow start",
// "header shadow end" => "header shadow end",
// "middle shadow start" => "middle shadow start",
// "middle shadow end" => "middle shadow end",
// "center shadow start" => "center shadow start",
// "center shadow end" => "center shadow end",
// "footer shadow start" => "footer shadow start",
// "footer shadow end" => "footer shadow end",
// "box shadow start" => "box shadow start",
// "box shadow end" => "box shadow end",
// "feature custom center column header" => "feature custom center column header",
// "feature mods provider" => "feature mods provider",
// "mods dir" => "mods dir",
// "mods server" => "mods server",
// "feature experimental" => "feature experimental",
// "feature actionlog" => "feature actionlog",
// "feature actionlog bytes" => "feature actionlog bytes",
// "browsertitle" => "browsertitle",
// "site title location" => "site title location",
// "site title breadcrumb" => "site title breadcrumb",
// "tmpDir" => "tmpDir",
// "feature tell a friend" => "feature tell a friend",
// "feature copyright" => "feature copyright",
// "feature multimedia" => "feature multimedia",
// "feature smileys" => "feature smileys",
// "popupLinks" => "popupLinks",
// "feature autolinks" => "feature autolinks",
// "default rows textarea wiki" => "default rows textarea wiki",
// "default rows textarea comment" => "default rows textarea comment",
// "default rows textarea forum" => "default rows textarea forum",
// "default rows textarea forumthread" => "default rows textarea forumthread",
// "section comments parse" => "section comments parse",
// "toolbar global" => "toolbar global",
// "toolbar global comments" => "toolbar global comments",
// "direct pagination" => "direct pagination",
// "nextprev pagination" => "nextprev pagination",
// "pagination firstlast" => "pagination firstlast",
// "pagination hide if one page" => "pagination hide if one page",
// "pagination icons" => "pagination icons",
// "pagination fastmove links" => "pagination fastmove links",
// "direct pagination max middle links" => "direct pagination max middle links",
// "direct pagination max ending links" => "direct pagination max ending links",
// "feature kaltura" => "feature kaltura",
// "wikiplugin kaltura" => "wikiplugin kaltura",
// "wikiplugininline kaltura" => "wikiplugininline kaltura",
// "default kaltura editor" => "default kaltura editor",
// "partnerId" => "partnerId",
// "secret" => "secret",
// "adminSecret" => "adminSecret",
// "kdpUIConf" => "kdpUIConf",
// "kdpWidget" => "kdpWidget",
// "kcwUIConf" => "kcwUIConf",
// "kseUIConf" => "kseUIConf",
// "kaeUIConf" => "kaeUIConf",
// "anonCanEdit" => "anonCanEdit",
// "cacheimages" => "cacheimages",
// "cachepages" => "cachepages",
// "count admin pvs" => "count admin pvs",
// "default mail charset" => "default mail charset",
// "error reporting adminonly" => "error reporting adminonly",
// "error reporting level" => "error reporting level",
// "smarty notice reporting" => "smarty notice reporting",
// "smarty security" => "smarty security",
// "feature htmlpurifier output" => "feature htmlpurifier output",
// "feature ajax" => "feature ajax",
// "feature ajax autosave" => "feature ajax autosave",
// "feature antibot" => "feature antibot",
// "feature banners" => "feature banners",
// "feature banning" => "feature banning",
// "feature comm" => "feature comm",
// "feature contribution" => "feature contribution",
// "feature contribution display in comment" => "feature contribution display in comment",
// "feature contribution mandatory" => "feature contribution mandatory",
// "feature contribution mandatory blog" => "feature contribution mandatory blog",
// "feature contribution mandatory comment" => "feature contribution mandatory comment",
// "feature contribution mandatory forum" => "feature contribution mandatory forum",
// "feature debug console" => "feature debug console",
// "feature debugger console" => "feature debugger console",
// "feature display my to others" => "feature display my to others",
// "feature dynamic content" => "feature dynamic content",
// "feature edit templates" => "feature edit templates",
// "feature editcss" => "feature editcss",
// "feature events" => "feature events",
// "feature friends" => "feature friends",
// "feature fullscreen" => "feature fullscreen",
// "feature help" => "feature help",
// "feature hotwords" => "feature hotwords",
// "feature hotwords nw" => "feature hotwords nw",
// "feature integrator" => "feature integrator",
// "feature live support" => "feature live support",
// "feature mailin" => "feature mailin",
// "feature menusfolderstyle" => "feature menusfolderstyle",
// "feature mobile" => "feature mobile",
// "feature modulecontrols" => "feature modulecontrols",
// "feature morcego" => "feature morcego",
// "feature multilingual" => "feature multilingual",
// "feature multilingual one page" => "feature multilingual one page",
// "feature multilingual structures" => "feature multilingual structures",
// "feature machine translation" => "feature machine translation",
// "feature newsletters" => "feature newsletters",
// "feature obzip" => "feature obzip",
// "feature perspective" => "feature perspective",
// "feature phplayers" => "feature phplayers",
// "feature cssmenus" => "feature cssmenus",
// "feature projects" => "feature projects",
// "feature ranking" => "feature ranking",
// "feature redirect on error" => "feature redirect on error",
// "feature referer highlight" => "feature referer highlight",
// "feature referer stats" => "feature referer stats",
// "feature score" => "feature score",
// "feature sheet" => "feature sheet",
// "feature shoutbox" => "feature shoutbox",
// "feature source" => "feature source",
// "feature stats" => "feature stats",
// "feature tabs" => "feature tabs",
// "feature theme control" => "feature theme control",
// "feature ticketlib" => "feature ticketlib",
// "feature ticketlib2" => "feature ticketlib2",
// "feature top banner" => "feature top banner",
// "feature usability" => "feature usability",
// "feature use quoteplugin" => "feature use quoteplugin",
// "feature user watches" => "feature user watches",
// "feature group watches" => "feature group watches",
// "feature user watches translations" => "feature user watches translations",
// "feature daily report watches" => "feature daily report watches",
// "feature quick object perms" => "feature quick object perms",
// "feature xmlrpc" => "feature xmlrpc",
// "helpurl" => "helpurl",
// "layout section" => "layout section",
// "limitedGoGroupHome" => "limitedGoGroupHome",
// "minical reminders" => "minical reminders",
// "modallgroups" => "modallgroups",
// "modseparateanon" => "modseparateanon",
// "php docroot" => "php docroot",
// "proxy host" => "proxy host",
// "proxy port" => "proxy port",
// "ip can be checked" => "ip can be checked",
// "sender email" => "sender email",
// "feature site report email" => "feature site report email",
// "session storage" => "session storage",
// "session lifetime" => "session lifetime",
// "session silent" => "session silent",
// "session cookie name" => "session cookie name",
// "shoutbox autolink" => "shoutbox autolink",
// "show comzone" => "show comzone",
// "tikiIndex" => "tikiIndex",
// "urlIndex" => "urlIndex",
// "useGroupHome" => "useGroupHome",
// "useGroupTheme" => "useGroupTheme",
// "useUrlIndex" => "useUrlIndex",
// "use proxy" => "use proxy",
// "user list order" => "user list order",
// "webserverauth" => "webserverauth",
// "feature purifier" => "feature purifier",
// "feature shadowbox" => "feature shadowbox",
// "log sql" => "log sql",
// "log sql perf min" => "log sql perf min",
// "log mail" => "log mail",
// "log tpl" => "log tpl",
// "case patched" => "case patched",
// "site closed" => "site closed",
// "site closed msg" => "site closed msg",
// "use load threshold" => "use load threshold",
// "load threshold" => "load threshold",
// "site busy msg" => "site busy msg",
// "bot logo code" => "bot logo code",
// "feature blogposts pings" => "feature blogposts pings",
// "feature create webhelp" => "feature create webhelp",
// "page n times in a structure" => "page n times in a structure",
// "feature forums search" => "feature forums search",
// "feature trackbackpings" => "feature trackbackpings",
// "feature wiki ext icon" => "feature wiki ext icon",
// "feature wiki mandatory category" => "feature wiki mandatory category",
// "feature intertiki imported groups" => "feature intertiki imported groups",
// "feature wiki history ip" => "feature wiki history ip",
// "pam create user tiki" => "pam create user tiki",
// "pam service" => "pam service",
// "pam skip admin" => "pam skip admin",
// "shib affiliation" => "shib affiliation",
// "shib create user tiki" => "shib create user tiki",
// "shib group" => "shib group",
// "shib skip admin" => "shib skip admin",
// "shib usegroup" => "shib usegroup",
// "wiki 3d camera distance" => "wiki 3d camera distance",
// "wiki 3d elastic constant" => "wiki 3d elastic constant",
// "wiki 3d eletrostatic constant" => "wiki 3d eletrostatic constant",
// "wiki 3d fov" => "wiki 3d fov",
// "wiki 3d friction constant" => "wiki 3d friction constant",
// "wiki 3d node charge" => "wiki 3d node charge",
// "wiki 3d node mass" => "wiki 3d node mass",
// "wiki 3d node size" => "wiki 3d node size",
// "wiki 3d spring size" => "wiki 3d spring size",
// "wiki 3d text size" => "wiki 3d text size",
// "articles feature copyrights" => "articles feature copyrights",
// "blogues feature copyrights" => "blogues feature copyrights",
// "faqs feature copyrights" => "faqs feature copyrights",
// "feature contributor wiki" => "feature contributor wiki",
// "https login required" => "https login required",
// "maxRowsGalleries" => "maxRowsGalleries",
// "replimaster" => "replimaster",
// "rowImagesGalleries" => "rowImagesGalleries",
// "scaleSizeGalleries" => "scaleSizeGalleries",
// "thumbSizeXGalleries" => "thumbSizeXGalleries",
// "thumbSizeYGalleries" => "thumbSizeYGalleries",
// "wiki 3d adjust camera" => "wiki 3d adjust camera",
// "wiki 3d autoload" => "wiki 3d autoload",
// "javascript enabled" => "javascript enabled",
// "feature comments post as anonymous" => "feature comments post as anonymous",
// "feature comments moderation" => "feature comments moderation",
// "feature comments locking" => "feature comments locking",
// "feature template zoom" => "feature template zoom",
// "menus items icons" => "menus items icons",
// "menus items icons path" => "menus items icons path",
// "feature iepngfix" => "feature iepngfix",
// "iepngfix selectors" => "iepngfix selectors",
// "iepngfix elements" => "iepngfix elements",
// "valid email regex" => "valid email regex",
// "feature jquery" => "feature jquery",
// "jquery effect" => "jquery effect",
// "jquery effect direction" => "jquery effect direction",
// "jquery effect speed" => "jquery effect speed",
// "jquery effect tabs" => "jquery effect tabs",
// "jquery effect tabs direction" => "jquery effect tabs direction",
// "jquery effect tabs speed" => "jquery effect tabs speed",
// "feature jquery ui" => "feature jquery ui",
// "feature jquery ui theme" => "feature jquery ui theme",
// "feature jquery tooltips" => "feature jquery tooltips",
// "feature jquery autocomplete" => "feature jquery autocomplete",
// "feature jquery superfish" => "feature jquery superfish",
// "feature jquery reflection" => "feature jquery reflection",
// "feature jquery sheet" => "feature jquery sheet",
// "feature jquery tablesorter" => "feature jquery tablesorter",
// "feature jquery cycle" => "feature jquery cycle",
// "feature sefurl" => "feature sefurl",
// "feature sefurl filter" => "feature sefurl filter",
// "feature sefurl paths" => "feature sefurl paths",
// "feature sefurl title article" => "feature sefurl title article",
// "feature sefurl title blog" => "feature sefurl title blog",
// "feature wiki screencasts" => "feature wiki screencasts",
// "feature wiki screencasts base" => "feature wiki screencasts base",
// "feature wiki screencasts httpbase" => "feature wiki screencasts httpbase",
// "feature wiki screencasts upload type" => "feature wiki screencasts upload type",
// "feature wiki screencasts user" => "feature wiki screencasts user",
// "feature wiki screencasts pass" => "feature wiki screencasts pass",
// "feature wiki screencasts max size" => "feature wiki screencasts max size",
// "feature tikitests" => "feature tikitests",
// "profile sources" => "profile sources",
// "profile channels" => "profile channels",
// "feature minichat" => "feature minichat",
// "memcache enabled" => "memcache enabled",
// "memcache flags" => "memcache flags",
// "memcache servers" => "memcache servers",
// "memcache expiration" => "memcache expiration",
// "memcache prefix" => "memcache prefix",
// "memcache wiki data" => "memcache wiki data",
// "memcache wiki output" => "memcache wiki output",
// "memcache forum output" => "memcache forum output",
// "feature pear date" => "feature pear date",
// "feature bidi" => "feature bidi",
// "feature lastup" => "feature lastup",
// "magic last load" => "magic last load",
// "feature groupalert" => "feature groupalert",
// "zend mail handler" => "zend mail handler",
// "zend mail smtp server" => "zend mail smtp server",
// "zend mail smtp auth" => "zend mail smtp auth",
// "zend mail smtp user" => "zend mail smtp user",
// "zend mail smtp pass" => "zend mail smtp pass",
// "zend mail smtp port" => "zend mail smtp port",
// "zend mail smtp security" => "zend mail smtp security",
// "feature group transition" => "feature group transition",
// "feature category transition" => "feature category transition",
// "terminology profile installed" => "terminology profile installed",
// "multidomain active" => "multidomain active",
// "multidomain config" => "multidomain config",
// "feature use minified scripts" => "feature use minified scripts",
// "tiki minify javascript" => "tiki minify javascript",
// "lib spellcheck" => "lib spellcheck",
// "wiki spellcheck" => "wiki spellcheck",
// "blog spellcheck" => "blog spellcheck",
// "allowMsgs" => "allowMsgs",
// "country" => "country",
// "diff versions" => "diff versions",
// "display timezone" => "display timezone",
// "email is public" => "email is public",
// "homePage" => "homePage",
// "lat" => "lat",
// "lon" => "lon",
// "mess archiveAfter" => "mess archiveAfter",
// "mess maxRecords" => "mess maxRecords",
// "mess sendReadStatus" => "mess sendReadStatus",
// "minPrio" => "minPrio",
// "mytiki blogs" => "mytiki blogs",
// "mytiki articles" => "mytiki articles",
// "mytiki gals" => "mytiki gals",
// "mytiki items" => "mytiki items",
// "mytiki msgs" => "mytiki msgs",
// "mytiki pages" => "mytiki pages",
// "mytiki tasks" => "mytiki tasks",
// "mytiki forum topics" => "mytiki forum topics",
// "mytiki forum replies" => "mytiki forum replies",
// "realName" => "realName",
// "gender" => "gender",
// "show mouseover user info" => "show mouseover user info",
// "tasks maxRecords" => "tasks maxRecords",
// "user dbl" => "user dbl",
// "user information" => "user information",
// "mailCharset" => "mailCharset",
// "mailCurrentAccount" => "mailCurrentAccount",
// "Click Here to Insert in Wiki Syntax" => "Click Here to Insert in Wiki Syntax",
// "Select Categories" => "Select Categories",
// "Select/deselect all categories" => "Select/deselect all categories",
// "Approve" => "Approve",
// "Reject" => "Reject",
// "Group Monitor" => "Group Monitor",
// "Comments Locked" => "Comments Locked",
// "Comments are locked" => "Comments are locked",
// "Maximum size" => "Maximum size",
// "optional" => "optional",
// "If you would like to be notified when someone replies to this topic<br />please tell us your e-mail address" => "If you would like to be notified when someone replies to this topic<br />please tell us your e-mail address",
// "Please note that the preview does not keep the attached file which you will have to choose before posting" => "Please note that the preview does not keep the attached file which you will have to choose before posting",
// "Your comment will have to be approved by the moderator before it is displayed" => "Your comment will have to be approved by the moderator before it is displayed",
// "System error" => "System error",
// "Database is not currently up to date! Visit <a href=\"tiki-install.php\">Tiki Installer</a> to resolve this issue" => "Database is not currently up to date! Visit <a href=\"tiki-install.php\">Tiki Installer</a> to resolve this issue",
// "If you have shell (SSH) access, you can also use the following, on the command line, from the root of your Tiki installation" => "If you have shell (SSH) access, you can also use the following, on the command line, from the root of your Tiki installation",
// "The query was" => "The query was",
// "The built query was likely" => "The built query was likely",
// "Stacktrace" => "Stacktrace",
// "Tiki Debugger Console" => "Tiki Debugger Console",
// "Current URL" => "Current URL",
// "Command" => "Command",
// "exec" => "exec",
// "Type <code>help</code> to get list of available commands" => "Type <code>help</code> to get list of available commands",
// "Page generation debugging log" => "Page generation debugging log",
// "Features state" => "Features state",
// "features matched" => "features matched",
// "File gallery" => "File gallery",
// "Duplicate permissions" => "Duplicate permissions",
// "There are individual permissions set for this file gallery" => "There are individual permissions set for this file gallery",
// "Any file" => "Any file",
// "Podcast (audio)" => "Podcast (audio)",
// "Podcast (video)" => "Podcast (video)",
// "Gallery is visible to non-admin users" => "Gallery is visible to non-admin users",
// "Gallery is public" => "Gallery is public",
// "Any user with permission (not only the gallery owner) can upload files" => "Any user with permission (not only the gallery owner) can upload files",
// "Files can be locked at download" => "Files can be locked at download",
// "Quota" => "Quota",
// "Used" => "Used",
// "Min" => "Min",
// "Group of users alerted when file gallery is modified" => "Group of users alerted when file gallery is modified",
// "Allows to select each user for small groups" => "Allows to select each user for small groups",
// "Descending" => "Descending",
// "Ascending" => "Ascending",
// "Max rows per page" => "Max rows per page",
// "Select which items to display when listing galleries" => "Select which items to display when listing galleries",
// "Please login" => "Please login",
// "Perhaps you are looking for" => "Perhaps you are looking for",
// "Replace" => "Replace",
// "List" => "List",
// "The checkbox is disabled because this preference is disabled globally" => "The checkbox is disabled because this preference is disabled globally",
// "Please, enable the preference globally first" => "Please, enable the preference globally first",
// "You can ask your site Admin to enable the preference" => "You can ask your site Admin to enable the preference",
// "Start the Slideshow" => "Start the Slideshow",
// "Pause the Slideshow" => "Pause the Slideshow",
// "not in" => "not in",
// "Clear Filter" => "Clear Filter",
// "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together or enclose them with double quotes" => "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together or enclose them with double quotes",
// "Download the zip" => "Download the zip",
// "In order to confirm your subscription you must access the following URL" => "In order to confirm your subscription you must access the following URL",
// "To validate your account and login to the site, please click on the following link" => "To validate your account and login to the site, please click on the following link",
// "The administrator approved your account" => "The administrator approved your account",
// "Confirm your email at %s" => "Confirm your email at %s",
// "A new topic was posted to forum" => "A new topic was posted to forum",
// "You are invited by" => "You are invited by",
// "You join this group" => "You join this group",
// "Join me on %s" => "Join me on %s",
// "You sent a request with the subject" => "You sent a request with the subject",
// "Use the subject to indicate the operation to apply" => "Use the subject to indicate the operation to apply",
// "GET:WikiName to get a wiki page" => "GET:WikiName to get a wiki page",
// "PUT:WikiName to update/create a wiki page (use the body for the page data)" => "PUT:WikiName to update/create a wiki page (use the body for the page data)",
// "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)" => "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)",
// "PREPEND:WikiName to append the data at the top" => "PREPEND:WikiName to append the data at the top",
// "Tiki mail-in instructions" => "Tiki mail-in instructions",
// "Tiki mail-in auto-reply" => "Tiki mail-in auto-reply",
// "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first" => "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first",
// "has requested an account on" => "has requested an account on",
// "To validate that account, please follow the link" => "To validate that account, please follow the link",
// "Assign to a group" => "Assign to a group",
// "Best regards" => "Best regards",
// "User Tracker" => "User Tracker",
// "Go to your friendship network to accept or refuse this request" => "Go to your friendship network to accept or refuse this request",
// "Bye bye from %s at %s" => "Bye bye from %s at %s",
// "You can unsubscribe from this newsletter following this link" => "You can unsubscribe from this newsletter following this link",
// "This email address has been added to the list of subscriptors of" => "This email address has been added to the list of subscriptors of",
// "You can always cancel your subscription using" => "You can always cancel your subscription using",
// "Welcome to %s at %s" => "Welcome to %s at %s",
// "Someone" => "Someone",
// "requested a reminder of the password for your account" => "requested a reminder of the password for your account",
// "requested password reset for your account" => "requested password reset for your account",
// "Since this is your registered email address we inform that the password for this account is" => "Since this is your registered email address we inform that the password for this account is",
// "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else" => "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else",
// "Important: Username & password are CaSe SenSitiVe" => "Important: Username & password are CaSe SenSitiVe",
// "Important: The old password remains active if you don't click the link above" => "Important: The old password remains active if you don't click the link above",
// "Your account information for %s" => "Your account information for %s",
// "Report for" => "Report for",
// "Last Report sent on" => "Last Report sent on",
// "Changes in detail" => "Changes in detail",
// "A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}" => "A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}",
// "You can edit the submission following this link" => "You can edit the submission following this link",
// "New article submitted at %s" => "New article submitted at %s",
// "Look at this link" => "Look at this link",
// "A friend sends you a link from: " => "A friend sends you a link from: ",
// "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}" => "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}",
// "New status ItemID {\$mail_itemId} for the tracker {\$mail_trackerName}" => "New status ItemID {\$mail_itemId} for the tracker {\$mail_trackerName}",
// "Download the file at" => "Download the file at",
// "Tracker was modified at" => "Tracker was modified at",
// "Last attempt" => "Last attempt",
// "IP" => "IP",
// "An administrator of the site below has added you as a new user" => "An administrator of the site below has added you as a new user",
// "If you want to confirm your membership in this site, click on the following link to login for the first time" => "If you want to confirm your membership in this site, click on the following link to login for the first time",
// "Your authentication credentials are" => "Your authentication credentials are",
// "Welcome on the site" => "Welcome on the site",
// "Your personal access to" => "Your personal access to",
// "You or someone registered this email address at" => "You or someone registered this email address at",
// "Your registration confirmation" => "Your registration confirmation",
// "Your account request has been stored and will be activated by the admin as soon as possible" => "Your account request has been stored and will be activated by the admin as soon as possible",
// "{\$mail_action} article post" => "{\$mail_action} article post",
// "{\$mail_title} by {\$mail_user} at" => "{\$mail_title} by {\$mail_user} at",
// "New article post" => "New article post",
// "Edited article post" => "Edited article post",
// "Deleted article post" => "Deleted article post",
// "{\$mail_action} article post at" => "{\$mail_action} article post at",
// "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user|username} at {\$mail_date|tiki_short_datetime}" => "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user|username} at {\$mail_date|tiki_short_datetime}",
// "View the blog at" => "View the blog at",
// "New blog post at %s" => "New blog post at %s",
// "View item calendar at" => "View item calendar at",
// "Modified calendar item" => "Modified calendar item",
// "New calendar item" => "New calendar item",
// "changed" => "changed",
// "A new category was created in" => "A new category was created in",
// "created" => "created",
// "A category was removed in" => "A category was removed in",
// "Removed by" => "Removed by",
// "removed" => "removed",
// "A category was updated" => "A category was updated",
// "Updated by" => "Updated by",
// "updated" => "updated",
// "File Gallery %s changed" => "File Gallery %s changed",
// "A file was removed from the file gallery" => "A file was removed from the file gallery",
// "File Name" => "File Name",
// "A new file was posted to file gallery" => "A new file was posted to file gallery",
// "Posted by" => "Posted by",
// "New forum topic in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}" => "New forum topic in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}",
// "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}" => "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}",
// "Image Gallery {\$galleryName} changed" => "Image Gallery {\$galleryName} changed",
// "A new file was posted to image gallery" => "A new file was posted to image gallery",
// "The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "You can view the updated map following this link" => "You can view the updated map following this link",
// "You can edit the map following this link" => "You can edit the map following this link",
// "An object was added to category" => "An object was added to category",
// "An object was removed from category" => "An object was removed from category",
// "The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "The page {\$mail_page} was deleted by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was deleted by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "A file was attached to {\$mail_page}" => "A file was attached to {\$mail_page}",
// "The page {\$mail_page} was deleted but used to be here" => "The page {\$mail_page} was deleted but used to be here",
// "You can view a diff back to the previous version by following this link" => "You can view a diff back to the previous version by following this link",
// "The changes in this version follow below, followed after by the current full page text" => "The changes in this version follow below, followed after by the current full page text",
// "-Lines: {\$oldd} changed to +Lines: {\$newd}" => "-Lines: {\$oldd} changed to +Lines: {\$newd}",
// "The old page content follows below" => "The old page content follows below",
// "The new page content follows below" => "The new page content follows below",
// "Wiki page %s created by {\$mail_user}" => "Wiki page %s created by {\$mail_user}",
// "Wiki page %s deleted by {\$mail_user}" => "Wiki page %s deleted by {\$mail_user}",
// "A file was attached to %s" => "A file was attached to %s",
// "Wiki page %s changed by {\$mail_user}" => "Wiki page %s changed by {\$mail_user}",
// "The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "click on the map to zoom or pan, do not drag" => "click on the map to zoom or pan, do not drag",
// "Query Results" => "Query Results",
// "Querying" => "Querying",
// "Scroll Up" => "Scroll Up",
// "Scroll Down" => "Scroll Down",
// "Scale" => "Scale",
// "Query" => "Query",
// "Pan" => "Pan",
// "Redraw" => "Redraw",
// "select zoom/pan/query and image size" => "select zoom/pan/query and image size",
// "View the Map Only" => "View the Map Only",
// "Reset Map" => "Reset Map",
// "Click on the map or click redraw" => "Click on the map or click redraw",
// "This layer has been set by the maps administrator to not be downloadable" => "This layer has been set by the maps administrator to not be downloadable",
// "you have requested to download the layer" => "you have requested to download the layer",
// "from the mapfile" => "from the mapfile",
// "Here are the files to download, do not forget to rename them" => "Here are the files to download, do not forget to rename them",
// "Mapfiles" => "Mapfiles",
// "Mapfile" => "Mapfile",
// "Available mapfiles" => "Available mapfiles",
// "monitor this map" => "monitor this map",
// "Stop Monitoring this Map" => "Stop Monitoring this Map",
// "Create a new mapfile" => "Create a new mapfile",
// "Mapfile listing" => "Mapfile listing",
// "You can view this map in your browser using" => "You can view this map in your browser using",
// "Mapfile History" => "Mapfile History",
// "Bytes maximum" => "Bytes maximum",
// "Create Directory" => "Create Directory",
// "index file (.shp)" => "index file (.shp)",
// "files to index (regexp)" => "files to index (regexp)",
// "Broadcast message" => "Broadcast message",
// "Confirmation" => "Confirmation",
// "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences" => "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences",
// "'name' parameter for tikimodule missed" => "'name' parameter for tikimodule missed",
// "Unassign this module" => "Unassign this module",
// "Are you sure you want to unassign this module" => "Are you sure you want to unassign this module",
// "Toggle Vertically" => "Toggle Vertically",
// "Display type unknown, you have to enter the banner type" => "Display type unknown, you have to enter the banner type",
// "You forgot your Google ad_client number " => "You forgot your Google ad_client number ",
// "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>" => "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>",
// "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies" => "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies",
// "To remove this module" => "To remove this module",
// "Admin Modules" => "Admin Modules",
// "and remove the assistant module" => "and remove the assistant module",
// "You can also add other modules" => "You can also add other modules",
// "To customize the menu" => "To customize the menu",
// "Admin Menus" => "Admin Menus",
// "and edit menu ID 42" => "and edit menu ID 42",
// "Or, create your own menu and add it to a module" => "Or, create your own menu and add it to a module",
// "To begin configuring Tiki, please" => "To begin configuring Tiki, please",
// "To learn more, visit: <a href=\"http://tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://tikiwiki.org</a>" => "To learn more, visit: <a href=\"http://tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://tikiwiki.org</a>",
// "Tikiwiki Documentation" => "Tikiwiki Documentation",
// "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>" => "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>",
// "on blogpost" => "on blogpost",
// "Missing %0 of the following categories" => "Missing %0 of the following categories",
// "%0 extra of the following categories" => "%0 extra of the following categories",
// "Unknown comparison" => "Unknown comparison",
// "Impossible condition, %0 of" => "Impossible condition, %0 of",
// "Assign into category" => "Assign into category",
// "Unassign category" => "Unassign category",
// "All Groups" => "All Groups",
// "Your Groups" => "Your Groups",
// "Emulated Groups" => "Emulated Groups",
// "Switch to Groups" => "Switch to Groups",
// "Simulate" => "Simulate",
// "No records to display" => "No records to display",
// "insert original" => "insert original",
// "insert thumbnail" => "insert thumbnail",
// "No avatar" => "No avatar",
// "Open operator console" => "Open operator console",
// "Enter user name and click 'Switch'.<br />Useful for testing permissions" => "Enter user name and click 'Switch'.<br />Useful for testing permissions",
// "CapsLock is on" => "CapsLock is on",
// "new messages" => "new messages",
// "new message" => "new message",
// "submissions waiting to be examined" => "submissions waiting to be examined",
// "Wiki feed" => "Wiki feed",
// "Feed" => "Feed",
// "Blogs feed" => "Blogs feed",
// "Articles feed" => "Articles feed",
// "Image Galleries feed" => "Image Galleries feed",
// "File Galleries feed" => "File Galleries feed",
// "Forums feed" => "Forums feed",
// "Maps feed" => "Maps feed",
// "A leading plus sign indicates that this word must be present in every object returned" => "A leading plus sign indicates that this word must be present in every object returned",
// "A leading minus sign indicates that this word must not be present in any row returned" => "A leading minus sign indicates that this word must not be present in any row returned",
// "By default (when neither plus nor minus is specified) the word is optional, but the object that contain it will be rated higher" => "By default (when neither plus nor minus is specified) the word is optional, but the object that contain it will be rated higher",
// "These two operators are used to change a word's contribution to the relevance value that is assigned to a row" => "These two operators are used to change a word's contribution to the relevance value that is assigned to a row",
// "Parentheses are used to group words into subexpressions" => "Parentheses are used to group words into subexpressions",
// "A leading tilde acts as a negation operator, causing the word's contribution to the object relevance to be negative. It's useful for marking noise words. An object that contains such a word will be rated lower than others, but will not be excluded altogether, as it would be with the - operator" => "A leading tilde acts as a negation operator, causing the word's contribution to the object relevance to be negative. It's useful for marking noise words. An object that contains such a word will be rated lower than others, but will not be excluded altogether, as it would be with the - operator",
// "An asterisk is the truncation operator. Unlike the other operators, it should be appended to the word, not prepended" => "An asterisk is the truncation operator. Unlike the other operators, it should be appended to the word, not prepended",
// "The phrase, that is enclosed in double quotes &quot;, matches only objects that contain this phrase literally, as it was typed" => "The phrase, that is enclosed in double quotes &quot;, matches only objects that contain this phrase literally, as it was typed",
// "Advanced search" => "Advanced search",
// "Advanced Search Help" => "Advanced Search Help",
// "Page Relations" => "Page Relations",
// "Are you sure you want to delete this shout" => "Are you sure you want to delete this shout",
// "Shout date" => "Shout date",
// "Delete this shout" => "Delete this shout",
// "Edit this shout" => "Edit this shout",
// "`\$module_params.prefix`" => "`\$module_params.prefix`",
// "Find term" => "Find term",
// "If not found, you will be given a chance to create it" => "If not found, you will be given a chance to create it",
// "There are no translations of this page" => "There are no translations of this page",
// "Up-to-date-ness" => "Up-to-date-ness",
// "Better translations" => "Better translations",
// "update from it" => "update from it",
// "view" => "view",
// "None match your" => "None match your",
// "Set your preferred languages" => "Set your preferred languages",
// "preferred languages" => "preferred languages",
// "Equivalent translations" => "Equivalent translations",
// "Translations that need improvement" => "Translations that need improvement",
// "update it" => "update it",
// "Group information" => "Group information",
// "Webmail inbox" => "Webmail inbox",
// "Refresh (non-ajax)" => "Refresh (non-ajax)",
// "TAKE" => "TAKE",
// "View contact" => "View contact",
// "online users" => "online users",
// "User does not accept messages" => "User does not accept messages",
// "More Videos" => "More Videos",
// "Changes that need to be reproduced are highlighted below" => "Changes that need to be reproduced are highlighted below",
// "Use Ctrl+Click to select multiple options" => "Use Ctrl+Click to select multiple options",
// "Requires" => "Requires",
// "You need to set" => "You need to set",
// "Warning" => "Warning",
// "Send Newsletter" => "Send Newsletter",
// "Switch to normal (wiki) editor" => "Switch to normal (wiki) editor",
// "By" => "By",
// "Read more" => "Read more",
// "To edit the copyright notices" => "To edit the copyright notices",
// "The content on this page is licensed under the terms of the" => "The content on this page is licensed under the terms of the",
// "referenced by" => "referenced by",
// "Trackback pings" => "Trackback pings",
// "Select <a href=\"tiki-list_banners.php\" title=\"Banners\">Admin &gt; Banners</a> from the menu to create and edit banner zones" => "Select <a href=\"tiki-list_banners.php\" title=\"Banners\">Admin &gt; Banners</a> from the menu to create and edit banner zones",
// "Change preferences" => "Change preferences",
// "<strong>Activate</strong> will display content for Admin only. Select <strong>Publish</strong> to display for all users" => "<strong>Activate</strong> will display content for Admin only. Select <strong>Publish</strong> to display for all users",
// "Global site configuration, date formats, admin password etc" => "Global site configuration, date formats, admin password etc",
// "Switches for major features" => "Switches for major features",
// "User resistration, remember me cookie settings and authentication methods" => "User resistration, remember me cookie settings and authentication methods",
// "User specific features and settings" => "User specific features and settings",
// "Profiles" => "Profiles",
// "Repository configuration, browse and apply profiles" => "Repository configuration, browse and apply profiles",
// "Look & Feel" => "Look & Feel",
// "Theme selection, layout settings and UI effect controls" => "Theme selection, layout settings and UI effect controls",
// "Internationalization and localization - mulitlingual features" => "Internationalization and localization - mulitlingual features",
// "Editing and Plugins" => "Editing and Plugins",
// "Text editing settings applicable to many areas. Plugin activation and plugin alias management" => "Text editing settings applicable to many areas. Plugin activation and plugin alias management",
// "Module appearance settings" => "Module appearance settings",
// "Information to include in the header of each page" => "Information to include in the header of each page",
// "Performance" => "Performance",
// "Server performance settings" => "Server performance settings",
// "Security" => "Security",
// "Site security settings" => "Site security settings",
// "Feeds" => "Feeds",
// "Web feeds" => "Web feeds",
// "Connect" => "Connect",
// "Wiki page settings and features" => "Wiki page settings and features",
// "Defaults and configuration for file galleries" => "Defaults and configuration for file galleries",
// "Settings for blogs" => "Settings for blogs",
// "Defaults and configuration for image galleries (will be phased out in favour of file galleries)" => "Defaults and configuration for image galleries (will be phased out in favour of file galleries)",
// "Settings and features for articles" => "Settings and features for articles",
// "Settings and features for forums" => "Settings and features for forums",
// "Settings and features for trackers" => "Settings and features for trackers",
// "Settings and features for polls" => "Settings and features for polls",
// "Settings and features for calendars" => "Settings and features for calendars",
// "Settings and features for categories" => "Settings and features for categories",
// "Values of actions for users rank score" => "Values of actions for users rank score",
// "Settings and features for freetags" => "Settings and features for freetags",
// "Search configuration" => "Search configuration",
// "Settings and features for FAQs" => "Settings and features for FAQs",
// "Settings and features for directory of links" => "Settings and features for directory of links",
// "Settings and features for maps" => "Settings and features for maps",
// "Defaults and API key for Google Maps" => "Defaults and API key for Google Maps",
// "?" => "?",
// "Site-wide copyright information" => "Site-wide copyright information",
// "Message settings" => "Message settings",
// "User files settings" => "User files settings",
// "Webmail settings" => "Webmail settings",
// "Options for WYSIWYG editor" => "Options for WYSIWYG editor",
// "Set up links between Tiki servers" => "Set up links between Tiki servers",
// "Manage semantic wiki links" => "Manage semantic wiki links",
// "Webservices" => "Webservices",
// "Register and manage web services" => "Register and manage web services",
// "Sef URL" => "Sef URL",
// "Search Engine Friendly URLs" => "Search Engine Friendly URLs",
// "Kaltura video configuration" => "Kaltura video configuration",
// "To add/remove blogs, go to \"Create/Edit Blog\" under \"Blogs\" on the application menu, or" => "To add/remove blogs, go to \"Create/Edit Blog\" under \"Blogs\" on the application menu, or",
// "General Settings" => "General Settings",
// "Home Blog (main blog)" => "Home Blog (main blog)",
// "Create a blog" => "Create a blog",
// "Requires a separate download" => "Requires a separate download",
// "Force and limit categorization to within subtree of" => "Force and limit categorization to within subtree of",
// "Blogs Listings" => "Blogs Listings",
// "Select which items to display when listing blogs" => "Select which items to display when listing blogs",
// "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or" => "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or",
// "General settings" => "General settings",
// "Default calendars to display" => "Default calendars to display",
// "All calendars" => "All calendars",
// "A subset of available calendars" => "A subset of available calendars",
// "Create calendar" => "Create calendar",
// "View list begins" => "View list begins",
// "Focus Date" => "Focus Date",
// "Period beginning" => "Period beginning",
// "Manual selection of time/date" => "Manual selection of time/date",
// "JS calendar" => "JS calendar",
// "Year selection is valid when the JS Calendar <strong>is not</strong> enabled" => "Year selection is valid when the JS Calendar <strong>is not</strong> enabled",
// "First year in the dropdown" => "First year in the dropdown",
// "Enter a year or use +/- N to specify a year relative to the current\n\tyear" => "Enter a year or use +/- N to specify a year relative to the current\n\tyear",
// "Last year in the dropdown" => "Last year in the dropdown",
// "Sticky popup" => "Sticky popup",
// "Item view tab" => "Item view tab",
// "Administer categories" => "Administer categories",
// "Separate category IDs with a comma (,)" => "Separate category IDs with a comma (,)",
// "Will improve performance, but may show forbidden results" => "Will improve performance, but may show forbidden results",
// "Look under \"Articles\" on the application menu for links to" => "Look under \"Articles\" on the application menu for links to",
// "Title of articles home page" => "Title of articles home page",
// "Article properties" => "Article properties",
// "Give only one value (width or height) to keep the image proportions" => "Give only one value (width or height) to keep the image proportions",
// "Batch upload (CSV file)" => "Batch upload (CSV file)",
// "File format: title,authorName,heading,body,lang,user" => "File format: title,authorName,heading,body,lang,user",
// "Articles Listing" => "Articles Listing",
// "Select which items to display when listing articles" => "Select which items to display when listing articles",
// "Admin Groups" => "Admin Groups",
// "Admin Users" => "Admin Users",
// "User features" => "User features",
// "Highlight group" => "Highlight group",
// "Use the format: trackerId, fieldId1, fieldId2, .." => "Use the format: trackerId, fieldId1, fieldId2, ..",
// "Users can choose to show their gender" => "Users can choose to show their gender",
// "Requires User Preferences feature" => "Requires User Preferences feature",
// "Show user's information on mouseover" => "Show user's information on mouseover",
// "Requires user's information to be public" => "Requires user's information to be public",
// "Real name" => "Real name",
// "avatar" => "avatar",
// "Number of friends" => "Number of friends",
// "Feature is disabled" => "Feature is disabled",
// "E-mail" => "E-mail",
// "Last login" => "Last login",
// "Distance" => "Distance",
// "Default user preferences" => "Default user preferences",
// "Users Default Preferences" => "Users Default Preferences",
// "Character set for mail" => "Character set for mail",
// "default" => "default",
// "Number of visited pages to remember" => "Number of visited pages to remember",
// "Displayed time zone" => "Displayed time zone",
// "Detect user timezone if browser allows, otherwise site default" => "Detect user timezone if browser allows, otherwise site default",
// "Show user's info on mouseover" => "Show user's info on mouseover",
// "Tasks per page" => "Tasks per page",
// "User messages" => "User messages",
// "Notify sender when reading mail" => "Notify sender when reading mail",
// "Send me an email for messages with priority equal or greater than" => "Send me an email for messages with priority equal or greater than",
// "Auto-archive read messages after x days" => "Auto-archive read messages after x days",
// "My Tiki" => "My Tiki",
// "My pages" => "My pages",
// "My messages" => "My messages",
// "My tasks" => "My tasks",
// "My forum topics" => "My forum topics",
// "My forum replies" => "My forum replies",
// "My items" => "My items",
// "Select which items to display when listing users" => "Select which items to display when listing users",
// "Score ascending" => "Score ascending",
// "Score descending" => "Score descending",
// "Name ascending" => "Name ascending",
// "Name descending" => "Name descending",
// "Login ascending" => "Login ascending",
// "Login descending" => "Login descending",
// "TikiWiki CMS/Groupware is Free and Open Source Software (FOSS). It is a community-driven project which exists and improves thanks to the participation of people just like YOU" => "TikiWiki CMS/Groupware is Free and Open Source Software (FOSS). It is a community-driven project which exists and improves thanks to the participation of people just like YOU",
// "Join the community" => "Join the community",
// "Promote your site" => "Promote your site",
// "To submit your site to TikiWiki.org" => "To submit your site to TikiWiki.org",
// "Submit site" => "Submit site",
// "Help Tiki spread" => "Help Tiki spread",
// "Help improve Tiki" => "Help improve Tiki",
// "To submit a feature request or to report a bug" => "To submit a feature request or to report a bug",
// "Click here to go to our development site" => "Click here to go to our development site",
// "Copyright allows to determine a copyright for all the objects of tikiwiki" => "Copyright allows to determine a copyright for all the objects of tikiwiki",
// "Enable copyright management for" => "Enable copyright management for",
// "To configure your directory, find \"Admin Directory\" under \"Directory\" on the application menu, or" => "To configure your directory, find \"Admin Directory\" under \"Directory\" on the application menu, or",
// "To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or",
// "Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site" => "Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site",
// "Global features" => "Global features",
// "Main feature" => "Main feature",
// "Additional" => "Additional",
// "Programmer" => "Programmer",
// "These features are relatively new, or recently underwent major renovations. You should expect growing pains and possibly a lack of up to date documentation, as you would of a version 1.0 application" => "These features are relatively new, or recently underwent major renovations. You should expect growing pains and possibly a lack of up to date documentation, as you would of a version 1.0 application",
// "Experimental" => "Experimental",
// "Will be phased out" => "Will be phased out",
// "These features generally work but will probably be phased out in the future, because they are superseded by other features or because of evolution in Web technology" => "These features generally work but will probably be phased out in the future, because they are superseded by other features or because of evolution in Web technology",
// "Seem ok but.." => "Seem ok but..",
// "These features are not reported to be broken, but they are not actively developed and/or widely used" => "These features are not reported to be broken, but they are not actively developed and/or widely used",
// "Need polish" => "Need polish",
// "These features are generally known to have issues, and/or need admin help and/or user patience to work" => "These features are generally known to have issues, and/or need admin help and/or user patience to work",
// "Feedbacks" => "Feedbacks",
// "To create or remove file galleries, select" => "To create or remove file galleries, select",
// "from the application menu" => "from the application menu",
// "If you decide to store files in a directory you must ensure that the user cannot access directly to the directory" => "If you decide to store files in a directory you must ensure that the user cannot access directly to the directory",
// "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>" => "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>",
// "To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/" => "To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/",
// "Create a Gallery" => "Create a Gallery",
// "Move files from database to directory" => "Move files from database to directory",
// "Move files from directory to database" => "Move files from directory to database",
// "Store in database" => "Store in database",
// "Store in directory" => "Store in directory",
// "Score is disabled" => "Score is disabled",
// "Upload Regex" => "Upload Regex",
// "Gallery Listings" => "Gallery Listings",
// "Changing these settings will <em>not</em> affect existing file galleries. These changes will apply <em>only</em> to new file galleries" => "Changing these settings will <em>not</em> affect existing file galleries. These changes will apply <em>only</em> to new file galleries",
// "Select which items to display when listing galleries: " => "Select which items to display when listing galleries: ",
// "Search Indexing" => "Search Indexing",
// "Automatically index files on upload or change" => "Automatically index files on upload or change",
// "Handlers" => "Handlers",
// "Add custom handlers to make your files &quot;searchable&quot; content" => "Add custom handlers to make your files &quot;searchable&quot; content",
// "Use <strong>%1</strong> as the internal file name. For example, use <strong>strings %1</strong> to convert the document to text, using the Unix <strong>strings</strong> command" => "Use <strong>%1</strong> as the internal file name. For example, use <strong>strings %1</strong> to convert the document to text, using the Unix <strong>strings</strong> command",
// "To delete a handler, leave the <strong>System Command</strong> field blank" => "To delete a handler, leave the <strong>System Command</strong> field blank",
// "MIME Type" => "MIME Type",
// "System Command" => "System Command",
// "Reindex all files for search" => "Reindex all files for search",
// "To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or",
// "Home Forum (main forum)" => "Home Forum (main forum)",
// "Create a forum" => "Create a forum",
// "If disabled, replies will quote the original post" => "If disabled, replies will quote the original post",
// "Will be a thread title" => "Will be a thread title",
// "Threads" => "Threads",
// "Allows users to override the defaults" => "Allows users to override the defaults",
// "When listing forums" => "When listing forums",
// "Forums Listing" => "Forums Listing",
// "Select which items to display when listing forums" => "Select which items to display when listing forums",
// "Show tag cloud" => "Show tag cloud",
// "Maximum number of tags in cloud" => "Maximum number of tags in cloud",
// "Show freetags in middle column" => "Show freetags in middle column",
// "Preload freetag random tag" => "Preload freetag random tag",
// "When arriving on <a href=\"tiki-browse_freetags.php\">freetag search page</a>" => "When arriving on <a href=\"tiki-browse_freetags.php\">freetag search page</a>",
// "Random tag cloud colors" => "Random tag cloud colors",
// "Separate colors with a comma (,)" => "Separate colors with a comma (,)",
// "Number of Tags to show in Tag Suggestions" => "Number of Tags to show in Tag Suggestions",
// "Valid characters pattern" => "Valid characters pattern",
// "Alphanumeric ASCII characters only" => "Alphanumeric ASCII characters only",
// "No accents or special characters" => "No accents or special characters",
// "Accept all charactrs" => "Accept all charactrs",
// "Lowercase tags only" => "Lowercase tags only",
// "&quot;More Like This&quot; algorithm" => "&quot;More Like This&quot; algorithm",
// "basic" => "basic",
// "weighted" => "weighted",
// "Minimum amount of tags in common" => "Minimum amount of tags in common",
// "Tag Management" => "Tag Management",
// "Cleanup unused tags" => "Cleanup unused tags",
// "3D Tag Browser" => "3D Tag Browser",
// "Morcego 3D browser disabled" => "Morcego 3D browser disabled",
// "Enable freetags 3D browser" => "Enable freetags 3D browser",
// "Browser width" => "Browser width",
// "Graph appearance" => "Graph appearance",
// "Node color" => "Node color",
// "Camera settinsg" => "Camera settinsg",
// "Physics engine" => "Physics engine",
// "To add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "To add/remove image galleries, go to \"Image Galleries\" on the application menu, or",
// "Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value" => "Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value",
// "No Gallery exists" => "No Gallery exists",
// "Uses Slideshow" => "Uses Slideshow",
// "Use database to store images" => "Use database to store images",
// "Use a directory to store images" => "Use a directory to store images",
// "Directory path" => "Directory path",
// "Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below" => "Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below",
// "Library to use for processing images" => "Library to use for processing images",
// "Uploaded image names must match regex" => "Uploaded image names must match regex",
// "Uploaded image names cannot match regex" => "Uploaded image names cannot match regex",
// "Directory Batch Loading" => "Directory Batch Loading",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols",
// "Enable directory batch loading" => "Enable directory batch loading",
// "Batch loading directory" => "Batch loading directory",
// "Display image informations in a mouseover box" => "Display image informations in a mouseover box",
// "yes, and don't display those informations under the image" => "yes, and don't display those informations under the image",
// "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)" => "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)",
// "Images per row" => "Images per row",
// "Thumbnails size X" => "Thumbnails size X",
// "Pixels Default" => "Pixels Default",
// "Thumbnails size Y" => "Thumbnails size Y",
// "Default scale size" => "Default scale size",
// "pixels" => "pixels",
// "Set features" => "Set features",
// "Exterminator" => "Exterminator",
// "Move images from database storage to filesystem storage" => "Move images from database storage to filesystem storage",
// "Move images from filesystem storage to database storage" => "Move images from filesystem storage to database storage",
// "System Gallery" => "System Gallery",
// "Move images from old filesystem store to new directory" => "Move images from old filesystem store to new directory",
// "Gallery listing configuration" => "Gallery listing configuration",
// "Change configuration" => "Change configuration",
// "Image galleries comments settings" => "Image galleries comments settings",
// "General Preferences" => "General Preferences",
// "Release Check" => "Release Check",
// "Reset or upgrade your database" => "Reset or upgrade your database",
// "Check for updates now" => "Check for updates now",
// "Site Identity" => "Site Identity",
// "Go to <a href=\"tiki-admin.php?page=look\" title=\"\"><strong>Look & Feel</strong></a> section for additional site related customization preferences" => "Go to <a href=\"tiki-admin.php?page=look\" title=\"\"><strong>Look & Feel</strong></a> section for additional site related customization preferences",
// "Mail" => "Mail",
// "Mail Sender" => "Mail Sender",
// "Sendmail" => "Sendmail",
// "SMTP" => "SMTP",
// "SMTP Server" => "SMTP Server",
// "Authentication" => "Authentication",
// "These values will be stored in plain text in the database" => "These values will be stored in plain text in the database",
// "Logging and Reporting" => "Logging and Reporting",
// "Visible to admin only" => "Visible to admin only",
// "Include Smarty notices" => "Include Smarty notices",
// "Spam protection" => "Spam protection",
// "MultiDomain" => "MultiDomain",
// "Session" => "Session",
// "Advanced configuration warning" => "Advanced configuration warning",
// "Note that storing session data in the database is an advanced systems administration option, and is for admins who have comprehensive access and understanding of the database, in order to deal with any unexpected effects" => "Note that storing session data in the database is an advanced systems administration option, and is for admins who have comprehensive access and understanding of the database, in order to deal with any unexpected effects",
// "Changing this feature will immediately log you out when you save this preference" => "Changing this feature will immediately log you out when you save this preference",
// "Contact" => "Contact",
// "Miscellaneous" => "Miscellaneous",
// "Use TikiWiki feature as homepage" => "Use TikiWiki feature as homepage",
// "Custom home" => "Custom home",
// "Use different URL as home page" => "Use different URL as home page",
// "Redirects" => "Redirects",
// "If a requested page doesn't exist, redirect to a similarly named page" => "If a requested page doesn't exist, redirect to a similarly named page",
// "On permission denied, display login module (for Anonymous)" => "On permission denied, display login module (for Anonymous)",
// "Send to URL" => "Send to URL",
// "Site Access" => "Site Access",
// "Date and Time Formats" => "Date and Time Formats",
// "Default timezone" => "Default timezone",
// "Use site default to show times" => "Use site default to show times",
// "Detect user timezone (if browser allows). Otherwise use site default" => "Detect user timezone (if browser allows). Otherwise use site default",
// "Long date format" => "Long date format",
// "Sample" => "Sample",
// "Short date format" => "Short date format",
// "Long time format" => "Long time format",
// "Short time format" => "Short time format",
// "Fields display order" => "Fields display order",
// "Date and Time Format Help" => "Date and Time Format Help",
// "Change admin password" => "Change admin password",
// "Change the <strong>Admin</strong> password" => "Change the <strong>Admin</strong> password",
// "New password" => "New password",
// "Change password" => "Change password",
// "To use Google Maps, you must generate a Google Maps API Key for your web site. See <a href=\"http://www.google.com/apis/maps/signup.html\">http://www.google.com/apis/maps/signup.html</a> for details" => "To use Google Maps, you must generate a Google Maps API Key for your web site. See <a href=\"http://www.google.com/apis/maps/signup.html\">http://www.google.com/apis/maps/signup.html</a> for details",
// "Google Maps API Key" => "Google Maps API Key",
// "Defaults" => "Defaults",
// "Default x for map center" => "Default x for map center",
// "Default y from map center" => "Default y from map center",
// "Default zoom level" => "Default zoom level",
// "whole earth" => "whole earth",
// "country size" => "country size",
// "city size" => "city size",
// "max zoom" => "max zoom",
// "Internationalization" => "Internationalization",
// "Edit or export/import Languages" => "Edit or export/import Languages",
// "Babelfish links" => "Babelfish links",
// "Customized String Translation" => "Customized String Translation",
// "Syntax error" => "Syntax error",
// "Intertiki client" => "Intertiki client",
// "Tiki Unique key" => "Tiki Unique key",
// "InterTiki Slave mode" => "InterTiki Slave mode",
// "Warning: overrides manually registered local users" => "Warning: overrides manually registered local users",
// "as master" => "as master",
// "Import user preferences" => "Import user preferences",
// "Import user groups" => "Import user groups",
// "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)" => "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)",
// "Intertiki shared cookie for sliding auth under same domain" => "Intertiki shared cookie for sliding auth under same domain",
// "InterTiki Server" => "InterTiki Server",
// "host" => "host",
// "port" => "port",
// "Add new server" => "Add new server",
// "Intertiki server" => "Intertiki server",
// "Intertiki Server enabled" => "Intertiki Server enabled",
// "Access Log file" => "Access Log file",
// "Errors Log file" => "Errors Log file",
// "Known hosts" => "Known hosts",
// "Key" => "Key",
// "Kaltura Registration" => "Kaltura Registration",
// "If you don't have a Kaltura Partner Id, " => "If you don't have a Kaltura Partner Id, ",
// "click here" => "click here",
// "to register" => "to register",
// "Kaltura Partner Settings" => "Kaltura Partner Settings",
// "Partner Id" => "Partner Id",
// "User Secret" => "User Secret",
// "Admin Secret" => "Admin Secret",
// "Kaltura Dynamic Player" => "Kaltura Dynamic Player",
// "KDP UI Configuration Id" => "KDP UI Configuration Id",
// "KDP Widget Id" => "KDP Widget Id",
// "Kaltura Contribution Wizard" => "Kaltura Contribution Wizard",
// "KCW UI Configuration Id" => "KCW UI Configuration Id",
// "Kaltura Remix Editors" => "Kaltura Remix Editors",
// "Kaltura Simple Editor UI Configuration Id" => "Kaltura Simple Editor UI Configuration Id",
// "Kaltura Advance Editor UI Configuration Id" => "Kaltura Advance Editor UI Configuration Id",
// "Enable/disable Tiki features in " => "Enable/disable Tiki features in ",
// ", but configure them elsewhere" => ", but configure them elsewhere",
// "Wysiwyg" => "Wysiwyg",
// "Tiki and HTTP Auth" => "Tiki and HTTP Auth",
// "Users can register" => "Users can register",
// "Validate by email" => "Validate by email",
// "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a>" => "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a>",
// "Validate user's email server" => "Validate user's email server",
// "Require validation by Admin" => "Require validation by Admin",
// "Validator emails (separated by comma) if different than the sender email" => "Validator emails (separated by comma) if different than the sender email",
// "Require passcode to register" => "Require passcode to register",
// "Passcode" => "Passcode",
// "Users must enter this code to register" => "Users must enter this code to register",
// "Use CAPTCHA to prevent automatic/robot registrations" => "Use CAPTCHA to prevent automatic/robot registrations",
// "Requires PHP GD library" => "Requires PHP GD library",
// "Include &quot;Generate Password&quot; option on registration form" => "Include &quot;Generate Password&quot; option on registration form",
// "Users can select a group to join at registration" => "Users can select a group to join at registration",
// "By default, new users automatically join the Registered group" => "By default, new users automatically join the Registered group",
// "Url a user is redirected after account validation" => "Url a user is redirected after account validation",
// "Use tracker to collect more user information" => "Use tracker to collect more user information",
// "Use the <strong><a href=\"tiki-admingroups.php\" title=\"Admin Groups\">Admin: Groups</a></strong> page to select which tracker and fields to display" => "Use the <strong><a href=\"tiki-admingroups.php\" title=\"Admin Groups\">Admin: Groups</a></strong> page to select which tracker and fields to display",
// "Use tracker to collect more group information" => "Use tracker to collect more group information",
// "Re-validate user by email after" => "Re-validate user by email after",
// "Use <strong>-1</strong> for never" => "Use <strong>-1</strong> for never",
// "unsuccessful login attempts" => "unsuccessful login attempts",
// "Create a new group for each user" => "Create a new group for each user",
// "The group will be named identical to the user's username" => "The group will be named identical to the user's username",
// "Disable browser's autocomplete feature for username and password fields" => "Disable browser's autocomplete feature for username and password fields",
// "Use challenge/response authentication" => "Use challenge/response authentication",
// "Confirm that the Admin account has a valid email address or you will not be permitted to login" => "Confirm that the Admin account has a valid email address or you will not be permitted to login",
// "Use HTTPS login" => "Use HTTPS login",
// "Allow secure (https) login" => "Allow secure (https) login",
// "Encourage secure (https) login" => "Encourage secure (https) login",
// "Consider we are always in HTTPS, but do not check" => "Consider we are always in HTTPS, but do not check",
// "Require secure (https) login" => "Require secure (https) login",
// "Users can choose to stay in SSL mode after an HTTPS login" => "Users can choose to stay in SSL mode after an HTTPS login",
// "Users can switch between secured or standard mode at login" => "Users can switch between secured or standard mode at login",
// "HTTP port" => "HTTP port",
// "HTTPS port" => "HTTPS port",
// "Cookie name" => "Cookie name",
// "Use email as username" => "Use email as username",
// "Minimum length" => "Minimum length",
// "Force lowercase" => "Force lowercase",
// "Username pattern" => "Username pattern",
// "Store passwords in plain text is activated. You should never set this unless you know what you are doing" => "Store passwords in plain text is activated. You should never set this unless you know what you are doing",
// "Users can change their password" => "Users can change their password",
// "Require characters and numerals" => "Require characters and numerals",
// "Password expires after" => "Password expires after",
// "LDAP" => "LDAP",
// "You must change the Authentication Method to LDAP for these changes to take effect" => "You must change the Authentication Method to LDAP for these changes to take effect",
// "Create user if not in Tiki" => "Create user if not in Tiki",
// "Create user if not in LDAP" => "Create user if not in LDAP",
// "Use Tiki authentication for Admin login" => "Use Tiki authentication for Admin login",
// "Use Tiki authentication for users created in tiki" => "Use Tiki authentication for users created in tiki",
// "LDAP Bind settings" => "LDAP Bind settings",
// "Will override the Host and Port settings" => "Will override the Host and Port settings",
// "Write LDAP debug Information in Tiki Logs" => "Write LDAP debug Information in Tiki Logs",
// "Use SSL (ldaps)" => "Use SSL (ldaps)",
// "Use TLS" => "Use TLS",
// "LDAP Bind Type" => "LDAP Bind Type",
// "Default: userattr=username,UserDN,BaseDN" => "Default: userattr=username,UserDN,BaseDN",
// "userattr=username,BaseDN" => "userattr=username,BaseDN",
// "Active Directory (username@domain)" => "Active Directory (username@domain)",
// "Plain Username" => "Plain Username",
// "Search scope" => "Search scope",
// "Subtree" => "Subtree",
// "One level" => "One level",
// "Base object" => "Base object",
// "LDAP version" => "LDAP version",
// "Base DN" => "Base DN",
// "LDAP User" => "LDAP User",
// "User DN" => "User DN",
// "User attribute" => "User attribute",
// "User OC" => "User OC",
// "Realname attribute" => "Realname attribute",
// "Country attribute" => "Country attribute",
// "E-mail attribute" => "E-mail attribute",
// "Synchronize user attributes to tiki everytime the user logs in" => "Synchronize user attributes to tiki everytime the user logs in",
// "LDAP Group" => "LDAP Group",
// "Synchronize group attributes to tiki everytime the user logs in" => "Synchronize group attributes to tiki everytime the user logs in",
// "Note: this enables the usage of LDAP groups" => "Note: this enables the usage of LDAP groups",
// "Group DN" => "Group DN",
// "Group attribute" => "Group attribute",
// "Group description attribute" => "Group description attribute",
// "Group OC" => "Group OC",
// "LDAP Group Member - if group membership can be found in group attributes" => "LDAP Group Member - if group membership can be found in group attributes",
// "Member attribute" => "Member attribute",
// "Member is DN" => "Member is DN",
// "LDAP User Group - if group membership can be found in user attributes" => "LDAP User Group - if group membership can be found in user attributes",
// "Group attribute in group entry" => "Group attribute in group entry",
// "LDAP Admin" => "LDAP Admin",
// "Admin user" => "Admin user",
// "Admin password" => "Admin password",
// "PAM" => "PAM",
// "You must change the Authentication Method to PAM for these changes to take effect" => "You must change the Authentication Method to PAM for these changes to take effect",
// "PAM service" => "PAM service",
// "Currently unused" => "Currently unused",
// "Shibboleth Authentication " => "Shibboleth Authentication ",
// "You must change the Authentication Method to Shibboleth for these changes to take effect" => "You must change the Authentication Method to Shibboleth for these changes to take effect",
// "Valid affiliations" => "Valid affiliations",
// "Separate multiple affiliations with commas" => "Separate multiple affiliations with commas",
// "Create with default group" => "Create with default group",
// "CAS" => "CAS",
// "You must change the Authentication Method to CAS for these changes to take effect" => "You must change the Authentication Method to CAS for these changes to take effect",
// "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/" => "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/",
// "CAS server version" => "CAS server version",
// "Version 1.0" => "Version 1.0",
// "Version 2.0" => "Version 2.0",
// "CAS Server" => "CAS Server",
// "Hostname" => "Hostname",
// "You must enable PHP CAS first" => "You must enable PHP CAS first",
// "Themes" => "Themes",
// "Theme options" => "Theme options",
// "The \"users can change theme\" feature will override the theme displayed" => "The \"users can change theme\" feature will override the theme displayed",
// "Theme not saved yet - click \"Apply\"" => "Theme not saved yet - click \"Apply\"",
// "Theme Screenshot" => "Theme Screenshot",
// "Users can change theme" => "Users can change theme",
// "Restrict available themes" => "Restrict available themes",
// "Available styles" => "Available styles",
// "Each group can have its theme" => "Each group can have its theme",
// "Slideshow theme" => "Slideshow theme",
// "Edit CSS" => "Edit CSS",
// "Tiki Template Viewing" => "Tiki Template Viewing",
// "View Templates" => "View Templates",
// "General Layout options" => "General Layout options",
// "Custom HTML &lt;head&gt; Content" => "Custom HTML &lt;head&gt; Content",
// "Custom Site Header" => "Custom Site Header",
// "The Custom Site Header will display for the Admin only. Select <strong>Publish</strong> to display the content for </em>all<em> users" => "The Custom Site Header will display for the Admin only. Select <strong>Publish</strong> to display the content for </em>all<em> users",
// "Site Logo and Title" => "Site Logo and Title",
// "Logo source (image path)" => "Logo source (image path)",
// "Logo background color" => "Logo background color",
// "Examples" => "Examples",
// "Logo background style" => "Logo background style",
// "Logo alignment" => "Logo alignment",
// "Logo title (on mouse over)" => "Logo title (on mouse over)",
// "Alt. description (e.g. for text browsers)" => "Alt. description (e.g. for text browsers)",
// "Site title" => "Site title",
// "Search Bar" => "Search Bar",
// "Login Bar" => "Login Bar",
// "Top Bar" => "Top Bar",
// "Site menu bar" => "Site menu bar",
// "Requires CSS Menus or PHPLayers" => "Requires CSS Menus or PHPLayers",
// "Display current Tiki version" => "Display current Tiki version",
// "Custom code" => "Custom code",
// "Custom Center Column Header" => "Custom Center Column Header",
// "Left column" => "Left column",
// "only if module" => "only if module",
// "always" => "always",
// "user decides" => "user decides",
// "Users can Flip Columns" => "Users can Flip Columns",
// "Right column" => "Right column",
// "Prefix breadcrumbs with &quot;Location : &quot" => "Prefix breadcrumbs with &quot;Location : &quot",
// "Site location bar" => "Site location bar",
// "Top of page" => "Top of page",
// "Top of center column" => "Top of center column",
// "Larger font for" => "Larger font for",
// "Entire location" => "Entire location",
// "Use page description" => "Use page description",
// "Custom Site Footer" => "Custom Site Footer",
// "Custom End of &lt;body&gt; Code" => "Custom End of &lt;body&gt; Code",
// "Bottom bar" => "Bottom bar",
// "Bottom bar icons" => "Bottom bar icons",
// "Bottom bar debug" => "Bottom bar debug",
// "Bottom bar (RSS)" => "Bottom bar (RSS)",
// "Site Report Bar" => "Site Report Bar",
// "Webmaster Report" => "Webmaster Report",
// "Webmaster Email" => "Webmaster Email",
// "Leave <strong>blank</strong> to use the default sender email" => "Leave <strong>blank</strong> to use the default sender email",
// "Shadow layer" => "Shadow layer",
// "Additional layers for shadows, rounded corners or other decorative styling" => "Additional layers for shadows, rounded corners or other decorative styling",
// "Main shadow start" => "Main shadow start",
// "Main shadow end" => "Main shadow end",
// "Header shadow start" => "Header shadow start",
// "Header shadow end" => "Header shadow end",
// "Middle shadow start" => "Middle shadow start",
// "Middle shadow end" => "Middle shadow end",
// "Center shadow start" => "Center shadow start",
// "Center shadow end" => "Center shadow end",
// "Footer shadow start" => "Footer shadow start",
// "Footer shadow end" => "Footer shadow end",
// "Module (box) shadow start" => "Module (box) shadow start",
// "Module (box) shadow end" => "Module (box) shadow end",
// "Pagination links" => "Pagination links",
// "Maximum number of records in listings" => "Maximum number of records in listings",
// "Use relative (next / previous) pagination links" => "Use relative (next / previous) pagination links",
// "Use direct pagination links" => "Use direct pagination links",
// "Max. number of links around the current item" => "Max. number of links around the current item",
// "Max. number of links after the first or before the last item" => "Max. number of links after the first or before the last item",
// "Display 'First' and 'Last' links" => "Display 'First' and 'Last' links",
// "Display fast move links (by 10 percent of the total number of pages) " => "Display fast move links (by 10 percent of the total number of pages) ",
// "Hide pagination when there is only one page" => "Hide pagination when there is only one page",
// "Use Icons" => "Use Icons",
// "UI Effects" => "UI Effects",
// "JQuery plugins and add-ons" => "JQuery plugins and add-ons",
// "Requires jquery feature" => "Requires jquery feature",
// "Tooltips" => "Tooltips",
// "JQuery Tooltips: Customisable help tips" => "JQuery Tooltips: Customisable help tips",
// "Autocomplete" => "Autocomplete",
// "JQuery Autocomplete" => "JQuery Autocomplete",
// "Superfish" => "Superfish",
// "JQuery Superfish (effects on CSS menus)" => "JQuery Superfish (effects on CSS menus)",
// "Reflection" => "Reflection",
// "JQuery Reflection (reflection effect on images)" => "JQuery Reflection (reflection effect on images)",
// "JQuery UI" => "JQuery UI",
// "JQuery UI: More JQuery functionality" => "JQuery UI: More JQuery functionality",
// "JQuery UI Theme" => "JQuery UI Theme",
// "JQuery UI Theme: Themes for look and feel of JQuery UI widgets" => "JQuery UI Theme: Themes for look and feel of JQuery UI widgets",
// "For future use" => "For future use",
// "Cycle" => "Cycle",
// "slideshow" => "slideshow",
// "JQuery Cycle (slideshow)" => "JQuery Cycle (slideshow)",
// "JQuery Sheet" => "JQuery Sheet",
// "JQuery Spreadsheet" => "JQuery Spreadsheet",
// "JQuery Sortable Tables" => "JQuery Sortable Tables",
// "Standard UI effects" => "Standard UI effects",
// "Effect for modules" => "Effect for modules",
// "Slide" => "Slide",
// "Blind (UI)" => "Blind (UI)",
// "Clip (UI)" => "Clip (UI)",
// "Drop (UI)" => "Drop (UI)",
// "Explode (UI)" => "Explode (UI)",
// "Fold (UI)" => "Fold (UI)",
// "Puff (UI)" => "Puff (UI)",
// "Slide (UI)" => "Slide (UI)",
// "Main JQuery effect" => "Main JQuery effect",
// "Speed" => "Speed",
// "Fast" => "Fast",
// "Slow" => "Slow",
// "Vertical" => "Vertical",
// "Horizontal" => "Horizontal",
// "Tab UI effects" => "Tab UI effects",
// "Effect for tabs" => "Effect for tabs",
// "JQuery effect for tabs" => "JQuery effect for tabs",
// "Use Tabs" => "Use Tabs",
// "Layout per section" => "Layout per section",
// "Admin layout per section" => "Admin layout per section",
// "Correct PNG images alpha transparency in IE6 (experimental)" => "Correct PNG images alpha transparency in IE6 (experimental)",
// "CSS selectors to be fixed" => "CSS selectors to be fixed",
// "Separate multiple elements with a comma (&nbsp;,&nbsp;)" => "Separate multiple elements with a comma (&nbsp;,&nbsp;)",
// "HTMLDomElements to be fixed" => "HTMLDomElements to be fixed",
// "Favicon" => "Favicon",
// "Favicon icon file name" => "Favicon icon file name",
// "Favicon icon MIME type" => "Favicon icon MIME type",
// "image/png" => "image/png",
// "image/bmp" => "image/bmp",
// "image/x-icon" => "image/x-icon",
// "Context Menus" => "Context Menus",
// "Currently used in File Galleries only" => "Currently used in File Galleries only",
// "Use context menus for actions (icons)" => "Use context menus for actions (icons)",
// "Use context menus for actions (text)" => "Use context menus for actions (text)",
// "Separators" => "Separators",
// "Generate User Map" => "Generate User Map",
// "Meta tags" => "Meta tags",
// "Geo URL" => "Geo URL",
// "Robots" => "Robots",
// "&quot;Modules&quot; are the boxes of content in the right &amp; left columns" => "&quot;Modules&quot; are the boxes of content in the right &amp; left columns",
// "Admin &gt; Modules" => "Admin &gt; Modules",
// "from the menu to create and edit modules" => "from the menu to create and edit modules",
// "Hint: If you lose your login module, use tiki-login_scr.php to be able to login" => "Hint: If you lose your login module, use tiki-login_scr.php to be able to login",
// "It works with the File Gallery, wiki pages (via a plugin), and a new multimedia tracker item" => "It works with the File Gallery, wiki pages (via a plugin), and a new multimedia tracker item",
// "Save Preferences" => "Save Preferences",
// "ProgressBarPlay Color" => "ProgressBarPlay Color",
// "ProgressBarLoad Color" => "ProgressBarLoad Color",
// "ProgressBarButton Color" => "ProgressBarButton Color",
// "ProgressBar Color" => "ProgressBar Color",
// "Volume On Color" => "Volume On Color",
// "Volume Off Color" => "Volume Off Color",
// "Volume Button Color" => "Volume Button Color",
// "Button Color" => "Button Color",
// "Button Pressed Color" => "Button Pressed Color",
// "Button Over Color" => "Button Over Color",
// "Button Info Color" => "Button Info Color",
// "Button Info Pressed Color" => "Button Info Pressed Color",
// "Button Info Over Color" => "Button Info Over Color",
// "Button Info Text Color" => "Button Info Text Color",
// "ID3 Tag Color" => "ID3 Tag Color",
// "Play Time Color" => "Play Time Color",
// "Total Time Color" => "Total Time Color",
// "Panel Display Color" => "Panel Display Color",
// "Alert Message Color" => "Alert Message Color",
// "Flash Length" => "Flash Length",
// "Flash Heigth" => "Flash Heigth",
// "Video Length" => "Video Length",
// "Video Heigth" => "Video Heigth",
// "Preload Delay" => "Preload Delay",
// "Max Play time" => "Max Play time",
// "URL Append" => "URL Append",
// "Message after limited time" => "Message after limited time",
// "ID of System File Galleries to upload multimedia files" => "ID of System File Galleries to upload multimedia files",
// "Please see the <a class='rbox-link' target='tikihelp' href='http://dev.tikiwiki.org/Performance'>Performance page</a> on Tiki's developer site" => "Please see the <a class='rbox-link' target='tikihelp' href='http://dev.tikiwiki.org/Performance'>Performance page</a> on Tiki's developer site",
// "Output compression is active" => "Output compression is active",
// "Compression is handled by" => "Compression is handled by",
// "Many search options impact performance. Please see <a href=\"tiki-admin.php?page=search\">Search admin panel</a>" => "Many search options impact performance. Please see <a href=\"tiki-admin.php?page=search\">Search admin panel</a>",
// "To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or",
// "Loading profile" => "Loading profile",
// "Are you sure you want to apply the profile" => "Are you sure you want to apply the profile",
// "Sending" => "Sending",
// "Waiting" => "Waiting",
// "TikiWiki Profiles" => "TikiWiki Profiles",
// "The following list of changes has been applied" => "The following list of changes has been applied",
// "Apply Profiles" => "Apply Profiles",
// "A Friendly Warning" => "A Friendly Warning",
// "Some of your Profiles Repositories are not connecting. This may prevent you from applying certain profiles" => "Some of your Profiles Repositories are not connecting. This may prevent you from applying certain profiles",
// "Option 1: Quick Filter" => "Option 1: Quick Filter",
// "Option 2: Manual Filter" => "Option 2: Manual Filter",
// "Filter the list of profiles" => "Filter the list of profiles",
// "Profile" => "Profile",
// "Repository" => "Repository",
// "applied" => "applied",
// "Profile repository" => "Profile repository",
// "Last update" => "Last update",
// "Javascript must be turned <b>ON</b> in order to apply Profiles. Please enable your javascript and try again" => "Javascript must be turned <b>ON</b> in order to apply Profiles. Please enable your javascript and try again",
// "Repositories" => "Repositories",
// "Repository URLs" => "Repository URLs",
// "Enter multiple repository URLs, one per line" => "Enter multiple repository URLs, one per line",
// "Data Channels" => "Data Channels",
// "Data channels create a named pipe to run profiles from user space. One channel per line. Each line is comma delimited and contain <strong>channel name, domain, profile, allowed groups</strong>. " => "Data channels create a named pipe to run profiles from user space. One channel per line. Each line is comma delimited and contain <strong>channel name, domain, profile, allowed groups</strong>. ",
// "More information" => "More information",
// "Profile tester" => "Profile tester",
// "This will run the profile and make potentially unrecoverable changes in your database" => "This will run the profile and make potentially unrecoverable changes in your database",
// "Test Profile Name" => "Test Profile Name",
// "Use this page to configure the feeds generated by Tiki. To syndicate feeds from other sites, use the <strong>Admin</strong> &gt; <strong>External Feeds</strong> menu option, or" => "Use this page to configure the feeds generated by Tiki. To syndicate feeds from other sites, use the <strong>Admin</strong> &gt; <strong>External Feeds</strong> menu option, or",
// "External feeds" => "External feeds",
// "Maximum number of items to display" => "Maximum number of items to display",
// "Show Author" => "Show Author",
// "Homepage URL" => "Homepage URL",
// "Map files" => "Map files",
// "Default RDF version" => "Default RDF version",
// "Specification" => "Specification",
// "Documentation" => "Documentation",
// "Editor" => "Editor",
// "Webmaster" => "Webmaster",
// "Image Path" => "Image Path",
// "Caching time" => "Caching time",
// "Use <strong>0</strong> for no caching" => "Use <strong>0</strong> for no caching",
// "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public" => "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public",
// "You can see users rank by score in the module users_rank, for that go to" => "You can see users rank by score in the module users_rank, for that go to",
// "Admin modules" => "Admin modules",
// "Expiration" => "Expiration",
// "can be seen on page" => "can be seen on page",
// "in Admin menu" => "in Admin menu",
// "Search type" => "Search type",
// "This search uses the MySQL Full-Text feature" => "This search uses the MySQL Full-Text feature",
// "The indexation is always updated" => "The indexation is always updated",
// "Tiki search" => "Tiki search",
// "Specify the Tiki search settings" => "Specify the Tiki search settings",
// "Use <strong>0</strong> for no refresh" => "Use <strong>0</strong> for no refresh",
// "The Tiki search indexes must be refreshed if you turn the Tiki search on" => "The Tiki search indexes must be refreshed if you turn the Tiki search on",
// "Refresh all search index now" => "Refresh all search index now",
// "Refresh trackers search index now" => "Refresh trackers search index now",
// "Refresh tracker search index now" => "Refresh tracker search index now",
// "Refresh files search index now" => "Refresh files search index now",
// "May impact performance" => "May impact performance",
// "Enabling these options will improve performance, but may show forbidden results" => "Enabling these options will improve performance, but may show forbidden results",
// "Search Results" => "Search Results",
// "Select the items to display on the search results page" => "Select the items to display on the search results page",
// "Select the information to display for each result" => "Select the information to display for each result",
// "Please see the <a class='rbox-link' target='tikihelp' href='http://dev.tikiwiki.org/Security'>Security page</a> on Tiki's developer site" => "Please see the <a class='rbox-link' target='tikihelp' href='http://dev.tikiwiki.org/Security'>Security page</a> on Tiki's developer site",
// "See <a href=\"tiki-admin_security.php\" title=\"Security\"><strong>Admin &gt; Security Admin</strong></a> for additional security settings" => "See <a href=\"tiki-admin_security.php\" title=\"Security\"><strong>Admin &gt; Security Admin</strong></a> for additional security settings",
// "CSRF Security" => "CSRF Security",
// "Use these options to protect against cross-site request forgeries (CSRF)" => "Use these options to protect against cross-site request forgeries (CSRF)",
// "SEFURL will not work unless Tiki specific directives are deployed to the .htaccess file. You will need to execute htaccess.sh or manually configure the .htaccess file" => "SEFURL will not work unless Tiki specific directives are deployed to the .htaccess file. You will need to execute htaccess.sh or manually configure the .htaccess file",
// "List of Url Parameters that should go in the path" => "List of Url Parameters that should go in the path",
// "Known Types" => "Known Types",
// "Token" => "Token",
// "Invert" => "Invert",
// "Show Usage" => "Show Usage",
// "Delete &amp; Unreference" => "Delete &amp; Unreference",
// "Invert Relation" => "Invert Relation",
// "Self" => "Self",
// "New Types" => "New Types",
// "Fix" => "Fix",
// "No occurences found" => "No occurences found",
// "Text area (that apply throughout many features)" => "Text area (that apply throughout many features)",
// "Wiki paragraph formatting" => "Wiki paragraph formatting",
// "...but still create line breaks within paragraphs" => "...but still create line breaks within paragraphs",
// "Parse wiki syntax in comments in all sections apart from Forums" => "Parse wiki syntax in comments in all sections apart from Forums",
// "Automonospaced text" => "Automonospaced text",
// "Tables syntax" => "Tables syntax",
// "|| for rows" => "|| for rows",
// "&lt;return&gt; for rows" => "&lt;return&gt; for rows",
// "Open Hotwords in new window" => "Open Hotwords in new window",
// "Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting" => "Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting",
// "Plugin disabled" => "Plugin disabled",
// "Default size" => "Default size",
// "rows" => "rows",
// "Comments " => "Comments ",
// "Forum reply" => "Forum reply",
// "External links and images" => "External links and images",
// "External links will be identified with" => "External links will be identified with",
// "Plugins" => "Plugins",
// "About plugins" => "About plugins",
// "Tiki plugins add functionality to wiki pages, articles and blogs etc. You can enable and disable them below" => "Tiki plugins add functionality to wiki pages, articles and blogs etc. You can enable and disable them below",
// "You can approve plugin use at <a href=\"tiki-plugins.php\">tiki-plugins.php</a>" => "You can approve plugin use at <a href=\"tiki-plugins.php\">tiki-plugins.php</a>",
// "The edit plugin icon is an easy way for users to edit the parameters of each plugin in wiki pages. It can be disabled for individual plugins below" => "The edit plugin icon is an easy way for users to edit the parameters of each plugin in wiki pages. It can be disabled for individual plugins below",
// "Edit plugin icons" => "Edit plugin icons",
// "Enable" => "Enable",
// "Disable edit plugin icon (make plugin inline)" => "Disable edit plugin icon (make plugin inline)",
// "Plugin Aliases" => "Plugin Aliases",
// "About plugin aliases" => "About plugin aliases",
// "Tiki plugin aliases allow you to define your own custom configurations of existing plugins.<br />Find out more here: {help url=\"Plugin+Alias\"}" => "Tiki plugin aliases allow you to define your own custom configurations of existing plugins.<br />Find out more here: {help url=\"Plugin+Alias\"}",
// "This page is designed to work with JQuery {icon _id=\"arrow_right\" href=\"tiki-admin.php?page=features\"}" => "This page is designed to work with JQuery {icon _id=\"arrow_right\" href=\"tiki-admin.php?page=features\"}",
// "Available Alias" => "Available Alias",
// "Enable Plugins" => "Enable Plugins",
// "General Information" => "General Information",
// "Plugin Name" => "Plugin Name",
// "Base Plugin" => "Base Plugin",
// "Body Label" => "Body Label",
// "Dependencies" => "Dependencies",
// "Validation" => "Validation",
// "Inline (No Plugin Edit UI)" => "Inline (No Plugin Edit UI)",
// "Simple Plugin Arguments" => "Simple Plugin Arguments",
// "Argument" => "Argument",
// "New Argument" => "New Argument",
// "Plugin Parameter Documentation" => "Plugin Parameter Documentation",
// "Safe" => "Safe",
// "Plugin Body" => "Plugin Body",
// "Ignore User Input" => "Ignore User Input",
// "Default Content" => "Default Content",
// "Encoding" => "Encoding",
// "Argument Source (if different)" => "Argument Source (if different)",
// "Default Value" => "Default Value",
// "Composed Plugin Arguments" => "Composed Plugin Arguments",
// "Pattern" => "Pattern",
// "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or",
// "Tracker attachment preferences" => "Tracker attachment preferences",
// "Use database to store files" => "Use database to store files",
// "Use a directory to store files" => "Use a directory to store files",
// "Tracker attachments" => "Tracker attachments",
// "dls" => "dls",
// "Switch storage" => "Switch storage",
// "Trackers with mirror tables" => "Trackers with mirror tables",
// "Use trackers with mirror tables" => "Use trackers with mirror tables",
// "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki" => "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki",
// "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely" => "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely",
// "Do not use this feature as it is very buggy and unmaintained. It will be pulled out of the code base later on" => "Do not use this feature as it is very buggy and unmaintained. It will be pulled out of the code base later on",
// "Validate choice" => "Validate choice",
// "Use database to store userfiles" => "Use database to store userfiles",
// "Use a directory to store userfiles" => "Use a directory to store userfiles",
// "Enter the URL of a web services returning either JSON or YAML. Parameters can be specified by enclosing a name between percentage signs. For example: %name%. %service% and %template% are reserved keywords and cannot be used" => "Enter the URL of a web services returning either JSON or YAML. Parameters can be specified by enclosing a name between percentage signs. For example: %name%. %service% and %template% are reserved keywords and cannot be used",
// "Lookup" => "Lookup",
// "Test Input" => "Test Input",
// "Response Information" => "Response Information",
// "OIntegrate Version" => "OIntegrate Version",
// "Not supported" => "Not supported",
// "Schema Version" => "Schema Version",
// "Schema Documentation" => "Schema Documentation",
// "Available" => "Available",
// "Not specified, default used" => "Not specified, default used",
// "Content Type" => "Content Type",
// "Not specified" => "Not specified",
// "Returned Data" => "Returned Data",
// "Proposed Templates" => "Proposed Templates",
// "Register this web service. It will be possible to register the templates afterwards. Service name must only contain letters" => "Register this web service. It will be possible to register the templates afterwards. Service name must only contain letters",
// "Register Service" => "Register Service",
// "Registered Templates" => "Registered Templates",
// "Engine" => "Engine",
// "Output" => "Output",
// "Register Template" => "Register Template",
// "Use the 'Quick Edit' module to easily create or edit wiki pages" => "Use the 'Quick Edit' module to easily create or edit wiki pages",
// "Select <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">Admin &gt; Modules</a> to add this (or other) modules" => "Select <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">Admin &gt; Modules</a> to add this (or other) modules",
// "Page display" => "Page display",
// "Page ID" => "Page ID",
// "Page version" => "Page version",
// "List authors" => "List authors",
// "Allow override per page" => "Allow override per page",
// "Not Installed" => "Not Installed",
// "Warn on edit conflict" => "Warn on edit conflict",
// "Edit idle timeout" => "Edit idle timeout",
// "Footnotes" => "Footnotes",
// "Edit section" => "Edit section",
// "Edit section level" => "Edit section level",
// "Toggle display of section and plugin edit icons" => "Toggle display of section and plugin edit icons",
// "Allow minor edits" => "Allow minor edits",
// "Minor edits do not flag new content for translation and do not send watch notifications" => "Minor edits do not flag new content for translation and do not send watch notifications",
// "Only user groups granted the tiki_p_minor permission (and admins) will be able to save minor edits when this is enabled" => "Only user groups granted the tiki_p_minor permission (and admins) will be able to save minor edits when this is enabled",
// "Log bytes changes (+/-) in action logs" => "Log bytes changes (+/-) in action logs",
// "Display by default" => "Display by default",
// "Dumps" => "Dumps",
// "Tag for current wiki" => "Tag for current wiki",
// "Restore wiki to tag" => "Restore wiki to tag",
// "Restore" => "Restore",
// "Remove a tag" => "Remove a tag",
// "Generate dump" => "Generate dump",
// "Download last dump" => "Download last dump",
// "Pictures" => "Pictures",
// "Use File Galleries to store pictures " => "Use File Galleries to store pictures ",
// "WikiWords" => "WikiWords",
// "Accept dashes and underscores in WikiWords" => "Accept dashes and underscores in WikiWords",
// "Link plural WikiWords to their singular forms" => "Link plural WikiWords to their singular forms",
// "Maximum number of versions" => "Maximum number of versions",
// "Never delete versions younger than" => "Never delete versions younger than",
// "Display IP address" => "Display IP address",
// "Default diff style" => "Default diff style",
// "Only with last version" => "Only with last version",
// "History all instead of only page data, description, and change comment" => "History all instead of only page data, description, and change comment",
// "View source" => "View source",
// "Polls are disabled" => "Polls are disabled",
// "like pages" => "like pages",
// "Open page as structure" => "Open page as structure",
// "Make structure from page" => "Make structure from page",
// "Categorize structure pages together" => "Categorize structure pages together",
// "A page can occur multiple times in a structure" => "A page can occur multiple times in a structure",
// "Import HTML" => "Import HTML",
// "Import pages" => "Import pages",
// "Slideshows" => "Slideshows",
// "User's page" => "User's page",
// "UserPage prefix" => "UserPage prefix",
// "Users can lock pages" => "Users can lock pages",
// "Page creators are admin of their pages" => "Page creators are admin of their pages",
// "MultiPrint" => "MultiPrint",
// "Wiki watch" => "Wiki watch",
// "Create watch for author on page creation" => "Create watch for author on page creation",
// "Enable watch events when I am the editor" => "Enable watch events when I am the editor",
// "Enable watches on comments" => "Enable watches on comments",
// "Watch minor edits" => "Watch minor edits",
// "Staging &amp; Approval" => "Staging &amp; Approval",
// "Use wiki page staging and approval" => "Use wiki page staging and approval",
// "Force bounce of editing of approved pages to staging" => "Force bounce of editing of approved pages to staging",
// "Delete staging pages at approval" => "Delete staging pages at approval",
// "If not in the group, edit is always redirected to the staging page edit" => "If not in the group, edit is always redirected to the staging page edit",
// "Unique page name prefix to indicate staging copy" => "Unique page name prefix to indicate staging copy",
// "Hide page name prefix" => "Hide page name prefix",
// "Staging" => "Staging",
// "Approved" => "Approved",
// "(mandatory for feature to work)" => "(mandatory for feature to work)",
// "Out-of-sync" => "Out-of-sync",
// "Categorize approved pages with categories of staging copy on approval" => "Categorize approved pages with categories of staging copy on approval",
// "Freetags are disabled" => "Freetags are disabled",
// "Replace freetags with that of staging pages, on approval" => "Replace freetags with that of staging pages, on approval",
// "Add new freetags of approved copy (into tags field) when editing staging pages" => "Add new freetags of approved copy (into tags field) when editing staging pages",
// "Page Listings" => "Page Listings",
// "Pages not in structure" => "Pages not in structure",
// "Configuration" => "Configuration",
// "Select which items to display when listing pages" => "Select which items to display when listing pages",
// "Edit comments" => "Edit comments",
// "Edit Comments length" => "Edit Comments length",
// "Categories path" => "Categories path",
// "Wiki 3D Browser Configuration" => "Wiki 3D Browser Configuration",
// "Camera settings" => "Camera settings",
// "Upload Type" => "Upload Type",
// "Data location" => "Data location",
// "HTTP Prefix" => "HTTP Prefix",
// "WebDav username" => "WebDav username",
// "WebDav password" => "WebDav password",
// "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>" => "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>",
// "Wysiwyg Editor Features" => "Wysiwyg Editor Features",
// "Development Notice" => "Development Notice",
// "Unless a significant amount of preferences are documented and use dynamic preferences before the 4.0 release, this search feature will become disabled by default" => "Unless a significant amount of preferences are documented and use dynamic preferences before the 4.0 release, this search feature will become disabled by default",
// "Database Version Problem" => "Database Version Problem",
// "Your database requires an update to match the current TikiWiki version. Please proceed to <a href=\"tiki-install.php\">the installer</a>. Using Tiki with an incorrect database version usually provoke errors" => "Your database requires an update to match the current TikiWiki version. Please proceed to <a href=\"tiki-install.php\">the installer</a>. Using Tiki with an incorrect database version usually provoke errors",
// "A new version of Tikiwiki, <b>{\$prefs.tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>" => "A new version of Tikiwiki, <b>{\$prefs.tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>",
// "disabled" => "disabled",
// "enabled" => "enabled",
// "preference" => "preference",
// "preference name" => "preference name",
// "Crosslinks to other features and settings" => "Crosslinks to other features and settings",
// "Other sections" => "Other sections",
// "Spreadsheet" => "Spreadsheet",
// "Live Support" => "Live Support",
// "Administration features" => "Administration features",
// "TikiCache/System" => "TikiCache/System",
// "SysLogs" => "SysLogs",
// "phpinfo" => "phpinfo",
// "Mods" => "Mods",
// "Edit Languages" => "Edit Languages",
// "Transversal features" => "Transversal features",
// "which apply to more than one section" => "which apply to more than one section",
// "Mail Notifications" => "Mail Notifications",
// "Navigation features" => "Navigation features",
// "Look & feel" => "Look & feel",
// "themes" => "themes",
// "Text area features" => "Text area features",
// "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc" => "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc",
// "External Pages Cache" => "External Pages Cache",
// "Content Templates" => "Content Templates",
// "External Wikis" => "External Wikis",
// "Stats &amp; banners" => "Stats &amp; banners",
// "Report" => "Report",
// "Please select some actions to view" => "Please select some actions to view",
// "bytes" => "bytes",
// "kb" => "kb",
// "Graph Contributions" => "Graph Contributions",
// "Group Bar Plot" => "Group Bar Plot",
// "Accumulated Bar Plot" => "Accumulated Bar Plot",
// "Legend background color" => "Legend background color",
// "Save graphs to image gallery" => "Save graphs to image gallery",
// "See Statistics" => "See Statistics",
// "contribution" => "contribution",
// "contributor" => "contributor",
// "Volumes are equally distributed on each contributors/author" => "Volumes are equally distributed on each contributors/author",
// "connection time" => "connection time",
// "connection seconds" => "connection seconds",
// "mns" => "mns",
// "Volumn per category" => "Volumn per category",
// "Volumn per category and per user" => "Volumn per category and per user",
// "Number of actions per user" => "Number of actions per user",
// "Total number of users" => "Total number of users",
// "Number of actions per object" => "Number of actions per object",
// "Total number of objects" => "Total number of objects",
// "Number of actions per category" => "Number of actions per category",
// "Number of actions per category and per user" => "Number of actions per category and per user",
// "Volumn per the users'group and per contribution" => "Volumn per the users'group and per contribution",
// "Volumn per group and per contribution" => "Volumn per group and per contribution",
// "Volumn per user and per contribution" => "Volumn per user and per contribution",
// "Volumn per users'contribution and time" => "Volumn per users'contribution and time",
// "Volumn per contribution and time" => "Volumn per contribution and time",
// "Setting" => "Setting",
// "recorded" => "recorded",
// "viewed" => "viewed",
// "Wiki page actions except viewed will always be recorded but can be not reported" => "Wiki page actions except viewed will always be recorded but can be not reported",
// "Add or edit a rule" => "Add or edit a rule",
// "Rule title" => "Rule title",
// "Username regex matching" => "Username regex matching",
// "IP regex matching" => "IP regex matching",
// "Banned from sections" => "Banned from sections",
// "Rule activated by dates" => "Rule activated by dates",
// "Rule active from" => "Rule active from",
// "Rule active until" => "Rule active until",
// "Custom message to the user" => "Custom message to the user",
// "x" => "x",
// "Create Calendar" => "Create Calendar",
// "View Calendars" => "View Calendars",
// "Loc" => "Loc",
// "Cat" => "Cat",
// "Lang" => "Lang",
// "Prio" => "Prio",
// "Subscription" => "Subscription",
// "Perso" => "Perso",
// "View Calendar" => "View Calendar",
// "Create / Edit Calendar" => "Create / Edit Calendar",
// "Create/Edit Calendars" => "Create/Edit Calendars",
// "Custom Locations" => "Custom Locations",
// "Custom Participants" => "Custom Participants",
// "Custom Categories" => "Custom Categories",
// "Custom Languages" => "Custom Languages",
// "Custom URL" => "Custom URL",
// "Custom Subscription List" => "Custom Subscription List",
// "Custom Priorities" => "Custom Priorities",
// "Standard Colors" => "Standard Colors",
// "Green" => "Green",
// "Blue" => "Blue",
// "Purple" => "Purple",
// "Orange" => "Orange",
// "Yellow" => "Yellow",
// "Let me select my own colors" => "Let me select my own colors",
// "Ex" => "Ex",
// "Default event status" => "Default event status",
// "Show in calendar view" => "Show in calendar view",
// "Group of users alerted when calendar event is modified" => "Group of users alerted when calendar event is modified",
// "Browse the category system" => "Browse the category system",
// "Use the Administration page of each enabled feature to allow the use of content templates" => "Use the Administration page of each enabled feature to allow the use of content templates",
// "CMS" => "CMS",
// "HTML Pages" => "HTML Pages",
// "No features are configured to use templates" => "No features are configured to use templates",
// "Visible in no sections" => "Visible in no sections",
// "Remove section" => "Remove section",
// "Contributions are mandatory in wiki pages" => "Contributions are mandatory in wiki pages",
// "Contributions are mandatory in forums" => "Contributions are mandatory in forums",
// "Contributions are mandatory in comments" => "Contributions are mandatory in comments",
// "Contributions are mandatory in blogs" => "Contributions are mandatory in blogs",
// "Contributions are displayed in the comment/post" => "Contributions are displayed in the comment/post",
// "Create a new contribution" => "Create a new contribution",
// "List of contributions" => "List of contributions",
// "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}" => "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}",
// "Admin dsn" => "Admin dsn",
// "Use Admin DSN to define the database to be used by the SQL plugin" => "Use Admin DSN to define the database to be used by the SQL plugin",
// "Create/edit dsn" => "Create/edit dsn",
// "Admin external wikis" => "Admin external wikis",
// "Admin External Wikis" => "Admin External Wikis",
// "tiki admin external wikis template" => "tiki admin external wikis template",
// "URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)" => "URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)",
// "Coms" => "Coms",
// "Age" => "Age",
// "PPD" => "PPD",
// ".." => "..",
// "Create/Edit Forums" => "Create/Edit Forums",
// "Originating e-mail address for mails from this forum" => "Originating e-mail address for mails from this forum",
// "Set thread preferences" => "Set thread preferences",
// "Show threads preferences" => "Show threads preferences",
// "hide threads preferences" => "hide threads preferences",
// "Default ordering for threads" => "Default ordering for threads",
// "Default style for threads" => "Default style for threads",
// "Duplicate Forum" => "Duplicate Forum",
// "Duplicate" => "Duplicate",
// "Admin Hotwords" => "Admin Hotwords",
// "Add Hotword" => "Add Hotword",
// "Word" => "Word",
// "Admin HTML Page Dynamic Zones" => "Admin HTML Page Dynamic Zones",
// "Admin HTML pages" => "Admin HTML pages",
// "Edit zone" => "Edit zone",
// "Dynamic zones" => "Dynamic zones",
// "zone" => "zone",
// "content" => "content",
// "Mass update" => "Mass update",
// "Create new HTML page" => "Create new HTML page",
// "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones" => "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones",
// "Edit this HTML page" => "Edit this HTML page",
// "Dynamic" => "Dynamic",
// "Static" => "Static",
// "Refresh rate (if dynamic)" => "Refresh rate (if dynamic)",
// "Admin dynamic zones" => "Admin dynamic zones",
// "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature" => "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature",
// "Edit Repository" => "Edit Repository",
// "Create New Repository" => "Create New Repository",
// "List Repositories" => "List Repositories",
// "New Repository" => "New Repository",
// "View Repository" => "View Repository",
// "Human readable repository name" => "Human readable repository name",
// "Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')" => "Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')",
// "CSS file to load when browse this repository" => "CSS file to load when browse this repository",
// "CSS file" => "CSS file",
// "Is repository visible to users" => "Is repository visible to users",
// "Can files from repository be cached" => "Can files from repository be cached",
// "Cacheable" => "Cacheable",
// "Are files from repository can be cached" => "Are files from repository can be cached",
// "Clear all cached pages of this repository" => "Clear all cached pages of this repository",
// "Clear cache" => "Clear cache",
// "Seconds count 'till cached page will be expired" => "Seconds count 'till cached page will be expired",
// "Cache expiration" => "Cache expiration",
// "Human readable text description of repository" => "Human readable text description of repository",
// "Available Repositories" => "Available Repositories",
// "Edit Rules for Repository" => "Edit Rules for Repository",
// "Configure Repositories" => "Configure Repositories",
// "Configure this Repository" => "Configure this Repository",
// "View this Repository" => "View this Repository",
// "view/hide copy rules dialog" => "view/hide copy rules dialog",
// "Source repository" => "Source repository",
// "Copy" => "Copy",
// "According this order rules will be applied ('0' or empty = auto)" => "According this order rules will be applied ('0' or empty = auto)",
// "Rule order" => "Rule order",
// "Text to search for" => "Text to search for",
// "Text to replace" => "Text to replace",
// "Is this regular expression or simple search/replacer" => "Is this regular expression or simple search/replacer",
// "Regex" => "Regex",
// "Is case sensitive (for simple replacer)" => "Is case sensitive (for simple replacer)",
// "Case sensitive" => "Case sensitive",
// "subset of chars: imsxeADSXUu, which is regex modifiers" => "subset of chars: imsxeADSXUu, which is regex modifiers",
// "Regex modifiers" => "Regex modifiers",
// "Human readable text description of rule" => "Human readable text description of rule",
// "Check to enable this rule" => "Check to enable this rule",
// "Enabled" => "Enabled",
// "Preview options" => "Preview options",
// "Apply all rules or just this to generate preview" => "Apply all rules or just this to generate preview",
// "Apply all rules" => "Apply all rules",
// "View source code after rules applied" => "View source code after rules applied",
// "Code preview" => "Code preview",
// "Generate HTML preview" => "Generate HTML preview",
// "HTML preview" => "HTML preview",
// "Test file from repository to generate preview for (empty = configured start page)" => "Test file from repository to generate preview for (empty = configured start page)",
// "Preview Results" => "Preview Results",
// "Rules List" => "Rules List",
// "Case" => "Case",
// "Admin layout" => "Admin layout",
// "layout options" => "layout options",
// "Top bar" => "Top bar",
// "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>" => "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>",
// "Generate positions by hits" => "Generate positions by hits",
// "List of featured links" => "List of featured links",
// "Position" => "Position",
// "Add Featured Link" => "Add Featured Link",
// "Edit this Featured Link" => "Edit this Featured Link",
// "Create new Featured Link" => "Create new Featured Link",
// "disables the link" => "disables the link",
// "Link type" => "Link type",
// "replace current page" => "replace current page",
// "framed" => "framed",
// "open new window" => "open new window",
// "Mail-in accounts" => "Mail-in accounts",
// "Account" => "Account",
// "Add new Mail-in account" => "Add new Mail-in account",
// "Edit Mail-in account" => "Edit Mail-in account",
// "Account name" => "Account name",
// "POP server" => "POP server",
// "SMTP server" => "SMTP server",
// "SMTP requires authentication" => "SMTP requires authentication",
// "article-put" => "article-put",
// "wiki-get" => "wiki-get",
// "wiki-put" => "wiki-put",
// "wiki-append" => "wiki-append",
// "Article Topic" => "Article Topic",
// "Article Type" => "Article Type",
// "Admin Types" => "Admin Types",
// "Allow anonymous acces" => "Allow anonymous acces",
// "Discard to the end from" => "Discard to the end from",
// "Check Mail-in accounts" => "Check Mail-in accounts",
// "Show Quick Urls" => "Show Quick Urls",
// "Some useful URLs" => "Some useful URLs",
// "Hide Quick Urls" => "Hide Quick Urls",
// "Separate multiple sections with a comma ( , ) for an AND or a vertical bar ( | ) for an OR" => "Separate multiple sections with a comma ( , ) for an AND or a vertical bar ( | ) for an OR",
// "Separate multiple permissions with a comma ( , ) for an AND or a vertical bar ( | ) for an OR" => "Separate multiple permissions with a comma ( , ) for an AND or a vertical bar ( | ) for an OR",
// "Selecting 2 groups means that the option will be seen if the user belongs to the 2 groups. If you want the 2 groups to see the option, create 2 options with one group each" => "Selecting 2 groups means that the option will be seen if the user belongs to the 2 groups. If you want the 2 groups to see the option, create 2 options with one group each",
// "If the url is ((PageName)), you do not need to put the groups, the option will be displayed only if the page can be displayed" => "If the url is ((PageName)), you do not need to put the groups, the option will be displayed only if the page can be displayed",
// "Home Blog" => "Home Blog",
// "Take a quiz" => "Take a quiz",
// "Stats for a Quiz" => "Stats for a Quiz",
// "Preview menu" => "Preview menu",
// "switch with previous option" => "switch with previous option",
// "switch with next option" => "switch with next option",
// "Export CSV data" => "Export CSV data",
// "Import CSV data" => "Import CSV data",
// "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'" => "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'",
// "Create/Edit Menu" => "Create/Edit Menu",
// "Icons" => "Icons",
// "Folder Icon" => "Folder Icon",
// "Path and filename of closed folder icon" => "Path and filename of closed folder icon",
// "To use custom folder icons in menus, enter the path to the icon for the <strong>closed</strong> folder" => "To use custom folder icons in menus, enter the path to the icon for the <strong>closed</strong> folder",
// "In the same directory, include an icon for the opened folder" => "In the same directory, include an icon for the opened folder",
// "The \"opened folder\" icon name must be identical to the \"closed folder\" icon name, prefixed with the letter <strong>o</strong>" => "The \"opened folder\" icon name must be identical to the \"closed folder\" icon name, prefixed with the letter <strong>o</strong>",
// "Configure icons for menu entries" => "Configure icons for menu entries",
// "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=look\">Look and Feel</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu" => "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=look\">Look and Feel</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu",
// "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes" => "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes",
// "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>" => "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>",
// "To use a menu in a tiki format" => "To use a menu in a tiki format",
// "To use menu in a css/suckerfish format" => "To use menu in a css/suckerfish format",
// "To customize the menu's CSS id (#)" => "To customize the menu's CSS id (#)",
// "The following required parameters are missing" => "The following required parameters are missing",
// "Assign/Edit modules" => "Assign/Edit modules",
// "Assigned Modules" => "Assigned Modules",
// "assign_name\">Module Name" => "assign_name\">Module Name",
// "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme', 'notitle', 'nopage'). Separator between params:'&amp;'. E.g. maxlen=15&amp;nonums=y" => "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme', 'notitle', 'nopage'). Separator between params:'&amp;'. E.g. maxlen=15&amp;nonums=y",
// "The" => "The",
// "setting will override your selection of specific groups" => "setting will override your selection of specific groups",
// "Visibility" => "Visibility",
// "Displayed now for all eligible users even with personal assigned modules" => "Displayed now for all eligible users even with personal assigned modules",
// "Displayed for the eligible users with no personal assigned modules" => "Displayed for the eligible users with no personal assigned modules",
// "Displayed now, can't be unassigned" => "Displayed now, can't be unassigned",
// "Not displayed until a user chooses it" => "Not displayed until a user chooses it",
// "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either" => "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either",
// "to make sure users will notice any newly assigned modules" => "to make sure users will notice any newly assigned modules",
// "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site" => "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site",
// "Must be wiki parsed" => "Must be wiki parsed",
// "Objects that can be included" => "Objects that can be included",
// "Available polls" => "Available polls",
// "Random active poll" => "Random active poll",
// "Random current poll" => "Random current poll",
// "Use Poll" => "Use Poll",
// "Random image from" => "Random image from",
// "Dynamic content blocks" => "Dynamic content blocks",
// "Use Dynamic Content" => "Use Dynamic Content",
// "Use RSS Module" => "Use RSS Module",
// "phpLayersMenus" => "phpLayersMenus",
// "Use phplayermenu" => "Use phplayermenu",
// "Banner zones" => "Banner zones",
// "Use Banner Zone" => "Use Banner Zone",
// "Admin newsletter subscriptions" => "Admin newsletter subscriptions",
// "List Newsletters" => "List Newsletters",
// "Edit Newsletter" => "Edit Newsletter",
// "Admin Newsletters" => "Admin Newsletters",
// "Add a subscription newsletters" => "Add a subscription newsletters",
// "You can add several email addresses by separating them with commas" => "You can add several email addresses by separating them with commas",
// "Group users" => "Group users",
// "Group subscription also subscribes included groups" => "Group subscription also subscribes included groups",
// "Don't send confirmation mail" => "Don't send confirmation mail",
// "The user email will be refreshed at each newsletter sending" => "The user email will be refreshed at each newsletter sending",
// "Batch e-mail subscribe" => "Batch e-mail subscribe",
// "txt file, one e-mail per line" => "txt file, one e-mail per line",
// "Export Subscriber Emails" => "Export Subscriber Emails",
// "Subscribe group" => "Subscribe group",
// "Included group, group users and emails will be refreshed at each newsletter sending" => "Included group, group users and emails will be refreshed at each newsletter sending",
// "Add subscribers of another newsletter" => "Add subscribers of another newsletter",
// "Subscriptions" => "Subscriptions",
// "Valid" => "Valid",
// "Subscribed" => "Subscribed",
// "Create Newsletter" => "Create Newsletter",
// "Editions" => "Editions",
// "Drafts" => "Drafts",
// "Last Sent" => "Last Sent",
// "Create/Edit Newsletters" => "Create/Edit Newsletters",
// "There are individual permissions set for this newsletter" => "There are individual permissions set for this newsletter",
// "Users can subscribe/unsubscribe to this list" => "Users can subscribe/unsubscribe to this list",
// "Users can subscribe any email address" => "Users can subscribe any email address",
// "Add unsubscribe instructions to each newsletter" => "Add unsubscribe instructions to each newsletter",
// "Validate email addresses" => "Validate email addresses",
// "Allow customized text message to be sent with the html version" => "Allow customized text message to be sent with the html version",
// "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications" => "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications",
// "Add notification" => "Add notification",
// "Alert" => "Alert",
// "Event" => "Event",
// "Preload Admin Account" => "Preload Admin Account",
// "User / Group" => "User / Group",
// "Multiple" => "Multiple",
// "Trackers Outbound Emails" => "Trackers Outbound Emails",
// "Forums Outbound Emails" => "Forums Outbound Emails",
// "Admin page lists" => "Admin page lists",
// "Current lists" => "Current lists",
// "Edit this list" => "Edit this list",
// "edit" => "edit",
// "Remove this list" => "Remove this list",
// "remove" => "remove",
// "Edit list" => "Edit list",
// "Add list" => "Add list",
// "Seed with pages from a category" => "Seed with pages from a category",
// "Add page" => "Add page",
// "Page priority" => "Page priority",
// "Page score" => "Page score",
// "Edit {\$list.name|escape}" => "Edit {\$list.name|escape}",
// "Admin Polls" => "Admin Polls",
// "List polls" => "List polls",
// "Edit this poll" => "Edit this poll",
// "Preview poll" => "Preview poll",
// "Add poll option" => "Add poll option",
// "Edit poll option" => "Edit poll option",
// "Option" => "Option",
// "Poll options" => "Poll options",
// "Votes" => "Votes",
// "Set last poll as current" => "Set last poll as current",
// "Close all polls but last" => "Close all polls but last",
// "Activate all polls" => "Activate all polls",
// "Create poll" => "Create poll",
// "Edit poll" => "Edit poll",
// "active" => "active",
// "current" => "current",
// "object" => "object",
// "Toggle Quick Options" => "Toggle Quick Options",
// "Add Option" => "Add Option",
// "Leave box empty for deleting an option" => "Leave box empty for deleting an option",
// "PublishDate" => "PublishDate",
// "Votes older than these days are no more considered" => "Votes older than these days are no more considered",
// "Results" => "Results",
// "Add poll to pages" => "Add poll to pages",
// "This menu shows only Polls with 'status': \"template\"" => "This menu shows only Polls with 'status': \"template\"",
// "Admin External Feeds" => "Admin External Feeds",
// "Tips" => "Tips",
// "This page is to configure settings of external feeds read/imported by Tiki. To generate/export feeds, look for \"Feeds\" on the admin panel, or" => "This page is to configure settings of external feeds read/imported by Tiki. To generate/export feeds, look for \"Feeds\" on the admin panel, or",
// "To use feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the feed" => "To use feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the feed",
// "Content for the feed" => "Content for the feed",
// "Edit this feed" => "Edit this feed",
// "Create new external feed" => "Create new external feed",
// "show feed title" => "show feed title",
// "show publish date" => "show publish date",
// "Show Date" => "Show Date",
// "Security Admin" => "Security Admin",
// "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>" => "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>",
// "PHP settings" => "PHP settings",
// "PHP variable" => "PHP variable",
// "Risk Factor" => "Risk Factor",
// "Explanation" => "Explanation",
// "PHP functions" => "PHP functions",
// "Function" => "Function",
// "To disallow a function, add a disable_functions=exec,passthru for instance in your php.ini" => "To disallow a function, add a disable_functions=exec,passthru for instance in your php.ini",
// "TikiWiki settings" => "TikiWiki settings",
// "Tiki variable" => "Tiki variable",
// "About WikiPlugins and security: Make sure to only grant the \"tiki_p_plugin_approve\" permission to trusted editors" => "About WikiPlugins and security: Make sure to only grant the \"tiki_p_plugin_approve\" permission to trusted editors",
// "You can deactivate risky plugins at (<a href=\"tiki-admin.php?page=textarea\">tiki-admin.php?page=textarea</a>)" => "You can deactivate risky plugins at (<a href=\"tiki-admin.php?page=textarea\">tiki-admin.php?page=textarea</a>)",
// "Security checks" => "Security checks",
// "Check all tiki files" => "Check all tiki files",
// "Note, that this can take a very long time. You should check your max_execution_time setting in php.ini" => "Note, that this can take a very long time. You should check your max_execution_time setting in php.ini",
// "File checks" => "File checks",
// "Check file permissions" => "Check file permissions",
// "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments" => "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments",
// "See end of table for detailed explanations" => "See end of table for detailed explanations",
// "owner" => "owner",
// "special" => "special",
// "user" => "user",
// "group" => "group",
// "other" => "other",
// "uid" => "uid",
// "gid" => "gid",
// "suid" => "suid",
// "sgid" => "sgid",
// "sticky" => "sticky",
// "Set User ID (suid) files" => "Set User ID (suid) files",
// "World writable files or directories" => "World writable files or directories",
// "Files or directories the Webserver can write to" => "Files or directories the Webserver can write to",
// "Strange Inodes (not file, not link, not directory)" => "Strange Inodes (not file, not link, not directory)",
// "Executable files" => "Executable files",
// "What to do with these check results" => "What to do with these check results",
// "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"" => "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"",
// "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content" => "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content",
// "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information" => "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information",
// "Inodes that are not files or directories are not part of tiki. Review these Inodes" => "Inodes that are not files or directories are not part of tiki. Review these Inodes",
// "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod" => "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod",
// "Admin Shoutbox Words" => "Admin Shoutbox Words",
// "Add Banned Word" => "Add Banned Word",
// "XML Zip Import" => "XML Zip Import",
// "has just been created" => "has just been created",
// "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict" => "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict",
// "The following pages have automatically been categorized with the same categories as the structure" => "The following pages have automatically been categorized with the same categories as the structure",
// "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent" => "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent",
// "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent" => "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent",
// "View structure" => "View structure",
// "XML Zip" => "XML Zip",
// "Add a New Question" => "Add a New Question",
// "This survey stats" => "This survey stats",
// "Edit Survey Question" => "Edit Survey Question",
// "Add a New Question to this survey" => "Add a New Question to this survey",
// "Multiple choices of thumbnails from a file gallery" => "Multiple choices of thumbnails from a file gallery",
// "Wiki textarea" => "Wiki textarea",
// "Rate (1..5)" => "Rate (1..5)",
// "Rate (1..10)" => "Rate (1..10)",
// "Rate" => "Rate",
// "Answer is mandatory" => "Answer is mandatory",
// "Number of required answers (for multiple choices)" => "Number of required answers (for multiple choices)",
// "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots" => "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots",
// "For a rate, you can give the maximum value" => "For a rate, you can give the maximum value",
// "For the 'multiple choices of thumbnail from a file gallery' type, options are: Gallery ID. Example: 4" => "For the 'multiple choices of thumbnail from a file gallery' type, options are: Gallery ID. Example: 4",
// "Options (if apply)" => "Options (if apply)",
// "Questions" => "Questions",
// "Create/Edit Surveys" => "Create/Edit Surveys",
// "Create New Survey" => "Create New Survey",
// "There are individual permissions set for this survey" => "There are individual permissions set for this survey",
// "Open" => "Open",
// "Closed" => "Closed",
// "Tiki Cache/System Admin" => "Tiki Cache/System Admin",
// "If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)" => "If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)",
// "Exterminator of cached content" => "Exterminator of cached content",
// "Directory to exterminate" => "Directory to exterminate",
// "Clear all Tiki caches" => "Clear all Tiki caches",
// "All user prefs sessions" => "All user prefs sessions",
// "Directories to save" => "Directories to save",
// "Full Path to the Zip File" => "Full Path to the Zip File",
// "Generate a zip of those directories" => "Generate a zip of those directories",
// "A zip has been written to {\$zipPath}" => "A zip has been written to {\$zipPath}",
// "Directory is not writeable" => "Directory is not writeable",
// "Advanced feature" => "Advanced feature",
// "Fix UTF-8 Errors in Tables" => "Fix UTF-8 Errors in Tables",
// "Warning: Make a backup of your Database before using this function" => "Warning: Make a backup of your Database before using this function",
// "Warning: If you try to convert large tables, raise the maximum execution time in your php.ini" => "Warning: If you try to convert large tables, raise the maximum execution time in your php.ini",
// "This function converts ISO-8859-1 encoded strings in your tables to UTF-8" => "This function converts ISO-8859-1 encoded strings in your tables to UTF-8",
// "This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1" => "This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1",
// "UTF-8 Errors fixed" => "UTF-8 Errors fixed",
// "View mode" => "View mode",
// "Wiki and WYSIWYG" => "Wiki and WYSIWYG",
// "Wiki only" => "Wiki only",
// "WYSIWYG only" => "WYSIWYG only",
// "Load" => "Load",
// "Reset to Global" => "Reset to Global",
// "Reset to defaults" => "Reset to defaults",
// "Auto Reloading" => "Auto Reloading",
// "Row" => "Row",
// "Formatting Tools" => "Formatting Tools",
// "Plugin Tools" => "Plugin Tools",
// "Edit tool" => "Edit tool",
// "Wysiwyg Token" => "Wysiwyg Token",
// "Plugin name" => "Plugin name",
// "Custom Tools" => "Custom Tools",
// "Add a new custom tool" => "Add a new custom tool",
// "To configure the toolbars on the various text editing areas select the section, and optionally check the comments checkbox, you want to edit and drag the icons from the left hand box to the toolbars on the right.<br />\nDrag icons back from the toolbar rows onto the full list to remove them.<br />\nIcons with <strong>bold</strong> labels are for wiki text areas, those that are <em>italic</em> are for WYSIWYG mode, and those that are <strong><em>bold and italic</em></strong> are for both.<br />\nTo save the current set use the dropdown (and optionally check the comments checkbox) at the bottom of the page to set where you want these toolbars to appear, and click Save" => "To configure the toolbars on the various text editing areas select the section, and optionally check the comments checkbox, you want to edit and drag the icons from the left hand box to the toolbars on the right.<br />\nDrag icons back from the toolbar rows onto the full list to remove them.<br />\nIcons with <strong>bold</strong> labels are for wiki text areas, those that are <em>italic</em> are for WYSIWYG mode, and those that are <strong><em>bold and italic</em></strong> are for both.<br />\nTo save the current set use the dropdown (and optionally check the comments checkbox) at the bottom of the page to set where you want these toolbars to appear, and click Save",
// "Admin Tracker" => "Admin Tracker",
// "Admin Trackers" => "Admin Trackers",
// "Edit This Tracker" => "Edit This Tracker",
// "View This Tracker's Items" => "View This Tracker's Items",
// "Tracker fields" => "Tracker fields",
// "Mandatory" => "Mandatory",
// "Is column visible when listing tracker items" => "Is column visible when listing tracker items",
// "Tbl vis" => "Tbl vis",
// "Column links to edit/view item" => "Column links to edit/view item",
// "isMain" => "isMain",
// "Searchable" => "Searchable",
// "Field is public? (viewed in trackerlist plugin)" => "Field is public? (viewed in trackerlist plugin)",
// "Hidden" => "Hidden",
// "New tracker field" => "New tracker field",
// "Edit tracker field" => "Edit tracker field",
// "Select list items that will be displayed" => "Select list items that will be displayed",
// "Field is mandatory" => "Field is mandatory",
// "Multilingual content" => "Multilingual content",
// "Column is searchable" => "Column is searchable",
// "Field is hidden" => "Field is hidden",
// "not hidden" => "not hidden",
// "visible to admin only" => "visible to admin only",
// "editable by admin only" => "editable by admin only",
// "visible by creator &amp; admin only" => "visible by creator &amp; admin only",
// "The option creator needs a field of type user selector and option 1" => "The option creator needs a field of type user selector and option 1",
// "Visible by" => "Visible by",
// "Editable by" => "Editable by",
// "Description text is wiki-parsed" => "Description text is wiki-parsed",
// "Import/Export Trackers Fields" => "Import/Export Trackers Fields",
// "Export fieldId also" => "Export fieldId also",
// "Check the box to re-import in this tracker and change the fields" => "Check the box to re-import in this tracker and change the fields",
// "Uncheck the box to import in another database" => "Uncheck the box to import in another database",
// "Edit This Tracker's Fields" => "Edit This Tracker's Fields",
// "trackers" => "trackers",
// "with" => "with",
// "Edit Tracker" => "Edit Tracker",
// "Create Tracker" => "Create Tracker",
// "Create/Edit Tracker" => "Create/Edit Tracker",
// "There are individual permissions set for this tracker" => "There are individual permissions set for this tracker",
// "No individual permissions. Global permissions apply" => "No individual permissions. Global permissions apply",
// "Auto create corresponding categories" => "Auto create corresponding categories",
// "Create a group for each item" => "Create a group for each item",
// "Groups will include" => "Groups will include",
// "Creator is assigned to the group" => "Creator is assigned to the group",
// "and it becomes his default group" => "and it becomes his default group",
// "and it becomes the new item group creator" => "and it becomes the new item group creator",
// "But copy the default group in this fiedlId before updating the group" => "But copy the default group in this fiedlId before updating the group",
// "Use \"explicit\" names in the mirror table" => "Use \"explicit\" names in the mirror table",
// "tracker name must be unique, field names must be unique for a tracker and they must be valid in SQL" => "tracker name must be unique, field names must be unique for a tracker and they must be valid in SQL",
// "Show status" => "Show status",
// "Default status displayed in list mode" => "Default status displayed in list mode",
// "Show status to tracker admin only" => "Show status to tracker admin only",
// "Send copies of all activity in this tracker to this e-mail address" => "Send copies of all activity in this tracker to this e-mail address",
// "Use simplified e-mail format" => "Use simplified e-mail format",
// "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender" => "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender",
// "New items are created with status" => "New items are created with status",
// "Authoritative status for modified items" => "Authoritative status for modified items",
// "No change" => "No change",
// "Item creator can modify his items" => "Item creator can modify his items",
// "The tracker needs a user field with the option 1" => "The tracker needs a user field with the option 1",
// "User can take ownership of item created by anonymous" => "User can take ownership of item created by anonymous",
// "Only one item per user or IP" => "Only one item per user or IP",
// "The tracker needs a user or IP field with the option 1" => "The tracker needs a user or IP field with the option 1",
// "Member of the creator group can modify items" => "Member of the creator group can modify items",
// "The tracker needs a group field with the option 1" => "The tracker needs a group field with the option 1",
// "Show creation date when listing tracker items" => "Show creation date when listing tracker items",
// "Format if not the default short one" => "Format if not the default short one",
// "Show creation date when viewing tracker item" => "Show creation date when viewing tracker item",
// "Identify creation user in tracker item" => "Identify creation user in tracker item",
// "Show lastModif date when listing tracker items" => "Show lastModif date when listing tracker items",
// "Show lastModif date when viewing tracker item" => "Show lastModif date when viewing tracker item",
// "Identify lastModif user in tracker item" => "Identify lastModif user in tracker item",
// "What field is used for default sort" => "What field is used for default sort",
// "LastModif" => "LastModif",
// "ItemId" => "ItemId",
// "What is default sort order in list" => "What is default sort order in list",
// "Tracker items allow ratings" => "Tracker items allow ratings",
// "with values" => "with values",
// "and display rating results in listing" => "and display rating results in listing",
// "Tracker items allow comments" => "Tracker items allow comments",
// "and display comments in listing" => "and display comments in listing",
// "and display last comment user/date" => "and display last comment user/date",
// "Tracker items allow attachments" => "Tracker items allow attachments",
// "and display attachments in listing" => "and display attachments in listing",
// "Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)" => "Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)",
// "LongDesc" => "LongDesc",
// "Items can be created only during a certain time" => "Items can be created only during a certain time",
// "Do not show empty fields in item view" => "Do not show empty fields in item view",
// "Show these fields (ID comma separated) in a popup on item link when listing tracker items" => "Show these fields (ID comma separated) in a popup on item link when listing tracker items",
// "Group of users alerted when tracker is modified" => "Group of users alerted when tracker is modified",
// "Import/Export" => "Import/Export",
// "Import/export trackers" => "Import/export trackers",
// "Date Format" => "Date Format",
// "timestamp" => "timestamp",
// "Charset encoding" => "Charset encoding",
// "UTF-8" => "UTF-8",
// "ISO-8859-1" => "ISO-8859-1",
// "Duplicate Tracker" => "Duplicate Tracker",
// "Admin groups" => "Admin groups",
// "Admin users" => "Admin users",
// "Add new group" => "Add new group",
// "Manage permissions" => "Manage permissions",
// "List of existing groups" => "List of existing groups",
// "Inherits Permissions from" => "Inherits Permissions from",
// "User Choice" => "User Choice",
// "Add a New Group" => "Add a New Group",
// "Inherit permissions directly from following groups" => "Inherit permissions directly from following groups",
// "Selected groups only. Use Ctrl+Click to select more than one" => "Selected groups only. Use Ctrl+Click to select more than one",
// "Also inheriting permissions from the following groups (indirect inheritance through the groups selected above)" => "Also inheriting permissions from the following groups (indirect inheritance through the groups selected above)",
// "Group Homepage" => "Group Homepage",
// "Use wiki page name or full URL" => "Use wiki page name or full URL",
// "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)" => "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)",
// "Default category assigned to uncategorized objects edited by a user with this default group" => "Default category assigned to uncategorized objects edited by a user with this default group",
// "Group Theme" => "Group Theme",
// "Use site default" => "Use site default",
// "Group Information Tracker" => "Group Information Tracker",
// "choose a group tracker .." => "choose a group tracker ..",
// "choose a field .." => "choose a field ..",
// "Users Information Tracker" => "Users Information Tracker",
// "choose a users tracker .." => "choose a users tracker ..",
// "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)" => "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)",
// "User can assign to the group himself" => "User can assign to the group himself",
// "Users are automatically unassigned from the group after" => "Users are automatically unassigned from the group after",
// "0 or empty for never" => "0 or empty for never",
// "Assign group <em>management</em> permissions" => "Assign group <em>management</em> permissions",
// "Group tracker item : {\$groupitemid}" => "Group tracker item : {\$groupitemid}",
// "Edit Item" => "Edit Item",
// "Group tracker item not found" => "Group tracker item not found",
// "Create Item" => "Create Item",
// "Choose a field .." => "Choose a field ..",
// "Members" => "Members",
// "Add to group" => "Add to group",
// "Each user in the file must already exist" => "Each user in the file must already exist",
// "To create users or/and assign them to groups, got to <a href=\"tiki-adminusers.php\">admin->users</a>" => "To create users or/and assign them to groups, got to <a href=\"tiki-adminusers.php\">admin->users</a>",
// "Since this tiki site is in slave mode and import groups, the master groups will be automatically reimported at each login" => "Since this tiki site is in slave mode and import groups, the master groups will be automatically reimported at each login",
// "Since this tiki site is in slave mode and import preferences, the master user preferences will be automatically reimported at each login" => "Since this tiki site is in slave mode and import preferences, the master user preferences will be automatically reimported at each login",
// "Feedback" => "Feedback",
// "ago" => "ago",
// "Assign to group" => "Assign to group",
// "to groups" => "to groups",
// "Edit Included Group" => "Edit Included Group",
// "Edit Group" => "Edit Group",
// "Validate user" => "Validate user",
// "Confirm user email" => "Confirm user email",
// "Remove Users and their Userpages" => "Remove Users and their Userpages",
// "Manage Group Assignments" => "Manage Group Assignments",
// "Set Default Groups" => "Set Default Groups",
// "Send a wiki page by Email" => "Send a wiki page by Email",
// "the following groups" => "the following groups",
// "Tip: Hold down CTRL to select multiple" => "Tip: Hold down CTRL to select multiple",
// "Set the default group of the selected users to" => "Set the default group of the selected users to",
// "Template wiki page" => "Template wiki page",
// "bcc" => "bcc",
// "Assign user to Groups" => "Assign user to Groups",
// "Lowercase only" => "Lowercase only",
// "Warning: changing the username could require the user to change his password (for user registered with an old tikiwiki&lt;=1.8)" => "Warning: changing the username could require the user to change his password (for user registered with an old tikiwiki&lt;=1.8)",
// "Warning: it will mess with slave intertiki sites that use this one as master" => "Warning: it will mess with slave intertiki sites that use this one as master",
// "Tikiwiki is configured to delegate the password managment to LDAP" => "Tikiwiki is configured to delegate the password managment to LDAP",
// "Repeat Password" => "Repeat Password",
// "User must change password at first login" => "User must change password at first login",
// "Send an email to the user in order to allow him to validate his account" => "Send an email to the user in order to allow him to validate his account",
// "Last Login" => "Last Login",
// "User tracker item : {\$usersitemid}" => "User tracker item : {\$usersitemid}",
// "You do not have permission to edit this user" => "You do not have permission to edit this user",
// "CSV file layout" => "CSV file layout",
// "login,password,email<br />user1,pass1,email1<br />user2,pass2,email2" => "login,password,email<br />user1,pass1,email1<br />user2,pass2,email2",
// "Overwrite but keep the previous login if the login exists in another case" => "Overwrite but keep the previous login if the login exists in another case",
// "You can export users of a group in <a href=\"tiki-admingroups.php\">admin->groups->a_group</a>" => "You can export users of a group in <a href=\"tiki-admingroups.php\">admin->groups->a_group</a>",
// "More languages are available. To view them, update languages you can read from <a href=\"tiki-user_preferences.php\">user preferences</a> or your browser's preferences" => "More languages are available. To view them, update languages you can read from <a href=\"tiki-user_preferences.php\">user preferences</a> or your browser's preferences",
// "Changes from the following versions under staging have been merged into the approved version" => "Changes from the following versions under staging have been merged into the approved version",
// "Admin Article Types" => "Admin Article Types",
// "List of types" => "List of types",
// "Show Help" => "Show Help",
// "Article type" => "Article type",
// "Shows up in the drop down list of article types" => "Shows up in the drop down list of article types",
// "Allow ratings by the author" => "Allow ratings by the author",
// "Show before publish date" => "Show before publish date",
// "non-admins can view before the publish date" => "non-admins can view before the publish date",
// "Show after expire date" => "Show after expire date",
// "non-admins can view after the expire date" => "non-admins can view after the expire date",
// "Heading only" => "Heading only",
// "No article body, heading only" => "No article body, heading only",
// "Allow comments for this type" => "Allow comments for this type",
// "Comment Can Rate Article" => "Comment Can Rate Article",
// "Allow comments to include a rating value" => "Allow comments to include a rating value",
// "Show image" => "Show image",
// "Show topic or own image" => "Show topic or own image",
// "Show avatar" => "Show avatar",
// "Show author's avatar" => "Show author's avatar",
// "Show author" => "Show author",
// "Show author name" => "Show author name",
// "Show publish date" => "Show publish date",
// "Show expire date" => "Show expire date",
// "Show reads" => "Show reads",
// "Show the number of times the article was read" => "Show the number of times the article was read",
// "Show size" => "Show size",
// "Show the size of the article" => "Show the size of the article",
// "Show topline" => "Show topline",
// "Show a small title over the title" => "Show a small title over the title",
// "Show subtitle" => "Show subtitle",
// "Show the subtitle" => "Show the subtitle",
// "Show source" => "Show source",
// "Show link to source after article body" => "Show link to source after article body",
// "Show Image Caption" => "Show Image Caption",
// "Show a legend under the image" => "Show a legend under the image",
// "Show Language" => "Show Language",
// "Show the language" => "Show the language",
// "Creator can edit" => "Creator can edit",
// "The person who submits an article of this type can edit it" => "The person who submits an article of this type can edit it",
// "Actions on this article type" => "Actions on this article type",
// "Show lang" => "Show lang",
// "Review" => "Review",
// "Classified" => "Classified",
// "Create a new type" => "Create a new type",
// "This page will be replaced with the Object Permissions page although currently it does not support the \"advanced\" mode of this page.<br />Please try it out and feedback with any improvements or problems" => "This page will be replaced with the Object Permissions page although currently it does not support the \"advanced\" mode of this page.<br />Please try it out and feedback with any improvements or problems",
// "Click this button to try it now" => "Click this button to try it now",
// "Global object permissions" => "Global object permissions",
// "level" => "level",
// "inherited from" => "inherited from",
// "inherited" => "inherited",
// "Level configuration" => "Level configuration",
// "all permissions in level" => "all permissions in level",
// "Assign User {\$assign_user|escape} to Groups" => "Assign User {\$assign_user|escape} to Groups",
// "Directory batch upload" => "Directory batch upload",
// "Upload From Disk" => "Upload From Disk",
// "Remove File Extension from Image Name" => "Remove File Extension from Image Name",
// "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field" => "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field",
// "Convert the last sub directory to a sub gallery" => "Convert the last sub directory to a sub gallery",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created",
// "Use the last sub directory name as description" => "Use the last sub directory name as description",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created",
// "Process" => "Process",
// "Browse File Gallery" => "Browse File Gallery",
// "Please do not use this feature to upload data into the database" => "Please do not use this feature to upload data into the database",
// "Available Files" => "Available Files",
// "Process files" => "Process files",
// "The TikiWiki Community" => "The TikiWiki Community",
// "database queries used in " => "database queries used in ",
// "Sheets" => "Sheets",
// "\$feature_label" => "\$feature_label",
// "Directory Batch" => "Directory Batch",
// "You can view this gallery's configured image (first, random, etc.) in your browser using" => "You can view this gallery's configured image (first, random, etc.) in your browser using",
// "You can include the gallery's image in an HTML page using one of these lines" => "You can include the gallery's image in an HTML page using one of these lines",
// "Latitude (WGS84/decimal degrees)" => "Latitude (WGS84/decimal degrees)",
// "Longitude (WGS84/decimal degrees)" => "Longitude (WGS84/decimal degrees)",
// "Include the image in a tiki page using the following syntax" => "Include the image in a tiki page using the following syntax",
// "To include the image in an HTML page" => "To include the image in an HTML page",
// "To link to this page from another tiki page" => "To link to this page from another tiki page",
// "Browsing Video" => "Browsing Video",
// "Edit Video" => "Edit Video",
// "First Video" => "First Video",
// "Prev Video" => "Prev Video",
// "Next Video" => "Next Video",
// "Last Video" => "Last Video",
// "Video Title" => "Video Title",
// "Move video" => "Move video",
// "You can view this video in your browser using" => "You can view this video in your browser using",
// "You can include the video in a tiki page using one of these lines" => "You can include the video in a tiki page using one of these lines",
// "Admin Calendar" => "Admin Calendar",
// "Export Calendars" => "Export Calendars",
// "Click to export calendars" => "Click to export calendars",
// "Export calendars" => "Export calendars",
// "advanced parameters" => "advanced parameters",
// "Delete event" => "Delete event",
// "All-Day" => "All-Day",
// "Website" => "Website",
// "View this Week" => "View this Week",
// "View this Day" => "View this Day",
// "o" => "o",
// "Recurrence" => "Recurrence",
// "This event depends on a recurrence rule" => "This event depends on a recurrence rule",
// "This event is not recurrent" => "This event is not recurrent",
// "On a weekly basis" => "On a weekly basis",
// "Each" => "Each",
// "of the week" => "of the week",
// "On a monthly basis" => "On a monthly basis",
// "of the month" => "of the month",
// "On a yearly basis" => "On a yearly basis",
// "There's no such date as" => "There's no such date as",
// "Starting on" => "Starting on",
// "ending by" => "ending by",
// "ending after" => "ending after",
// "events" => "events",
// "Start period" => "Start period",
// "End after" => "End after",
// "occurrences" => "occurrences",
// "End before" => "End before",
// "Event is repeated" => "Event is repeated",
// "times" => "times",
// "every" => "every",
// "of every month" => "of every month",
// "on each" => "on each",
// "Events cannot end before they start" => "Events cannot end before they start",
// "No description" => "No description",
// "Choose users to alert" => "Choose users to alert",
// "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in" => "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in",
// "role:login_or_email,login_or_email" => "role:login_or_email,login_or_email",
// "If no role is provided, default role will be \"Chair participant\"" => "If no role is provided, default role will be \"Chair participant\"",
// "Update this event only" => "Update this event only",
// "Update every unchanged events of this recurrence rule" => "Update every unchanged events of this recurrence rule",
// "Update every events of this recurrence rule" => "Update every events of this recurrence rule",
// "Delete Recurrent events" => "Delete Recurrent events",
// "import" => "import",
// "D" => "D",
// "W" => "W",
// "M" => "M",
// "%d/%m" => "%d/%m",
// "%m/%d" => "%m/%d",
// "Advanced parameters for iCal export" => "Advanced parameters for iCal export",
// "Calendars to be exported" => "Calendars to be exported",
// "Your account has been validated" => "Your account has been validated",
// "You have to choose a password to use this account" => "You have to choose a password to use this account",
// "Change password enforced" => "Change password enforced",
// "Change your password" => "Change your password",
// "Old password" => "Old password",
// "Send a message to us" => "Send a message to us",
// "Contact us by email" => "Contact us by email",
// "Send another message" => "Send another message",
// "Group View" => "Group View",
// "You can browse the generated WebHelp here" => "You can browse the generated WebHelp here",
// "Add a new site" => "Add a new site",
// "You cannot add sites until Directory Categories are setup" => "You cannot add sites until Directory Categories are setup",
// "Please contact the Site Administrator" => "Please contact the Site Administrator",
// "<a href=\"tiki-directory_admin_categories.php\">Add a directory category now</a>" => "<a href=\"tiki-directory_admin_categories.php\">Add a directory category now</a>",
// "Site added" => "Site added",
// "The following site was added, but may require validation by the admin before appearing on the lists" => "The following site was added, but may require validation by the admin before appearing on the lists",
// "Directory Categories" => "Directory Categories",
// "Use Ctrl+Click to select multiple directory categories" => "Use Ctrl+Click to select multiple directory categories",
// "Directory Administration" => "Directory Administration",
// "There are" => "There are",
// "invalid sites" => "invalid sites",
// "valid sites" => "valid sites",
// "Users have visited" => "Users have visited",
// "sites from the directory" => "sites from the directory",
// "Users have searched" => "Users have searched",
// "times from the directory" => "times from the directory",
// "Related" => "Related",
// "Admin directory categories" => "Admin directory categories",
// "Parent directory category" => "Parent directory category",
// "Add a directory category" => "Add a directory category",
// "Edit this directory category" => "Edit this directory category",
// "Children type" => "Children type",
// "Most visited directory sub-categories" => "Most visited directory sub-categories",
// "Directory Category description" => "Directory Category description",
// "Random directory sub-categories" => "Random directory sub-categories",
// "Maximum number of children to show" => "Maximum number of children to show",
// "Allow sites in this directory category" => "Allow sites in this directory category",
// "Show number of sites in this directory category" => "Show number of sites in this directory category",
// "Editor group" => "Editor group",
// "Directory Subcategories" => "Directory Subcategories",
// "cType" => "cType",
// "allow" => "allow",
// "count" => "count",
// "editor" => "editor",
// "relate" => "relate",
// "Admin related directory categories" => "Admin related directory categories",
// "Add a related directory category" => "Add a related directory category",
// "Directory Category" => "Directory Category",
// "Mutual" => "Mutual",
// "Related directory categories" => "Related directory categories",
// "Admin sites" => "Admin sites",
// "Is valid" => "Is valid",
// "Perform action with selected" => "Perform action with selected",
// "New Sites" => "New Sites",
// "Cool Sites" => "Cool Sites",
// "Add a Site" => "Add a Site",
// "Add a Directory Category" => "Add a Directory Category",
// "any" => "any",
// "in entire directory" => "in entire directory",
// "in current directory category" => "in current directory category",
// "Sort by" => "Sort by",
// "name (desc)" => "name (desc)",
// "name (asc)" => "name (asc)",
// "creation date (desc)" => "creation date (desc)",
// "creation date (asc)" => "creation date (asc)",
// "last updated (desc)" => "last updated (desc)",
// "last updated (asc)" => "last updated (asc)",
// "Last updated" => "Last updated",
// "Total directory categories" => "Total directory categories",
// "Total links" => "Total links",
// "Links to validate" => "Links to validate",
// "Searches performed" => "Searches performed",
// "Total links visited" => "Total links visited",
// "Directory ranking" => "Directory ranking",
// "Validate sites" => "Validate sites",
// "Topline" => "Topline",
// "Edit or create banners" => "Edit or create banners",
// "List banners" => "List banners",
// "URL to link the banner" => "URL to link the banner",
// "Client" => "Client",
// "Max impressions" => "Max impressions",
// "-1 for unlimited" => "-1 for unlimited",
// "Max impressions for a user" => "Max impressions for a user",
// "Max clicks" => "Max clicks",
// "Or, create a new zone" => "Or, create a new zone",
// "Show the banner only between these dates" => "Show the banner only between these dates",
// "Select ONE method for the banner" => "Select ONE method for the banner",
// "Use image generated by URL (the image will be requested at the URL for each impression)" => "Use image generated by URL (the image will be requested at the URL for each impression)",
// "Use Flash" => "Use Flash",
// "Movie Size" => "Movie Size",
// "FlashPlugin min version" => "FlashPlugin min version",
// "ex" => "ex",
// "Use text" => "Use text",
// "Save the Banner" => "Save the Banner",
// "Remove Zones (you lose entered info for the banner)" => "Remove Zones (you lose entered info for the banner)",
// "A category is mandatory" => "A category is mandatory",
// "Current heading" => "Current heading",
// "There are individual permissions set for this blog" => "There are individual permissions set for this blog",
// "Number of posts to show" => "Number of posts to show",
// "Allow other user to post in this blog" => "Allow other user to post in this blog",
// "Allow search" => "Allow search",
// "Allow comments" => "Allow comments",
// "Show user avatar" => "Show user avatar",
// "Blog heading" => "Blog heading",
// "Edit Style Sheet" => "Edit Style Sheet",
// "Style Sheet" => "Style Sheet",
// "The file will be saved in" => "The file will be saved in",
// "choose a stylesheet" => "choose a stylesheet",
// "Try" => "Try",
// "Wiki Syntax" => "Wiki Syntax",
// "For more information, please see" => "For more information, please see",
// "Wiki Page Editor" => "Wiki Page Editor",
// "More help on editing wiki pages" => "More help on editing wiki pages",
// "The syntax system used for creating pages in TikiWiki" => "The syntax system used for creating pages in TikiWiki",
// "Also available here" => "Also available here",
// "Plugins help" => "Plugins help",
// "Bold text" => "Bold text",
// "Italic text" => "Italic text",
// "single quotes" => "single quotes",
// "Underlined text" => "Underlined text",
// "Colored text" => "Colored text",
// "Will display using the indicated HTML color or color name. Color name can contain two colors separated by a comma. In this case, the first color would be the foreground and the second one the background" => "Will display using the indicated HTML color or color name. Color name can contain two colors separated by a comma. In this case, the first color would be the foreground and the second one the background",
// "Deleted text" => "Deleted text",
// "2 dashes" => "2 dashes",
// "Headings" => "Headings",
// "Show/Hide" => "Show/Hide",
// "show/hide heading section. + (shown) or - (hidden) by default" => "show/hide heading section. + (shown) or - (hidden) by default",
// "Autonumbered Headings" => "Autonumbered Headings",
// "{literal}{toc}{/literal}, {literal}{maketoc}{/literal} prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "{literal}{toc}{/literal}, {literal}{maketoc}{/literal} prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)",
// "Horizontal rule" => "Horizontal rule",
// "Text box" => "Text box",
// "Box content" => "Box content",
// "Centered text" => "Centered text",
// "Dynamic variables" => "Dynamic variables",
// "Inserts an editable variable" => "Inserts an editable variable",
// "External links" => "External links",
// "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)" => "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)",
// "For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))" => "For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))",
// "Square Brackets" => "Square Brackets",
// "Use [[foo] to show [foo]" => "Use [[foo] to show [foo]",
// "Wiki References" => "Wiki References",
// "JoinCapitalizedWords or use" => "JoinCapitalizedWords or use",
// "page|description" => "page|description",
// "for wiki references" => "for wiki references",
// "page|#anchor" => "page|#anchor",
// "page|#anchor|desc" => "page|#anchor|desc",
// "for wiki heading/anchor references" => "for wiki heading/anchor references",
// "SomeName" => "SomeName",
// "prevents referencing" => "prevents referencing",
// "Lists" => "Lists",
// "for bullet lists" => "for bullet lists",
// "for numbered lists" => "for numbered lists",
// "for definiton lists" => "for definiton lists",
// "Indentation" => "Indentation",
// "Creates an indentation for each plus (useful in list to continue at the same level)" => "Creates an indentation for each plus (useful in list to continue at the same level)",
// "Tables" => "Tables",
// "row" => "row",
// "col" => "col",
// "Monospace font" => "Monospace font",
// "Code sample" => "Code sample",
// "Line break" => "Line break",
// "(very useful especially in tables)" => "(very useful especially in tables)",
// "Multi-page pages" => "Multi-page pages",
// "to separate pages" => "to separate pages",
// "Non parsed sections" => "Non parsed sections",
// "Prevents wiki parsing of the enclosed data" => "Prevents wiki parsing of the enclosed data",
// "Preformated sections" => "Preformated sections",
// "~pp~ data ~/pp~ Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  ~pre~ data ~/pre~ also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text" => "~pp~ data ~/pp~ Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  ~pre~ data ~/pre~ also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text",
// "~tc~ Tiki Comment ~/tc~ makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  ~hc~ HTML Comment ~/hc~ makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar" => "~tc~ Tiki Comment ~/tc~ makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  ~hc~ HTML Comment ~/hc~ makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar",
// "Block Preformatting" => "Block Preformatting",
// "Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that" => "Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that",
// "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew" => "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew",
// "Special characters" => "Special characters",
// "hard space" => "hard space",
// "numeric between ~ for html numeric characters entity" => "numeric between ~ for html numeric characters entity",
// "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines" => "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines",
// "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line" => "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line",
// "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt" => "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt",
// "More help here" => "More help here",
// "Wiki plugins extend the function of wiki syntax with more specialized commands" => "Wiki plugins extend the function of wiki syntax with more specialized commands",
// "The following image was successfully edited" => "The following image was successfully edited",
// "Edit or ex/import Languages" => "Edit or ex/import Languages",
// "Edit and create Languages" => "Edit and create Languages",
// "Im-Export Languages" => "Im-Export Languages",
// "Toggle interactive translation off" => "Toggle interactive translation off",
// "Toggle interactive translation on" => "Toggle interactive translation on",
// "Edit and create languages" => "Edit and create languages",
// "Create Language" => "Create Language",
// "Select the language to edit" => "Select the language to edit",
// "Edit translations" => "Edit translations",
// "Translate recorded" => "Translate recorded",
// "reset table" => "reset table",
// "Program dynamic content for block" => "Program dynamic content for block",
// "Create New Block" => "Create New Block",
// "Block description: " => "Block description: ",
// "You are editing block" => "You are editing block",
// "Publishing date" => "Publishing date",
// "Publishing Date" => "Publishing Date",
// "Edit question options" => "Edit question options",
// "Quiz Stats" => "Quiz Stats",
// "This Quiz Stats" => "This Quiz Stats",
// "Edit this Quiz" => "Edit this Quiz",
// "Admin Quizzes" => "Admin Quizzes",
// "Create/edit options for question" => "Create/edit options for question",
// "points" => "points",
// "Quiz" => "Quiz",
// "canRepeat" => "canRepeat",
// "timeLimit" => "timeLimit",
// "Create/edit quizzes" => "Create/edit quizzes",
// "There are individual permissions set for this quiz" => "There are individual permissions set for this quiz",
// "Quiz can be repeated" => "Quiz can be repeated",
// "Store quiz results" => "Store quiz results",
// "Immediate feedback" => "Immediate feedback",
// "Show correct answers" => "Show correct answers",
// "Shuffle questions" => "Shuffle questions",
// "Shuffle answers" => "Shuffle answers",
// "Quiz is time limited" => "Quiz is time limited",
// "Passing Percentage" => "Passing Percentage",
// "Edit quiz questions" => "Edit quiz questions",
// "Create/edit questions for quiz" => "Create/edit questions for quiz",
// "Question Type" => "Question Type",
// "Import questions from text" => "Import questions from text",
// "Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character" => "Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character",
// "Input" => "Input",
// "maxScore" => "maxScore",
// "Edit quiz results" => "Edit quiz results",
// "From Points" => "From Points",
// "To Points" => "To Points",
// "Remove existing categories from ALL pages before recategorizing" => "Remove existing categories from ALL pages before recategorizing",
// "List Submissions" => "List Submissions",
// "<b>Topline</b>=small line above Title" => "<b>Topline</b>=small line above Title",
// "<b>Subtitle</b>=small line below Title" => "<b>Subtitle</b>=small line below Title",
// "<b>Source</b>=URL to article source" => "<b>Source</b>=URL to article source",
// "Submit Article" => "Submit Article",
// "Auto-Approve Article" => "Auto-Approve Article",
// "Template listing" => "Template listing",
// "Available templates" => "Available templates",
// "If you go to edit this (or any other TPL file) file via the Tiki built-in TPL editor below, all the javascript can be sanitized or completely stripped out by Tiki security filtering" => "If you go to edit this (or any other TPL file) file via the Tiki built-in TPL editor below, all the javascript can be sanitized or completely stripped out by Tiki security filtering",
// "This would cause you problems (e.g. menus can stop collapsing/expanding)" => "This would cause you problems (e.g. menus can stop collapsing/expanding)",
// "You should only modify default header.tpl and other important files via text code editor, through console, or SSH, or FTP edit commands. And only if you know what you are doing ! ;-)" => "You should only modify default header.tpl and other important files via text code editor, through console, or SSH, or FTP edit commands. And only if you know what you are doing ! ;-)",
// "Maybe You just want to modify the top of your Tiki site" => "Maybe You just want to modify the top of your Tiki site",
// "Please consider using the Look & Feel preferences custom code areas or modify tiki-top_bar.tpl which you can do safely via the web-based interface" => "Please consider using the Look & Feel preferences custom code areas or modify tiki-top_bar.tpl which you can do safely via the web-based interface",
// "Save Only in the Theme" => "Save Only in the Theme",
// "Delete the copy in the theme" => "Delete the copy in the theme",
// "Edit a topic" => "Edit a topic",
// "Add Notification Email" => "Add Notification Email",
// "Admin notifications" => "Admin notifications",
// "View Page" => "View Page",
// "View Article" => "View Article",
// "You must specify the object language" => "You must specify the object language",
// "The object doesn't exist" => "The object doesn't exist",
// "The object doesn't have a language" => "The object doesn't have a language",
// "The object has already a translation for this language" => "The object has already a translation for this language",
// "The object is already in the set of translations" => "The object is already in the set of translations",
// "Language of newly translated page" => "Language of newly translated page",
// "Unspecified" => "Unspecified",
// "Name of newly translated page" => "Name of newly translated page",
// "Create translation" => "Create translation",
// "\"You forgot to specify the language of the translation. Please choose a language in the picklist.\"" => "\"You forgot to specify the language of the translation. Please choose a language in the picklist.\"",
// "\"The page already exists. It was selected in the list below.\"" => "\"The page already exists. It was selected in the list below.\"",
// "Or" => "Or",
// "Add existing page as a translation of this page" => "Add existing page as a translation of this page",
// "Manage existing translations of this page" => "Manage existing translations of this page",
// "detach" => "detach",
// "Change language for this page" => "Change language for this page",
// "Select from available options.." => "Select from available options..",
// "Change Language" => "Change Language",
// "No language is assigned to this page" => "No language is assigned to this page",
// "Please select a language before performing translation" => "Please select a language before performing translation",
// "Set Current Page's Language" => "Set Current Page's Language",
// "Edit Video Information" => "Edit Video Information",
// "Browse Videos" => "Browse Videos",
// "The following video was successfully edited" => "The following video was successfully edited",
// "You can include the video in an HTML page using one of these lines" => "You can include the video in an HTML page using one of these lines",
// "This edit session will expire in" => "This edit session will expire in",
// "Update '{\$page|escape}'" => "Update '{\$page|escape}'",
// "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval" => "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval",
// "This is a new staging page that has not been approved before" => "This is a new staging page that has not been approved before",
// "The current staging copy may contain changes that have yet to be approved" => "The current staging copy may contain changes that have yet to be approved",
// "View changes since last approval" => "View changes since last approval",
// "You are editing the approved copy of this page" => "You are editing the approved copy of this page",
// "There are currently changes in the staging copy that have yet to be approved" => "There are currently changes in the staging copy that have yet to be approved",
// "Are you sure you do not want to edit" => "Are you sure you do not want to edit",
// "the staging copy" => "the staging copy",
// "instead" => "instead",
// "Draft written on" => "Draft written on",
// "Warning: new versions of this page have been made after this draft" => "Warning: new versions of this page have been made after this draft",
// "Edit wiki page" => "Edit wiki page",
// "Change the style used to display differences to be translated" => "Change the style used to display differences to be translated",
// "Change diff styles" => "Change diff styles",
// "Edit page" => "Edit page",
// "Edit Comment" => "Edit Comment",
// "Edit comment: Enter some text to describe the changes you are currently making" => "Edit comment: Enter some text to describe the changes you are currently making",
// "Monitor this page" => "Monitor this page",
// "Add another image" => "Add another image",
// "Categories will be inherited from the structure top page" => "Categories will be inherited from the structure top page",
// "Tools" => "Tools",
// "Allow comments on this page" => "Allow comments on this page",
// "Regex search " => "Regex search ",
// "Replace with" => "Replace with",
// "Case Insensitivity" => "Case Insensitivity",
// "Try to convert HTML to wiki" => "Try to convert HTML to wiki",
// "Upload Screencast" => "Upload Screencast",
// "Incorrect file extension was used for your flash screencast, expecting .swf or .flv" => "Incorrect file extension was used for your flash screencast, expecting .swf or .flv",
// "An unexpected error occurred while uploading your flash screencast" => "An unexpected error occurred while uploading your flash screencast",
// "Incorrect file extension was used for your Ogg screencast, expecting .ogg" => "Incorrect file extension was used for your Ogg screencast, expecting .ogg",
// "A flash screencast is mandatory" => "A flash screencast is mandatory",
// "An unexpected error occurred while uploading your Ogg screencast" => "An unexpected error occurred while uploading your Ogg screencast",
// "Preview not possible" => "Preview not possible",
// "Flash video (required)" => "Flash video (required)",
// "Ogg video (optional)" => "Ogg video (optional)",
// "Add another screencast" => "Add another screencast",
// "Authors' style" => "Authors' style",
// "Description (used for metatags)" => "Description (used for metatags)",
// "Use rating" => "Use rating",
// "There is no available poll template" => "There is no available poll template",
// "You should ask an admin to create them" => "You should ask an admin to create them",
// "or use" => "or use",
// "an existing poll" => "an existing poll",
// "votes" => "votes",
// "Translation request" => "Translation request",
// "Send urgent translation request" => "Send urgent translation request",
// "List Sheets" => "List Sheets",
// "Graph" => "Graph",
// "Export to file" => "Export to file",
// "Format" => "Format",
// "Autodetect" => "Autodetect",
// "Export Tracker Items" => "Export Tracker Items",
// "Delimitors" => "Delimitors",
// "Carriage Return inside Field Value" => "Carriage Return inside Field Value",
// "Parse as Wiki Text" => "Parse as Wiki Text",
// "status" => "status",
// "lastModif" => "lastModif",
// "Fields visible in items list" => "Fields visible in items list",
// "Fields searchable or visible in items list" => "Fields searchable or visible in items list",
// "Fields visible in an item view" => "Fields visible in an item view",
// "These fields" => "These fields",
// "Use Ctrl+Click to select multiple fields" => "Use Ctrl+Click to select multiple fields",
// "Admin FAQ" => "Admin FAQ",
// "View FAQ" => "View FAQ",
// "Edit this FAQ" => "Edit this FAQ",
// "New Question" => "New Question",
// "Edit FAQ question" => "Edit FAQ question",
// "Add FAQ question" => "Add FAQ question",
// "Use a question from another FAQ" => "Use a question from another FAQ",
// "FAQ questions" => "FAQ questions",
// "Suggested questions" => "Suggested questions",
// "No suggested questions" => "No suggested questions",
// "File Archive" => "File Archive",
// "View tpl" => "View tpl",
// "File Galleries tpl" => "File Galleries tpl",
// "Be careful to set the right permissions on the files you link to" => "Be careful to set the right permissions on the files you link to",
// "Size (width x height)" => "Size (width x height)",
// "Forum Importer" => "Forum Importer",
// "Local SQL Filename on Server (path will be stripped)" => "Local SQL Filename on Server (path will be stripped)",
// "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up" => "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up",
// "Verification" => "Verification",
// "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>" => "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>",
// "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred" => "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred",
// "Select a Forum You Wish to Move (ONE at a time!)" => "Select a Forum You Wish to Move (ONE at a time!)",
// "Which Forum Do You Wish to Import this Into" => "Which Forum Do You Wish to Import this Into",
// "Message queue for forum" => "Message queue for forum",
// "Back to forum" => "Back to forum",
// "make this a thread of" => "make this a thread of",
// "None, this is a thread message" => "None, this is a thread message",
// "summary" => "summary",
// "normal" => "normal",
// "announce" => "announce",
// "hot" => "hot",
// "no feeling" => "no feeling",
// "frown" => "frown",
// "exclaim" => "exclaim",
// "idea" => "idea",
// "neutral" => "neutral",
// "question" => "question",
// "happy" => "happy",
// "wink" => "wink",
// "Save and Approve" => "Save and Approve",
// "convert to topic" => "convert to topic",
// "List of messages" => "List of messages",
// "New Topic" => "New Topic",
// "no summary" => "no summary",
// "No messages queued yet" => "No messages queued yet",
// "Search by name" => "Search by name",
// "Last Post" => "Last Post",
// "Configure Forum" => "Configure Forum",
// "Reported messages for forum" => "Reported messages for forum",
// "Reported by" => "Reported by",
// "Perfom action with checked" => "Perfom action with checked",
// "Un-report" => "Un-report",
// "Tag translation" => "Tag translation",
// "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag" => "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag",
// "Until then, they cannot be translated" => "Until then, they cannot be translated",
// "Show checkboxes to clear language information on tags" => "Show checkboxes to clear language information on tags",
// "There are no tags on this page in your preferred languages" => "There are no tags on this page in your preferred languages",
// "Set language" => "Set language",
// "Universal" => "Universal",
// "Show the following languages" => "Show the following languages",
// "Pending requests" => "Pending requests",
// "Request Time" => "Request Time",
// "Accept" => "Accept",
// "Refuse" => "Refuse",
// "Waiting requests" => "Waiting requests",
// "Cancel friendship request" => "Cancel friendship request",
// "Your friends" => "Your friends",
// "break friendship" => "break friendship",
// "Available scales" => "Available scales",
// "Global default" => "Global default",
// "Bounding box" => "Bounding box",
// "default scale" => "default scale",
// "No scales available" => "No scales available",
// "Original image is default scale" => "Original image is default scale",
// "Add scaled images with bounding box of square size" => "Add scaled images with bounding box of square size",
// "You can access the gallery using the following URL" => "You can access the gallery using the following URL",
// "Available Galleries" => "Available Galleries",
// "Choose a filter" => "Choose a filter",
// "Imgs" => "Imgs",
// "Make Map" => "Make Map",
// "Google Map Locator" => "Google Map Locator",
// "enter address" => "enter address",
// "Find address" => "Find address",
// "Save clicked point" => "Save clicked point",
// "Reset view to default" => "Reset view to default",
// "Save current view as default" => "Save current view as default",
// "Center map to saved point" => "Center map to saved point",
// "Reset view to site default" => "Reset view to site default",
// "Users Map" => "Users Map",
// "Select Graphic Type" => "Select Graphic Type",
// "Pie Chart" => "Pie Chart",
// "Multiline" => "Multiline",
// "Multibar" => "Multibar",
// "Bar Stack" => "Bar Stack",
// "Landscape" => "Landscape",
// "Portrait" => "Portrait",
// "Independant Scale" => "Independant Scale",
// "Horizontal Scale" => "Horizontal Scale",
// "Vertical Scale" => "Vertical Scale",
// "Series" => "Series",
// "Wiki plug-in" => "Wiki plug-in",
// "Ical import / Export" => "Ical import / Export",
// "Select The calendar to export" => "Select The calendar to export",
// "Calendar Import" => "Calendar Import",
// "ICal File" => "ICal File",
// "Im- Export languages" => "Im- Export languages",
// "Select the language to Import" => "Select the language to Import",
// "Select the language to Export" => "Select the language to Export",
// "Modify String in Source Language" => "Modify String in Source Language",
// "Original String" => "Original String",
// "New String" => "New String",
// "Import From File" => "Import From File",
// "Grab Wiki Tables" => "Grab Wiki Tables",
// "Import pages from a Structured Text Dump" => "Import pages from a Structured Text Dump",
// "Name of the dump file (it has to be in dump/)" => "Name of the dump file (it has to be in dump/)",
// "Overwrite existing pages if the name is the same" => "Overwrite existing pages if the name is the same",
// "Previously remove existing page versions" => "Previously remove existing page versions",
// "excerpt" => "excerpt",
// "Result" => "Result",
// "body" => "body",
// "If you are NOT running a new Tiki installation, make a backup of your database before using this importer" => "If you are NOT running a new Tiki installation, make a backup of your database before using this importer",
// "Your PHP is running with safe mode enabled. This might cause problems to the import process as safe mode limits the possibly to change in run time some PHP settings (like max_execution_time). It is recommended to run this script without safe mode" => "Your PHP is running with safe mode enabled. This might cause problems to the import process as safe mode limits the possibly to change in run time some PHP settings (like max_execution_time). It is recommended to run this script without safe mode",
// "Depending on the size of the file from the source software, the import process may take a while to complete. This might be a problem according to your PHP and web server settings. This script tries to change the relevant settings but there are some settings that the script cannot change. So, if you are having problems with the script, please try to increase the value of the following PHP settings: max_input_time, max_execution_time (this setting is limited by the web server setting, if you are running Apache also change its Timeout setting), post_max_size, upload_max_filesize, memory_limit. It is recommended that you run this script on a server where you can change the values of those settings (if needed)" => "Depending on the size of the file from the source software, the import process may take a while to complete. This might be a problem according to your PHP and web server settings. This script tries to change the relevant settings but there are some settings that the script cannot change. So, if you are having problems with the script, please try to increase the value of the following PHP settings: max_input_time, max_execution_time (this setting is limited by the web server setting, if you are running Apache also change its Timeout setting), post_max_size, upload_max_filesize, memory_limit. It is recommended that you run this script on a server where you can change the values of those settings (if needed)",
// "Select the software to import from" => "Select the software to import from",
// "WARNING: make sure to have a backup before running the script. If you do not have a backup this is the last chance to cancel the importer by clicking on the cancel button" => "WARNING: make sure to have a backup before running the script. If you do not have a backup this is the last chance to cancel the importer by clicking on the cancel button",
// "Congratulations! You have successful imported your data to Tikiwiki" => "Congratulations! You have successful imported your data to Tikiwiki",
// "pages imported from a total of" => "pages imported from a total of",
// "You can see the list of wiki pages in your site" => "You can see the list of wiki pages in your site",
// "here" => "here",
// "Importer log" => "Importer log",
// "Tiki installer" => "Tiki installer",
// "Welcome" => "Welcome",
// "Welcome to the Tiki installation and upgrade script" => "Welcome to the Tiki installation and upgrade script",
// "Use this script to install a new Tiki database or upgrade your existing database to release" => "Use this script to install a new Tiki database or upgrade your existing database to release",
// "For the latest information about this release, please read the" => "For the latest information about this release, please read the",
// "Release Notes" => "Release Notes",
// "For complete documentation, please visit" => "For complete documentation, please visit",
// "For more information about Tiki, please visit" => "For more information about Tiki, please visit",
// "Select your language" => "Select your language",
// "Read the License" => "Read the License",
// "Tiki is software distributed under the LGPL license" => "Tiki is software distributed under the LGPL license",
// " <a href=\"http://creativecommons.org/licenses/LGPL/2.1/\" target=\"_blank\">Here is a human-readable summary of the license below, including many translations.</a>" => " <a href=\"http://creativecommons.org/licenses/LGPL/2.1/\" target=\"_blank\">Here is a human-readable summary of the license below, including many translations.</a>",
// "Review the System Requirements" => "Review the System Requirements",
// "Before installing Tiki, <a href=\"http://doc.tikiwiki.org/Requirements\" target=\"_blank\">review the documentation</a> and confirm that your system meets the minimum requirements" => "Before installing Tiki, <a href=\"http://doc.tikiwiki.org/Requirements\" target=\"_blank\">review the documentation</a> and confirm that your system meets the minimum requirements",
// "This installer will perform some basic checks automatically" => "This installer will perform some basic checks automatically",
// "Memory" => "Memory",
// "Success" => "Success",
// "Tiki has not detected your PHP memory_limit" => "Tiki has not detected your PHP memory_limit",
// "This probably means you have no set limit (all is well)" => "This probably means you have no set limit (all is well)",
// "Tiki has detected your PHP memory limit at" => "Tiki has detected your PHP memory limit at",
// "Tiki requires <strong>at least</strong> 32MB of PHP memory for script execution" => "Tiki requires <strong>at least</strong> 32MB of PHP memory for script execution",
// "Allocating too little memory will cause Tiki to display blank pages" => "Allocating too little memory will cause Tiki to display blank pages",
// "To change the memory limit, use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 32M) and restart your webserver" => "To change the memory limit, use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 32M) and restart your webserver",
// "Tiki has detected your PHP memory_limit at" => "Tiki has detected your PHP memory_limit at",
// "Tiki uses the PHP <strong>mail</strong> function to send email notifications and messages" => "Tiki uses the PHP <strong>mail</strong> function to send email notifications and messages",
// "To test your system configuration, Tiki will attempt to send a test message to you" => "To test your system configuration, Tiki will attempt to send a test message to you",
// "Test email" => "Test email",
// "Email address to send test to" => "Email address to send test to",
// "Copy test mail to " => "Copy test mail to ",
// "Send Test Message" => "Send Test Message",
// "Tiki was able to send a test message to" => "Tiki was able to send a test message to",
// "Tiki was not able to send a test message" => "Tiki was not able to send a test message",
// "Review your mail log for details" => "Review your mail log for details",
// "Review the mail settings in your <strong>php.ini</strong> file (for example: confirm that the <strong>sendmail_path</strong> is correct)" => "Review the mail settings in your <strong>php.ini</strong> file (for example: confirm that the <strong>sendmail_path</strong> is correct)",
// "If your host requires SMTP authentication, additional configuration may be necessary" => "If your host requires SMTP authentication, additional configuration may be necessary",
// "Image Processing" => "Image Processing",
// "Tiki detected" => "Tiki detected",
// "Tiki was not able to detect the GD library" => "Tiki was not able to detect the GD library",
// "Tiki uses the GD library to process images for the Image Gallery and CAPTCHA support" => "Tiki uses the GD library to process images for the Image Gallery and CAPTCHA support",
// "Set the Database Connection" => "Set the Database Connection",
// "Tiki requires an active database connection" => "Tiki requires an active database connection",
// "You must create the database and user <em>before</em> completing this page" => "You must create the database and user <em>before</em> completing this page",
// "This is normal for a new installation" => "This is normal for a new installation",
// "Tiki found an existing database connection in your local.php file" => "Tiki found an existing database connection in your local.php file",
// "Use Existing Connection" => "Use Existing Connection",
// "Use this page to create a new database connection, or use the <a href=\"http://doc.tikiwiki.org/Manual+Installation\" target=\"_blank\" title=\"manual installation\">manual installation process</a>" => "Use this page to create a new database connection, or use the <a href=\"http://doc.tikiwiki.org/Manual+Installation\" target=\"_blank\" title=\"manual installation\">manual installation process</a>",
// "Database information" => "Database information",
// "Enter your database connection information" => "Enter your database connection information",
// "Select the type of database to use with Tiki" => "Select the type of database to use with Tiki",
// "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension" => "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension",
// "Host name" => "Host name",
// "Enter the host name or IP for your database" => "Enter the host name or IP for your database",
// "Use <strong>localhost</strong> if the database is running on the same machine as Tiki" => "Use <strong>localhost</strong> if the database is running on the same machine as Tiki",
// "Enter the name of the database that Tiki will use" => "Enter the name of the database that Tiki will use",
// "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your hosting provider.  Normally Tiki tables won't conflict with other product names" => "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your hosting provider.  Normally Tiki tables won't conflict with other product names",
// "Database user" => "Database user",
// "Enter a database user with administrator permission for the Database" => "Enter a database user with administrator permission for the Database",
// "User name" => "User name",
// "Install &amp; Upgrade" => "Install &amp; Upgrade",
// "Install" => "Install",
// "Failed to set max_execution_time to 0 for PHP. You may experience problems when creating/upgrading the database on a slow system. This will manitest itself by a blank page" => "Failed to set max_execution_time to 0 for PHP. You may experience problems when creating/upgrading the database on a slow system. This will manitest itself by a blank page",
// "This install will populate (or upgrade) the database" => "This install will populate (or upgrade) the database",
// "If you want to upgrade from a previous Tiki release, ensure that you have read and understood the <a href=\"http://doc.tikiwiki.org/Upgrade\" target=\"_blank\">Upgrade instructions</a>" => "If you want to upgrade from a previous Tiki release, ensure that you have read and understood the <a href=\"http://doc.tikiwiki.org/Upgrade\" target=\"_blank\">Upgrade instructions</a>",
// "A new install will populate the database" => "A new install will populate the database",
// "Reinstall the database" => "Reinstall the database",
// "This will destroy your current database" => "This will destroy your current database",
// "Reinstall" => "Reinstall",
// "Upgrade" => "Upgrade",
// "Warning: Category Permissions Will Not Be Upgraded" => "Warning: Category Permissions Will Not Be Upgraded",
// "Category permissions have been revamped in version 4. If you have been using category permissions, note that they may not work properly after upgrading to version 4, and it will be necessary to reconfigure them" => "Category permissions have been revamped in version 4. If you have been using category permissions, note that they may not work properly after upgrading to version 4, and it will be necessary to reconfigure them",
// "Automatically upgrade your existing database to v" => "Automatically upgrade your existing database to v",
// "This site has an admin account configured" => "This site has an admin account configured",
// "Please login with your admin password to continue" => "Please login with your admin password to continue",
// "Pass" => "Pass",
// "Review the Upgrade" => "Review the Upgrade",
// "Review the Installation" => "Review the Installation",
// "Upgrade complete" => "Upgrade complete",
// "Installation complete" => "Installation complete",
// "Your database has been configured and Tiki is ready to run" => "Your database has been configured and Tiki is ready to run",
// "If this is your first install, your admin password is <strong>admin</strong>" => "If this is your first install, your admin password is <strong>admin</strong>",
// "You can now log in into Tiki as user <strong>admin</strong> and start configuring the application" => "You can now log in into Tiki as user <strong>admin</strong> and start configuring the application",
// "Upgrade operations executed successfully" => "Upgrade operations executed successfully",
// "Installation operations executed successfully" => "Installation operations executed successfully",
// "SQL queries" => "SQL queries",
// "Database was left unchanged" => "Database was left unchanged",
// "Failed" => "Failed",
// "Operations failed" => "Operations failed",
// "Display details" => "Display details",
// "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages" => "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages",
// ".htaccess File" => ".htaccess File",
// "We recommend enabling the <strong>.htaccess</strong> file for your Tiki" => "We recommend enabling the <strong>.htaccess</strong> file for your Tiki",
// "This will enable you to use SEFURLs (search engine friendly URLs) and help improve site security" => "This will enable you to use SEFURLs (search engine friendly URLs) and help improve site security",
// "To enable this file, simply rename the <strong>_htaccess</strong> file (located in the main directory of your Tiki installation) to <strong>.htaccess</strong>" => "To enable this file, simply rename the <strong>_htaccess</strong> file (located in the main directory of your Tiki installation) to <strong>.htaccess</strong>",
// "Configure General Settings" => "Configure General Settings",
// "Complete these fields to configure common, general settings for your site" => "Complete these fields to configure common, general settings for your site",
// "The information you enter here can be changed later" => "The information you enter here can be changed later",
// "Refer to the <a href=\"http://doc.tikiwiki.org/Admin+Panels\" target=\"_blank\">documentation</a> for complete information on these, and other, settings" => "Refer to the <a href=\"http://doc.tikiwiki.org/Admin+Panels\" target=\"_blank\">documentation</a> for complete information on these, and other, settings",
// "This will appear in the browser title bar" => "This will appear in the browser title bar",
// "Email sent by your site will use this address" => "Email sent by your site will use this address",
// "Secure Login" => "Secure Login",
// "HTTPS login" => "HTTPS login",
// "Administrator" => "Administrator",
// "Admin email" => "Admin email",
// "This is the email address for your administrator account" => "This is the email address for your administrator account",
// "Enter Your Tiki" => "Enter Your Tiki",
// "The installation is complete" => "The installation is complete",
// "Tiki is an open source project, <em>you</em> can <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>join the community</a> and help <a href='http://info.tikiwiki.org/Develop+Tiki' target='_blank'>develop Tiki</a>" => "Tiki is an open source project, <em>you</em> can <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>join the community</a> and help <a href='http://info.tikiwiki.org/Develop+Tiki' target='_blank'>develop Tiki</a>",
// "Installation" => "Installation",
// "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation" => "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation",
// "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu" => "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu",
// "Enter Tiki and Lock Installer" => "Enter Tiki and Lock Installer",
// "Recommended" => "Recommended",
// "Enter Tiki Without Locking Installer" => "Enter Tiki Without Locking Installer",
// "MultiTiki Setup" => "MultiTiki Setup",
// "Default Installation" => "Default Installation",
// "DB OK" => "DB OK",
// "No DB" => "No DB",
// "Adding a new host" => "Adding a new host",
// "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter" => "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter",
// "MultiTiki" => "MultiTiki",
// "Are you upgrading an existing Tiki site" => "Are you upgrading an existing Tiki site",
// "Go directly to the <strong>Install/Upgrade</strong> step" => "Go directly to the <strong>Install/Upgrade</strong> step",
// "Install/Upgrade" => "Install/Upgrade",
// "Restart the installer" => "Restart the installer",
// "Database Connection" => "Database Connection",
// "Reset the Database Connection" => "Reset the Database Connection",
// "Install Profile" => "Install Profile",
// "Configure the General Settings" => "Configure the General Settings",
// "Tiki Icon" => "Tiki Icon",
// "TikiWiki Project Web Site" => "TikiWiki Project Web Site",
// "Support Forums" => "Support Forums",
// "TikiWiki CMS/Groupware Project" => "TikiWiki CMS/Groupware Project",
// "Powered by TikiWiki" => "Powered by TikiWiki",
// "Clear cached version and refresh cache" => "Clear cached version and refresh cache",
// "configure rules" => "configure rules",
// "Interactive translator" => "Interactive translator",
// "has been updated" => "has been updated",
// "Close this window" => "Close this window",
// "Clicking 'Close this window' will reload the main window from where it was opened" => "Clicking 'Close this window' will reload the main window from where it was opened",
// "Upload to Kaltura" => "Upload to Kaltura",
// "List Entries" => "List Entries",
// "Upload Successful" => "Upload Successful",
// "You have successfully added {\$count} new entry/entries" => "You have successfully added {\$count} new entry/entries",
// "Change Details" => "Change Details",
// "Remix" => "Remix",
// "Advanced Editor" => "Advanced Editor",
// "Simple Editor" => "Simple Editor",
// "Views" => "Views",
// "Plays" => "Plays",
// "Last 2 days" => "Last 2 days",
// "Last 3 days" => "Last 3 days",
// "Last 5 days" => "Last 5 days",
// "Last week" => "Last week",
// "Last 2 weeks" => "Last 2 weeks",
// "Last month" => "Last month",
// "Search by Date" => "Search by Date",
// "LastChanges" => "LastChanges",
// "v" => "v",
// "View Submissions" => "View Submissions",
// "ExpireDate" => "ExpireDate",
// "AuthorName" => "AuthorName",
// "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone" => "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone",
// "Create banner" => "Create banner",
// "Method" => "Method",
// "Use Dates" => "Use Dates",
// "Max Impressions" => "Max Impressions",
// "Impressions" => "Impressions",
// "Max Clicks" => "Max Clicks",
// "Clicks" => "Clicks",
// "Create New Blog" => "Create New Blog",
// "The cache is used by" => "The cache is used by",
// "Approval" => "Approval",
// "Rejected" => "Rejected",
// "Dynamic content system" => "Dynamic content system",
// "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block" => "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block",
// "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block" => "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block",
// "Edit content block" => "Edit content block",
// "Create content block" => "Create content block",
// "Available content blocks" => "Available content blocks",
// "Current Value" => "Current Value",
// "Current ver" => "Current ver",
// "Next ver" => "Next ver",
// "Future vers" => "Future vers",
// "Program" => "Program",
// "Available FAQs" => "Available FAQs",
// "Create new FAQ" => "Create new FAQ",
// "Create New FAQ" => "Create New FAQ",
// "Users can suggest questions" => "Users can suggest questions",
// "Create a File Gallery" => "Create a File Gallery",
// "SlideShow" => "SlideShow",
// "Keep gallery window open" => "Keep gallery window open",
// "Modifications" => "Modifications",
// "Property <b>{\$fgp_name}</b> Changed" => "Property <b>{\$fgp_name}</b> Changed",
// "Gallery Images" => "Gallery Images",
// "Media Entries" => "Media Entries",
// "Mix Entries" => "Mix Entries",
// "Kaltura Remix Entries" => "Kaltura Remix Entries",
// "Kaltura Media Entries" => "Kaltura Media Entries",
// "Loads" => "Loads",
// "Browse Entries" => "Browse Entries",
// "Media Type" => "Media Type",
// "No entries" => "No entries",
// "No media entries found. " => "No media entries found. ",
// "Click here " => "Click here ",
// "to upload" => "to upload",
// "No mix entries found. " => "No mix entries found. ",
// "to create a new mix" => "to create a new mix",
// "Playlist Type" => "Playlist Type",
// "No playlists found. " => "No playlists found. ",
// "to create a playlist" => "to create a playlist",
// "Object Permissions List" => "Object Permissions List",
// "Manage Permissions" => "Manage Permissions",
// "If an object is not in the special section, then only the default perms are on" => "If an object is not in the special section, then only the default perms are on",
// "Special" => "Special",
// "Edit New Submission" => "Edit New Submission",
// "Survey stats" => "Survey stats",
// "Take Survey" => "Take Survey",
// "users registered" => "users registered",
// "Those movies are very good tutorials of tikiwiki use. They have been generated by siridhar with camtasia studio for public use ! Thanks to him. The up-to-date list of movies is on" => "Those movies are very good tutorials of tikiwiki use. They have been generated by siridhar with camtasia studio for public use ! Thanks to him. The up-to-date list of movies is on",
// "Page aliases found" => "Page aliases found",
// " {if \$find ne ''}and {/if}starting with" => " {if \$find ne ''}and {/if}starting with",
// "However, some page aliases fitting the query were found (see Aliases section above)" => "However, some page aliases fitting the query were found (see Aliases section above)",
// "Xml Zip" => "Xml Zip",
// "Transcripts" => "Transcripts",
// "Online operators" => "Online operators",
// "Accepted requests" => "Accepted requests",
// "transcripts" => "transcripts",
// "offline" => "offline",
// "Offline operators" => "Offline operators",
// "Add an operator to the system" => "Add an operator to the system",
// "Operators must be tiki users" => "Operators must be tiki users",
// "Set as Operator" => "Set as Operator",
// "Chat started" => "Chat started",
// "Live support:User window" => "Live support:User window",
// "Request live support" => "Request live support",
// "Request support" => "Request support",
// "Open a support ticket instead" => "Open a support ticket instead",
// "Your request is being processed" => "Your request is being processed",
// "cancel request and exit" => "cancel request and exit",
// "cancel request and leave a message" => "cancel request and leave a message",
// "Live support:Console" => "Live support:Console",
// "be online" => "be online",
// "be offline" => "be offline",
// "Support requests" => "Support requests",
// "Requested" => "Requested",
// "Join" => "Join",
// "Support chat transcripts" => "Support chat transcripts",
// "Back to admin" => "Back to admin",
// "operator" => "operator",
// "started" => "started",
// "reason" => "reason",
// "msgs" => "msgs",
// "Transcript" => "Transcript",
// "For security purposes we must periodically validate your email address to allow continued access to this site" => "For security purposes we must periodically validate your email address to allow continued access to this site",
// "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site" => "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site",
// "Thank you" => "Thank you",
// "Mail-in feature" => "Mail-in feature",
// "Missing dependency. Obtain <a href=\"http://tikiwiki.org/tiki-download_file.php?fileId=50\">visorFreemind.swf</a> and upload it in files/" => "Missing dependency. Obtain <a href=\"http://tikiwiki.org/tiki-download_file.php?fileId=50\">visorFreemind.swf</a> and upload it in files/",
// "Prefs" => "Prefs",
// "Daily" => "Daily",
// "Weekly" => "Weekly",
// "Tikiwiki Mods" => "Tikiwiki Mods",
// "Mods Configuration" => "Mods Configuration",
// "Update remote index" => "Update remote index",
// "Rebuild local list" => "Rebuild local list",
// "Republish all" => "Republish all",
// "Publish all" => "Publish all",
// "Unpublish all" => "Unpublish all",
// "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>" => "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>",
// "Tiki \"mods\" are undergoing refurbishment" => "Tiki \"mods\" are undergoing refurbishment",
// "You will probably some find mods shown as being compatible with older versions of Tiki will work with later versions with little or no modification" => "You will probably some find mods shown as being compatible with older versions of Tiki will work with later versions with little or no modification",
// "Your help is needed! Please visit <a href=\"http://dev.tikiwiki.org/tiki-index.php?page=Mods\">dev.tikiwiki.org</a> to find out more" => "Your help is needed! Please visit <a href=\"http://dev.tikiwiki.org/tiki-index.php?page=Mods\">dev.tikiwiki.org</a> to find out more",
// "Attention" => "Attention",
// "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"sh setup.sh\" for example)" => "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"sh setup.sh\" for example)",
// "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"sh setup.sh open\" to set it up). After installation you need to remove that permission (using \"sh setup.sh\")" => "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"sh setup.sh open\" to set it up). After installation you need to remove that permission (using \"sh setup.sh\")",
// "all types" => "all types",
// "for version" => "for version",
// "all versions" => "all versions",
// "or later" => "or later",
// "No mods found" => "No mods found",
// "Display only this type" => "Display only this type",
// "Unpublish" => "Unpublish",
// "Republish" => "Republish",
// "licence" => "licence",
// "Tikiwiki Mods Configuration" => "Tikiwiki Mods Configuration",
// "Mods Install/uninstall" => "Mods Install/uninstall",
// "Enable Mods providing" => "Enable Mods providing",
// "Mods local directory" => "Mods local directory",
// "Mods remote server" => "Mods remote server",
// "Package Config" => "Package Config",
// "y" => "y",
// "Records" => "Records",
// "My Articles" => "My Articles",
// "User Articles" => "User Articles",
// "My User Items" => "My User Items",
// "User Items" => "User Items",
// "Unread Messages" => "Unread Messages",
// "User forum topics" => "User forum topics",
// "Forum topics" => "Forum topics",
// "Date of post" => "Date of post",
// "User forum replies" => "User forum replies",
// "Forum replies" => "Forum replies",
// "To display the objects you created or contributed to" => "To display the objects you created or contributed to",
// "Contacts Preferences" => "Contacts Preferences",
// "My Watches" => "My Watches",
// "Sent Edition" => "Sent Edition",
// "HTML version" => "HTML version",
// "Text version" => "Text version",
// "Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed" => "Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed",
// "Your email address was removed from the list of subscriptors" => "Your email address was removed from the list of subscriptors",
// "Removal of your email address failed" => "Removal of your email address failed",
// "Subscription confirmed" => "Subscription confirmed",
// "Subscription failed" => "Subscription failed",
// "Subscribe to Newsletter" => "Subscribe to Newsletter",
// "Subscribe to this Newsletter" => "Subscribe to this Newsletter",
// "quota" => "quota",
// "No notes yet" => "No notes yet",
// "Merge selected notes into" => "Merge selected notes into",
// "Reading note" => "Reading note",
// "Object Watches" => "Object Watches",
// "Watching Groups" => "Watching Groups",
// "Currently editing Global permissions" => "Currently editing Global permissions",
// "This object's direct permissions override any global permissions or category permissions affecting this object" => "This object's direct permissions override any global permissions or category permissions affecting this object",
// "This category's direct permissions override any global permissions affecting objects in it" => "This category's direct permissions override any global permissions affecting objects in it",
// "To edit global permissions" => "To edit global permissions",
// "No permissions yet applied to this object but category permissions affect this object and are displayed below" => "No permissions yet applied to this object but category permissions affect this object and are displayed below",
// "To edit category permissions" => "To edit category permissions",
// "No direct permissions yet applied to this object. Global permissions apply" => "No direct permissions yet applied to this object. Global permissions apply",
// "Currently inherited permissions displayed" => "Currently inherited permissions displayed",
// "Assign global permissions" => "Assign global permissions",
// "Reset to Global Perms" => "Reset to Global Perms",
// "Reset Perms" => "Reset Perms",
// "This will remove all the settings here and permissions will be reset to inherit any category permissions that are set, or the global sitewide permissions" => "This will remove all the settings here and permissions will be reset to inherit any category permissions that are set, or the global sitewide permissions",
// "This will remove all the settings here and permissions will be reset to inherit the global sitewide permissions" => "This will remove all the settings here and permissions will be reset to inherit the global sitewide permissions",
// "Permissions Clipboard" => "Permissions Clipboard",
// "Copy the permissions set here" => "Copy the permissions set here",
// "Paste" => "Paste",
// "Paste copied permissions from " => "Paste copied permissions from ",
// "Assign or remove permissions on <em>all</em> child categories" => "Assign or remove permissions on <em>all</em> child categories",
// "Are you sure you want to effect all child categories?\\nThere is no undo" => "Are you sure you want to effect all child categories?\\nThere is no undo",
// "Assign or remove permissions on all pages of the sub-structure" => "Assign or remove permissions on all pages of the sub-structure",
// "Are you sure you want to effect all pages in this sub-structure?\\nThere is no undo" => "Are you sure you want to effect all pages in this sub-structure?\\nThere is no undo",
// "Select groups" => "Select groups",
// "Some of your groups have been automatically hidden.<br /> Select the groups below to assign permissions for" => "Some of your groups have been automatically hidden.<br /> Select the groups below to assign permissions for",
// "Select all" => "Select all",
// "Select features" => "Select features",
// "Some of your features have been automatically hidden.<br /> Select the features below to assign permissions for" => "Some of your features have been automatically hidden.<br /> Select the features below to assign permissions for",
// "Show permissions for disabled features" => "Show permissions for disabled features",
// "Feature name" => "Feature name",
// "Quick Permissions" => "Quick Permissions",
// "These permissions override any global permissions or category permissions affecting this object" => "These permissions override any global permissions or category permissions affecting this object",
// "To edit global permissions <a class=\"rbox-link\" href=\"tiki-objectpermissions.php?objectType=global\">click here</a>" => "To edit global permissions <a class=\"rbox-link\" href=\"tiki-objectpermissions.php?objectType=global\">click here</a>",
// "Assign Quick-Permissions to this object" => "Assign Quick-Permissions to this object",
// "A couple of userdefined permissions are currently assigned (See tab Assign Permissions)" => "A couple of userdefined permissions are currently assigned (See tab Assign Permissions)",
// "However, no account is associated to the OpenID identifier" => "However, no account is associated to the OpenID identifier",
// "Associate OpenID with an existing Tikiwiki account" => "Associate OpenID with an existing Tikiwiki account",
// "Your identity gives you access to multiple user accounts" => "Your identity gives you access to multiple user accounts",
// "random" => "random",
// "File (only .gif, .jpg and .png images approximately 45px × 45px)" => "File (only .gif, .jpg and .png images approximately 45px × 45px)",
// "Plugin execution was denied" => "Plugin execution was denied",
// "Plugin execution pending approval" => "Plugin execution pending approval",
// "After argument validation by an editor, the execution of this plugin was denied. This plugin will eventually be removed or corrected" => "After argument validation by an editor, the execution of this plugin was denied. This plugin will eventually be removed or corrected",
// "This plugin was recently added or modified. Until an editor of the site validates the parameters, execution will not be possible" => "This plugin was recently added or modified. Until an editor of the site validates the parameters, execution will not be possible",
// "You are allowed to" => "You are allowed to",
// "View arguments" => "View arguments",
// "Execute the plugin in preview mode (may be dangerous)" => "Execute the plugin in preview mode (may be dangerous)",
// "Approve the plugin for public execution" => "Approve the plugin for public execution",
// "View Details" => "View Details",
// "This plugin does not contain any arguments" => "This plugin does not contain any arguments",
// "This plugin's body is empty" => "This plugin's body is empty",
// "Any" => "Any",
// "Items found" => "Items found",
// "Rank" => "Rank",
// "atts" => "atts",
// "List Attachments" => "List Attachments",
// "Sum" => "Sum",
// "Plugin Approval" => "Plugin Approval",
// "For security, grant the <strong>tiki_p_plugin_approve</strong> permission only to trusted user groups" => "For security, grant the <strong>tiki_p_plugin_approve</strong> permission only to trusted user groups",
// "Use the <a href=\"tiki-admin.php?page=textarea\">Admin: Text Area page</a> to deactivate potentially risky plugins" => "Use the <a href=\"tiki-admin.php?page=textarea\">Admin: Text Area page</a> to deactivate potentially risky plugins",
// "This page lists the plugins that require validation, the first time they are encountered" => "This page lists the plugins that require validation, the first time they are encountered",
// "Each plugin contains a unique <em>signature</em> that is preserved" => "Each plugin contains a unique <em>signature</em> that is preserved",
// "If a plugin is no longer in use (for example, it has been removed from the wiki page), use <strong>Clear</strong> to remove it from this list" => "If a plugin is no longer in use (for example, it has been removed from the wiki page), use <strong>Clear</strong> to remove it from this list",
// "The plugin will automatically be added if it is encountered" => "The plugin will automatically be added if it is encountered",
// "Plugins can be individually previewed, approved, or rejected from the particular location that contains the plugin" => "Plugins can be individually previewed, approved, or rejected from the particular location that contains the plugin",
// "For security, you should review each plugin to ensure it is safe to approve" => "For security, you should review each plugin to ensure it is safe to approve",
// "Added By" => "Added By",
// "Signature" => "Signature",
// "Wiki page: <a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page" => "Wiki page: <a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page",
// "<a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page" => "<a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page",
// "Approve all pending plugins" => "Approve all pending plugins",
// "Using <strong>Approve</strong> or <strong>Approve All</strong> will approve and activate the pending plugins" => "Using <strong>Approve</strong> or <strong>Approve All</strong> will approve and activate the pending plugins",
// "Use this feature <strong>only</strong> if you have verified that all the pending plugins are safe" => "Use this feature <strong>only</strong> if you have verified that all the pending plugins are safe",
// "No plugins pending approval" => "No plugins pending approval",
// "View Results" => "View Results",
// "Vote poll" => "Vote poll",
// "Other Polls" => "Other Polls",
// "Poll Results" => "Poll Results",
// "Top Voted Polls" => "Top Voted Polls",
// "Edit Poll" => "Edit Poll",
// "Find the poll" => "Find the poll",
// "Number of top voted polls to show" => "Number of top voted polls to show",
// "Vote range displayed" => "Vote range displayed",
// "All votes with no span consideration" => "All votes with no span consideration",
// "All votes with span consideration" => "All votes with span consideration",
// "All votes" => "All votes",
// "List Votes" => "List Votes",
// "Permission denied. You do not have permission to read complete articles" => "Permission denied. You do not have permission to read complete articles",
// "The original document is available at" => "The original document is available at",
// "Print multiple pages" => "Print multiple pages",
// "Current Version" => "Current Version",
// "randomly selected questions" => "randomly selected questions",
// "Test-time Options" => "Test-time Options",
// "Limit questions displayed per page to " => "Limit questions displayed per page to ",
// "&nbsp question(s)" => "&nbsp question(s)",
// "Impose a time limit of " => "Impose a time limit of ",
// "Allow students to store partial results and return to quiz" => "Allow students to store partial results and return to quiz",
// "Allow students to retake this quiz " => "Allow students to retake this quiz ",
// "Grading and Feedback" => "Grading and Feedback",
// "Grading method " => "Grading method ",
// "Show students their score " => "Show students their score ",
// "Show students the correct answers " => "Show students the correct answers ",
// "Publish statistics " => "Publish statistics ",
// "Extra Options" => "Extra Options",
// "Solicit additional questions from students" => "Solicit additional questions from students",
// "Link quiz to forum named: " => "Link quiz to forum named: ",
// "Prologue" => "Prologue",
// "Epilogue" => "Epilogue",
// "Quiz result stats" => "Quiz result stats",
// "Time" => "Time",
// "User answers" => "User answers",
// "Stats for quizzes" => "Stats for quizzes",
// "taken" => "taken",
// "Av score" => "Av score",
// "Av time" => "Av time",
// "Stats for quiz" => "Stats for quiz",
// "Clear Stats" => "Clear Stats",
// "time taken" => "time taken",
// "P/F" => "P/F",
// "Passed" => "Passed",
// "Stats for this quiz Questions " => "Stats for this quiz Questions ",
// "Prefix the checked" => "Prefix the checked",
// "Postfix the checked" => "Postfix the checked",
// "Referer stats" => "Referer stats",
// "Use your email as login" => "Use your email as login",
// "Minimum {\$prefs.min_username_length} characters long" => "Minimum {\$prefs.min_username_length} characters long",
// "Passcode to register" => "Passcode to register",
// "Not your password" => "Not your password",
// "To request a passcode, {if \$prefs.feature_contact eq 'y'}<a href=\"tiki-contact.php\">{/if}\n\t\t\t\t\t\tcontact the sytem administrator{if \$prefs.feature_contact eq 'y'}</a>{/if}" => "To request a passcode, {if \$prefs.feature_contact eq 'y'}<a href=\"tiki-contact.php\">{/if}\n\t\t\t\t\t\tcontact the sytem administrator{if \$prefs.feature_contact eq 'y'}</a>{/if}",
// "Generate a\tpassword" => "Generate a\tpassword",
// "Make sure to whitelist this domain to prevent registration emails being canned by your spam filter" => "Make sure to whitelist this domain to prevent registration emails being canned by your spam filter",
// "On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites" => "On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites",
// "Registering does not give you any benefits except one more link to your site" => "Registering does not give you any benefits except one more link to your site",
// "You don't get any emails, we don't sell the data about your site" => "You don't get any emails, we don't sell the data about your site",
// "Registering is just for us to get an overview of Tiki's usage" => "Registering is just for us to get an overview of Tiki's usage",
// "Enter your email" => "Enter your email",
// "Back to page" => "Back to page",
// "to version" => "to version",
// "Date Search" => "Date Search",
// "All dates" => "All dates",
// "Calendar Items" => "Calendar Items",
// "octets" => "octets",
// "Apply content template" => "Apply content template",
// "Data HTML" => "Data HTML",
// "Data Txt" => "Data Txt",
// "Attached Files" => "Attached Files",
// "To add a file, click here" => "To add a file, click here",
// "Reply To Email" => "Reply To Email",
// "if not" => "if not",
// "Save your changes" => "Save your changes",
// "Save any changes and send to all subscribers" => "Save any changes and send to all subscribers",
// "Transmission results" => "Transmission results",
// "Ex: http://tikiwiki.org or localhost" => "Ex: http://tikiwiki.org or localhost",
// "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need" => "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need",
// "Create a sheet" => "Create a sheet",
// "Edit this sheet" => "Edit this sheet",
// "Create New Sheet" => "Create New Sheet",
// "There are individual permissions set for this sheet" => "There are individual permissions set for this sheet",
// "Class Name" => "Class Name",
// "Header Rows" => "Header Rows",
// "Footer Rows" => "Footer Rows",
// "Create new Sheet" => "Create new Sheet",
// "You can access the sheet using the following URL" => "You can access the sheet using the following URL",
// "Available Sheets" => "Available Sheets",
// "Change shoutbox general settings" => "Change shoutbox general settings",
// "auto-link urls" => "auto-link urls",
// "Post or edit a message" => "Post or edit a message",
// "Location : " => "Location : ",
// "This is the staging copy of" => "This is the staging copy of",
// "the approved version of this page" => "the approved version of this page",
// "Viewing of changes since last approval is possible only after first approval" => "Viewing of changes since last approval is possible only after first approval",
// "Approve changes" => "Approve changes",
// "Latest changes will be synchronized after approval" => "Latest changes will be synchronized after approval",
// "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time" => "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time",
// "Content may be out of date" => "Content may be out of date",
// "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages" => "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages",
// "TOC" => "TOC",
// "This text was automatically translated by Google Translate from the following page: " => "This text was automatically translated by Google Translate from the following page: ",
// "page: %0/%1" => "page: %0/%1",
// "Page last modified on %0 by %1" => "Page last modified on %0 by %1",
// "Created by %0" => "Created by %0",
// "Last Modification: %0 by %1" => "Last Modification: %0 by %1",
// "You will not see the latest queries" => "You will not see the latest queries",
// "Clean" => "Clean",
// "Params" => "Params",
// "Most viewed objects in period" => "Most viewed objects in period",
// "Daily Usage" => "Daily Usage",
// "Stats for surveys" => "Stats for surveys",
// "Last taken" => "Last taken",
// "Stats for survey" => "Stats for survey",
// "Tiki Logs" => "Tiki Logs",
// "Clean logs older than" => "Clean logs older than",
// "months" => "months",
// "Time Left" => "Time Left",
// "Send Answers" => "Send Answers",
// "Summary mode" => "Summary mode",
// "Show Tidy Errors and Warnings" => "Show Tidy Errors and Warnings",
// "Show POST Data" => "Show POST Data",
// "Recorded Links" => "Recorded Links",
// "Request" => "Request",
// "Element to compare (Xpath expression)" => "Element to compare (Xpath expression)",
// "Test Xpath Expression" => "Test Xpath Expression",
// "Post Variables" => "Post Variables",
// "Tidy Results" => "Tidy Results",
// "Delete this link" => "Delete this link",
// "TikiTests List" => "TikiTests List",
// "Config" => "Config",
// "Replay" => "Replay",
// "Tidy extension not present" => "Tidy extension not present",
// "PECL HTTP extension present" => "PECL HTTP extension present",
// "cURL extension present" => "cURL extension present",
// "PECL HTTP and cURL extension not present. Replay of the TikiTest will not be possible" => "PECL HTTP and cURL extension not present. Replay of the TikiTest will not be possible",
// "List TikiTests" => "List TikiTests",
// "Create a TikiTest" => "Create a TikiTest",
// "Replay the TikiTest" => "Replay the TikiTest",
// "Edit the TikiTest" => "Edit the TikiTest",
// "TikiTests Record Configuration" => "TikiTests Record Configuration",
// "Start Recording Test" => "Start Recording Test",
// "TikiTests Replay Configuration" => "TikiTests Replay Configuration",
// "Failure" => "Failure",
// "Reference" => "Reference",
// "The pages are different" => "The pages are different",
// "The pages are identical" => "The pages are identical",
// "Recording to pause press the pause button" => "Recording to pause press the pause button",
// "Pause the recording" => "Pause the recording",
// "Paused to resume press the play button" => "Paused to resume press the play button",
// "Resume the recording" => "Resume the recording",
// "Stop the recording" => "Stop the recording",
// "Theme Control Center: Categories" => "Theme Control Center: Categories",
// "Theme is selected as follows" => "Theme is selected as follows",
// "If a theme is assigned to the individual object that theme is used" => "If a theme is assigned to the individual object that theme is used",
// "If not then if a theme is assigned to the object's category that theme is used" => "If not then if a theme is assigned to the object's category that theme is used",
// "If not then a theme for the section is used" => "If not then a theme for the section is used",
// "If none of the above was selected the user theme is used" => "If none of the above was selected the user theme is used",
// "Finally if the user didn't select a theme the default theme is used" => "Finally if the user didn't select a theme the default theme is used",
// "Control by Objects" => "Control by Objects",
// "Control by Sections" => "Control by Sections",
// "Theme Control Center: Objects" => "Theme Control Center: Objects",
// "Control by Categories" => "Control by Categories",
// "Theme Control Center: Sections" => "Theme Control Center: Sections",
// "Advanced mode" => "Advanced mode",
// "Retry" => "Retry",
// "The following file was successfully uploaded" => "The following file was successfully uploaded",
// "The following files have been successfully uploaded" => "The following files have been successfully uploaded",
// "You can link to the file from a Wiki page using" => "You can link to the file from a Wiki page using",
// "You can display an image in a Wiki page using" => "You can display an image in a Wiki page using",
// "Or using as a thumbnail with ShadowBox" => "Or using as a thumbnail with ShadowBox",
// "You can link to the file from an HTML page using" => "You can link to the file from an HTML page using",
// "File title" => "File title",
// "File description" => "File description",
// "Unzip zip files" => "Unzip zip files",
// "Author, if different from the Creator" => "Author, if different from the Creator",
// "Maximum number of downloads" => "Maximum number of downloads",
// "Add File" => "Add File",
// "Maximum file size is around" => "Maximum file size is around",
// "Uploading file.." => "Uploading file..",
// "No File to Upload.." => "No File to Upload..",
// " Syntax tips" => " Syntax tips",
// "Link to file from a Wiki page" => "Link to file from a Wiki page",
// "For image files" => "For image files",
// "To display in a Wiki page" => "To display in a Wiki page",
// "Display thumbnail that enlarges" => "Display thumbnail that enlarges",
// "or upload a local image from your disk" => "or upload a local image from your disk",
// "Batch Upload" => "Batch Upload",
// "Restore defaults" => "Restore defaults",
// "The column is disabled" => "The column is disabled",
// "#" => "#",
// "act" => "act",
// "a bookmark" => "a bookmark",
// "Basic Data" => "Basic Data",
// "User Icon" => "User Icon",
// "(non public)" => "(non public)",
// "This user is your friend " => "This user is your friend ",
// "The user requested friendship with you" => "The user requested friendship with you",
// "Accept friendship from this user" => "Accept friendship from this user",
// "Refuse friendship from this user" => "Refuse friendship from this user",
// "Currently waiting for user approval" => "Currently waiting for user approval",
// "Cancel friendship request towards this user" => "Cancel friendship request towards this user",
// "Request friendship from this user" => "Request friendship from this user",
// "Additional Information" => "Additional Information",
// "User Contribution" => "User Contribution",
// "has contributed to the following content" => "has contributed to the following content",
// "has not contributed to any content yet" => "has not contributed to any content yet",
// "Forum comments" => "Forum comments",
// "Send Me A Message" => "Send Me A Message",
// "Send me a message " => "Send me a message ",
// "The following message will be sent to user" => "The following message will be sent to user",
// "Message Body" => "Message Body",
// "Toggle" => "Toggle",
// "Toggle options" => "Toggle options",
// "Personal Information" => "Personal Information",
// "Male" => "Male",
// "Female" => "Female",
// "Use Google Map locator" => "Use Google Map locator",
// "Your personal tracker information" => "Your personal tracker information",
// "View extra information" => "View extra information",
// "Is email public? (uses scrambling to prevent spam)" => "Is email public? (uses scrambling to prevent spam)",
// "Unavailable - please set your e-mail below" => "Unavailable - please set your e-mail below",
// "Does your mail reader need a special charset" => "Does your mail reader need a special charset",
// "Your preferred language" => "Your preferred language",
// "Can you read more languages" => "Can you read more languages",
// "Other languages you can read (select on the left to add to the list on the right)" => "Other languages you can read (select on the left to add to the list on the right)",
// "Select language.." => "Select language..",
// "Display info tooltip on mouseover for every user who allows his/her information to be public" => "Display info tooltip on mouseover for every user who allows his/her information to be public",
// "My user items" => "My user items",
// "My level" => "My level",
// "Account Information" => "Account Information",
// "Leave \"New password\" and \"Confirm new password\" fields blank to keep current password" => "Leave \"New password\" and \"Confirm new password\" fields blank to keep current password",
// "Confirm new password" => "Confirm new password",
// "Change administrative info" => "Change administrative info",
// "Account Deletion" => "Account Deletion",
// "Are you really sure you want to delete your account " => "Are you really sure you want to delete your account ",
// "Check this box if you really want to delete your account" => "Check this box if you really want to delete your account",
// "Delete my account" => "Delete my account",
// "New task" => "New task",
// "Task list" => "Task list",
// "Admin mode off" => "Admin mode off",
// "Admin mode on" => "Admin mode on",
// "Task help" => "Task help",
// "Empty Trash" => "Empty Trash",
// "Received task" => "Received task",
// "You received this task, please read and execute it" => "You received this task, please read and execute it",
// "Send task" => "Send task",
// "You send this task to a other user" => "You send this task to a other user",
// "Shared task" => "Shared task",
// "This task is public to a special group" => "This task is public to a special group",
// "Accepted by Task User and Creator" => "Accepted by Task User and Creator",
// "Accepted User and Creator" => "Accepted User and Creator",
// "Task is accepted by user and creator" => "Task is accepted by user and creator",
// "Not Accepted by One User" => "Not Accepted by One User",
// "Not Accepted User" => "Not Accepted User",
// "Task is rejected by one user" => "Task is rejected by one user",
// "Waiting for Me" => "Waiting for Me",
// "Task is not accepted by you, read the task and accept or reject it" => "Task is not accepted by you, read the task and accept or reject it",
// "Waiting for Other User" => "Waiting for Other User",
// "Task is not accepted/rejected by other user" => "Task is not accepted/rejected by other user",
// "Admin Mode" => "Admin Mode",
// "Task saved" => "Task saved",
// "View Task" => "View Task",
// "Open a new task" => "Open a new task",
// "taskId" => "taskId",
// "Task user" => "Task user",
// "Only the creator can delete this task" => "Only the creator can delete this task",
// "Use start date and time" => "Use start date and time",
// "Use end date and time" => "Use end date and time",
// "Open / In Process" => "Open / In Process",
// "Waiting / Not Started" => "Waiting / Not Started",
// "Percentage completed" => "Percentage completed",
// "Shared for Group" => "Shared for Group",
// "Accepted by User" => "Accepted by User",
// "No / Rejected" => "No / Rejected",
// "Accepted by Creator" => "Accepted by Creator",
// "This message will be send to users if you are makeing changes of assigned tasks" => "This message will be send to users if you are makeing changes of assigned tasks",
// "Send message with changes" => "Send message with changes",
// "Modified by" => "Modified by",
// "Marked as deleted" => "Marked as deleted",
// "Inform task user by email" => "Inform task user by email",
// "You can only view this task" => "You can only view this task",
// "Completed" => "Completed",
// "%m/%d/%Y [%H:%M]" => "%m/%d/%Y [%H:%M]",
// "No tasks entered" => "No tasks entered",
// "Select One" => "Select One",
// "Undo Trash" => "Undo Trash",
// "Received" => "Received",
// "Submitted" => "Submitted",
// "Shared" => "Shared",
// "version" => "version",
// "completed (100%)" => "completed (100%)",
// "Public for group" => "Public for group",
// "User Watches and preferences" => "User Watches and preferences",
// "You need to set your email to receive email notifications" => "You need to set your email to receive email notifications",
// "Report Preferences" => "Report Preferences",
// "You are not allowed to remove this notification " => "You are not allowed to remove this notification ",
// "Use reports to summarise notifications about objects you are watching" => "Use reports to summarise notifications about objects you are watching",
// "Use reports" => "Use reports",
// "Interval in witch you want to get the reports" => "Interval in witch you want to get the reports",
// "Monthly" => "Monthly",
// "Short report" => "Short report",
// "Detailed report" => "Detailed report",
// "HTML-Email" => "HTML-Email",
// "Send me an email also if nothing happened" => "Send me an email also if nothing happened",
// "Reports are disabled, only standard reporting is available" => "Reports are disabled, only standard reporting is available",
// "Sites you are watching" => "Sites you are watching",
// "Select event type" => "Select event type",
// "All watched events" => "All watched events",
// "A user edited an article" => "A user edited an article",
// "A user deleted an article" => "A user deleted an article",
// "A user edits an article" => "A user edits an article",
// "A user deletes an article" => "A user deletes an article",
// "no limit for admin" => "no limit for admin",
// "May need to refresh twice to see changes" => "May need to refresh twice to see changes",
// "Add top level bookmarks to menu" => "Add top level bookmarks to menu",
// "New Window" => "New Window",
// "replace window" => "replace window",
// "Pos" => "Pos",
// "User_versions_for" => "User_versions_for",
// "Insert Row" => "Insert Row",
// "Insert Column" => "Insert Column",
// "Merge Cells" => "Merge Cells",
// "Restore Cells" => "Restore Cells",
// "Copy Calculation" => "Copy Calculation",
// "Format Cell" => "Format Cell",
// "expires" => "expires",
// "No articles yet" => "No articles yet",
// "Add an article" => "Add an article",
// "Banner stats" => "Banner stats",
// "Create new banner" => "Create new banner",
// "Banner Information" => "Banner Information",
// "Click ratio" => "Click ratio",
// "Banner raw data" => "Banner raw data",
// "This is a cached version of the page" => "This is a cached version of the page",
// "Click here to view the Google cache of the page instead" => "Click here to view the Google cache of the page instead",
// "There are no questions in this FAQ" => "There are no questions in this FAQ",
// "Answers" => "Answers",
// "Add Suggestion" => "Add Suggestion",
// "Forum List" => "Forum List",
// "Edit Forum" => "Edit Forum",
// "Manage Message Queue" => "Manage Message Queue",
// "Manage Reported Messages" => "Manage Reported Messages",
// "Monitor Topics of this Forum" => "Monitor Topics of this Forum",
// "Stop Monitoring Topics of this Forum" => "Stop Monitoring Topics of this Forum",
// "Monitor Topics and Threads of this Forum" => "Monitor Topics and Threads of this Forum",
// "Stop Monitoring Topics and Threads of this Forum" => "Stop Monitoring Topics and Threads of this Forum",
// "Group Monitor Topics of this Forum" => "Group Monitor Topics of this Forum",
// "Group Monitor Topics and Threads of this Forum" => "Group Monitor Topics and Threads of this Forum",
// "Editing" => "Editing",
// "Post New" => "Post New",
// "Summary" => "Summary",
// "Watch for replies" => "Watch for replies",
// "Send me an e-mail when someone replies to my topic" => "Send me an e-mail when someone replies to my topic",
// "Don't send me any e-mails" => "Don't send me any e-mails",
// "Moderator Actions" => "Moderator Actions",
// "Unlock Selected Topics" => "Unlock Selected Topics",
// "Delete Selected Topics" => "Delete Selected Topics",
// "Merge" => "Merge",
// "Merge Selected Topics" => "Merge Selected Topics",
// "Reported Messages" => "Reported Messages",
// "Queued Messages" => "Queued Messages",
// "Merge into topic" => "Merge into topic",
// "Emot" => "Emot",
// "pts" => "pts",
// "Announce" => "Announce",
// "Hot" => "Hot",
// "Forum Lock" => "Forum Lock",
// "Unarchive" => "Unarchive",
// "No topics yet" => "No topics yet",
// "Filter Posts" => "Filter Posts",
// "Jump to forum" => "Jump to forum",
// "Posts Filtering" => "Posts Filtering",
// "Last post date" => "Last post date",
// "Last hour" => "Last hour",
// "Last 24 hours" => "Last 24 hours",
// "Last 48 hours" => "Last 48 hours",
// "Show archived posts" => "Show archived posts",
// "Containing posts by" => "Containing posts by",
// "Me" => "Me",
// "Posts with no replies" => "Posts with no replies",
// "Archived" => "Archived",
// "Topic List" => "Topic List",
// "The post has been reported and will be reviewed by a moderator" => "The post has been reported and will be reviewed by a moderator",
// "prev topic" => "prev topic",
// "next topic" => "next topic",
// "Print this page only" => "Print this page only",
// "Print all pages" => "Print all pages",
// "Monitor" => "Monitor",
// "Stop Monitor" => "Stop Monitor",
// "Insert New Item" => "Insert New Item",
// "Edit Fields" => "Edit Fields",
// "Tracker Items" => "Tracker Items",
// "Pending" => "Pending",
// "View inserted item" => "View inserted item",
// "Insert new item" => "Insert new item",
// "Tracker Item" => "Tracker Item",
// "View Item" => "View Item",
// "Filter Tracker Items" => "Filter Tracker Items",
// "Items list" => "Items list",
// "Special Operations" => "Special Operations",
// "Add a new" => "Add a new",
// "Edit this" => "Edit this",
// " mail account" => " mail account",
// "Incoming servers (used in this order)" => "Incoming servers (used in this order)",
// "IMAP server" => "IMAP server",
// "Mbox filepath" => "Mbox filepath",
// "Maildir mail directory" => "Maildir mail directory",
// "Use SSL" => "Use SSL",
// "Outgoing server" => "Outgoing server",
// "Account details" => "Account details",
// "Group (shared mail inbox) or private" => "Group (shared mail inbox) or private",
// "This will be a group mail account" => "This will be a group mail account",
// "This will be a personal mail account" => "This will be a personal mail account",
// "Auto-refresh page time" => "Auto-refresh page time",
// "You do not have the correct permissions to Add or Edit a webmail account. <BR />Please contact your administrator and ask for \"admin_personal_webmail\" or \"admin_group_webmail\" permission" => "You do not have the correct permissions to Add or Edit a webmail account. <BR />Please contact your administrator and ask for \"admin_personal_webmail\" or \"admin_group_webmail\" permission",
// "Personal e-mail accounts" => "Personal e-mail accounts",
// "This is the active account" => "This is the active account",
// "IMAP" => "IMAP",
// "Mbox" => "Mbox",
// "Maildir" => "Maildir",
// "POP3" => "POP3",
// "Group e-mail accounts" => "Group e-mail accounts",
// "Show Unread" => "Show Unread",
// "Show Flagged" => "Show Flagged",
// "Auto refresh set for every \$autoRefresh seconds" => "Auto refresh set for every \$autoRefresh seconds",
// "Refresh now" => "Refresh now",
// "Group messages" => "Group messages",
// "unFlagged" => "unFlagged",
// "Clip" => "Clip",
// "Back To Mailbox" => "Back To Mailbox",
// "Full Headers" => "Full Headers",
// "Normal Headers" => "Normal Headers",
// "Forward" => "Forward",
// "Part" => "Part",
// "Select from address book" => "Select from address book",
// "Use HTML mail" => "Use HTML mail",
// "The following addresses are not in your address book" => "The following addresses are not in your address book",
// "Add Contacts" => "Add Contacts",
// "Attachment 1" => "Attachment 1",
// "Attachment 2" => "Attachment 2",
// "Attachment 3" => "Attachment 3",
// "Address book" => "Address book",
// "View edit icons" => "View edit icons",
// "Group Monitor on Structure" => "Group Monitor on Structure",
// "Latitude" => "Latitude",
// "Longitude" => "Longitude",
// "Word Limit Exceeded" => "Word Limit Exceeded",
// "Character Limit Exceeded" => "Character Limit Exceeded",
// "Character Count" => "Character Count",
// "Word Count" => "Word Count",
// "Format: x,y,zoom where x is the longitude, and y is the latitude. Zoom is between 0(view Earth) and 19. You can use <a href=\"tiki-gmap_locator.php?for=item&amp;itemId={\$item.itemId}&amp;trackerId={\$item.trackerId}&amp;fieldId={\$field_value.fieldId}\">{tr}Google Map Locator" => "Format: x,y,zoom where x is the longitude, and y is the latitude. Zoom is between 0(view Earth) and 19. You can use <a href=\"tiki-gmap_locator.php?for=item&amp;itemId={\$item.itemId}&amp;trackerId={\$item.trackerId}&amp;fieldId={\$field_value.fieldId}\">{tr}Google Map Locator",
// "Number of votes" => "Number of votes",
// "Your rating" => "Your rating",
// "You did not vote yet" => "You did not vote yet",
// "My rating" => "My rating",
// "Click to vote for this value" => "Click to vote for this value",
// "Clik to delete your vote" => "Clik to delete your vote",
// "You have ever subscribed" => "You have ever subscribed",
// "You have not yet subscribed" => "You have not yet subscribed",
// "friends" => "friends",
// "Unsubscribe" => "Unsubscribe",
// "Google Maps is not enabled" => "Google Maps is not enabled",
// "The main text of this page is available in the following languages" => "The main text of this page is available in the following languages",
// "Use this thread to discuss the page" => "Use this thread to discuss the page",
// "Missing or incorrect trackerId parameter for the plugin" => "Missing or incorrect trackerId parameter for the plugin",
// "list" => "list",
// "Email address the person you want to invite" => "Email address the person you want to invite",
// "Set in these groups" => "Set in these groups",
// "Leave" => "Leave",
// "Undecided" => "Undecided",
// "Last Day" => "Last Day",
// "Last Week" => "Last Week",
// "Last Month" => "Last Month",
// "Last Year" => "Last Year",
// "Your default group" => "Your default group",
// "Change default group" => "Change default group",
// "Subscribe to a group" => "Subscribe to a group",
// "Toggle display" => "Toggle display",
// "Creator &amp; Last Editor" => "Creator &amp; Last Editor",
// "as Creator &amp; Last Editor" => "as Creator &amp; Last Editor",
// "no (disabled)" => "no (disabled)",
// "Save the page as a partial translation" => "Save the page as a partial translation",
// "Partial Translation" => "Partial Translation",
// "Save the page as a completed translation" => "Save the page as a completed translation",
// "Complete Translation" => "Complete Translation",
// "Save Minor Edit" => "Save Minor Edit",
// "Permission denied you cannot view the Tiki calendar" => "Permission denied you cannot view the Tiki calendar",
// "%0 enabled" => "%0 enabled",
// "%0 disabled" => "%0 disabled",
// "%0 set" => "%0 set",
// "%0 unset" => "%0 unset",
// "Administration" => "Administration",
// "Help on Configuration Sections" => "Help on Configuration Sections",
// "Current version is up to date : <b>%0</b>" => "Current version is up to date : <b>%0</b>",
// "A new major release branch is available" => "A new major release branch is available",
// "A new %0 major release branch is available" => "A new %0 major release branch is available",
// "Enable/disable Tiki features here, but configure them elsewhere" => "Enable/disable Tiki features here, but configure them elsewhere",
// "General preferences and settings" => "General preferences and settings",
// "User registration, login and authentication" => "User registration, login and authentication",
// "Article/CMS settings" => "Article/CMS settings",
// "Poll comments settings" => "Poll comments settings",
// "Configuration options for all blogs on your site" => "Configuration options for all blogs on your site",
// "Forums settings" => "Forums settings",
// "FAQ comments settings" => "FAQ comments settings",
// "Trackers settings" => "Trackers settings",
// "Feeds settings" => "Feeds settings",
// "Directory settings" => "Directory settings",
// "Maps configuration" => "Maps configuration",
// "Meta Tags settings" => "Meta Tags settings",
// "Search settings" => "Search settings",
// "Score settings" => "Score settings",
// "Community settings" => "Community settings",
// "Calendar settings" => "Calendar settings",
// "Intertiki settings" => "Intertiki settings",
// "Customize look and feel of your Tiki" => "Customize look and feel of your Tiki",
// "Text area" => "Text area",
// "Configure Site Ads and Banners" => "Configure Site Ads and Banners",
// "Kaltura settings" => "Kaltura settings",
// "Help on \$admintitle Config" => "Help on \$admintitle Config",
// "Must specify actionId" => "Must specify actionId",
// "Users Contributions: Addition" => "Users Contributions: Addition",
// "%s Contributions: Addition" => "%s Contributions: Addition",
// "Users Contributions: Suppression" => "Users Contributions: Suppression",
// "%s Contributions: Suppression" => "%s Contributions: Suppression",
// "Total Contributions Addition per Day" => "Total Contributions Addition per Day",
// "Total Contributions Addition per Week" => "Total Contributions Addition per Week",
// "Total Contributions Suppression per Day" => "Total Contributions Suppression per Day",
// "Total Contributions Suppression per Week" => "Total Contributions Suppression per Week",
// "Total Contributions: Addition" => "Total Contributions: Addition",
// "Total Contributions: Suppression" => "Total Contributions: Suppression",
// "Groups Contributions: Addition" => "Groups Contributions: Addition",
// "Groups Contributions: Suppression" => "Groups Contributions: Suppression",
// "white" => "white",
// "gray" => "gray",
// "silver" => "silver",
// "ivory" => "ivory",
// "whitesmoke" => "whitesmoke",
// "beige" => "beige",
// "darkgrey" => "darkgrey",
// "Object doesn't exists" => "Object doesn't exists",
// "You can not create a category with a name already existing at this level" => "You can not create a category with a name already existing at this level",
// "The file does not have the required header" => "The file does not have the required header",
// "Category can`t be parent of itself" => "Category can`t be parent of itself",
// "No display" => "No display",
// "Score (desc)" => "Score (desc)",
// "Replies (desc)" => "Replies (desc)",
// "Reads (desc)" => "Reads (desc)",
// "You have to provide a hotword and a URL" => "You have to provide a hotword and a URL",
// "You must specify a directory" => "You must specify a directory",
// "Owner" => "Owner",
// "moved %d images, %d errors occured" => "moved %d images, %d errors occured",
// "a timeout occured. Hit the reload button to move the rest" => "a timeout occured. Hit the reload button to move the rest",
// "Test Image" => "Test Image",
// "Your admin password has been changed" => "Your admin password has been changed",
// "You cannot have a blank password" => "You cannot have a blank password",
// "All Fields except gdaltindex must be filled" => "All Fields except gdaltindex must be filled",
// "Path to mapfiles is invalid" => "Path to mapfiles is invalid",
// "No valid gdaltindex executable" => "No valid gdaltindex executable",
// "You cannot mix old and new trackers" => "You cannot mix old and new trackers",
// "Tag already exists" => "Tag already exists",
// "Tag not found" => "Tag not found",
// "Repository name can't be an empty" => "Repository name can't be an empty",
// "Requested action is not supported on repository" => "Requested action is not supported on repository",
// "No repository" => "No repository",
// "Search is mandatory field" => "Search is mandatory field",
// "File not found " => "File not found ",
// "Requested action in not supported on repository" => "Requested action in not supported on repository",
// "Non-existent link" => "Non-existent link",
// "Mail-in account %s incorrect" => "Mail-in account %s incorrect",
// "Mail-in account %s saved" => "Mail-in account %s saved",
// "Frequency should be a positive integer" => "Frequency should be a positive integer",
// "Mail-in accounts set to be checked every %s minutes" => "Mail-in accounts set to be checked every %s minutes",
// "Automatic Mail-in accounts checking disabled" => "Automatic Mail-in accounts checking disabled",
// "No menu indicated" => "No menu indicated",
// "Unassign module" => "Unassign module",
// "Cannot create or update module: You need to specify a name to the module" => "Cannot create or update module: You need to specify a name to the module",
// "Cannot create or update module: You cannot leave the data field empty" => "Cannot create or update module: You cannot leave the data field empty",
// "No newsletter indicated" => "No newsletter indicated",
// "PHP error" => "PHP error",
// "The list name must be specified" => "The list name must be specified",
// "Sorry, your list could not be added. Please check that it doesn\\'t already exist" => "Sorry, your list could not be added. Please check that it doesn\\'t already exist",
// "Sorry, your list could not be updated. Please check that it already exists" => "Sorry, your list could not be updated. Please check that it already exists",
// "No poll indicated" => "No poll indicated",
// "register_globals should be off by default. See the php manual for details" => "register_globals should be off by default. See the php manual for details",
// "risky" => "risky",
// "off" => "off",
// "session.use_trans_sid should be off by default. See the php manual for details" => "session.use_trans_sid should be off by default. See the php manual for details",
// "upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser" => "upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser",
// "cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config" => "cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config",
// "setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them" => "setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them",
// "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off" => "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off",
// "The Path to store files in the filegallery should be outside the tiki root directory" => "The Path to store files in the filegallery should be outside the tiki root directory",
// "The Path to store files in the imagegallery should be outside the tiki root directory" => "The Path to store files in the imagegallery should be outside the tiki root directory",
// "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code" => "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code",
// "The \"Snarf Wikiplugin\" is activated. It can be used by wiki editors to include pages from the local network and via regex replacement create any html" => "The \"Snarf Wikiplugin\" is activated. It can be used by wiki editors to include pages from the local network and via regex replacement create any html",
// "The \"Regex Wikiplugin\" is activated. It can be used by wiki editors to create any html via regex replacement" => "The \"Regex Wikiplugin\" is activated. It can be used by wiki editors to create any html via regex replacement",
// "The \"Lsdir Wikiplugin\" is activated. It can be used by wiki editors to view the contents of any directory" => "The \"Lsdir Wikiplugin\" is activated. It can be used by wiki editors to view the contents of any directory",
// "The \"Bloglist Wikiplugin\" is activated. It can be used by wiki editors to disclose private blog posts" => "The \"Bloglist Wikiplugin\" is activated. It can be used by wiki editors to disclose private blog posts",
// "The \"iframe Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks" => "The \"iframe Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks",
// "The \"js Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc" => "The \"js Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc",
// "The \"JQ Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc" => "The \"JQ Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc",
// "The \"Redirect Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks" => "The \"Redirect Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks",
// "The \"Module Wikiplugin\" is activated. It can be used by wiki editors to add modules which permit to access information (see module list)" => "The \"Module Wikiplugin\" is activated. It can be used by wiki editors to add modules which permit to access information (see module list)",
// "The \"Userlist Wikiplugin\" is activated. It can be used by wiki editors to display the list of users" => "The \"Userlist Wikiplugin\" is activated. It can be used by wiki editors to display the list of users",
// "The \"Usercount Wikiplugin\" is activated. It can be used by wiki editors to display a count of the number of users" => "The \"Usercount Wikiplugin\" is activated. It can be used by wiki editors to display a count of the number of users",
// "The \"SQL Wikiplugin\" is activated. It can be used by wiki editors to execute SQL commands" => "The \"SQL Wikiplugin\" is activated. It can be used by wiki editors to execute SQL commands",
// "Path disclosure" => "Path disclosure",
// "Path disclosure through error message" => "Path disclosure through error message",
// "SQL injection" => "SQL injection",
// "SQL injection by authenticated user" => "SQL injection by authenticated user",
// "SQL injection by authenticated user with special privileges" => "SQL injection by authenticated user with special privileges",
// "SQL injection without authentication" => "SQL injection without authentication",
// "PHP command injection" => "PHP command injection",
// "PHP command injection by authenticated user" => "PHP command injection by authenticated user",
// "PHP command injection by authenticated user with special privileges" => "PHP command injection by authenticated user with special privileges",
// "PHP command injection without authentication" => "PHP command injection without authentication",
// "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous" => "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous",
// "This is a modified File. Cannot check version. Check if it is dangerous" => "This is a modified File. Cannot check version. Check if it is dangerous",
// "No survey indicated" => "No survey indicated",
// "You don't have permission to use this feature" => "You don't have permission to use this feature",
// "Are you sure you want to delete this custom tool" => "Are you sure you want to delete this custom tool",
// "JavaScript is required for this page" => "JavaScript is required for this page",
// "Are you sure you want to remove this topic" => "Are you sure you want to remove this topic",
// "Are you sure you want to remove this topic AND all the articles related" => "Are you sure you want to remove this topic AND all the articles related",
// "No tracker indicated" => "No tracker indicated",
// "Tracker does not allow attachments" => "Tracker does not allow attachments",
// "Group name can not be empty" => "Group name can not be empty",
// "The description is mandatory as it is used as mail subject" => "The description is mandatory as it is used as mail subject",
// "No records were found. Check the file please" => "No records were found. Check the file please",
// "User does not exist on master" => "User does not exist on master",
// "Created account %s <%s>" => "Created account %s <%s>",
// "Assigned %s in group %s" => "Assigned %s in group %s",
// "Email validation requested but email address not set" => "Email validation requested but email address not set",
// "Password not set" => "Password not set",
// "User %s already exists" => "User %s already exists",
// "User login contains invalid characters" => "User login contains invalid characters",
// "New %s created with %s %s" => "New %s created with %s %s",
// "Impossible to create new %s with %s %s" => "Impossible to create new %s with %s %s",
// "%s %s successfully deleted" => "%s %s successfully deleted",
// "Deleted account %s" => "Deleted account %s",
// "%s %s removed from %s %s" => "%s %s removed from %s %s",
// "%s %s assigned to %s %s" => "%s %s assigned to %s %s",
// "group %s set as the default group of user %s" => "group %s set as the default group of user %s",
// "Login contains invalid characters" => "Login contains invalid characters",
// "%s changed from %s to %s" => "%s changed from %s to %s",
// "Impossible to change %s from %s to %s" => "Impossible to change %s from %s to %s",
// "%s modified successfully" => "%s modified successfully",
// "password" => "password",
// "%s modification failed" => "%s modification failed",
// "approved by " => "approved by ",
// "This function is only for staging pages" => "This function is only for staging pages",
// "Permission denied you cannot approve staging pages" => "Permission denied you cannot approve staging pages",
// "Approved page was last saved after most recent staging edit" => "Approved page was last saved after most recent staging edit",
// "rss feed disabled" => "rss feed disabled",
// "Tiki RSS feed for articles" => "Tiki RSS feed for articles",
// "Unassign perm %s from group %s" => "Unassign perm %s from group %s",
// "Unknown group" => "Unknown group",
// "Group doesn't exist" => "Group doesn't exist",
// "You have to indicate a group" => "You have to indicate a group",
// "This group is invalid" => "This group is invalid",
// "Permission denied you cannot view backlinks for this page" => "Permission denied you cannot view backlinks for this page",
// "The page cannot be found" => "The page cannot be found",
// "Image Galleries Admin Panel" => "Image Galleries Admin Panel",
// "Could not read image %s" => "Could not read image %s",
// "Image %s upload failed" => "Image %s upload failed",
// "Image %s uploaded successfully" => "Image %s uploaded successfully",
// "Image %s removed from Batch directory" => "Image %s removed from Batch directory",
// "Impossible to remove image %s from Batch directory" => "Impossible to remove image %s from Batch directory",
// "Permission denied you cannot use the batch directory loading" => "Permission denied you cannot use the batch directory loading",
// "Incorrect directory chosen for batch upload of images" => "Incorrect directory chosen for batch upload of images",
// "Please setup that dir on " => "Please setup that dir on ",
// "Please contact the website administrator" => "Please contact the website administrator",
// "Invalid directory name" => "Invalid directory name",
// "File Galleries Admin Panel" => "File Galleries Admin Panel",
// "Could not read file %s" => "Could not read file %s",
// "Could not write to file %s" => "Could not write to file %s",
// "File %s upload failed" => "File %s upload failed",
// "File %s removed from Batch directory" => "File %s removed from Batch directory",
// "Impossible to remove file %s from Batch directory" => "Impossible to remove file %s from Batch directory",
// "Incorrect directory chosen for batch upload of files" => "Incorrect directory chosen for batch upload of files",
// "It isn't possible to post in any blog. You may need to create a blog first" => "It isn't possible to post in any blog. You may need to create a blog first",
// "Permission denied you cannot post" => "Permission denied you cannot post",
// "Permission denied you cannot edit this post" => "Permission denied you cannot edit this post",
// "No blogId specified" => "No blogId specified",
// "Tiki RSS feed for weblogs" => "Tiki RSS feed for weblogs",
// "Last posts to weblogs" => "Last posts to weblogs",
// "TOP" => "TOP",
// "You must clear your browser cache" => "You must clear your browser cache",
// "Permission denied you cannot access this gallery" => "Permission denied you cannot access this gallery",
// "No gallery indicated" => "No gallery indicated",
// "Permission denied you can not view this section" => "Permission denied you can not view this section",
// "Permission denied you cannot remove images from this gallery" => "Permission denied you cannot remove images from this gallery",
// "Permission denied you cannot rebuild thumbnails in this gallery" => "Permission denied you cannot rebuild thumbnails in this gallery",
// "Permission denied you cannot rotate images in this gallery" => "Permission denied you cannot rotate images in this gallery",
// "No image indicated" => "No image indicated",
// "Permission denied you cannot move images from this gallery" => "Permission denied you cannot move images from this gallery",
// "Permission denied you cannot view the calendar" => "Permission denied you cannot view the calendar",
// "You need to <a href=\"tiki-admin_calendars.php\">create a calendar</a>" => "You need to <a href=\"tiki-admin_calendars.php\">create a calendar</a>",
// "Calendar event : " => "Calendar event : ",
// "event without name" => "event without name",
// "Permission denied you can not view this page" => "Permission denied you can not view this page",
// "%H:%M %Z" => "%H:%M %Z",
// "Mo" => "Mo",
// "Tu" => "Tu",
// "We" => "We",
// "Th" => "Th",
// "Fr" => "Fr",
// "Sa" => "Sa",
// "Su" => "Su",
// "Tiki RSS feed for calendars" => "Tiki RSS feed for calendars",
// "Invalid request. Expecting channels array" => "Invalid request. Expecting channels array",
// "Missing channel name" => "Missing channel name",
// "Authentication required" => "Authentication required",
// "One of the requested channels cannot be requested. It does not exist or permission is denied" => "One of the requested channels cannot be requested. It does not exist or permission is denied",
// "One of the install profiles could not be obtained" => "One of the install profiles could not be obtained",
// "This feature is disabled'.\$prefs['validateUsers']));\n\t\$smarty->display('error.tpl" => "This feature is disabled'.\$prefs['validateUsers']));\n\t\$smarty->display('error.tpl",
// "Problem. Try to log in again to receive new confirmation instructions" => "Problem. Try to log in again to receive new confirmation instructions",
// "ERROR: you must include a subject or a message. You must also make sure to have a valid e-mail in the FROM field" => "ERROR: you must include a subject or a message. You must also make sure to have a valid e-mail in the FROM field",
// "You need to change chmod 'whelp' manually to 777" => "You need to change chmod 'whelp' manually to 777",
// "Tiki RSS feed for directory sites" => "Tiki RSS feed for directory sites",
// "URL already added to the directory. Duplicate site? " => "URL already added to the directory. Duplicate site? ",
// "URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. " => "URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. ",
// "Must select a category. " => "Must select a category. ",
// "Must enter a name to add a site" => "Must enter a name to add a site",
// "Must enter a url to add a site" => "Must enter a url to add a site",
// "URL already added to the directory. Duplicate site" => "URL already added to the directory. Duplicate site",
// "URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory" => "URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory",
// "Must select a category" => "Must select a category",
// "No site indicated" => "No site indicated",
// "No parent specified" => "No parent specified",
// "Last sites of directory \" . \$rc[\"name\"] . \" " => "Last sites of directory \" . \$rc[\"name\"] . \" ",
// "You cannot download this file right now. Your score is low or file limit was reached" => "You cannot download this file right now. Your score is low or file limit was reached",
// "Error : The file %s doesn't exist" => "Error : The file %s doesn't exist",
// "The language can't be changed as its set of translations has already this language" => "The language can't be changed as its set of translations has already this language",
// "You do not have permissions to edit banners" => "You do not have permissions to edit banners",
// "Banner not found" => "Banner not found",
// "You do not have permission to edit this banner" => "You do not have permission to edit this banner",
// "Permission denied you cannot create or edit blogs" => "Permission denied you cannot create or edit blogs",
// "Permission denied you cannot edit this blog" => "Permission denied you cannot edit this blog",
// "You do not have permission to write the style sheet" => "You do not have permission to write the style sheet",
// "Invalid request to edit an image" => "Invalid request to edit an image",
// "Permission denied you cannot edit images" => "Permission denied you cannot edit images",
// "Permission denied you can edit images but not in this gallery" => "Permission denied you can edit images but not in this gallery",
// "Failed to edit the image" => "Failed to edit the image",
// "Permission denied to use this feature" => "Permission denied to use this feature",
// "Shortname must be 2 Characters" => "Shortname must be 2 Characters",
// "You must provide a longname" => "You must provide a longname",
// "Language created" => "Language created",
// "No content id indicated" => "No content id indicated",
// "No question indicated" => "No question indicated",
// "No quiz indicated" => "No quiz indicated",
// "No structure indicated" => "No structure indicated",
// "Invalid structure_id or page_ref_id" => "Invalid structure_id or page_ref_id",
// "Permission denied you cannot send submissions" => "Permission denied you cannot send submissions",
// "Permission denied you cannot edit submissions" => "Permission denied you cannot edit submissions",
// "You have to create a topic first" => "You have to create a topic first",
// "You do not have permission to do that" => "You do not have permission to do that",
// "You do not have permission to write the template" => "You do not have permission to write the template",
// "You do not have permission to read the template" => "You do not have permission to read the template",
// "No topic id specified" => "No topic id specified",
// "Invalid topic id specified" => "Invalid topic id specified",
// "No object indicated" => "No object indicated",
// "Page is a staging copy. Translation must begin from the approved copy" => "Page is a staging copy. Translation must begin from the approved copy",
// "Translation of this page is incomplete" => "Translation of this page is incomplete",
// "No type indicated" => "No type indicated",
// "Not enable for this type of object" => "Not enable for this type of object",
// "Override lock and carry on with edit" => "Override lock and carry on with edit",
// "Page is currently being edited" => "Page is currently being edited",
// "page imported" => "page imported",
// "created from import" => "created from import",
// "This page is being edited by " => "This page is being edited by ",
// "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. " => "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. ",
// "Can't import remote HTML page" => "Can't import remote HTML page",
// "The file you selected is too large to upload" => "The file you selected is too large to upload",
// "Incorrect file extension was used for your 0gg screencast, expecting .ogg" => "Incorrect file extension was used for your 0gg screencast, expecting .ogg",
// "The translation set already contains a page in this language" => "The translation set already contains a page in this language",
// "No questions group indicated" => "No questions group indicated",
// "Form error - no import method selected for some reason" => "Form error - no import method selected for some reason",
// "Form error - no server-side filename entered for selected import method" => "Form error - no server-side filename entered for selected import method",
// "No forum indicated" => "No forum indicated",
// "Last replied forum topics" => "Last replied forum topics",
// "No forumId specified" => "No forumId specified",
// "Tiki RSS feed for forum: " => "Tiki RSS feed for forum: ",
// "Tiki RSS feed for forums" => "Tiki RSS feed for forums",
// "Last topics in forums" => "Last topics in forums",
// "Not supported yet" => "Not supported yet",
// "Accepted friendship request from %s" => "Accepted friendship request from %s",
// "Refused friendship request from %s" => "Refused friendship request from %s",
// "Canceled friendship request with %s" => "Canceled friendship request with %s",
// "Broke friendship with %s" => "Broke friendship with %s",
// "I have broken our friendship" => "I have broken our friendship",
// "You must be logged in to use this feature" => "You must be logged in to use this feature",
// "Friendship request sent to %s" => "Friendship request sent to %s",
// "You're already friend of %s" => "You're already friend of %s",
// "I have accepted your friendship request" => "I have accepted your friendship request",
// "I have refused your friendship request" => "I have refused your friendship request",
// "I have canceled my friendship request" => "I have canceled my friendship request",
// "Permission denied you cannot create galleries and so you cant edit them" => "Permission denied you cannot create galleries and so you cant edit them",
// "Permission denied you cannot edit this gallery" => "Permission denied you cannot edit this gallery",
// "Permission denied you cannot remove this gallery" => "Permission denied you cannot remove this gallery",
// "Permission denied you cannot make the map of this gallery" => "Permission denied you cannot make the map of this gallery",
// "Back to preferences" => "Back to preferences",
// "Back to item" => "Back to item",
// "No valid renderer found. GD or PDFLib required" => "No valid renderer found. GD or PDFLib required",
// "No sheet specified" => "No sheet specified",
// "You must select a renderer" => "You must select a renderer",
// "Invalid Series for current graphic" => "Invalid Series for current graphic",
// "Tiki RSS feed for image galleries" => "Tiki RSS feed for image galleries",
// "Last images uploaded to the image galleries" => "Last images uploaded to the image galleries",
// "Tiki RSS feed for the image gallery: " => "Tiki RSS feed for the image gallery: ",
// "Only the administrator can upload language files" => "Only the administrator can upload language files",
// "overwriting old page" => "overwriting old page",
// "updated from structured text import" => "updated from structured text import",
// "page created" => "page created",
// "created from structured text import" => "created from structured text import",
// "Operations executed successfully" => "Operations executed successfully",
// "Invalid software name" => "Invalid software name",
// "No name indicated for wiki page" => "No name indicated for wiki page",
// "Page saved (version %d)" => "Page saved (version %d)",
// "You have requested that this page be machine translated" => "You have requested that this page be machine translated",
// "However, the Machine Translation feature is not enabled. Please enable this feature, or ask a site admin to do it" => "However, the Machine Translation feature is not enabled. Please enable this feature, or ask a site admin to do it",
// "No repository given" => "No repository given",
// "Error writing in the databse: \$query" => "Error writing in the databse: \$query",
// "Permission denied: You cannot upload videos" => "Permission denied: You cannot upload videos",
// "You need to set your Kaltura account details: " => "You need to set your Kaltura account details: ",
// "Could not establish Kaltura session. Try again" => "Could not establish Kaltura session. Try again",
// "Permission denied: You cannot remix videos" => "Permission denied: You cannot remix videos",
// "Permission denied: You cannot change video version" => "Permission denied: You cannot change video version",
// "Permission denied: You cannot delete kaltura video" => "Permission denied: You cannot delete kaltura video",
// "Permission denied: You cannot download kaltura video" => "Permission denied: You cannot download kaltura video",
// "Permission denied: You cannot edit video information" => "Permission denied: You cannot edit video information",
// "Permission denied: You cannot view video" => "Permission denied: You cannot view video",
// "Permission denied. You cannot view pages like this page" => "Permission denied. You cannot view pages like this page",
// "Permission denied you cannot remove articles" => "Permission denied you cannot remove articles",
// "Permission denied you cannot remove banners" => "Permission denied you cannot remove banners",
// "Permission denied you cannot remove this blog" => "Permission denied you cannot remove this blog",
// "Delete comments" => "Delete comments",
// "Approved Status" => "Approved Status",
// "Queued" => "Queued",
// "Non-existent gallery" => "Non-existent gallery",
// "The file is already locked by %s" => "The file is already locked by %s",
// "Quota too big" => "Quota too big",
// "Quota too small" => "Quota too small",
// "Warning: Empty file" => "Warning: Empty file",
// "Please re-upload your file" => "Please re-upload your file",
// "Could not upload the file" => "Could not upload the file",
// "Could not find the file requested" => "Could not find the file requested",
// "Permission denied you can edit this file" => "Permission denied you can edit this file",
// "Permission denied: You cannot view this page" => "Permission denied: You cannot view this page",
// "Invalid action" => "Invalid action",
// "You cannot admin blogs" => "You cannot admin blogs",
// "Permission denied you cannot remove submissions" => "Permission denied you cannot remove submissions",
// "Permission denied you cannot approve submissions" => "Permission denied you cannot approve submissions",
// "You have to enable cookies to be able to login to this site" => "You have to enable cookies to be able to login to this site",
// "Unable to contact remote server" => "Unable to contact remote server",
// "XMLRPC Error: " => "XMLRPC Error: ",
// "More than %d unsuccessful login attempts have been made" => "More than %d unsuccessful login attempts have been made",
// "An email has been sent to you with the instructions to follow" => "An email has been sent to you with the instructions to follow",
// "Resend" => "Resend",
// "You should have received an email. Check your mailbox and your spam box.Otherwise click on the button to resend the email" => "You should have received an email. Check your mailbox and your spam box.Otherwise click on the button to resend the email",
// "Your default nickname is already in use. A new one has to be selected" => "Your default nickname is already in use. A new one has to be selected",
// "The selected account is not associated with your identity" => "The selected account is not associated with your identity",
// "Authentication method is not OpenID" => "Authentication method is not OpenID",
// "You must use the right case for your user name" => "You must use the right case for your user name",
// "Sorry, you can't use this feature" => "Sorry, you can't use this feature",
// "Feature Ajax Disabled. Please ask your site administrator to enable" => "Feature Ajax Disabled. Please ask your site administrator to enable",
// "You must first setup MapServer" => "You must first setup MapServer",
// "invalid mapfile name" => "invalid mapfile name",
// "An error as occured with the mapfile" => "An error as occured with the mapfile",
// "Please create a directory named ' . \$prefs['map_path'] . ' to hold your map files" => "Please create a directory named ' . \$prefs['map_path'] . ' to hold your map files",
// "You do not have permissions to view the maps" => "You do not have permissions to view the maps",
// "Maps feature is not correctly setup : Maps path is missing" => "Maps feature is not correctly setup : Maps path is missing",
// "mapfile name incorrect" => "mapfile name incorrect",
// "This mapfile already exists" => "This mapfile already exists",
// "You do not have permission to write to the mapfile" => "You do not have permission to write to the mapfile",
// "You do not have permission to delete the mapfile" => "You do not have permission to delete the mapfile",
// "I could not make a copy" => "I could not make a copy",
// "You do not have permission to read the mapfile" => "You do not have permission to read the mapfile",
// "map edit" => "map edit",
// "You dont have permission to do that" => "You dont have permission to do that",
// "Tiki RSS feed for maps" => "Tiki RSS feed for maps",
// "List of maps available" => "List of maps available",
// "You do not have permissions to view the layers" => "You do not have permissions to view the layers",
// "You do not have permissions to delete a file" => "You do not have permissions to delete a file",
// "You do not have permissions to create a directory" => "You do not have permissions to create a directory",
// "The Directory is not empty" => "The Directory is not empty",
// "You do not have permissions to delete a directory" => "You do not have permissions to delete a directory",
// "You do not have permissions to create an index file" => "You do not have permissions to create an index file",
// "Invalid file name" => "Invalid file name",
// "Invalid files to index" => "Invalid files to index",
// "I do not know where is gdaltindex. Set correctly the Map feature" => "I do not know where is gdaltindex. Set correctly the Map feature",
// "I could not create the index file" => "I could not create the index file",
// "No page provided" => "No page provided",
// "Page \"%0\" does not exist" => "Page \"%0\" does not exist",
// "Must be logged to use this feature" => "Must be logged to use this feature",
// "Welcome at Hawiki" => "Welcome at Hawiki",
// "This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more" => "This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more",
// "You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site" => "You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site",
// "tiki-mobile.php" => "tiki-mobile.php",
// "About" => "About",
// "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody" => "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody",
// "Your PHP installation does not have zlib enabled" => "Your PHP installation does not have zlib enabled",
// "You must log in to use this feature" => "You must log in to use this feature",
// "You do not have permission to view other users data" => "You do not have permission to view other users data",
// "You must be logged in to subscribe to newsletters" => "You must be logged in to subscribe to newsletters",
// "No note indicated" => "No note indicated",
// "merged note" => "merged note",
// "File is too big" => "File is too big",
// "No item indicated" => "No item indicated",
// "Are you sure you want to delete this note" => "Are you sure you want to delete this note",
// "created from notepad" => "created from notepad",
// "Note not found" => "Note not found",
// "Page already exists" => "Page already exists",
// "Not enough information to display this page" => "Not enough information to display this page",
// "Permission denied you cannot assign permissions for this object" => "Permission denied you cannot assign permissions for this object",
// "Permission denied you cannot browse this page history" => "Permission denied you cannot browse this page history",
// "Permission denied you cannot view the source of this page" => "Permission denied you cannot view the source of this page",
// "No post indicated" => "No post indicated",
// "Missing object list type argument" => "Missing object list type argument",
// "Index" => "Index",
// "Index (' . \$code . " => "Index (' . \$code . ",
// "No pages indicated" => "No pages indicated",
// "Pageviews" => "Pageviews",
// "No result indicated" => "No result indicated",
// "You are already logged in" => "You are already logged in",
// "Missing User Name" => "Missing User Name",
// "User Already Exists" => "User Already Exists",
// "Valid User Name" => "Valid User Name",
// "Missing Email" => "Missing Email",
// "Valid Email" => "Valid Email",
// "A password reminder email has been sent " => "A password reminder email has been sent ",
// "to the email" => "to the email",
// "You cannot rename staging pages. Please rename the approved page instead" => "You cannot rename staging pages. Please rename the approved page instead",
// "Cannot rename page because the new name begins with reserved prefix" => "Cannot rename page because the new name begins with reserved prefix",
// "Cannot rename page because maybe new staging page name already exists" => "Cannot rename page because maybe new staging page name already exists",
// "Permission denied you cannot rollback this page" => "Permission denied you cannot rollback this page",
// "Tiki RSS Feed Error Message: \$errmsg" => "Tiki RSS Feed Error Message: \$errmsg",
// "A problem occured during file uploading" => "A problem occured during file uploading",
// "File which was causing trouble was at rank" => "File which was causing trouble was at rank",
// "The error was" => "The error was",
// "invalid email" => "invalid email",
// "successfully sent" => "successfully sent",
// "not sent" => "not sent",
// "Notice: invalid variable value" => "Notice: invalid variable value",
// "Permission denied you cannot remove this sheet" => "Permission denied you cannot remove this sheet",
// "You do not have permission to edit messages \$owner" => "You do not have permission to edit messages \$owner",
// "Page must be defined inside a structure to use this feature" => "Page must be defined inside a structure to use this feature",
// "Clean the sql logs" => "Clean the sql logs",
// "You cannot take this quiz twice" => "You cannot take this quiz twice",
// "Quiz time limit exceeded quiz cannot be computed" => "Quiz time limit exceeded quiz cannot be computed",
// "You cannot take this survey twice" => "You cannot take this survey twice",
// "Report to the webmaster" => "Report to the webmaster",
// "Please create a category first" => "Please create a category first",
// "No trackerId specified" => "No trackerId specified",
// "Tiki RSS feed for individual trackers: " => "Tiki RSS feed for individual trackers: ",
// "You must lock the file before editing it" => "You must lock the file before editing it",
// "Batch file processed" => "Batch file processed",
// "No permission to upload zipped file packages" => "No permission to upload zipped file packages",
// "Incorrect file extension" => "Incorrect file extension",
// "Error processing zipped image package" => "Error processing zipped image package",
// "No permission to upload zipped image packages" => "No permission to upload zipped image packages",
// "The uploaded file ist not recognized as a image" => "The uploaded file ist not recognized as a image",
// "That is not an image (or you have php < 4.0.5)" => "That is not an image (or you have php < 4.0.5)",
// "Your screencast has been uploaded successfully" => "Your screencast has been uploaded successfully",
// "Your screencasts have been uploaded successfully" => "Your screencasts have been uploaded successfully",
// "No url indicated" => "No url indicated",
// "Invalid password. Your current password is required to change administrative information" => "Invalid password. Your current password is required to change administrative information",
// "was moved into trash" => "was moved into trash",
// "trashed by" => "trashed by",
// "open / in process" => "open / in process",
// "Rights by creator" => "Rights by creator",
// "END" => "END",
// "Percentage" => "Percentage",
// "Task accepted by creator" => "Task accepted by creator",
// "Task accepted by task user" => "Task accepted by task user",
// "Task NOT accepted by creator" => "Task NOT accepted by creator",
// "Task NOT accepted by task user" => "Task NOT accepted by task user",
// "Sorry this task does not exist or you have no rights to view this task" => "Sorry this task does not exist or you have no rights to view this task",
// "Task entries" => "Task entries",
// "Info message" => "Info message",
// "NEW Task" => "NEW Task",
// "Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks" => "Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks",
// "Changes on Task" => "Changes on Task",
// "You received a new task" => "You received a new task",
// "The priority is" => "The priority is",
// "very low" => "very low",
// "low" => "low",
// "high" => "high",
// "very high" => "very high",
// "You've to start your work at least on" => "You've to start your work at least on",
// "You've to finish your work on" => "You've to finish your work on",
// "Please read the task and work on it" => "Please read the task and work on it",
// "Sorry, there was an error while trying to write data into the database" => "Sorry, there was an error while trying to write data into the database",
// "A new page is created in a language" => "A new page is created in a language",
// "Language watch" => "Language watch",
// "Cannot upload this file not enough quota" => "Cannot upload this file not enough quota",
// "No user indicated" => "No user indicated",
// "No banner indicated" => "No banner indicated",
// "No blog indicated" => "No blog indicated",
// "Permission denied you cannot remove the post" => "Permission denied you cannot remove the post",
// "Permission denied: you cannot view this blog post while it is marked private" => "Permission denied: you cannot view this blog post while it is marked private",
// "No cache information available" => "No cache information available",
// "You must suggest a question; please try again" => "You must suggest a question; please try again",
// "No faq indicated" => "No faq indicated",
// "You are not permitted to remove someone else\\'s post" => "You are not permitted to remove someone else\\'s post",
// "Incorrect thread" => "Incorrect thread",
// "No thread indicated" => "No thread indicated",
// "A SheetId is required" => "A SheetId is required",
// "That tracker don't use extras" => "That tracker don't use extras",
// "There are a problem connecting to that account" => "There are a problem connecting to that account",
// "There are a problem deleting that mail" => "There are a problem deleting that mail",
// "Mail ID" => "Mail ID",
// "There are a problem deleting mails" => "There are a problem deleting mails",
// "Are you sure you want to delete this account" => "Are you sure you want to delete this account",
// "Taking" => "Taking",
// "Putting back" => "Putting back",
// "Checking" => "Checking",
// "Aborted" => "Aborted",
// "Plugin modified by editor" => "Plugin modified by editor",
// "Tidy Extension not present" => "Tidy Extension not present",
// "The TikiTests Replay File is Empty" => "The TikiTests Replay File is Empty",
// "The TikiTests Replay File has an error" => "The TikiTests Replay File has an error",
// "You are about to delete a TikiTest file, do you want to continue " => "You are about to delete a TikiTest file, do you want to continue ",
// "You need one of the extension pecl HTTP or Curl to replay the TikiTest" => "You need one of the extension pecl HTTP or Curl to replay the TikiTest",
// ### end of untranslated words
// ###

// ###
// ### start of possibly untranslated words
// ###

"Re:" => "Re:",
"ID" => "ID",
"Wiki" => "Wiki",
"blog" => "blog",
"forum" => "forum",
"Blog" => "Blog",
"1" => "1",
"2" => "2",
"3" => "3",
"4" => "4",
"5" => "5",
"Featured links" => "Featured links",
"Google Maps" => "Google Maps",
"Intertiki" => "Intertiki",
"Integrator" => "Integrator",
"Mb" => "Mb",
"Threaded" => "Threaded",
"no cache" => "no cache",
"Forum" => "Forum",
"km" => "km",
"wiki" => "wiki",
"img-g" => "img-g",
"file-g" => "file-g",
"arts" => "arts",
"textarea" => "textarea",
"category" => "category",
"user preference" => "user preference",
"(AT)" => "(AT)",
"(DOT)" => "(DOT)",
"characters long" => "characters long",
"HTML code" => "HTML code",
"URL" => "URL",
"Image ID" => "Image ID",
"Stop" => "Stop",
"Filter" => "Filter",
"%" => "%",
"Status" => "Status",
"Subscribe" => "Subscribe",
"Id" => "Id",
"Original" => "Original",
"to" => "to",
"Reset" => "Reset",
"Test" => "Test",
"^Parameters: key=>value,...\n" => "^Parameters: key=>value,...\n",
"id" => "id",
"Show Tree" => "Show Tree",
"New message arrived from %s" => "New message arrived from %s",
"The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
"Ip" => "Ip",
"Diff" => "Diff",
"Read message" => "Read message",
"To configure your Tiki" => "To configure your Tiki",
"Admin" => "Admin",
"Standard" => "Standard",
"Cache" => "Cache",
"online user" => "online user",
"on host" => "on host",
"[-]" => "[-]",
"Permalink" => "Permalink",
"URI" => "URI",
"i18n" => "i18n",
"InterTiki" => "InterTiki",
"Semester" => "Semester",
"URL:" => "URL:",
"Banning" => "Banning",
"DSN" => "DSN",
"h" => "h",
"Red" => "Red",
"ExtWiki" => "ExtWiki",
"Topic list configuration" => "Topic list configuration",
"Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address" => "Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address",
"mn" => "mn",
"List image galleries" => "List image galleries",
"dynamic collapsed" => "dynamic collapsed",
"dynamic extended" => "dynamic extended",
"fixed" => "fixed",
"r" => "r",
"w" => "w",
"PDF" => "PDF",
"Dump Tree" => "Dump Tree",
"Wiki RSS" => "Wiki RSS",
"TikiWiki CMS/Groupware" => "TikiWiki CMS/Groupware",
"RSS" => "RSS",
"Hit" => "Hit",
"+" => "+",
"April" => "April",
"September" => "September",
"November" => "November",
"December" => "December",
"Nickname" => "Nickname",
"Sites" => "Sites",
"Use HTML" => "Use HTML",
"Use image" => "Use image",
"Image:" => "Image:",
"Current Image" => "Current Image",
"DB Prefix" => "DB Prefix",
"Creation Date" => "Creation Date",
"XY-Size" => "XY-Size",
"Gallery Image" => "Gallery Image",
"Img" => "Img",
"Backl." => "Backl.",
"tikiwiki.org" => "tikiwiki.org",
"pvs" => "pvs",
"You can download this file using" => "You can download this file using",
"top" => "top",
"Default view" => "Default view",
"Status:" => "Status:",
"This page is being edited by" => "This page is being edited by",
"Cached" => "Cached",
"Top topics" => "Top topics",
"unicode" => "unicode",
// ###
// ### end of possibly untranslated words
// ###

"This feature is disabled" => "Ta možnost ni omogočena",
"Permission denied. You cannot view pages" => "Nimate dovoljenja za ogled strani",
"For you to vote, cookies must be allowed" => "Dovoliti moraš piškotke za omogočanje volitev",
"This forum is flat and doesn't allow replies to other replies" => "ta forum je plosek in ne omogoča odgovarjanje na komentarje",
"You do not have permission to use this feature" => "Nimaš dovoljenja uporabljati to značilnost",
"Type" => "Tip",
"Name" => "Ime",
"Description" => "Opis",
"Size" => "Velikost",
"Created" => "Ustvaril",
"Uploaded" => "Naložil",
"Last Modified" => "Zadnji spremenil",
"Creator" => "Ustvaril",
"Author" => "Avtor",
"Last editor" => "Zadnji urednik",
"Comment" => "Komentar",
"Files" => "Datoteke",
"Hits" => "Zadetki",
"Locked by" => "Zaklenil",
"Explorer" => "Raziskovalec",
"Path" => "Pot",
"Permission denied" => "Nimate dovoljenja",
"Template %s not registered" => "Predloga %s ni registrirana",
"The file is not a CSV file or has not a correct syntax" => "Datoteka ni CSV datoteka ali ima napačno sintakso",
"Error line: %d" => "Napaka v liniji: %d",
"locked" => "zaklenjeno",
"locked by" => "Zaklenil",
"Administration:" => "Administracija:",
"in" => "v",
"continued" => "se nadaljuje",
"New Image Uploaded by" => "Novo sliko je naložil",
"New Subscriptions" => "Nove naročnine",
"New Item in Tracker" => "Nova postavka v sledilniku",
"tracker" => "sledilnik",
"by" => "",
"Image Gallery" => "Galerija slik",
"Articles" => "Članki",
"Blogs" => "Blogi",
"Forums" => "Forumi",
"Directory" => "Imenik",
"File Gallery" => "Galerija datotek",
"FAQs" => "Vprašanja in odgovoriF",
"Quizzes" => "Kvizi",
"Trackers" => "Sledilniki",
"Survey" => "Spletna anketa",
"Newsletter" => "Bilten",
"article" => "članek",
"directory" => "direktorij",
"faq" => "vino",
"file gallery" => "galerija datotek",
"image gallery" => "galerija slik",
"newsletter" => "bilten",
"poll" => "anketa",
"quiz" => "kviz",
"survey" => "spletna anketa",
"wiki page" => "wiki stran",
"image" => "slika",
"calendar" => "koledar",
"Cannot upload this file - maximum upload size exceeded" => "Ne moreš naložiti te datoteke, ker presega maksimalno velikost",
"Cannot write to this file:" => "Ne morete pisati v to datoteko:",
"(not registered)" => "(ni registriran)",
"Anonymous" => "Anonomni",
"You have mistyped the anti-bot verification code; please try again." => "Napačno si vtipkal anti-bot verifikacijsko kodo. Prosim, poskusi znova.",
"Wrong password. Cannot post comment" => "Napačno geslo. Ne morete komentirati.",
"A contribution is mandatory" => "Prispevanje je obvezno",
"Line:" => "Vrstica:",
"Lines:" => "Vrstice:",
"Tiki Link - Insert internal link" => "Tiki povezava - vstavi notranjo povezavo",
"Select a Wiki page to link to:" => "Izberi Wiki stran za povezavo na:",
"Find" => "Poišči",
"find" => "poišči",
"prev" => "prej",
"Page" => "Stran",
"next" => "naslednji",
"Link" => "Povezava",
"Page name" => "Ime strani",
"Cannot open this file:" => "Ne morem odpreti te datoteke:",
"File Galleries" => "Galerije datotek",
"Wiki Home" => "Wiki dom",
"Home" => "Domov",
"previous page" => "prejšnja stran",
"next page" => "naslednja stran",
"posted on" => "objavljeno v",
"Continue" => "Nadaljuj",
"By:" => "Od:",
"Read" => "Preberi",
"List articles" => "Seznam člankov",
"Last post" => "Zadnja objava",
"Invalid imagename (using filters for filenames)" => "Nepravilno ime slike(uporaba filtrov za imena datotek)",
"Errors detected" => "Najdene napake",
"Upload was not successful" => "Nalaganje ni uspelo",
"No image yet, sorry." => "Še ni slike, oprostite.",
"Contributions" => "Prispevki",
"Query point:" => "Točka poizvedbe:",
"layer:" => "raven:",
"Record:" => "Zapis:",
"unknown" => "neznan",
"User Map Generated in:" => "Zemljevid uporabnikov je bil narejen v:",
"Image Map Generated in:" => "Zemljevid slik je bil narejen v:",
"menu" => "meni",
"NONE" => "Nobeden",
"File %s not found" => "Datoteke % ne najdem",
"Language" => "Jezik",
"Section" => "Sekcija",
"Rows" => "Vrstice",
"This poll is closed." => "Ta spletna anketa je zaprta.",
"Title" => "Naslov",
"Title length" => "Dolžina naslova",
"Topic" => "tema",
"Visible" => "Vidna",
"Reads" => "Branja",
"Images" => "Slike",
"Newest first" => "Najnovejši najprej",
"Oldest first" => "Najstarejši najprej",
"Creation date (desc)" => "Datum ustvarjanja (pad)",
"Last modification date (desc)" => "Datum zadnje spremebe (pad)",
"Disabled" => "Onemogočen",
"Plain text" => "Navadno besedilo",
"Faqs" => "Vprašanja in odgovori (Faqs)",
"Polls" => "Spletne ankete",
"Newsletters" => "Bilteni",
"Calendar" => "Koledar",
"Category" => "Kategorija",
"Score" => "Rezultat",
"Search" => "Išči",
"Freetags" => "Značke",
"Contribution" => "Prispevanje",
"FAQ" => "Vprašanja in odgovori",
"Surveys" => "Spletne ankete",
"Copyright" => "Avtorske pravice",
"Shoutbox" => "Kričač (Shoutbox)",
"Maps" => "Zemljevidi",
"HTML pages" => "HTML strani",
"Webmail" => "Spletna pošta",
"Mail-in" => "Prispela pošta (Mail-in)",
"Wysiwyg editor" => "Urejevalnik WYSIWYG",
"Friendship Network" => "Mreža prijateljev",
"Stats" => "Statistika",
"Mini Calendar" => "Mini koledar",
"User Watches" => "Uporabnikova opazovanja",
"User Menu" => "Uporabniški meni",
"User Files" => "Uporabnikove datoteke",
"Multilingual structures" => "Večjezikovne strukture",
"Smileys" => "Smejkoti",
"Activate" => "Aktiviraj",
"Rankings" => "Najboljše",
"Content templates" => "Predloga vsebine",
"Print" => "Natisni",
"List pages" => "Seznam strani",
"Last changes" => "Zadnje spremembe",
"Orphan pages" => "Osirotele strani",
"Search stats" => "Iskalna statistika",
"Visits" => "Obiski",
"Object type" => "Tip objekta",
"Yes, even in the same gallery" => "Da, celo v isti galeriji",
"Only in different galleries" => "Samo v različnih galerijah",
"Plain" => "Navaden",
"Headers Only" => "Samo glave",
"Title (desc)" => "Naslov (pad)",
"Title (asc)" => "Naslovi (nar)",
"Topics" => "Teme",
"Posts" => "Prispevki",
"Topics (desc)" => "Teme (pad)",
"Open external links in new window" => "Odpri zunanje povezave v novem oknu",
"Content" => "Vsebina",
"Show categories" => "Pokaži kategorije",
"Normal" => "Normalen",
"Database" => "Podatkovna baza",
"Publish" => "Objavi",
"Always" => "Vedno",
"Maximum size for each attachment" => "Maksimalna velikost za vsako priponko",
"Unlimited" => "Neomejeno",
"Page last modified on" => "Stran zadnjič spremenjena",
"Top" => "Na vrh",
"Both" => "Oboje",
"minute" => "minuta",
"minutes" => "minute",
"hour" => "ura",
"hours" => "ure",
"Wysiwyg Editor is optional" => "WYSIWYG urejevalnik je opcija (optional)",
"Wiki top pages" => "Najbolj iskane wiki strani",
"Most relevant pages" => "Najbolj pomembne strani",
"Relevance" => "Pomembnost",
"Wiki last pages" => "Zadnje wiki strani",
"Modified" => "Spremenjeno",
"Forums last posts" => "Zadnji prispevki na forumu",
"Topic date" => "Datum teme",
"Forums most read topics" => "Najbolj brani prispevki na forumu",
"Forums best topics" => "Najboljše teme na forumu",
"Forums most visited forums" => "Najbolj brani forumi",
"Forums with most posts" => "Forumi z največ prispevki",
"Wiki top galleries" => "Najboljše wiki galerije",
"Wiki top file galleries" => "Najboljše wiki galerije datotek",
"Wiki top images" => "Najboljše wiki galerije slik",
"Wiki top files" => "Najboljše wiki datoteke",
"Downloads" => "Snemanje",
"Wiki last images" => "Zadnje wiki slike",
"Upload date" => "Datum nalaganja",
"Wiki last files" => "Zadnje wiki datoteke",
"Wiki top articles" => "Najboljši članki v wikiju",
"Most visited blogs" => "Najbolj obiskani blogi",
"Most active blogs" => "Najbolj aktivni blogi",
"Activity" => "Aktivnost",
"Blogs last posts" => "Zadnji prispevki v blogih",
"Post date" => "Datum pošiljanja",
"Wiki top authors" => "Najboljši wiki avtorji",
"Pages" => "Strani",
"Top article authors" => "Najboljši avtorji člankov",
"The passwords do not match" => "Gesli se ne ujemata",
"User already exists" => "Uporabnik že obstaja",
"Wrong registration code" => "Napačna registracijska koda",
"Invalid username" => "Neveljavno uporabniško ime",
"Username is too long" => "Uporabniško ime je predolgo",
"Username cannot contain whitespace" => "Uporabniško ime ne sme vsebovati presledka",
"Wrong passcode. You need to know the passcode to register at this site" => "Napačna koda. Poznati morate kodo, da lahko registrirate na to stran",
"Invalid email address. You must enter a valid email address" => "Napačen e-naslov. Vpišite pravilen e-naslov.",
"The registration mail can't be sent. Contact the administrator" => "Registracijska e-pošta ne more biti poslana. Povežite se z administratorjem.",
"Today" => "Danes",
"and" => "in",
"from" => "iz",
"Feed provided by %s. Click to visit." => "Vir je priskrbel %s. Klikni za obisk.",
"Login" => "Prijava",
"See other users' profiles" => "Poglej profil drugih uporabnikov",
"Have your profile seen" => "Omogoči vpogled v svoj profil",
"Make friends" => "Poišči prijatelje",
"Receive message" => "Dobi sporočilo",
"Send message" => "Poslano sporočilo",
"Read an article" => "Preberi članek",
"Publish an article" => "Objavi članek",
"Have your article read" => "Omogoči branje svojega članka",
"Create new file gallery" => "Ustvari nov galerijo datotek",
"Upload new file to gallery" => "Naloži novo datoteko v galerijo",
"Download other user's file" => "Naloži datoteko drugega uporabnika",
"Have your file downloaded" => "Omogoči nalaganje datoteke",
"Create a new image gallery" => "Ustvari novo galerijo slik",
"Upload new image to gallery" => "Naloži novo sliko v galerijo",
"See other users' galleries" => "Poglej galerijo drugih uporabnikov",
"See other users' images" => "Poglej slike drugih uporabnikov",
"Have your gallery seen by other users" => "Omogočite vpogled v tvojo galerijo drugim uporabnikom",
"Have your image seen" => "Omogoči vpogled v tvojo sliko",
"Create new blog" => "Ustvari nov blog",
"Post in a blog" => "Pošlji nov blog",
"Read other users' blogs" => "Preberite blog drugih uporabnikov",
"Have your blog read" => "Omogočite branje tvojega bloga",
"Create a new wiki page" => "Ustvari novo wiki stran",
"Edit an existing page" => "Uredite obstoječo stran",
"Attach file" => "Pripni datoteko",
"Gallery" => "Galerija",
"Image" => "Slika",
"Article" => "Članek",
"Blog post" => "Blogovski prispevek",
"Tracker item" => "Predmet sledilnika",
"Tracker" => "Sledilnik",
"Unknown" => "Neznan",
"Trackeritem" => "Ritem sledilnika",
"Directory category" => "Kategorija direktorija",
"Simple" => "Preprosto",
"Advanced" => "Napredno",
"Fast Next" => "Hitro naslednji",
"Fast Prev" => "Hitro prejšjni",
"Prev" => "Prej",
"Next" => "Nasl",
"First {\$params['itemname']}" => "Najprej {\$params['itemname']}",
"Last {\$params['itemname']}" => "Zadnji {\$params['itemname']}",
"Next {\$params['itemname']}" => "Naslednji {\$params['itemname']}",
"Prev {\$params['itemname']}" => "Prejšnji {\$params['itemname']}",
"Click Here" => "Klikni tukaj",
"Your edit session will expire in" => "Urejanje bo poteklo v ",
"Help page:" => "Stran pomoč:",
"View tpl:" => "Poglej predlogo:",
"Edit Template" => "Uredi predlogo",
"Admin Feature" => "Administriraj značilnost (Feature)",
"Hide" => "Skrij",
"help" => "pomoč",
"All" => "Vse",
"The text is" => "Tekst je",
"Date Selector" => "Izbira datuma",
"phplayers are not available on this site" => "phplayers niso na razpolago na tej strani",
"Select All" => "Izberi vse",
"Invert Sort" => "Zamenjaj razvrščanje",
"days" => "dni",
"day" => "dan",
"mins" => "minute",
"min" => "minuta",
"secs" => "sekunde",
"sec" => "sekunda",
"done" => "narejeno",
"Task" => "Opravilo",
"for" => "za",
"Priority" => "Prioriteta",
"Start date:" => "Datum začetka:",
"End date:" => "Datum konca:",
"Friend" => "Prijatelj",
"(idle for %s seconds)" => "(nedejavno %s sekund)",
"User information - Click for more info" => "Informacije o uporabniku - klikni za več informacij",
"More info about \$other_user" => "Več informacij o \$other_user",
"(idle for \$idletime seconds)" => "(nedejavno \$idletime sekund)",
"No" => "Ne",
"Use this tree to copy the structure" => "Uporabi to drevo za kopiranje strukture",
"created from structure" => "ustvarjeno iz strukture",
"Table of contents" => "Tabela vsebin",
"text" => "tekst",
"unknown error" => "neznana napaka",
"You are not logged in" => "Nisi prijavljen",
"Page cannot be found" => "Ne najdem strani",
"Help" => "Pomoč",
"You are banned from" => "Prepovedano ti je",
"faqs" => "Vprašanja in odgovori",
"quizzes" => "kvizi",
"blogs" => "blogi",
"forums" => "forumi",
"Click to edit dynamic variable" => "Klikni za urejanje dinamične variable",
"Update variables" => "Posodobi variable",
"Edit Section" => "Uredi sekcijo",
"index" => "indeks",
"Show" => "Pokaži",
"The file you are trying upload was only partially uploaded." => "Datoteka, ki jo želite naložiti, je bila samo delno naložena.",
"%d points" => "%d točk",
"Removed" => "Odstranjeno",
"at" => "pri",
"new" => "novo",
"Create page:" => "Ustvari stran:",
"Unknown language" => "Neznan jezik",
"Click here to confirm your action" => "Klikni tu za potrditev",
"Heading" => "Naslov",
"Reduce area height" => "Zmanjšaj površino v višino",
"Enlarge area height" => "Povečaj površino v višino",
"Wiki Help" => "Wiki pomoč",
"Upload was not successful. Duplicate file content ?" => "Nalaganje ni bilo uspešno. Podvajanje vsebine datoteke?",
"Item Modification" => "Modifikacija postavke",
"Item" => "Postavka",
"Item creation" => "Izvedba postavke",
"Subject" => "Predmet",
"Tracker was modified at " => "Sledilnik je bil spremenjen ob ",
"Field is not numeric" => "Polje ni numerično",
"Field is not a link to mp3 in the gallery" => "Polje ni povezava na mp3 v galeriji",
"Field is not a link to FLV in the gallery" => "Polje ni povezava na FLV v galeriji",
"Field is not a link to FLV or MP3 in the gallery" => "Polje ni povezava na mp3 ali FLV v galeriji",
"text field" => "tekstvono polje",
"half column" => "polkolona",
"size" => "velikost",
"max" => "maks",
"checkbox" => "potrditveno polje",
"numeric field" => "numerično polje",
"drop down" => "spustni",
"user selector" => "izbirnik uporabnikov",
"group selector" => "izbirnik skupin",
"country selector" => "izbirnik držav",
"date and time" => "datum in čas",
"action" => "akcija",
"header" => "glava",
"static text" => "statični tekst",
"email" => "e-pošta",
"multimedia" => "večpredstavnost",
"user subscription" => "naročnina uporabnika",
"system" => "sistem",
"computed field" => "izračunano polje",
"attachment" => "priponka",
"open" => "odpri",
"pending" => "nerešen",
"closed" => "zaprt",
"Message" => "Sporočilo",
"No extra information for that attached file. " => "Ni posebnih informacij za pripeto datoteko. ",
"child categories" => "otroška kategorija",
"objects in category" => "objekti v kategoriji",
"The administrator has not yet validated your account. Please wait." => "Administrator še ni potrdil vašega računa. Prosimo počakajte.",
"You must validate your account first. An email has been sent to you" => "Najprej morate potrditi vaš račun. Poslali smo vam e-pošto.",
"Password should be at least" => "Geslo mora biti dolgo vsaj ",
"Password must contain both letters and numbers" => "Geslo mora vsebovati oboje: črke in številke.",
"The registration mail can't be sent because there is no server email address set, and this feature is disabled" => "Registracijske e-pošte nismo poslali, ker ni nastavljen e-naslov strežnika in ta značilnost je onemogočena.",
"The user email confirmation can't be sent. Contact the administrator" => "Potrditev e-pošte uporabnika ne moremo poslati. Pokličite administratorja.",
"Personal Phone" => "Osebni telefon",
"Personal Mobile" => "Osebni mobilni telefon",
"Personal Fax" => "Osebni faks",
"Work Phone" => "Službeni telefon",
"Work Mobile" => "Službeni mobilni telefon",
"Work Fax" => "Službeni faks",
"Company" => "Podjetje",
"Organization" => "Organizacija",
"Department" => "Oddelek",
"Division" => "Enota",
"Job Title" => "Naziv na delovnem mestu",
"Street Address" => "Ulica",
"City" => "Mesto",
"State" => "Država",
"Zip Code" => "Poštna številka",
"Country" => "Država",
"No subject" => "Ni zadeve",
"Displays browser client info" => "Prikaže informacije brskalniških odjemalcev",
"linktext" => "tekst povezave",
"Location" => "Lokacija",
"Save changes to annotations" => "Shrani spremembe v notacijo",
"Creates an annotation block for an image." => "Ustvari notacijski blok za sliko.",
"Field" => "polje",
"Includes an article" => "Vključi članek",
"Attachment" => "Priponka",
"File" => "Datoteka",
"Show description" => "Pokaži opis",
"Same as name" => "Enako kot ime",
"Shows a file icon" => "pokaži ikono datotek",
"Avatar" => "Avatarji",
"Displays the user Avatar" => "Prikaže uporabnikovega Avatarja",
"username" => "uporabniško ime",
"Back" => "Nazaj",
"Backlinks" => "Povezava nazaj",
"No pages links to" => "Nobena stran se ne povezuje na",
"One page links to" => "Ena stran se povezuje na",
"pages link to" => "strani se povezujejo na",
"Use BLOGLIST to include posts from a blog. Syntax is" => "Uporabi BLOGLIST za vključitev prispevkov z bloga. Sintaksa je",
"Categories are disabled" => "Kategorije niso omogočene",
"Chart" => "Graf",
"title" => "naslov",
"Chart as PDF" => "Graf kot PDF",
"code" => "koda",
"Cookie" => "Piškotek",
"Example" => "Primer",
"seconds" => "sekunde",
"Right" => "Desno",
"Left" => "Levo",
"Clear" => "Počisti",
"Events" => "Dogodki",
"Desc" => "Pad",
"Label" => "Nalepka",
"missing parameters" => "manjkajoči parametri",
"Incorrect param" => "Nepravi param",
"Missing parameter" => "Manjkajoči parameter",
"Group" => "Skupina",
"Image size" => "Velikost slike",
"Thumbnail" => "Miniaturna sličica (Thumbnail)",
"Browse" => "Brskaj",
"Download" => "Naloži",
"Start" => "Začetek",
"Last Modification" => "Zadnja sprememba",
"List Pages" => "Seznam strani",
"List wiki pages." => "Seznam viki strani.",
"Sort" => "Sortiraj",
"or" => "ali",
"complete" => "kompletno",
"Lists files in a directory" => "Seznami datotek v direktoriju",
"could not be opened because it doesn't exist or permission was denied" => "se ne da odpreti, ker ne obstoji ali nimate dovoljenja",
"Template" => "Predloga",
"Style" => "Stil",
"Groups" => "Skupine",
"Module Name" => "Ime modula",
"data" => "podatek",
"Object" => "Objekt",
"Days" => "Dnevi",
"picture not found" => "nisem našel slike",
"Information" => "Informacije",
"Poll" => "Anketa",
"Preferences" => "Izbirne nastavitve",
"User Information" => "Uporabnikove informacije",
"one data per line" => "en podatek v vrsto",
"Icon" => "Ikona",
"Close" => "Zapri",
"Date" => "Datum",
"List wiki pages" => "Naredi seznam wiki strani",
"Display" => "Prikaži",
"Last modified by" => "Zadnji spremenil",
"Clickable Skype link" => "Klikabilna Skype povezava",
"Action" => "Akcija",
"Order" => "Vrstni red",
"First" => "Prvi",
"Edit" => "Uredi",
"Structure ID" => "ID strukture",
"Translate" => "Prevedi",
"Email" => "E-naslov",
"Preview" => "Predogled",
"View" => "Pogled",
"Error" => "Napaka",
"Example:" => "Primer:",
"Wiki text" => "Wiki besedilo",
"More" => "Več",
"Delete" => "Izbriši",
"Flag" => "Označi (Flag)",
"User List" => "Seznam uporabnikov",
"Displays a list of registered users" => "Prikaže seznam registriranih uporabnikov",
"Real Name" => "Pravo ime",
"users" => "uporabniki",
"Versions" => "Verzije",
"Vote" => "Glasuj",
"Table" => "Tabela",
"Level" => "Nivo",
"ignored" => "ignorirano",
"External Wiki" => "Zunanji wiki",
"valid" => "veljaven",
"Wanted Page" => "Željena stran",
"width" => "širina",
"height" => "višina",
"rollback version " => "povrnjena verzija",
"Page locked" => "Zaklenjena stran",
"Page unlocked" => "Nezaklenjena stran",
"Removed last version" => "Odstranjena zadnja verzija",
"Invalid user" => "Neveljaven uporabnik",
"Categories" => "Kategorije",
"Categorize" => "Kategoriziraj",
"Unassign" => "Od-dodeli (Unassign)",
"Assign" => "Določi",
"Categorize %s in %s" => "Kategoriziraj %s v %s",
"Received objects" => "Prejeti objekti",
"File galleries" => "Galerije datotek",
"Last forum posts" => "Zadnji prispevki v forumu",
"Topics only" => "Samo teme",
"Most commented forums" => "Najbolj komentirani forumi",
"Most read topics" => "Najbolj brane teme",
"Most visited forums" => "Najbolj obiskani forumi",
"Most popular tags" => "Najbolj priljubljene značke",
"My preferred tags" => "Moje prednostne značke",
"Google Search" => "Google iskanje",
"Last actions" => "Zadnje akcije",
"Default:" => "Privzeto:",
"Last blog posts" => "Zadnji prispevki na blogu",
"Last Created blogs" => "Zadnji ustvarjeni blogi",
"Last Created FAQs" => "Zadnja ustvarjena vprašanja in odgovori (FAQs)",
"Last Created Quizzes" => "Zadnji ustvarjeni kvizi",
"Last Files" => "Zadnje datoteke",
"Last Images" => "Zadnje slike",
"Last Items" => "Zadnje postavke",
"Last Visitors" => "Zadnji obiskovalci",
"Live support" => "Živa podpora",
"Messages" => "Sporočila",
"Old articles" => "Stari članki",
"Create/Edit" => "Ustvari/Uredi",
"Quick Edit a Wiki Page" => "Hitro urejanje wiki strani",
"New user registration" => "Registracija novega uporabnika",
"Post" => "Objavi",
"Since your last visit" => "Od zadnjega obiska",
"Changes since" => "Spremembe od",
"new comments" => "Novi komentarji",
"new posts" => "Novi prispevki",
"wiki pages changed" => "Spremenjene wiki strani",
"new articles" => "Novi članki",
"new FAQs" => "Nova vprašanja in odgovori",
"new blogs" => "Novi blogi",
"new blog posts" => "Novi blogovski prispevki",
"new image galleries" => "Nove galerije slik",
"new images" => "Nove slike",
"new file galleries" => "Nove galerije datotek",
"new files" => "Nove datoteke",
"new polls" => "Nove spletne ankete",
"new users" => "Novi uporabniki",
"new tracker items" => "Nove postavke sledilnika",
"Most Active blogs" => "najbolj aktivni blogi",
"Top File Galleries" => "Najboljše galerije datotek",
"My blogs" => "Moji blogi",
"User bookmarks" => "Zaznamki uporabnikov",
"My galleries" => "Moje galerije",
"User Pages" => "Uporabnikove strani",
"My Pages" => "Moje strani",
"User tasks" => "Uporabnikova opravila",
"Public tasks" => "Javne naloge",
"Top users" => "Najbolj aktivni uporabniki",
"Last wiki comments" => "zadnji wiki komentarji",
"Invalid username or password" => "Neveljavno uporabniško ime ali geslo",
"theme" => "teme",
"Anti-Bot verification code" => "Anti-Bot verifikacijska koda",
"Random Image" => "Naključna slika",
"Enter the code you see above" => "Vnesi kodo, ki jo vidiš zgoraj",
"List of attached files" => "Seznam pripetih datotek",
"desc" => "padajoče",
"uploaded" => "naloženo",
"Remove" => "Odstrani",
"Upload file" => "Naloži datoteko",
"Attach" => "Pripni",
"Attach a file to this item" => "Pripni datoteko tej postavki",
"Version" => "Verzija",
"Attachments" => "Priponka",
"more info" => "vač informacij",
"No attachments for this item" => "Ni priponk za to postavko",
"debug" => "popravi napako",
"Fatal error" => "Usodna napaka",
"Created by" => "Ustvaril",
"on" => "na",
"Activity=" => "Aktivnost=",
"Actions" => "Akcije",
"Properties" => "Lastnosti",
"No records found" => "Ni najdenih zapisov",
"Admin Categories" => "Administriraj kategorije",
"No categories defined" => "Ni definiranih kategorij",
"Browse Category" => "Prebrskaj kategorijo",
"posts:" => "zapisi:",
"stars" => "zvezde",
"User Level" => "Uporabniška stopnjaUser Level",
"private message" => "privatno sporočilo",
"Send eMail to User" => "Pošlji e-pošto uporabniku",
"user online" => "uporabnik priključen",
"user offline" => "uporabnik ni priključen",
"top of page" => "na vrh strani",
"Reply" => "Odgovori",
"Report this post" => "Poročaj o tem zapisu",
"Save to notepad" => "Shrani na ave to beležnico",
"Monitor this Topic" => "Opazuj to temo",
"Stop Monitoring this Topic" => "Prenehaj opazovati to temo",
"Watched by categories" => "Opazovano po kategorijah",
"Errors" => "Napake",
"Moderator actions" => "Akcije moderatorja",
"reported:" => "poročano:",
"queued:" => "v vrsti:",
"Move to topic:" => "Prestavi v temo:",
"Move" => "Prestavi",
"Delete Selected" => "Izbriši izbrano",
"Unlock" => "Odkleni",
"Lock" => "Zakleni",
"Threshold" => "Prag",
"Set" => "Nastavi",
"Replies" => "Odgovori",
"below your current threshold" => "pod vašim trenutnim pragom",
"Note" => "Opomba",
"New Reply" => "Nov odgovor",
"Editing reply" => "Urejanje odgovora",
"Reply to the selected post" => "Odgovori na izbrani prispevek",
"Post new message" => "napiši novo sporočilo",
"Editing comment" => "Urejanje komentarja",
"Comment on the selected post" => "Komentiraj izbrani prispevek",
"Post new comment" => "Prispevaj nov komentar",
"required" => "zahtevano",
"Toolbars" => "Hitre značke",
"Enter your name" => "Vpiši svoje ime",
"Reply to parent post" => "Odgovori na starševski prispevek",
"Post new reply" => "napiši nov odgovor",
"Post as Anonymous" => "Piši anonimno",
"Cancel" => "Prekliči",
"Posting replies" => "Pisanje odgovorov",
"Posting comments" => "Pisanje komentarjev",
"Add Comment" => "Dodaj komentar",
"1 comment" => "1 komentar",
"Go back" => "Pojdi nazaj",
"Return to home page" => "Nazaj na domačo stran",
"Type of contribution:" => "Tip prispevanja:",
"Contributors" => "Tisti, ki prispevajo",
"Copyrights" => "Avtorska pravica",
"Year" => "Leto",
"Authors" => "Avtorji",
"Add" => "Dodaj",
"Syntax" => "Sintaksa",
"Total" => "Skupaj",
"Watchlist" => "Seznam opazovanj",
"Duplicate File Gallery" => "Dupliciraj galerijo datotek",
"Duplicate categories" => "Dupliciraj kategorijo",
"duplicate" => "Dupliciraj",
"Save" => "Shrani",
"View inserted gallery" => "Poglej vstavljeno galerijo",
"System" => "Sistem",
"Maximum number of archives for each file" => "Maksimalno število arhivov za vsako datoteko",
"Use" => "Uporabi",
"unlimited" => "neomejeno",
"none" => "nobena",
"Parent gallery" => "Starševska galerija",
"Owner of the gallery" => "Lastnik galerije",
"Max:" => "Maks:",
"Display Properties" => "Prikaži lastnosti",
"Default sort order" => "Privzet vrstni red",
"Max description display size" => "Maksimalna velikost prikaza za opis",
"There are no wiki pages similar to '{\$page}'" => "Ni wiki strani, ki bi bile podobne '{\$page}'",
"You are not logged in." => "Nisi prijavljen.",
"Go to Login Page" => "Pojdi na stran za prijavo",
"Create this page" => "Ustvari to stran",
"(page will be orphaned)" => "(stran bo osirotela stran)",
"Close Window" => "Zapri okno",
"Go to" => "Pojdi na",
"Private Gallery" => "Privatna galerija",
"Active Perms" => "Aktivna dovoljenja",
"Perms" => "Dovoljenja",
"Archives" => "Arhivi",
"Upload New Version" => "Naloži novo verzijo",
"Download and lock" => "Naloži in zakleni",
"Name-filename" => "Ime-ime datoteke",
"Filename only" => "Samo ime datoteke",
"Show as a column" => "Prikaži kot kolono",
"Show in popup box" => "Prikaži v oknu",
"Show an icon in a column" => "Prikaži ikono v koloni",
"Exact&nbsp;match" => "Natančno&nbsp;ujemanje",
"any type" => "katerikoli tip",
"all topic" => "vse teme",
"any language" => "katerikoli jezik",
"any category" => "katerakoli kategorija",
"Number of displayed rows" => "Število prikazanih vrstic",
"in:" => "v:",
"Go" => "Pojdi",
"Show php error messages" => "Pokaži sporočila php napak",
"Folksonomy Tags" => "Značke:",
"Tags" => "Značke:",
"Translate tags" => "Prevedi značke",
"Images Galleries" => "Galerije slik",
"Edit this page!" => "Uredi so stran!",
"RSS Wiki" => "RSS wiki",
"RSS Blogs" => "RSS blogi",
"RSS Articles" => "RSS članki",
"RSS Image Galleries" => "RSS galerije slik",
"RSS File Galleries" => "RSS galerije datotek",
"RSS Forums" => "RSS Forumov",
"RSS Maps" => "RSS zemljevidi",
"RSS Directories" => "RSS imeniki",
"RSS Calendars" => "RSS koledarji",
"Hide Tree" => "Skrij drevo",
"Perform action with checked:" => "Izvedi akcijo z izbranimi:",
"Move Selected Files" => "Prestavi izbrane datoteke",
"Are you sure you want to delete the selected files?" => "Ali ste prepričani, da želite zbrisati izbrane datoteke?",
"Assign Permissions" => "Pripiši dovoljenja",
"Move to" => "Prestavi v",
"Filename" => "Ime datoteke",
"Other Sorts" => "Druga razvrščanja (Sorts)",
"No Additionnal Sort" => "Ni dodatnega razvrščanja (Sort)",
"No information" => "Ni informacij",
"Hi {\$mail_user} has sent you this link:" => "Pozdravljeni {\$mail_user} vam je poslal to povezavo:",
"Blog post:" => "Blogovski prispevek:",
"at:" => "pri:",
"Somebody or you tried to subscribe this email address at our site:" => "Nekdo ali pa vi se želi naročiti ta e-naslov na to stran:",
"To the newsletter:" => "Na bilten:",
"Description:" => "Opis:",
"User:" => "Uporabnik:",
"Author:" => "Avtor:",
"A new message was posted to forum" => "Novo sporočilo je bilo poslano na ta forum",
"New topic:" => "Nova tema:",
"Topic:" => "Tema:",
"Page not found:" => "Stran ni najdena:",
"Hi," => "Pozdravljeni,",
"A new message was posted to you at {\$mail_machine}" => "Novo sporočilo vam je bilo poslano pri {\$mail_machine}",
"From" => "Od",
"Hi" => "Pozdravljeni",
"Your account registration request for {\$mail_site} was validated by the site admin and your account is active now." => "Vašo zahtevo za registracijo računa za {\$mail_site} je preveril administrator strani in vaš račun je sedaj aktiven.",
"To login with your username and password, please follow this link:" => "Za prijavo z uporabniškim imenom in geslom sledite tej povezavi:",
"Enjoy the site!" => "Uživajte na strani!",
"User Account Activated" => "Uporabniški račun je aktiviran.",
"User Registration Request" => "Zahteva Tiki uporabnika za registracijo",
"You're invited to join my network of friends!" => "Povabljeni ste, da se pridružite moji mreži prijateljev!",
"The user" => "Uporabnik",
"registered at your site" => "registriran na vaši strani",
"Bye bye!" => "Na svidenje!",
"This email address has been removed to the list of subscriptors of:" => "Ta e-naslov je bil odstranjen s seznama naročnikov:",
"Newsletter:" => "Bilten:",
"Welcome to our newsletter!" => "Dobrodošli v našem biltenu!",
"Email notification" => "Tiki e-poštno obvestilo",
"Title:" => "Naslov:",
"Please visit this link before login again:" => "Prosimo obiščite povezavo preden se ponovno prijavite:",
"Confirm your account at %s" => "Potrdite vaš račun na %s",
"If you want to be a registered user in this site you will have to use the following link to login for the first time:" => "Če želite biti registriran uporabnik na tej strani, morate uporabiti to povezavo, da bi se prvič prijavili.",
"You will receive an email with information to login for the first time into this site" => "Prejel boš e-pošto z informacijami za prvo prijavo na to stran",
"You'll receive email notification once your account is activated." => "Prejel boš e-poštno obvestilo ko bo račun aktiviran.",
"Please do not attempt to login until you receive the email notification." => "Prosim ne poskusi se prijaviti dokler ne dobiš obvestila po e-pošti.",
"View the article at:" => "Poglej si članek na:",
"If you don't want to receive these notifications follow this link:" => "Če ne želiš dobivati teh obvestil, sledi tej povezavi:",
"Old" => "Star",
"New" => "Nov",
"File Description" => "Opis datoteke",
"Added by" => "Dodal",
"A page has been added to your watched sub-structure:" => "Stran je bila dodana k vaši opazovani pod-strukturi:",
"A page has been removed from your watched sub-structure:" => "Stran je bila odstranjena iz vaše opazovane pod-strukture:",
"A page has been promoted out your watched sub-structure:" => "Stran je bila povišana iz vaše opazovane pod-strukture:",
"A page has been demoted to your watched structure:" => "Stran je bila ponižana v vašo opazovano pod-strukturo:",
"Structure modified" => "Struktura je bila spremenjena",
"A new file have been attached to page" => "Nova datoteka je bila pripeta k strani",
"File name" => "Ime datoteke",
"New attachment on %s, page" => "Nova priponka na %s, strani",
"Comment:" => "Komentar:",
"You can view the page by following this link:" => "Lahko si obledate to stran, če sledite to povezavo:",
"Wiki page %s was commented on by" => "Wiki stran %s je komentiral",
"an anonymous user" => "anonimni uporabnik",
"Wiki page renamed" => "Wiki stran je preimenovana",
"Old name" => "Staro ime",
"New name" => "Novo ime",
"Thank you for your registration. You may log in now." => "Hval aza registracijo. Sedaj se lahko prijavite.",
"Zoom out" => "Povečaj",
"Zoom in" => "Zmanjšaj",
"Last modification date" => "Datum zadnje spremembe",
"Overview" => "Pregled",
"Legend" => "Legenda",
"Layer Manager" => "Upravlalec ravni (Layer Manager)",
"Layer" => "Raven(Layer)",
"On" => "Na",
"Download Layer" => "naloži plast (Layer)",
"hits last 7 days" => "zadetki zadnjih 7 dni",
"Create" => "Ustvari",
"Reload" => "Ponovno naloži",
"History" => "Zgodovina",
"Zoom out x2" => "Povečaj x2",
"Zoom in x2" => "Zmanjšaj x2",
"of" => "",
"Compare" => "Primerjaj",
"Comparing version {\$old.version} with version {\$new.version}" => "Primerjanje verzije {\$old.version} z verzijo {\$new.version}",
"Version:" => "Verzije:",
"Current" => "Trenutna",
"Versions are identical" => "Verzije so enake",
"Legend:" => "Legenda:",
"v=view" => "v=pogled",
"c=compare" => "c=primerjaj",
"d=diff" => "d=razlika",
"Full side-by-side diff" => "Polna side-by-side razlika",
"Unified diff" => "Unificirana razlika",
"Side-by-side view" => "Side-by-side pogled",
"User" => "Uporabnik",
"Older Version" => "Starejša verzija",
"Directories" => "Direktoriji",
"back to" => "nazaj na",
"Upload From Disk:" => "Naloži z diska:",
"Upload Files" => "Nalaganje podatkovnih datotek",
"Message Archive" => "Sporočilo arhiva",
"messages" => "sporočilo",
"Archive is full!" => "Arhiv je poln!",
"Unread" => "Neprebrano",
"Flagged" => "Označeno",
"Unflagged" => "Neoznačeno",
"Containing" => "Vsebuje",
"Sender" => "Pošiljatelj",
"No messages to display" => "Ni sporočil za prikaz",
"OK" => "V redu",
"Please Confirm" => "Prosim potrdi",
"All users" => "Vsi uporabniki",
"Lowest" => "Nižji",
"Low" => "Nizek",
"High" => "Visok",
"Very High" => "Zelo visok",
"Send" => "Pošlji",
"Compose message" => "Sestavi sporočilo",
"ERROR" => "NAPAKA",
"Invalid" => "Neveljaven",
"No messages to download" => "Ni sporočil za naložiti",
"Mailbox is full! Delete or archive some messages if you want to receive more messages." => "Poštni predal je poln! Izbrišite ali arhivirajte nekatera sporočila, če želite prejeti več sporočil.",
"is reply to" => "je odgovor na",
"Find replied message" => "Poišči sporočila (odgovorjena)",
"Archive" => "Arhiv",
"Mark as read" => "Označi kot prebrano",
"Mark as unread" => "Označi kot neprebrano",
"Mark as flagged" => "Označi kot zaznamovano (flagged)",
"Mark as unflagged" => "Označi kot nezaznamovano (unflagged)",
"Mark" => "Označi",
"Mailbox" => "Poštni predal",
"Compose" => "Sestavi",
"Broadcast" => "Oddaj(Broadcast)",
"Sent" => "Poslano",
"Auto-archive age for read messages:" => "Avto-arhiv čas za prebrana sporočila:",
"Return to mailbox" => "Nazaj na poštni predal",
"replyall" => "odgovori vsem",
"Unflag" => "Odznači (unflag)",
"Flag this message" => "Označi (flag) to sporočilo",
"Return to archive" => "Nazaj na arhiv",
"Return to outbox" => "Nazaj na odpremni predal (outbox)",
"Sent Messages" => "Poslana sporočila",
"Replied" => "Odgovorjeno",
"Not replied" => "Ne odgovorjeno",
"move to archive" => "premakni v arhiv",
"receiver" => "prejemnik",
"Move module up" => "Prestavi modul gor",
"Up" => "Gor",
"Move module down" => "Prestavi modul dol",
"Down" => "Dol",
"Move module to opposite side" => "Prestavi modul na nasprotno stran",
"opp side" => "nasp. str.",
"Toggle module contents" => "Preklopi na vsebino modula",
"toggle" => "preklopi",
"More..." => "Več...",
"Thank you for installing Tikiwiki" => "Hvala za inštaliranje Tikiwikija",
"Select" => "iZBERI",
"Admin Home" => "Admin Domov",
"from the menu" => "iz menija",
"Modules" => "Moduli",
"Menus" => "Meniji",
"login" => "prijava",
"as admin" => "kot Admin",
"The Tikiwiki Community" => "Skupnost Tikiwiki",
"Add event" => "Dodaj dogodek",
"Apply" => "Apliciraj",
"Pages:" => "Strani:",
"Categories:" => "Kategorije:",
"Tags This Page Has" => "Značke na tej strani",
"Add tags" => "Dodaj značke",
"List everything tagged" => "Seznam vsega kar vsebuje značke",
"more" => "več",
"Register" => "Registriraj se",
"You" => "Vi",
"Logged in as" => "Prijavljen kot",
"Logout" => "Odjava",
"Switch User" => "Preklopi na",
"Switch" => "Preklopi",
"Switch user" => "Preklopi uporabnika (Switch user)",
"Login through CAS" => "Prijava preko CAS",
"Login as admin" => "Prijava kot admin",
"Login through Shibboleth" => "Prijava preko Shibboleth",
"Login as" => "Prijavi se kot",
"eMail" => "e-naslov",
"Password" => "Geslo",
"Remember me" => "Zapomni si me",
"week" => "teden",
"month" => "mesec",
"year" => "leto",
"Click here to register" => "Klikni tu za registracijo",
"Click here if you've forgotten your password" => "Klikni tu, če ste pozabili vaše geslo",
"I forgot my password" => "Pozabil sem geslo",
"Click here to login using the default security protocol" => "Klikni tu za prijavo z uporabo privzetega varnostnega protokola",
"Click here to login using a secure protocol" => "Klikni tukaj za prijavo s pomočjo varnostnega protokola",
"Secure" => "Varno",
"Stay in ssl Mode" => "Ostani v SSL načinu",
"local account" => "lokalni račun",
"OpenID Login" => "OpenID prijava",
"What is OpenID?" => "Kaj je OpenID?",
"You have" => "Vi imate",
"You have 0 new messages" => "Nimate novih sporočil",
"We have" => "Mi imamo",
"Image Galleries" => "Galerije slik",
"Calendars" => "Koledarji",
"Entire Site" => "Celotni strani",
"Wiki Pages" => "Wiki strani",
"Image Gals" => "Galerije slik",
"Blog Posts" => "Blogovski zapisi",
"Search Wiki PageName" => "Poišči ime wiki strani",
"Read More" => "Preberite več",
"Since your last visit on" => "Spremembe od zadnjega obiska na",
"New Images" => "Nove slike",
"Wiki Pages Changed" => "Wiki strani so se spremenile",
"New Files" => "Nove datoteke",
"New Comments" => "Novi komentarji",
"New Tracker Items" => "Nove postavke iskalnikov",
"New Calendar Events" => "Novi dogodki v koledarju",
"New Users" => "Novi uporabniki",
"click to edit" => "Klikni za urejanje",
"Nothing has changed" => "Nič se ni spremenilo",
"Site Language:" => "Jezik strani:",
"Site default" => "Privzeta stran",
"TikiTests Menu" => "Meni TikiTestov",
"List Tests" => "Seznam testov",
"Create Test" => "Ustvari test",
"Top galleries" => "Najboljše galerije",
"click to view" => "klokni za pogled",
"Bookmarks" => "Zaznamki",
"Done" => "Narejeno",
"Del" => "Izbr",
"select" => "izberite",
"Refresh" => "Osveži",
"Send a message to" => "Pošlji sporočilo na",
"Send a message" => "Pošlji sporočilo",
"vote" => "glasuj",
"Users" => "Uporabniki",
"Insert/Edit an internal wiki link" => "Vstavite/Urejajte notranjo wiki povezavo",
"Wiki Link insert" => "Vrivalka wiki povezave",
"Please make a selection of text in order to create a link" => "Prosimo izberite besedilo, da bi lahko ustvaril povezavo",
"Insert an image" => "Vstavite sliko",
"Tiki Image - Insert an image" => "Tiki slika - vstavite sliko",
"RSS feed" => "Vir RSS",
"Edit blog" => "Uredi blog",
"Monitor this Blog" => "Opazuj ta blog",
"Stop Monitoring this Blog" => "Prenehaj opazovati ta blog",
"Find:" => "Poišči:",
"pages" => "strani",
"comments" => "komentarj/a/i/ev",
"First page" => "Prva stran",
"Previous page" => "Prejšnja stran",
"page" => "stran",
"Next page" => "Naslednja stran",
"Last page" => "Zadnja stran",
"references" => "reference",
"View Comments" => "Poglej komentarje",
"Blog name" => "Ime bloga",
"Do not group by item" => "Ne grupiraj po postavkah",
"Group by item" => "Grupiraj po postavkah",
"Calendar View" => "Koled. pogled",
"List View" => "Seznam pogledov",
"Tiki Action Calendar" => "Tiki akcijski koledar",
"Tools Calendars" => "Orodja koledarja",
"Check / Uncheck All" => "Potrdi/Ne potrdi vseh",
"Tip" => "Namig",
"Cancel Edit" => "Prekliči urejanje",
"Site Ads and Banners" => "Reklame in pasice",
"General" => "Splošno",
"Features" => "Značilnosti",
"Community" => "Skupnost",
"Module" => "Modul",
"Meta Tags" => "Meta značke",
"User files" => "Uporabnikove datoteke",
"Change settings" => "Spremeni nastavitve",
"Default view mode" => "Privzet pogled",
"Day" => "Dan",
"Week" => "Teden",
"Month" => "Mesec",
"Quarter" => "Četrtletje",
"First day of the week" => "Prvi dan v tednu",
"Saturday" => "Sobota",
"Sunday" => "Nedelja",
"Monday" => "Ponedeljek",
"Depends user language" => "Odvisno od jezika",
"Split hours in periods of" => "Razdeli uro v enote po",
"1 minute" => "1 minuto",
"5 minutes" => "5 minut",
"10 minutes" => "10 minute",
"15 minutes" => "15 minute",
"30 minutes" => "30 minute",
"Browse categories" => "Prebrskaj kategorije",
"Permissions" => "Dovoljenja",
"Admin topics" => "Administriraj teme",
"Admin types" => "Administriraj tipe",
"Import CSV file" => "Uvozi CSV datoteko",
"Import" => "Uvozi",
"Gender" => "Spol",
"Enable now" => "Omogoči sedaj",
"User information" => "Uporabnikove informacije",
"Private" => "Privatno",
"public" => "javno",
"Use double-click to edit pages" => "Dvoklikni za urejanje strani",
"Messages per page" => "Sporočil na stran",
"Allow messages from other users" => "Dovoli sporočila drugih uporabnikov",
"never" => "nikoli",
"Settings" => "Nastavitve",
"Watches" => "Opazovanja",
"Home Gallery (main gallery)" => "Domača galerija (glavna galerija)",
"Searches" => "Iskanja",
"You can upload images of a size of " => "Naložiš lahko sliko velikosti ",
"Home Gallery" => "Domača galerija",
"Galleries features" => "Značilnosti galerij",
"Max Rows per page" => "maksimalno št. vrstic na stran",
"Remove images in the system gallery not being used in Wiki pages, articles or blog posts" => "Odstrani slike v sistemski galeriji, ki se ne uporabljajo na wiki straneh, člankih ali blogih.",
"Mover" => "Prestavitelj",
"All galleries" => "Vse galerije",
"Moved" => "Prestavljeno",
"Parent" => "Starš",
"Last modified" => "Zadnjič spremenjeno",
"Username" => "Uporabniško ime",
"Home Page" => "Domača stran",
"Minimum {\$prefs.min_pass_length} characters long" => "Dolžina gesla je minimalno {\$prefs.min_pass_length} črk",
"Registration" => "Registracija",
"Account validated successfully." => "Uporabniški račun je uspešno preverjen.",
"User's choice" => "Uporabnikova izbira",
"Duration:" => "Trajanje:",
"Path:" => "Pot:",
"Theme Control" => "Kontrola tem",
"Edit Templates" => "Uredite predloge",
"logged as" => "prijavljen kot",
"Subtitle" => "Podnaslov",
"Menu ID" => "ID meni",
"Email this page" => "Pošlji to stran po e-pošti",
"Direction" => "Smer",
"Feed for articles" => "Vir za članke",
"Feature is disabled." => "Značilnost je onemogočena.",
"Feed for blogs" => "Vir za bloge",
"Individual blogs" => "Individualni blogi",
"Image galleries" => "Galerije slik",
"Feed for image galleries" => "Vir za galerije slik",
"Individual image galleries" => "Posamezne galerije slik",
"Feed for file galleries" => "Vir za galerije datotek",
"Individual file galleries" => "Posamezne galerije datotek",
"Feed for wiki" => "Vir za wikiF",
"Feed for forums" => "Vir za forume",
"Individual forums" => "Posamezni forumi",
"Individual trackers items" => "Posamezne postavke sledilnikov",
"Calendar events" => "Dogodki v koledarju",
"Feed for directory" => "Vir za direktorij",
"Feed for maps" => "Vir za zemljevide",
"Refresh wiki search index now" => "Osveži wiki iskalni indeks",
"AutoLinks" => "AvtoPovezave",
"Hotwords" => "Vroče besede",
"Required" => "Zahtevano",
"Parameters" => "Parameteri",
"Storage" => "Shranjevanje",
"No records" => "Ni zapisov",
"Change all to db" => "Spremeni vse v db",
"Change all to file" => "premeni vse v file",
"Quota (Mb)" => "Kvota (Mb)",
"Create New" => "Ustvari novo",
"Undo" => "Razveljavi (undo)",
"Permission" => "Dovoljenje",
"Allow HTML" => "Dovoli HTML",
"Sandbox" => "Peskovnik",
"Manage attachments" => "Upravljaj priponkeManage attachments",
"Remove unused pictures" => "Odstrani neuporabljane slike",
"Export" => "Izvozi",
"Export Wiki Pages" => "Izvozi wiki strani",
"HTML diff" => "HTML spr",
"Side-by-side diff" => "Side-by-side spr",
"Side-by-side diff by characters" => "Side-by-side spr po črkah",
"Inline diff" => "Inline spr",
"Inline diff by characters" => "Inline spr po črkah",
"Full side-by-side diff by characters" => "Polna side-by-side spr po črkah",
"Full inline diff" => "Full inline spr",
"Full inline diff by characters" => "Full inline spr po črkah",
"Discuss pages on forums" => "Razpravljaj strani na forumih",
"Forums are disabled." => "Forumi niso omogočeni.",
"Forum for discussion:" => "Forum za razpravo:",
"Similar" => "Podobno",
"Structures" => "Strukture",
"Create webhelp from structure:" => "Ustvari spletno pomoč iz strukture:",
"Name length:" => "Dolžina imena:",
"Links" => "Povezave",
"Wiki attachments" => "Wiki priponke",
"Change" => "Spremeni",
"Shoutbox Words" => "Besede kričača (Shoutbox)",
"Contact us" => "Stopi z nami v stik",
"Cookies" => "Piškotki",
"Search Stats" => "Iskalna statistika",
"Edit Action" => "Uredi akcijo",
"Save Action" => "Shrani akcijo",
"Statistics" => "Statistika",
"Weeks" => "Tedni",
"Rules" => "Pravila",
"User/IP" => "Uporabnik/IP",
"Sections" => "Sekcije",
"Admin Calendars" => "Admin koledarje",
"List of Calendars" => "Seznam koledarjev",
"Participants" => "Udeleženci",
"Add Event" => "Dodaj dogodek",
"Personal Calendar" => "Osebni koledar",
"Start of day" => "Začetek dneva",
"End of day" => "Konec dneva",
"Custom foreground color" => "Običajna osprednja barva",
"Custom background color" => "Običajan barva ozadja",
"Delete events older than:" => "Izbriši dogodke, ki so starejši kot:",
"Current category" => "Trenutna kategorija",
"Current Category ID:" => "ID trenutne kategorije:",
"Child categories" => "Otroška kategorija",
"Edit permissions for this category" => "Uredi dovoljenja za to kategorijo",
"Edit this category:" => "Uredite to kategorijo:",
"Add new category" => "Dodaj novo kategorijo",
"Batch upload (CSV file):" => "Paketno nalaganje (CSV datoteka):",
"Objects in category" => "Predmeti v kategoriji",
"Remove from this Category" => "Odstrani iz te kategorije",
"No records found." => "Ni najdenih zapisov.",
"Add objects to category" => "Dodaj objekte v kategorijo",
"Admin templates" => "Administriraj predloge",
"Edit this template:" => "Uredite to predlogo:",
"Create new template" => "Ustvari novo predlogo",
"Use wysiwyg editor" => "Uporabi WYSIWYG urejevalnik",
"Use normal editor" => "Uporabi normalni urejevalnik",
"Use in" => "Uporabi v",
"Templates" => "Predloge",
"Admin Contributions" => "Administriraj prispevanja",
"Edit the contribution:" => "Uredi prispevanja:",
"Admin cookies" => "Administriraj piškotke",
"Create/edit cookies" => "Ustvari/uredi piškotke",
"Upload Cookies from textfile" => "Naloži piškotke iz tekstovne datoteke",
"Upload from disk:" => "Naloži z diska:",
"Upload" => "Naloži",
"Remove all cookies" => "Odstrani vse piškotke",
"cookie" => "piškotki",
"View template" => "Poglej predlogo",
"Edit template" => "Uredite predlogo",
"Create/Edit External Wiki" => "Ustvari/uredi zunanji wiki",
"Admin Forums" => "Administriraj forume",
"Create new forum" => "Ustvari nov forum",
"Duplicate forum" => "Dupliciraj forum",
"View this forum" => "Poglej ta forum",
"Import forums" => "Uvozi forume",
"List forums" => "Seznam forumov",
"Edit this Forum:" => "Uredi ta forum:",
"Create New Forum" => "ustvari nov forum",
"There are individual permissions set for this forum" => "za ta forum so nastavljene osebna dovoljenja",
"Name:" => "Ime:",
"Create new" => "Ustvari novo",
"Password protected" => "Zaščiteno z geslom",
"Forum password" => "Geslo foruma",
"Posts can be rated" => "Prispevki se lahko ocenjuje",
"Display last post titles" => "Prikaži zadnje naslove prispevkov",
"Send mails even when the post is generated by inbound mail" => "Pošlji pošto celo ko je prispevek generiran z inbound pošto",
"Append a reply link to outbound mails" => "Pripni povezavo v odgovoru na outbound pošto",
"Add messages from this email to the forum" => "Dodaj sporočila s tega e-naslova za e-naslove s tega foruma",
"Use topic smileys" => "Uporabi smejkote tem",
"Show topic summary" => "Pokaži povzetek teme",
"User information display" => "Prikaz uporabnikovih informacij",
"Online" => "Priključeni (Online)",
"Approval type" => "Tip potrditve",
"Store attachments in:" => "Shrani priponke v:",
"Set topics preferences" => "Nastavi prednosti (preferences) tem",
"Show topics preferences" => "Pokaži prednosti (preferences) tem",
"hide topics preferences" => "skrij prednosti (preferences) tem",
"Default number of comments per page:" => "Privzeto število komentarjev na stran:",
"Duplicate perms" => "Dupliciraj dovoljenje",
"Edit this page" => "Uredi to stran",
"View page" => "Poglej stran",
"Apply template" => "Uporabi predlogo",
"Last Modif" => "Zadnja sprem.",
"File name of start page" => "Ime datoteke začetne strani",
"Start page" => "Začetna stran",
"CSS File" => "CSS datoteka",
"Edit rules" => "Uredi pravila",
"New Rule" => "Novo pravilo",
"Copy Rules" => "Kopiraj pravila",
"Configure/Options" => "Konfiguriraj/Opcije",
"Theme control" => "Kontrola tem",
"Admin Topics" => "Administriraj teme",
"Active" => "Aktiven",
"Allow attachments" => "Dovoli priponke",
"Check automatically" => "Preveri avtomatično",
"Frequency" => "Frekvenca",
"List menus" => "Seznam menijev",
"Edit this menu" => "Uredite ta meni",
"Edit menu options" => "Uredi opcije menija",
"For wiki page, use ((PageName))." => "Za wiki stran uporabi((ime strani)).",
"Use Ctrl+Click to select multiple groups." => "Uporabi Ctrl+klik za izbiro več skupin.",
"option" => "opcija",
"section level 0" => "nivo sekcija 0",
"section level 1" => "nivo sekcija 1",
"section level 2" => "nivo sekcija 2",
"section level 3" => "nivo sekcija 3",
"sorted section level 0" => "sortirano po nivoju sekcije 0",
"separator" => "ločilnik",
"Choose" => "Izberi",
"Home Image Gal" => "Domača gal. slik",
"Home Image Gallery" => "Domača galerija slik",
"Home File Gal" => "Domača gal. datotek",
"Home File Gallery" => "Domača galerija datotek",
"User preferences" => "Uporabnikove izbirne nastavitve",
"User prefs" => "Uporabnikove izbir. nastavitve",
"List galleries" => "Seznam galerij",
"Upload image" => "Naloži sliko",
"Gallery Rankings" => "Najboljše galerije",
"Browse a gallery" => "Prebrskaj galerijo",
"Articles home" => "Članki dom",
"All articles" => "Vsi članki",
"Submit" => "Predloži",
"List Blogs" => "Seznam blogov",
"Create blog" => "Ustvari blog",
"View a forum" => "Poglej forum",
"View a thread" => "Poglej nit(thread)",
"View a FAQ" => "Poglej vprašanja in odgovore",
"Quiz stats" => "Statistika kvizov",
"Menu options" => "Opcije menija",
"Options" => "Opcije",
"Active Permissions" => "Aktivna dovoljenja",
"Edit this Menu:" => "Uredi ta meni:",
"Create new Menu" => "Ustvari ta meni",
"Clear Cache" => "Počisti Cache",
"Left Modules" => "Levi moduli",
"Move Up" => "Prestavi gor",
"Move Down" => "Prestavi dol",
"Move to Right Column" => "Prestavi v desno kolono",
"Right Modules" => "Desni moduli",
"Move to Left Column" => "Prestavi v levo kolono",
"Assign new module" => "Določi nov modul",
"Edit this assigned module:" => "Uredi ta določen modul:",
"Cache Time" => "Čas za Cache",
"Display Modules to All Groups" => "Prikaži module vsem skupinam",
"User Modules" => "Uporabnikovi moduli",
"Create new user module" => "Ustvari nov uporabniški modul",
"Edit this user module:" => "Uredi ta uporabniški modul:",
"Use Gallery" => "Uporabi galerijo",
"Use Menu" => "Uporabniški meni",
"Structures:" => "Strukture:",
"Use Wiki Structure" => "Uporabi wiki strukturo",
"Data" => "Podatki",
"Send Newsletters" => "Pošlji biltene",
"Add email:" => "Dodajte e-naslov:",
"Add user:" => "Dodajte uporabnika:",
"Admin newsletters" => "Administrirajte biltene",
"Mail notifications" => "Poštne objave (notifications)",
"Update" => "Posodobi",
"0 for no limit" => "0 za brez omejitev",
"Wiki pages" => "Wiki strani",
"Lock the pages" => "Zaklenite strani",
"Show Title?" => "Prikaži naslov?",
"View feed" => "Poglej vir",
"Are you sure you want to delete this word?" => "Ste prepričani, da bi radi izbrisali to besedo?",
"The structure" => "Struktura",
"You will remove structure" => "Odstranil boš strukturo",
"Destroy the structure leaving the wiki pages" => "Uniči strukturo a pusti wiki strani",
"Destroy the structure and remove the pages" => "Uniči strukturo in odstrani wiki strani",
"Edit structure" => "Uredi strukturo",
"Export Pages" => "Izvozi strani",
"Create WebHelp" => "Ustvari spletno pomoč",
"View WebHelp" => "Poglej spletno pomoč",
"Create new structure" => "Ustvari novo strukturo",
"Alias" => "Vzdevek (alias)",
"Tree" => "Drevo",
"Use single spaces to indent structure levels" => "Uporabite posamezne presledke za zamikanje nivojev struktur",
"Create New Structure" => "Ustvari novo strukturo",
"List surveys" => "Seznam spletnih anket",
"Survey Stats" => "Statistika ankete",
"Edit this Survey" => "Uredite anketo",
"Admin Surveys" => "Administrirajte anketo",
"Question" => "Vprašanje",
"One choice" => "Ena izbira",
"Multiple choices" => "Mnogovrstna izbira (multiple)",
"Short text" => "Kratko besedilo",
"Admin surveys" => "Administriraj spletne anktete",
"List Surveys" => "Seznam domačih strani",
"Empty" => "Izprazni",
"Investigate" => "Preišči",
"Fix it" => "Popravi",
"Create a new topic" => "ustvari novo ",
"Topic Name" => "Ime teme",
"Upload Image" => "Naloži sliko",
"List of topics" => "Seznam tem",
"Articles (subs)" => "Članki (subs)",
"topic image" => "slika teme",
"Inactive - Click to Activate" => "Neaktiven - kliknite za aktivacijo",
"Deactivate" => "Deaktiviraj",
"Active - Click to Deactivate" => "Aktiven - kliknite za deaktivacijo",
"Remove with articles" => "Odstrani članke",
"List Trackers" => "Seznam sledilnikov",
"Error message:" => "Sporočilo napake:",
"Found" => "Najdeno",
"ascending" => "naraščajoč",
"descending" => "padajoč",
"Filesize" => "Velikost datoteke",
"Filetype" => "Tip datoteke",
"After:" => "Po:",
"Before:" => "Pred:",
"Edit group" => "Uredite skupino",
"Remove from Group" => "Odstrani iz skupine",
"users in group" => "uporabniki v skupini",
"Download CSV export" => "naloži CSV izvoz",
"Assign users to group:" => "Določi uporabnika v skupino:",
"CSV File" => "CSV datoteka",
"Add a New User" => "Dodajte novega uporabnika",
"Reason" => "Razlog",
"More Criteria" => "Več kriterijev",
"Group (direct)" => "Skupina (direktno)",
"Registered" => "Registriran",
"Need to validate email" => "Mora preveriti veljavnost e-naslova",
"Invalid email" => "Neveljaven e-naslov",
"Assign selected to" => "Določi izbrane za",
"Remove selected from" => "Odstrani izbrano iz",
"Edit user" => "Uredite uporabnika",
"Use the email as username" => "Uporabi e-naslov za uporabniško ime",
"No password is required" => "Ni zahtevano geslo",
"Generate a password" => "Generiraj geslo",
"Overwrite" => "Prepiši",
"Don't overwrite" => "ne prepiši",
"Overwrite groups:" => "Prepiši skupine:",
"Loading..." => "nalaganje...",
"Page has been approved" => "Stran je odobrena",
"New attachments" => "Nove priponke",
"Old attachments" => "Stare priponke",
"Source" => "Vir",
"Group Information" => "Informacije za skupino",
"Create level" => "Ustvari stopnjo (level)",
"Assign User to Group" => "Določi uporabnika v skupino",
"backlinks to" => "povezovanje nazaj v",
"No backlinks to this page" => "Ni povezovanja nazaj na to stran",
"Browse Gallery" => "Prebrskaj galerijo",
"available images" => "razpoložljive slike",
"Select a Gallery" => "Izberi galerijo",
"Select a File Gallery" => "Izberi galerijo datotek",
"Edit Post" => "Uredi prispevek",
"View Blog" => "Poglej blog",
"If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. " => "Če želiš uporabiti slike, prosim shrani prvo zapis in lahko boš urejal/pošiljal slike. Uporabi &lt;img&gt; delček (=majhen del kode HTML ali XML) (snippet) da bi vključil slike v besedilno področje z uporabo WYSIWYG urejevalnika.",
"Use ...page... to separate pages in a multi-page post" => "Uporabi ... stran... za ločevanje strani v večstranskih prispevkih",
"Body" => "Telo besedila",
"Upload image for this post" => "Naloži sliko za ta prispevek",
"Trash" => "Odpad",
"Mark entry as private:" => "Označi vnos kot privaten:",
"Spellcheck" => "Črkovalnik",
"Save and Exit" => "Shrani in izhod",
"Report to Webmaster" => "Poročajte skrbniku spletišča (Webmaster)",
"Powered by" => "Poganja",
"Made with" => "Narejeno z",
"powered by" => "poganja",
"Blogs RSS" => "Blog RSS",
"Articles RSS" => "Članki RSS",
"Image Galleries RSS" => "Galerije slik RSS",
"File Galleries RSS" => "Galerije datotek RSS",
"Forums RSS" => "Forumi RSS",
"Maps RSS" => "Zemljevidi RSS",
"Execution time" => "Čas izvršitve",
"Memory usage" => "Uporaba spomina",
"Server load" => "Obremenitev strežnika (Server Load)",
"Last update from SVN" => "Zadnja posodobitev iz SVN",
"Watch Only This Category" => "Opazuj samo to kategorijo",
"Watch This Category and Their Descendants" => "Opazuj to kategorijo in njene potomce ",
"Stop Watching Only This Category" => "Prenehaj opazovati to kategorijo",
"Stop Watching This Category and Their Descendants" => "Prenehaj opazovati to kategorijo in njene potomce",
"Admin Category" => "Administriraj kategorijo",
"Admin the Category System" => "Administriraj sistem kategorij",
"Browse in" => "Brskaj v",
"Trackers Items" => "Sledilne postavke",
"in the current category - and its subcategories: " => "v trenutni kategoriji in v njenih podkategorijah: ",
"Hide subcategories objects" => "Skrij objekte podkategorije",
"Show subcategories objects" => "Prikaži objekte podkategorije",
"Upper level" => "Zgornji nivo",
"Browse related tags" => "Brskaj po sorodnih značkah",
"Network of Tags related to" => "Mreža značk, ki so sorodne",
"With all selected tags" => "Z vsemi izbranimi značkami",
"With one selected tag" => "Z eno izbrano značko",
"With last selected tag" => "Z zadnjo izbrano značko",
"More Popular Tags" => "Več priljubljenih značk",
"Sort:" => "Sortiraj:",
"Alphabetically" => "Po abecedi",
"By Size" => "Po velikosti",
"Cloud" => "Oblak",
"results found" => "najdeni rezultati",
"List Galleries" => "Seznam galerij",
"Edit Gallery" => "Uredi galerijo",
"Rebuild Thumbnails" => "Predelaj (Rebuild) miniaturne sličice (Thumbnails)",
"List Gallery" => "Navedi galerijo",
"All Images" => "Vse slike",
"Monitor this Gallery" => "Spremljaj to galerijo",
"Stop Monitoring this Gallery" => "Prenehaj spremljati to galerijo",
"Sort Images by" => "Sortiraj slike po",
"subgallery" => "podgalerija",
"Subgallery" => "Podgalerija",
"Original Size" => "Originalna velikost",
"rotate right" => "rotiraj desno",
"rotate" => "rotiraj",
"Details" => "Podrobnosti",
"popup" => "pojavno oknopup",
"You can include the image in a tiki page using one of these lines" => "Sliko lahko vključite v tiki stran z uporabo ene od teh vrstic",
"Return to Gallery" => "Nazaj na galerijo",
"Edit Image" => "Uredi sliko",
"First Image" => "Prva slika",
"Prev Image" => "Pred. slika",
"Smaller" => "Manjša",
"Bigger" => "Večja",
"Popup window" => "Pojavno (pop up) okno",
"Next Image" => "Naslednja slika",
"Slideshow Forward" => "Slideshow Naprej",
"Last Image" => "Zadnja slika",
"Cyclic" => "Ciklično",
"Click to zoom" => "Klikni za povečavo",
"Image Name" => "Ime slike",
"Image Scale" => "Skala slike",
"Move image" => "Prestavi sliko",
"Stop Monitoring this Page" => "Prenehaj opazovati to stran",
"Monitor this Page" => "Opazuj to stran",
"Visible Calendars" => "Vidni koledarji",
"Click to select visible calendars" => "Klikni za izbiro vidnosti koledarjev",
"Group Calendars" => "Koledarji skupin",
"Edit event" => "Uredi dogodek",
"View event" => "Poglej dogodek",
"Tentative" => "Nameravan",
"Confirmed" => "Potrjen",
"Cancelled" => "Odpovedan",
"Change Focus" => "Spremeni fokus",
"Calendar Item" => "Postavka v koledarju",
"Edit Calendar" => "Uredi koledar",
"New event" => "Novi dogodek",
"Edit Calendar Item" => "Uredite postavko koledarja",
"New Calendar Item" => "Nova postavka v koledarju",
"Tuesday" => "Torek",
"Wednesday" => "Sreda",
"Thursday" => "Četrtek",
"Friday" => "Petek",
"January" => "Januar",
"February" => "Februar",
"March" => "Marec",
"May" => "Maj",
"June" => "Junij",
"July" => "Julij",
"August" => "Avgust",
"October" => "Oktober",
"End" => "Konec",
"Duration" => "Trajanje",
"Date and time of end" => "Datum in čas zaključka",
"or new" => "ali nov",
"Organized by" => "Organizira",
"Roles" => "Vloge",
"chair" => "predsednik",
"default role" => "privzeta vloga",
"required participant" => "zahtevan udeleženec",
"optional participant" => "opcijski udeleženec",
"non participant" => "ne udeleženec",
"Calendar import" => "Uvoz koledarja",
"Calendar has been updated" => "Koledar je bil posodobljen",
"Click here to send us an email" => "Klikni tu za pošiljanje e-pošte",
"Contacts" => "Stiki",
"Create/edit contacts" => "Ustvari/uredi stike",
"First Name" => "Ime",
"Publish this contact to groups" => "Objavi ta stik v skupini",
"Last Name" => "Priimek",
"Structure" => "Struktura",
"Top page" => "Vrh strani",
"Edit a site" => "Uredi stran(site)",
"Add a site" => "Dodaj stran(site)",
"Validate" => "Preveri (Validate)",
"hits (desc)" => "zadetki (padajoče)",
"hits (asc)" => "zadetki (naraščajoče)",
"Added" => "Dodano",
"Search results" => "Rezultati iskanja",
"Edit article" => "Uredi članek",
"List Articles" => "Seznam člankov",
"View Articles" => "Poglej članke",
"One of the email addresses you typed is invalid" => "Eden od e-naslovov je neveljaven",
"Author Name" => "Ime avtorja",
"Own Image" => "Lastna slika",
"Article image" => "Slika v članku",
"Use own image" => "Uporabi svojo sliko",
"Float text around image" => "Plavajoče besedilo okoli slike",
"Own image size x" => "Velikost lastne slike x",
"Own image size y" => "Velikost lastne slike y",
"Image caption" => "Napis pod sliko",
"Publish Date" => "Datum objave",
"Expiration Date" => "Končni rok",
"Emails to be notified (separated with commas)" => "E-naslovi, ki bodo obveščeni (loči z vejivami)",
"From date" => "Od datuma",
"To date" => "Do datuma",
"Use dates" => "Uporabi datume",
"Show the banner only in this hours" => "Pokaži pasico samo v teh urah",
"Show the banner only on" => "Pokaži pasico samo v",
"Mon" => "Pon",
"Tue" => "Tor",
"Wed" => "Sre",
"Thu" => "Čet",
"Fri" => "Pet",
"Sat" => "Sob",
"Sun" => "ned",
"Create Blog" => "Ustvari blog",
"Title bar" => "Naslovna vrstica",
"No description available" => "Opis ni na voljo",
"Browse Images" => "Prebrskaj slike",
"Edit successful!" => "Uspešno urejanje!",
"Image Description" => "Opis slike",
"Upload from disk to change the image:" => "Naloži z diska, da bi spremenili sliko:",
"Save and Go Next" => "Shrani in pojdi naprej",
"You can view this image in your browser using" => "To sliko lahko vidite v vašem brskalniku z uporabo",
"You can include the image in an HTML page using one of these lines" => "Sliko lahko vključite v HTML stran z uporabo ene od teh vrstic",
"Shortname" => "Kratko ime",
"like" => "kot",
"Longname" => "Dolgo ime",
"Add a translation" => "Dodaj prevod",
"Translation" => "Prevod",
"Return to block listing" => "Nazaj na blogovski izpis",
"List Quizzes" => "Seznam kvizov",
"Maximum time" => "Maksimalni čas",
"Answer" => "Odgovor",
"Modify Structure" => "Spremeni strukturo",
"You will remove" => "Odstranili boste",
"and its subpages from the structure, now you have two options:" => "in njene podstrani iz strukture, sedaj imete dve možnosti:",
"and its subpages from the structure" => "in njene podstrani iz strukture",
"Remove only from structure" => "Odstrani samo iz strukture",
"Remove from structure and remove page too" => "Odstrani iz strukture in tudi odstrani stran",
"The page already exists. The page that has been added to the structure is the existing one." => "Stran že obstaja. Stran, ki je bila dodana strukturi je obstoječa.",
"The following pages added have automatically been categorized with the same categories as the structure:" => "Naslednje strani, ki so bile dodane so avtomatsko kategorizirane z istimi kategorijami kot struktura:",
"Structure Layout" => "Razporeditev strukture",
"Monitor the Sub-Structure" => "Nadziraj podstrukturo",
"Stop Monitoring the Sub-Structure" => "Prenehaj nadzirati pod-strukturo",
"Promote" => "Povišaj",
"Demote" => "Ponižaj",
"Previous" => "Prejšnji",
"Current Node" => "Sedanje vozlišče",
"Page alias" => "Vzdevek strani",
"Move in this structure" => "Prestavi v tej strukturi",
"Move to another structure" => "Prestavi v drugo strukturo",
"at the beginning" => "na začetku",
"at the end" => "na koncu",
"Add pages to current node" => "Dodaj strani na sedanje vozlišče",
"After page" => "Po strani",
"Create Page" => "Ustvari stran",
"Use pre-existing page" => "Uporabi pred-obstoječo stran",
"Categorize all pages in structure together" => "Kategoriziraj vse strani v strukturi",
"Submit article" => "Pošlji članek",
"<b>*</b>=optional" => "<b>*</b>=opcija",
"Edit templates" => "Uredite predloge",
"Edit Section:" => "Uredi sekcijo:",
"View object" => "Poglej predmet (object)",
"Preview your changes." => "Predogled sprememb.",
"Save the page." => "Shrani stran.",
"Cancel the edit, you will lose your changes." => "Preklic urejanja strani pomeni izgubo sprememb.",
"<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer." => "Klikni <strong>Predogled</strong> ali <strong>Shrani</strong> da bi spet pognal uro od začetka.",
"The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page." => "Peskovnik je stran kjer lahko vadiš urejanje (uporabiš lahko vse funkcije). Uporabi Predogled, da vidiš kako stran izgleda. Nobena verzija se ne shrani za to stran.",
"Upload picture" => "Naloži sliko",
"Admin Content Templates" => "Administratorjeve vsebinske predloge",
"Lock this page" => "Zaklenite to stran",
"Import page" => "Uvozi stran",
"export all versions" => "Izvozi vse verzije",
"Year:" => "Leto:",
"Authors:" => "Avtorji:",
"Manage structures" => "Upravljaj strukture",
"License" => "Licenca",
"Important" => "Pomembno",
"My Footnotes" => "Opombe v nogi",
"All fields" => "Vsa polja",
"List FAQs" => "Seznam vprašanj in odgovorov (FAQs)",
"Upload File" => "Naloži datoteko",
"Create New File Gallery" => "Ustvari novo galerijo datotek",
"You can access the file gallery using the following URL" => "Lahko dostopš do galerije datotek z uporabo sledečega URL",
"Admin forums" => "Administriraj forume",
"Import from a Local SQL File" => "Uvozi iz lokalne SQL datoteke",
"Forum Type" => "Tip foruma",
"Edit queued message" => "Uredi sporočila v vrsti",
"Search in content" => "Iščite v vsebini",
"Galleries" => "Galerije",
"Create New Gallery" => "Ustvari novo galerijo",
"Create a gallery" => "Ustvari galerijo",
"Edit this gallery:" => "Uredi to galerijo:",
"There are individual permissions set for this gallery" => "Individualna dovoljenja, ki so nastavljena za to galerijo",
"Gallery is visible to non-admin users?" => "Galerija je vidna uporabnikom, ki niso administratorji?",
"Geographic" => "Geografsko",
"Fields to show during browsing the gallery" => "Polja, ki se pokažejo med brskanjem po galeriji",
"Other users can upload images to this gallery" => "Drugi uporabniki lahko nalagajo slike v to galerijo",
"To" => "Za",
"Errors:" => "Napake:",
"Locked" => "Zaklenjeno",
"Go Back" => "Pojdi nazaj",
"Last Changes" => "Zadnje spremembe",
"Rollback" => "Povrni na to verzijo",
"Pages like" => "Strani kot",
"No pages found" => "Ni najdenih strani",
"Edit New Article" => "Uredi nov članek",
"Edit/Create" => "Uredi/Ustvari",
"Your comment" => "Vaš komentar",
"Additional Info" => "Dodatne informacije",
"Edit Blog" => "Uredite blog",
"Blog Title" => "Naslov bloga",
"Distance (km)" => "Razdalja (km)",
"List Movies" => "Seznam filmov",
"Choose a movie" => "Izberi film",
"Last mod" => "Zadnja sprememba",
"Last modification" => "Zadnja sprememba",
"Page creator" => "ustvarjalec strani",
"Last author" => "Zad. avtor",
"Last version" => "Zadnja verzija",
"Last ver." => "Zad.ver.",
"Status of the page" => "Status strani",
"Vers." => "Verz.",
"Links to other items in page" => "Povezave na druge postavke na strani",
"Links to this page in other pages" => "Povezave na to stran in druge strani",
"Page size" => "Velikost strani",
"unlocked" => "nezaklenjen",
"Perform action with checked" => "Izvedi to akcijo ko označim",
"Open client window" => "Odpri okno klienta",
"Generate HTML" => "Generiraj HTML",
"Operator" => "Operater",
"Remove old events" => "Odstrani stare dogodke",
"duration" => "trajanje",
"Mini Calendar: Preferences" => "Mini koledar: izbirne nastavitve",
"Calendar Interval in daily view" => "Koledarski intervali v dnevnem pogledu",
"Start hour for days" => "Ure začetka dni",
"End hour for days" => "Ura konca dni",
"Reminders" => "Opomniki",
"no reminders" => "brez opomnikov",
"Or enter path or URL" => "Ali vnesi pot ali URL",
"Add Topic" => "Dodaj temo",
"User Galleries" => "Uporabnikove galerije",
"Comments:" => "Komentarji:",
"Tasks" => "Opravila",
"MyTiki" => "Moj Tiki",
"MyInfo" => "Moje informacije",
"Notepad" => "Beležnica",
"MyFiles" => "Moje datoteke",
"Sent editions" => "Pošlji izdaje (editions)",
"The newsletter was sent to {\$sent} email addresses" => "Bilten je bil poslan {\$sent} e-poštne naslove",
"Delete errors" => "Izbriši napake",
"Not sent" => "Ni poslano",
"Available Newsletters" => "Dostopni bilteni",
"Notes" => "Opomba",
"Write a note" => "Napiši opombo",
"List notes" => "Seznam opomb",
"Write note" => "Napiši opombo",
"Wiki Create" => "Wiki ustvari",
"Wiki Overwrite" => "Wiki prepiši",
"Added:" => "Dodan:",
"Removed:" => "Odstranjen:",
"Assign permissions to " => "Določi dovoljenja v ",
"Edit Permissions" => "Uredi dovoljenja",
"Assign permissions to this object" => "Določi dovoljenja za ta objekt",
"Published" => "Objavljeno",
"Your OpenID identity is valid" => "Tvoj OpenID identiteta je veljavna",
"Create a new Tikiwiki account from OpenID" => "Ustvari nov Tikiwiki račun iz OpenID",
"Passcode to register (not your user password)" => "Koda za registracijo (to ni vaše uporabniško geslo)",
"Select account" => "Izberi račun",
"Orphan Pages" => "Osirotele strani",
"Browser not supported" => "Brskalnik ni podprt",
"Rename" => "Preimenuj",
"Make Structure" => "Naredi strukturo",
"Slides" => "Diapozitivi (slides)",
"Discuss" => "Diskutiraj",
"Attach File" => "Pripni datoteko",
"1 File Attached" => "1 pripeta datoteka",
"{\$atts|@count} files attached" => "{\$atts|@count} pripete datoteke",
"History:" => "Zgodovina:",
"(current)" => "(trenutna)",
"Rollback to this version" => "Povrni na to verzijo",
"s=source" => "s=vir",
"b=rollback" => "b=povrni",
"Update Translation" => "Posodobljen prevod",
"Hide translation history" => "Skrij zgodovino prevajanja",
"Show translation history" => "Pokaži zgodovino prevajanja",
"Avatar:" => "Podoba (avatar):",
"Pick your avatar" => "Izberi podobo (avatarja)",
"User Preferences" => "Uporabnikove izbirne nastavitve",
"Your current avatar" => "vaša trenutna podoba (avatar)",
"no avatar" => "brez podobe (avatarja)",
"reset" => "ponovno nastavi",
"Pick avatar from the library" => "Izberi podobo (avatarja) iz knjižnice",
"Pick user Avatar" => "Izberi uporabnikovo podobo(avatarja)",
"Hide all" => "Skrij vse",
"icons" => "ikone",
"Show all" => "Prikaži vse",
"Avatar Image" => "Slika podobe (Avatar Image)",
"Upload your own avatar" => "Naloži svojega avatarja",
"Insert" => "Vstavi",
"Average" => "Povprečje",
"Plugin" => "Vtičnik",
"Note: Remember that this is only a preview, and has not yet been saved!" => "Opozorilo: Vedi, da je to samo predogled in ni bil shranjen!",
"on:" => "na:",
"Topic image" => "Slika teme",
"Viewing blog post" => "Gledanje zapisa na blogu",
"Return to blog" => "Nazaj na blog",
"Selected Structures" => "Izbrane strukture",
"Add Structure" => "Dodaj strukture",
"No structures" => "Brez struktur",
"Add Pages" => "Dodaj strani",
"No pages" => "Brez strani",
"Use Ctrl+Click to select multiple pages" => "Uporabi Ctrl+Click za izbiro več strani",
"Add Page" => "Dodaj stran",
"Add Pages from Structures" => "Dodaj strani iz struktur",
"Add Structure Pages" => "Dodaj strukturne strani",
"Selected Pages" => "Izbrane strani",
"No pages selected." => "Ni izbranih strani.",
"Edit quiz" => "Uredi kviz",
"General Options" => "Splošne možnosti",
"Publication Date" => "Datum objave",
"at " => "pri ",
"Use " => "Uporabi ",
"Question:" => "Vprašanje:",
"Top 10" => "Najboljših 10",
"Top 20" => "Najboljših 20",
"Top 50" => "Najboljših 50",
"Top 100" => "Najboljših 100",
"star" => "zvezda",
"half star" => "polzvezda",
"Send a link" => "Pošlji povezavo prijatelju",
"Received articles" => "Prejeti članki",
"Edit received article" => "Urejaj prejete članke",
"Use Image" => "Uporabi sliko",
"Image x size" => "Slika x velikost",
"Image y size" => "Slika y velikost",
"Image name" => "Ime slike",
"Accept Article" => "Sprejmi članek",
"Site" => "Stran",
"Received Pages" => "Prejete strani",
"Edit Received Page" => "Uredi prejeto stran",
"The highlight pages already exist." => "Označene strani že obstajajo.",
"Please, change the name if you want the page to be uploaded." => "Prosimo, zamenjajte ime, če želite, da se slika naloži.",
"Received Structures" => "Prejete strukture",
"Last" => "Zadnji",
"Your email could not be validated; make sure you email is correct and click register below." => "Ne morem preveriti veljavnosti vašega e-naslova; preverite pravilnost e-naslova in kliknite spodaj Registriraj.",
"Register as a new user" => "Registriraj se kot nov uporabnik",
"Repeat password" => "Ponovi geslo",
"A valid email is mandatory to register" => "Za registracijo je potreben veljaven e-naslov",
"Select your group" => "Izberi svojo skupino",
"Tiki site registered" => "Tiki stran registrirana",
"The following site was added and validation by admin may be needed before appearing on the lists" => "Ta stran je bila dodana in validacija administratorja je potrebna preden se pojavite na seznamih",
"You don't have permission to use this feature." => "Nimate dovoljenja uporabljati te značilnosti (feature).",
"Please register." => "Prosim registrirajte se.",
"Register this site at tikiwiki.org" => "Registriraj to stran pri tikiwiki.org",
"Read this first!" => "Najprej preberi tole!",
"Registering is voluntary." => "Registracija je prostovoljna.",
"If your site is private or inside your intranet, you should not register!" => "Če je to vaša privatna stran ali stran znotraj intraneta, se ne smete registrirati!",
"Information about your site" => "Informacije o vaši strani",
"Enter your username or email." => "Vnesi uporabniško ime ali e-naslov.",
"Send me my Password" => "Pošlji mi geslo",
"Request Password Reset" => "Zahtevaj ponovno nastavljanje gesla",
"Remove page" => "Odstrani stran",
"Last Version" => "Zadnja verzija",
"You are about to remove the page" => "Odstranili boste stran",
"permanently" => "za stalno",
"Remove all versions of this page" => "Odstranite vse verzije te strani",
"Rollback page" => "Stran povrni nazaj (Rollback)",
"Searched" => "Iskano",
"Search in" => "Išči v",
"Simple search" => "Preprosto iskanje",
"No pages matched the search criteria" => "Nobena stran ne ustreza iskanim kriterijem",
"This newsletter will be sent to {\$subscribers} email addresses." => "Ta bilten bo poslan na {\$subscribers} e-poštne naslove.",
"Prepare a newsletter to be sent" => "Pripravi bilten za pošiljanje",
"Save as Draft" => "Shranite kot osnutek",
"Send objects" => "Pošlji objekte",
"Send Wiki Pages" => "Pošlji wiki strani",
"Send a structure" => "Pošlji strukture",
"Send Articles" => "Pošlji članke",
"Add Article" => "Dodaj članek",
"Send objects to this site" => "Pošlji objekte na to stran",
"Parent page" => "Starševska stran",
"Child" => "Otrok",
"Last edited by" => "Zadnji urejal",
"based on work by" => "temelji na delu",
"Contributors to this page" => "Prispevali na to stran",
"Most viewed objects" => "Najbolj gledano",
"Most viewed objects in the last 7 days" => "Najbolj gledano v zadnjih 7 dneh",
"Site Stats" => "Statistika strani",
"Started" => "Začetek",
"Days online" => "Dnevi online",
"Total pageviews" => "Skupno število ogledov strani",
"Average pageviews per day" => "Povprečno število pogledov na dan",
"Best day" => "Najboljši dan",
"Worst day" => "Najslabši dan",
"Wiki Stats" => "Wiki statistika",
"Size of Wiki Pages" => "Velikost wiki strani",
"Average page length" => "Povprečna dolžina strani",
"Average versions per page" => "Povprečno število verzij na stran",
"Visits to wiki pages" => "Obiski wiki strani",
"Average links per page" => "Povprečno število povezav na stran",
"Image galleries Stats" => "Statistika galerij slik",
"Average images per gallery" => "Povprečje slik na galerijo",
"Total size of images" => "Skupna velikost slik",
"Average image size" => "Povprečna velikost slik",
"Visits to image galleries" => "Obiski galerij slik",
"File galleries Stats" => "Statistika galerij datotek",
"Average files per gallery" => "Povprečje datotek na galerijo",
"Total size of files" => "Skupna velikost datotek",
"Average file size" => "Povprečna velikost datoteke",
"Visits to file galleries" => "Obiski galerij datotek",
"CMS Stats" => "CMS statistika",
"Total reads" => "Skupno število obledov",
"Average reads per article" => "Poprečno število ogledov na članek",
"Total articles size" => "Skupna velikost člankov",
"Average article size" => "Povprečna velikost članka",
"Forum Stats" => "Statistika forumov",
"Total topics" => "Skupno število tem",
"Average topics per forums" => "Povprečje tem na forum",
"Total replies" => "Skupno število odgovorov",
"Average number of replies per topic" => "Povprečno število odgovorov na temo",
"Visits to forums" => "Število obiskov na forumih",
"Blog Stats" => "Statistika blogov",
"Weblogs" => "Blogi",
"Total posts" => "Skupno število prispevkov",
"Average posts per weblog" => "Povprečje število prispevkov na blog",
"Total size of blog posts" => "Skupna velikost prispevkov na blogih",
"Average posts size" => "Povprečna velikost prispevka",
"Visits to weblogs" => "Skupno število obiskov na blogih",
"Poll Stats" => "Statistika spletnih anket",
"Total votes" => "Skupno število glasov",
"Average votes per poll" => "Povprečno število glasov na spletno anketo",
"FAQ Stats" => "Statistika vprašanj in odgovorov (FAQ)",
"Total questions" => "Skupno število vprašanj",
"Average questions per FAQ" => "Povprečno število vprašanj na FAQ",
"User Stats" => "Statistika uporabnikov",
"Average bookmarks per user" => "Povprečje zaznamkov na uporabnika",
"Average questions per quiz" => "Povprečno število vprašanj na kviz",
"Quizzes taken" => "Odgovorjeni kvizi",
"Average quiz score" => "Povprečen rezultat v kvizu",
"Average time per quiz" => "Povprečen čas za kviz",
"Usage chart" => "Grafikoni uporabe",
"Usage chart image" => "Slika grafikonov uporabe",
"Thank you for your submission" => "Hvala za vašo predložitev",
"Send a link to a friend" => "Pošlji povezavo prijatelju",
"Your email was sent" => "Vaša e-pošta je bila poslana",
"The link was sent to the following addresses:" => "Povezava je bila poslana na te naslove:",
"Friend's email" => "E-naslov prijatelja",
"Separate multiple email addresses with a comma." => "Več naslovov ločite z vejico.",
"Your name" => "Vaše ime",
"Your email" => "Vaš e-naslov",
"I found an interesting page that I thought you would like." => "Našel sem zanimivo stran, za katero se mi zdi da bi te utegnila zanimati.",
"TikiTests Edit" => "Urejanje Tiki testa",
"Show Page Differences" => "Pokaži razlike strani",
"Use Current Session/Logout" => "Uporabi trenutno sejo/odjavo",
"Assign themes to categories" => "Določi teme za kategorije",
"Assigned categories" => "Določene kategorije",
"Assign themes to objects" => "Določi teme objektom",
"Assigned objects" => "Določeni objekti",
"Assign themes to sections" => "Določi teme v sekcije",
"Assigned sections" => "Določene sekcije",
"Edit File:" => "Uredite datoteko:",
"You locked the file" => "Zaklenil si datoteko",
"The file is locked by {\$fileInfo.lockedby}" => "Datoteko je zaklenil {\$fileInfo.lockedby}",
"required field for podcasts" => "zahtevana polja za podcaste",
"Batch Upload Results" => "Rezultati paketnega (batch) nalaganja",
"Upload successful!" => "Nalaganje je bilo uspešno!",
"The following image was successfully uploaded" => "Slika je bila uspešno naložena",
"Image ID thumb" => "ID slike thumb",
"You can include the image in an Wiki page using" => "Lahko vključiš sliko v wiki stran s pomočjo",
"or use filename" => "ali uporabi ime datoteke",
"Now enter the image URL" => "Sedaj vnesi URL slike",
"Thumbnail (optional, overrides automatic thumbnail generation)" => "Miniaturna sličica (Thumbnail) (opcija, povozi avtomatsko generiranje miniaturne sličice (thumbnail))",
"No gallery available." => "Ni galerije.",
"You have to create a gallery first!" => "Najprej moraš ustvariti galerijo!",
"User assigned modules" => "Moduli, ki jih je določil uporabnik",
"Assign module" => "Določi modul",
"Column" => "Kolona",
"Folders" => "Mape",
"Folder in" => "Mape v",
"Remove Folder" => "Odstrani mapo",
"Refresh Cache" => "Osveži Cache",
"Admin folders and bookmarks" => "Administriraj mape in zaznamke",
"a folder" => "mapa",
"User Contacts Preferences" => "Uporabnikove izbire za kontakte",
"Manage Fields" => "Upravljaj polja",
"Send me a message" => "Pošlji sporočilo",
"Assign Group" => "Določi skupino",
"Change user preferences" => "Spremenite uporabnikove izbirne nastavitve",
"Homepage" => "Domača stran",
"Users HomePage" => "Domača stran uporabnika",
"Personal Wiki Page" => "Osebna wiki stran",
"Create page" => "Ustvari stran",
"Notify sender when reading his mail" => "Obvesti avtorja ko preberem njegovo e-pošto",
"Edit task" => "Uredite nalogo(task)",
"NOT accept" => "NI sprejeto",
"Remove from Trash" => "Odstranite iz odpada",
"Move into Trash" => "Prestavite v odpad",
"Edit Task" => "Uredite nalogo(task)",
"All Shared Tasks" => "Vse skupne (shared) naloge",
"Start:" => "Začetek:",
"End:" => "Konec:",
"Created by:" => "Ustvaril:",
"Use \"watches\" to monitor wiki pages or other objects." => "Uporabi \"Opazovanja\" za spremljanje wiki strani ali drugih objektov.",
"Watch new items by clicking the {icon _id=eye} button on specific pages." => "Opazuj novosti tako da kliknete {icon _id=eye} gumb na željenih straneh.",
"Add Watch" => "Dodaj opazovanje",
"A user submits an article" => "Uporabnik pošlje članek",
"A user submits a blog post" => "Uporabnik predloži blogovski zapis",
"A user posts a forum thread" => "Uporabnik pošlje forum nit (thread)",
"A user posts a forum topic" => "Uporabnik pošlje temo na forum",
"A user edited a wiki page" => "Uporabnik je urejal wiki stran",
"A user created a wiki page in a language" => "Uporabnik je ustvaril wiki stran v jeziku",
"Used space:" => "Uporabljen prostor:",
"up to" => "do",
"Add or edit an item" => "Dodaj ali uredi postavko",
"Proceed at your own peril" => "Nadaljuj na svoj peril",
"Remove Row" => "Odstrani vrstico",
"Remove Column" => "Odstrani kolono",
"Hours" => "Ure",
"Weekdays" => "Dnevi v tednu",
"mon" => "pon",
"tue" => "tor",
"wed" => "sre",
"thu" => "čet",
"fri" => "pet",
"sat" => "sob",
"sun" => "ned",
"Editing posts" => "Urejanje prispevkov",
"for links" => "za povezave",
"HTML tags are not allowed inside posts" => "HTML značke niso dovoljene znotraj prispevkov",
"Move Selected Topics" => "Prestavi izbrane teme",
"Lock Selected Topics" => "Zaklenite izbrane teme",
"posts in this forum" => "prispevkov v tem forumu",
"All posts" => "Vsi prispevki",
"Show posts" => "Pokaži prospevke",
"Add a Comment" => "Dodajte komentar",
"Edit/Delete" => "Uredite/Izbrišite",
"close" => "zapri",
"Show All" => "Pokaži vse",
"Reply To All" => "Odgovori vsem",
"Cc" => "Kp",
"CC" => "Kp",
"BCC" => "Skp",
"page id" => "stran id",
"3d browser" => "3d brskaljnik",
"Jump to Content" => "Skočite na vsebino",
"Fullscreen" => "Celotni ekran",
"Cancel Fullscreen" => "Prekliči celotni ekran",
"Show/Hide Left Column" => "Pokaži/Skrij levi meni",
"Show/Hide Right Column" => "Pokaži/Skrij desni meni",
"Remove Image" => "Odstrani sliko",
"Other:" => "Drugo:",
"Close:" => "Zapri:",
"List authors:" => "Seznam avtorjev:",
"Save the page, but do not send notifications and do not count it as new content to be translated." => "Shrani stran, toda ne pošlje obvestil in ne šteje kot novo vsebino, ki jo je treba prevesti.",
"Save the page as a draft." => "Shranite stran kot osnutek.",
"Save Draft" => "Shrani osnutek",
"Wiki settings" => "Wiki nastavitve",
"Wiki Attachments" => "Wiki priponke",
"Freetags settings" => "Nastavitve značk",
"Click here to delete the category:" => "Klikni tu za brisanje kategorije:",
"Upload failed" => "Nalaganje ni bilo uspešno",
"All posted" => "Vsi poslani (posted)",
"Queue anonymous posts" => "Postavi v vrsto anonimne prispevke",
"Queue all posts" => "Postavi v vrsto vse prispevke",
"No attachments" => "Brez priponk",
"Everybody can attach" => "Vsakdo lahko pripne",
"Only users with attach permission" => "Samo uporabniki s pripetim dovoljenjem",
"Moderators and admin can attach" => "Modratorji in administratorji lahko pripenjajo",
"Date (desc)" => "Datum (pad)",
"Date (asc)" => "Datum (nar)",
"Detected, Version:" => "Najdena, Verzija:",
"Not detected." => "Ni najdena.",
"Error opening uploaded file" => "Napaka pri odpiranju naložene podatkovne datoteke",
"A user registers" => "Uporabnik se registrira",
"Any wiki page is changed" => "katerakoli wiki stran je spremnjena",
"Any wiki page is changed, even minor changes" => "Katerakoli wiki stran je spremenjena, tudi male spremembe",
"A comment in a wiki page is posted or edited" => "Komentar na wiki strani je dodan ali urejevan",
"You need to provide a username or an email" => "Morate priskrbeti uporabniško ime ali e-naslov.",
"unsafe" => "nevarno (unsafe)",
"safe" => "varno",
"File upload" => "Nalaganje datotek",
"File is not readable. Unable to check." => "Datoteke se ne da prebrati. Ne morem preveriti.",
"This file is from another Tikiwiki version: " => "Ta datoteka je iz druge Tikiwiki verzije: ",
"You have to provide a word" => "zagotoviti moraš besedo",
"Permission denied. You cannot view this page." => "Nimate dovoljenja gledati te strani",
"Permission denied you cannot edit this page" => "Nimaš dovoljenja urejati te strani",
"You must specify a page name, it will be created if it doesn't exist." => "Napisati moraš ime strani. Bo ustvarjena, če še ne obstaja.",
"page not added (Exists)" => "stran ni dodana (že obstaja)",
"No Errors detected" => "Ni najdenih napak.",
"Group already exists" => "Skupina že obstaja",
"Remove group: " => "Odstrani skupino: ",
"Remove permission: %s on %s" => "Odstrani dovoljenje: %s na %s",
"User doesn't exist" => "Uporabnik ne obstaja",
"Invalid or unknown email" => "neveljaven ali nepoznan e-naslov",
"User login or email is required" => "Zahtevano je uporabniško ime ali e-naslove",
"User login is required" => "Zahtevana je prijava uporabnika",
"Password is required" => "Zahtevano je geslo",
"Email is required" => "Zahtevan je e-naslov.",
"User is duplicated" => "Uporabnik je podvojen",
"Upload was successful" => "Nalaganje je bilo uspešno",
"Top visited blogs" => "Najbolj obiskani blogi",
"Last posts" => "Zadnji prispevki",
"Top active blogs" => "Najbolj aktivni blogi",
"Tiki RSS feed for blog: " => "Tiki RSS vir za blog: ",
"Last modifications to the blog." => "Zadnje spremembe v blogu.",
"Nothing tagged yet" => "Nič še ni označkano",
"Access Denied" => "Dostop noi dovoljen",
"Invalid username or activation code. Maybe this code has already been used." => "Neveljavno uporabniško ime ali aktivacijska koda. Morda je bila ta koda že uporabljena.",
"You can not use the same password again" => "Ne smete ponovno uporabiti enakega gesla",
"Invalid old password or unknown user" => "Neveljavno staro geslo ali nepoznan uporabnik",
"Top authors" => "Najboljši avtorji",
"Message sent to" => "Stran poslana na",
"This feature has been disabled" => "Ta lastnost (feature) je bila onemogočena.",
"Last sites." => "zadnje strani.",
"Must enter a name to add a site. " => "Morate vstaviti ime, da bi dodali stran. ",
"Must enter a url to add a site. " => "Morate dodati URL, da bi dodali stran. ",
"Article not found" => "Članek ni najden",
"Permission denied you cannot edit this article" => "Nimate dovoljenja za urejanje tega članka",
"The SandBox is disabled" => "Peskovnik je onemogočen",
"Cannot edit page because it is locked" => "Ne moreš urejati strani, ker je zaklenjena",
"Page already exists. Go back and choose a different name." => "Stran že obstaja. Pojdi nazaj in izberi drugo ime.",
"Remove archive: " => "Odstrani arhiv: ",
"Remove file gallery: " => "Odstrani galerijo podatkovnih datotek: ",
"Permission denied you cannot edit this file" => "Nimaš dovoljenja urejati te datoteke",
"Permission denied you cannot remove files from this gallery" => "Nimaš dovoljenja odstraniti datoteke iz te galerije",
"Top visited file galleries" => "Najbolj obiskane galerije",
"Most downloaded files" => "Najbolj nalagane datoteke",
"Last files" => "Zadnje datoteke",
"Tiki RSS feed for file galleries" => "Tiki RSS vir za galerija datotek",
"Last files uploaded to the file galleries." => "Zadnje naložene datoteke v galerije datotek.",
"No galleryId specified" => "Ni specifiziran Id galerije",
"Tiki RSS feed for the file gallery: " => "Tiki RSS vir za galerijo podatkovnih datotek: ",
"Last forum topics" => "Zadnje teme v forumu",
"Forum posts" => "Prispevki na forumu",
"first uploaded image" => "prva naložena slika",
"last uploaded image" => "zadnja naložena slika",
"first image" => "prva slika",
"last image" => "zadnja slika",
"random image" => "naključna slika",
"Top images" => "Najboljše slike",
"Last images" => "Zadnje slike",
"Remove file: " => "Odstrani datoteko: ",
"Permission denied you can upload files but not to this file gallery" => "Nimate dovoljenja nalagati podatkovnih datotek v to galerijo",
"Cannot read file:" => "Ne morem brati datoteke:",
"Cannot read the file:" => "ne morem brati datoteke:",
"Upload was not successful. Duplicate file content" => "Nalaganje ni bilo uspešno. Podvojena vsebina datoteke.",
"File update was successful" => "Nalaganje datoteke je bilo uspešno",
"Permission denied you can't upload files so you can't edit them" => "Nimate dovoljeja nalagati podatkovnih datotek, zato jih tudi ne morete urejati",
"This gallery does not exist" => "Ta galerija ne obstaja",
"Unable to create login" => "Ni možno ustvariti prijave",
"unknown action" => "neznana akcija",
"Invalid password" => "Neveljavno geslo",
"Account disabled" => "Račun onemogočen",
"No article indicated" => "Ni naznačenih člankov",
"Article is not published yet" => "Članek še ni objavljen",
"Blog not found" => "ne najdem bloga",
"You don't have permission to edit quizzes." => "Nimaš dovoljenja za urejanje kvizov.",
"You must choose a group" => "Izbrati moraš skupino",
"This is not a valid mail adress" => "To ni veljaven e.naslov",
"The passwords don't match" => "Gesli se ne ujemata",
"Username cannot contain uppercase letters" => "Uporabniško ime ne sme vsebovati velikih črk",
"Username must be at least" => "Uporabniško ime mora biti najmanj",
"Username cannot contain more than" => "Uporabniško ime ne sme vsebovati več kot",
"characters" => "znakov",
"Please enter a valid %s.  No spaces, more than %d characters and contain %s" => "Prosim vstavi veljaven %s.  Brez presledkov, več kot %d črk in vsebuje %s",
"Invalid or unknown username" => "Neveljaven ali nepoznan uporabnik",
"Unable to send mail. User has not configured email" => "Ne morem poslati e-pošte. Uporabnik ni oblikoval e-naslova",
"Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password." => "Prosim stopi v stik z administratorjem, če ne moreš dobiti e-pošte ali če ne moreš ponovno nastaviti gesla.",
"The mail can't be sent. Contact the administrator" => "E-pošte ne morem poslati. Stopi v stik z administratorjem",
"An email with a link to reset your password has been sent " => "E-pošta s povezavo za ponovno nastavitev gesla je bila poslana ",
"to the registered email address for" => "na registriran e-naslov za",
"last version" => "zadnja verzija",
"Permission denied you cannot remove versions from this page" => "Nimaš dovoljenja za odstranitev verzij te strani",
"Permission denied you cannot rename this page" => "Nimaš dovoljenja za preimenovanje te strani",
"Cannot rename page maybe new page already exists" => "Ne morem preimenovati strani. Mogoče nova stran že obstaja",
"Non-existent version" => "Neobstoječa verzija",
"Error Message" => "Sporočilo napake",
"No newsletters available." => "Ni biltena.",
"Error: " => "Napaka: ",
"Notice: this variable may not be empty:" => "Obvestilo: ta spremenljivka ne sme biti prazna:",
"empty" => "prazen",
"Permission denied you cannot upload images" => "Nimate dovoljenja za nalaganje slik",
"Permission denied you can upload images but not to this gallery" => "Nimate dovoljenja nalagati slik v to galerijo (sicer lahko nalagate slike)",
"Cannot get image from URL" => "ne morem dobiti slike iz URL-ja",
"Usage" => "Uporaba",
"Unknown user" => "neznan uporabnik",
"You are not logged in and no user indicated" => "Nisi prijavljen in noben uporabnik ni naveden",
"The user has chosen to make his information private" => "Uporabnik je izbral, da bo obdržal svoje informacije kot privatne",
"Password has been changed" => "Geslo je bilo zamenjano",
"Email is set to %s" => "E-naslov je nastavljen na %s",
"The passwords did not match" => "Gesli se ne ujemata",
"no" => "ne",
"Login and click the link below" => "Prijavite se in kliknite spodnje povezavo",
"Non-existent user" => "Uporabnik ne obstaja",
"Top pages" => "Najbolj gledane strani",
"Last pages" => "Zadnje strani",
"Tiki RSS feed for the wiki pages" => "Tiki RSS vir za wiki strani",
"Last modifications to the Wiki." => "Zadnja sprememba v wikiju.",
"Error deleting the file" => "Napaka pri brisanju datoteke",
"TikiTest List" => "Timki testni seznam",
"TikiTest Record" => "zapis Tiki testa",
"The TikiTest Replay File is Empty" => "Ponovitven adatoteka Tiki testa je prazna",
"TikiTest Replay" => "Ponovitev Tiki testa",
"The page is empty" => "Stran je prazna",
"###end###"=>"###end###");
