/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.gui;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import jde.debugger.JDE;
import jde.debugger.JDEException;
import jde.debugger.Protocol;
import jde.debugger.gui.ArrayModel;
import jde.debugger.gui.LVTreeNode;
import jde.debugger.gui.NullModel;
import jde.debugger.gui.ObjectModel;
import jde.debugger.gui.ReferenceModel;

class ReferenceTreeNode
extends LVTreeNode
implements Protocol {
    private ReferenceModel m_model;
    private MutableTreeNode[] m_children;

    protected ReferenceTreeNode(String name, String typeName, Value val, DefaultTreeModel model) throws JDEException {
        super(name, typeName, val, model);
        if (!(this.m_type instanceof ReferenceType) && val != null) {
            throw new JDEException("ReferenceTreeNode received non-object reference Type " + this.m_type.name());
        }
        if (null != val && !(val instanceof ObjectReference)) {
            JDE.debug(64, "Incorrect Value type in ReferenceTreeNode constructor");
            JDE.debug(64, "val=" + val);
            JDE.debug(64, "val.type()=" + val.type());
            throw new JDEException("ReferenceTreeNode received non-object reference value " + val.type().name());
        }
    }

    protected void valueChanged(Value newValue) {
        this.m_model = null == newValue ? new NullModel() : (newValue instanceof ArrayReference ? new ArrayModel((ArrayReference)newValue, this.getModel()) : new ObjectModel((ObjectReference)newValue, this.getModel()));
        if (this.getAllowsChildren()) {
            if (null == this.m_children) {
                this.m_children = new MutableTreeNode[this.m_model.getChildCount()];
            } else if (this.m_children.length != this.m_model.getChildCount()) {
                MutableTreeNode[] newChildren = new MutableTreeNode[this.m_model.getChildCount()];
                System.arraycopy(this.m_children, 0, newChildren, 0, Math.min(this.m_children.length, newChildren.length));
                this.m_children = newChildren;
            }
        } else {
            this.m_children = null;
        }
        this.m_model.updateChildren(this.m_children);
    }

    public int getChildCount() {
        if (null == this.m_children) {
            return 0;
        }
        return this.m_children.length;
    }

    public boolean getAllowsChildren() {
        return this.m_model.getAllowsChildren();
    }

    String getValue() {
        return this.m_model.getValue();
    }

    public int getIndex(TreeNode treeNode) {
        int index = 0;
        while (index < this.m_children.length) {
            if (this.m_children[index] == treeNode) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public Enumeration children() {
        return Collections.enumeration(Arrays.asList(this.m_children));
    }

    public TreeNode getChildAt(int childIndex) {
        try {
            if (null == this.m_children[childIndex]) {
                this.m_children[childIndex] = this.m_model.createChildAt(childIndex);
                this.m_children[childIndex].setParent(this);
            }
        }
        catch (JDEException exc) {
            this.m_children[childIndex] = new DefaultMutableTreeNode("Error displaying data: " + exc.getMessage());
        }
        return this.m_children[childIndex];
    }

    public boolean isLeaf() {
        return null == this.m_children || this.m_children.length == 0;
    }

    protected LVTreeNode getExistingChildAt(int childIndex) {
        if (null == this.m_children[childIndex] || !(this.m_children[childIndex] instanceof LVTreeNode)) {
            return null;
        }
        return (LVTreeNode)this.m_children[childIndex];
    }

    protected int getExistingChildLength() {
        return this.m_children.length;
    }

    protected String paramString() {
        return super.paramString() + ",m_model=" + this.m_model + ",m_children=" + this.m_children + (null == this.m_children ? "" : "[" + this.m_children.length + "]");
    }
}

