/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import com.sun.jdi.BooleanValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ExceptionRequest;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jde.debugger.Debugger;
import jde.debugger.Etc;
import jde.debugger.EventSetEvent;
import jde.debugger.EventSetListener;
import jde.debugger.JDE;
import jde.debugger.JDEException;
import jde.debugger.Protocol;
import jde.debugger.Rep;
import jde.debugger.spec.EventRequestSpec;
import jde.debugger.spec.WatchpointSpec;

public class EventHandler
extends Thread
implements Protocol {
    static final int EVTQ_TIMEOUT = 2000;
    private boolean m_connected = true;
    private final Debugger m_debugger;
    boolean m_stopRequested = false;
    boolean resumeApp;
    private final Collection m_eventSetListeners;

    public EventHandler(Debugger debugger) {
        super("Event Handler for process " + debugger.getProcID());
        this.m_debugger = debugger;
        this.m_eventSetListeners = new LinkedList();
        this.addEventSetListener(new EvtListener());
    }

    public void shutdown() {
        this.m_stopRequested = true;
    }

    public void run() {
        EventQueue queue = this.m_debugger.getVM().eventQueue();
        while (!this.m_stopRequested && this.m_connected) {
            try {
                EventSetListener listener;
                Iterator iter;
                EventSet eventSet = queue.remove(2000L);
                if (eventSet == null) {
                    JDE.debug(16, "EventHandler " + this.m_debugger.getProcID() + " timed out");
                    continue;
                }
                this.resumeApp = true;
                ThreadReference eventThread = this.getCurrentThread(eventSet);
                EventSetEvent event = new EventSetEvent(eventSet, eventThread, !this.resumeApp);
                JDE.debug(16, "EventHandler: sending event " + event);
                Iterator iter2 = this.m_eventSetListeners.iterator();
                while (iter2.hasNext()) {
                    EventSetListener listener2 = (EventSetListener)iter2.next();
                    listener2.eventSetReceived(event);
                }
                if (this.resumeApp) {
                    iter = this.m_eventSetListeners.iterator();
                    while (iter.hasNext()) {
                        listener = (EventSetListener)iter.next();
                        JDE.debug(16, "EventHandler: sending resume event to " + listener);
                        try {
                            listener.debuggerResumed(event);
                        }
                        catch (RuntimeException exc) {
                            JDE.signalException(exc);
                        }
                    }
                    JDE.debug(16, "EventHandler: VM resumed");
                    continue;
                }
                JDE.debug(16, "EventHandler: VM not resumed");
                iter = this.m_eventSetListeners.iterator();
                while (iter.hasNext()) {
                    listener = (EventSetListener)iter.next();
                    JDE.debug(16, "EventHandler: sending suspended event to " + listener);
                    listener.debuggerSuspended(event);
                }
            }
            catch (InterruptedException ex) {
                JDE.debug(8, ex.toString());
            }
            catch (VMDisconnectedException ex) {
                JDE.debug(8, ex.toString());
                this.handleDisconnectedException(queue);
            }
            catch (RuntimeException ex) {
                JDE.debug(8, ex.toString());
                ex.printStackTrace();
            }
        }
        JDE.debug(16, "event handler: " + this.m_debugger.getProcID() + " terminated");
    }

    private String handleEvent(Event event) {
        if (event instanceof BreakpointEvent) {
            return this.breakpointEvent((BreakpointEvent)event);
        }
        if (event instanceof StepEvent) {
            return this.stepEvent((StepEvent)event);
        }
        if (event instanceof WatchpointEvent) {
            return this.watchpointEvent((WatchpointEvent)event);
        }
        if (event instanceof ExceptionEvent) {
            return this.exceptionEvent((ExceptionEvent)event);
        }
        if (event instanceof ThreadStartEvent) {
            return this.threadStartEvent((ThreadStartEvent)event);
        }
        if (event instanceof ThreadDeathEvent) {
            return this.threadDeathEvent((ThreadDeathEvent)event);
        }
        if (event instanceof MethodEntryEvent) {
            return this.methodEntryEvent((MethodEntryEvent)event);
        }
        if (event instanceof MethodExitEvent) {
            return this.methodExitEvent((MethodExitEvent)event);
        }
        if (event instanceof ClassPrepareEvent) {
            return this.classPrepareEvent((ClassPrepareEvent)event);
        }
        if (event instanceof VMStartEvent) {
            return this.vmStartEvent((VMStartEvent)event);
        }
        if (event instanceof VMDeathEvent) {
            return this.vmDeathEvent((VMDeathEvent)event);
        }
        if (event instanceof VMDisconnectEvent) {
            return this.vmDisconnectEvent((VMDisconnectEvent)event);
        }
        return this.otherEvent(event);
    }

    private String otherEvent(Event event) {
        this.resumeApp &= true;
        return "(list 'jde-dbo-event-other)";
    }

    private void handleDisconnectedException(EventQueue queue) {
        int numberOfTimeoutsBeforeQuit = 5;
        int currentNumberOfTimeouts = 0;
        JDE.debug(16, "handling disconnected exception");
        while (this.m_connected) {
            try {
                JDE.debug(16, "handling disconnected exception loop");
                EventSet eventSet = queue.remove(2000L);
                if (eventSet == null) {
                    if (++currentNumberOfTimeouts < numberOfTimeoutsBeforeQuit) continue;
                    JDE.signal(this.m_debugger.getProcID(), "error", "no vmDisconnectEvent found in handleDisconnectedException after " + currentNumberOfTimeouts + " timeouts, terminating anyway!", true);
                    this.m_connected = false;
                    continue;
                }
                JDE.debug(16, "disc. exc: got an event set");
                EventIterator iter = eventSet.eventIterator();
                while (iter.hasNext()) {
                    Event evt = (Event)iter.next();
                    if (evt instanceof VMDeathEvent) {
                        this.vmDeathEvent(evt);
                        continue;
                    }
                    if (!(evt instanceof VMDisconnectEvent)) continue;
                    this.vmDisconnectEvent(evt);
                }
            }
            catch (InterruptedException ex) {
                JDE.debug(8, ex.toString());
            }
        }
    }

    private ThreadReference getCurrentThread(EventSet eventSet) {
        ThreadReference thread;
        if (eventSet.size() > 0) {
            Event event = (Event)eventSet.iterator().next();
            thread = this.getEventThread(event);
        } else {
            thread = null;
        }
        return thread;
    }

    private ThreadReference getEventThread(Event event) {
        if (event instanceof ClassPrepareEvent) {
            return ((ClassPrepareEvent)event).thread();
        }
        if (event instanceof LocatableEvent) {
            return ((LocatableEvent)event).thread();
        }
        if (event instanceof ThreadStartEvent) {
            return ((ThreadStartEvent)event).thread();
        }
        if (event instanceof ThreadDeathEvent) {
            return ((ThreadDeathEvent)event).thread();
        }
        if (event instanceof VMStartEvent) {
            return ((VMStartEvent)event).thread();
        }
        return null;
    }

    private String threadMatch(Event event) {
        Object thread = event.request().getProperty(EventRequestSpec.threadKey);
        if (thread == null) {
            return "nil";
        }
        if (thread instanceof Long) {
            ThreadReference t = this.getEventThread(event);
            if (t.uniqueID() == ((Long)thread).longValue()) {
                return "(list \"on_thread_id\" " + t.uniqueID() + ")";
            }
            return null;
        }
        if (thread instanceof String) {
            ThreadReference tRef = this.m_debugger.getThreadReference(thread.toString());
            ThreadReference t = this.getEventThread(event);
            if (t.equals(tRef)) {
                return "(list \"on_thread_name\" \"" + thread.toString() + "\")";
            }
            return null;
        }
        return "\"Error matching thread\"";
    }

    private String expressionSuccess(Event event) {
        Object exprObject = event.request().getProperty(EventRequestSpec.expressionKey);
        if (exprObject != null) {
            String expr = exprObject.toString();
            try {
                StackFrame frame = this.getEventThread(event).frame(0);
                Value val = Etc.evaluate(expr, frame);
                if (!val.type().name().equals("boolean")) {
                    return "\"Expression evaluates to non-boolean\"";
                }
                BooleanValue boolValue = (BooleanValue)val;
                if (boolValue.value()) {
                    return "(list \"" + expr + "\")";
                }
                return null;
            }
            catch (Exception ex) {
                JDE.debug(8, ex.toString());
                return "\"Expression didn't evaluate correctly\"";
            }
        }
        return "nil";
    }

    private String objectIDMatches(WatchpointEvent event) {
        Object idObject = event.request().getProperty(WatchpointSpec.objectIDKey);
        if (idObject == null) {
            return "nil";
        }
        if (idObject instanceof Long) {
            Long id = (Long)idObject;
            if (event.object() == null) {
                return "(list " + id + ")";
            }
            if (event.object().uniqueID() == id.longValue()) {
                return "(list " + id + ")";
            }
            return null;
        }
        return "\"Object ID was not a Long\"";
    }

    private String breakpointEvent(BreakpointEvent event) {
        String threadString;
        JDE.debug(4, "got a BreakpointEvent");
        Long specID = ((EventRequestSpec)event.request().getProperty(EventRequestSpec.specPropertyKey)).getID();
        ThreadReference thread = event.thread();
        if (thread != null) {
            this.m_debugger.getStore().put(thread);
        }
        if ((threadString = this.threadMatch(event)) == null) {
            this.resumeApp &= true;
            return null;
        }
        String exprString = this.expressionSuccess(event);
        if (exprString == null) {
            this.resumeApp &= true;
            return null;
        }
        this.resumeApp &= false;
        return "(list 'jde-dbo-breakpoint-hit-event " + specID + Protocol.BR + Rep.getLocationRep(event.location()) + " " + threadString + " " + exprString + ")";
    }

    private String stepEvent(StepEvent event) {
        JDE.debug(4, "got a STEP event");
        this.resumeApp &= false;
        return "(list 'jde-dbo-step-event " + Rep.getLocationRep(event.location()) + ")";
    }

    private String watchpointEvent(WatchpointEvent event) {
        JDE.debug(4, "got a WATCHPOINT event");
        Long specID = ((EventRequestSpec)event.request().getProperty(EventRequestSpec.specPropertyKey)).getID();
        String threadString = this.threadMatch(event);
        if (threadString == null) {
            this.resumeApp &= true;
            return null;
        }
        String exprString = this.expressionSuccess(event);
        if (exprString == null) {
            this.resumeApp &= true;
            return null;
        }
        String objectIDString = this.objectIDMatches(event);
        if (objectIDString == null) {
            this.resumeApp &= true;
            return null;
        }
        String fieldValueString = Rep.getFieldValueRep(event.field(), event.valueCurrent());
        String objectString = Rep.getObjectRep(event.object());
        this.resumeApp &= false;
        return "(list 'jde-dbo-watchpoint-hit-event " + specID + Protocol.BR + objectString + Protocol.BR + fieldValueString + Protocol.BR + Rep.getLocationRep(event.location()) + Protocol.BR + objectIDString + " " + threadString + " " + exprString + ")";
    }

    private String exceptionEvent(ExceptionEvent event) {
        JDE.debug(4, "got an EXCEPTION event");
        if (event.request() == null) {
            this.resumeApp &= true;
            return null;
        }
        Long specID = ((EventRequestSpec)event.request().getProperty(EventRequestSpec.specPropertyKey)).getID();
        ExceptionRequest request = (ExceptionRequest)event.request();
        String threadString = this.threadMatch(event);
        if (threadString == null) {
            this.resumeApp &= true;
            return null;
        }
        this.resumeApp &= false;
        return "(list 'jde-dbo-exception-event " + specID + Protocol.BR + Rep.getObjectRep(event.exception()) + Protocol.BR + threadString + ")";
    }

    private String methodEntryEvent(MethodEntryEvent event) {
        JDE.debug(4, "got a METHOD ENTRY event");
        this.resumeApp &= false;
        return "(list 'jde-dbo-method-entry-event" + Protocol.BR + Rep.getMethodRep(event.method()) + ")";
    }

    private String methodExitEvent(MethodExitEvent event) {
        JDE.debug(4, "got a METHOD EXIT event");
        this.resumeApp &= false;
        return "(list 'jde-dbo-method-exit-event" + Protocol.BR + Rep.getMethodRep(event.method()) + ")";
    }

    private String threadStartEvent(ThreadStartEvent event) {
        JDE.debug(4, "got a THREAD START event");
        this.m_debugger.getStore().put(event.thread());
        this.resumeApp &= false;
        return "(list 'jde-dbo-thread-start-event" + Protocol.BR + Rep.getThreadRep(event.thread()) + ")";
    }

    private String threadDeathEvent(ThreadDeathEvent event) {
        JDE.debug(4, "got a THREAD DEATH event");
        this.resumeApp &= false;
        return "(list 'jde-dbo-thread-death-event" + Protocol.BR + Rep.getThreadRep(event.thread()) + ")";
    }

    private String classPrepareEvent(ClassPrepareEvent event) {
        this.m_debugger.getEventRequestSpecList().resolve(event.referenceType());
        EventRequest request = event.request();
        if (request.getProperty("default") == null) {
            this.resumeApp &= false;
            return "(list 'jde-dbo-class-prepare-event \"" + event.referenceType().name() + "\")";
        }
        this.resumeApp &= true;
        return null;
    }

    private String classUnloadEvent(ClassUnloadEvent event) {
        JDE.debug(4, "got a CLASS UNLOAD event");
        this.resumeApp &= false;
        return "(list 'jde-dbo-class-unload-event \"" + event.className() + "\")";
    }

    private String vmStartEvent(Event event) {
        JDE.debug(4, "got a VM START event");
        ThreadReference thread = this.getEventThread(event);
        this.m_debugger.getStore().put(thread);
        this.resumeApp &= false;
        return "(list 'jde-dbo-vm-start-event)";
    }

    private String vmDeathEvent(Event event) {
        JDE.debug(4, "got a VM DEATH event");
        this.resumeApp &= true;
        return "(list 'jde-dbo-vm-death-event)";
    }

    private String vmDisconnectEvent(Event event) {
        JDE.debug(4, "got a VM DISCONNECT event");
        this.m_connected = false;
        this.resumeApp &= true;
        try {
            this.m_debugger.shutdown();
        }
        catch (JDEException e) {
            JDE.signal(this.m_debugger.getProcID(), "error", "EventHandler.vmDisconnectEvent() caught exception: " + e, true);
        }
        return "(list 'jde-dbo-vm-disconnected-event)";
    }

    void addEventSetListener(EventSetListener listener) {
        if (this.m_eventSetListeners.contains(listener)) {
            return;
        }
        this.m_eventSetListeners.add(listener);
    }

    void removeEventSetListener(EventSetListener listener) {
        this.m_eventSetListeners.remove(listener);
    }

    private class EvtListener
    implements EventSetListener {
        private final List events = new LinkedList();
        private String suspendStateString;

        private EvtListener() {
        }

        public void eventSetReceived(EventSetEvent evt) {
            this.events.clear();
            EventIterator it = evt.getEventSet().eventIterator();
            while (it.hasNext()) {
                String eventLispDescription = EventHandler.this.handleEvent(it.nextEvent());
                if (eventLispDescription == null) continue;
                this.events.add(eventLispDescription);
            }
        }

        public void debuggerSuspended(EventSetEvent evt) {
            switch (evt.getEventSet().suspendPolicy()) {
                case 2: {
                    this.suspendStateString = "all";
                    break;
                }
                case 1: {
                    this.suspendStateString = "thread";
                    break;
                }
                case 0: {
                    this.suspendStateString = "none";
                    evt.getEventSet().resume();
                    break;
                }
                default: {
                    this.suspendStateString = "invalid";
                }
            }
            this.finishEventSet(evt);
        }

        public void debuggerResumed(EventSetEvent evt) {
            this.suspendStateString = "none";
            this.finishEventSet(evt);
            evt.getEventSet().resume();
            JDE.debug(16, "EventHandler: VM resumed");
        }

        private void finishEventSet(EventSetEvent evt) {
            StringBuffer eventSetString = new StringBuffer("\"");
            eventSetString.append(this.suspendStateString);
            eventSetString.append("\"");
            ThreadReference eventThread = evt.getThreadReference();
            if (eventThread == null) {
                eventSetString.append(" nil");
            } else {
                eventSetString.append(Protocol.BR);
                eventSetString.append(Rep.getThreadRep(eventThread));
            }
            Iterator iter = this.events.iterator();
            while (iter.hasNext()) {
                eventSetString.append(Protocol.BR);
                eventSetString.append(iter.next().toString());
            }
            JDE.signal(EventHandler.this.m_debugger.getProcID(), "event-set", eventSetString.toString(), false);
        }
    }
}

