##############################################################################
#
# __init__.py	Initialization code for the JTracker
#
# This software is governed by a license. See
# LICENSE.txt for the terms of this license.
# 
##############################################################################

__doc__     = """ JTracker initialization module """
__version__ = '$Revision: 1.4 $'[11:-2]

from Permissions import ManageJTracker, SubmitJTrackerIssues
from Globals import ImageFile
from JTracker import addJTrackerForm, \
                     manage_addJTracker, \
                     JTracker
from JTrackerIssue import JTrackerIssue, \
                          manage_addJTrackerIssue, \
                          addJTrackerIssueForm

try:
    from Products import BTreeFolder2
    from JTracker import BTreeJTracker
except:
    BTreeFolder2 = None

try:
    from Products.ViewsManager.ViewsManager import registerType
    registerType(JTracker.meta_type, JTracker._views)
    registerType(JTrackerIssue.meta_type, JTrackerIssue._views)
except ImportError:
    pass


def initialize(context):
    try:
        if BTreeFolder2 is not None:
            context.registerClass( BTreeJTracker
                                 , permission=ManageJTracker
                                 , constructors=( addJTrackerForm
                                                , manage_addJTracker
                                                )
                                 , icon='www/jtracker.gif'
                                 )
            # Make old JTrackers keep their icons...
            JTracker.icon = 'misc_/JTracker/jtracker.gif'

        else:
            context.registerClass( JTracker
                                 , permission=ManageJTracker
                                 , constructors=( addJTrackerForm
                                                , manage_addJTracker
                                                )
                                 , icon='www/jtracker.gif'
                                 )

        context.registerClass( JTrackerIssue
                             , permission=SubmitJTrackerIssues
                             , constructors=( addJTrackerIssueForm
                                            , manage_addJTrackerIssue
                                            )
                             , icon='www/issue.gif'
                             , visibility=None
                             )
    except:
        import traceback; traceback.print_exc()

    context.registerHelp()

