#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2019 BetaRays
# SPDX-FileCopyrightText: © 2021 Mopi
set -o errexit

###
# SpaceChem
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250603.2

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='spacechem'
GAME_NAME='SpaceChem'

ARCHIVE_BASE_0_NAME='spacechem_1016_40617.sh'
ARCHIVE_BASE_0_MD5='aec2809166dbc60a7cfa3f7c22db9a07'
ARCHIVE_BASE_0_SIZE='299942'
ARCHIVE_BASE_0_VERSION='1016-gog40617'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/spacechem'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_MAIN_FILES='
fonts
images
lang
music
sounds
text
Ionic.Zip.dll
Newtonsoft.Json.dll
System.Data.SQLite.dll
SpaceChem.exe
SpaceChem.exe.config
journal.json
scores.json
template.locals
template.user
monoconfig
monomachineconfig
rgb2theora'
CONTENT_DOC_MAIN_FILES='
LICENSE.txt'

APP_MAIN_EXE='SpaceChem.exe'
## FIXME: The binary file is not automatically used as an icon source for Mono games.
##        (./play.it 2.32.4)
APP_MAIN_ICON="$APP_MAIN_EXE"

PKG_MAIN_DEPENDENCIES_LIBRARIES='
libSDL2-2.0.so.0
libSDL2_mixer-2.0.so.0
libvorbisfile.so.3'
PKG_MAIN_DEPENDENCIES_MONO_LIBRARIES='
mscorlib.dll
I18N.dll
I18N.West.dll
Mono.Posix.dll
Mono.Security.dll
System.dll
System.ComponentModel.DataAnnotations.dll
System.Configuration.dll
System.Core.dll
System.Data.dll
System.Drawing.dll
System.Numerics.dll
System.Runtime.Serialization.dll
System.Security.dll
System.Transactions.dll
System.Xml.dll
System.Xml.Linq.dll'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Set required execution permission on the rgb2theora binary.
	# This binary is used to generate .ogv video clips from puzzle solutions.
	chmod 755 'rgb2theora'
)

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
