#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The House of Da Vinci
# send your bug reports to bugs@dotslashplay.it
###

script_version=20240930.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='the-house-of-da-vinci'
GAME_NAME='The House of Da Vinci'

ARCHIVE_BASE_0_NAME='setup_the_house_of_da_vinci_1.0.3_(64bit)_(52072).exe'
ARCHIVE_BASE_0_MD5='2cf6dce4524fe1b2ce1429f19438c38f'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_the_house_of_da_vinci_1.0.3_(64bit)_(52072)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='3b3e636a1697fa84161b57fc18bfacba'
ARCHIVE_BASE_0_SIZE='2700000'
ARCHIVE_BASE_0_VERSION='1.0.3-gog52072'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/the_house_of_da_vinci'

UNITY3D_NAME='the house of da vinci'

CONTENT_PATH_DEFAULT='the house of da vinci'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/LocalLow/Blue Brain Games/The House of da Vinci'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
