#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Nomads of Driftland
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250513.6

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='nomads-of-driftland'
GAME_NAME='Nomads of Driftland'

ARCHIVE_BASE_0_NAME='setup_nomads_of_driftland_nomads_1.0.48a_(64bit)_(44177).exe'
ARCHIVE_BASE_0_MD5='9745838e34b9412aaf0cc538264cd289'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_nomads_of_driftland_nomads_1.0.48a_(64bit)_(44177)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='74032f57b81ae76040e9d9ec18d829d4'
ARCHIVE_BASE_0_SIZE='2711794'
ARCHIVE_BASE_0_VERSION='1.0.48a-gog44177'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/nomads_of_driftland'

UNREALENGINE4_NAME='nomads'

CONTENT_PATH_DEFAULT='.'

APP_MAIN_EXE="${UNREALENGINE4_NAME}.exe"

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Drop the shipped installer for Unreal Engine 4 runtime requirements.
	rm --recursive 'engine/extras'
)

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

## Do not install the Visual C++ Runtime, as it triggers an unending loop of UE4 Prerequisites install/uninstall.
unrealengine4_wine_winetricks_verbs_default() { return 0; }

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
