# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "netappfiles pool update",
)
class Update(AAZCommand):
    """Update a capacity pool

    Update the specified ANF capacity pool

    :example: Update specific values for an ANF pool
        az netappfiles pool update -g mygroup --account-name myaccname --name mypoolname --tags mytag1=abcd mytag2=efgh
    """

    _aaz_info = {
        "version": "2025-06-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.netapp/netappaccounts/{}/capacitypools/{}", "2025-06-01"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    AZ_SUPPORT_GENERIC_UPDATE = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.account_name = AAZStrArg(
            options=["-a", "--account-name"],
            help="The name of the NetApp account",
            required=True,
            id_part="name",
            fmt=AAZStrArgFormat(
                pattern="^[a-zA-Z0-9][a-zA-Z0-9\\-_]{0,127}$",
            ),
        )
        _args_schema.pool_name = AAZStrArg(
            options=["-n", "-p", "--name", "--pool-name"],
            help="The name of the capacity pool",
            required=True,
            id_part="child_name_1",
            fmt=AAZStrArgFormat(
                pattern="^[a-zA-Z0-9][a-zA-Z0-9\\-_]{0,63}$",
                max_length=64,
                min_length=1,
            ),
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )

        # define Arg Group "Body"

        _args_schema = cls._args_schema
        _args_schema.tags = AAZDictArg(
            options=["--tags"],
            arg_group="Body",
            help="Resource tags.",
            nullable=True,
        )

        tags = cls._args_schema.tags
        tags.Element = AAZStrArg(
            nullable=True,
        )

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.cool_access = AAZBoolArg(
            options=["--cool-access"],
            arg_group="Properties",
            help="If enabled (true) the pool can contain cool Access enabled volumes.",
            nullable=True,
        )
        _args_schema.custom_throughput_mibps = AAZFloatArg(
            options=["--custom-throughput", "--custom-throughput-mibps"],
            arg_group="Properties",
            help="Maximum throughput in MiB/s that can be achieved by this pool and this will be accepted as input only for manual qosType pool with Flexible service level",
            nullable=True,
        )
        _args_schema.qos_type = AAZStrArg(
            options=["--qos-type"],
            arg_group="Properties",
            help="The qos type of the pool",
            nullable=True,
            enum={"Auto": "Auto", "Manual": "Manual"},
        )
        _args_schema.service_level = AAZStrArg(
            options=["--service-level"],
            arg_group="Properties",
            help="serviceLevel",
            enum={"Flexible": "Flexible", "Premium": "Premium", "Standard": "Standard", "StandardZRS": "StandardZRS", "Ultra": "Ultra"},
        )
        _args_schema.size = AAZIntArg(
            options=["--size"],
            arg_group="Properties",
            help="Provisioned size of the pool. Must be an integer number of tebibytes in multiples of 4",
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.PoolsGet(ctx=self.ctx)()
        self.pre_instance_update(self.ctx.vars.instance)
        self.InstanceUpdateByJson(ctx=self.ctx)()
        self.InstanceUpdateByGeneric(ctx=self.ctx)()
        self.post_instance_update(self.ctx.vars.instance)
        yield self.PoolsCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    @register_callback
    def pre_instance_update(self, instance):
        pass

    @register_callback
    def post_instance_update(self, instance):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class PoolsGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "accountName", self.ctx.args.account_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "poolName", self.ctx.args.pool_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2025-06-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _UpdateHelper._build_schema_capacity_pool_read(cls._schema_on_200)

            return cls._schema_on_200

    class PoolsCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "location"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200, 201]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "location"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "accountName", self.ctx.args.account_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "poolName", self.ctx.args.pool_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2025-06-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=self.ctx.vars.instance,
            )

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()
            _UpdateHelper._build_schema_capacity_pool_read(cls._schema_on_200_201)

            return cls._schema_on_200_201

    class InstanceUpdateByJson(AAZJsonInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance(self.ctx.vars.instance)

        def _update_instance(self, instance):
            _instance_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=instance,
                typ=AAZObjectType
            )
            _builder.set_prop("properties", AAZObjectType, ".", typ_kwargs={"flags": {"required": True, "client_flatten": True}})
            _builder.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("coolAccess", AAZBoolType, ".cool_access")
                properties.set_prop("customThroughputMibps", AAZFloatType, ".custom_throughput_mibps", typ_kwargs={"nullable": True})
                properties.set_prop("qosType", AAZStrType, ".qos_type")
                properties.set_prop("serviceLevel", AAZStrType, ".service_level", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("size", AAZIntType, ".size", typ_kwargs={"flags": {"required": True}})

            tags = _builder.get(".tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            return _instance_value

    class InstanceUpdateByGeneric(AAZGenericInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance_by_generic(
                self.ctx.vars.instance,
                self.ctx.generic_update_args
            )


class _UpdateHelper:
    """Helper class for Update"""

    _schema_capacity_pool_read = None

    @classmethod
    def _build_schema_capacity_pool_read(cls, _schema):
        if cls._schema_capacity_pool_read is not None:
            _schema.etag = cls._schema_capacity_pool_read.etag
            _schema.id = cls._schema_capacity_pool_read.id
            _schema.location = cls._schema_capacity_pool_read.location
            _schema.name = cls._schema_capacity_pool_read.name
            _schema.properties = cls._schema_capacity_pool_read.properties
            _schema.system_data = cls._schema_capacity_pool_read.system_data
            _schema.tags = cls._schema_capacity_pool_read.tags
            _schema.type = cls._schema_capacity_pool_read.type
            return

        cls._schema_capacity_pool_read = _schema_capacity_pool_read = AAZObjectType()

        capacity_pool_read = _schema_capacity_pool_read
        capacity_pool_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        capacity_pool_read.id = AAZStrType(
            flags={"read_only": True},
        )
        capacity_pool_read.location = AAZStrType(
            flags={"required": True},
        )
        capacity_pool_read.name = AAZStrType(
            flags={"read_only": True},
        )
        capacity_pool_read.properties = AAZObjectType(
            flags={"required": True, "client_flatten": True},
        )
        capacity_pool_read.system_data = AAZObjectType(
            serialized_name="systemData",
            flags={"read_only": True},
        )
        capacity_pool_read.tags = AAZDictType()
        capacity_pool_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_capacity_pool_read.properties
        properties.cool_access = AAZBoolType(
            serialized_name="coolAccess",
        )
        properties.custom_throughput_mibps = AAZFloatType(
            serialized_name="customThroughputMibps",
            nullable=True,
        )
        properties.encryption_type = AAZStrType(
            serialized_name="encryptionType",
            nullable=True,
        )
        properties.pool_id = AAZStrType(
            serialized_name="poolId",
            flags={"read_only": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.qos_type = AAZStrType(
            serialized_name="qosType",
        )
        properties.service_level = AAZStrType(
            serialized_name="serviceLevel",
            flags={"required": True},
        )
        properties.size = AAZIntType(
            flags={"required": True},
        )
        properties.total_throughput_mibps = AAZFloatType(
            serialized_name="totalThroughputMibps",
            flags={"read_only": True},
        )
        properties.utilized_throughput_mibps = AAZFloatType(
            serialized_name="utilizedThroughputMibps",
            flags={"read_only": True},
        )

        system_data = _schema_capacity_pool_read.system_data
        system_data.created_at = AAZStrType(
            serialized_name="createdAt",
        )
        system_data.created_by = AAZStrType(
            serialized_name="createdBy",
        )
        system_data.created_by_type = AAZStrType(
            serialized_name="createdByType",
        )
        system_data.last_modified_at = AAZStrType(
            serialized_name="lastModifiedAt",
        )
        system_data.last_modified_by = AAZStrType(
            serialized_name="lastModifiedBy",
        )
        system_data.last_modified_by_type = AAZStrType(
            serialized_name="lastModifiedByType",
        )

        tags = _schema_capacity_pool_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_capacity_pool_read.etag
        _schema.id = cls._schema_capacity_pool_read.id
        _schema.location = cls._schema_capacity_pool_read.location
        _schema.name = cls._schema_capacity_pool_read.name
        _schema.properties = cls._schema_capacity_pool_read.properties
        _schema.system_data = cls._schema_capacity_pool_read.system_data
        _schema.tags = cls._schema_capacity_pool_read.tags
        _schema.type = cls._schema_capacity_pool_read.type


__all__ = ["Update"]
