'''This QpropertyJsRef module provides JS reference for a given C++ class' Q_PROPERTY statements'''

class QpropertyJsRef:
	'''This class acts as a storage unit for a class JS reference'''


	def __init__(self):

		self.name_space = ""
		self.class_name = ""
		# The C++ statement extracted from the code
		self.statement = ""
		# List of lines making the description
		self.description = [ ]


	def __str__(self):

		return self.get_as_text("  ", 1)


	def get_description_as_text(self, tab, offset):

		lead = offset * tab

		output_text = ""

		for line in self.description:

			output_text = f"{output_text}{lead}{line}\n"

		# print(f"Returning property description:\n{output_text}")

		return output_text


	def print_description(self, tab, offset):

		output_text = self.get_description_as_text(tab, offset)
		return output_text


	def get_as_text(self, tab, offset):

		lead = offset * tab

		output_text = f"{lead}{self.statement}\n"

		if len(self.description):

			indent_offset = offset + 1

			# lead = indent_offset * tab
			# output_text = f"{output_text}{lead}Description:\n"
			# indent_offset += 1

			output_text = f"{output_text}{self.get_description_as_text(tab, indent_offset)}\n"

		# print(f"Returning QpropertyJsRef as text:\n{output_text}")

		return output_text


	def print(self, tab, offset):

		output_text = self.get_as_text(tab, offset)

		print(output_text)




