"""Keywords in the Greenplum Dialect.

https://docs.vmware.com/en/VMware-Greenplum/6/greenplum-database/ref_guide-sql-keywords.html
"""

greenplum_keywords = [
    ("ACTIVE", "non-reserved"),
    ("CONCURRENCY", "non-reserved"),
    ("CONTAINS", "non-reserved"),
    ("CPU_RATE_LIMIT", "non-reserved"),
    ("CPUSET", "non-reserved"),
    ("CREATEEXTTABLE", "non-reserved"),
    ("CUBE", "non-reserved-(cannot-be-function-or-type)"),
    ("DECODE", "reserved"),
    ("DENY", "non-reserved"),
    ("DISTRIBUTED", "reserved"),
    ("DXL", "non-reserved"),
    ("ERRORS", "non-reserved"),
    ("EVERY", "non-reserved"),
    ("EXCHANGE", "non-reserved"),
    # ("EXCLUDE", "reserved"),
    ("EXPAND", "non-reserved"),
    ("FIELDS", "non-reserved"),
    ("FILL", "non-reserved"),
    # ("FOLLOWING", "reserved"),
    ("FORMAT", "non-reserved"),
    ("FULLSCAN", "non-reserved"),
    ("GROUP_ID", "non-reserved-(cannot-be-function-or-type)"),
    ("GROUPING", "non-reserved-(cannot-be-function-or-type)"),
    ("HASH", "non-reserved"),
    ("HOST", "non-reserved"),
    ("IGNORE", "non-reserved"),
    ("INCLUSIVE", "non-reserved"),
    ("LIST", "non-reserved"),
    ("LOG", "reserved-(can-be-function-or-type)"),
    ("MASTER", "non-reserved"),
    ("MEDIAN", "non-reserved-(cannot-be-function-or-type)"),
    ("MEMORY_LIMIT", "non-reserved"),
    ("MEMORY_SHARED_QUOTA", "non-reserved"),
    ("MEMORY_SPILL_RATIO", "non-reserved"),
    ("MISSING", "non-reserved"),
    ("MODIFIES", "non-reserved"),
    ("NEWLINE", "non-reserved"),
    ("NOCREATEEXTTABLE", "non-reserved"),
    ("NOOVERCOMMIT", "non-reserved"),
    ("ORDERED", "non-reserved"),
    ("OTHERS", "non-reserved"),
    ("OVERCOMMIT", "non-reserved"),
    # ("PARTITION", "reserved"),
    ("PARTITIONS", "non-reserved"),
    ("PERCENT", "non-reserved"),
    # ("PRECEDING", "reserved"),
    ("PROTOCOL", "non-reserved"),
    ("QUEUE", "non-reserved"),
    ("RANDOMLY", "non-reserved"),
    ("READABLE", "non-reserved"),
    ("READS", "non-reserved"),
    ("REJECT", "non-reserved"),
    ("REPLICATED", "non-reserved"),
    ("RESOURCE", "non-reserved"),
    ("ROLLUP", "non-reserved-(cannot-be-function-or-type)"),
    ("ROOTPARTITION", "non-reserved"),
    ("SCATTER", "reserved"),
    ("SEGMENT", "non-reserved"),
    ("SEGMENTS", "non-reserved"),
    ("SETS", "non-reserved-(cannot-be-function-or-type)"),
    ("SPLIT", "non-reserved"),
    ("SQL", "non-reserved"),
    ("SUBPARTITION", "non-reserved"),
    ("THRESHOLD", "non-reserved"),
    ("TIES", "non-reserved"),
    # ("UNBOUNDED", "reserved"),
    ("VALIDATION", "non-reserved"),
    ("WEB", "non-reserved"),
    ("WRITABLE", "non-reserved"),
]
