/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev$
 * $Date$
 */
#include "About.hpp"

#include "SplashImage.hpp"
#include "../meta.hpp"
#include "../images/indii.hpp"
#include "../../social/social.hpp"
#include "../../gnome/gnome.hpp"
#include "../reg/Components.hpp"

#include "wx/sizer.h"
#include "wx/gbsizer.h"
#include "wx/statline.h"
#include "wx/stattext.h"
#include "wx/textctrl.h"
#include "wx/statbmp.h"
#include "wx/button.h"
#include "wx/dcmemory.h"
#include "wx/event.h"

#ifdef __WXOSX__
/* modal dialogs shouldn't have close button */
#define INDII_ABOUT_STYLE wxCAPTION
#else
#define INDII_ABOUT_STYLE wxDEFAULT_DIALOG_STYLE
#endif

using namespace indii;

void indii::showAboutDialog(wxWindow* parent, const Components::Component c) {
  About* dlgAbout = new About(parent, c);
  dlgAbout->ShowModal();

  //wxAboutDialogInfo info;
  
#ifdef __WXOSX__
  /* on Mac, generic about dialog is not modal which causes issues in Photoshop,
   * not providing a URL ensures native dialog is used instead */
  //info.SetName(_("indii.org / " PACKAGE_NAME));
  //info.SetVersion(_("Mac"), _(PACKAGE_VERSION));
  //info.SetDescription(_(PACKAGE_DESC));
  //info.SetCopyright(_("Copyright 2007-2015 Lawrence Murray"));
#else
  //info.SetName(_(PACKAGE_NAME));
  //info.SetVersion(_(PACKAGE_VERSION));
  //info.SetDescription(_(PACKAGE_DESC));
  //info.SetWebSite(_("http://www.indii.org/" PACKAGE_TARNAME));
  //info.SetCopyright(_("Copyright 2007-2015 Lawrence Murray"));
#endif
  
#ifndef WX_28
  //wxAboutBox(info, parent);
#else
  //wxAboutBox(info);
#endif
}

About::About(wxWindow* parent, const Components::Component c) : wxDialog(parent, wxID_ANY, _(PACKAGE_NAME), wxDefaultPosition, wxDefaultSize, INDII_ABOUT_STYLE), c(c) {
  /* pre-condition */
  assert (c == Components::APP || c == Components::PLUGIN);
  
  static const int PADDING = 8;

  /* splash panel */
  wxPanel* pnlSplash = new SplashImage(this);
  
  /* description panel */
  wxPanel* pnlDesc = new wxPanel(this);
  wxGridBagSizer* szrDesc = new wxGridBagSizer();
  pnlDesc->SetSizer(szrDesc);
  pnlDesc->SetBackgroundColour(*wxWHITE);
  wxStaticText* lblDesc = new wxStaticText(pnlDesc, wxID_ANY, PACKAGE_DESC);
  lblDesc->Wrap(_img_indii_splash_32->GetWidth() - 2*PADDING);
  lblDesc->SetFont(wxNORMAL_FONT->Italic());
  szrDesc->Add(lblDesc, wxGBPosition(0,0), wxDefaultSpan, wxTOP|wxLEFT|wxRIGHT, PADDING);
  
  /* registration panel */
  pnlReg = new wxPanel(this);
  wxGridBagSizer* szrReg = new wxGridBagSizer();
  pnlReg->SetSizer(szrReg);
  pnlReg->SetBackgroundColour(*wxWHITE);
  
  int daysLeft = Components::daysLeft();
  wxString message;
  if (Components::isActivated(c)) {
    message = wxString::Format(_("Thank you for registering %s."), PACKAGE_NAME);
  } else if (c == Components::PLUGIN && Components::isActivated(Components::APP)) {
    message = wxString::Format(_("Thank you for registering the %s app. This is the %s plugin, to use it you will need to buy a plugin registration code."), PACKAGE_NAME, PACKAGE_NAME);
  //} else if (Components::needsReactivation(c)) {
  //  message = wxString::Format(_("Your registration code must be revalidated for this version of %s."), PACKAGE_NAME);
  } else {
    if (daysLeft == 0) {
      message = wxString::Format("Thank you for trying %s. Your trial period has now ended. Please register now to continue using %s.", PACKAGE_NAME, PACKAGE_NAME);
    } else if (daysLeft == 1) {
      message = wxString::Format("Thank you for trying %s. You have %d day left in your trial period. Please register to continue using %s.", PACKAGE_NAME, daysLeft, PACKAGE_NAME);
    } else {
      message = wxString::Format("Thank you for trying %s. You have %d days left in your trial period. Please register to continue using %s after this time.", PACKAGE_NAME, daysLeft, PACKAGE_NAME);
    }
  }
  wxStaticText* lblMessage = new wxStaticText(pnlReg, wxID_ANY, message);
  lblMessage->Wrap(_img_indii_splash_32->GetWidth() - 2*PADDING);
  szrReg->Add(lblMessage, wxGBPosition(0,0), wxGBSpan(1,2), wxLEFT|wxRIGHT|wxBOTTOM, PADDING);
  
  butRegister = new wxButton(pnlReg, ID_BUT_REGISTER, _("Buy a code"));
  txtKey = new wxTextCtrl(pnlReg, ID_TXT_KEY, _("Enter it here"), wxDefaultPosition, wxSize(200,-1));
  butActivate = new wxButton(pnlReg, ID_BUT_ACTIVATE, _("Activate"));
  
  wxStaticText* lblHeading = new wxStaticText(pnlReg, wxID_ANY, _("How to register"));
  wxStaticText* lblRegister = new wxStaticText(pnlReg, wxID_ANY, _("Step 1"));
  wxStaticText* lblKey = new wxStaticText(pnlReg, wxID_ANY, _("Step 2"));
  wxStaticText* lblActivate = new wxStaticText(pnlReg, wxID_ANY, _("Step 3"));
  
  lblHeading->SetFont(wxNORMAL_FONT->Bold().Larger());
  lblRegister->SetFont(wxNORMAL_FONT->Bold());
  lblKey->SetFont(wxNORMAL_FONT->Bold());
  lblActivate->SetFont(wxNORMAL_FONT->Bold());
  txtKey->SetForegroundColour(*wxLIGHT_GREY);
  
  szrReg->Add(lblHeading, wxGBPosition(1,0), wxGBSpan(1,2), wxALL, PADDING);
  szrReg->Add(lblRegister, wxGBPosition(2,0), wxDefaultSpan, wxALL, PADDING);
  szrReg->Add(lblKey, wxGBPosition(3,0), wxDefaultSpan, wxALL, PADDING);
  szrReg->Add(lblActivate, wxGBPosition(4,0), wxDefaultSpan, wxALL, PADDING);
  szrReg->Add(butRegister, wxGBPosition(2,1), wxDefaultSpan, wxALL, PADDING);
  szrReg->Add(txtKey, wxGBPosition(3,1), wxDefaultSpan, wxALL, PADDING);
  szrReg->Add(butActivate, wxGBPosition(4,1), wxDefaultSpan, wxALL, PADDING);
  
  /* social panel */
  wxPanel* pnlSocial = new wxPanel(this/*, wxID_ANY, wxDefaultPosition, wxDefaultSize, wxBORDER_RAISED*/);
  wxBoxSizer* szrSocial = new wxBoxSizer(wxVERTICAL);
  pnlSocial->SetSizer(szrSocial);
  pnlSocial->SetBackgroundColour(*wxWHITE);
  
  social_scale_images(this->GetContentScaleFactor());
  wxBitmapButton* butFacebook = new wxBitmapButton(pnlSocial, ID_BUT_FACEBOOK, *_img_facebook);
  wxBitmapButton* butFlickr = new wxBitmapButton(pnlSocial, ID_BUT_FLICKR, *_img_flickr);
  wxBitmapButton* butTwitter = new wxBitmapButton(pnlSocial, ID_BUT_TWITTER, *_img_twitter);
  wxBitmapButton* butInstagram = new wxBitmapButton(pnlSocial, ID_BUT_INSTAGRAM, *_img_instagram);
  wxGridBagSizer* szrSocialInternal = new wxGridBagSizer();
  szrSocialInternal->Add(butFacebook, wxGBPosition(0,0), wxDefaultSpan, wxTOP|wxBOTTOM|wxRIGHT, PADDING);
  szrSocialInternal->Add(butTwitter, wxGBPosition(0,1), wxDefaultSpan, wxTOP|wxBOTTOM|wxRIGHT, PADDING);
  szrSocialInternal->Add(butInstagram, wxGBPosition(0,2), wxDefaultSpan, wxTOP|wxBOTTOM|wxRIGHT, PADDING);
  szrSocialInternal->Add(butFlickr, wxGBPosition(0,3), wxDefaultSpan, wxTOP|wxBOTTOM, PADDING);
  szrSocial->Add(szrSocialInternal, 0.0, wxALIGN_CENTER_HORIZONTAL);
  
  /* button panel */
  wxPanel* pnlButton = new wxPanel(this);
  wxStdDialogButtonSizer* szrButton = this->CreateStdDialogButtonSizer(0);
  pnlButton->SetSizer(szrButton);

  wxButton* butClose = new wxButton(pnlButton, wxID_CLOSE);
  szrButton->SetCancelButton(butClose);
  szrButton->Realize();

  /* arrange everything */
  wxBoxSizer* sizer = new wxBoxSizer(wxVERTICAL);
  sizer->Add(pnlSplash, 0, wxEXPAND);
  sizer->Add(pnlDesc, 0, wxEXPAND);
  sizer->Add(pnlSocial, 0, wxEXPAND);
  //sizer->AddSpacer(8);
  sizer->Add(pnlReg, 0, wxEXPAND);
  sizer->Add(pnlButton, 0, wxEXPAND);
  
  //pnlDesc->Hide();
  if (Components::isActivated(c)) {
    pnlReg->Hide();
  }
  SetSizerAndFit(sizer);
}

void About::OnButtonRegister(wxCommandEvent& evt) {
  #ifdef ADOBE_EXCHANGE
  wxLaunchDefaultBrowser(_("https://creative.adobe.com/addons/products/" PACKAGE_ADOBE_ID));
  #else
  wxLaunchDefaultBrowser(_("http://www.indii.org/software/" PACKAGE_TARNAME "/register"));
  #endif
}

void About::OnSetFocus(wxChildFocusEvent& evt) {
  if (evt.GetWindow()->GetId() == ID_TXT_KEY) {
    if (txtKey->GetValue().IsSameAs(_("Enter it here"))) {
      txtKey->SetValue(wxEmptyString);
      txtKey->SetForegroundColour(*wxBLACK);
    }
  } else if (txtKey->GetValue().IsSameAs(wxEmptyString)) {
    txtKey->SetValue(_("Enter it here"));
    txtKey->SetForegroundColour(*wxLIGHT_GREY);
  }
  evt.Skip();
}

void About::OnButtonActivate(wxCommandEvent& evt) {
  if (Components::activate(c, txtKey->GetValue())) {
    pnlReg->Hide();
  }
}

void About::OnButtonFacebook(wxCommandEvent& evt) {
  wxLaunchDefaultBrowser(_("http://www.facebook.com/indii.org"));
}

void About::OnButtonFlickr(wxCommandEvent& evt) {
  wxLaunchDefaultBrowser(_("http://www.flickr.com/photos/lawmurray"));
}

void About::OnButtonTwitter(wxCommandEvent& evt) {
  wxLaunchDefaultBrowser(_("http://www.twitter.com/lawmurray"));
}

void About::OnButtonInstagram(wxCommandEvent& evt) {
  wxLaunchDefaultBrowser(_("http://www.instagram.com/lawmurray"));
}

void About::OnButtonClose(wxCommandEvent& evt) {
  EndModal(wxID_CLOSE);
}

void About::OnClose(wxCloseEvent& evt) {
  Destroy();
}

BEGIN_EVENT_TABLE(About, wxDialog)
EVT_CLOSE(About::OnClose)
EVT_BUTTON(ID_BUT_REGISTER, About::OnButtonRegister)
EVT_BUTTON(ID_BUT_ACTIVATE, About::OnButtonActivate)
EVT_BUTTON(ID_BUT_FACEBOOK, About::OnButtonFacebook)
EVT_BUTTON(ID_BUT_FLICKR, About::OnButtonFlickr)
EVT_BUTTON(ID_BUT_TWITTER, About::OnButtonTwitter)
EVT_BUTTON(ID_BUT_INSTAGRAM, About::OnButtonInstagram)
EVT_BUTTON(wxID_CLOSE, About::OnButtonClose)
EVT_CHILD_FOCUS(About::OnSetFocus)
END_EVENT_TABLE()
