/*
 * Copyright (C) 2017 Hangzhou C-SKY Microsystems co.,ltd.
 *
 * Licensed under the LGPL v2.1 or later, see the file COPYING.LIB
 * in this tarball.
 */

/* Required stack pointer alignment at beginning.  SSE requires 16
   bytes.  */
#define STACK_ALIGN		16

/* Minimal stack size after allocating thread descriptor and guard size.  */
#define MINIMAL_REST_STACK	2048

/* Alignment requirement for TCB.  */
#define TCB_ALIGNMENT		16

/* Location of current stack frame.  */
#define CURRENT_STACK_FRAME	__builtin_frame_address (0)

/* XXX Until we have a better place keep the definitions here.  */
#define __exit_thread_inline(val) \
  INLINE_SYSCALL (exit, 1, (val))
