/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.managers;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.data.dialogs.DefaultValueViewDialog;
import org.jkiss.dbeaver.ui.data.editors.ComplexValueInlineEditor;
import org.jkiss.dbeaver.ui.data.editors.StringInlineEditor;
import org.jkiss.dbeaver.ui.data.managers.BaseValueManager;

public abstract class ComplexValueManager
extends BaseValueManager {
    @Override
    @NotNull
    public IValueController.EditType[] getSupportedEditTypes() {
        return new IValueController.EditType[]{IValueController.EditType.PANEL, IValueController.EditType.EDITOR};
    }

    @Override
    public IValueEditor createEditor(@NotNull IValueController controller) throws DBException {
        return switch (controller.getEditType()) {
            case IValueController.EditType.PANEL -> new ComplexValueInlineEditor(controller);
            case IValueController.EditType.INLINE -> new StringInlineEditor(controller);
            case IValueController.EditType.EDITOR -> new DefaultValueViewDialog(controller);
            default -> null;
        };
    }
}

