/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.RepositoryProviderType;
import org.eclipse.team.internal.core.IRepositoryProviderListener;
import org.eclipse.team.internal.core.RepositoryProviderManager;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.mapping.ITeamStateChangeEvent;
import org.eclipse.team.ui.mapping.ITeamStateChangeListener;
import org.eclipse.team.ui.mapping.ITeamStateDescription;
import org.eclipse.team.ui.mapping.ITeamStateProvider;
import org.eclipse.team.ui.synchronize.TeamStateProvider;

public class WorkspaceTeamStateProvider
extends TeamStateProvider
implements ITeamStateChangeListener,
IRepositoryProviderListener,
IResourceChangeListener {
    private final Map<String, ITeamStateProvider> providers = new HashMap<String, ITeamStateProvider>();

    public WorkspaceTeamStateProvider() {
        IProject[] allProjects;
        RepositoryProviderManager.getInstance().addListener((IRepositoryProviderListener)this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        IProject[] iProjectArray = allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            this.handleProject(project);
            ++n2;
        }
    }

    public void dispose() {
        RepositoryProviderManager.getInstance().removeListener((IRepositoryProviderListener)this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    @Override
    public final boolean isDecorationEnabled(Object element) {
        ITeamStateProvider provider = this.getDecoratedStateProvider(element);
        if (provider != null) {
            return provider.isDecorationEnabled(element);
        }
        return false;
    }

    @Override
    public boolean hasDecoratedState(Object element) throws CoreException {
        ITeamStateProvider provider = this.getDecoratedStateProvider(element);
        if (provider != null) {
            provider.hasDecoratedState(element);
        }
        return false;
    }

    @Override
    public final int getDecoratedStateMask(Object element) {
        ITeamStateProvider provider = this.getDecoratedStateProvider(element);
        if (provider != null) {
            return provider.getDecoratedStateMask(element);
        }
        return 0;
    }

    @Override
    public String[] getDecoratedProperties(Object element) {
        ITeamStateProvider provider = this.getDecoratedStateProvider(element);
        if (provider != null) {
            return provider.getDecoratedProperties(element);
        }
        return new String[0];
    }

    @Override
    public ITeamStateDescription getStateDescription(Object element, int stateMask, String[] properties, IProgressMonitor monitor) throws CoreException {
        ITeamStateProvider provider = this.getDecoratedStateProvider(element);
        if (provider != null) {
            return provider.getStateDescription(element, stateMask, properties, monitor);
        }
        return null;
    }

    @Override
    public ResourceMappingContext getResourceMappingContext(Object element) {
        ITeamStateProvider provider = this.getDecoratedStateProvider(element);
        if (provider != null) {
            return provider.getResourceMappingContext(element);
        }
        return ResourceMappingContext.LOCAL_CONTEXT;
    }

    private ITeamStateProvider getDecoratedStateProvider(Object element) {
        RepositoryProviderType type = this.getProviderType(element);
        if (type != null) {
            return (ITeamStateProvider)Adapters.adapt((Object)type, ITeamStateProvider.class);
        }
        return null;
    }

    private ITeamStateProvider getDecoratedStateProviderForId(String id) {
        RepositoryProviderType type = this.getProviderTypeForId(id);
        if (type != null) {
            return (ITeamStateProvider)Adapters.adapt((Object)type, ITeamStateProvider.class);
        }
        return null;
    }

    private RepositoryProviderType getProviderType(Object element) {
        String providerId;
        ResourceMapping mapping = Utils.getResourceMapping(element);
        if (mapping != null && (providerId = this.getProviderId(mapping.getProjects())) != null) {
            return this.getProviderTypeForId(providerId);
        }
        return null;
    }

    private String getProviderId(IProject[] projects) {
        String id = null;
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            String nextId = this.getProviderId(project);
            if (id == null) {
                id = nextId;
            } else if (nextId != null && !id.equals(nextId)) {
                return null;
            }
            ++n2;
        }
        return id;
    }

    private String getProviderId(IProject project) {
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
        if (provider != null) {
            return provider.getID();
        }
        return null;
    }

    private RepositoryProviderType getProviderTypeForId(String providerId) {
        return RepositoryProviderType.getProviderType((String)providerId);
    }

    private void handleProject(IProject project) {
        if (RepositoryProvider.isShared((IProject)project)) {
            try {
                String currentId = project.getPersistentProperty(TeamPlugin.PROVIDER_PROP_KEY);
                if (currentId != null) {
                    this.listenerForStateChangesForId(currentId);
                }
            }
            catch (CoreException e) {
                TeamPlugin.log((CoreException)e);
            }
        }
    }

    private void listenerForStateChangesForId(String id) {
        ITeamStateProvider provider;
        if (!this.providers.containsKey(id) && (provider = this.getDecoratedStateProviderForId(id)) != null) {
            this.providers.put(id, provider);
            provider.addDecoratedStateChangeListener(this);
        }
    }

    @Override
    public void teamStateChanged(ITeamStateChangeEvent event) {
        this.fireStateChangeEvent(event);
    }

    public void providerUnmapped(IProject project) {
    }

    public void providerMapped(RepositoryProvider provider) {
        String id = provider.getID();
        this.listenerForStateChangesForId(id);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta[] projectDeltas;
        IResourceDelta delta = event.getDelta();
        IResourceDelta[] iResourceDeltaArray = projectDeltas = delta.getAffectedChildren(5);
        int n = projectDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project;
            IResourceDelta projectDelta = iResourceDeltaArray[n2];
            IResource resource = projectDelta.getResource();
            if ((projectDelta.getFlags() & 0x4000) != 0 && resource.getType() == 4 && (project = (IProject)resource).isAccessible()) {
                this.handleProject(project);
            }
            ++n2;
        }
    }
}

