---
stage: none
group: unassigned
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 非推奨に関する用語
---

## 非推奨 {#deprecation}

- 機能のサポート終了または機能の削除前に必要です。
- 使用が推奨されない機能です。
- 開発は優先度1/重要度1のバグ修正に制限されます。
- 将来のメジャーリリースで削除されます。
- サポート終了日または削除日を明記した非推奨の発表後に開始されます。
- サポート終了日または削除日が過ぎた後に終了します。

## サポート終了 {end-of-support}

- 削除前のオプションステップです。
- 機能の使用は強く非推奨とされます。
- サポートや修正は提供されません。
- 内部テストは実施されません。
- 将来のメジャーリリースで削除されます。
- サポート終了日が過ぎた後に開始されます。

サポート終了期間の発表は特別な状況でのみ使用すべきであり、一般的な使用は推奨されません。
ほとんどの機能は非推奨とした後に削除すべきです。

## 削除 {#removal}

- 機能の使用が不可能になります。
- 機能のサポートが終了します（サポート終了期間が既に発表されていない場合）。
- [セマンティックバージョニングポリシー](../policy/maintenance.md)に従って、メジャーリリースで実施されます。
- 削除日が過ぎた後に開始されます。

## 破壊的な変更 {#breaking-change}

ユーザーがGitLabワークフローが中断されないよう対応する必要がある変更は、すべて破壊的な変更とみなされます。

破壊的な変更は以下のような要因から生じる可能性があります:

- 意図的な製品変更
- 設定の更新
- サードパーティの非推奨

デフォルトでは、破壊的な変更の実装計画が上位承認者によって承認されない限り、破壊的な変更は許可されません。

## サードパーティ依存関係 {#third-party-dependencies}

このセクションは前述のすべての用語に適用されます。

サードパーティ依存関係の変更（非推奨、サポート終了、削除、または破壊的な変更）は、GitLab自体の機能変更とは別に処理されます:

- これらの変更は依存関係独自のライフサイクルに従い、GitLabの機能プロセスやタイムライン要件の対象ではありません。
- GitLabは、当社製品に影響するサードパーティ依存関係の変更について、影響を最小限に抑え、スムーズな移行を実現できるよう努めます。
- 依存関係のセキュリティアップデートは、重大な脆弱性に対処するため、脆弱性修正SLAの範囲内で必要に応じて標準的な非推奨化プロセスに従わずに適用される場合があります。詳細については、GitLabハンドブックを参照してください。
- 依存関係が当社の管理やタイムラインの範囲外で変更される場合、GitLabは機能性、互換性、またはセキュリティを維持するために、通常のプロセスやタイムラインの範囲外で当社ソフトウェアに変更を実装する必要がある場合があります。
- GitLabは重要なサードパーティ依存関係の変更について、合理的な範囲で通知を行うよう努めます。
- GitLabは、GitLab製品で直接使用されていないサードパーティ依存関係の機能変更については責任を負いません。
- GitLabの使用パターンを超えてこれらのサードパーティ依存関係を活用するユーザーは、自己責任で行うものとし、以下を実施する必要があります:
  - サードパーティのリリースノートを独自に監視する。
  - 新しい依存関係バージョンに対してカスタム実装をテストする。
  - サードパーティの変更に対する独自の移行戦略を計画する。
