---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Ionic personal access token'
---

## Description

The response body contains content that matches the pattern of an Ionic personal access token was identified. Personal access tokens can be used to authenticate the Ionic CLI, Appflow CLI, or any third party application. A malicious actor with access to this token can gain full access to linked repositories and pipelines.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To revoke your API token:

- Sign in to your Ionic account and visit <https://dashboard.ionicframework.com/settings/personal-access-tokens>
- Find the API token that was identified
- Select "Delete"
- When prompted, select "I'm sure, delete this personal access token" in the "Are you sure?" dialog

For more information, please see [Ionic's documentation on access tokens](https://ionic.io/docs/appflow/personal-access-tokens).

## Details

| ID      | Aggregated | CWE | Type | Risk |
|:--------|:-----------|:----|:-----|:-----|
| 798.157 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
