---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Segment public API token'
---

## Description

The response body contains content that matches the pattern of a Segment Public API token was identified. The Segment Public API is used to manage your Segment workspaces and its resources. Two types of tokens match this pattern, a workspace owner token and a limited role token. In general these tokens allow callers of the API to perform read, write, and delete operations. A malicious actor with access to a workspace owner token can access all workspace data. A limited role token can access the data it was granted access to on creation.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To rotate a Public API token:

- Sign in to your Segment account and access your workspace from <https://app.segment.com/>
- From the left-hand menu, select "Settings" and go to "Workspace settings"
- Select the "Access Management" tab in the "Workspace settings" page
- Select the "Tokens" tab under "Access Management"
- Find the key that was identified, and select it
- In the right hand side, select "Edit token" in the "Token Permissions" section
- Select "Remove token" in the top right corner
- When prompted, select "Remove Token" in the dialog

For more information, please see [Segment's documentation on their public API](https://segment.com/docs/api/public-api/).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.169 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
