/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.oauth.IOAuthToken;
import org.openstreetmap.josm.data.oauth.OAuth20Token;
import org.openstreetmap.josm.data.oauth.OAuthAccessTokenHolder;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;

public class AccessTokenInfoPanel
extends JPanel {
    private final JosmTextField tfAccessTokenKey = new JosmTextField(null, null, 0, false);
    private final JCheckBox cbSaveAccessTokenInPreferences = new JCheckBox(I18n.tr("Save Access Token in preferences", new Object[0]));

    public AccessTokenInfoPanel() {
        this.build();
    }

    protected final void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.insets = new Insets(0, 0, 3, 3);
        this.add((Component)new JLabel(I18n.tr("Access Token Key:", new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.add((Component)this.tfAccessTokenKey, gc);
        this.tfAccessTokenKey.setEditable(false);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.weightx = 0.0;
        gc.insets = new Insets(0, 0, 3, 3);
        this.add((Component)new JLabel(I18n.tr("Access Token Secret:", new Object[0])), gc);
        gc.weightx = 1.0;
        gc.gridx = 0;
        gc.gridy = 2;
        gc.gridwidth = 2;
        this.add((Component)this.cbSaveAccessTokenInPreferences, gc);
        this.cbSaveAccessTokenInPreferences.setToolTipText(I18n.tr("<html>Select to save the Access Token in the JOSM preferences.<br>Unselect to use the Access Token in this JOSM session only.</html>", new Object[0]));
        this.cbSaveAccessTokenInPreferences.setSelected(OAuthAccessTokenHolder.getInstance().isSaveToPreferences());
        gc.gridx = 0;
        gc.gridy = 3;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        gc.gridwidth = 2;
        this.add((Component)new JPanel(), gc);
    }

    public void setAccessToken(IOAuthToken token) {
        if (token == null) {
            this.tfAccessTokenKey.setText("");
            return;
        }
        if (!(token instanceof OAuth20Token)) {
            throw new JosmRuntimeException("Unknown token type: " + String.valueOf(token.getClass()));
        }
        this.tfAccessTokenKey.setText(((OAuth20Token)token).getBearerToken());
    }

    public void setSaveToPreferences(boolean saveToPreferences) {
        this.cbSaveAccessTokenInPreferences.setSelected(saveToPreferences);
    }

    public boolean isSaveToPreferences() {
        return this.cbSaveAccessTokenInPreferences.isSelected();
    }
}

