/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.xml;

import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.function.FunctionRenderer;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentException;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.expression.SqmXmlAttributesExpression;
import org.hibernate.query.sqm.tree.expression.SqmXmlElementExpression;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.XmlAttributes;
import org.hibernate.type.BindingContext;
import org.hibernate.type.descriptor.jdbc.XmlHelper;
import org.hibernate.type.spi.TypeConfiguration;

public class XmlElementFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    public XmlElementFunction(TypeConfiguration typeConfiguration) {
        super("xmlelement", FunctionKind.NORMAL, StandardArgumentsValidators.composite(new ArgumentTypesValidator(StandardArgumentsValidators.min(1), FunctionParameterType.STRING), new ArgumentsValidator(){

            @Override
            public void validate(List<? extends SqmTypedNode<?>> arguments, String functionName, BindingContext bindingContext) {
                SqmTypedNode<?> sqmTypedNode;
                String elementName = (String)((SqmLiteral)arguments.get(0)).getLiteralValue();
                if (!XmlHelper.isValidXmlName(elementName)) {
                    throw new FunctionArgumentException(String.format("Invalid XML element name passed to 'xmlelement()': %s", elementName));
                }
                if (arguments.size() > 1 && (sqmTypedNode = arguments.get(1)) instanceof SqmXmlAttributesExpression) {
                    SqmXmlAttributesExpression attributesExpression = (SqmXmlAttributesExpression)sqmTypedNode;
                    Map<String, SqmExpression<?>> attributes = attributesExpression.getAttributes();
                    for (Map.Entry<String, SqmExpression<?>> entry : attributes.entrySet()) {
                        if (XmlHelper.isValidXmlName(entry.getKey())) continue;
                        throw new FunctionArgumentException(String.format("Invalid XML attribute name passed to 'xmlattributes()': %s", entry.getKey()));
                    }
                }
            }
        }), StandardFunctionReturnTypeResolvers.invariant(typeConfiguration.getBasicTypeRegistry().resolve(String.class, 2009)), null);
    }

    @Override
    protected <T> SelfRenderingSqmFunction<T> generateSqmFunctionExpression(List<? extends SqmTypedNode<?>> arguments, ReturnableType<T> impliedResultType, QueryEngine queryEngine) {
        return new SqmXmlElementExpression((SqmFunctionDescriptor)this, (FunctionRenderer)this, arguments, impliedResultType, this.getArgumentsValidator(), this.getReturnTypeResolver(), queryEngine.getCriteriaBuilder(), this.getName());
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        this.render(sqlAppender, XmlElementArguments.extract(sqlAstArguments), returnType, walker);
    }

    protected void render(SqlAppender sqlAppender, XmlElementArguments arguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql("xmlelement(name ");
        sqlAppender.appendDoubleQuoteEscapedString(arguments.elementName());
        if (arguments.attributes() != null) {
            sqlAppender.appendSql(",xmlattributes");
            int separator = 40;
            for (Map.Entry<String, Expression> entry : arguments.attributes().getAttributes().entrySet()) {
                sqlAppender.appendSql((char)separator);
                entry.getValue().accept(walker);
                sqlAppender.appendSql(" as ");
                sqlAppender.appendDoubleQuoteEscapedString(entry.getKey());
                separator = 44;
            }
            sqlAppender.appendSql(')');
        }
        if (!arguments.content().isEmpty()) {
            for (Expression expression : arguments.content()) {
                sqlAppender.appendSql(',');
                expression.accept(walker);
            }
        }
        sqlAppender.appendSql(')');
    }

    protected record XmlElementArguments(String elementName, @Nullable XmlAttributes attributes, List<Expression> content) {
        static XmlElementArguments extract(List<? extends SqlAstNode> arguments) {
            XmlAttributes attributes;
            SqlAstNode sqlAstNode;
            Literal elementName = (Literal)arguments.get(0);
            int index = 1;
            if (arguments.size() > index && (sqlAstNode = arguments.get(index)) instanceof XmlAttributes) {
                XmlAttributes xmlAttributes;
                attributes = xmlAttributes = (XmlAttributes)sqlAstNode;
                ++index;
            } else {
                attributes = null;
            }
            List<? extends SqlAstNode> content = arguments.subList(index, arguments.size());
            return new XmlElementArguments((String)elementName.getLiteralValue(), attributes, content);
        }
    }
}

