/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.function.Supplier;
import org.hibernate.MappingException;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Value;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.type.MappingContext;
import org.hibernate.usertype.UserCollectionType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class IndexedCollection
extends Collection {
    public static final String DEFAULT_INDEX_COLUMN_NAME = "idx";
    private Value index;

    public IndexedCollection(MetadataBuildingContext buildingContext, PersistentClass owner) {
        super(buildingContext, owner);
    }

    public IndexedCollection(Supplier<ManagedBean<? extends UserCollectionType>> customTypeBeanResolver, PersistentClass owner, MetadataBuildingContext buildingContext) {
        super(customTypeBeanResolver, owner, buildingContext);
    }

    protected IndexedCollection(IndexedCollection original) {
        super(original);
        this.index = original.index == null ? null : original.index.copy();
    }

    public Value getIndex() {
        return this.index;
    }

    public void setIndex(Value index) {
        this.index = index;
    }

    @Override
    public final boolean isIndexed() {
        return true;
    }

    public boolean hasMapKeyProperty() {
        return false;
    }

    @Override
    public boolean isSame(Collection other) {
        IndexedCollection indexedCollection;
        return other instanceof IndexedCollection && this.isSame(indexedCollection = (IndexedCollection)other);
    }

    public boolean isSame(IndexedCollection other) {
        return super.isSame(other) && IndexedCollection.isSame(this.index, other.index);
    }

    @Override
    void createPrimaryKey() {
        if (!this.isOneToMany()) {
            PrimaryKey pk = new PrimaryKey(this.getCollectionTable());
            pk.addColumns(this.getKey());
            boolean indexIsPartOfElement = false;
            for (Selectable selectable : this.getIndex().getSelectables()) {
                if (!selectable.isFormula() && this.getCollectionTable().containsColumn((Column)selectable)) continue;
                indexIsPartOfElement = true;
            }
            if (indexIsPartOfElement) {
                pk.addColumns(this.getElement());
            } else {
                pk.addColumns(this.getIndex());
            }
            this.getCollectionTable().setPrimaryKey(pk);
        }
    }

    @Override
    public void validate(MappingContext mappingContext) throws MappingException {
        super.validate(mappingContext);
        assert (this.getElement() != null) : "IndexedCollection index not bound : " + this.getRole();
        if (!this.getIndex().isValid(mappingContext)) {
            throw new MappingException("collection index mapping has wrong number of columns: " + this.getRole() + " type: " + this.getIndex().getType().getName());
        }
    }

    public boolean isList() {
        return false;
    }
}

