/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.model.ast;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.model.ast.ColumnValueParameter;

public class ColumnWriteFragment
implements Expression {
    private final String fragment;
    private final List<ColumnValueParameter> parameters;
    private final JdbcMapping jdbcMapping;

    public ColumnWriteFragment(String fragment, JdbcMapping jdbcMapping) {
        this(fragment, Collections.emptyList(), jdbcMapping);
    }

    public ColumnWriteFragment(String fragment, ColumnValueParameter parameter, JdbcMapping jdbcMapping) {
        this(fragment, Collections.singletonList(parameter), jdbcMapping);
        assert (!fragment.contains("?") || parameter != null);
    }

    public ColumnWriteFragment(String fragment, List<ColumnValueParameter> parameters, JdbcMapping jdbcMapping) {
        this.fragment = fragment;
        this.parameters = parameters;
        this.jdbcMapping = jdbcMapping;
    }

    public String getFragment() {
        return this.fragment;
    }

    public Collection<ColumnValueParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public JdbcMapping getExpressionType() {
        return this.jdbcMapping;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitColumnWriteFragment(this);
    }

    public String toString() {
        return switch (this.parameters.size()) {
            case 0 -> String.format(Locale.ROOT, "ColumnWriteFragment(%s)@%s", this.fragment, this.hashCode());
            case 1 -> String.format(Locale.ROOT, "ColumnWriteFragment(%s = %s (%s))@%s", new Object[]{this.parameters.get(0).getColumnReference().getColumnExpression(), this.fragment, this.parameters.get(0).getUsage(), this.hashCode()});
            default -> String.format(Locale.ROOT, "ColumnWriteFragment(%s = %s (%s))@%s", new Object[]{this.parameters, this.fragment, this.parameters.get(0).getUsage(), this.hashCode()});
        };
    }
}

