/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.builder.item.SimpleBuildItem;
import java.util.Set;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.MethodInfo;

public final class BuildExclusionsBuildItem
extends SimpleBuildItem {
    private final Set<String> excludedDeclaringClasses;
    private final Set<String> excludedMethods;
    private final Set<String> excludedFields;

    public BuildExclusionsBuildItem(Set<String> excludedDeclaringClasses, Set<String> excludedMethods, Set<String> excludedFields) {
        this.excludedDeclaringClasses = excludedDeclaringClasses;
        this.excludedMethods = excludedMethods;
        this.excludedFields = excludedFields;
    }

    public Set<String> getExcludedDeclaringClasses() {
        return this.excludedDeclaringClasses;
    }

    public Set<String> getExcludedMethods() {
        return this.excludedMethods;
    }

    public Set<String> getExcludedFields() {
        return this.excludedFields;
    }

    public boolean isExcluded(AnnotationTarget target) {
        switch (target.kind()) {
            case CLASS: {
                return this.excludedDeclaringClasses.contains(BuildExclusionsBuildItem.targetMapper(target));
            }
            case METHOD: {
                return this.excludedMethods.contains(BuildExclusionsBuildItem.targetMapper(target)) || this.excludedDeclaringClasses.contains(BuildExclusionsBuildItem.targetMapper((AnnotationTarget)target.asMethod().declaringClass()));
            }
            case METHOD_PARAMETER: {
                MethodInfo method = target.asMethodParameter().method();
                return this.excludedMethods.contains(BuildExclusionsBuildItem.targetMapper((AnnotationTarget)method)) || this.excludedDeclaringClasses.contains(BuildExclusionsBuildItem.targetMapper((AnnotationTarget)method.declaringClass()));
            }
            case FIELD: {
                return this.excludedFields.contains(BuildExclusionsBuildItem.targetMapper(target)) || this.excludedDeclaringClasses.contains(BuildExclusionsBuildItem.targetMapper((AnnotationTarget)target.asField().declaringClass()));
            }
        }
        return false;
    }

    public static String targetMapper(AnnotationTarget target) {
        AnnotationTarget.Kind kind = target.kind();
        if (kind == AnnotationTarget.Kind.CLASS) {
            return target.asClass().toString();
        }
        if (kind == AnnotationTarget.Kind.METHOD) {
            MethodInfo method = target.asMethod();
            return String.format("%s#%s", method.declaringClass(), method);
        }
        return target.asField().toString();
    }
}

