/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;

public final class ScoreCachingWrappingScorer
extends Scorable {
    private boolean scoreIsCached;
    private float curScore;
    private final Scorable in;

    public static LeafCollector wrap(LeafCollector collector) {
        if (collector instanceof ScoreCachingWrappingLeafCollector) {
            return collector;
        }
        return new ScoreCachingWrappingLeafCollector(collector);
    }

    private ScoreCachingWrappingScorer(Scorable scorer) {
        this.in = scorer;
    }

    @Override
    public float score() throws IOException {
        if (!this.scoreIsCached) {
            this.curScore = this.in.score();
            this.scoreIsCached = true;
        }
        return this.curScore;
    }

    @Override
    public void setMinCompetitiveScore(float minScore) throws IOException {
        this.in.setMinCompetitiveScore(minScore);
    }

    @Override
    public Collection<Scorable.ChildScorable> getChildren() {
        return Collections.singleton(new Scorable.ChildScorable(this.in, "CACHED"));
    }

    private static class ScoreCachingWrappingLeafCollector
    extends FilterLeafCollector {
        private ScoreCachingWrappingScorer scorer;

        ScoreCachingWrappingLeafCollector(LeafCollector in) {
            super(in);
        }

        @Override
        public void setScorer(Scorable scorer) throws IOException {
            this.scorer = new ScoreCachingWrappingScorer(scorer);
            super.setScorer(this.scorer);
        }

        @Override
        public void collect(int doc) throws IOException {
            if (this.scorer != null) {
                this.scorer.scoreIsCached = false;
            }
            super.collect(doc);
        }

        @Override
        public DocIdSetIterator competitiveIterator() throws IOException {
            return this.in.competitiveIterator();
        }
    }
}

