/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Objects;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.script.Script;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceConfig;
import org.opensearch.search.aggregations.bucket.missing.MissingOrder;
import org.opensearch.search.aggregations.support.ValueType;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.aggregations.support.ValuesSourceType;
import org.opensearch.search.sort.SortOrder;

public abstract class CompositeValuesSourceBuilder<AB extends CompositeValuesSourceBuilder<AB>>
implements Writeable,
ToXContentFragment {
    protected final String name;
    private String field = null;
    private Script script = null;
    private ValueType userValueTypeHint = null;
    private boolean missingBucket = false;
    private MissingOrder missingOrder = MissingOrder.DEFAULT;
    private SortOrder order = SortOrder.ASC;
    private String format = null;

    public CompositeValuesSourceBuilder(String name) {
        this.name = name;
    }

    public CompositeValuesSourceBuilder(StreamInput in) throws IOException {
        this.name = in.readString();
        this.field = in.readOptionalString();
        if (in.readBoolean()) {
            this.script = new Script(in);
        }
        if (in.readBoolean()) {
            this.userValueTypeHint = ValueType.readFromStream(in);
        }
        this.missingBucket = in.readBoolean();
        this.missingOrder = MissingOrder.readFromStream(in);
        this.order = SortOrder.readFromStream(in);
        this.format = in.readOptionalString();
    }

    public final void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeOptionalString(this.field);
        boolean hasScript = this.script != null;
        out.writeBoolean(hasScript);
        if (hasScript) {
            this.script.writeTo(out);
        }
        boolean hasValueType = this.userValueTypeHint != null;
        out.writeBoolean(hasValueType);
        if (hasValueType) {
            this.userValueTypeHint.writeTo(out);
        }
        out.writeBoolean(this.missingBucket);
        this.missingOrder.writeTo(out);
        this.order.writeTo(out);
        out.writeOptionalString(this.format);
        this.innerWriteTo(out);
    }

    protected abstract void innerWriteTo(StreamOutput var1) throws IOException;

    protected abstract void doXContentBody(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.type());
        if (this.field != null) {
            builder.field("field", this.field);
        }
        if (this.script != null) {
            builder.field("script", (ToXContent)this.script);
        }
        builder.field("missing_bucket", this.missingBucket);
        if (this.userValueTypeHint != null) {
            builder.field("value_type", this.userValueTypeHint.getPreferredName());
        }
        if (this.format != null) {
            builder.field("format", this.format);
        }
        if (!MissingOrder.isDefault(this.missingOrder)) {
            builder.field("missing_order", this.missingOrder.toString());
        }
        builder.field("order", (Object)this.order);
        this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.missingBucket, this.script, this.userValueTypeHint, this.order, this.format});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeValuesSourceBuilder that = (CompositeValuesSourceBuilder)o;
        return Objects.equals(this.field, that.field()) && Objects.equals(this.script, that.script()) && Objects.equals((Object)this.userValueTypeHint, (Object)that.userValuetypeHint()) && Objects.equals(this.missingBucket, that.missingBucket()) && Objects.equals((Object)this.missingOrder, (Object)that.missingOrder()) && Objects.equals((Object)this.order, (Object)that.order()) && Objects.equals(this.format, that.format());
    }

    public String name() {
        return this.name;
    }

    protected abstract String type();

    public AB field(String field) {
        if (field == null) {
            throw new IllegalArgumentException("[field] must not be null");
        }
        this.field = field;
        return (AB)this;
    }

    public String field() {
        return this.field;
    }

    public AB script(Script script) {
        if (script == null) {
            throw new IllegalArgumentException("[script] must not be null");
        }
        this.script = script;
        return (AB)this;
    }

    public Script script() {
        return this.script;
    }

    public AB userValuetypeHint(ValueType valueType) {
        if (valueType == null) {
            throw new IllegalArgumentException("[userValueTypeHint] must not be null");
        }
        this.userValueTypeHint = valueType;
        return (AB)this;
    }

    public ValueType userValuetypeHint() {
        return this.userValueTypeHint;
    }

    public AB missingBucket(boolean missingBucket) {
        this.missingBucket = missingBucket;
        return (AB)this;
    }

    public boolean missingBucket() {
        return this.missingBucket;
    }

    public AB missingOrder(MissingOrder missingOrder) {
        this.missingOrder = missingOrder;
        return (AB)this;
    }

    public AB missingOrder(String missingOrder) {
        return this.missingOrder(MissingOrder.fromString(missingOrder));
    }

    public MissingOrder missingOrder() {
        return this.missingOrder;
    }

    public AB order(String order) {
        if (order == null) {
            throw new IllegalArgumentException("[order] must not be null");
        }
        this.order = SortOrder.fromString(order);
        return (AB)this;
    }

    public AB order(SortOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("[order] must not be null");
        }
        this.order = order;
        return (AB)this;
    }

    public SortOrder order() {
        return this.order;
    }

    public AB format(String format) {
        if (format == null) {
            throw new IllegalArgumentException("[format] must not be null: [" + this.name + "]");
        }
        this.format = format;
        return (AB)this;
    }

    public String format() {
        return this.format;
    }

    protected abstract CompositeValuesSourceConfig innerBuild(QueryShardContext var1, ValuesSourceConfig var2) throws IOException;

    protected abstract ValuesSourceType getDefaultValuesSourceType();

    public final CompositeValuesSourceConfig build(QueryShardContext queryShardContext) throws IOException {
        if (!this.missingBucket && this.missingOrder != MissingOrder.DEFAULT) {
            throw new IllegalArgumentException("missing_order require missing_bucket is true");
        }
        ValuesSourceConfig config = ValuesSourceConfig.resolve(queryShardContext, this.userValueTypeHint, this.field, this.script, null, this.timeZone(), this.format, this.getDefaultValuesSourceType());
        return this.innerBuild(queryShardContext, config);
    }

    protected ZoneId timeZone() {
        return null;
    }
}

