/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.ByoipCidr;
import software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsResponse;

public class DescribeByoipCidrsPublisher
implements SdkPublisher<DescribeByoipCidrsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeByoipCidrsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeByoipCidrsPublisher(Ec2AsyncClient client, DescribeByoipCidrsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeByoipCidrsPublisher(Ec2AsyncClient client, DescribeByoipCidrsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeByoipCidrsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeByoipCidrsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ByoipCidr> byoipCidrs() {
        Function<DescribeByoipCidrsResponse, Iterator> getIterator = response -> {
            if (response != null && response.byoipCidrs() != null) {
                return response.byoipCidrs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeByoipCidrsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeByoipCidrsResponseFetcher
    implements AsyncPageFetcher<DescribeByoipCidrsResponse> {
        private DescribeByoipCidrsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeByoipCidrsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeByoipCidrsResponse> nextPage(DescribeByoipCidrsResponse previousPage) {
            if (previousPage == null) {
                return DescribeByoipCidrsPublisher.this.client.describeByoipCidrs(DescribeByoipCidrsPublisher.this.firstRequest);
            }
            return DescribeByoipCidrsPublisher.this.client.describeByoipCidrs((DescribeByoipCidrsRequest)((Object)DescribeByoipCidrsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

