/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.LocalGatewayRoute;
import software.amazon.awssdk.services.ec2.model.SearchLocalGatewayRoutesRequest;
import software.amazon.awssdk.services.ec2.model.SearchLocalGatewayRoutesResponse;

public class SearchLocalGatewayRoutesIterable
implements SdkIterable<SearchLocalGatewayRoutesResponse> {
    private final Ec2Client client;
    private final SearchLocalGatewayRoutesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchLocalGatewayRoutesIterable(Ec2Client client, SearchLocalGatewayRoutesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchLocalGatewayRoutesResponseFetcher();
    }

    public Iterator<SearchLocalGatewayRoutesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LocalGatewayRoute> routes() {
        Function<SearchLocalGatewayRoutesResponse, Iterator> getIterator = response -> {
            if (response != null && response.routes() != null) {
                return response.routes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchLocalGatewayRoutesResponseFetcher
    implements SyncPageFetcher<SearchLocalGatewayRoutesResponse> {
        private SearchLocalGatewayRoutesResponseFetcher() {
        }

        public boolean hasNextPage(SearchLocalGatewayRoutesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchLocalGatewayRoutesResponse nextPage(SearchLocalGatewayRoutesResponse previousPage) {
            if (previousPage == null) {
                return SearchLocalGatewayRoutesIterable.this.client.searchLocalGatewayRoutes(SearchLocalGatewayRoutesIterable.this.firstRequest);
            }
            return SearchLocalGatewayRoutesIterable.this.client.searchLocalGatewayRoutes((SearchLocalGatewayRoutesRequest)((Object)SearchLocalGatewayRoutesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

