/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.evaluation;

import java.util.ArrayList;
import java.util.List;
import org.tribuo.Example;
import org.tribuo.Model;
import org.tribuo.Output;
import org.tribuo.Prediction;
import org.tribuo.evaluation.Evaluation;
import org.tribuo.evaluation.Evaluator;
import org.tribuo.provenance.DataProvenance;

public final class OnlineEvaluator<T extends Output<T>, E extends Evaluation<T>> {
    private final Evaluator<T, E> evaluator;
    private final Model<T> model;
    private final DataProvenance provenance;
    private final List<Prediction<T>> predictions = new ArrayList<Prediction<T>>();

    public OnlineEvaluator(Evaluator<T, E> evaluator, Model<T> model, DataProvenance provenance) {
        this.evaluator = evaluator;
        this.model = model;
        this.provenance = provenance;
    }

    public E evaluate() {
        return this.evaluator.evaluate(this.model, new ArrayList<Prediction<T>>(this.predictions), this.provenance);
    }

    public synchronized Prediction<T> predictAndObserve(Example<T> example) {
        Prediction<T> cur = this.model.predict(example);
        this.predictions.add(cur);
        return cur;
    }

    public synchronized List<Prediction<T>> predictAndObserve(Iterable<Example<T>> examples) {
        List<Prediction<T>> cur = this.model.predict(examples);
        this.predictions.addAll(cur);
        return new ArrayList<Prediction<T>>(cur);
    }

    public synchronized void observe(Prediction<T> newPrediction) {
        this.predictions.add(newPrediction);
    }

    public synchronized void observe(List<Prediction<T>> newPredictions) {
        this.predictions.addAll(newPredictions);
    }
}

