/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class PasswordData {
    private String password;
    private String username;
    private List<Reference> passwordReferences = new ArrayList<Reference>();
    private Origin origin = Origin.User;

    public PasswordData() {
    }

    public PasswordData(String p) {
        this.setPassword(p);
    }

    public PasswordData(String u, String p) {
        this.setUsername(u);
        this.setPassword(p);
    }

    public PasswordData(String p, Origin o) {
        this.setPassword(p);
        this.setOrigin(o);
    }

    public PasswordData(String u, String p, Origin o) {
        this.setUsername(u);
        this.setPassword(p);
        this.setOrigin(o);
    }

    public PasswordData(String u, String p, List<Reference> r) {
        this.setUsername(u);
        this.setPassword(p);
        this.setPasswordReferences(r);
    }

    public void setPassword(String p) {
        if (p == null) {
            throw new NullPointerException("Password cannot be null");
        }
        this.password = p;
    }

    public String getPassword() {
        return this.password;
    }

    public void setOrigin(Origin o) {
        if (o == null) {
            throw new NullPointerException("Origin cannot be null");
        }
        this.origin = o;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public void setUsername(String s) {
        if (s == null) {
            throw new NullPointerException("Username cannot be null");
        }
        this.username = s;
    }

    public String getUsername() {
        return this.username;
    }

    public List<Reference> getPasswordReferences() {
        return this.passwordReferences;
    }

    public <T extends Reference> List<T> getPasswordReferences(Class<T> type) {
        ArrayList l = new ArrayList();
        if (this.passwordReferences != null) {
            l.addAll(this.passwordReferences.stream().filter(type::isInstance).map(r -> r).collect(Collectors.toList()));
        }
        return Collections.unmodifiableList(l);
    }

    public void setPasswordReferences(Reference ... r) {
        this.setPasswordReferences(Arrays.asList(r));
    }

    public void setPasswordReferences(List<Reference> l) {
        this.passwordReferences = l;
    }

    public static PasswordData newPasswordData(PasswordData data) {
        PasswordData pd = new PasswordData();
        pd.setUsername(data.getUsername());
        pd.setPassword(data.getPassword());
        pd.setPasswordReferences(data.getPasswordReferences());
        pd.setOrigin(data.getOrigin());
        return pd;
    }

    public String toString() {
        return String.format("%s@%h::username=%s,password=%s,origin=%s,passwordReferences=%s", new Object[]{this.getClass().getName(), this.hashCode(), this.username, this.password, this.origin, this.passwordReferences});
    }

    public static abstract class AbstractReference
    implements Reference {
        private final String label;
        private final String password;
        private final Salt salt;

        public AbstractReference(String lbl, String pass, Salt slt) {
            this.label = lbl;
            this.password = pass;
            this.salt = slt;
        }

        public AbstractReference(String lbl, String pass) {
            this(lbl, pass, null);
        }

        public String getLabel() {
            return this.label;
        }

        @Override
        public String getPassword() {
            return this.password;
        }

        @Override
        public Salt getSalt() {
            return this.salt;
        }

        public String toString() {
            return String.format("%s@%h::label=%s,password=%s", this.getClass().getName(), this.hashCode(), this.label, this.password);
        }
    }

    public static class SourceReference
    extends AbstractReference {
        public SourceReference(String pass) {
            super(null, pass);
        }

        public SourceReference(String lbl, String pass) {
            super(lbl, pass);
        }

        public SourceReference(String lbl, String pass, Salt slt) {
            super(lbl, pass, slt);
        }
    }

    public static class HistoricalReference
    extends AbstractReference {
        public HistoricalReference(String pass) {
            super(null, pass);
        }

        public HistoricalReference(String lbl, String pass) {
            super(lbl, pass);
        }

        public HistoricalReference(String lbl, String pass, Salt slt) {
            super(lbl, pass, slt);
        }
    }

    public static interface Reference {
        public String getPassword();

        default public Salt getSalt() {
            return null;
        }
    }

    public static class SuffixSalt
    implements Salt {
        private final String salt;

        public SuffixSalt(String slt) {
            this.salt = slt;
        }

        @Override
        public String applyTo(String password) {
            return password + this.salt;
        }
    }

    public static class PrefixSalt
    implements Salt {
        private final String salt;

        public PrefixSalt(String slt) {
            this.salt = slt;
        }

        @Override
        public String applyTo(String password) {
            return this.salt + password;
        }
    }

    public static interface Salt {
        public String applyTo(String var1);
    }

    public static enum Origin {
        User,
        Generated;

    }
}

