#include "./dxmt_names.hpp"
#include "util_names.hpp"

std::ostream &
operator<<(std::ostream &os, D3D_FEATURE_LEVEL e) {
  switch (e) {
    ENUM_NAME(D3D_FEATURE_LEVEL_9_1);
    ENUM_NAME(D3D_FEATURE_LEVEL_9_2);
    ENUM_NAME(D3D_FEATURE_LEVEL_9_3);
    ENUM_NAME(D3D_FEATURE_LEVEL_10_0);
    ENUM_NAME(D3D_FEATURE_LEVEL_10_1);
    ENUM_NAME(D3D_FEATURE_LEVEL_11_0);
    ENUM_NAME(D3D_FEATURE_LEVEL_11_1);
    ENUM_NAME(D3D_FEATURE_LEVEL_12_0);
    ENUM_NAME(D3D_FEATURE_LEVEL_12_1);
    ENUM_DEFAULT(e);
  }
}

std::ostream &
operator<<(std::ostream &os, D3D11_RESOURCE_DIMENSION e) {
  switch (e) {
    ENUM_NAME(D3D11_RESOURCE_DIMENSION_UNKNOWN);
    ENUM_NAME(D3D11_RESOURCE_DIMENSION_BUFFER);
    ENUM_NAME(D3D11_RESOURCE_DIMENSION_TEXTURE1D);
    ENUM_NAME(D3D11_RESOURCE_DIMENSION_TEXTURE2D);
    ENUM_NAME(D3D11_RESOURCE_DIMENSION_TEXTURE3D);
    ENUM_DEFAULT(e);
  }
}

std::ostream &
operator<<(std::ostream &os, DXGI_FORMAT e) {
  switch (e) {
    ENUM_NAME(DXGI_FORMAT_UNKNOWN);
    ENUM_NAME(DXGI_FORMAT_R32G32B32A32_TYPELESS);
    ENUM_NAME(DXGI_FORMAT_R32G32B32A32_FLOAT);
    ENUM_NAME(DXGI_FORMAT_R32G32B32A32_UINT);
    ENUM_NAME(DXGI_FORMAT_R32G32B32A32_SINT);
    ENUM_NAME(DXGI_FORMAT_R32G32B32_TYPELESS);
    ENUM_NAME(DXGI_FORMAT_R32G32B32_FLOAT);
    ENUM_NAME(DXGI_FORMAT_R32G32B32_UINT);
    ENUM_NAME(DXGI_FORMAT_R32G32B32_SINT);
    ENUM_NAME(DXGI_FORMAT_R16G16B16A16_TYPELESS);
    ENUM_NAME(DXGI_FORMAT_R16G16B16A16_FLOAT);
    ENUM_NAME(DXGI_FORMAT_R16G16B16A16_UNORM);
    ENUM_NAME(DXGI_FORMAT_R16G16B16A16_UINT);
    ENUM_NAME(DXGI_FORMAT_R16G16B16A16_SNORM);
    ENUM_NAME(DXGI_FORMAT_R16G16B16A16_SINT);
    ENUM_NAME(DXGI_FORMAT_R32G32_TYPELESS);
    ENUM_NAME(DXGI_FORMAT_R32G32_FLOAT);
    ENUM_NAME(DXGI_FORMAT_R32G32_UINT);
    ENUM_NAME(DXGI_FORMAT_R32G32_SINT);
    ENUM_NAME(DXGI_FORMAT_R32G8X24_TYPELESS);
    ENUM_NAME(DXGI_FORMAT_D32_FLOAT_S8X24_UINT);
    ENUM_NAME(DXGI_FORMAT_R32_FLOAT_X8X24_TYPELESS);
    ENUM_NAME(DXGI_FORMAT_X32_TYPELESS_G8X24_UINT);
    ENUM_NAME(DXGI_FORMAT_R10G10B10A2_TYPELESS);
    ENUM_NAME(DXGI_FORMAT_R10G10B10A2_UNORM);
    ENUM_NAME(DXGI_FORMAT_R10G10B10A2_UINT);
    ENUM_NAME(DXGI_FORMAT_R11G11B10_FLOAT);
    ENUM_NAME(DXGI_FORMAT_R8G8B8A8_TYPELESS);
    ENUM_NAME(DXGI_FORMAT_R8G8B8A8_UNORM);
    ENUM_NAME(DXGI_FORMAT_R8G8B8A8_UNORM_SRGB);
    ENUM_NAME(DXGI_FORMAT_R8G8B8A8_UINT);
    ENUM_NAME(DXGI_FORMAT_R8G8B8A8_SNORM);
    ENUM_NAME(DXGI_FORMAT_R8G8B8A8_SINT);
    ENUM_NAME(DXGI_FORMAT_R16G16_TYPELESS);
    ENUM_NAME(DXGI_FORMAT_R16G16_FLOAT);
    ENUM_NAME(DXGI_FORMAT_R16G16_UNORM);
    ENUM_NAME(DXGI_FORMAT_R16G16_UINT);
    ENUM_NAME(DXGI_FORMAT_R16G16_SNORM);
    ENUM_NAME(DXGI_FORMAT_R16G16_SINT);
    ENUM_NAME(DXGI_FORMAT_R32_TYPELESS);
    ENUM_NAME(DXGI_FORMAT_D32_FLOAT);
    ENUM_NAME(DXGI_FORMAT_R32_FLOAT);
    ENUM_NAME(DXGI_FORMAT_R32_UINT);
    ENUM_NAME(DXGI_FORMAT_R32_SINT);
    ENUM_NAME(DXGI_FORMAT_R24G8_TYPELESS);
    ENUM_NAME(DXGI_FORMAT_D24_UNORM_S8_UINT);
    ENUM_NAME(DXGI_FORMAT_R24_UNORM_X8_TYPELESS);
    ENUM_NAME(DXGI_FORMAT_X24_TYPELESS_G8_UINT);
    ENUM_NAME(DXGI_FORMAT_R8G8_TYPELESS);
    ENUM_NAME(DXGI_FORMAT_R8G8_UNORM);
    ENUM_NAME(DXGI_FORMAT_R8G8_UINT);
    ENUM_NAME(DXGI_FORMAT_R8G8_SNORM);
    ENUM_NAME(DXGI_FORMAT_R8G8_SINT);
    ENUM_NAME(DXGI_FORMAT_R16_TYPELESS);
    ENUM_NAME(DXGI_FORMAT_R16_FLOAT);
    ENUM_NAME(DXGI_FORMAT_D16_UNORM);
    ENUM_NAME(DXGI_FORMAT_R16_UNORM);
    ENUM_NAME(DXGI_FORMAT_R16_UINT);
    ENUM_NAME(DXGI_FORMAT_R16_SNORM);
    ENUM_NAME(DXGI_FORMAT_R16_SINT);
    ENUM_NAME(DXGI_FORMAT_R8_TYPELESS);
    ENUM_NAME(DXGI_FORMAT_R8_UNORM);
    ENUM_NAME(DXGI_FORMAT_R8_UINT);
    ENUM_NAME(DXGI_FORMAT_R8_SNORM);
    ENUM_NAME(DXGI_FORMAT_R8_SINT);
    ENUM_NAME(DXGI_FORMAT_A8_UNORM);
    ENUM_NAME(DXGI_FORMAT_R1_UNORM);
    ENUM_NAME(DXGI_FORMAT_R9G9B9E5_SHAREDEXP);
    ENUM_NAME(DXGI_FORMAT_R8G8_B8G8_UNORM);
    ENUM_NAME(DXGI_FORMAT_G8R8_G8B8_UNORM);
    ENUM_NAME(DXGI_FORMAT_BC1_TYPELESS);
    ENUM_NAME(DXGI_FORMAT_BC1_UNORM);
    ENUM_NAME(DXGI_FORMAT_BC1_UNORM_SRGB);
    ENUM_NAME(DXGI_FORMAT_BC2_TYPELESS);
    ENUM_NAME(DXGI_FORMAT_BC2_UNORM);
    ENUM_NAME(DXGI_FORMAT_BC2_UNORM_SRGB);
    ENUM_NAME(DXGI_FORMAT_BC3_TYPELESS);
    ENUM_NAME(DXGI_FORMAT_BC3_UNORM);
    ENUM_NAME(DXGI_FORMAT_BC3_UNORM_SRGB);
    ENUM_NAME(DXGI_FORMAT_BC4_TYPELESS);
    ENUM_NAME(DXGI_FORMAT_BC4_UNORM);
    ENUM_NAME(DXGI_FORMAT_BC4_SNORM);
    ENUM_NAME(DXGI_FORMAT_BC5_TYPELESS);
    ENUM_NAME(DXGI_FORMAT_BC5_UNORM);
    ENUM_NAME(DXGI_FORMAT_BC5_SNORM);
    ENUM_NAME(DXGI_FORMAT_B5G6R5_UNORM);
    ENUM_NAME(DXGI_FORMAT_B5G5R5A1_UNORM);
    ENUM_NAME(DXGI_FORMAT_B8G8R8A8_UNORM);
    ENUM_NAME(DXGI_FORMAT_B8G8R8X8_UNORM);
    ENUM_NAME(DXGI_FORMAT_R10G10B10_XR_BIAS_A2_UNORM);
    ENUM_NAME(DXGI_FORMAT_B8G8R8A8_TYPELESS);
    ENUM_NAME(DXGI_FORMAT_B8G8R8A8_UNORM_SRGB);
    ENUM_NAME(DXGI_FORMAT_B8G8R8X8_TYPELESS);
    ENUM_NAME(DXGI_FORMAT_B8G8R8X8_UNORM_SRGB);
    ENUM_NAME(DXGI_FORMAT_BC6H_TYPELESS);
    ENUM_NAME(DXGI_FORMAT_BC6H_UF16);
    ENUM_NAME(DXGI_FORMAT_BC6H_SF16);
    ENUM_NAME(DXGI_FORMAT_BC7_TYPELESS);
    ENUM_NAME(DXGI_FORMAT_BC7_UNORM);
    ENUM_NAME(DXGI_FORMAT_BC7_UNORM_SRGB);
    ENUM_NAME(DXGI_FORMAT_AYUV);
    ENUM_NAME(DXGI_FORMAT_Y410);
    ENUM_NAME(DXGI_FORMAT_Y416);
    ENUM_NAME(DXGI_FORMAT_NV12);
    ENUM_NAME(DXGI_FORMAT_P010);
    ENUM_NAME(DXGI_FORMAT_P016);
    ENUM_NAME(DXGI_FORMAT_420_OPAQUE);
    ENUM_NAME(DXGI_FORMAT_YUY2);
    ENUM_NAME(DXGI_FORMAT_Y210);
    ENUM_NAME(DXGI_FORMAT_Y216);
    ENUM_NAME(DXGI_FORMAT_NV11);
    ENUM_NAME(DXGI_FORMAT_AI44);
    ENUM_NAME(DXGI_FORMAT_IA44);
    ENUM_NAME(DXGI_FORMAT_P8);
    ENUM_NAME(DXGI_FORMAT_A8P8);
    ENUM_NAME(DXGI_FORMAT_B4G4R4A4_UNORM);
    ENUM_DEFAULT(e);
  }
}

std::ostream &
operator<<(std::ostream &os, WMTPixelFormat e) {
  switch (e) {
    ENUM_NAME(WMTPixelFormatInvalid);
    ENUM_NAME(WMTPixelFormatA8Unorm);
    ENUM_NAME(WMTPixelFormatR8Unorm);
    ENUM_NAME(WMTPixelFormatR8Unorm_sRGB);
    ENUM_NAME(WMTPixelFormatR8Snorm);
    ENUM_NAME(WMTPixelFormatR8Uint);
    ENUM_NAME(WMTPixelFormatR8Sint);
    ENUM_NAME(WMTPixelFormatR16Unorm);
    ENUM_NAME(WMTPixelFormatR16Snorm);
    ENUM_NAME(WMTPixelFormatR16Uint);
    ENUM_NAME(WMTPixelFormatR16Sint);
    ENUM_NAME(WMTPixelFormatR16Float);
    ENUM_NAME(WMTPixelFormatRG8Unorm);
    ENUM_NAME(WMTPixelFormatRG8Unorm_sRGB);
    ENUM_NAME(WMTPixelFormatRG8Snorm);
    ENUM_NAME(WMTPixelFormatRG8Uint);
    ENUM_NAME(WMTPixelFormatRG8Sint);
    ENUM_NAME(WMTPixelFormatB5G6R5Unorm);
    ENUM_NAME(WMTPixelFormatA1BGR5Unorm);
    ENUM_NAME(WMTPixelFormatABGR4Unorm);
    ENUM_NAME(WMTPixelFormatBGR5A1Unorm);
    ENUM_NAME(WMTPixelFormatR32Uint);
    ENUM_NAME(WMTPixelFormatR32Sint);
    ENUM_NAME(WMTPixelFormatR32Float);
    ENUM_NAME(WMTPixelFormatRG16Unorm);
    ENUM_NAME(WMTPixelFormatRG16Snorm);
    ENUM_NAME(WMTPixelFormatRG16Uint);
    ENUM_NAME(WMTPixelFormatRG16Sint);
    ENUM_NAME(WMTPixelFormatRG16Float);
    ENUM_NAME(WMTPixelFormatRGBA8Unorm);
    ENUM_NAME(WMTPixelFormatRGBA8Unorm_sRGB);
    ENUM_NAME(WMTPixelFormatRGBA8Snorm);
    ENUM_NAME(WMTPixelFormatRGBA8Uint);
    ENUM_NAME(WMTPixelFormatRGBA8Sint);
    ENUM_NAME(WMTPixelFormatBGRA8Unorm);
    ENUM_NAME(WMTPixelFormatBGRA8Unorm_sRGB);
    ENUM_NAME(WMTPixelFormatRGB10A2Unorm);
    ENUM_NAME(WMTPixelFormatRGB10A2Uint);
    ENUM_NAME(WMTPixelFormatRG11B10Float);
    ENUM_NAME(WMTPixelFormatRGB9E5Float);
    ENUM_NAME(WMTPixelFormatBGR10A2Unorm);
    ENUM_NAME(WMTPixelFormatRG32Uint);
    ENUM_NAME(WMTPixelFormatRG32Sint);
    ENUM_NAME(WMTPixelFormatRG32Float);
    ENUM_NAME(WMTPixelFormatRGBA16Unorm);
    ENUM_NAME(WMTPixelFormatRGBA16Snorm);
    ENUM_NAME(WMTPixelFormatRGBA16Uint);
    ENUM_NAME(WMTPixelFormatRGBA16Sint);
    ENUM_NAME(WMTPixelFormatRGBA16Float);
    ENUM_NAME(WMTPixelFormatRGBA32Uint);
    ENUM_NAME(WMTPixelFormatRGBA32Sint);
    ENUM_NAME(WMTPixelFormatRGBA32Float);
    ENUM_NAME(WMTPixelFormatBC1_RGBA);
    ENUM_NAME(WMTPixelFormatBC1_RGBA_sRGB);
    ENUM_NAME(WMTPixelFormatBC2_RGBA);
    ENUM_NAME(WMTPixelFormatBC2_RGBA_sRGB);
    ENUM_NAME(WMTPixelFormatBC3_RGBA);
    ENUM_NAME(WMTPixelFormatBC3_RGBA_sRGB);
    ENUM_NAME(WMTPixelFormatBC4_RUnorm);
    ENUM_NAME(WMTPixelFormatBC4_RSnorm);
    ENUM_NAME(WMTPixelFormatBC5_RGUnorm);
    ENUM_NAME(WMTPixelFormatBC5_RGSnorm);
    ENUM_NAME(WMTPixelFormatBC6H_RGBFloat);
    ENUM_NAME(WMTPixelFormatBC6H_RGBUfloat);
    ENUM_NAME(WMTPixelFormatBC7_RGBAUnorm);
    ENUM_NAME(WMTPixelFormatBC7_RGBAUnorm_sRGB);
    ENUM_NAME(WMTPixelFormatPVRTC_RGB_2BPP);
    ENUM_NAME(WMTPixelFormatPVRTC_RGB_2BPP_sRGB);
    ENUM_NAME(WMTPixelFormatPVRTC_RGB_4BPP);
    ENUM_NAME(WMTPixelFormatPVRTC_RGB_4BPP_sRGB);
    ENUM_NAME(WMTPixelFormatPVRTC_RGBA_2BPP);
    ENUM_NAME(WMTPixelFormatPVRTC_RGBA_2BPP_sRGB);
    ENUM_NAME(WMTPixelFormatPVRTC_RGBA_4BPP);
    ENUM_NAME(WMTPixelFormatPVRTC_RGBA_4BPP_sRGB);
    ENUM_NAME(WMTPixelFormatEAC_R11Unorm);
    ENUM_NAME(WMTPixelFormatEAC_R11Snorm);
    ENUM_NAME(WMTPixelFormatEAC_RG11Unorm);
    ENUM_NAME(WMTPixelFormatEAC_RG11Snorm);
    ENUM_NAME(WMTPixelFormatEAC_RGBA8);
    ENUM_NAME(WMTPixelFormatEAC_RGBA8_sRGB);
    ENUM_NAME(WMTPixelFormatETC2_RGB8);
    ENUM_NAME(WMTPixelFormatETC2_RGB8_sRGB);
    ENUM_NAME(WMTPixelFormatETC2_RGB8A1);
    ENUM_NAME(WMTPixelFormatETC2_RGB8A1_sRGB);
    ENUM_NAME(WMTPixelFormatASTC_4x4_sRGB);
    ENUM_NAME(WMTPixelFormatASTC_5x4_sRGB);
    ENUM_NAME(WMTPixelFormatASTC_5x5_sRGB);
    ENUM_NAME(WMTPixelFormatASTC_6x5_sRGB);
    ENUM_NAME(WMTPixelFormatASTC_6x6_sRGB);
    ENUM_NAME(WMTPixelFormatASTC_8x5_sRGB);
    ENUM_NAME(WMTPixelFormatASTC_8x6_sRGB);
    ENUM_NAME(WMTPixelFormatASTC_8x8_sRGB);
    ENUM_NAME(WMTPixelFormatASTC_10x5_sRGB);
    ENUM_NAME(WMTPixelFormatASTC_10x6_sRGB);
    ENUM_NAME(WMTPixelFormatASTC_10x8_sRGB);
    ENUM_NAME(WMTPixelFormatASTC_10x10_sRGB);
    ENUM_NAME(WMTPixelFormatASTC_12x10_sRGB);
    ENUM_NAME(WMTPixelFormatASTC_12x12_sRGB);
    ENUM_NAME(WMTPixelFormatASTC_4x4_LDR);
    ENUM_NAME(WMTPixelFormatASTC_5x4_LDR);
    ENUM_NAME(WMTPixelFormatASTC_5x5_LDR);
    ENUM_NAME(WMTPixelFormatASTC_6x5_LDR);
    ENUM_NAME(WMTPixelFormatASTC_6x6_LDR);
    ENUM_NAME(WMTPixelFormatASTC_8x5_LDR);
    ENUM_NAME(WMTPixelFormatASTC_8x6_LDR);
    ENUM_NAME(WMTPixelFormatASTC_8x8_LDR);
    ENUM_NAME(WMTPixelFormatASTC_10x5_LDR);
    ENUM_NAME(WMTPixelFormatASTC_10x6_LDR);
    ENUM_NAME(WMTPixelFormatASTC_10x8_LDR);
    ENUM_NAME(WMTPixelFormatASTC_10x10_LDR);
    ENUM_NAME(WMTPixelFormatASTC_12x10_LDR);
    ENUM_NAME(WMTPixelFormatASTC_12x12_LDR);
    ENUM_NAME(WMTPixelFormatASTC_4x4_HDR);
    ENUM_NAME(WMTPixelFormatASTC_5x4_HDR);
    ENUM_NAME(WMTPixelFormatASTC_5x5_HDR);
    ENUM_NAME(WMTPixelFormatASTC_6x5_HDR);
    ENUM_NAME(WMTPixelFormatASTC_6x6_HDR);
    ENUM_NAME(WMTPixelFormatASTC_8x5_HDR);
    ENUM_NAME(WMTPixelFormatASTC_8x6_HDR);
    ENUM_NAME(WMTPixelFormatASTC_8x8_HDR);
    ENUM_NAME(WMTPixelFormatASTC_10x5_HDR);
    ENUM_NAME(WMTPixelFormatASTC_10x6_HDR);
    ENUM_NAME(WMTPixelFormatASTC_10x8_HDR);
    ENUM_NAME(WMTPixelFormatASTC_10x10_HDR);
    ENUM_NAME(WMTPixelFormatASTC_12x10_HDR);
    ENUM_NAME(WMTPixelFormatASTC_12x12_HDR);
    ENUM_NAME(WMTPixelFormatGBGR422);
    ENUM_NAME(WMTPixelFormatBGRG422);
    ENUM_NAME(WMTPixelFormatDepth16Unorm);
    ENUM_NAME(WMTPixelFormatDepth32Float);
    ENUM_NAME(WMTPixelFormatStencil8);
    ENUM_NAME(WMTPixelFormatDepth24Unorm_Stencil8);
    ENUM_NAME(WMTPixelFormatDepth32Float_Stencil8);
    ENUM_NAME(WMTPixelFormatX32_Stencil8);
    ENUM_NAME(WMTPixelFormatX24_Stencil8);
    ENUM_NAME(WMTPixelFormatBGRA10_XR);
    ENUM_NAME(WMTPixelFormatBGRA10_XR_sRGB);
    ENUM_NAME(WMTPixelFormatBGR10_XR);
    ENUM_NAME(WMTPixelFormatBGR10_XR_sRGB);
    ENUM_DEFAULT(e);
  }
}