/* soundfile.h - low-level sound file I/O interface.
 *
 * Copyright 2010 Petteri Hintsanen <petterih@iki.fi>
 *
 * This file is part of abx.
 *
 * abx is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * abx is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with abx.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef ABX_SOUNDFILE_H
#define ABX_SOUNDFILE_H

/* sound metadata structure */
typedef struct {
    char *filename;
    int bits;                   /* bits per sample */
    int channels;               /* number of channels */
    int frames;                 /* number of frames */
    int rate;                   /* sampling rate */

    /* some derived numbers for convenience */
    double duration;            /* duration in seconds */
    unsigned int minutes;       /* duration, minutes part */
    unsigned int seconds;       /* duration, seconds part */
} Metadata;

typedef struct Sound_file Sound_file;

extern Sound_file *open_sound_file(const char *filename);
extern int close_sound_file(Sound_file *sndfile);
extern Metadata get_metadata(Sound_file *sndfile);
extern double seek_sound_file(Sound_file *sndfile, double offset,
                              int whence);
extern unsigned int read_pcm_data(Sound_file *sndfile, 
                                  float *buf, unsigned int nframes);

#endif
