      SUBROUTINE IRREPGET(PTGRPX,IORDGP,Z,V,LENTOT,LENGTH,LENMAX,
     &                    NDEG,IPTR,NBFATM,ILCATM,SYOP,SCRATCH,
     &                    NATOMS,IRREP,NBAS,NBASX,IANG)
C
C THIS SUBROUTINE FUNCTIONS TO DETERMINE THE IRREDUCIBLE REPRESENTATION
C  TO WHICH THE VECTOR V BELONGS.  V CAN BE EXPRESSED IN A NUMBER OF 
C  REPRESENTATIONS.  
C
C INPUT:
C    PTGRPX (CHARACTER*4) - THE POINT GROUP OF THE MOLECULE
C    IORDGP               - THE ORDER OF THE POINT GROUP
C    Z                    - A SCRATCH VECTOR OF LENGTH IORDGP WHICH
C                           IS USED TO HOLD THE CHARACTERS
C    V (DOUBLE PRECISION) - THE VECTOR WHICH IS GOING TO BE ASSIGNED
C                           TO A PARTICULAR IRREP OF THE GROUP.  IF
C                           THE VECTOR IS ASSOCIATED WITH A DEGENERATE
C                           EIGENVALUE, THEN V HOLDS ALL EIGENVECTORS
C                           OF THE EIGENVALUE 
C    LENTOT               - THE TOTAL LENGTH OF V (SEE ABOVE)
C    LENGTH               - A VECTOR (OF LENGTH 5) GIVING THE LOGICAL
C                           LENGTH OF EACH EIGENVECTOR IN V.  (THEY
C                           ARE ALMOST ALWAYS EQUAL) [SEE NBAS BELOW]
C    LENMAX               - NDEG*MAXIMUM VALUE IN LENGTH ARRAY [NBAS]
C    NDEG                 - THE LEVEL OF DEGENERACY ASSOCIATED WITH V
C    IPTR                 - THE SYMMETRY POINTER VECTOR RELATING ATOMIC
C                           POSITIONS WITH THEIR IMAGE UNDER THE SYMOPS.
C    NBFATM               - AN INTEGER VECTOR RELATING THE CENTER NUMBER
C                           TO THE NUMBER OF ELEMENTS IN EACH EIGENVECTOR
C                           WHICH ARE ASSOCIATED WITH IT
C    ILCATM               - A VECTOR WHICH GIVES THE STARTING POSITION OF
C                           EACH CENTER IN AN EIGENVECTOR
C    SYOP                 - THE SET OF 3x3 CARTESIAN SYMMETRY OPERATIONS
C    NATOMS               - THE NUMBER OF CENTERS IN EACH EIGENVECTOR
C    NBAS                 - THE MAXIMUM LENGTH OF AN EIGENVECTOR IN V
C                           ***NOTE THAT THIS VALUE IS USED AS A LEADING
C                              DIMENSION IN THE V ARRAY***
C    IANG                 - A NUMBER GIVING THE REPRESENTATION IN WHICH
C                           V IS EXPRESSED.  
C                              0=POSITION REPRESENTATION (LIKE S FUNCS)
C                              1=DIRPRD(POSITION,XYZ) (LIKE P FUNCS)
C                              2=DIRPRD(DIRPRD(POSITION,XYZ),XYZ) (LIKE D)
C    SCRATCH              - A WORKING SCRATCH AREA OF MINIMUM LENGTH
C                           MAX(3^{IANG},NATOMS*3)
C
C RETURNED:
C
C    IRREP                - THE IRREDUCIBLE REPRESENTATION OF V
C
CEND
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      INTEGER ATOI
      CHARACTER*4 PTGRP,PTGRPX
      CHARACTER*4 IRREP
      DIMENSION V(LENGTH,5),SCRATCH(1),NBFATM(NATOMS)
      DIMENSION IPTR(1),ILCATM(NATOMS),SYOP(1),Z(IORDGP)
      COMMON /FLAGS/ IFLAGS(100)
      COMMON /SYMCHAR/ CHAR
C     
C     If the length of the vector is zero, return immediately
C     to avoid division by zero.
C     
      If (Length .eq. 0) Return
C
C APPLY ALL SYMMETRY OPERATIONS OF THE GROUP TO THE VECTOR AND
C CALCULATE THE CHARACTERS.
C
      CALL ZERO(Z,IORDGP)
      DO 100 I=1,IORDGP
       CALL IMAGE(NATOMS,LENGTH,NDEG,I,IPTR,NBFATM,
     &            ILCATM,V,SCRATCH,SCRATCH(NDEG*LENGTH+1),
     &            IANG,NBASX,SYOP,0)
       Z(I)=CHAR
100   CONTINUE
C
C OLD CODE BELOW.  CHAR IS NOW PASSED VIA COMMON DIRECTLY FROM
C IMAGE.  CHANGE NECESSARY BECAUSE PROPER NORMALIZATION OF D,F, ETC
C FUNCTIONS IS TRICKY AND MORE EASILY HANDLED IN IMAGE.  
C
c       IOFF=1
c       DO 110 J=1,NDEG
c        Z0=1.D0/SNRM2(LENGTH,V(1,J),1)
c        z1=1.D0/snrm2(length,scratch(ioff),1)
c        write(6,*)' z0 and z1 are ',z0,z1
c        Z(I)=Z(I)+SDOT(LENGTH,V(1,J),1,SCRATCH(IOFF),1)*Z0*Z1
c        IOFF=IOFF+LENGTH
c110    CONTINUE
c100   CONTINUE
C
C PRINT CHARACTERS IF PRINT IS TURNED WAY UP
C
      IF(IFLAGS(1).GT.100)THEN
       WRITE(6,1000)PTGRPX
1000   FORMAT(T3,'@IRREPGET-I, Characters under operations of ',A,':')
       IPASS=1+(IORDGP-1)/10
       IBOT=1
       DO 1100 I=1,IPASS
        ITOP=MIN(IBOT+9,IORDGP)
        WRITE(6,'((10I7))')(IJ,IJ=IBOT,ITOP)
        WRITE(6,'((10F7.4))')(Z(IJ),IJ=IBOT,ITOP)
        IBOT=IBOT+10
1100   CONTINUE
      ENDIF
C
C DETERMINE THE IRREP OF THIS REPRESENTATION
C
      CALL ASSIRR(PTGRPX,Z,NDEG,IRREP)
      RETURN
      END
