C------------------------------------------------------------------------
C  INCLUDE FILE: ERD__FTABLE
C  MODULE      : ELECTRON REPULSION INTEGRALS DIRECT
C  MODULE-ID   : ERD
C  DESCRIPTION : Include file used for Taylor expansion of auxillary
C                integrals Fm (T).
C
C
C                  Table characteristics:
C
C                    Maximum m in Fm (T)  = 10
C                    Maximum T in Fm (T)  = 46
C                    Interpolation steps = 0.05
C
C
C                  Data in table:
C
C                    FTABLE       =  table of auxillary integrals Fm (T)
C                                    for interpolation use
C                    TMAX         =  maximum T in table of Fm (T)'s
C                    TSTEP        =  interpolation steps for T in table
C                                    of Fm (T)'s
C                    TVSTEP       =  inverse of TSTEP
C
C
C                  Location of FTABLE data (dimensions MGRID x NGRID):
C
C                    FTABLE (M,T) =  Fm (T)   ;  0 =< M =< MGRID
C                                                0 =< T =< 46 step 0.05
C
C  AUTHOR      : Norbert Flocke
C------------------------------------------------------------------------
C
C
C             ...declare and set the data.
C
C
         INTEGER   I,J
         INTEGER   MGRID
         INTEGER   NGRID

         PARAMETER  (MGRID  = 10)
         PARAMETER  (NGRID = 920)

         DOUBLE PRECISION    TMAX
         DOUBLE PRECISION    TSTEP
         DOUBLE PRECISION    TVSTEP

         DOUBLE PRECISION    FTABLE (0:MGRID,0:NGRID)

         DATA  TMAX    / 46.000000000000000D0/
         DATA  TSTEP   /   .050000000000000D0/
         DATA  TVSTEP  / 20.000000000000000D0/

         DATA  ((FTABLE (I,J),I=0,10),J=  0,  9)
     +     /1.000000000000000D0, .333333333333333D0, .200000000000000D0,
     +       .142857142857143D0, .111111111111111D0, .090909090909091D0,
     +       .076923076923077D0, .066666666666667D0, .058823529411765D0,
     +       .052631578947368D0, .047619047619048D0, .983580385842959D0,
     +       .323509613422450D0, .192994157666346D0, .137413638310181D0,
     +       .106660436705514D0, .087145058489144D0, .073662188798712D0,
     +       .063790298825366D0, .056250578797778D0, .050304150615128D0,
     +       .045494371867164D0, .967643312635592D0, .314029472998161D0,
     +       .186255004792621D0, .132188029635739D0, .102393947071065D0,
     +       .083540528018141D0, .070541950817984D0, .061039712989142D0,
     +       .053791384005819D0, .048080550314778D0, .043465189724101D0,
     +       .952171930273449D0, .304879846161303D0, .179771873529508D0,
     +       .127171304074947D0, .098303840331894D0, .080088621873286D0,
     +       .067556213936973D0, .058409349185289D0, .051440871180917D0,
     +       .045956112168412D0, .041527182582549D0, .937150028797979D0,
     +       .296048189299992D0, .173534537054986D0, .122354830492368D0,
     +       .094382650921487D0, .076782763038513D0, .064699100864166D0,
     +       .055893895390439D0, .049194194446507D0, .043926381281596D0,
     +       .039676228180875D0, .922562012825585D0, .287522459508360D0,
     +       .167533190907351D0, .117730342930696D0, .090623234886940D0,
     +       .073616661822110D0, .061964993943621D0, .053488276391324D0,
     +       .047046725596908D0, .041987104152047D0, .037908391634972D0,
     +       .908392877032751D0, .279291093918388D0, .161758435122409D0,
     +       .113289924883880D0, .087018755842400D0, .070584303166469D0,
     +       .059348523582399D0, .051187643149114D0, .044994044258325D0,
     +       .040134219516345D0, .036219916881389D0, .894628182652567D0,
     +       .271342989905505D0, .156201257139716D0, .109025994256952D0,
     +       .083562671542786D0, .067679934523372D0, .056844557197679D0,
     +       .048987362644441D0, .043031928496997D0, .038363849614615D0,
     +       .034607218512822D0, .881254034939924D0, .263667486130356D0,
     +       .150853015444288D0, .104931288982249D0, .080248721050131D0,
     +       .064898054269425D0, .054448188660050D0, .046883008181259D0,
     +       .041156345854049D0, .036672291853998D0, .033066873987895D0,
     +       .868257061564465D0, .256254344380769D0, .145705423911703D0,
     +       .100998853263045D0, .077070912466158D0, .062233400637391D0,
     +       .052154728210585D0, .044870350128707D0, .039363444787597D0,
     +       .035056010852631D0, .031595616198023D0/
         DATA  ((FTABLE (I,J),I=0,10),J= 10, 19)
     +     / .855624391892149D0, .249093732179515D0, .140750536825913D0,
     +       .097222024416930D0, .074023511205878D0, .059680941140265D0,
     +       .049959692830285D0, .042945347081075D0, .037649546503491D0,
     +       .033511630846714D0, .030190326374924D0, .843343637117978D0,
     +       .242176206124992D0, .135980734540445D0, .093594420292489D0,
     +       .071101028788122D0, .057235862466009D0, .047858797041466D0,
     +       .041104137416879D0, .036011137156993D0, .032035928443995D0,
     +       .028848027323112D0, .831402871214021D0, .235492695933329D0,
     +       .131388709754967D0, .090109927234008D0, .068298212120022D0,
     +       .054893560821813D0, .045847944121597D0, .039343031238943D0,
     +       .034444860408437D0, .030625825707839D0, .027565876962430D0,
     +       .819790612658427D0, .229034489151855D0, .126967454380422D0,
     +       .086762688570073D0, .065610033253455D0, .052649632707753D0,
     +       .043923217710974D0, .037658502678186D0, .032947510316749D0,
     +       .029278383556699D0, .026341162166356D0, .808495806912583D0,
     +       .222793216515124D0, .122710246967117D0, .083547093602981D0,
     +       .063031679592470D0, .050499866100585D0, .042080873796450D0,
     +       .036047182544598D0, .031516024555401D0, .027990795464574D0,
     +       .025171292882497D0, .797507809614984D0, .216760837915979D0,
     +       .118610640671282D0, .080457767076930D0, .060558544531665D0,
     +       .048440232029311D0, .040317333054272D0, .034505851309679D0,
     +       .030147477936118D0, .026760381448656D0, .024053796522294D0,
     +       .786816370461720D0, .210929628965312D0, .114662451736696D0,
     +       .077489559103912D0, .058186218506350D0, .046466876524958D0,
     +       .038629173535821D0, .033031432405285D0, .028839076226285D0,
     +       .025584582331017D0, .022986312607561D0, .776411617744798D0,
     +       .205292168115336D0, .110859748468989D0, .074637535527187D0,
     +       .055910480436226D0, .044576112927827D0, .037013123680803D0,
     +       .031620985824540D0, .027588150246693D0, .024460954261802D0,
     +       .021966587662061D0, .766284043520696D0, .199841324322276D0,
     +       .107196840681238D0, .071896968703107D0, .053727289545085D0,
     +       .042764414536202D0, .035466055643125D0, .030271702011126D0,
     +       .026392150236829D0, .023387163491945D0, .020992470336862D0,
     +       .756424489382800D0, .194570245225421D0, .103668269590400D0,
     +       .069263328682895D0, .051632777539874D0, .041028407581246D0,
     +       .033984978915373D0, .028980896023868D0, .025248640475536D0,
     +       .022360981384005D0, .020061906758730D0/
         DATA  ((FTABLE (I,J),I=0,10),J= 20, 29)
     +     / .746824132812427D0, .189472345820492D0, .100268798145017D0,
     +       .066732274776822D0, .049623241133157D0, .039364864513484D0,
     +       .032567034238442D0, .027746001964150D0, .024155294145404D0,
     +       .021380279650214D0, .019172936091315D0, .737474474084268D0,
     +       .184541297606244D0, .096993401765513D0, .064299647484004D0,
     +       .047695134893750D0, .037770697586949D0, .031209487783468D0,
     +       .026564567654249D0, .023109888429800D0, .020443025807358D0,
     +       .018323686299358D0, .728367323703093D0, .179771018184097D0,
     +       .093837259479187D0, .061961460771753D0, .045845064410997D0,
     +       .036242952727679D0, .029909725593813D0, .025434249555223D0,
     +       .022110299831936D0, .019547278838559D0, .017512370106608D0,
     +       .719494790349553D0, .175155661291522D0, .090795745432831D0,
     +       .059713894689175D0, .044069779758770D0, .034778803673860D0,
     +       .028665248275393D0, .024352807913504D0, .021154499705872D0,
     +       .018691185052509D0, .016737281138529D0, .710849269313849D0,
     +       .170689607250686D0, .087864420766607D0, .057553288300347D0,
     +       .042366169245927D0, .033375546375474D0, .027473665924173D0,
     +       .023318102125851D0, .020240549989818D0, .017872974131129D0,
     +       .015996790241354D0, .702423431396967D0, .166367453814711D0,
     +       .085039025833577D0, .055476132923078D0, .040731253440541D0,
     +       .032030593641872D0, .026332693280162D0, .022328086312765D0,
     +       .019366599132516D0, .017090955357030D0, .015289341969355D0,
     +       .694210212260006D0, .162184007394613D0, .082315472749933D0,
     +       .053479065659867D0, .039162179455790D0, .030741470026192D0,
     +       .025240145097729D0, .021380805090948D0, .018530878203924D0,
     +       .016343514012572D0, .014613451232636D0, .686202802202985D0,
     +       .158134274650775D0, .079689838261642D0, .051558863208267D0,
     +       .037656215485917D0, .029505806936059D0, .024193931722502D0,
     +       .020474389535789D0, .017731697181829D0, .015629107942668D0,
     +       .013967700098076D0, .678394636355279D0, .154213454433455D0,
     +       .077158356913842D0, .049712435938430D0, .036210745581215D0,
     +       .028321337960474D0, .023192054865572D0, .019607053325298D0,
     +       .016967441406379D0, .014946264273869D0, .013350734736394D0,
     +       .670779385260629D0, .150416930057528D0, .074717414509926D0,
     +       .047936822226150D0, .034823264651465D0, .027185894403238D0,
     +       .022232603566144D0, .018777089057267D0, .016236568194897D0,
     +       .014293576282572D0, .012761262508642D0/
         DATA  ((FTABLE (I,J),I=0,10),J= 30, 39)
     +     / .663350945840335D0, .146740261897302D0, .072363541847825D0,
     +       .046229183030232D0, .033491373687731D0, .026097401013716D0,
     +       .021313750334149D0, .017982864731838D0, .015537603609712D0,
     +       .013669700405558D0, .012198049185727D0, .656103432719009D0,
     +       .143179180287828D0, .070093408721529D0, .044586796703517D0,
     +       .032212775192863D0, .025053871906138D0, .020433747464765D0,
     +       .017222820392002D0, .014869139372027D0, .013073353386359D0,
     +       .011659916294865D0, .649031169897862D0, .139729578719752D0,
     +       .067903818176438D0, .043007054027354D0, .030985268811507D0,
     +       .024053406659034D0, .019590923517100D0, .016495464914889D0,
     +       .014229829915213D0, .012503309551238D0, .011145738587148D0,
     +       .642128682761166D0, .136387507315276D0, .065791701007599D0,
     +       .041487453459769D0, .029806747150797D0, .023094186586794D0,
     +       .018783679949692D0, .015799372947044D0, .013618389571183D0,
     +       .011958398208895D0, .010654441620680D0, .635390690402153D0,
     +       .133149166573358D0, .063754110490394D0, .040025596588011D0,
     +       .028675191783335D0, .022174471175672D0, .018010487905780D0,
     +       .015133181977178D0, .013033589883805D0, .011437501168223D0,
     +       .010184999453970D0, .628812098255143D0, .130010901372771D0,
     +       .061788217333676D0, .038619183776553D0, .027588669424408D0,
     +       .021292594676922D0, .017269885141627D0, .014495589540202D0,
     +       .012474257043594D0, .010939550368757D0, .009736432444556D0,
     +       .622387991021315D0, .126969195222147D0, .059891304845793D0,
     +       .037266010002049D0, .026545328275766D0, .020446962850086D0,
     +       .016560473091488D0, .013885350546598D0, .011939269438161D0,
     +       .010463525618654D0, .009307805148010D0, .616113625876012D0,
     +       .124020664746590D0, .058060764304363D0, .035963960867078D0,
     +       .025543394528626D0, .019636049849733D0, .015880914063089D0,
     +       .013301274731496D0, .011427555313192D0, .010008452435306D0,
     +       .008898224312755D0, .609984425946011D0, .121162054400888D0,
     +       .056294090521061D0, .034711008784913D0, .024581169018883D0,
     +       .018858395249291D0, .015229928557782D0, .012742224218034D0,
     +       .010938090538914D0, .009573399983922D0, .008506836966286D0,
     +       .603995974045666D0, .118390231399783D0, .054588877593034D0,
     +       .033505209327861D0, .023657024027824D0, .018112601195873D0,
     +       .014606292709767D0, .012207111189863D0, .010469896477288D0,
     +       .009157479109586D0, .008132828588623D0/
         DATA  ((FTABLE (I,J),I=0,10),J= 40, 49)
     +     / .598144006661304D0, .115702180856173D0, .052942814832976D0,
     +       .032344697732067D0, .022769400221965D0, .017397329690268D0,
     +       .014008835839083D0, .011694895667866D0, .010022037945344D0,
     +       .008759840458557D0, .007775421368994D0, .592424408173695D0,
     +       .113095001118510D0, .051353682870177D0, .031227685551971D0,
     +       .021916803725852D0, .016711299986552D0, .013436438113235D0,
     +       .011204583386404D0, .009593621270305D0, .008379672684726D0,
     +       .007433872541951D0, .586833205308847D0, .110565899299015D0,
     +       .049819349915253D0, .030152457457925D0, .021097803322022D0,
     +       .016053286106005D0, .012888028312635D0, .010735223764589D0,
     +       .009183792432348D0, .008016200737364D0, .007107472799268D0,
     +       .581366561807785D0, .108112186984718D0, .048337768181548D0,
     +       .029117368170755D0, .020311027772508D0, .015422114460250D0,
     +       .012362581695176D0, .010285907968323D0, .008791735291012D0,
     +       .007668684226444D0, .006795544774171D0, .576020773306375D0,
     +       .105731276123646D0, .046906970456501D0, .028120839527311D0,
     +       .019555163256556D0, .014816661578788D0, .011859117955530D0,
     +       .009855767058991D0, .008416669891485D0, .007336415862025D0,
     +       .006497441594577D0, .570792262416601D0, .103420675078830D0,
     +       .045525066816584D0, .027161357671345D0, .018828950919456D0,
     +       .014235851936276D0, .011376699274927D0, .009443970224930D0,
     +       .008057850847131D0, .007018719964304D0, .006212545502202D0,
     +       .565677574001107D0, .101177984843109D0, .044190241479679D0,
     +       .026237470364259D0, .018131184527611D0, .013678655875151D0,
     +       .010914428457361D0, .009049723091933D0, .007714565794824D0,
     +       .006714951041133D0, .005940266534504D0, .560673370633112D0,
     +       .099000895407992D0, .042900749789027D0, .025347784410550D0,
     +       .017460708225170D0, .013144087619358D0, .010471447148381D0,
     +       .008672266109234D0, .007386133919777D0, .006424492429929D0,
     +       .005680041266617D0, .555776428234163D0, .096887182280156D0,
     +       .041654915323137D0, .024490963192973D0, .016816414387792D0,
     +       .012631203375148D0, .010046934132754D0, .008310873007581D0,
     +       .007071904546731D0, .006146755001044D0, .005431331610505D0,
     +       .550983631882507D0, .094834703139416D0, .040451127126301D0,
     +       .023665724312681D0, .016197241569264D0, .012139099515104D0,
     +       .009640103707504D0, .007964849326159D0, .006771255794494D0,
     +       .005881175919801D0, .005193623668744D0/
         DATA  ((FTABLE (I,J),I=0,10),J= 50, 59)
     +     / .546291971785148D0, .092841394632250D0, .039287837054570D0,
     +       .022870837329790D0, .015602172536927D0, .011666910841688D0,
     +       .009250204126935D0, .007633531005251D0, .006483593290973D0,
     +       .005627217464527D0, .004966426640423D0, .541698539406959D0,
     +       .090905269295256D0, .038163557232277D0, .022105121600046D0,
     +       .015030232391994D0, .011213808926822D0, .008876516116448D0,
     +       .007316283041700D0, .006208348945951D0, .005384365898041D0,
     +       .004749271776791D0, .537200523750482D0, .089024412603105D0,
     +       .037076857614420D0, .021367444203416D0, .014480486771073D0,
     +       .010779000524101D0, .008518351452072D0, .007012498204346D0,
     +       .005944979779010D0, .005152130390160D0, .004541711384368D0,
     +       .532795207780330D0, .087196980135830D0, .036026363650389D0,
     +       .020656717960663D0, .013952040125323D0, .010361726050468D0,
     +       .008175051602777D0, .006721595806730D0, .005692966800097D0,
     +       .004930041988909D0, .004343317873366D0, .528479964986347D0,
     +       .085421194860481D0, .035010754044758D0, .019971899534082D0,
     +       .013444034073856D0, .009961258134250D0, .007845986432779D0,
     +       .006443020534513D0, .005451813940361D0, .004717652638221D0,
     +       .004153682849341D0, .524252256079918D0, .083695344522402D0,
     +       .034028758611000D0, .019311987608780D0, .012955645828137D0,
     +       .009576900226641D0, .007530552961153D0, .006176241325143D0,
     +       .005221047030988D0, .004514534240015D0, .003972416246105D0,
     +       .520109625818075D0, .082017779141582D0, .033079156214201D0,
     +       .018676021151034D0, .012486086684289D0, .009207985273818D0,
     +       .007228174176211D0, .005920750297415D0, .005000212827859D0,
     +       .004320277758639D0, .003799145498021D0, .516049699950252D0,
     +       .080386908609722D0, .032160772799005D0, .018063077740383D0,
     +       .012034600580324D0, .008853874447031D0, .006938297902193D0,
     +       .005676061728713D0, .004788878079975D0, .004134492365743D0,
     +       .003633514749873D0, .512070182282748D0, .078801200383852D0,
     +       .031272479499164D0, .017472271972312D0, .011600462715479D0,
     +       .008513955928087D0, .006660395715956D0, .005441711077763D0,
     +       .004586628639662D0, .003956804623766D0, .003475184102610D0,
     +       .508168851856189D0, .077259177272501D0, .030413190825266D0,
     +       .016902753928457D0, .011182978228944D0, .008187643747807D0,
     +       .006393961911432D0, .005217254050879D0, .004393068612670D0,
     +       .003786857706263D0, .003323828893316D0/
         DATA  ((FTABLE (I,J),I=0,10),J= 60, 69)
     +     / .504343560231439D0, .075759415310596D0, .029581862927321D0,
     +       .016353707711456D0, .010781480935389D0, .007874376675106D0,
     +       .006138512509716D0, .005002265709741D0, .004207819546375D0,
     +       .003624310653420D0, .003179139007852D0, .500592228879628D0,
     +       .074300541719424D0, .028777491929038D0, .015824350041647D0,
     +       .010395332114818D0, .007573617154463D0, .005893584312778D0,
     +       .004796339618849D0, .004030519654359D0, .003468837661141D0,
     +       .003040818224679D0, .496912846672131D0, .072881232948157D0,
     +       .027999112330792D0, .015313928912968D0, .010023919354391D0,
     +       .007284850289670D0, .005658733998841D0, .004599087030868D0,
     +       .003860823075720D0, .003320127402206D0, .002908583588443D0,
     +       .493303467466497D0, .071500212793565D0, .027245795478358D0,
     +       .014821722305516D0, .009666655439932D0, .007007582871801D0,
     +       .005433537257582D0, .004410136108179D0, .003698399167563D0,
     +       .003177882378020D0, .002782164811959D0, .489762207784512D0,
     +       .070156250594710D0, .026516648094651D0, .014347036952326D0,
     +       .009322977294987D0, .006741342449456D0, .005217587963382D0,
     +       .004229131179001D0, .003542931829163D0, .003041818299595D0,
     +       .002661303705304D0, .486287244578707D0, .068848159499536D0,
     +       .025810810871829D0, .013889207158065D0, .008992344965343D0,
     +       .006485676439441D0, .005010497384943D0, .004055732026545D0,
     +       .003394118856377D0, .002911663496414D0, .002545753630793D0,
     +       .482876813083813D0, .067574794800390D0, .025127457121201D0,
     +       .013447593667389D0, .008674240647043D0, .006240151276083D0,
     +       .004811893429647D0, .003889613209723D0, .003251671324939D0,
     +       .002787158351928D0, .002435278982636D0, .479529204749764D0,
     +       .066335052335660D0, .024465791478527D0, .013021582580864D0,
     +       .008368167756001D0, .006004351597487D0, .004621419921121D0,
     +       .003730463413990D0, .003115313001344D0, .002668054764477D0,
     +       .002329654690182D0, .476242765253032D0, .065127866954810D0,
     +       .023825048662368D0, .012610584316399D0, .008073650037422D0,
     +       .005777879467128D0, .004438735908541D0, .003577984830987D0,
     +       .002984779780070D0, .002554115632481D0, .002228665743650D0,
     +       .473015892583175D0, .063952211044218D0, .023204492283274D0,
     +       .012214032614246D0, .007790230713284D0, .005560353629201D0,
     +       .004263515006252D0, .003431892565682D0, .002859819145966D0,
     +       .002445114362805D0, .002132106741337D0/
         DATA  ((FTABLE (I,J),I=0,10),J= 70, 79)
     +     / .469847035201624D0, .062807093111329D0, .022603413701667D0,
     +       .011831383583717D0, .007517471666243D0, .005351408796266D0,
     +       .004095444762373D0, .003291914069790D0, .002740189660648D0,
     +       .002340834401243D0, .002039781457328D0, .466734690269853D0,
     +       .061691556424734D0, .022021130932389D0, .011462114789818D0,
     +       .007254952658378D0, .005150694967770D0, .003934226055102D0,
     +       .003157788600295D0, .002625660471856D0, .002241068784130D0,
     +       .001951502428764D0, .463677401944206D0, .060604677707905D0,
     +       .021456987593947D0, .011105724378117D0, .007002270583268D0,
     +       .004957876778072D0, .003779572515486D0, .003029266701948D0,
     +       .002516010844712D0, .002145619710113D0, .001867090561785D0,
     +       .460673759734724D0, .059545565884379D0, .020910351900600D0,
     +       .010761730236198D0, .006759038749950D0, .004772632872711D0,
     +       .003631209975488D0, .002906109712684D0, .002411029713905D0,
     +       .002054298131183D0, .001786374755303D0, .457722396925484D0,
     +       .058513360872317D0, .020380615695488D0, .010429669190149D0,
     +       .006524886197392D0, .004594655311647D0, .003488875940241D0,
     +       .002788089290917D0, .002310515255868D0, .001966923362082D0,
     +       .001709191541787D0, .454821989054011D0, .057507232426400D0,
     +       .019867193523092D0, .010109096234594D0, .006299457038153D0,
     +       .004423648998316D0, .003352319083395D0, .002674986963750D0,
     +       .002214274480032D0, .001883322707271D0, .001635384744285D0,
     +       .451971252447460D0, .056526379025170D0, .019369521739388D0,
     +       .009799583794838D0, .006082409829961D0, .004259331133353D0,
     +       .003221298764568D0, .002566593695161D0, .002122122838321D0,
     +       .001803331104645D0, .001564805148958D0, .449168942813318D0,
     +       .055570026801940D0, .018887057658110D0, .009500721019762D0,
     +       .005873416974021D0, .004101430691923D0, .003095584567893D0,
     +       .002462709473278D0, .002033883852050D0, .001726790785257D0,
     +       .001497310192403D0, .446413853882527D0, .054637428517529D0,
     +       .018419278731639D0, .009212113104152D0, .005672164138880D0,
     +       .003949687923604D0, .002974955860749D0, .002363142915889D0,
     +       .001949388755453D0, .001653550948320D0, .001432763663111D0,
     +       .443704816102947D0, .053727862573109D0, .017965681765056D0,
     +       .008933380639227D0, .005478349708760D0, .003803853873854D0,
     +       .002859201371773D0, .002267710893376D0, .001868476155095D0,
     +       .001583467450788D0, .001371035416403D0/
         DATA  ((FTABLE (I,J),I=0,10),J= 80, 89)
     +     / .441040695381211D0, .052840632061560D0, .017525782161993D0,
     +       .008664158990154D0, .005291684255293D0, .003663689926113D0,
     +       .002748118787313D0, .002176238168292D0, .001790991704456D0,
     +       .001516402510878D0, .001312001102242D0, .438420391871084D0,
     +       .051975063855752D0, .017099113200958D0, .008404097699420D0,
     +       .005111890031660D0, .003528967363635D0, .002641514365493D0,
     +       .002088557050853D0, .001716787793001D0, .001452224424879D0,
     +       .001255541905334D0, .435842838806517D0, .051130507732287D0,
     +       .016685225340866D0, .008152859914947D0, .004938700488155D0,
     +       .003399466950199D0, .002539202567126D0, .002004507069618D0,
     +       .001645723249087D0, .001390807296673D0, .001201544296955D0,
     +       .433307001377653D0, .050306335529253D0, .016283685554567D0,
     +       .007910121841925D0, .004771859808268D0, .003274978528862D0,
     +       .002441005702726D0, .001923934656697D0, .001577663056097D0,
     +       .001332030779372D0, .001149899797979D0, .430811875648124D0,
     +       .049501940336625D0, .015894076689214D0, .007675572217332D0,
     +       .004611122464387D0, .003155300637977D0, .002346753594912D0,
     +       .001846692846831D0, .001512478081190D0, .001275779828541D0,
     +       .001100504752596D0, .428356487512047D0, .048716735718006D0,
     +       .015515996852355D0, .007448911806209D0, .004456252792290D0,
     +       .003040240143719D0, .002256283255518D0, .001772640989734D0,
     +       .001450044816119D0, .001221944466474D0, .001053260112235D0,
     +       .425939891689163D0, .047950154962437D0, .015149058822687D0,
     +       .007229852918748D0, .004307024583609D0, .002929611888405D0,
     +       .002169438576773D0, .001701644475099D0, .001390245129568D0,
     +       .001170419557030D0, .001008071229229D0, .423561170756673D0,
     +       .047201650365080D0, .014792889484455D0, .007018118947333D0,
     +       .004163220695500D0, .002823238353910D0, .002086070035923D0,
     +       .001633574469715D0, .001332966030489D0, .001121104590555D0,
     +       .000964847659778D0, .421219434216328D0, .046470692535598D0,
     +       .014447129284514D0, .006813443922671D0, .004024632676776D0,
     +       .002720949339536D0, .002006034412707D0, .001568307666151D0,
     +       .001278099441953D0, .001073903478425D0, .000923502975796D0,
     +       .418913817595444D0, .045756769733152D0, .014111431711130D0,
     +       .006615572088231D0, .003891060409800D0, .002622581653686D0,
     +       .001929194519118D0, .001505726042488D0, .001225541985047D0,
     +       .001028724356787D0, .000883954585232D0/
         DATA  ((FTABLE (I,J),I=0,10),J= 90, 99)
     +     / .416643481580516D0, .045059387226919D0, .013785462793613D0,
     +       .006424257492202D0, .003762311767464D0, .002527978818770D0,
     +       .001855418940915D0, .001445716632627D0, .001175194772352D0,
     +       .000985479399082D0, .000846123560481D0, .414407611182190D0,
     +       .044378066681136D0, .013468900621929D0, .006239263596241D0,
     +       .003638202284597D0, .002436990788739D0, .001784581790360D0,
     +       .001388171306684D0, .001126963210594D0, .000944084636950D0,
     +       .000809934474527D0, .412205414930393D0, .043712345563669D0,
     +       .013161434885476D0, .006060362900298D0, .003518554843202D0,
     +       .002349473678715D0, .001716562469699D0, .001332986561028D0,
     +       .001080756812042D0, .000904459789139D0, .000775315244458D0,
     +       .410036124098465D0, .043061776577196D0, .012862766430220D0,
     +       .005887336582855D0, .003403199370908D0, .002265289506197D0,
     +       .001651245444905D0, .001280063317551D0, .001036489014271D0,
     +       .000866528098072D0, .000742196982024D0, .407898991955183D0,
     +       .042425927112073D0, .012572606833460D0, .005719974155915D0,
     +       .003291972552097D0, .002184305943317D0, .001588520029233D0,
     +       .001229306731737D0, .000994077007911D0, .000830216173701D0,
     +       .000710513850917D0, .405793293043624D0, .041804378720053D0,
     +       .012290677995478D0, .005558073134133D0, .003184717551138D0,
     +       .002106396079697D0, .001528280176163D0, .001180626009158D0,
     +       .000953441572026D0, .000795453844350D0, .000680202930476D0,
     +       .403718322485826D0, .041196726608001D0, .012016711747394D0,
     +       .005401438717495D0, .003081283747234D0, .002031438195425D0,
     +       .001470424281319D0, .001133934230013D0, .000914506916789D0,
     +       .000762174014207D0, .000651204085511D0, .401673395312296D0,
     +       .040602579150832D0, .011750449474564D0, .005249883486968D0,
     +       .002981526480366D0, .001959315543719D0, .001414854992957D0,
     +       .001089148181362D0, .000877200533114D0, .000730312527186D0,
     +       .000623459841991D0, .399657845815393D0, .040021557422905D0,
     +       .011491641754877D0, .005103227112598D0, .002885306807884D0,
     +       .001889916142860D0, .001361479030667D0, .001046188196709D0,
     +       .000841453048950D0, .000699808036860D0, .000596915268307D0,
     +       .397671026925699D0, .039453294747136D0, .011240048011349D0,
     +       .004961296073504D0, .002792491271260D0, .001823132576999D0,
     +       .001310207011913D0, .001004978002608D0, .000807198091926D0,
     +       .000670601882190D0, .000571517861875D0/
         DATA  ((FTABLE (I,J),I=0,10),J=100,109)
     +     / .395712309610514D0, .038897436261143D0, .010995436178434D0,
     +       .004823923389309D0, .002702951672607D0, .001758861805438D0,
     +       .001260953286073D0, .000965444571987D0, .000774372158072D0,
     +       .000642637968814D0, .000547217440837D0, .393781082293616D0,
     +       .038353638499739D0, .010757582381481D0, .004690948362490D0,
     +       .002616564860512D0, .001697004980035D0, .001213635775656D0,
     +       .000927517983889D0, .000742914486344D0, .000615862655603D0,
     +       .000523966040614D0, .391876750295519D0, .037821568993138D0,
     +       .010526270628813D0, .004562216331231D0, .002533212524814D0,
     +       .001637467270373D0, .001168175824371D0, .000891131289344D0,
     +       .000712766938691D0, .000590224646298D0, .000501717815112D0,
     +       .389998735293426D0, .037300905880251D0, .010301292515914D0,
     +       .004437578432304D0, .002452780999930D0, .001580157696362D0,
     +       .001124498051761D0, .000856220383112D0, .000683873885421D0,
     +       .000565674885954D0, .000480428942357D0, .388146474800162D0,
     +       .036791337536481D0, .010082446941219D0, .004316891373590D0,
     +       .002375161076382D0, .001524988967949D0, .001082530214104D0,
     +       .000822723881019D0, .000656182095627D0, .000542166462009D0,
     +       .000460057534366D0, .386319421661361D0, .036292562215446D0,
     +       .009869539833062D0, .004200017215822D0, .002300247820150D0,
     +       .001471877331635D0, .001042203071315D0, .000790583002658D0,
     +       .000629640632446D0, .000519654509753D0, .000440563551060D0,
     +       .384517043570234D0, .035804287704087D0, .009662383887297D0,
     +       .004086823163168D0, .002227940399553D0, .001420742423497D0,
     +       .001003450259581D0, .000759741459211D0, .000604200752949D0,
     +       .000498096122002D0, .000421908718031D0, .382738822599254D0,
     +       .035326230990640D0, .009460798315188D0, .003977181362292D0,
     +       .002158141919312D0, .001371507128448D0, .000966208169487D0,
     +       .000730145346161D0, .000579815812431D0, .000477450262795D0,
     +       .000404056448009D0, .380984254748137D0, .034858117944956D0,
     +       .009264608601135D0, .003870968709543D0, .002090759261499D0,
     +       .001324097445451D0, .000930415829385D0, .000701743040684D0,
     +       .000556441172930D0, .000457677684926D0, .000386971765832D0,
     +       .379252849507499D0, .034399683010711D0, .009073646269851D0,
     +       .003768066665918D0, .002025702933089D0, .001278442358445D0,
     +       .000896014793775D0, .000674485103515D0, .000534034115778D0,
     +       .000438740851144D0, .000370621236787D0/
         DATA  ((FTABLE (I,J),I=0,10),J=110,119)
     +     / .377544129437629D0, .033950668909015D0, .008887748662598D0,
     +       .003668361079502D0, .001962886919823D0, .001234473712722D0,
     +       .000862949036498D0, .000648324185092D0, .000512553757992D0,
     +       .000420603858855D0, .000354972898162D0, .375857629761790D0,
     +       .033510826353001D0, .008706758722120D0, .003571742015056D0,
     +       .001902228546119D0, .001192126096540D0, .000831164848510D0,
     +       .000623214935780D0, .000491960972362D0, .000403232368169D0,
     +       .000339996193850D0, .374192897973536D0, .033079913772951D0,
     +       .008530524785926D0, .003478103590460D0, .001843648340780D0,
     +       .001151336727726D0, .000800610740045D0, .000599113920009D0,
     +       .000472218311041D0, .000386593533144D0, .000325661911898D0,
     +       .372549493457515D0, .032657697051558D0, .008358900387589D0,
     +       .003387343819738D0, .001787069908252D0, .001112045345076D0,
     +       .000771237346984D0, .000575979534149D0, .000453289932507D0,
     +       .000370655936080D0, .000311942124832D0, .370926987123262D0,
     +       .032243949268929D0, .008191744065729D0, .003299364462384D0,
     +       .001732419805194D0, .001074194104323D0, .000742997341235D0,
     +       .000553771927946D0, .000435141531729D0, .000355389524731D0,
     +       .000298810132668D0, .369324961051508D0, .031838450456956D0,
     +       .008028919180379D0, .003214070878729D0, .001679627422139D0,
     +       .001037727478499D0, .000715845344955D0, .000532452929383D0,
     +       .000417740273411D0, .000340765552303D0, .000286240408456D0,
     +       .367743008152542D0, .031440987362687D0, .007870293736438D0,
     +       .003131371891105D0, .001628624870031D0, .001002592162492D0,
     +       .000689737848451D0, .000511985972801D0, .000401054728158D0,
     +       .000326756520113D0, .000274208546273D0, .366180731836188D0,
     +       .031051353220350D0, .007715740213928D0, .003051179650560D0,
     +       .001579346871439D0, .000968736981612D0, .000664633131593D0,
     +       .000492336030139D0, .000385054811453D0, .000313336122787D0,
     +       .000262691211527D0, .364637745692975D0, .030669347531712D0,
     +       .007565135404777D0, .002973409508908D0, .001531730656236D0,
     +       .000936112804013D0, .000640491188592D0, .000473469545163D0,
     +       .000369711725311D0, .000300479195892D0, .000251666093490D0,
     +       .363113673186079D0, .030294775854426D0, .007418360255871D0,
     +       .002897979895878D0, .001485715861575D0, .000904672456787D0,
     +       .000617273655987D0, .000455354370540D0, .000354997902495D0,
     +       .000288161665883D0, .000241111859946D0/
         DATA  ((FTABLE (I,J),I=0,10),J=120,129)
     +     / .361608147353658D0, .029927449598083D0, .007275299718132D0,
     +       .002824812201166D0, .001441244435958D0, .000874370645580D0,
     +       .000594943743726D0, .000437959707647D0, .000340886953170D0,
     +       .000276360502269D0, .000231008113871D0, .360120810521208D0,
     +       .029567185827663D0, .007135842601363D0, .002753830661184D0,
     +       .001398260547256D0, .000845163877588D0, .000573466169172D0,
     +       .000421256048987D0, .000327353613910D0, .000265053671899D0,
     +       .000221335352033D0, .358651314023546D0, .029213807074103D0,
     +       .006999881434658D0, .002684962250312D0, .001356710494483D0,
     +       .000817010387776D0, .000552807093938D0, .000405215123091D0,
     +       .000314373698925D0, .000254220095265D0, .000212074925455D0,
     +       .357199317936115D0, .028867141151714D0, .006867312332122D0,
     +       .002618136576469D0, .001316542623191D0, .000789870068185D0,
     +       .000532934063415D0, .000389809841817D0, .000301924053433D0,
     +       .000243839604741D0, .000203209001630D0, .355764490815237D0,
     +       .028527020982173D0, .006738034863728D0, .002553285780834D0,
     +       .001277707244318D0, .000763704400207D0, .000513815948869D0,
     +       .000375014249920D0, .000289982509073D0, .000233892904673D0,
     +       .000194720528426D0, .354346509447012D0, .028193284424863D0,
     +       .006611951931069D0, .002490344441529D0, .001240156556358D0,
     +       .000738476389680D0, .000495422892020D0, .000360803476802D0,
     +       .000278527841265D0, .000224361533222D0, .000186593199599D0,
     +       .352945058604552D0, .027865774113296D0, .006488969647846D0,
     +       .002429249481127D0, .001203844570703D0, .000714150504706D0,
     +       .000477726251964D0, .000347153690357D0, .000267539728438D0,
     +       .000215227825907D0, .000178811421841D0, .351559830813235D0,
     +       .027544337297400D0, .006368997224877D0, .002369940077805D0,
     +       .001168727040029D0, .000690692616063D0, .000460698554365D0,
     +       .000334042052794D0, .000256998713043D0, .000206474880746D0,
     +       .000171360283300D0, .350190526123712D0, .027228825691448D0,
     +       .006251946859466D0, .002312357580012D0, .001134761389603D0,
     +       .000668069940098D0, .000444313442805D0, .000321446678382D0,
     +       .000246886164262D0, .000198086524944D0, .000164225523496D0,
     +       .348836851892378D0, .026919095327414D0, .006137733628954D0,
     +       .002256445424499D0, .001101906651376D0, .000646250984004D0,
     +       .000428545632194D0, .000309346593007D0, .000237184242354D0,
     +       .000190047283045D0, .000157393504583D0/
         DATA  ((FTABLE (I,J),I=0,10),J=130,139)
     +     / .347498522569045D0, .026615006413544D0, .006026275388281D0,
     +       .002202149057571D0, .001070123400771D0, .000625205493382D0,
     +       .000413370864171D0, .000297721695480D0, .000227875864556D0,
     +       .000182342346498D0, .000150851183883D0, .346175259491556D0,
     +       .026316423197958D0, .005917492671417D0, .002149415859449D0,
     +       .001039373696018D0, .000604904401973D0, .000398765864382D0,
     +       .000286552720508D0, .000218944672467D0, .000174957544551D0,
     +       .000144586087646D0, .344866790687104D0, .026023213837088D0,
     +       .005811308596494D0, .002098195071585D0, .001009621019966D0,
     +       .000585319783496D0, .000384708301584D0, .000275821203261D0,
     +       .000210375000861D0, .000167879316446D0, .000138586285979D0,
     +       .343572850680004D0, .025735250268762D0, .005707648774498D0,
     +       .002048437726844D0, .000980830224244D0, .000566424805468D0,
     +       .000371176748473D0, .000265509445464D0, .000202151847857D0,
     +       .000161094684820D0, .000132840368881D0, .342293180305706D0,
     +       .025452408089779D0, .005606441221393D0, .002000096582410D0,
     +       .000952967475686D0, .000548193684963D0, .000358150644173D0,
     +       .000255600482953D0, .000194260846390D0, .000154591230295D0,
     +       .000127337423354D0, .341027526530814D0, .025174566437779D0,
     +       .005507616273522D0, .001953126055320D0, .000926000204922D0,
     +       .000530601646186D0, .000345610258315D0, .000246078054615D0,
     +       .000186688236921D0, .000148357067175D0, .000122067011522D0,
     +       .339775642278912D0, .024901607877284D0, .005411106506177D0,
     +       .001907482160518D0, .000899897057043D0, .000513624879819D0,
     +       .000333536656630D0, .000236926572672D0, .000179420841341D0,
     +       .000142380820217D0, .000117019149726D0, .338537286261987D0,
     +       .024633418289714D0, .005316846655200D0, .001863122451320D0,
     +       .000874627844258D0, .000497240504045D0, .000321911667999D0,
     +       .000228131094239D0, .000172446038006D0, .000136651602423D0,
     +       .000112184288550D0, .337312222817249D0, .024369886767261D0,
     +       .005224773541502D0, .001820005962208D0, .000850163500464D0,
     +       .000481426527183D0, .000310717852896D0, .000219677294102D0,
     +       .000165751737860D0, .000131158993810D0, .000107553293721D0,
     +       .336100221749171D0, .024110905510466D0, .005134825998396D0,
     +       .001778093153834D0, .000826476037636D0, .000466161811873D0,
     +       .000299938473159D0, .000211551438660D0, .000159326361597D0,
     +       .000125893021112D0, .000103117427873D0/
         DATA  ((FTABLE (I,J),I=0,10),J=140,149)
     +     / .334901058176559D0, .023856369729357D0, .005046944801608D0,
     +       .001737345860178D0, .000803538503978D0, .000451426040732D0,
     +       .000289557463035D0, .000203740360993D0, .000153158817810D0,
     +       .000120844138373D0, .000098868333109D0, .333714512384473D0,
     +       .023606177548026D0, .004961072601899D0, .001697727237744D0,
     +       .000781324943752D0, .000437199683437D0, .000279559401454D0,
     +       .000196231436992D0, .000147238482098D0, .000116003208394D0,
     +       .000094798014339D0, .332540369680845D0, .023360229912506D0,
     +       .004877153860159D0, .001659201716727D0, .000759810358720D0,
     +       .000423463965156D0, .000269929485454D0, .000189012562510D0,
     +       .000141555177069D0, .000111361484994D0, .000090898823353D0,
     +       .331378420257612D0, .023118430501839D0, .004795134784910D0,
     +       .001621734954073D0, .000738970671133D0, .000410200836286D0,
     +       .000260653504743D0, .000182072131493D0, .000136099153223D0,
     +       .000106910596047D0, .000087163443608D0, .330228459056234D0,
     +       .022880685642212D0, .004714963272101D0, .001585293788342D0,
     +       .000718782688196D0, .000397392943430D0, .000251717817316D0,
     +       .000175399015051D0, .000130861070652D0, .000102642527271D0,
     +       .000083584875679D0, .329090285637414D0, .022646904224039D0,
     +       .004636588847122D0, .001549846196329D0, .000699224067963D0,
     +       .000385023601574D0, .000243109326101D0, .000168982541412D0,
     +       .000125831981541D0, .000098549606714D0, .000080156423360D0,
     +       .327963704054900D0, .022416997621898D0, .004559962608938D0,
     +       .001515361251335D0, .000680273286586D0, .000373076767403D0,
     +       .000234815456591D0, .000162812476746D0, .000121003313425D0,
     +       .000094624489933D0, .000076871680379D0, .326848522733229D0,
     +       .022190879617202D0, .004485037176276D0, .001481809083063D0,
     +       .000661909606876D0, .000361537013710D0, .000226824135405D0,
     +       .000156879006796D0, .000116366853169D0, .000090860145818D0,
     +       .000073724517700D0, .325744554349252D0, .021968466323522D0,
     +       .004411766635773D0, .001449160839036D0, .000644113048116D0,
     +       .000350389504859D0, .000219123769752D0, .000151172719300D0,
     +       .000111914731647D0, .000087249843031D0, .000070709071383D0,
     +       .324651615717350D0, .021749676114440D0, .004340106492022D0,
     +       .001417388647511D0, .000626864357073D0, .000339619973252D0,
     +       .000211703227757D0, .000145684587158D0, .000107639409072D0,
     +       .000083787137049D0, .000067819730989D0/
         DATA  ((FTABLE (I,J),I=0,10),J=150,159)
     +     / .323569527678179D0, .021534429553869D0, .004270013619431D0,
     +       .001386465581800D0, .000610144980164D0, .000329214696755D0,
     +       .000204551819610D0, .000140405952319D0, .000103533660976D0,
     +       .000080465857763D0, .000065051128490D0, .322498114990849D0,
     +       .021322649328724D0, .004201446215832D0, .001356365625963D0,
     +       .000593937036730D0, .000319160477050D0, .000197659279499D0,
     +       .000135328510356D0, .000099590564783D0, .000077280097628D0,
     +       .000062398127670D0, .321437206228409D0, .021114260183880D0,
     +       .004134363757776D0, .001327063641805D0, .000578223293368D0,
     +       .000309444618873D0, .000191015748300D0, .000130444295688D0,
     +       .000095803486966D0, .000074224200328D0, .000059855813999D0,
     +       .320386633676531D0, .020909188859314D0, .004068726957446D0,
     +       .001298535337138D0, .000562987139277D0, .000300054910096D0,
     +       .000184611756996D0, .000125745667446D0, .000092166070763D0,
     +       .000071292749931D0, .000057419484945D0, .319346233235276D0,
     +       .020707364029376D0, .004004497721120D0, .001270757235241D0,
     +       .000548212562584D0, .000290979602622D0, .000178438210776D0,
     +       .000121225295922D0, .000088672224412D0, .000068480560527D0,
     +       .000055084640723D0, .318315844323860D0, .020508716244083D0,
     +       .003941639109140D0, .001243706645492D0, .000533884127604D0,
     +       .000282207394056D0, .000172486373809D0, .000116876149609D0,
     +       .000085316109907D0, .000065782666313D0, .000052846975443D0,
     +       .317295309788288D0, .020313177872392D0, .003880115297320D0,
     +       .001217361635104D0, .000519986952997D0, .000273727410128D0,
     +       .000166747854643D0, .000112691482780D0, .000082092132226D0,
     +       .000063194312107D0, .000050702368657D0, .316284475811793D0,
     +       .020120683047359D0, .003819891539734D0, .001191701001937D0,
     +       .000506506690784D0, .000265529187822D0, .000161214592216D0,
     +       .000108664823602D0, .000078994929030D0, .000060710944284D0,
     +       .000048646877271D0, .315283191827960D0, .019931167613133D0,
     +       .003760934132844D0, .001166704248339D0, .000493429506197D0,
     +       .000257602659197D0, .000155878842450D0, .000104789962746D0,
     +       .000076019360806D0, .000058328202104D0, .000046676727818D0,
     +       .314291310436461D0, .019744569073700D0, .003703210380910D0,
     +       .001142351555970D0, .000480742058312D0, .000249938135860D0,
     +       .000150733165398D0, .000101060942488D0, .000073160501427D0,
     +       .000056041909410D0, .000044788309067D0/
         DATA  ((FTABLE (I,J),I=0,10),J=160,169)
     +     / .313308687321307D0, .019560826543338D0, .003646688562632D0,
     +       .001118623761579D0, .000468431481447D0, .000242526294070D0,
     +       .000145770412929D0, .000097472046261D0, .000070413629126D0,
     +       .000053848066702D0, .000042978164965D0, .312335181171541D0,
     +       .019379880698699D0, .003591337898982D0, .001095502333691D0,
     +       .000456485367289D0, .000235358160442D0, .000140983716918D0,
     +       .000094017788662D0, .000067774217854D0, .000051742843543D0,
     +       .000041242987877D0, .311370653604281D0, .019201673732482D0,
     +       .003537128522183D0, .001072969350175D0, .000444891747725D0,
     +       .000228425098237D0, .000136366477934D0, .000090692905868D0,
     +       .000065237929009D0, .000049722571301D0, .000039579612138D0,
     +       .310414969090047D0, .019026149308615D0, .003484031445780D0,
     +       .001051007476642D0, .000433639078336D0, .000221718794196D0,
     +       .000131912354388D0, .000087492346467D0, .000062800603520D0,
     +       .000047783736210D0, .000037985007875D0, .309467994880286D0,
     +       .018853252518922D0, .003432018535780D0, .001029599945666D0,
     +       .000422716222542D0, .000215231245909D0, .000127615252136D0,
     +       .000084411262670D0, .000060458254273D0, .000045922972724D0,
     +       .000036456275109D0, .308529600937036D0, .018682929841196D0,
     +       .003381062482805D0, .001008730536771D0, .000412112436369D0,
     +       .000208954749698D0, .000123469314508D0, .000081445001897D0,
     +       .000058207058858D0, .000044137057169D0, .000034990638115D0,
     +       .307599659864639D0, .018515129098646D0, .003331136775231D0,
     +       .000988383557171D0, .000401817353801D0, .000202881888982D0,
     +       .000119468912753D0, .000078589098715D0, .000056043352628D0,
     +       .000042422901661D0, .000033585440027D0, .306678046843466D0,
     +       .018349799420661D0, .003282215673267D0, .000968543823228D0,
     +       .000391820972705D0, .000197005523109D0, .000115608636872D0,
     +       .000075839267120D0, .000053963622058D0, .000040777548297D0,
     +       .000032238137678D0, .305764639565555D0, .018186891204844D0,
     +       .003234274183950D0, .000949196642593D0, .000382113641308D0,
     +       .000191318776642D0, .000111883286839D0, .000073191393138D0,
     +       .000051964498387D0, .000039198163595D0, .000030946296674D0,
     +       .304859318172125D0, .018026356080282D0, .003187288037010D0,
     +       .000930327797023D0, .000372686045195D0, .000185815029076D0,
     +       .000108287864170D0, .000070641527742D0, .000050042751524D0,
     +       .000037682033168D0, .000029707586676D0/
         DATA  ((FTABLE (I,J),I=0,10),J=170,179)
     +     / .303961965192900D0, .017868146871994D0, .003141233661586D0,
     +       .000911923525819D0, .000363529194807D0, .000180487904956D0,
     +       .000104817563853D0, .000068185880064D0, .000048195284232D0,
     +       .000036226556643D0, .000028519776895D0, .303072465487172D0,
     +       .017712217566527D0, .003096088163744D0, .000893970509893D0,
     +       .000354634413432D0, .000175331264405D0, .000101467766602D0,
     +       .000065820810893D0, .000046419126540D0, .000034829242785D0,
     +       .000027380731775D0, .302190706186563D0, .017558523278657D0,
     +       .003051829304785D0, .000876455856410D0, .000345993325651D0,
     +       .000170339194023D0, .000098234031429D0, .000063542826449D0,
     +       .000044711430410D0, .000033487704844D0, .000026288406881D0,
     +       .301316576639425D0, .017407020219148D0, .003008435480306D0,
     +       .000859367084010D0, .000337597846238D0, .000165505998149D0,
     +       .000095112088525D0, .000061348572409D0, .000043069464623D0,
     +       .000032199656094D0, .000025240844950D0, .300449968356825D0,
     +       .017257665663554D0, .002965885699981D0, .000842692108559D0,
     +       .000329440169478D0, .000160826190478D0, .000092097832429D0,
     +       .000059234828195D0, .000041490609881D0, .000030962905575D0,
     +       .000024236172122D0, .299590774960061D0, .017110417921997D0,
     +       .002924159568050D0, .000826419229436D0, .000321512758911D0,
     +       .000156294486005D0, .000089187315482D0, .000057198501494D0,
     +       .000039972354131D0, .000029775354007D0, .000023272594344D0,
     +       .298738892129676D0, .016965236309919D0, .002883237264469D0,
     +       .000810537116321D0, .000313808337452D0, .000151905793294D0,
     +       .000086376741542D0, .000055236623008D0, .000038512288070D0,
     +       .000028634989892D0, .000022348393912D0, .297894217555898D0,
     +       .016822081119753D0, .002843099526722D0, .000795034796460D0,
     +       .000306319877906D0, .000147655207055D0, .000083662459962D0,
     +       .000053346341426D0, .000037108100854D0, .000027539885776D0,
     +       .000021461926185D0, .297056650890482D0, .016680913593483D0,
     +       .002803727632245D0, .000779901642401D0, .000299040593839D0,
     +       .000143538001015D0, .000081040959814D0, .000051524918601D0,
     +       .000035757575985D0, .000026488194678D0, .000020611616426D0,
     +       .296226093699900D0, .016541695896081D0, .002765103381464D0,
     +       .000765127360183D0, .000291963930795D0, .000139549621068D0,
     +       .000078508864341D0, .000049769724938D0, .000034458587375D0,
     +       .000025478146667D0, .000019795956795D0/
         DATA  ((FTABLE (I,J),I=0,10),J=180,189)
     +     / .295402449419840D0, .016404391089764D0, .002727209081400D0,
     +       .000750701977940D0, .000285083557861D0, .000135685678703D0,
     +       .000076062925647D0, .000048078234963D0, .000033209095575D0,
     +       .000024508045594D0, .000019013503455D0, .294585623310968D0,
     +       .016268963109063D0, .002690027529849D0, .000736615834935D0,
     +       .000278393359537D0, .000131941944692D0, .000073700019596D0,
     +       .000046448023084D0, .000032007144163D0, .000023576265959D0,
     +       .000018262873828D0, .293775522415920D0, .016135376736672D0,
     +       .002653542000084D0, .000722859570985D0, .000271887427934D0,
     +       .000128314343018D0, .000071417140918D0, .000044876759530D0,
     +       .000030850856289D0, .000022681249913D0, .000017542743948D0,
     +       .292972055517484D0, .016003597580040D0, .002617736226086D0,
     +       .000709424116267D0, .000265560055253D0, .000124798945056D0,
     +       .000069211398518D0, .000043362206447D0, .000029738431364D0,
     +       .000021821504396D0, .000016851845944D0, .292175133097928D0,
     +       .015873592048701D0, .002582594388275D0, .000696300681497D0,
     +       .000259405726557D0, .000121391963977D0, .000067080010973D0,
     +       .000041902214175D0, .000028668141890D0, .000020995598386D0,
     +       .000016188965625D0, .291384667299453D0, .015745327332291D0,
     +       .002548101099720D0, .000683480748461D0, .000253419112820D0,
     +       .000118089749369D0, .000065020302216D0, .000040494717662D0,
     +       .000027638330425D0, .000020202160279D0, .000015552940175D0,
     +       .290600571885719D0, .015618771379260D0, .002514241392812D0,
     +       .000670956060891D0, .000247595064235D0, .000114888782077D0,
     +       .000063029697385D0, .000039137733039D0, .000026647406673D0,
     +       .000019439875374D0, .000014942655948D0, .289822762204426D0,
     +       .015493892876221D0, .002481000706394D0, .000658718615662D0,
     +       .000241928603772D0, .000111785669244D0, .000061105718855D0,
     +       .000037829354333D0, .000025693844700D0, .000018707483466D0,
     +       .000014357046350D0, .289051155150906D0, .015370661227944D0,
     +       .002448364873313D0, .000646760654309D0, .000236414920990D0,
     +       .000108777139540D0, .000059245982414D0, .000036567750310D0,
     +       .000024776180271D0, .000018003776545D0, .000013795089830D0,
     +       .288285669132705D0, .015249046537959D0, .002416320108392D0,
     +       .000635074654851D0, .000231049366068D0, .000105860038589D0,
     +       .000057448193609D0, .000035351161463D0, .000023893008289D0,
     +       .000017327596595D0, .000013255807938D0/
         DATA  ((FTABLE (I,J),I=0,10),J=190,199)
     +     / .287526224035115D0, .015129019589749D0, .002384852996808D0,
     +       .000623653323903D0, .000225827444075D0, .000103031324568D0,
     +       .000055710144229D0, .000034177897110D0, .000023042980356D0,
     +       .000016677833482D0, .000012738263488D0, .286772741187638D0,
     +       .015010551828512D0, .002353950482852D0, .000612489589068D0,
     +       .000220744809445D0, .000100288063976D0, .000054029708936D0,
     +       .000033046332623D0, .000022224802423D0, .000016053422938D0,
     +       .000012241558783D0, .286025143331342D0, .014893615343482D0,
     +       .002323599859060D0, .000601576591605D0, .000215797260664D0,
     +       .000097627427577D0, .000052404842024D0, .000031954906761D0,
     +       .000021437232548D0, .000015453344627D0, .000011764833928D0,
     +       .285283354587090D0, .014778182850780D0, .002293788755715D0,
     +       .000590907679355D0, .000210980735153D0, .000095046686494D0,
     +       .000050833574321D0, .000030902119127D0, .000020679078749D0,
     +       .000014876620296D0, .000011307265212D0, .284547300424615D0,
     +       .014664227676782D0, .002264505130685D0, .000580476399916D0,
     +       .000206291304348D0, .000092543208458D0, .000049314010205D0,
     +       .000029886527712D0, .000019949196940D0, .000014322312006D0,
     +       .000010868063560D0, .283816907632413D0, .014551723741984D0,
     +       .002235737259601D0, .000570276494065D0, .000201725168960D0,
     +       .000090114454201D0, .000047844324742D0, .000028906746560D0,
     +       .000019246488957D0, .000013789520438D0, .000010446473056D0,
     +       .283092104288427D0, .014440645545357D0, .002207473726359D0,
     +       .000560301889406D0, .000197278654409D0, .000087757973992D0,
     +       .000046422760943D0, .000027961443512D0, .000018569900676D0,
     +       .000013277383268D0, .000010041769523D0, .282372819731508D0,
     +       .014330968149162D0, .002179703413933D0, .000550546694246D0,
     +       .000192948206432D0, .000085471404308D0, .000045047627126D0,
     +       .000027049338052D0, .000017918420191D0, .000012785073616D0,
     +       .000009653259172D0, .281658984533620D0, .014222667164220D0,
     +       .002152415495485D0, .000541005191685D0, .000188730386856D0,
     +       .000083252464629D0, .000043717294387D0, .000026169199241D0,
     +       .000017291076089D0, .000012311798558D0, .000009280277301D0,
     +       .280950530472770D0, .014115718735620D0, .002125599425775D0,
     +       .000531671833916D0, .000184621869522D0, .000081098954360D0,
     +       .000042430194172D0, .000025319843734D0, .000016686935782D0,
     +       .000011856797707D0, .000008922187060D0/
         DATA  ((FTABLE (I,J),I=0,10),J=200,209)
     +     / .280247390506643D0, .014010099528844D0, .002099244932838D0,
     +       .000522541236721D0, .000180619436364D0, .000079008749876D0,
     +       .000041184815944D0, .000024500133875D0, .000016105103918D0,
     +       .000011419341842D0, .000008578378262D0, .279549498746922D0,
     +       .013905786716312D0, .002073342009944D0, .000513608174162D0,
     +       .000176719973636D0, .000076979801675D0, .000039979704943D0,
     +       .000023708975881D0, .000015544720853D0, .000010998731614D0,
     +       .000008248266249D0, .278856790434270D0, .013802757964309D0,
     +       .002047880907807D0, .000504867573456D0, .000172920468266D0,
     +       .000075010131642D0, .000038813460041D0, .000022945318085D0,
     +       .000015004961190D0, .000010594296288D0, .000007931290804D0,
     +       .278169201913952D0, .013700991420309D0, .002022852127057D0,
     +       .000496314510030D0, .000169218004361D0, .000073097830422D0,
     +       .000037684731673D0, .000022208149265D0, .000014485032379D0,
     +       .000010205392550D0, .000007626915112D0, .277486670612087D0,
     +       .013600465700657D0, .001998246410945D0, .000487944202747D0,
     +       .000165609759831D0, .000071241054892D0, .000036592219859D0,
     +       .000021496497034D0, .000013984173373D0, .000009831403366D0,
     +       .000007334624768D0, .276809135012507D0, .013501159878617D0,
     +       .001974054738293D0, .000479752009298D0, .000162093003134D0,
     +       .000069438025724D0, .000035534672298D0, .000020809426294D0,
     +       .000013501653344D0, .000009471736878D0, .000007053926821D0,
     +       .276136534634197D0, .013403053472768D0, .001950268316656D0,
     +       .000471733421752D0, .000158665090149D0, .000067687025056D0,
     +       .000034510882545D0, .000020146037762D0, .000013036770449D0,
     +       .000009125825361D0, .000006784348868D0, .275468810009318D0,
     +       .013306126435727D0, .001926878575720D0, .000463884062262D0,
     +       .000155323461162D0, .000065986394236D0, .000033519688252D0,
     +       .000019505466546D0, .000012588850648D0, .000008793124214D0,
     +       .000006525438178D0, .274805902661778D0, .013210359143210D0,
     +       .001903877160895D0, .000456199678917D0, .000152065637952D0,
     +       .000064334531662D0, .000032559969484D0, .000018886880783D0,
     +       .000012157246574D0, .000008473110997D0, .000006276760863D0,
     +       .274147755086342D0, .013115732383399D0, .001881255927124D0,
     +       .000448676141738D0, .000148889220998D0, .000062729890703D0,
     +       .000031630647102D0, .000018289480336D0, .000011741336447D0,
     +       .000008165284512D0, .000006037901073D0/
         DATA  ((FTABLE (I,J),I=0,10),J=210,219)
     +     / .273494310728272D0, .013022227346615D0, .001859006932881D0,
     +       .000441309438812D0, .000145791886778D0, .000061170977698D0,
     +       .000030730681206D0, .000017712495539D0, .000011340523035D0,
     +       .000007869163917D0, .000005808460241D0, .272845513963469D0,
     +       .012929825615289D0, .001837122434360D0, .000434095672556D0,
     +       .000142771385167D0, .000059656350030D0, .000029859069643D0,
     +       .000017155185995D0, .000010954232657D0, .000007584287881D0,
     +       .000005588056345D0, .272201310079113D0, .012838509154216D0,
     +       .001815594879855D0, .000427031056110D0, .000139825536936D0,
     +       .000058184614278D0, .000029014846572D0, .000016616839420D0,
     +       .000010581914225D0, .000007310213778D0, .000005376323210D0,
     +       .271561645254783D0, .012748260301089D0, .001794416904304D0,
     +       .000420111909855D0, .000136952231333D0, .000056754424432D0,
     +       .000028197081087D0, .000016096770541D0, .000010223038334D0,
     +       .000007046516906D0, .000005172909841D0, .270926466544045D0,
     +       .012659061757296D0, .001773581324017D0, .000413334658046D0,
     +       .000134149423757D0, .000055364480182D0, .000027404875892D0,
     +       .000015594320032D0, .000009877096382D0, .000006792789746D0,
     +       .000004977479779D0, .270295721856488D0, .012570896578985D0,
     +       .001753081131565D0, .000406695825558D0, .000131415133516D0,
     +       .000054013525271D0, .000026637366031D0, .000015108853492D0,
     +       .000009543599724D0, .000006548641256D0, .000004789710490D0,
     +       .269669359940206D0, .012483748168370D0, .001732909490819D0,
     +       .000400192034754D0, .000128747441660D0, .000052700345904D0,
     +       .000025893717664D0, .000014639760473D0, .000009222078874D0,
     +       .000006313696178D0, .000004609292777D0, .269047330364708D0,
     +       .012397600265291D0, .001713059732165D0, .000393820002439D0,
     +       .000126144488903D0, .000051423769227D0, .000025173126895D0,
     +       .000014186453536D0, .000008912082726D0, .000006087594399D0,
     +       .000004435930216D0, .268429583504242D0, .012312436939002D0,
     +       .001693525347845D0, .000387576536937D0, .000123604473604D0,
     +       .000050182661855D0, .000024474818643D0, .000013748367356D0,
     +       .000008613177814D0, .000005869990314D0, .000004269338622D0,
     +       .267816070521524D0, .012228242580193D0, .001674299987456D0,
     +       .000381458535250D0, .000121125649838D0, .000048975928458D0,
     +       .000023798045559D0, .000013324957852D0, .000008324947602D0,
     +       .000005660552234D0, .000004109245532D0/
         DATA  ((FTABLE (I,J),I=0,10),J=220,229)
     +     / .267206743351862D0, .012145001893231D0, .001655377453586D0,
     +       .000375462980325D0, .000118706325522D0, .000047802510405D0,
     +       .000023142086985D0, .000012915701364D0, .000008046991803D0,
     +       .000005458961812D0, .000003955389711D0, .266601554687661D0,
     +       .012062699888617D0, .001636751697585D0, .000369586938402D0,
     +       .000116344860615D0, .000046661384448D0, .000022506247950D0,
     +       .000012520093852D0, .000007778925726D0, .000005264913489D0,
     +       .000003807520682D0, .266000457963302D0, .011981321875652D0,
     +       .001618416815457D0, .000363827556462D0, .000114039665379D0,
     +       .000045551561468D0, .000021889858213D0, .000012137650133D0,
     +       .000007520379647D0, .000005078113972D0, .000003665398273D0,
     +       .265403407340377D0, .011900853455304D0, .001600367043893D0,
     +       .000358182059748D0, .000111789198706D0, .000044472085258D0,
     +       .000021292271334D0, .000011767903150D0, .000007270998214D0,
     +       .000004898281728D0, .000003528792186D0, .264810357693287D0,
     +       .011821280513269D0, .001582596756417D0, .000352647749376D0,
     +       .000109591966498D0, .000043422031358D0, .000020712863789D0,
     +       .000011410403267D0, .000007030439864D0, .000004725146501D0,
     +       .000003397481583D0, .264221264595168D0, .011742589213223D0,
     +       .001565100459645D0, .000347222000025D0, .000107446520112D0,
     +       .000042400505927D0, .000020151034113D0, .000011064717592D0,
     +       .000006798376277D0, .000004558448847D0, .000003271254686D0,
     +       .263636084304161D0, .011664765990261D0, .001547872789669D0,
     +       .000341902257703D0, .000105351454852D0, .000041406644664D0,
     +       .000019606202082D0, .000010730429327D0, .000006574491843D0,
     +       .000004397939693D0, .000003149908403D0, .263054773749999D0,
     +       .011587797544510D0, .001530908508542D0, .000336686037581D0,
     +       .000103305408522D0, .000040439611765D0, .000019077807920D0,
     +       .000010407137152D0, .000006358483156D0, .000004243379913D0,
     +       .000003033247962D0, .262477290520914D0, .011511670834915D0,
     +       .001514202500873D0, .000331570921909D0, .000101307060023D0,
     +       .000039498598919D0, .000018565311547D0, .000010094454617D0,
     +       .000006150058527D0, .000004094539917D0, .000002921086561D0,
     +       .261903592850847D0, .011436373073198D0, .001497749770524D0,
     +       .000326554557992D0, .000099355128006D0, .000038582824343D0,
     +       .000018068191841D0, .000009792009578D0, .000005948937514D0,
     +       .000003951199263D0, .000002813245039D0/
         DATA  ((FTABLE (I,J),I=0,10),J=230,239)
     +     / .261333639606954D0, .011361891717972D0, .001481545437405D0,
     +       .000321634656236D0, .000097448369568D0, .000037691531848D0,
     +       .000017585945945D0, .000009499443638D0, .000005754850477D0,
     +       .000003813146283D0, .000002709551556D0, .260767390277409D0,
     +       .011288214469018D0, .001465584734370D0, .000316808988257D0,
     +       .000095585578991D0, .000036823989949D0, .000017118088586D0,
     +       .000009216411624D0, .000005567538150D0, .000003680177725D0,
     +       .000002609841284D0, .260204804959486D0, .011215329261713D0,
     +       .001449863004198D0, .000312075385054D0, .000093765586536D0,
     +       .000035979490995D0, .000016664151432D0, .000008942581072D0,
     +       .000005386751222D0, .000003552098407D0, .000002513956120D0,
     +       .259645844347909D0, .011143224261611D0, .001434375696673D0,
     +       .000307431735236D0, .000091987257266D0, .000035157350345D0,
     +       .000016223682465D0, .000008677631746D0, .000005212249950D0,
     +       .000003428720892D0, .000002421744403D0, .259090469723486D0,
     +       .011071887859159D0, .001419118365740D0, .000302875983314D0,
     +       .000090249489916D0, .000034356905559D0, .000015796245384D0,
     +       .000008421255164D0, .000005043803773D0, .000003309865170D0,
     +       .000002333060644D0, .258538642941982D0, .011001308664560D0,
     +       .001404086666760D0, .000298406128041D0, .000088551215807D0,
     +       .000033577515636D0, .000015381419028D0, .000008173154151D0,
     +       .000004881190955D0, .000003195358357D0, .000002247765275D0,
     +       .257990326423266D0, .010931475502769D0, .001389276353830D0,
     +       .000294020220815D0, .000086891397788D0, .000032818560262D0,
     +       .000014978796820D0, .000007933042405D0, .000004724198227D0,
     +       .000003085034404D0, .000002165724397D0, .257445483140691D0,
     +       .010862377408624D0, .001374683277197D0, .000289716364121D0,
     +       .000085269029221D0, .000032079439101D0, .000014587986236D0,
     +       .000007700644083D0, .000004572620461D0, .000002978733820D0,
     +       .000002086809548D0, .256904076610721D0, .010794003622097D0,
     +       .001360303380735D0, .000285492710036D0, .000083683133002D0,
     +       .000031359571101D0, .000014208608290D0, .000007475693402D0,
     +       .000004426260345D0, .000002876303406D0, .000002010897475D0,
     +       .256366070882789D0, .010726343583679D0, .001346132699505D0,
     +       .000281347458773D0, .000082132760609D0, .000030658393834D0,
     +       .000013840297042D0, .000007257934255D0, .000004284928074D0,
     +       .000002777596000D0, .000001937869922D0/
         DATA  ((FTABLE (I,J),I=0,10),J=240,249)
     +     / .255831430529383D0, .010659386929876D0, .001332167357386D0,
     +       .000277278857274D0, .000080616991190D0, .000029975362848D0,
     +       .000013482699124D0, .000007047119844D0, .000004148441055D0,
     +       .000002682470232D0, .000001867613419D0, .255300120636359D0,
     +       .010593123488829D0, .001318403564768D0, .000273285197853D0,
     +       .000079134930680D0, .000029309951060D0, .000013135473281D0,
     +       .000006843012327D0, .000004016623623D0, .000002590790291D0,
     +       .000001800019085D0, .254772106793464D0, .010527543276042D0,
     +       .001304837616318D0, .000269364816874D0, .000077685710945D0,
     +       .000028661648151D0, .000012798289935D0, .000006645382476D0,
     +       .000003889306772D0, .000002502425698D0, .000001734982439D0,
     +       .254247355085072D0, .010462636490226D0, .001291465888811D0,
     +       .000265516093476D0, .000076268488961D0, .000028029960003D0,
     +       .000012470830759D0, .000006454009353D0, .000003766327890D0,
     +       .000002417251092D0, .000001672403217D0, .253725832081125D0,
     +       .010398393509243D0, .001278284839021D0, .000261737448340D0,
     +       .000074882446015D0, .000027414408137D0, .000012152788274D0,
     +       .000006268679998D0, .000003647530507D0, .000002335146025D0,
     +       .000001612185200D0, .253207504828278D0, .010334804886159D0,
     +       .001265291001677D0, .000258027342489D0, .000073526786940D0,
     +       .000026814529187D0, .000011843865455D0, .000006089189124D0,
     +       .000003532764060D0, .000002255994760D0, .000001554236043D0,
     +       .252692340841230D0, .010271861345397D0, .001252480987469D0,
     +       .000254384276133D0, .000072200739369D0, .000026229874384D0,
     +       .000011543775356D0, .000005915338828D0, .000003421883657D0,
     +       .000002179686085D0, .000001498467120D0, .252180308094257D0,
     +       .010209553778987D0, .001239851481121D0, .000250806787544D0,
     +       .000070903553018D0, .000025660009065D0, .000011252240747D0,
     +       .000005746938317D0, .000003314749858D0, .000002106113130D0,
     +       .000001444793369D0, .251671375012915D0, .010147873242912D0,
     +       .001227399239517D0, .000247293451971D0, .000069634498996D0,
     +       .000025104512188D0, .000010968993764D0, .000005583803638D0,
     +       .000003211228462D0, .000002035173192D0, .000001393133142D0,
     +       .251165510465941D0, .010086810953541D0, .001215121089874D0,
     +       .000243842880586D0, .000068392869130D0, .000024562975880D0,
     +       .000010693775579D0, .000005425757420D0, .000003111190303D0,
     +       .000001966767565D0, .000001343408071D0/
         DATA  ((FTABLE (I,J),I=0,10),J=250,259)
     +     / .250662683757313D0, .010026358284166D0, .001203013927973D0,
     +       .000240453719468D0, .000067177975324D0, .000024035004990D0,
     +       .000010426336069D0, .000005272628629D0, .000003014511050D0,
     +       .000001900801387D0, .000001295542928D0, .250162864618494D0,
     +       .009966506761607D0, .001191074716441D0, .000237124648608D0,
     +       .000065989148928D0, .000023520216661D0, .000010166433511D0,
     +       .000005124252330D0, .000002921071028D0, .000001837183479D0,
     +       .000001249465496D0, .249666023200836D0, .009907248062921D0,
     +       .001179300483077D0, .000233854380958D0, .000064825740138D0,
     +       .000023018239921D0, .000009913834282D0, .000004980469461D0,
     +       .000002830755027D0, .000001775826200D0, .000001205106451D0,
     +       .249172130068150D0, .009848574012175D0, .001167688319226D0,
     +       .000230641661503D0, .000063687117407D0, .000022528715279D0,
     +       .000009668312567D0, .000004841126611D0, .000002743452137D0,
     +       .000001716645305D0, .000001162399236D0, .248681156189432D0,
     +       .009790476577318D0, .001156235378205D0, .000227485266357D0,
     +       .000062572666887D0, .000022051294348D0, .000009429650089D0,
     +       .000004706075811D0, .000002659055575D0, .000001659559812D0,
     +       .000001121279955D0, .248193072931750D0, .009732947867111D0,
     +       .001144938873762D0, .000224384001898D0, .000061481791878D0,
     +       .000021585639470D0, .000009197635834D0, .000004575174331D0,
     +       .000002577462531D0, .000001604491868D0, .000001081687258D0,
     +       .247707852053275D0, .009675980128152D0, .001133796078589D0,
     +       .000221336703921D0, .000060413912300D0, .000021131423364D0,
     +       .000008972065798D0, .000004448284485D0, .000002498574012D0,
     +       .000001551366626D0, .000001043562239D0, .247225465696462D0,
     +       .009619565741959D0, .001122804322871D0, .000218342236819D0,
     +       .000059368464188D0, .000020688328778D0, .000008752742741D0,
     +       .000004325273445D0, .000002422294691D0, .000001500112126D0,
     +       .000001006848338D0, .246745886381378D0, .009563697222134D0,
     +       .001111960992871D0, .000215399492792D0, .000058344899194D0,
     +       .000020256048156D0, .000008539475945D0, .000004206013061D0,
     +       .000002348532775D0, .000001450659180D0, .000000971491244D0,
     +       .246269086999165D0, .009508367211590D0, .001101263529567D0,
     +       .000212507391076D0, .000057342684114D0, .000019834283323D0,
     +       .000008332080987D0, .000004090379686D0, .000002277199858D0,
     +       .000001402941259D0, .000000937438801D0/
         DATA  ((FTABLE (I,J),I=0,10),J=260,269)
     +     / .245795040805641D0, .009453568479855D0, .001090709427314D0,
     +       .000209664877199D0, .000056361300422D0, .000019422745169D0,
     +       .000008130379517D0, .000003978254012D0, .000002208210799D0,
     +       .000001356894391D0, .000000904640924D0, .245323721415041D0,
     +       .009399293920429D0, .001080296232546D0, .000206870922256D0,
     +       .000055400243830D0, .000019021153357D0, .000007934199046D0,
     +       .000003869520910D0, .000002141483594D0, .000001312457060D0,
     +       .000000873049513D0, .244855102793877D0, .009345536548216D0,
     +       .001070021542520D0, .000204124522213D0, .000054459023850D0,
     +       .000018629236031D0, .000007743372737D0, .000003764069273D0,
     +       .000002076939255D0, .000001269570103D0, .000000842618372D0,
     +       .244389159254934D0, .009292289497011D0, .001059883004087D0,
     +       .000201424697220D0, .000053537163384D0, .000018246729540D0,
     +       .000007557739216D0, .000003661791873D0, .000002014501694D0,
     +       .000001228176625D0, .000000813303130D0, .243925865451386D0,
     +       .009239546017053D0, .001049878312498D0, .000198770490958D0,
     +       .000052634198315D0, .000017873378168D0, .000007377142373D0,
     +       .000003562585214D0, .000001954097614D0, .000001188221903D0,
     +       .000000785061173D0, .243465196371032D0, .009187299472631D0,
     +       .001040005210248D0, .000196160969997D0, .000051749677120D0,
     +       .000017508933878D0, .000007201431183D0, .000003466349399D0,
     +       .000001895656403D0, .000001149653303D0, .000000757851564D0,
     +       .243007127330658D0, .009135543339754D0, .001030261485942D0,
     +       .000193595223177D0, .000050883160490D0, .000017153156060D0,
     +       .000007030459528D0, .000003372987995D0, .000001839110027D0,
     +       .000001112420197D0, .000000731634983D0, .242551633970500D0,
     +       .009084271203868D0, .001020644973198D0, .000191072361003D0,
     +       .000050034220967D0, .000016805811292D0, .000006864086030D0,
     +       .000003282407909D0, .000001784392937D0, .000001076473885D0,
     +       .000000706373655D0, .242098692248835D0, .009033476757639D0,
     +       .001011153549582D0, .000188591515067D0, .000049202442588D0,
     +       .000016466673104D0, .000006702173882D0, .000003194519267D0,
     +       .000001731441973D0, .000001041767516D0, .000000682031295D0,
     +       .241648278436670D0, .008983153798774D0, .001001785135564D0,
     +       .000186151837478D0, .000048387420546D0, .000016135521757D0,
     +       .000006544590694D0, .000003109235292D0, .000001680196272D0,
     +       .000001008256021D0, .000000658573039D0/
         DATA  ((FTABLE (I,J),I=0,10),J=270,279)
     +     / .241200369112547D0, .008933296227906D0, .000992537693505D0,
     +       .000183752500313D0, .000047588760856D0, .000015812144023D0,
     +       .000006391208339D0, .000003026472197D0, .000001630597180D0,
     +       .000000975896036D0, .000000635965393D0, .240754941157443D0,
     +       .008883898046525D0, .000983409226677D0, .000181392695084D0,
     +       .000046806080035D0, .000015496332978D0, .000006241902809D0,
     +       .000002946149074D0, .000001582588173D0, .000000944645842D0,
     +       .000000614176176D0, .240311971749785D0, .008834953354952D0,
     +       .000974397778301D0, .000179071632221D0, .000046039004797D0,
     +       .000015187887797D0, .000006096554070D0, .000002868187788D0,
     +       .000001536114770D0, .000000914465294D0, .000000593174467D0,
     +       .239871438360551D0, .008786456350371D0, .000965501430611D0,
     +       .000176788540573D0, .000045287171743D0, .000014886613563D0,
     +       .000005955045926D0, .000002792512880D0, .000001491124461D0,
     +       .000000885315766D0, .000000572930554D0, .239433318748481D0,
     +       .008738401324895D0, .000956718303953D0, .000174542666912D0,
     +       .000044550227081D0, .000014592321072D0, .000005817265891D0,
     +       .000002719051468D0, .000001447566630D0, .000000857160085D0,
     +       .000000553415885D0, .238997590955374D0, .008690782663686D0,
     +       .000948046555893D0, .000172333275471D0, .000043827826338D0,
     +       .000014304826656D0, .000005683105062D0, .000002647733156D0,
     +       .000001405392485D0, .000000829962481D0, .000000534603023D0,
     +       .238564233301485D0, .008643594843116D0, .000939484380358D0,
     +       .000170159647475D0, .000043119634089D0, .000014023952005D0,
     +       .000005552457992D0, .000002578489943D0, .000001364554988D0,
     +       .000000803688526D0, .000000516465599D0, .238133224381004D0,
     +       .008596832428970D0, .000931030006800D0, .000168021080703D0,
     +       .000042425323696D0, .000013749523997D0, .000005425222579D0,
     +       .000002511256137D0, .000001325008791D0, .000000778305087D0,
     +       .000000498978271D0, .237704543057638D0, .008550490074686D0,
     +       .000922681699378D0, .000165916889048D0, .000041744577050D0,
     +       .000013481374536D0, .000005301299947D0, .000002445968272D0,
     +       .000001286710170D0, .000000753780271D0, .000000482116683D0,
     +       .237278168460262D0, .008504562519647D0, .000914437756159D0,
     +       .000163846402103D0, .000041077084323D0, .000013219340387D0,
     +       .000005180594342D0, .000002382565030D0, .000001249616966D0,
     +       .000000730083380D0, .000000465857424D0/
         DATA  ((FTABLE (I,J),I=0,10),J=280,289)
     +     / .236854079978671D0, .008459044587498D0, .000906296508349D0,
     +       .000161808964751D0, .000040422543733D0, .000012963263032D0,
     +       .000005063013022D0, .000002320987163D0, .000001213688526D0,
     +       .000000707184865D0, .000000450177990D0, .236432257259404D0,
     +       .008413931184513D0, .000898256319536D0, .000159803936765D0,
     +       .000039780661309D0, .000012712988512D0, .000004948466158D0,
     +       .000002261177419D0, .000001178885648D0, .000000685056278D0,
     +       .000000435056751D0, .236012680201656D0, .008369217297991D0,
     +       .000890315584953D0, .000157830692428D0, .000039151150663D0,
     +       .000012468367293D0, .000004836866735D0, .000002203080470D0,
     +       .000001145170523D0, .000000663670234D0, .000000420472913D0,
     +       .235595328953261D0, .008324897994695D0, .000882472730766D0,
     +       .000155888620157D0, .000038533732781D0, .000012229254121D0,
     +       .000004728130457D0, .000002146642846D0, .000001112506689D0,
     +       .000000643000364D0, .000000406406485D0, .235180183906763D0,
     +       .008280968419318D0, .000874726213374D0, .000153977122139D0,
     +       .000037928135804D0, .000011995507891D0, .000004622175657D0,
     +       .000002091812867D0, .000001080858974D0, .000000623021283D0,
     +       .000000392838248D0, .234767225695554D0, .008237423792994D0,
     +       .000867074518729D0, .000152095613980D0, .000037334094830D0,
     +       .000011766991517D0, .000004518923210D0, .000002038540579D0,
     +       .000001050193455D0, .000000603708545D0, .000000379749724D0,
     +       .234356435190085D0, .008194259411834D0, .000859516161674D0,
     +       .000150243524362D0, .000036751351710D0, .000011543571810D0,
     +       .000004418296443D0, .000001986777697D0, .000001020477407D0,
     +       .000000585038611D0, .000000367123147D0, .233947793494163D0,
     +       .008151470645498D0, .000852049685300D0, .000148420294708D0,
     +       .000036179654863D0, .000011325119351D0, .000004320221062D0,
     +       .000001936477541D0, .000000991679259D0, .000000566988816D0,
     +       .000000354941433D0, .233541281941298D0, .008109052935796D0,
     +       .000844673660313D0, .000146625378861D0, .000035618759085D0,
     +       .000011111508382D0, .000004224625064D0, .000001887594981D0,
     +       .000000963768554D0, .000000549537328D0, .000000343188155D0,
     +       .233136882091135D0, .008067001795329D0, .000837386684424D0,
     +       .000144858242768D0, .000035068425372D0, .000010902616686D0,
     +       .000004131438665D0, .000001840086385D0, .000000936715905D0,
     +       .000000532663123D0, .000000331847516D0/
         DATA  ((FTABLE (I,J),I=0,10),J=290,299)
     +     / .232734575725948D0, .008025312806148D0, .000830187381751D0,
     +       .000143118364176D0, .000034528420744D0, .000010698325484D0,
     +       .000004040594230D0, .000001793909563D0, .000000910492958D0,
     +       .000000516345952D0, .000000320904325D0, .232334344847199D0,
     +       .007983981618449D0, .000823074402234D0, .000141405232331D0,
     +       .000033998518075D0, .000010498519324D0, .000003952026193D0,
     +       .000001749023717D0, .000000885072351D0, .000000500566311D0,
     +       .000000310343971D0, .231936171672164D0, .007943003949299D0,
     +       .000816046421071D0, .000139718347696D0, .000033478495933D0,
     +       .000010303085985D0, .000003865671000D0, .000001705389396D0,
     +       .000000860427682D0, .000000485305409D0, .000000300152402D0,
     +       .231540038630618D0, .007902375581384D0, .000809102138160D0,
     +       .000138057221664D0, .000032968138416D0, .000010111916372D0,
     +       .000003781467032D0, .000001662968442D0, .000000836533467D0,
     +       .000000470545149D0, .000000290316102D0, .231145928361588D0,
     +       .007862092361791D0, .000802240277566D0, .000136421376289D0,
     +       .000032467235003D0, .000009924904425D0, .000003699354549D0,
     +       .000001621723952D0, .000000813365114D0, .000000456268095D0,
     +       .000000280822070D0, .230753823710163D0, .007822150200807D0,
     +       .000795459586985D0, .000134810344019D0, .000031975580399D0,
     +       .000009741947025D0, .000003619275624D0, .000001581620229D0,
     +       .000000790898884D0, .000000442457447D0, .000000271657801D0,
     +       .230363707724359D0, .007782545070757D0, .000788758837241D0,
     +       .000133223667441D0, .000031492974397D0, .000009562943907D0,
     +       .000003541174089D0, .000001542622744D0, .000000769111866D0,
     +       .000000429097019D0, .000000262811265D0, .229975563652051D0,
     +       .007743273004857D0, .000782136821777D0, .000131660899027D0,
     +       .000031019221731D0, .000009387797568D0, .000003464995470D0,
     +       .000001504698092D0, .000000747981939D0, .000000416171218D0,
     +       .000000254270887D0, .229589374937954D0, .007704330096094D0,
     +       .000775592356172D0, .000130121600890D0, .000030554131942D0,
     +       .000009216413192D0, .000003390686939D0, .000001467813955D0,
     +       .000000727487751D0, .000000403665014D0, .000000246025534D0,
     +       .229205125220661D0, .007665712496134D0, .000769124277663D0,
     +       .000128605344550D0, .000030097519250D0, .000009048698561D0,
     +       .000003318197254D0, .000001431939065D0, .000000707608686D0,
     +       .000000391563926D0, .000000238064493D0/
         DATA  ((FTABLE (I,J),I=0,10),J=300,309)
     +     / .228822798329737D0, .007627416414247D0, .000762731444681D0,
     +       .000127111710703D0, .000029649202420D0, .000008884563982D0,
     +       .000003247476716D0, .000001397043166D0, .000000688324839D0,
     +       .000000379853998D0, .000000230377455D0, .228442378282868D0,
     +       .007589438116265D0, .000756412736396D0, .000125640288993D0,
     +       .000029209004640D0, .000008723922208D0, .000003178477110D0,
     +       .000001363096981D0, .000000669616991D0, .000000368521779D0,
     +       .000000222954502D0, .228063849283053D0, .007551773923549D0,
     +       .000750167052278D0, .000124190677799D0, .000028776753402D0,
     +       .000008566688369D0, .000003111151662D0, .000001330072177D0,
     +       .000000651466582D0, .000000357554306D0, .000000215786091D0,
     +       .227687195715857D0, .007514420211990D0, .000743993311663D0,
     +       .000122762484018D0, .000028352280382D0, .000008412779897D0,
     +       .000003045454993D0, .000001297941332D0, .000000633855690D0,
     +       .000000346939081D0, .000000208863036D0, .227312402146707D0,
     +       .007477373411022D0, .000737890453336D0, .000121355322863D0,
     +       .000027935421329D0, .000008262116458D0, .000002981343072D0,
     +       .000001266677905D0, .000000616767004D0, .000000336664060D0,
     +       .000000202176497D0, .226939453318240D0, .007440630002665D0,
     +       .000731857435116D0, .000119968817659D0, .000027526015956D0,
     +       .000008114619890D0, .000002918773174D0, .000001236256207D0,
     +       .000000600183808D0, .000000326717632D0, .000000195717968D0,
     +       .226568334147698D0, .007404186520578D0, .000725893233455D0,
     +       .000118602599649D0, .000027123907828D0, .000007970214132D0,
     +       .000002857703838D0, .000001206651369D0, .000000584089952D0,
     +       .000000317088600D0, .000000189479261D0, .226199029724366D0,
     +       .007368039549141D0, .000719996843052D0, .000117256307803D0,
     +       .000026728944264D0, .000007828825168D0, .000002798094825D0,
     +       .000001177839316D0, .000000568469838D0, .000000307766173D0,
     +       .000000183452494D0, .225831525307063D0, .007332185722552D0,
     +       .000714167276467D0, .000115929588632D0, .000026340976233D0,
     +       .000007690380962D0, .000002739907082D0, .000001149796741D0,
     +       .000000553308398D0, .000000298739945D0, .000000177630081D0,
     +       .225465806321671D0, .007296621723940D0, .000708403563750D0,
     +       .000114622096014D0, .000025959858258D0, .000007554811404D0,
     +       .000002683102703D0, .000001122501075D0, .000000538591074D0,
     +       .000000289999881D0, .000000172004719D0/
         DATA  ((FTABLE (I,J),I=0,10),J=310,319)
     +     / .225101858358709D0, .007261344284502D0, .000702704752076D0,
     +       .000113333491008D0, .000025585448320D0, .000007422048250D0,
     +       .000002627644891D0, .000001095930466D0, .000000524303802D0,
     +       .000000281536306D0, .000000166569377D0, .224739667170953D0,
     +       .007226350182658D0, .000697069905392D0, .000112063441694D0,
     +       .000025217607768D0, .000007292025068D0, .000002573497925D0,
     +       .000001070063754D0, .000000510432991D0, .000000273339889D0,
     +       .000000161317287D0, .224379218671095D0, .007191636243216D0,
     +       .000691498104067D0, .000110811622999D0, .000024856201226D0,
     +       .000007164677188D0, .000002520627126D0, .000001044880445D0,
     +       .000000496965510D0, .000000265401632D0, .000000156241931D0,
     +       .224020498929443D0, .007157199336563D0, .000685988444558D0,
     +       .000109577716542D0, .000024501096511D0, .000007039941648D0,
     +       .000002468998822D0, .000001020360692D0, .000000483888670D0,
     +       .000000257712855D0, .000000151337036D0, .223663494171664D0,
     +       .007123036377868D0, .000680540039077D0, .000108361410471D0,
     +       .000024152164545D0, .000006917757143D0, .000002418580318D0,
     +       .000000996485272D0, .000000471190206D0, .000000250265188D0,
     +       .000000146596560D0, .223308190776562D0, .007089144326303D0,
     +       .000675152015266D0, .000107162399311D0, .000023809279275D0,
     +       .000006798063982D0, .000002369339866D0, .000000973235563D0,
     +       .000000458858267D0, .000000243050556D0, .000000142014684D0,
     +       .222954575273898D0, .007055520184276D0, .000669823515888D0,
     +       .000105980383819D0, .000023472317594D0, .000006680804037D0,
     +       .000002321246634D0, .000000950593528D0, .000000446881397D0,
     +       .000000236061170D0, .000000137585806D0, .222602634342250D0,
     +       .007022160996689D0, .000664553698513D0, .000104815070831D0,
     +       .000023141159262D0, .000006565920698D0, .000002274270677D0,
     +       .000000928541690D0, .000000435248522D0, .000000229289516D0,
     +       .000000133304529D0, .222252354806901D0, .006989063850198D0,
     +       .000659341735220D0, .000103666173129D0, .000022815686833D0,
     +       .000006453358833D0, .000002228382911D0, .000000907063121D0,
     +       .000000423948937D0, .000000222728344D0, .000000129165658D0,
     +       .221903723637773D0, .006956225872501D0, .000654186812305D0,
     +       .000102533409296D0, .000022495785583D0, .000006343064742D0,
     +       .000002183555084D0, .000000886141414D0, .000000412972296D0,
     +       .000000216370660D0, .000000125164187D0/
         DATA  ((FTABLE (I,J),I=0,10),J=320,329)
     +     / .221556727947392D0, .006923644231632D0, .000649088129991D0,
     +       .000101416503587D0, .000022181343435D0, .000006234986117D0,
     +       .000002139759754D0, .000000865760676D0, .000000402308593D0,
     +       .000000210209716D0, .000000121295294D0, .221211354988890D0,
     +       .006891316135269D0, .000644044902151D0, .000100315185794D0,
     +       .000021872250897D0, .000006129072003D0, .000002096970257D0,
     +       .000000845905501D0, .000000391948154D0, .000000204238998D0,
     +       .000000117554336D0, .220867592154034D0, .006859238830062D0,
     +       .000639056356029D0, .000099229191121D0, .000021568400988D0,
     +       .000006025272759D0, .000002055160693D0, .000000826560962D0,
     +       .000000381881627D0, .000000198452224D0, .000000113936839D0,
     +       .220525426971302D0, .006827409600972D0, .000634121731981D0,
     +       .000098158260061D0, .000021269689180D0, .000005923540022D0,
     +       .000002014305892D0, .000000807712591D0, .000000372099967D0,
     +       .000000192843329D0, .000000110438493D0, .220184847103979D0,
     +       .006795825770616D0, .000629240283205D0, .000097102138272D0,
     +       .000020976013330D0, .000005823826666D0, .000001974381399D0,
     +       .000000789346363D0, .000000362594427D0, .000000187406458D0,
     +       .000000107055145D0, .219845840348288D0, .006764484698640D0,
     +       .000624411275490D0, .000096060576461D0, .000020687273623D0,
     +       .000005726086773D0, .000001935363447D0, .000000771448687D0,
     +       .000000353356548D0, .000000182135964D0, .000000103782795D0,
     +       .219508394631561D0, .006733383781088D0, .000619633986968D0,
     +       .000095033330268D0, .000020403372508D0, .000005630275597D0,
     +       .000001897228941D0, .000000754006384D0, .000000344378149D0,
     +       .000000177026393D0, .000000100617588D0, .219172498010428D0,
     +       .006702520449793D0, .000614907707865D0, .000094020160157D0,
     +       .000020124214645D0, .000005536349529D0, .000001859955432D0,
     +       .000000737006679D0, .000000335651315D0, .000000172072482D0,
     +       .000000097555809D0, .218838138669046D0, .006671892171782D0,
     +       .000610231740267D0, .000093020831303D0, .000019849706846D0,
     +       .000005444266068D0, .000001823521103D0, .000000720437187D0,
     +       .000000327168391D0, .000000167269148D0, .000000094593879D0,
     +       .218505304917353D0, .006641496448686D0, .000605605397886D0,
     +       .000092035113490D0, .000019579758019D0, .000005353983787D0,
     +       .000001787904743D0, .000000704285899D0, .000000318921972D0,
     +       .000000162611487D0, .000000091728348D0/
         DATA  ((FTABLE (I,J),I=0,10),J=330,339)
     +     / .218173985189353D0, .006611330816161D0, .000601028005832D0,
     +       .000091062781004D0, .000019314279121D0, .000005265462305D0,
     +       .000001753085737D0, .000000688541168D0, .000000310904894D0,
     +       .000000158094762D0, .000000088955892D0, .217844168041427D0,
     +       .006581392843332D0, .000596498900388D0, .000090103612532D0,
     +       .000019053183099D0, .000005178662258D0, .000001719044039D0,
     +       .000000673191703D0, .000000303110223D0, .000000153714400D0,
     +       .000000086273307D0, .217515842150676D0, .006551680132231D0,
     +       .000592017428798D0, .000089157391065D0, .000018796384845D0,
     +       .000005093545271D0, .000001685760162D0, .000000658226551D0,
     +       .000000295531254D0, .000000149465985D0, .000000083677503D0,
     +       .217188996313286D0, .006522190317260D0, .000587582949047D0,
     +       .000088223903805D0, .000018543801145D0, .000005010073928D0,
     +       .000001653215156D0, .000000643635091D0, .000000288161497D0,
     +       .000000145345253D0, .000000081165504D0, .216863619442928D0,
     +       .006492921064659D0, .000583194829661D0, .000087302942066D0,
     +       .000018295350633D0, .000004928211748D0, .000001621390596D0,
     +       .000000629407019D0, .000000280994670D0, .000000141348086D0,
     +       .000000078734441D0, .216539700569172D0, .006463870071980D0,
     +       .000578852449495D0, .000086394301183D0, .000018050953744D0,
     +       .000004847923160D0, .000001590268564D0, .000000615532343D0,
     +       .000000274024695D0, .000000137470506D0, .000000076381545D0,
     +       .216217228835942D0, .006435035067578D0, .000574555197542D0,
     +       .000085497780429D0, .000017810532669D0, .000004769173473D0,
     +       .000001559831634D0, .000000602001367D0, .000000267245690D0,
     +       .000000133708673D0, .000000074104151D0, .215896193499982D0,
     +       .006406413810112D0, .000570302472734D0, .000084613182921D0,
     +       .000017574011313D0, .000004691928861D0, .000001530062856D0,
     +       .000000588804686D0, .000000260651961D0, .000000130058876D0,
     +       .000000071899686D0, .215576583929357D0, .006378004088046D0,
     +       .000566093683750D0, .000083740315543D0, .000017341315249D0,
     +       .000004616156327D0, .000001500945746D0, .000000575933175D0,
     +       .000000254237995D0, .000000126517530D0, .000000069765671D0,
     +       .215258389601973D0, .006349803719174D0, .000561928248836D0,
     +       .000082878988856D0, .000017112371682D0, .000004541823692D0,
     +       .000001472464267D0, .000000563377979D0, .000000247998458D0,
     +       .000000123081174D0, .000000067699715D0/
         DATA  ((FTABLE (I,J),I=0,10),J=340,349)
     +     / .214941600104125D0, .006321810550140D0, .000557805595619D0,
     +       .000082029017021D0, .000016887109405D0, .000004468899567D0,
     +       .000001444602819D0, .000000551130508D0, .000000241928184D0,
     +       .000000119746463D0, .000000065699512D0, .214626205129060D0,
     +       .006294022455975D0, .000553725160927D0, .000081190217722D0,
     +       .000016665458761D0, .000004397353330D0, .000001417346226D0,
     +       .000000539182423D0, .000000236022171D0, .000000116510164D0,
     +       .000000063762839D0, .214312194475578D0, .006266437339645D0,
     +       .000549686390621D0, .000080362412088D0, .000016447351606D0,
     +       .000004327155109D0, .000001390679722D0, .000000527525634D0,
     +       .000000230275579D0, .000000113369156D0, .000000061887551D0,
     +       .213999558046639D0, .006239053131600D0, .000545688739418D0,
     +       .000079545424616D0, .000016232721269D0, .000004258275762D0,
     +       .000001364588939D0, .000000516152287D0, .000000224683718D0,
     +       .000000110320421D0, .000000060071581D0, .213688285848004D0,
     +       .006211867789333D0, .000541731670728D0, .000078739083102D0,
     +       .000016021502522D0, .000004190686853D0, .000001339059897D0,
     +       .000000505054759D0, .000000219242048D0, .000000107361043D0,
     +       .000000058312932D0, .213378367986889D0, .006184879296957D0,
     +       .000537814656493D0, .000077943218568D0, .000015813631539D0,
     +       .000004124360637D0, .000001314078990D0, .000000494225652D0,
     +       .000000213946171D0, .000000104488204D0, .000000056609682D0,
     +       .213069794670652D0, .006158085664776D0, .000533937177021D0,
     +       .000077157665193D0, .000015609045865D0, .000004059270040D0,
     +       .000001289632978D0, .000000483657783D0, .000000208791830D0,
     +       .000000101699182D0, .000000054959973D0, .212762556205488D0,
     +       .006131484928871D0, .000530098720835D0, .000076382260246D0,
     +       .000015407684382D0, .000003995388640D0, .000001265708974D0,
     +       .000000473344179D0, .000000203774900D0, .000000098991345D0,
     +       .000000053362014D0, .212456642995150D0, .006105075150699D0,
     +       .000526298784519D0, .000075616844016D0, .000015209487278D0,
     +       .000003932690651D0, .000001242294435D0, .000000463278070D0,
     +       .000000198891385D0, .000000096362147D0, .000000051814079D0,
     +       .212152045539696D0, .006078854416684D0, .000522536872569D0,
     +       .000074861259755D0, .000015014396014D0, .000003871150909D0,
     +       .000001219377152D0, .000000453452881D0, .000000194137416D0,
     +       .000000093809131D0, .000000050314501D0/
         DATA  ((FTABLE (I,J),I=0,10),J=350,359)
     +     / .211848754434242D0, .006052820837836D0, .000518812497243D0,
     +       .000074115353606D0, .000014822353293D0, .000003810744847D0,
     +       .000001196945238D0, .000000443862231D0, .000000189509242D0,
     +       .000000091329918D0, .000000048861670D0, .211546760367752D0,
     +       .006026972549356D0, .000515125178425D0, .000073378974552D0,
     +       .000014633303034D0, .000003751448488D0, .000001174987123D0,
     +       .000000434499921D0, .000000185003232D0, .000000088922210D0,
     +       .000000047454035D0, .211246054121830D0, .006001307710266D0,
     +       .000511474443476D0, .000072651974344D0, .000014447190339D0,
     +       .000003693238426D0, .000001153491541D0, .000000425359931D0,
     +       .000000180615867D0, .000000086583786D0, .000000046090099D0,
     +       .210946626569541D0, .005975824503036D0, .000507859827103D0,
     +       .000071934207455D0, .000014263961468D0, .000003636091808D0,
     +       .000001132447522D0, .000000416436414D0, .000000176343735D0,
     +       .000000084312496D0, .000000044768415D0, .210648468674249D0,
     +       .005950521133218D0, .000504280871224D0, .000071225531011D0,
     +       .000014083563807D0, .000003579986326D0, .000001111844386D0,
     +       .000000407723692D0, .000000172183533D0, .000000082106264D0,
     +       .000000043487590D0, .210351571488470D0, .005925395829093D0,
     +       .000500737124834D0, .000070525804746D0, .000013905945846D0,
     +       .000003524900195D0, .000001091671731D0, .000000399216249D0,
     +       .000000168132058D0, .000000079963079D0, .000000042246277D0,
     +       .210055926152746D0, .005900446841315D0, .000497228143877D0,
     +       .000069834890939D0, .000013731057153D0, .000003470812147D0,
     +       .000001071919429D0, .000000390908726D0, .000000164186206D0,
     +       .000000077880999D0, .000000041043175D0, .209761523894533D0,
     +       .005875672442572D0, .000493753491121D0, .000069152654367D0,
     +       .000013558848343D0, .000003417701411D0, .000001052577614D0,
     +       .000000382795918D0, .000000160342971D0, .000000075858145D0,
     +       .000000039877032D0, .209468356027110D0, .005851070927245D0,
     +       .000490312736034D0, .000068478962247D0, .000013389271061D0,
     +       .000003365547705D0, .000001033636677D0, .000000374872767D0,
     +       .000000156599435D0, .000000073892700D0, .000000038746636D0,
     +       .209176413948501D0, .005826640611077D0, .000486905454663D0,
     +       .000067813684192D0, .000013222277953D0, .000003314331218D0,
     +       .000001015087258D0, .000000367134360D0, .000000152952773D0,
     +       .000000071982906D0, .000000037650818D0/
         DATA  ((FTABLE (I,J),I=0,10),J=360,369)
     +     / .208885689140415D0, .005802379830845D0, .000483531229515D0,
     +       .000067156692155D0, .000013057822642D0, .000003264032605D0,
     +       .000000996920241D0, .000000359575921D0, .000000149400245D0,
     +       .000000070127061D0, .000000036588449D0, .208596173167204D0,
     +       .005778286944044D0, .000480189649444D0, .000066507860388D0,
     +       .000012895859709D0, .000003214632969D0, .000000979126744D0,
     +       .000000352192811D0, .000000145939195D0, .000000068323521D0,
     +       .000000035558440D0, .208307857674833D0, .005754360328568D0,
     +       .000476880309532D0, .000065867065387D0, .000012736344670D0,
     +       .000003166113850D0, .000000961698113D0, .000000344980520D0,
     +       .000000142567048D0, .000000066570695D0, .000000034559739D0,
     +       .208020734389870D0, .005730598382405D0, .000473602810982D0,
     +       .000065234185850D0, .000012579233950D0, .000003118457217D0,
     +       .000000944625918D0, .000000337934666D0, .000000139281306D0,
     +       .000000064867043D0, .000000033591329D0, .207734795118485D0,
     +       .005706999523331D0, .000470356761009D0, .000064609102632D0,
     +       .000012424484867D0, .000003071645455D0, .000000927901944D0,
     +       .000000331050989D0, .000000136079549D0, .000000063211074D0,
     +       .000000032652229D0, .207450031745475D0, .005683562188612D0,
     +       .000467141772732D0, .000063991698700D0, .000012272055610D0,
     +       .000003025661353D0, .000000911518185D0, .000000324325350D0,
     +       .000000132959428D0, .000000061601347D0, .000000031741492D0,
     +       .207166436233288D0, .005660284834717D0, .000463957465068D0,
     +       .000063381859090D0, .000012121905218D0, .000002980488096D0,
     +       .000000895466842D0, .000000317753724D0, .000000129918667D0,
     +       .000000060036467D0, .000000030858203D0, .206884000621077D0,
     +       .005637165937022D0, .000460803462634D0, .000062779470866D0,
     +       .000011973993561D0, .000002936109255D0, .000000879740311D0,
     +       .000000311332198D0, .000000126955057D0, .000000058515084D0,
     +       .000000030001477D0, .206602717023759D0, .005614203989533D0,
     +       .000457679395642D0, .000062184423077D0, .000011828281320D0,
     +       .000002892508775D0, .000000864331184D0, .000000305056968D0,
     +       .000000124066455D0, .000000057035891D0, .000000029170461D0,
     +       .206322577631091D0, .005591397504608D0, .000454584899804D0,
     +       .000061596606720D0, .000011684729972D0, .000002849670967D0,
     +       .000000849232238D0, .000000298924337D0, .000000121250786D0,
     +       .000000055597623D0, .000000028364330D0/
         DATA  ((FTABLE (I,J),I=0,10),J=370,379)
     +     / .206043574706758D0, .005568745012684D0, .000451519616232D0,
     +       .000061015914695D0, .000011543301768D0, .000002807580499D0,
     +       .000000834436433D0, .000000292930708D0, .000000118506032D0,
     +       .000000054199056D0, .000000027582287D0, .205765700587478D0,
     +       .005546245062009D0, .000448483191350D0, .000060442241774D0,
     +       .000011403959717D0, .000002766222386D0, .000000819936909D0,
     +       .000000287072584D0, .000000115830238D0, .000000052839006D0,
     +       .000000026823563D0, .205488947682116D0, .005523896218380D0,
     +       .000445475276794D0, .000059875484559D0, .000011266667568D0,
     +       .000002725581982D0, .000000805726973D0, .000000281346566D0,
     +       .000000113221508D0, .000000051516324D0, .000000026087413D0,
     +       .205213308470814D0, .005501697064881D0, .000442495529327D0,
     +       .000059315541445D0, .000011131389795D0, .000002685644971D0,
     +       .000000791800105D0, .000000275749346D0, .000000110678001D0,
     +       .000000050229900D0, .000000025373119D0, .204938775504133D0,
     +       .005479646201635D0, .000439543610747D0, .000058762312587D0,
     +       .000010998091581D0, .000002646397359D0, .000000778149946D0,
     +       .000000270277709D0, .000000108197932D0, .000000048978659D0,
     +       .000000024679988D0, .204665341402207D0, .005457742245549D0,
     +       .000436619187800D0, .000058215699863D0, .000010866738798D0,
     +       .000002607825468D0, .000000764770294D0, .000000264928525D0,
     +       .000000105779566D0, .000000047761560D0, .000000024007347D0,
     +       .204392998853910D0, .005435983830070D0, .000433721932099D0,
     +       .000057675606841D0, .000010737297995D0, .000002569915922D0,
     +       .000000751655103D0, .000000259698752D0, .000000103421224D0,
     +       .000000046577594D0, .000000023354548D0, .204121740616036D0,
     +       .005414369604947D0, .000430851520035D0, .000057141938744D0,
     +       .000010609736384D0, .000002532655648D0, .000000738798478D0,
     +       .000000254585429D0, .000000101121271D0, .000000045425785D0,
     +       .000000022720965D0, .203851559512488D0, .005392898235990D0,
     +       .000428007632696D0, .000056614602419D0, .000010484021822D0,
     +       .000002496031861D0, .000000726194667D0, .000000249585678D0,
     +       .000000098878125D0, .000000044305187D0, .000000022105992D0,
     +       .203582448433482D0, .005371568404840D0, .000425189955791D0,
     +       .000056093506303D0, .000010360122799D0, .000002460032061D0,
     +       .000000713838064D0, .000000244696696D0, .000000096690247D0,
     +       .000000043214885D0, .000000021509044D0/
         DATA  ((FTABLE (I,J),I=0,10),J=380,389)
     +     / .203314400334762D0, .005350378808736D0, .000422398179563D0,
     +       .000055578560395D0, .000010238008420D0, .000002424644026D0,
     +       .000000701723197D0, .000000239915757D0, .000000094556146D0,
     +       .000000042153992D0, .000000020929554D0, .203047408236823D0,
     +       .005329328160296D0, .000419631998723D0, .000055069676222D0,
     +       .000010117648399D0, .000002389855802D0, .000000689844732D0,
     +       .000000235240209D0, .000000092474372D0, .000000041121648D0,
     +       .000000020366975D0, .202781465224150D0, .005308415187291D0,
     +       .000416891112363D0, .000054566766811D0, .000009999013038D0,
     +       .000002355655700D0, .000000678197463D0, .000000230667471D0,
     +       .000000090443520D0, .000000040117021D0, .000000019820780D0,
     +       .202516564444466D0, .005287638632431D0, .000414175223888D0,
     +       .000054069746660D0, .000009882073218D0, .000002322032287D0,
     +       .000000666776313D0, .000000226195031D0, .000000088462222D0,
     +       .000000039139305D0, .000000019290455D0, .202252699107989D0,
     +       .005266997253146D0, .000411484040944D0, .000053578531707D0,
     +       .000009766800385D0, .000002288974382D0, .000000655576329D0,
     +       .000000221820445D0, .000000086529154D0, .000000038187719D0,
     +       .000000018775508D0, .201989862486701D0, .005246489821383D0,
     +       .000408817275342D0, .000053093039305D0, .000009653166537D0,
     +       .000002256471049D0, .000000644592677D0, .000000217541334D0,
     +       .000000084643027D0, .000000037261506D0, .000000018275459D0,
     +       .201728047913629D0, .005226115123393D0, .000406174642993D0,
     +       .000052613188195D0, .000009541144215D0, .000002224511588D0,
     +       .000000633820643D0, .000000213355381D0, .000000082802592D0,
     +       .000000036359933D0, .000000017789846D0, .201467248782134D0,
     +       .005205871959533D0, .000403555863834D0, .000052138898474D0,
     +       .000009430706488D0, .000002193085534D0, .000000623255624D0,
     +       .000000209260333D0, .000000081006635D0, .000000035482289D0,
     +       .000000017318224D0, .201207458545210D0, .005185759144060D0,
     +       .000400960661766D0, .000051670091576D0, .000009321826942D0,
     +       .000002162182650D0, .000000612893131D0, .000000205253996D0,
     +       .000000079253976D0, .000000034627885D0, .000000016860158D0,
     +       .200948670714796D0, .005165775504943D0, .000398388764584D0,
     +       .000051206690242D0, .000009214479671D0, .000002131792919D0,
     +       .000000602728782D0, .000000201334233D0, .000000077543470D0,
     +       .000000033796054D0, .000000016415232D0/
         DATA  ((FTABLE (I,J),I=0,10),J=390,399)
     +     / .200690878861093D0, .005145919883662D0, .000395839903916D0,
     +       .000050748618495D0, .000009108639261D0, .000002101906541D0,
     +       .000000592758299D0, .000000197498965D0, .000000075874005D0,
     +       .000000032986149D0, .000000015983040D0, .200434076611893D0,
     +       .005126191135022D0, .000393313815154D0, .000050295801617D0,
     +       .000009004280787D0, .000002072513927D0, .000000582977511D0,
     +       .000000193746166D0, .000000074244500D0, .000000032197544D0,
     +       .000000015563192D0, .200178257651921D0, .005106588126965D0,
     +       .000390810237398D0, .000049848166125D0, .000008901379796D0,
     +       .000002043605696D0, .000000573382341D0, .000000190073866D0,
     +       .000000072653906D0, .000000031429631D0, .000000015155309D0,
     +       .199923415722179D0, .005087109740388D0, .000388328913391D0,
     +       .000049405639746D0, .000008799912298D0, .000002015172666D0,
     +       .000000563968814D0, .000000186480144D0, .000000071101202D0,
     +       .000000030681820D0, .000000014759024D0, .199669544619304D0,
     +       .005067754868960D0, .000385869589457D0, .000048968151396D0,
     +       .000008699854759D0, .000001987205852D0, .000000554733048D0,
     +       .000000182963131D0, .000000069585398D0, .000000029953541D0,
     +       .000000014373985D0, .199416638194933D0, .005048522418946D0,
     +       .000383432015450D0, .000048535631156D0, .000008601184089D0,
     +       .000001959696461D0, .000000545671253D0, .000000179521006D0,
     +       .000000068105532D0, .000000029244240D0, .000000013999848D0,
     +       .199164690355081D0, .005029411309030D0, .000381015944687D0,
     +       .000048108010251D0, .000008503877633D0, .000001932635889D0,
     +       .000000536779729D0, .000000176151994D0, .000000066660667D0,
     +       .000000028553380D0, .000000013636281D0, .198913695059519D0,
     +       .005010420470146D0, .000378621133897D0, .000047685221027D0,
     +       .000008407913160D0, .000001906015711D0, .000000528054864D0,
     +       .000000172854371D0, .000000065249895D0, .000000027880441D0,
     +       .000000013282964D0, .198663646321172D0, .004991548845308D0,
     +       .000376247343166D0, .000047267196932D0, .000008313268859D0,
     +       .000001879827684D0, .000000519493130D0, .000000169626451D0,
     +       .000000063872333D0, .000000027224918D0, .000000012939586D0,
     +       .198414538205512D0, .004972795389441D0, .000373894335877D0,
     +       .000046853872495D0, .000008219923324D0, .000001854063736D0,
     +       .000000511091084D0, .000000166466598D0, .000000062527121D0,
     +       .000000026586322D0, .000000012605847D0/
         DATA  ((FTABLE (I,J),I=0,10),J=400,409)
     +     / .198166364829974D0, .004954159069221D0, .000371561878663D0,
     +       .000046445183304D0, .000008127855549D0, .000001828715970D0,
     +       .000000502845363D0, .000000163373214D0, .000000061213426D0,
     +       .000000025964177D0, .000000012281455D0, .197919120363365D0,
     +       .004935638862911D0, .000369249741349D0, .000046041065988D0,
     +       .000008037044920D0, .000001803776650D0, .000000494752681D0,
     +       .000000160344744D0, .000000059930437D0, .000000025358025D0,
     +       .000000011966131D0, .197672799025295D0, .004917233760206D0,
     +       .000366957696906D0, .000045641458197D0, .000007947471203D0,
     +       .000001779238204D0, .000000486809832D0, .000000157379672D0,
     +       .000000058677365D0, .000000024767418D0, .000000011659600D0,
     +       .197427395085608D0, .004898942762073D0, .000364685521394D0,
     +       .000045246298584D0, .000007859114542D0, .000001755093221D0,
     +       .000000479013682D0, .000000154476521D0, .000000057453443D0,
     +       .000000024191923D0, .000000011361600D0, .197182902863816D0,
     +       .004880764880601D0, .000362432993918D0, .000044855526784D0,
     +       .000007771955444D0, .000001731334442D0, .000000471361172D0,
     +       .000000151633854D0, .000000056257928D0, .000000023631120D0,
     +       .000000011071875D0, .196939316728558D0, .004862699138848D0,
     +       .000360199896576D0, .000044469083399D0, .000007685974779D0,
     +       .000001707954760D0, .000000463849312D0, .000000148850267D0,
     +       .000000055090093D0, .000000023084601D0, .000000010790178D0,
     +       .196696631097044D0, .004844744570692D0, .000357986014412D0,
     +       .000044086909978D0, .000007601153766D0, .000001684947216D0,
     +       .000000456475183D0, .000000146124395D0, .000000053949236D0,
     +       .000000022551972D0, .000000010516269D0, .196454840434526D0,
     +       .004826900220689D0, .000355791135371D0, .000043708949002D0,
     +       .000007517473969D0, .000001662304994D0, .000000449235933D0,
     +       .000000143454906D0, .000000052834671D0, .000000022032849D0,
     +       .000000010249918D0, .196213939253761D0, .004809165143925D0,
     +       .000353615050249D0, .000043335143863D0, .000007434917289D0,
     +       .000001640021421D0, .000000442128774D0, .000000140840501D0,
     +       .000000051745732D0, .000000021526858D0, .000000009990899D0,
     +       .195973922114494D0, .004791538405874D0, .000351457552650D0,
     +       .000042965438851D0, .000007353465959D0, .000001618089960D0,
     +       .000000435150986D0, .000000138279916D0, .000000050681772D0,
     +       .000000021033640D0, .000000009738995D0/
         DATA  ((FTABLE (I,J),I=0,10),J=410,419)
     +     / .195734783622938D0, .004774019082263D0, .000349318438942D0,
     +       .000042599779136D0, .000007273102532D0, .000001596504211D0,
     +       .000000428299906D0, .000000135771918D0, .000000049642161D0,
     +       .000000020552844D0, .000000009493997D0, .195496518431268D0,
     +       .004756606258932D0, .000347197508214D0, .000042238110752D0,
     +       .000007193809880D0, .000001575257901D0, .000000421572937D0,
     +       .000000133315304D0, .000000048626287D0, .000000020084129D0,
     +       .000000009255700D0, .195259121237115D0, .004739299031697D0,
     +       .000345094562231D0, .000041880380582D0, .000007115571187D0,
     +       .000001554344891D0, .000000414967539D0, .000000130908903D0,
     +       .000000047633553D0, .000000019627165D0, .000000009023907D0,
     +       .195022586783074D0, .004722096506224D0, .000343009405391D0,
     +       .000041526536342D0, .000007038369937D0, .000001533759163D0,
     +       .000000408481229D0, .000000128551573D0, .000000046663380D0,
     +       .000000019181633D0, .000000008798426D0, .194786909856213D0,
     +       .004704997797891D0, .000340941844689D0, .000041176526568D0,
     +       .000006962189914D0, .000001513494823D0, .000000402111583D0,
     +       .000000126242199D0, .000000045715204D0, .000000018747221D0,
     +       .000000008579074D0, .194552085287589D0, .004688002031662D0,
     +       .000338891689671D0, .000040830300596D0, .000006887015194D0,
     +       .000001493546099D0, .000000395856228D0, .000000123979695D0,
     +       .000000044788477D0, .000000018323626D0, .000000008365669D0,
     +       .194318107951776D0, .004671108341963D0, .000336858752398D0,
     +       .000040487808554D0, .000006812830138D0, .000001473907334D0,
     +       .000000389712850D0, .000000121763003D0, .000000043882666D0,
     +       .000000017910557D0, .000000008158040D0, .194084972766393D0,
     +       .004654315872552D0, .000334842847403D0, .000040149001344D0,
     +       .000006739619387D0, .000001454572986D0, .000000383679182D0,
     +       .000000119591089D0, .000000042997251D0, .000000017507729D0,
     +       .000000007956016D0, .193852674691638D0, .004637623776403D0,
     +       .000332843791656D0, .000039813830629D0, .000006667367856D0,
     +       .000001435537625D0, .000000377753011D0, .000000117462946D0,
     +       .000000042131727D0, .000000017114865D0, .000000007759436D0,
     +       .193621208729836D0, .004621031215578D0, .000330861404525D0,
     +       .000039482248818D0, .000006596060730D0, .000001416795929D0,
     +       .000000371932174D0, .000000115377593D0, .000000041285603D0,
     +       .000000016731697D0, .000000007568141D0/
         DATA  ((FTABLE (I,J),I=0,10),J=420,429)
     +     / .193390569924980D0, .004604537361112D0, .000328895507740D0,
     +       .000039154209058D0, .000006525683456D0, .000001398342687D0,
     +       .000000366214555D0, .000000113334070D0, .000000040458400D0,
     +       .000000016357965D0, .000000007381978D0, .193160753362292D0,
     +       .004588141392898D0, .000326945925354D0, .000038829665214D0,
     +       .000006456221739D0, .000001380172788D0, .000000360598085D0,
     +       .000000111331445D0, .000000039649653D0, .000000015993416D0,
     +       .000000007200799D0, .192931754167780D0, .004571842499566D0,
     +       .000325012483711D0, .000038508571859D0, .000006387661538D0,
     +       .000001362281226D0, .000000355080744D0, .000000109368805D0,
     +       .000000038858909D0, .000000015637805D0, .000000007024460D0,
     +       .192703567507804D0, .004555639878373D0, .000323095011406D0,
     +       .000038190884265D0, .000006319989059D0, .000001344663095D0,
     +       .000000349660553D0, .000000107445261D0, .000000038085728D0,
     +       .000000015290892D0, .000000006852821D0, .192476188588649D0,
     +       .004539532735091D0, .000321193339256D0, .000037876558384D0,
     +       .000006253190752D0, .000001327313584D0, .000000344335581D0,
     +       .000000105559947D0, .000000037329679D0, .000000014952447D0,
     +       .000000006685747D0, .192249612656098D0, .004523520283896D0,
     +       .000319307300263D0, .000037565550842D0, .000006187253303D0,
     +       .000001310227981D0, .000000339103936D0, .000000103712015D0,
     +       .000000036590346D0, .000000014622243D0, .000000006523108D0,
     +       .192023834995021D0, .004507601747260D0, .000317436729579D0,
     +       .000037257818924D0, .000006122163632D0, .000001293401666D0,
     +       .000000333963770D0, .000000101900640D0, .000000035867321D0,
     +       .000000014300064D0, .000000006364777D0, .191798850928956D0,
     +       .004491776355846D0, .000315581464478D0, .000036953320563D0,
     +       .000006057908890D0, .000001276830110D0, .000000328913276D0,
     +       .000000100125018D0, .000000035160209D0, .000000013985696D0,
     +       .000000006210630D0, .191574655819708D0, .004476043348398D0,
     +       .000313741344321D0, .000036652014330D0, .000005994476449D0,
     +       .000001260508873D0, .000000323950685D0, .000000098384361D0,
     +       .000000034468625D0, .000000013678933D0, .000000006060548D0,
     +       .191351245066943D0, .004460401971642D0, .000311916210523D0,
     +       .000036353859420D0, .000005931853903D0, .000001244433605D0,
     +       .000000319074270D0, .000000096677903D0, .000000033792192D0,
     +       .000000013379575D0, .000000005914416D0/
         DATA  ((FTABLE (I,J),I=0,10),J=430,439)
     +     / .191128614107793D0, .004444851480183D0, .000310105906527D0,
     +       .000036058815645D0, .000005870029061D0, .000001228600038D0,
     +       .000000314282338D0, .000000095004895D0, .000000033130547D0,
     +       .000000013087428D0, .000000005772121D0, .190906758416467D0,
     +       .004429391136404D0, .000308310277766D0, .000035766843419D0,
     +       .000005808989941D0, .000001213003991D0, .000000309573235D0,
     +       .000000093364607D0, .000000032483333D0, .000000012802301D0,
     +       .000000005633556D0, .190685673503861D0, .004414020210364D0,
     +       .000306529171642D0, .000035477903752D0, .000005748724771D0,
     +       .000001197641361D0, .000000304945343D0, .000000091756327D0,
     +       .000000031850203D0, .000000012524012D0, .000000005498613D0,
     +       .190465354917179D0, .004398737979707D0, .000304762437489D0,
     +       .000035191958236D0, .000005689221982D0, .000001182508129D0,
     +       .000000300397080D0, .000000090179358D0, .000000031230820D0,
     +       .000000012252381D0, .000000005367192D0, .190245798239553D0,
     +       .004383543729563D0, .000303009926547D0, .000034908969037D0,
     +       .000005630470201D0, .000001167600352D0, .000000295926897D0,
     +       .000000088633021D0, .000000030624857D0, .000000011987236D0,
     +       .000000005239192D0, .190026999089676D0, .004368436752448D0,
     +       .000301271491935D0, .000034628898885D0, .000005572458253D0,
     +       .000001152914163D0, .000000291533279D0, .000000087116654D0,
     +       .000000030031992D0, .000000011728406D0, .000000005114518D0,
     +       .189808953121431D0, .004353416348182D0, .000299546988620D0,
     +       .000034351711064D0, .000005515175155D0, .000001138445773D0,
     +       .000000287214743D0, .000000085629609D0, .000000029451913D0,
     +       .000000011475730D0, .000000004993077D0, .189591656023531D0,
     +       .004338481823786D0, .000297836273393D0, .000034077369402D0,
     +       .000005458610108D0, .000001124191462D0, .000000282969840D0,
     +       .000000084171255D0, .000000028884319D0, .000000011229046D0,
     +       .000000004874778D0, .189375103519156D0, .004323632493399D0,
     +       .000296139204838D0, .000033805838263D0, .000005402752501D0,
     +       .000001110147585D0, .000000278797150D0, .000000082740974D0,
     +       .000000028328912D0, .000000010988201D0, .000000004759533D0,
     +       .189159291365608D0, .004308867678186D0, .000294455643310D0,
     +       .000033537082535D0, .000005347591902D0, .000001096310567D0,
     +       .000000274695284D0, .000000081338165D0, .000000027785404D0,
     +       .000000010753044D0, .000000004647257D0/
         DATA  ((FTABLE (I,J),I=0,10),J=440,449)
     +     / .188944215353954D0, .004294186706250D0, .000292785450905D0,
     +       .000033271067627D0, .000005293118055D0, .000001082676899D0,
     +       .000000270662885D0, .000000079962240D0, .000000027253515D0,
     +       .000000010523427D0, .000000004537868D0, .188729871308683D0,
     +       .004279588912547D0, .000291128491435D0, .000033007759452D0,
     +       .000005239320880D0, .000001069243142D0, .000000266698622D0,
     +       .000000078612625D0, .000000026732971D0, .000000010299210D0,
     +       .000000004431285D0, .188516255087370D0, .004265073638800D0,
     +       .000289484630407D0, .000032747124426D0, .000005186190466D0,
     +       .000001056005923D0, .000000262801193D0, .000000077288758D0,
     +       .000000026223506D0, .000000010080253D0, .000000004327430D0,
     +       .188303362580334D0, .004250640233414D0, .000287853734992D0,
     +       .000032489129455D0, .000005133717068D0, .000001042961930D0,
     +       .000000258969326D0, .000000075990094D0, .000000025724860D0,
     +       .000000009866423D0, .000000004226229D0, .188091189710310D0,
     +       .004236288051395D0, .000286235674005D0, .000032233741929D0,
     +       .000005081891106D0, .000001030107918D0, .000000255201773D0,
     +       .000000074716096D0, .000000025236781D0, .000000009657588D0,
     +       .000000004127608D0, .187879732432117D0, .004222016454267D0,
     +       .000284630317878D0, .000031980929711D0, .000005030703163D0,
     +       .000001017440702D0, .000000251497314D0, .000000073466244D0,
     +       .000000024759020D0, .000000009453620D0, .000000004031495D0,
     +       .187668986732339D0, .004207824809993D0, .000283037538640D0,
     +       .000031730661133D0, .000004980143975D0, .000001004957155D0,
     +       .000000247854755D0, .000000072240026D0, .000000024291340D0,
     +       .000000009254397D0, .000000003937823D0, .187458948629001D0,
     +       .004193712492896D0, .000281457209891D0, .000031482904986D0,
     +       .000004930204437D0, .000000992654214D0, .000000244272926D0,
     +       .000000071036946D0, .000000023833504D0, .000000009059798D0,
     +       .000000003846523D0, .187249614171256D0, .004179678883578D0,
     +       .000279889206780D0, .000031237630512D0, .000004880875594D0,
     +       .000000980528870D0, .000000240750683D0, .000000069856515D0,
     +       .000000023385285D0, .000000008869707D0, .000000003757532D0,
     +       .187040979439071D0, .004165723368846D0, .000278333405984D0,
     +       .000030994807395D0, .000004832148639D0, .000000968578171D0,
     +       .000000237286905D0, .000000068698260D0, .000000022946460D0,
     +       .000000008684008D0, .000000003670786D0/
         DATA  ((FTABLE (I,J),I=0,10),J=450,459)
     +     / .186833040542916D0, .004151845341638D0, .000276789685683D0,
     +       .000030754405761D0, .000004784014914D0, .000000956799223D0,
     +       .000000233880495D0, .000000067561716D0, .000000022516812D0,
     +       .000000008502592D0, .000000003586223D0, .186625793623468D0,
     +       .004138044200943D0, .000275257925541D0, .000030516396159D0,
     +       .000004736465902D0, .000000945189184D0, .000000230530379D0,
     +       .000000066446430D0, .000000022096131D0, .000000008325350D0,
     +       .000000003503785D0, .186419234851301D0, .004124319351730D0,
     +       .000273738006684D0, .000030280749565D0, .000004689493227D0,
     +       .000000933745264D0, .000000227235505D0, .000000065351957D0,
     +       .000000021684210D0, .000000008152179D0, .000000003423414D0,
     +       .186213360426592D0, .004110670204878D0, .000272229811678D0,
     +       .000030047437368D0, .000004643088652D0, .000000922464730D0,
     +       .000000223994843D0, .000000064277866D0, .000000021280847D0,
     +       .000000007982975D0, .000000003345053D0, .186008166578831D0,
     +       .004097096177099D0, .000270733224511D0, .000029816431366D0,
     +       .000004597244076D0, .000000911344893D0, .000000220807386D0,
     +       .000000063223733D0, .000000020885848D0, .000000007817641D0,
     +       .000000003268649D0, .185803649566526D0, .004083596690874D0,
     +       .000269248130568D0, .000029587703760D0, .000004551951529D0,
     +       .000000900383121D0, .000000217672144D0, .000000062189145D0,
     +       .000000020499020D0, .000000007656079D0, .000000003194148D0,
     +       .185599805676918D0, .004070171174377D0, .000267774416618D0,
     +       .000029361227144D0, .000004507203173D0, .000000889576825D0,
     +       .000000214588152D0, .000000061173698D0, .000000020120178D0,
     +       .000000007498195D0, .000000003121499D0, .185396631225700D0,
     +       .004056819061411D0, .000266311970788D0, .000029136974501D0,
     +       .000004462991297D0, .000000878923467D0, .000000211554462D0,
     +       .000000060176997D0, .000000019749141D0, .000000007343899D0,
     +       .000000003050653D0, .185194122556732D0, .004043539791339D0,
     +       .000264860682546D0, .000028914919199D0, .000004419308318D0,
     +       .000000868420556D0, .000000208570146D0, .000000059198657D0,
     +       .000000019385730D0, .000000007193100D0, .000000002981561D0,
     +       .184992276041773D0, .004030332809017D0, .000263420442683D0,
     +       .000028695034979D0, .000004376146775D0, .000000858065645D0,
     +       .000000205634297D0, .000000058238300D0, .000000019029774D0,
     +       .000000007045714D0, .000000002914176D0/
         DATA  ((FTABLE (I,J),I=0,10),J=460,469)
     +     / .184791088080200D0, .004017197564730D0, .000261991143295D0,
     +       .000028477295953D0, .000004333499327D0, .000000847856333D0,
     +       .000000202746023D0, .000000057295558D0, .000000018681103D0,
     +       .000000006901655D0, .000000002848453D0, .184590555098741D0,
     +       .004004133514124D0, .000260572677760D0, .000028261676598D0,
     +       .000004291358754D0, .000000837790264D0, .000000199904453D0,
     +       .000000056370071D0, .000000018339554D0, .000000006760842D0,
     +       .000000002784347D0, .184390673551213D0, .003991140118146D0,
     +       .000259164940727D0, .000028048151749D0, .000004249717952D0,
     +       .000000827865124D0, .000000197108734D0, .000000055461487D0,
     +       .000000018004966D0, .000000006623194D0, .000000002721815D0,
     +       .184191439918250D0, .003978216842979D0, .000257767828091D0,
     +       .000027836696590D0, .000004208569931D0, .000000818078640D0,
     +       .000000194358029D0, .000000054569461D0, .000000017677183D0,
     +       .000000006488635D0, .000000002660815D0, .183992850707048D0,
     +       .003965363159979D0, .000256381236981D0, .000027627286657D0,
     +       .000004167907814D0, .000000808428584D0, .000000191651517D0,
     +       .000000053693658D0, .000000017356053D0, .000000006357088D0,
     +       .000000002601307D0, .183794902451110D0, .003952578545617D0,
     +       .000255005065740D0, .000027419897823D0, .000004127724835D0,
     +       .000000798912766D0, .000000188988398D0, .000000052833747D0,
     +       .000000017041426D0, .000000006228480D0, .000000002543252D0,
     +       .183597591709987D0, .003939862481416D0, .000253639213910D0,
     +       .000027214506299D0, .000004088014336D0, .000000789529034D0,
     +       .000000186367883D0, .000000051989409D0, .000000016733157D0,
     +       .000000006102739D0, .000000002486610D0, .183400915069027D0,
     +       .003927214453891D0, .000252283582213D0, .000027011088624D0,
     +       .000004048769766D0, .000000780275280D0, .000000183789203D0,
     +       .000000051160328D0, .000000016431105D0, .000000005979796D0,
     +       .000000002431345D0, .183204869139132D0, .003914633954495D0,
     +       .000250938072536D0, .000026809621664D0, .000004009984677D0,
     +       .000000771149430D0, .000000181251601D0, .000000050346197D0,
     +       .000000016135132D0, .000000005859582D0, .000000002377420D0,
     +       .183009450556506D0, .003902120479554D0, .000249602587915D0,
     +       .000026610082604D0, .000003971652725D0, .000000762149448D0,
     +       .000000178754339D0, .000000049546716D0, .000000015845102D0,
     +       .000000005742032D0, .000000002324801D0/
         DATA  ((FTABLE (I,J),I=0,10),J=470,479)
     +     / .182814655982419D0, .003889673530217D0, .000248277032519D0,
     +       .000026412448944D0, .000003933767667D0, .000000753273335D0,
     +       .000000176296690D0, .000000048761590D0, .000000015560885D0,
     +       .000000005627081D0, .000000002273453D0, .182620482102962D0,
     +       .003877292612394D0, .000246961311634D0, .000026216698492D0,
     +       .000003896323360D0, .000000744519130D0, .000000173877945D0,
     +       .000000047990533D0, .000000015282352D0, .000000005514666D0,
     +       .000000002223343D0, .182426925628813D0, .003864977236705D0,
     +       .000245655331648D0, .000026022809363D0, .000003859313755D0,
     +       .000000735884904D0, .000000171497407D0, .000000047233262D0,
     +       .000000015009377D0, .000000005404727D0, .000000002174438D0,
     +       .182233983295004D0, .003852726918424D0, .000244359000036D0,
     +       .000025830759971D0, .000003822732901D0, .000000727368764D0,
     +       .000000169154394D0, .000000046489504D0, .000000014741839D0,
     +       .000000005297203D0, .000000002126708D0, .182041651860685D0,
     +       .003840541177420D0, .000243072225344D0, .000025640529024D0,
     +       .000003786574941D0, .000000718968850D0, .000000166848236D0,
     +       .000000045758990D0, .000000014479618D0, .000000005192037D0,
     +       .000000002080121D0, .181849928108902D0, .003828419538114D0,
     +       .000241794917176D0, .000025452095524D0, .000003750834109D0,
     +       .000000710683337D0, .000000164578279D0, .000000045041456D0,
     +       .000000014222597D0, .000000005089172D0, .000000002034648D0,
     +       .181658808846366D0, .003816361529417D0, .000240526986179D0,
     +       .000025265438756D0, .000003715504731D0, .000000702510430D0,
     +       .000000162343879D0, .000000044336645D0, .000000013970663D0,
     +       .000000004988554D0, .000000001990261D0, .181468290903230D0,
     +       .003804366684683D0, .000239268344029D0, .000025080538287D0,
     +       .000003680581219D0, .000000694448367D0, .000000160144406D0,
     +       .000000043644307D0, .000000013723705D0, .000000004890128D0,
     +       .000000001946930D0, .181278371132872D0, .003792434541656D0,
     +       .000238018903415D0, .000024897373961D0, .000003646058075D0,
     +       .000000686495418D0, .000000157979244D0, .000000042964194D0,
     +       .000000013481615D0, .000000004793844D0, .000000001904630D0,
     +       .181089046411671D0, .003780564642421D0, .000236778578029D0,
     +       .000024715925897D0, .000003611929887D0, .000000678649881D0,
     +       .000000155847787D0, .000000042296066D0, .000000013244286D0,
     +       .000000004699649D0, .000000001863333D0/
         DATA  ((FTABLE (I,J),I=0,10),J=480,489)
     +     / .180900313638796D0, .003768756533355D0, .000235547282548D0,
     +       .000024536174479D0, .000003578191325D0, .000000670910087D0,
     +       .000000153749442D0, .000000041639687D0, .000000013011616D0,
     +       .000000004607494D0, .000000001823013D0, .180712169735991D0,
     +       .003757009765074D0, .000234324932626D0, .000024358100358D0,
     +       .000003544837143D0, .000000663274395D0, .000000151683626D0,
     +       .000000040994828D0, .000000012783503D0, .000000004517332D0,
     +       .000000001783646D0, .180524611647364D0, .003745323892390D0,
     +       .000233111444876D0, .000024181684444D0, .000003511862177D0,
     +       .000000655741192D0, .000000149649771D0, .000000040361263D0,
     +       .000000012559850D0, .000000004429114D0, .000000001745208D0,
     +       .180337636339178D0, .003733698474259D0, .000231906736859D0,
     +       .000024006907905D0, .000003479261342D0, .000000648308894D0,
     +       .000000147647316D0, .000000039738770D0, .000000012340560D0,
     +       .000000004342796D0, .000000001707673D0, .180151240799647D0,
     +       .003722133073734D0, .000230710727072D0, .000023833752158D0,
     +       .000003447029632D0, .000000640975946D0, .000000145675713D0,
     +       .000000039127135D0, .000000012125540D0, .000000004258332D0,
     +       .000000001671021D0, .179965422038729D0, .003710627257924D0,
     +       .000229523334936D0, .000023662198872D0, .000003415162118D0,
     +       .000000633740818D0, .000000143734425D0, .000000038526147D0,
     +       .000000011914697D0, .000000004175679D0, .000000001635227D0,
     +       .179780177087926D0, .003699180597942D0, .000228344480779D0,
     +       .000023492229957D0, .000003383653945D0, .000000626602007D0,
     +       .000000141822924D0, .000000037935598D0, .000000011707942D0,
     +       .000000004094795D0, .000000001600270D0, .179595503000088D0,
     +       .003687792668860D0, .000227174085831D0, .000023323827568D0,
     +       .000003352500336D0, .000000619558037D0, .000000139940694D0,
     +       .000000037355286D0, .000000011505189D0, .000000004015639D0,
     +       .000000001566130D0, .179411396849211D0, .003676463049670D0,
     +       .000226012072207D0, .000023156974093D0, .000003321696585D0,
     +       .000000612607458D0, .000000138087228D0, .000000036785014D0,
     +       .000000011306350D0, .000000003938169D0, .000000001532785D0,
     +       .179227855730244D0, .003665191323235D0, .000224858362896D0,
     +       .000022991652156D0, .000003291238058D0, .000000605748844D0,
     +       .000000136262029D0, .000000036224587D0, .000000011111344D0,
     +       .000000003862347D0, .000000001500215D0/
         DATA  ((FTABLE (I,J),I=0,10),J=490,499)
     +     / .179044876758899D0, .003653977076245D0, .000223712881752D0,
     +       .000022827844609D0, .000003261120191D0, .000000598980792D0,
     +       .000000134464609D0, .000000035673817D0, .000000010920089D0,
     +       .000000003788135D0, .000000001468401D0, .178862457071456D0,
     +       .003642819899179D0, .000222575553478D0, .000022665534534D0,
     +       .000003231338492D0, .000000592301928D0, .000000132694489D0,
     +       .000000035132517D0, .000000010732505D0, .000000003715495D0,
     +       .000000001437324D0, .178680593824581D0, .003631719386257D0,
     +       .000221446303619D0, .000022504705231D0, .000003201888535D0,
     +       .000000585710896D0, .000000130951202D0, .000000034600506D0,
     +       .000000010548514D0, .000000003644391D0, .000000001406965D0,
     +       .178499284195132D0, .003620675135404D0, .000220325058550D0,
     +       .000022345340224D0, .000003172765961D0, .000000579206368D0,
     +       .000000129234287D0, .000000034077607D0, .000000010368040D0,
     +       .000000003574787D0, .000000001377307D0, .178318525379981D0,
     +       .003609686748203D0, .000219211745463D0, .000022187423250D0,
     +       .000003143966478D0, .000000572787036D0, .000000127543292D0,
     +       .000000033563645D0, .000000010191011D0, .000000003506648D0,
     +       .000000001348331D0, .178138314595832D0, .003598753829859D0,
     +       .000218106292358D0, .000022030938262D0, .000003115485859D0,
     +       .000000566451614D0, .000000125877776D0, .000000033058450D0,
     +       .000000010017352D0, .000000003439942D0, .000000001320022D0,
     +       .177958649079037D0, .003587875989155D0, .000217008628034D0,
     +       .000021875869420D0, .000003087319939D0, .000000560198840D0,
     +       .000000124237304D0, .000000032561855D0, .000000009846993D0,
     +       .000000003374635D0, .000000001292361D0, .177779526085419D0,
     +       .003577052838416D0, .000215918682075D0, .000021722201091D0,
     +       .000003059464618D0, .000000554027473D0, .000000122621450D0,
     +       .000000032073697D0, .000000009679865D0, .000000003310696D0,
     +       .000000001265334D0, .177600942890101D0, .003566283993469D0,
     +       .000214836384841D0, .000021569917848D0, .000003031915855D0,
     +       .000000547936292D0, .000000121029796D0, .000000031593815D0,
     +       .000000009515901D0, .000000003248092D0, .000000001238924D0,
     +       .177422896787323D0, .003555569073602D0, .000213761667459D0,
     +       .000021419004463D0, .000003004669672D0, .000000541924097D0,
     +       .000000119461933D0, .000000031122055D0, .000000009355034D0,
     +       .000000003186793D0, .000000001213116D0/
         DATA  ((FTABLE (I,J),I=0,10),J=500,509)
     +     / .177245385090279D0, .003544907701528D0, .000212694461814D0,
     +       .000021269445904D0, .000002977722149D0, .000000535989709D0,
     +       .000000117917458D0, .000000030658261D0, .000000009197201D0,
     +       .000000003126770D0, .000000001187895D0, .177068405130941D0,
     +       .003534299503348D0, .000211634700536D0, .000021121227335D0,
     +       .000002951069424D0, .000000530131968D0, .000000116395977D0,
     +       .000000030202285D0, .000000009042337D0, .000000003067994D0,
     +       .000000001163247D0, .176891954259890D0, .003523744108512D0,
     +       .000210582316991D0, .000020974334111D0, .000002924707693D0,
     +       .000000524349735D0, .000000114897102D0, .000000029753979D0,
     +       .000000008890381D0, .000000003010436D0, .000000001139158D0,
     +       .176716029846156D0, .003513241149785D0, .000209537245276D0,
     +       .000020828751778D0, .000002898633211D0, .000000518641888D0,
     +       .000000113420453D0, .000000029313200D0, .000000008741273D0,
     +       .000000002954069D0, .000000001115614D0, .176540629277045D0,
     +       .003502790263208D0, .000208499420203D0, .000020684466064D0,
     +       .000002872842283D0, .000000513007325D0, .000000111965659D0,
     +       .000000028879805D0, .000000008594955D0, .000000002898866D0,
     +       .000000001092601D0, .176365749957980D0, .003492391088063D0,
     +       .000207468777294D0, .000020541462884D0, .000002847331275D0,
     +       .000000507444963D0, .000000110532352D0, .000000028453659D0,
     +       .000000008451368D0, .000000002844801D0, .000000001070107D0,
     +       .176191389312341D0, .003482043266839D0, .000206445252771D0,
     +       .000020399728331D0, .000002822096601D0, .000000501953738D0,
     +       .000000109120174D0, .000000028034624D0, .000000008310456D0,
     +       .000000002791847D0, .000000001048119D0, .176017544781305D0,
     +       .003471746445198D0, .000205428783546D0, .000020259248677D0,
     +       .000002797134733D0, .000000496532600D0, .000000107728773D0,
     +       .000000027622569D0, .000000008172165D0, .000000002739981D0,
     +       .000000001026624D0, .175844213823684D0, .003461500271937D0,
     +       .000204419307215D0, .000020120010369D0, .000002772442190D0,
     +       .000000491180520D0, .000000106357803D0, .000000027217365D0,
     +       .000000008036440D0, .000000002689177D0, .000000001005611D0,
     +       .175671393915775D0, .003451304398957D0, .000203416762044D0,
     +       .000019982000027D0, .000002748015547D0, .000000485896485D0,
     +       .000000105006925D0, .000000026818883D0, .000000007903230D0,
     +       .000000002639412D0, .000000000985068D0/
         DATA  ((FTABLE (I,J),I=0,10),J=510,519)
     +     / .175499082551202D0, .003441158481231D0, .000202421086966D0,
     +       .000019845204439D0, .000002723851425D0, .000000480679498D0,
     +       .000000103675805D0, .000000026427001D0, .000000007772482D0,
     +       .000000002590662D0, .000000000964984D0, .175327277240766D0,
     +       .003431062176766D0, .000201432221571D0, .000019709610564D0,
     +       .000002699946496D0, .000000475528580D0, .000000102364117D0,
     +       .000000026041595D0, .000000007644147D0, .000000002542906D0,
     +       .000000000945346D0, .175155975512289D0, .003421015146576D0,
     +       .000200450106096D0, .000019575205525D0, .000002676297481D0,
     +       .000000470442768D0, .000000101071540D0, .000000025662547D0,
     +       .000000007518175D0, .000000002496120D0, .000000000926146D0,
     +       .174985174910472D0, .003411017054644D0, .000199474681417D0,
     +       .000019441976605D0, .000002652901150D0, .000000465421113D0,
     +       .000000099797758D0, .000000025289739D0, .000000007394519D0,
     +       .000000002450284D0, .000000000907371D0, .174814872996740D0,
     +       .003401067567896D0, .000198505889043D0, .000019309911251D0,
     +       .000002629754316D0, .000000460462684D0, .000000098542464D0,
     +       .000000024923057D0, .000000007273131D0, .000000002405376D0,
     +       .000000000889013D0, .174645067349100D0, .003391166356166D0,
     +       .000197543671106D0, .000019178997067D0, .000002606853843D0,
     +       .000000455566564D0, .000000097305352D0, .000000024562389D0,
     +       .000000007153966D0, .000000002361376D0, .000000000871060D0,
     +       .174475755561996D0, .003381313092166D0, .000196587970354D0,
     +       .000019049221813D0, .000002584196637D0, .000000450731851D0,
     +       .000000096086126D0, .000000024207624D0, .000000007036979D0,
     +       .000000002318264D0, .000000000853503D0, .174306935246164D0,
     +       .003371507451455D0, .000195638730144D0, .000018920573400D0,
     +       .000002561779649D0, .000000445957658D0, .000000094884493D0,
     +       .000000023858655D0, .000000006922126D0, .000000002276019D0,
     +       .000000000836333D0, .174138604028491D0, .003361749112410D0,
     +       .000194695894432D0, .000018793039894D0, .000002539599877D0,
     +       .000000441243113D0, .000000093700166D0, .000000023515377D0,
     +       .000000006809363D0, .000000002234624D0, .000000000819541D0,
     +       .173970759551877D0, .003352037756195D0, .000193759407769D0,
     +       .000018666609508D0, .000002517654358D0, .000000436587357D0,
     +       .000000092532862D0, .000000023177685D0, .000000006698649D0,
     +       .000000002194059D0, .000000000803117D0/
         DATA  ((FTABLE (I,J),I=0,10),J=520,529)
     +     / .173803399475094D0, .003342373066730D0, .000192829215290D0,
     +       .000018541270603D0, .000002495940175D0, .000000431989547D0,
     +       .000000091382306D0, .000000022845478D0, .000000006589944D0,
     +       .000000002154306D0, .000000000787052D0, .173636521472649D0,
     +       .003332754730668D0, .000191905262709D0, .000018417011683D0,
     +       .000002474454451D0, .000000427448852D0, .000000090248225D0,
     +       .000000022518658D0, .000000006483205D0, .000000002115348D0,
     +       .000000000771339D0, .173470123234649D0, .003323182437357D0,
     +       .000190987496311D0, .000018293821397D0, .000002453194352D0,
     +       .000000422964455D0, .000000089130352D0, .000000022197126D0,
     +       .000000006378396D0, .000000002077167D0, .000000000755968D0,
     +       .173304202466669D0, .003313655878820D0, .000190075862946D0,
     +       .000018171688534D0, .000002432157081D0, .000000418535551D0,
     +       .000000088028426D0, .000000021880787D0, .000000006275476D0,
     +       .000000002039746D0, .000000000740932D0, .173138756889612D0,
     +       .003304174749722D0, .000189170310019D0, .000018050602021D0,
     +       .000002411339885D0, .000000414161351D0, .000000086942188D0,
     +       .000000021569547D0, .000000006174409D0, .000000002003068D0,
     +       .000000000726223D0, .172973784239586D0, .003294738747345D0,
     +       .000188270785487D0, .000017930550923D0, .000002390740047D0,
     +       .000000409841075D0, .000000085871388D0, .000000021263315D0,
     +       .000000006075157D0, .000000001967118D0, .000000000711834D0,
     +       .172809282267769D0, .003285347571559D0, .000187377237850D0,
     +       .000017811524438D0, .000002370354891D0, .000000405573959D0,
     +       .000000084815775D0, .000000020962002D0, .000000005977685D0,
     +       .000000001931880D0, .000000000697755D0, .172645248740281D0,
     +       .003276000924795D0, .000186489616144D0, .000017693511900D0,
     +       .000002350181778D0, .000000401359249D0, .000000083775107D0,
     +       .000000020665518D0, .000000005881958D0, .000000001897337D0,
     +       .000000000683981D0, .172481681438058D0, .003266698512020D0,
     +       .000185607869936D0, .000017576502770D0, .000002330218105D0,
     +       .000000397196203D0, .000000082749144D0, .000000020373777D0,
     +       .000000005787940D0, .000000001863476D0, .000000000670504D0,
     +       .172318578156723D0, .003257440040708D0, .000184731949317D0,
     +       .000017460486641D0, .000002310461309D0, .000000393084093D0,
     +       .000000081737652D0, .000000020086696D0, .000000005695599D0,
     +       .000000001830282D0, .000000000657318D0/
         DATA  ((FTABLE (I,J),I=0,10),J=530,539)
     +     / .172155936706464D0, .003248225220818D0, .000183861804894D0,
     +       .000017345453233D0, .000002290908859D0, .000000389022201D0,
     +       .000000080740398D0, .000000019804190D0, .000000005604901D0,
     +       .000000001797740D0, .000000000644414D0, .171993754911912D0,
     +       .003239053764764D0, .000182997387784D0, .000017231392391D0,
     +       .000002271558263D0, .000000385009820D0, .000000079757158D0,
     +       .000000019526179D0, .000000005515814D0, .000000001765836D0,
     +       .000000000631788D0, .171832030612011D0, .003229925387391D0,
     +       .000182138649612D0, .000017118294084D0, .000002252407064D0,
     +       .000000381046255D0, .000000078787707D0, .000000019252582D0,
     +       .000000005428307D0, .000000001734557D0, .000000000619432D0,
     +       .171670761659908D0, .003220839805952D0, .000181285542499D0,
     +       .000017006148402D0, .000002233452836D0, .000000377130823D0,
     +       .000000077831827D0, .000000018983322D0, .000000005342348D0,
     +       .000000001703888D0, .000000000607340D0, .171509945922825D0,
     +       .003211796740080D0, .000180438019058D0, .000016894945557D0,
     +       .000002214693190D0, .000000373262850D0, .000000076889304D0,
     +       .000000018718322D0, .000000005257908D0, .000000001673818D0,
     +       .000000000595506D0, .171349581281942D0, .003202795911767D0,
     +       .000179596032390D0, .000016784675879D0, .000002196125771D0,
     +       .000000369441673D0, .000000075959925D0, .000000018457507D0,
     +       .000000005174957D0, .000000001644334D0, .000000000583924D0,
     +       .171189665632284D0, .003193837045336D0, .000178759536077D0,
     +       .000016675329815D0, .000002177748254D0, .000000365666642D0,
     +       .000000075043484D0, .000000018200802D0, .000000005093465D0,
     +       .000000001615422D0, .000000000572588D0, .171030196882601D0,
     +       .003184919867419D0, .000177928484173D0, .000016566897927D0,
     +       .000002159558348D0, .000000361937113D0, .000000074139778D0,
     +       .000000017948136D0, .000000005013405D0, .000000001587071D0,
     +       .000000000561493D0, .170871172955253D0, .003176044106936D0,
     +       .000177102831203D0, .000016459370891D0, .000002141553795D0,
     +       .000000358252455D0, .000000073248605D0, .000000017699438D0,
     +       .000000004934749D0, .000000001559269D0, .000000000550632D0,
     +       .170712591786099D0, .003167209495067D0, .000176282532156D0,
     +       .000016352739495D0, .000002123732365D0, .000000354612047D0,
     +       .000000072369769D0, .000000017454639D0, .000000004857469D0,
     +       .000000001532004D0, .000000000540002D0/
         DATA  ((FTABLE (I,J),I=0,10),J=540,549)
     +     / .170554451324381D0, .003158415765232D0, .000175467542478D0,
     +       .000016246994639D0, .000002106091863D0, .000000351015276D0,
     +       .000000071503077D0, .000000017213669D0, .000000004781540D0,
     +       .000000001505265D0, .000000000529595D0, .170396749532616D0,
     +       .003149662653065D0, .000174657818067D0, .000016142127330D0,
     +       .000002088630121D0, .000000347461540D0, .000000070648339D0,
     +       .000000016976462D0, .000000004706934D0, .000000001479041D0,
     +       .000000000519408D0, .170239484386484D0, .003140949896398D0,
     +       .000173853315267D0, .000016038128683D0, .000002071345002D0,
     +       .000000343950246D0, .000000069805369D0, .000000016742954D0,
     +       .000000004633627D0, .000000001453320D0, .000000000509435D0,
     +       .170082653874719D0, .003132277235232D0, .000173053990867D0,
     +       .000015934989921D0, .000002054234398D0, .000000340480810D0,
     +       .000000068973983D0, .000000016513079D0, .000000004561594D0,
     +       .000000001428094D0, .000000000499671D0, .169926255999001D0,
     +       .003123644411718D0, .000172259802089D0, .000015832702370D0,
     +       .000002037296233D0, .000000337052657D0, .000000068154002D0,
     +       .000000016286774D0, .000000004490810D0, .000000001403350D0,
     +       .000000000490112D0, .169770288773849D0, .003115051170136D0,
     +       .000171470706586D0, .000015731257458D0, .000002020528454D0,
     +       .000000333665222D0, .000000067345247D0, .000000016063977D0,
     +       .000000004421251D0, .000000001379079D0, .000000000480753D0,
     +       .169614750226516D0, .003106497256870D0, .000170686662440D0,
     +       .000015630646718D0, .000002003929041D0, .000000330317948D0,
     +       .000000066547546D0, .000000015844628D0, .000000004352894D0,
     +       .000000001355271D0, .000000000471589D0, .169459638396883D0,
     +       .003097982420394D0, .000169907628151D0, .000015530861781D0,
     +       .000001987495999D0, .000000327010286D0, .000000065760728D0,
     +       .000000015628668D0, .000000004285717D0, .000000001331917D0,
     +       .000000000462616D0, .169304951337356D0, .003089506411243D0,
     +       .000169133562636D0, .000015431894378D0, .000001971227361D0,
     +       .000000323741697D0, .000000064984624D0, .000000015416037D0,
     +       .000000004219695D0, .000000001309007D0, .000000000453830D0,
     +       .169150687112762D0, .003081068981996D0, .000168364425224D0,
     +       .000015333736337D0, .000001955121187D0, .000000320511648D0,
     +       .000000064219070D0, .000000015206680D0, .000000004154809D0,
     +       .000000001286531D0, .000000000445226D0/
         DATA  ((FTABLE (I,J),I=0,10),J=550,559)
     +     / .168996843800249D0, .003072669887257D0, .000167600175648D0,
     +       .000015236379584D0, .000001939175563D0, .000000317319617D0,
     +       .000000063463903D0, .000000015000538D0, .000000004091035D0,
     +       .000000001264481D0, .000000000436800D0, .168843419489185D0,
     +       .003064308883632D0, .000166840774044D0, .000015139816137D0,
     +       .000001923388600D0, .000000314165087D0, .000000062718963D0,
     +       .000000014797558D0, .000000004028354D0, .000000001242848D0,
     +       .000000000428549D0, .168690412281059D0, .003055985729711D0,
     +       .000166086180944D0, .000015044038110D0, .000001907758437D0,
     +       .000000311047553D0, .000000061984095D0, .000000014597685D0,
     +       .000000003966744D0, .000000001221623D0, .000000000420468D0,
     +       .168537820289378D0, .003047700186047D0, .000165336357272D0,
     +       .000014949037710D0, .000001892283237D0, .000000307966513D0,
     +       .000000061259144D0, .000000014400866D0, .000000003906185D0,
     +       .000000001200799D0, .000000000412553D0, .168385641639576D0,
     +       .003039452015138D0, .000164591264341D0, .000014854807234D0,
     +       .000001876961186D0, .000000304921475D0, .000000060543958D0,
     +       .000000014207049D0, .000000003846657D0, .000000001180365D0,
     +       .000000000404802D0, .168233874468912D0, .003031240981406D0,
     +       .000163850863844D0, .000014761339069D0, .000001861790497D0,
     +       .000000301911957D0, .000000059838390D0, .000000014016183D0,
     +       .000000003788142D0, .000000001160316D0, .000000000397209D0,
     +       .168082516926378D0, .003023066851179D0, .000163115117854D0,
     +       .000014668625691D0, .000001846769406D0, .000000298937479D0,
     +       .000000059142292D0, .000000013828218D0, .000000003730619D0,
     +       .000000001140642D0, .000000000389772D0, .167931567172600D0,
     +       .003014929392671D0, .000162383988819D0, .000014576659664D0,
     +       .000001831896173D0, .000000295997572D0, .000000058455520D0,
     +       .000000013643105D0, .000000003674071D0, .000000001121336D0,
     +       .000000000382488D0, .167781023379748D0, .003006828375967D0,
     +       .000161657439554D0, .000014485433638D0, .000001817169081D0,
     +       .000000293091774D0, .000000057777934D0, .000000013460795D0,
     +       .000000003618480D0, .000000001102391D0, .000000000375352D0,
     +       .167630883731442D0, .002998763573000D0, .000160935433243D0,
     +       .000014394940349D0, .000001802586435D0, .000000290219628D0,
     +       .000000057109395D0, .000000013281242D0, .000000003563826D0,
     +       .000000001083798D0, .000000000368362D0/
         DATA  ((FTABLE (I,J),I=0,10),J=560,569)
     +     / .167481146422658D0, .002990734757535D0, .000160217933427D0,
     +       .000014305172615D0, .000001788146565D0, .000000287380686D0,
     +       .000000056449765D0, .000000013104397D0, .000000003510094D0,
     +       .000000001065552D0, .000000000361514D0, .167331809659638D0,
     +       .002982741705151D0, .000159504904007D0, .000014216123340D0,
     +       .000001773847820D0, .000000284574505D0, .000000055798911D0,
     +       .000000012930217D0, .000000003457266D0, .000000001047645D0,
     +       .000000000354805D0, .167182871659802D0, .002974784193224D0,
     +       .000158796309236D0, .000014127785508D0, .000001759688575D0,
     +       .000000281800650D0, .000000055156700D0, .000000012758656D0,
     +       .000000003405324D0, .000000001030069D0, .000000000348233D0,
     +       .167034330651656D0, .002966862000907D0, .000158092113714D0,
     +       .000014040152184D0, .000001745667224D0, .000000279058693D0,
     +       .000000054523002D0, .000000012589670D0, .000000003354253D0,
     +       .000000001012819D0, .000000000341793D0, .166886184874704D0,
     +       .002958974909116D0, .000157392282390D0, .000013953216514D0,
     +       .000001731782181D0, .000000276348210D0, .000000053897691D0,
     +       .000000012423217D0, .000000003304037D0, .000000000995888D0,
     +       .000000000335484D0, .166738432579359D0, .002951122700510D0,
     +       .000156696780549D0, .000013866971720D0, .000001718031885D0,
     +       .000000273668786D0, .000000053280639D0, .000000012259253D0,
     +       .000000003254659D0, .000000000979268D0, .000000000329302D0,
     +       .166591072026861D0, .002943305159476D0, .000156005573815D0,
     +       .000013781411105D0, .000001704414792D0, .000000271020011D0,
     +       .000000052671725D0, .000000012097737D0, .000000003206105D0,
     +       .000000000962955D0, .000000000323245D0, .166444101489185D0,
     +       .002935522072111D0, .000155318628145D0, .000013696528047D0,
     +       .000001690929380D0, .000000268401480D0, .000000052070825D0,
     +       .000000011938629D0, .000000003158359D0, .000000000946942D0,
     +       .000000000317309D0, .166297519248960D0, .002927773226206D0,
     +       .000154635909827D0, .000013612315998D0, .000001677574146D0,
     +       .000000265812797D0, .000000051477822D0, .000000011781888D0,
     +       .000000003111406D0, .000000000931222D0, .000000000311492D0,
     +       .166151323599383D0, .002920058411229D0, .000153957385470D0,
     +       .000013528768487D0, .000001664347609D0, .000000263253568D0,
     +       .000000050892598D0, .000000011627475D0, .000000003065232D0,
     +       .000000000915791D0, .000000000305792D0/
         DATA  ((FTABLE (I,J),I=0,10),J=570,579)
     +     / .166005512844137D0, .002912377418311D0, .000153283022009D0,
     +       .000013445879116D0, .000001651248305D0, .000000260723409D0,
     +       .000000050315037D0, .000000011475352D0, .000000003019822D0,
     +       .000000000900641D0, .000000000300206D0, .165860085297306D0,
     +       .002904730040226D0, .000152612786695D0, .000013363641560D0,
     +       .000001638274790D0, .000000258221939D0, .000000049745025D0,
     +       .000000011325480D0, .000000002975163D0, .000000000885768D0,
     +       .000000000294732D0, .165715039283295D0, .002897116071380D0,
     +       .000151946647094D0, .000013282049564D0, .000001625425639D0,
     +       .000000255748783D0, .000000049182452D0, .000000011177823D0,
     +       .000000002931241D0, .000000000871166D0, .000000000289367D0,
     +       .165570373136748D0, .002889535307790D0, .000151284571082D0,
     +       .000013201096947D0, .000001612699446D0, .000000253303572D0,
     +       .000000048627206D0, .000000011032344D0, .000000002888042D0,
     +       .000000000856830D0, .000000000284108D0, .165426085202469D0,
     +       .002881987547075D0, .000150626526845D0, .000013120777594D0,
     +       .000001600094823D0, .000000250885942D0, .000000048079181D0,
     +       .000000010889007D0, .000000002845553D0, .000000000842754D0,
     +       .000000000278954D0, .165282173835340D0, .002874472588435D0,
     +       .000149972482869D0, .000013041085461D0, .000001587610398D0,
     +       .000000248495535D0, .000000047538271D0, .000000010747777D0,
     +       .000000002803762D0, .000000000828933D0, .000000000273903D0,
     +       .165138637400245D0, .002866990232638D0, .000149322407944D0,
     +       .000012962014573D0, .000001575244821D0, .000000246131998D0,
     +       .000000047004369D0, .000000010608620D0, .000000002762656D0,
     +       .000000000815362D0, .000000000268951D0, .164995474271991D0,
     +       .002859540282005D0, .000148676271156D0, .000012883559021D0,
     +       .000001562996756D0, .000000243794983D0, .000000046477375D0,
     +       .000000010471500D0, .000000002722222D0, .000000000802036D0,
     +       .000000000264097D0, .164852682835228D0, .002852122540397D0,
     +       .000148034041884D0, .000012805712961D0, .000001550864887D0,
     +       .000000241484147D0, .000000045957186D0, .000000010336386D0,
     +       .000000002682448D0, .000000000788951D0, .000000000259339D0,
     +       .164710261484378D0, .002844736813197D0, .000147395689798D0,
     +       .000012728470617D0, .000001538847911D0, .000000239199153D0,
     +       .000000045443703D0, .000000010203245D0, .000000002643323D0,
     +       .000000000776101D0, .000000000254674D0/
         DATA  ((FTABLE (I,J),I=0,10),J=580,589)
     +     / .164568208623555D0, .002837382907298D0, .000146761184856D0,
     +       .000012651826276D0, .000001526944546D0, .000000236939667D0,
     +       .000000044936829D0, .000000010072043D0, .000000002604834D0,
     +       .000000000763482D0, .000000000250102D0, .164426522666488D0,
     +       .002830060631089D0, .000146130497298D0, .000012575774290D0,
     +       .000001515153525D0, .000000234705361D0, .000000044436467D0,
     +       .000000009942751D0, .000000002566971D0, .000000000751089D0,
     +       .000000000245619D0, .164285202036454D0, .002822769794437D0,
     +       .000145503597647D0, .000012500309072D0, .000001503473596D0,
     +       .000000232495913D0, .000000043942523D0, .000000009815336D0,
     +       .000000002529722D0, .000000000738918D0, .000000000241224D0,
     +       .164144245166197D0, .002815510208679D0, .000144880456704D0,
     +       .000012425425099D0, .000001491903524D0, .000000230311003D0,
     +       .000000043454903D0, .000000009689769D0, .000000002493076D0,
     +       .000000000726965D0, .000000000236915D0, .164003650497859D0,
     +       .002808281686604D0, .000144261045541D0, .000012351116909D0,
     +       .000001480442092D0, .000000228150319D0, .000000042973515D0,
     +       .000000009566019D0, .000000002457022D0, .000000000715225D0,
     +       .000000000232690D0, .163863416482905D0, .002801084042439D0,
     +       .000143645335506D0, .000012277379100D0, .000001469088094D0,
     +       .000000226013550D0, .000000042498271D0, .000000009444057D0,
     +       .000000002421550D0, .000000000703695D0, .000000000228547D0,
     +       .163723541582056D0, .002793917091841D0, .000143033298214D0,
     +       .000012204206329D0, .000001457840343D0, .000000223900391D0,
     +       .000000042029080D0, .000000009323854D0, .000000002386649D0,
     +       .000000000692369D0, .000000000224485D0, .163584024265212D0,
     +       .002786780651874D0, .000142424905544D0, .000012131593314D0,
     +       .000001446697666D0, .000000221810542D0, .000000041565857D0,
     +       .000000009205383D0, .000000002352309D0, .000000000681245D0,
     +       .000000000220502D0, .163444863011384D0, .002779674541007D0,
     +       .000141820129640D0, .000012059534830D0, .000001435658905D0,
     +       .000000219743707D0, .000000041108514D0, .000000009088614D0,
     +       .000000002318521D0, .000000000670318D0, .000000000216596D0,
     +       .163306056308629D0, .002772598579091D0, .000141218942905D0,
     +       .000011988025711D0, .000001424722917D0, .000000217699594D0,
     +       .000000040656967D0, .000000008973521D0, .000000002285274D0,
     +       .000000000659584D0, .000000000212766D0/
         DATA  ((FTABLE (I,J),I=0,10),J=590,599)
     +     / .163167602653973D0, .002765552587353D0, .000140621317998D0,
     +       .000011917060845D0, .000001413888572D0, .000000215677915D0,
     +       .000000040211134D0, .000000008860078D0, .000000002252560D0,
     +       .000000000649040D0, .000000000209010D0, .163029500553349D0,
     +       .002758536388379D0, .000140027227834D0, .000011846635178D0,
     +       .000001403154756D0, .000000213678387D0, .000000039770932D0,
     +       .000000008748257D0, .000000002220367D0, .000000000638682D0,
     +       .000000000205327D0, .162891748521524D0, .002751549806104D0,
     +       .000139436645577D0, .000011776743712D0, .000001392520369D0,
     +       .000000211700729D0, .000000039336282D0, .000000008638033D0,
     +       .000000002188688D0, .000000000628506D0, .000000000201714D0,
     +       .162754345082039D0, .002744592665799D0, .000138849544642D0,
     +       .000011707381502D0, .000001381984323D0, .000000209744667D0,
     +       .000000038907103D0, .000000008529380D0, .000000002157514D0,
     +       .000000000618509D0, .000000000198171D0, .162617288767136D0,
     +       .002737664794057D0, .000138265898688D0, .000011638543658D0,
     +       .000001371545547D0, .000000207809929D0, .000000038483318D0,
     +       .000000008422273D0, .000000002126834D0, .000000000608688D0,
     +       .000000000194696D0, .162480578117693D0, .002730766018783D0,
     +       .000137685681617D0, .000011570225344D0, .000001361202980D0,
     +       .000000205896247D0, .000000038064850D0, .000000008316688D0,
     +       .000000002096642D0, .000000000599039D0, .000000000191288D0,
     +       .162344211683164D0, .002723896169179D0, .000137108867574D0,
     +       .000011502421774D0, .000001350955576D0, .000000204003357D0,
     +       .000000037651624D0, .000000008212601D0, .000000002066928D0,
     +       .000000000589558D0, .000000000187944D0, .162208188021507D0,
     +       .002717055075735D0, .000136535430940D0, .000011435128218D0,
     +       .000001340802302D0, .000000202130998D0, .000000037243566D0,
     +       .000000008109987D0, .000000002037683D0, .000000000580243D0,
     +       .000000000184665D0, .162072505699125D0, .002710242570218D0,
     +       .000135965346330D0, .000011368339992D0, .000001330742138D0,
     +       .000000200278915D0, .000000036840601D0, .000000008008825D0,
     +       .000000002008901D0, .000000000571090D0, .000000000181448D0,
     +       .161937163290803D0, .002703458485655D0, .000135398588595D0,
     +       .000011302052469D0, .000001320774077D0, .000000198446855D0,
     +       .000000036442659D0, .000000007909090D0, .000000001980572D0,
     +       .000000000562097D0, .000000000178293D0/
         DATA  ((FTABLE (I,J),I=0,10),J=600,609)
     +     / .161802159379640D0, .002696702656326D0, .000134835132815D0,
     +       .000011236261066D0, .000001310897123D0, .000000196634567D0,
     +       .000000036049669D0, .000000007810760D0, .000000001952688D0,
     +       .000000000553260D0, .000000000175197D0, .161667492556992D0,
     +       .002689974917752D0, .000134274954296D0, .000011170961254D0,
     +       .000001301110294D0, .000000194841806D0, .000000035661560D0,
     +       .000000007713814D0, .000000001925243D0, .000000000544576D0,
     +       .000000000172161D0, .161533161422407D0, .002683275106683D0,
     +       .000133718028571D0, .000011106148551D0, .000001291412621D0,
     +       .000000193068331D0, .000000035278265D0, .000000007618229D0,
     +       .000000001898228D0, .000000000536043D0, .000000000169182D0,
     +       .161399164583566D0, .002676603061086D0, .000133164331396D0,
     +       .000011041818522D0, .000001281803144D0, .000000191313901D0,
     +       .000000034899715D0, .000000007523984D0, .000000001871636D0,
     +       .000000000527657D0, .000000000166259D0, .161265500656222D0,
     +       .002669958620135D0, .000132613838747D0, .000010977966782D0,
     +       .000001272280917D0, .000000189578281D0, .000000034525845D0,
     +       .000000007431058D0, .000000001845460D0, .000000000519416D0,
     +       .000000000163391D0, .161132168264137D0, .002663341624199D0,
     +       .000132066526819D0, .000010914588992D0, .000001262845006D0,
     +       .000000187861239D0, .000000034156588D0, .000000007339431D0,
     +       .000000001819692D0, .000000000511317D0, .000000000160578D0,
     +       .160999166039026D0, .002656751914834D0, .000131522372020D0,
     +       .000010851680859D0, .000001253494487D0, .000000186162547D0,
     +       .000000033791880D0, .000000007249082D0, .000000001794326D0,
     +       .000000000503358D0, .000000000157817D0, .160866492620499D0,
     +       .002650189334768D0, .000130981350976D0, .000010789238135D0,
     +       .000001244228449D0, .000000184481977D0, .000000033431659D0,
     +       .000000007159992D0, .000000001769354D0, .000000000495535D0,
     +       .000000000155109D0, .160734146655997D0, .002643653727894D0,
     +       .000130443440520D0, .000010727256621D0, .000001235045991D0,
     +       .000000182819307D0, .000000033075860D0, .000000007072140D0,
     +       .000000001744770D0, .000000000487846D0, .000000000152451D0,
     +       .160602126800740D0, .002637144939256D0, .000129908617696D0,
     +       .000010665732158D0, .000001225946224D0, .000000181174318D0,
     +       .000000032724424D0, .000000006985508D0, .000000001720568D0,
     +       .000000000480289D0, .000000000149843D0/
         DATA  ((FTABLE (I,J),I=0,10),J=610,619)
     +     / .160470431717665D0, .002630662815043D0, .000129376859755D0,
     +       .000010604660635D0, .000001216928269D0, .000000179546793D0,
     +       .000000032377290D0, .000000006900077D0, .000000001696739D0,
     +       .000000000472861D0, .000000000147284D0, .160339060077373D0,
     +       .002624207202575D0, .000128848144152D0, .000010544037982D0,
     +       .000001207991257D0, .000000177936518D0, .000000032034397D0,
     +       .000000006815828D0, .000000001673279D0, .000000000465560D0,
     +       .000000000144772D0, .160208010558072D0, .002617777950294D0,
     +       .000128322448543D0, .000010483860174D0, .000001199134333D0,
     +       .000000176343283D0, .000000031695687D0, .000000006732743D0,
     +       .000000001650181D0, .000000000458383D0, .000000000142308D0,
     +       .160077281845516D0, .002611374907756D0, .000127799750787D0,
     +       .000010424123228D0, .000001190356648D0, .000000174766881D0,
     +       .000000031361103D0, .000000006650804D0, .000000001627439D0,
     +       .000000000451328D0, .000000000139889D0, .159946872632957D0,
     +       .002604997925617D0, .000127280028938D0, .000010364823203D0,
     +       .000001181657368D0, .000000173207105D0, .000000031030588D0,
     +       .000000006569993D0, .000000001605047D0, .000000000444393D0,
     +       .000000000137515D0, .159816781621085D0, .002598646855627D0,
     +       .000126763261249D0, .000010305956198D0, .000001173035664D0,
     +       .000000171663755D0, .000000030704086D0, .000000006490294D0,
     +       .000000001582998D0, .000000000437576D0, .000000000135185D0,
     +       .159687007517978D0, .002592321550616D0, .000126249426166D0,
     +       .000010247518357D0, .000001164490722D0, .000000170136631D0,
     +       .000000030381541D0, .000000006411688D0, .000000001561287D0,
     +       .000000000430874D0, .000000000132899D0, .159557549039043D0,
     +       .002586021864490D0, .000125738502325D0, .000010189505860D0,
     +       .000001156021734D0, .000000168625536D0, .000000030062899D0,
     +       .000000006334160D0, .000000001539908D0, .000000000424285D0,
     +       .000000000130654D0, .159428404906966D0, .002579747652216D0,
     +       .000125230468554D0, .000010131914931D0, .000001147627904D0,
     +       .000000167130277D0, .000000029748107D0, .000000006257692D0,
     +       .000000001518857D0, .000000000417808D0, .000000000128452D0,
     +       .159299573851657D0, .002573498769816D0, .000124725303868D0,
     +       .000010074741830D0, .000001139308446D0, .000000165650662D0,
     +       .000000029437112D0, .000000006182269D0, .000000001498126D0,
     +       .000000000411439D0, .000000000126289D0/
         DATA  ((FTABLE (I,J),I=0,10),J=620,629)
     +     / .159171054610202D0, .002567275074358D0, .000124222987468D0,
     +       .000010017982860D0, .000001131062580D0, .000000164186503D0,
     +       .000000029129863D0, .000000006107874D0, .000000001477711D0,
     +       .000000000405178D0, .000000000124167D0, .159042845926805D0,
     +       .002561076423942D0, .000123723498741D0, .000009961634359D0,
     +       .000001122889541D0, .000000162737614D0, .000000028826308D0,
     +       .000000006034492D0, .000000001457606D0, .000000000399022D0,
     +       .000000000122084D0, .158914946552739D0, .002554902677696D0,
     +       .000123226817252D0, .000009905692705D0, .000001114788568D0,
     +       .000000161303812D0, .000000028526397D0, .000000005962108D0,
     +       .000000001437807D0, .000000000392969D0, .000000000120038D0,
     +       .158787355246297D0, .002548753695767D0, .000122732922749D0,
     +       .000009850154313D0, .000001106758911D0, .000000159884914D0,
     +       .000000028230081D0, .000000005890707D0, .000000001418308D0,
     +       .000000000387018D0, .000000000118031D0, .158660070772738D0,
     +       .002542629339306D0, .000122241795159D0, .000009795015637D0,
     +       .000001098799831D0, .000000158480744D0, .000000027937310D0,
     +       .000000005820273D0, .000000001399104D0, .000000000381166D0,
     +       .000000000116060D0, .158533091904240D0, .002536529470467D0,
     +       .000121753414582D0, .000009740273166D0, .000001090910594D0,
     +       .000000157091125D0, .000000027648038D0, .000000005750791D0,
     +       .000000001380190D0, .000000000375411D0, .000000000114125D0,
     +       .158406417419846D0, .002530453952393D0, .000121267761296D0,
     +       .000009685923426D0, .000001083090479D0, .000000155715883D0,
     +       .000000027362215D0, .000000005682249D0, .000000001361561D0,
     +       .000000000369753D0, .000000000112225D0, .158280046105420D0,
     +       .002524402649209D0, .000120784815751D0, .000009631962978D0,
     +       .000001075338769D0, .000000154354847D0, .000000027079797D0,
     +       .000000005614631D0, .000000001343213D0, .000000000364188D0,
     +       .000000000110360D0, .158153976753593D0, .002518375426012D0,
     +       .000120304558567D0, .000009578388421D0, .000001067654760D0,
     +       .000000153007847D0, .000000026800737D0, .000000005547923D0,
     +       .000000001325140D0, .000000000358716D0, .000000000108528D0,
     +       .158028208163718D0, .002512372148866D0, .000119826970534D0,
     +       .000009525196385D0, .000001060037753D0, .000000151674718D0,
     +       .000000026524990D0, .000000005482112D0, .000000001307340D0,
     +       .000000000353335D0, .000000000106730D0/
         DATA  ((FTABLE (I,J),I=0,10),J=630,639)
     +     / .157902739141822D0, .002506392684790D0, .000119352032609D0,
     +       .000009472383540D0, .000001052487060D0, .000000150355294D0,
     +       .000000026252511D0, .000000005417185D0, .000000001289806D0,
     +       .000000000348042D0, .000000000104965D0, .157777568500556D0,
     +       .002500436901752D0, .000118879725915D0, .000009419946586D0,
     +       .000001045001998D0, .000000149049413D0, .000000025983257D0,
     +       .000000005353127D0, .000000001272534D0, .000000000342838D0,
     +       .000000000103231D0, .157652695059148D0, .002494504668657D0,
     +       .000118410031740D0, .000009367882258D0, .000001037581895D0,
     +       .000000147756915D0, .000000025717184D0, .000000005289927D0,
     +       .000000001255520D0, .000000000337719D0, .000000000101529D0,
     +       .157528117643361D0, .002488595855345D0, .000117942931533D0,
     +       .000009316187325D0, .000001030226086D0, .000000146477642D0,
     +       .000000025454250D0, .000000005227571D0, .000000001238761D0,
     +       .000000000332684D0, .000000000099858D0, .157403835085439D0,
     +       .002482710332578D0, .000117478406904D0, .000009264858588D0,
     +       .000001022933913D0, .000000145211439D0, .000000025194413D0,
     +       .000000005166047D0, .000000001222251D0, .000000000327733D0,
     +       .000000000098216D0, .157279846224067D0, .002476847972032D0,
     +       .000117016439623D0, .000009213892883D0, .000001015704727D0,
     +       .000000143958150D0, .000000024937632D0, .000000005105342D0,
     +       .000000001205986D0, .000000000322862D0, .000000000096604D0,
     +       .157156149904322D0, .002471008646294D0, .000116557011617D0,
     +       .000009163287077D0, .000001008537886D0, .000000142717625D0,
     +       .000000024683866D0, .000000005045444D0, .000000001189963D0,
     +       .000000000318072D0, .000000000095021D0, .157032744977633D0,
     +       .002465192228848D0, .000116100104969D0, .000009113038066D0,
     +       .000001001432754D0, .000000141489714D0, .000000024433074D0,
     +       .000000004986341D0, .000000001174178D0, .000000000313360D0,
     +       .000000000093467D0, .156909630301727D0, .002459398594071D0,
     +       .000115645701915D0, .000009063142783D0, .000000994388706D0,
     +       .000000140274269D0, .000000024185219D0, .000000004928022D0,
     +       .000000001158626D0, .000000000308725D0, .000000000091940D0,
     +       .156786804740594D0, .002453627617223D0, .000115193784846D0,
     +       .000009013598188D0, .000000987405122D0, .000000139071144D0,
     +       .000000023940259D0, .000000004870475D0, .000000001143304D0,
     +       .000000000304165D0, .000000000090440D0/
         DATA  ((FTABLE (I,J),I=0,10),J=640,649)
     +     / .156664267164437D0, .002447879174444D0, .000114744336302D0,
     +       .000008964401273D0, .000000980481389D0, .000000137880195D0,
     +       .000000023698158D0, .000000004813688D0, .000000001128208D0,
     +       .000000000299680D0, .000000000088967D0, .156542016449632D0,
     +       .002442153142740D0, .000114297338974D0, .000008915549062D0,
     +       .000000973616902D0, .000000136701281D0, .000000023458878D0,
     +       .000000004757651D0, .000000001113335D0, .000000000295268D0,
     +       .000000000087521D0, .156420051478681D0, .002436449399979D0,
     +       .000113852775700D0, .000008867038606D0, .000000966811063D0,
     +       .000000135534261D0, .000000023222381D0, .000000004702351D0,
     +       .000000001098680D0, .000000000290928D0, .000000000086100D0,
     +       .156298371140174D0, .002430767824886D0, .000113410629466D0,
     +       .000008818866988D0, .000000960063280D0, .000000134378997D0,
     +       .000000022988631D0, .000000004647779D0, .000000001084241D0,
     +       .000000000286658D0, .000000000084704D0, .156176974328739D0,
     +       .002425108297030D0, .000112970883402D0, .000008771031320D0,
     +       .000000953372969D0, .000000133235353D0, .000000022757591D0,
     +       .000000004593924D0, .000000001070013D0, .000000000282457D0,
     +       .000000000083333D0, .156055859945010D0, .002419470696822D0,
     +       .000112533520782D0, .000008723528743D0, .000000946739553D0,
     +       .000000132103193D0, .000000022529227D0, .000000004540774D0,
     +       .000000001055994D0, .000000000278324D0, .000000000081987D0,
     +       .155935026895576D0, .002413854905504D0, .000112098525023D0,
     +       .000008676356426D0, .000000940162461D0, .000000130982386D0,
     +       .000000022303502D0, .000000004488321D0, .000000001042180D0,
     +       .000000000274258D0, .000000000080664D0, .155814474092944D0,
     +       .002408260805146D0, .000111665879682D0, .000008629511567D0,
     +       .000000933641128D0, .000000129872800D0, .000000022080383D0,
     +       .000000004436553D0, .000000001028567D0, .000000000270257D0,
     +       .000000000079364D0, .155694200455498D0, .002402688278634D0,
     +       .000111235568455D0, .000008582991393D0, .000000927174996D0,
     +       .000000128774305D0, .000000021859836D0, .000000004385461D0,
     +       .000000001015153D0, .000000000266321D0, .000000000078088D0,
     +       .155574204907456D0, .002397137209668D0, .000110807575177D0,
     +       .000008536793157D0, .000000920763514D0, .000000127686774D0,
     +       .000000021641826D0, .000000004335034D0, .000000001001934D0,
     +       .000000000262448D0, .000000000076834D0/
         DATA  ((FTABLE (I,J),I=0,10),J=650,659)
     +     / .155454486378831D0, .002391607482751D0, .000110381883819D0,
     +       .000008490914140D0, .000000914406138D0, .000000126610081D0,
     +       .000000021426321D0, .000000004285264D0, .000000000988907D0,
     +       .000000000258637D0, .000000000075601D0, .155335043805392D0,
     +       .002386098983186D0, .000109958478488D0, .000008445351650D0,
     +       .000000908102328D0, .000000125544101D0, .000000021213289D0,
     +       .000000004236141D0, .000000000976069D0, .000000000254887D0,
     +       .000000000074391D0, .155215876128622D0, .002380611597065D0,
     +       .000109537343423D0, .000008400103023D0, .000000901851551D0,
     +       .000000124488711D0, .000000021002697D0, .000000004187654D0,
     +       .000000000963417D0, .000000000251198D0, .000000000073202D0,
     +       .155096982295680D0, .002375145211266D0, .000109118462998D0,
     +       .000008355165620D0, .000000895653282D0, .000000123443791D0,
     +       .000000020794513D0, .000000004139796D0, .000000000950948D0,
     +       .000000000247567D0, .000000000072033D0, .154978361259363D0,
     +       .002369699713446D0, .000108701821718D0, .000008310536828D0,
     +       .000000889507000D0, .000000122409220D0, .000000020588707D0,
     +       .000000004092556D0, .000000000938660D0, .000000000243994D0,
     +       .000000000070885D0, .154860011978063D0, .002364274992031D0,
     +       .000108287404215D0, .000008266214062D0, .000000883412190D0,
     +       .000000121384881D0, .000000020385247D0, .000000004045927D0,
     +       .000000000926548D0, .000000000240478D0, .000000000069757D0,
     +       .154741933415733D0, .002358870936215D0, .000107875195254D0,
     +       .000008222194760D0, .000000877368343D0, .000000120370657D0,
     +       .000000020184104D0, .000000003999899D0, .000000000914611D0,
     +       .000000000237018D0, .000000000068648D0, .154624124541849D0,
     +       .002353487435949D0, .000107465179724D0, .000008178476387D0,
     +       .000000871374957D0, .000000119366432D0, .000000019985247D0,
     +       .000000003954463D0, .000000000902845D0, .000000000233613D0,
     +       .000000000067559D0, .154506584331368D0, .002348124381936D0,
     +       .000107057342641D0, .000008135056432D0, .000000865431535D0,
     +       .000000118372094D0, .000000019788648D0, .000000003909611D0,
     +       .000000000891249D0, .000000000230262D0, .000000000066489D0,
     +       .154389311764694D0, .002342781665625D0, .000106651669148D0,
     +       .000008091932409D0, .000000859537585D0, .000000117387531D0,
     +       .000000019594277D0, .000000003865335D0, .000000000879818D0,
     +       .000000000226964D0, .000000000065437D0/
         DATA  ((FTABLE (I,J),I=0,10),J=660,669)
     +     / .154272305827641D0, .002337459179207D0, .000106248144509D0,
     +       .000008049101857D0, .000000853692621D0, .000000116412630D0,
     +       .000000019402105D0, .000000003821627D0, .000000000868551D0,
     +       .000000000223718D0, .000000000064404D0, .154155565511394D0,
     +       .002332156815603D0, .000105846754112D0, .000008006562338D0,
     +       .000000847896163D0, .000000115447284D0, .000000019212105D0,
     +       .000000003778477D0, .000000000857446D0, .000000000220523D0,
     +       .000000000063388D0, .154039089812473D0, .002326874468466D0,
     +       .000105447483465D0, .000007964311440D0, .000000842147735D0,
     +       .000000114491384D0, .000000019024248D0, .000000003735879D0,
     +       .000000000846498D0, .000000000217379D0, .000000000062390D0,
     +       .153922877732700D0, .002321612032167D0, .000105050318198D0,
     +       .000007922346772D0, .000000836446869D0, .000000113544824D0,
     +       .000000018838508D0, .000000003693825D0, .000000000835707D0,
     +       .000000000214284D0, .000000000061409D0, .153806928279158D0,
     +       .002316369401794D0, .000104655244057D0, .000007880665968D0,
     +       .000000830793099D0, .000000112607498D0, .000000018654857D0,
     +       .000000003652306D0, .000000000825069D0, .000000000211238D0,
     +       .000000000060444D0, .153691240464159D0, .002311146473145D0,
     +       .000104262246909D0, .000007839266685D0, .000000825185967D0,
     +       .000000111679304D0, .000000018473268D0, .000000003611316D0,
     +       .000000000814582D0, .000000000208239D0, .000000000059497D0,
     +       .153575813305207D0, .002305943142721D0, .000103871312735D0,
     +       .000007798146602D0, .000000819625018D0, .000000110760138D0,
     +       .000000018293716D0, .000000003570845D0, .000000000804244D0,
     +       .000000000205288D0, .000000000058565D0, .153460645824964D0,
     +       .002300759307721D0, .000103482427634D0, .000007757303421D0,
     +       .000000814109804D0, .000000109849899D0, .000000018116175D0,
     +       .000000003530889D0, .000000000794053D0, .000000000202382D0,
     +       .000000000057650D0, .153345737051213D0, .002295594866036D0,
     +       .000103095577816D0, .000007716734866D0, .000000808639881D0,
     +       .000000108948487D0, .000000017940619D0, .000000003491438D0,
     +       .000000000784005D0, .000000000199522D0, .000000000056750D0,
     +       .153231086016829D0, .002290449716246D0, .000102710749607D0,
     +       .000007676438685D0, .000000803214810D0, .000000108055804D0,
     +       .000000017767023D0, .000000003452486D0, .000000000774100D0,
     +       .000000000196707D0, .000000000055866D0/
         DATA  ((FTABLE (I,J),I=0,10),J=670,679)
     +     / .153116691759737D0, .002285323757608D0, .000102327929445D0,
     +       .000007636412645D0, .000000797834157D0, .000000107171752D0,
     +       .000000017595362D0, .000000003414025D0, .000000000764334D0,
     +       .000000000193935D0, .000000000054997D0, .153002553322884D0,
     +       .002280216890058D0, .000101947103877D0, .000007596654536D0,
     +       .000000792497493D0, .000000106296236D0, .000000017425612D0,
     +       .000000003376050D0, .000000000754706D0, .000000000191207D0,
     +       .000000000054142D0, .152888669754203D0, .002275129014199D0,
     +       .000101568259562D0, .000007557162170D0, .000000787204393D0,
     +       .000000105429160D0, .000000017257749D0, .000000003338553D0,
     +       .000000000745213D0, .000000000188521D0, .000000000053302D0,
     +       .152775040106581D0, .002270060031301D0, .000101191383267D0,
     +       .000007517933378D0, .000000781954437D0, .000000104570430D0,
     +       .000000017091749D0, .000000003301527D0, .000000000735853D0,
     +       .000000000185877D0, .000000000052476D0, .152661663437825D0,
     +       .002265009843291D0, .000100816461868D0, .000007478966014D0,
     +       .000000776747212D0, .000000103719954D0, .000000016927589D0,
     +       .000000003264965D0, .000000000726624D0, .000000000183273D0,
     +       .000000000051665D0, .152548538810628D0, .002259978352750D0,
     +       .000100443482344D0, .000007440257951D0, .000000771582306D0,
     +       .000000102877641D0, .000000016765245D0, .000000003228862D0,
     +       .000000000717525D0, .000000000180710D0, .000000000050866D0,
     +       .152435665292539D0, .002254965462907D0, .000100072431786D0,
     +       .000007401807085D0, .000000766459313D0, .000000102043400D0,
     +       .000000016604695D0, .000000003193211D0, .000000000708553D0,
     +       .000000000178186D0, .000000000050082D0, .152323041955928D0,
     +       .002249971077636D0, .000099703297384D0, .000007363611328D0,
     +       .000000761377833D0, .000000101217142D0, .000000016445917D0,
     +       .000000003158005D0, .000000000699706D0, .000000000175702D0,
     +       .000000000049311D0, .152210667877958D0, .002244995101445D0,
     +       .000099336066436D0, .000007325668616D0, .000000756337468D0,
     +       .000000100398779D0, .000000016288887D0, .000000003123238D0,
     +       .000000000690982D0, .000000000173255D0, .000000000048552D0,
     +       .152098542140547D0, .002240037439478D0, .000098970726339D0,
     +       .000007287976903D0, .000000751337825D0, .000000099588224D0,
     +       .000000016133586D0, .000000003088904D0, .000000000682379D0,
     +       .000000000170846D0, .000000000047807D0/
         DATA  ((FTABLE (I,J),I=0,10),J=680,689)
     +     / .151986663830344D0, .002235097997505D0, .000098607264596D0,
     +       .000007250534161D0, .000000746378517D0, .000000098785392D0,
     +       .000000015979990D0, .000000003054998D0, .000000000673897D0,
     +       .000000000168474D0, .000000000047074D0, .151875032038690D0,
     +       .002230176681919D0, .000098245668807D0, .000007213338385D0,
     +       .000000741459159D0, .000000097990197D0, .000000015828079D0,
     +       .000000003021513D0, .000000000665531D0, .000000000166139D0,
     +       .000000000046353D0, .151763645861595D0, .002225273399730D0,
     +       .000097885926674D0, .000007176387586D0, .000000736579371D0,
     +       .000000097202556D0, .000000015677832D0, .000000002988443D0,
     +       .000000000657282D0, .000000000163839D0, .000000000045644D0,
     +       .151652504399701D0, .002220388058561D0, .000097528025998D0,
     +       .000007139679795D0, .000000731738778D0, .000000096422387D0,
     +       .000000015529228D0, .000000002955783D0, .000000000649147D0,
     +       .000000000161574D0, .000000000044947D0, .151541606758252D0,
     +       .002215520566641D0, .000097171954677D0, .000007103213061D0,
     +       .000000726937009D0, .000000095649606D0, .000000015382247D0,
     +       .000000002923526D0, .000000000641124D0, .000000000159344D0,
     +       .000000000044262D0, .151430952047069D0, .002210670832804D0,
     +       .000096817700707D0, .000007066985453D0, .000000722173696D0,
     +       .000000094884135D0, .000000015236868D0, .000000002891668D0,
     +       .000000000633212D0, .000000000157147D0, .000000000043588D0,
     +       .151320539380514D0, .002205838766480D0, .000096465252178D0,
     +       .000007030995057D0, .000000717448475D0, .000000094125893D0,
     +       .000000015093073D0, .000000002860203D0, .000000000625409D0,
     +       .000000000154985D0, .000000000042926D0, .151210367877462D0,
     +       .002201024277692D0, .000096114597279D0, .000006995239977D0,
     +       .000000712760987D0, .000000093374802D0, .000000014950842D0,
     +       .000000002829126D0, .000000000617713D0, .000000000152855D0,
     +       .000000000042274D0, .151100436661276D0, .002196227277053D0,
     +       .000095765724290D0, .000006959718335D0, .000000708110877D0,
     +       .000000092630783D0, .000000014810154D0, .000000002798430D0,
     +       .000000000610123D0, .000000000150757D0, .000000000041633D0,
     +       .150990744859768D0, .002191447675759D0, .000095418621586D0,
     +       .000006924428272D0, .000000703497792D0, .000000091893761D0,
     +       .000000014670992D0, .000000002768112D0, .000000000602637D0,
     +       .000000000148691D0, .000000000041003D0/
         DATA  ((FTABLE (I,J),I=0,10),J=690,699)
     +     / .150881291605181D0, .002186685385582D0, .000095073277634D0,
     +       .000006889367944D0, .000000698921386D0, .000000091163659D0,
     +       .000000014533337D0, .000000002738165D0, .000000000595253D0,
     +       .000000000146657D0, .000000000040384D0, .150772076034153D0,
     +       .002181940318873D0, .000094729680993D0, .000006854535528D0,
     +       .000000694381312D0, .000000090440402D0, .000000014397170D0,
     +       .000000002708585D0, .000000000587971D0, .000000000144653D0,
     +       .000000000039774D0, .150663097287688D0, .002177212388550D0,
     +       .000094387820313D0, .000006819929213D0, .000000689877233D0,
     +       .000000089723918D0, .000000014262472D0, .000000002679366D0,
     +       .000000000580787D0, .000000000142679D0, .000000000039175D0,
     +       .150554354511133D0, .002172501508097D0, .000094047684333D0,
     +       .000006785547210D0, .000000685408809D0, .000000089014131D0,
     +       .000000014129227D0, .000000002650504D0, .000000000573702D0,
     +       .000000000140735D0, .000000000038585D0, .150445846854147D0,
     +       .002167807591558D0, .000093709261883D0, .000006751387744D0,
     +       .000000680975709D0, .000000088310971D0, .000000013997416D0,
     +       .000000002621994D0, .000000000566713D0, .000000000138820D0,
     +       .000000000038006D0, .150337573470669D0, .002163130553535D0,
     +       .000093372541879D0, .000006717449056D0, .000000676577603D0,
     +       .000000087614366D0, .000000013867022D0, .000000002593831D0,
     +       .000000000559820D0, .000000000136934D0, .000000000037435D0,
     +       .150229533518899D0, .002158470309180D0, .000093037513327D0,
     +       .000006683729406D0, .000000672214164D0, .000000086924245D0,
     +       .000000013738027D0, .000000002566011D0, .000000000553020D0,
     +       .000000000135077D0, .000000000036874D0, .150121726161262D0,
     +       .002153826774193D0, .000092704165317D0, .000006650227067D0,
     +       .000000667885071D0, .000000086240540D0, .000000013610415D0,
     +       .000000002538528D0, .000000000546312D0, .000000000133247D0,
     +       .000000000036323D0, .150014150564386D0, .002149199864819D0,
     +       .000092372487027D0, .000006616940331D0, .000000663590005D0,
     +       .000000085563181D0, .000000013484169D0, .000000002511378D0,
     +       .000000000539694D0, .000000000131444D0, .000000000035780D0,
     +       .149906805899074D0, .002144589497841D0, .000092042467718D0,
     +       .000006583867505D0, .000000659328649D0, .000000084892101D0,
     +       .000000013359272D0, .000000002484557D0, .000000000533167D0,
     +       .000000000129669D0, .000000000035246D0/
         DATA  ((FTABLE (I,J),I=0,10),J=700,709)
     +     / .149799691340274D0, .002139995590575D0, .000091714096739D0,
     +       .000006551006910D0, .000000655100691D0, .000000084227232D0,
     +       .000000013235708D0, .000000002458060D0, .000000000526727D0,
     +       .000000000127919D0, .000000000034721D0, .149692806067057D0,
     +       .002135418060871D0, .000091387363518D0, .000006518356884D0,
     +       .000000650905823D0, .000000083568508D0, .000000013113461D0,
     +       .000000002431883D0, .000000000520374D0, .000000000126196D0,
     +       .000000000034204D0, .149586149262588D0, .002130856827102D0,
     +       .000091062257568D0, .000006485915781D0, .000000646743739D0,
     +       .000000082915864D0, .000000012992514D0, .000000002406021D0,
     +       .000000000514107D0, .000000000124499D0, .000000000033696D0,
     +       .149479720114100D0, .002126311808166D0, .000090738768485D0,
     +       .000006453681969D0, .000000642614136D0, .000000082269235D0,
     +       .000000012872853D0, .000000002380471D0, .000000000507924D0,
     +       .000000000122827D0, .000000000033196D0, .149373517812868D0,
     +       .002121782923478D0, .000090416885944D0, .000006421653831D0,
     +       .000000638516716D0, .000000081628557D0, .000000012754462D0,
     +       .000000002355227D0, .000000000501824D0, .000000000121179D0,
     +       .000000000032705D0, .149267541554183D0, .002117270092967D0,
     +       .000090096599701D0, .000006389829766D0, .000000634451182D0,
     +       .000000080993768D0, .000000012637325D0, .000000002330287D0,
     +       .000000000495806D0, .000000000119556D0, .000000000032221D0,
     +       .149161790537328D0, .002112773237073D0, .000089777899592D0,
     +       .000006358208186D0, .000000630417242D0, .000000080364804D0,
     +       .000000012521428D0, .000000002305645D0, .000000000489868D0,
     +       .000000000117957D0, .000000000031745D0, .149056263965550D0,
     +       .002108292276740D0, .000089460775534D0, .000006326787520D0,
     +       .000000626414606D0, .000000079741605D0, .000000012406756D0,
     +       .000000002281299D0, .000000000484010D0, .000000000116381D0,
     +       .000000000031276D0, .148950961046037D0, .002103827133419D0,
     +       .000089145217518D0, .000006295566209D0, .000000622442987D0,
     +       .000000079124108D0, .000000012293294D0, .000000002257243D0,
     +       .000000000478229D0, .000000000114829D0, .000000000030816D0,
     +       .148845880989892D0, .002099377729053D0, .000088831215616D0,
     +       .000006264542709D0, .000000618502101D0, .000000078512255D0,
     +       .000000012181027D0, .000000002233475D0, .000000000472526D0,
     +       .000000000113300D0, .000000000030362D0/
         DATA  ((FTABLE (I,J),I=0,10),J=710,719)
     +     / .148741023012109D0, .002094943986086D0, .000088518759975D0,
     +       .000006233715491D0, .000000614591668D0, .000000077905986D0,
     +       .000000012069942D0, .000000002209989D0, .000000000466899D0,
     +       .000000000111793D0, .000000000029916D0, .148636386331545D0,
     +       .002090525827448D0, .000088207840821D0, .000006203083039D0,
     +       .000000610711410D0, .000000077305242D0, .000000011960023D0,
     +       .000000002186783D0, .000000000461347D0, .000000000110308D0,
     +       .000000000029478D0, .148531970170902D0, .002086123176558D0,
     +       .000087898448450D0, .000006172643852D0, .000000606861053D0,
     +       .000000076709965D0, .000000011851259D0, .000000002163853D0,
     +       .000000000455868D0, .000000000108845D0, .000000000029046D0,
     +       .148427773756696D0, .002081735957317D0, .000087590573239D0,
     +       .000006142396440D0, .000000603040324D0, .000000076120097D0,
     +       .000000011743633D0, .000000002141195D0, .000000000450462D0,
     +       .000000000107403D0, .000000000028621D0, .148323796319237D0,
     +       .002077364094107D0, .000087284205635D0, .000006112339330D0,
     +       .000000599248954D0, .000000075535582D0, .000000011637135D0,
     +       .000000002118806D0, .000000000445127D0, .000000000105983D0,
     +       .000000000028203D0, .148220037092604D0, .002073007511785D0,
     +       .000086979336159D0, .000006082471060D0, .000000595486677D0,
     +       .000000074956365D0, .000000011531748D0, .000000002096682D0,
     +       .000000000439863D0, .000000000104583D0, .000000000027791D0,
     +       .148116495314621D0, .002068666135679D0, .000086675955406D0,
     +       .000006052790182D0, .000000591753230D0, .000000074382389D0,
     +       .000000011427462D0, .000000002074819D0, .000000000434669D0,
     +       .000000000103203D0, .000000000027386D0, .148013170226836D0,
     +       .002064339891588D0, .000086374054041D0, .000006023295261D0,
     +       .000000588048352D0, .000000073813601D0, .000000011324262D0,
     +       .000000002053214D0, .000000000429543D0, .000000000101844D0,
     +       .000000000026988D0, .147910061074492D0, .002060028705773D0,
     +       .000086073622804D0, .000005993984875D0, .000000584371784D0,
     +       .000000073249945D0, .000000011222136D0, .000000002031863D0,
     +       .000000000424484D0, .000000000100505D0, .000000000026596D0,
     +       .147807167106509D0, .002055732504958D0, .000085774652502D0,
     +       .000005964857615D0, .000000580723273D0, .000000072691369D0,
     +       .000000011121072D0, .000000002010764D0, .000000000419492D0,
     +       .000000000099184D0, .000000000026210D0/
         DATA  ((FTABLE (I,J),I=0,10),J=720,729)
     +     / .147704487575460D0, .002051451216326D0, .000085477134014D0,
     +       .000005935912084D0, .000000577102564D0, .000000072137820D0,
     +       .000000011021056D0, .000000001989913D0, .000000000414565D0,
     +       .000000000097883D0, .000000000025830D0, .147602021737546D0,
     +       .002047184767511D0, .000085181058288D0, .000005907146899D0,
     +       .000000573509408D0, .000000071589246D0, .000000010922076D0,
     +       .000000001969306D0, .000000000409703D0, .000000000096601D0,
     +       .000000000025457D0, .147499768852577D0, .002042933086601D0,
     +       .000084886416341D0, .000005878560688D0, .000000569943557D0,
     +       .000000071045596D0, .000000010824121D0, .000000001948941D0,
     +       .000000000404905D0, .000000000095338D0, .000000000025089D0,
     +       .147397728183946D0, .002038696102129D0, .000084593199258D0,
     +       .000005850152093D0, .000000566404767D0, .000000070506817D0,
     +       .000000010727178D0, .000000001928815D0, .000000000400169D0,
     +       .000000000094092D0, .000000000024727D0, .147295898998607D0,
     +       .002034473743075D0, .000084301398194D0, .000005821919765D0,
     +       .000000562892795D0, .000000069972861D0, .000000010631236D0,
     +       .000000001908924D0, .000000000395495D0, .000000000092865D0,
     +       .000000000024371D0, .147194280567058D0, .002030265938856D0,
     +       .000084011004366D0, .000005793862370D0, .000000559407401D0,
     +       .000000069443677D0, .000000010536282D0, .000000001889264D0,
     +       .000000000390882D0, .000000000091655D0, .000000000024020D0,
     +       .147092872163311D0, .002026072619329D0, .000083722009063D0,
     +       .000005765978586D0, .000000555948348D0, .000000068919217D0,
     +       .000000010442306D0, .000000001869834D0, .000000000386329D0,
     +       .000000000090463D0, .000000000023675D0, .146991673064875D0,
     +       .002021893714785D0, .000083434403636D0, .000005738267100D0,
     +       .000000552515402D0, .000000068399431D0, .000000010349295D0,
     +       .000000001850630D0, .000000000381836D0, .000000000089288D0,
     +       .000000000023335D0, .146890682552737D0, .002017729155944D0,
     +       .000083148179503D0, .000005710726614D0, .000000549108328D0,
     +       .000000067884271D0, .000000010257239D0, .000000001831650D0,
     +       .000000000377400D0, .000000000088129D0, .000000000023001D0,
     +       .146789899911334D0, .002013578873955D0, .000082863328146D0,
     +       .000005683355840D0, .000000545726898D0, .000000067373691D0,
     +       .000000010166126D0, .000000001812889D0, .000000000373023D0,
     +       .000000000086987D0, .000000000022672D0/
         DATA  ((FTABLE (I,J),I=0,10),J=730,739)
     +     / .146689324428535D0, .002009442800391D0, .000082579841112D0,
     +       .000005656153501D0, .000000542370884D0, .000000066867643D0,
     +       .000000010075946D0, .000000001794347D0, .000000000368701D0,
     +       .000000000085862D0, .000000000022348D0, .146588955395621D0,
     +       .002005320867245D0, .000082297710010D0, .000005629118332D0,
     +       .000000539040059D0, .000000066366081D0, .000000009986688D0,
     +       .000000001776018D0, .000000000364436D0, .000000000084753D0,
     +       .000000000022029D0, .146488792107263D0, .002001213006930D0,
     +       .000082016926514D0, .000005602249079D0, .000000535734202D0,
     +       .000000065868959D0, .000000009898341D0, .000000001757902D0,
     +       .000000000360226D0, .000000000083659D0, .000000000021715D0,
     +       .146388833861501D0, .001997119152271D0, .000081737482358D0,
     +       .000005575544499D0, .000000532453090D0, .000000065376232D0,
     +       .000000009810894D0, .000000001739995D0, .000000000356070D0,
     +       .000000000082581D0, .000000000021406D0, .146289079959722D0,
     +       .001993039236508D0, .000081459369340D0, .000005549003361D0,
     +       .000000529196506D0, .000000064887855D0, .000000009724338D0,
     +       .000000001722294D0, .000000000351967D0, .000000000081518D0,
     +       .000000000021101D0, .146189529706641D0, .001988973193288D0,
     +       .000081182579318D0, .000005522624443D0, .000000525964233D0,
     +       .000000064403784D0, .000000009638661D0, .000000001704797D0,
     +       .000000000347918D0, .000000000080471D0, .000000000020802D0,
     +       .146090182410283D0, .001984920956661D0, .000080907104212D0,
     +       .000005496406536D0, .000000522756056D0, .000000063923974D0,
     +       .000000009553855D0, .000000001687502D0, .000000000343920D0,
     +       .000000000079438D0, .000000000020507D0, .145991037381958D0,
     +       .001980882461085D0, .000080632936001D0, .000005470348440D0,
     +       .000000519571765D0, .000000063448384D0, .000000009469908D0,
     +       .000000001670404D0, .000000000339974D0, .000000000078420D0,
     +       .000000000020217D0, .145892093936243D0, .001976857641413D0,
     +       .000080360066724D0, .000005444448965D0, .000000516411148D0,
     +       .000000062976969D0, .000000009386811D0, .000000001653503D0,
     +       .000000000336078D0, .000000000077416D0, .000000000019931D0,
     +       .145793351390964D0, .001972846432895D0, .000080088488480D0,
     +       .000005418706934D0, .000000513273999D0, .000000062509689D0,
     +       .000000009304554D0, .000000001636796D0, .000000000332232D0,
     +       .000000000076427D0, .000000000019650D0/
         DATA  ((FTABLE (I,J),I=0,10),J=740,749)
     +     / .145694809067174D0, .001968848771178D0, .000079818193426D0,
     +       .000005393121177D0, .000000510160111D0, .000000062046500D0,
     +       .000000009223128D0, .000000001620279D0, .000000000328435D0,
     +       .000000000075451D0, .000000000019373D0, .145596466289133D0,
     +       .001964864592296D0, .000079549173777D0, .000005367690538D0,
     +       .000000507069282D0, .000000061587362D0, .000000009142523D0,
     +       .000000001603951D0, .000000000324687D0, .000000000074489D0,
     +       .000000000019100D0, .145498322384290D0, .001960893832672D0,
     +       .000079281421806D0, .000005342413868D0, .000000504001308D0,
     +       .000000061132234D0, .000000009062730D0, .000000001587810D0,
     +       .000000000320986D0, .000000000073541D0, .000000000018831D0,
     +       .145400376683265D0, .001956936429115D0, .000079014929843D0,
     +       .000005317290030D0, .000000500955992D0, .000000060681076D0,
     +       .000000008983739D0, .000000001571852D0, .000000000317332D0,
     +       .000000000072606D0, .000000000018567D0, .145302628519824D0,
     +       .001952992318815D0, .000078749690275D0, .000005292317895D0,
     +       .000000497933135D0, .000000060233847D0, .000000008905542D0,
     +       .000000001556076D0, .000000000313725D0, .000000000071684D0,
     +       .000000000018307D0, .145205077230869D0, .001949061439341D0,
     +       .000078485695544D0, .000005267496345D0, .000000494932543D0,
     +       .000000059790508D0, .000000008828129D0, .000000001540479D0,
     +       .000000000310164D0, .000000000070776D0, .000000000018050D0,
     +       .145107722156411D0, .001945143728638D0, .000078222938149D0,
     +       .000005242824273D0, .000000491954020D0, .000000059351021D0,
     +       .000000008751491D0, .000000001525059D0, .000000000306647D0,
     +       .000000000069879D0, .000000000017798D0, .145010562639554D0,
     +       .001941239125028D0, .000077961410644D0, .000005218300579D0,
     +       .000000488997377D0, .000000058915347D0, .000000008675620D0,
     +       .000000001509813D0, .000000000303175D0, .000000000068996D0,
     +       .000000000017549D0, .144913598026479D0, .001937347567199D0,
     +       .000077701105636D0, .000005193924174D0, .000000486062423D0,
     +       .000000058483447D0, .000000008600507D0, .000000001494740D0,
     +       .000000000299747D0, .000000000068124D0, .000000000017304D0,
     +       .144816827666421D0, .001933468994211D0, .000077442015790D0,
     +       .000005169693978D0, .000000483148970D0, .000000058055283D0,
     +       .000000008526143D0, .000000001479838D0, .000000000296363D0,
     +       .000000000067265D0, .000000000017063D0/
         DATA  ((FTABLE (I,J),I=0,10),J=750,759)
     +     / .144720250911654D0, .001929603345489D0, .000077184133820D0,
     +       .000005145608921D0, .000000480256833D0, .000000057630820D0,
     +       .000000008452520D0, .000000001465104D0, .000000000293021D0,
     +       .000000000066418D0, .000000000016826D0, .144623867117471D0,
     +       .001925750560819D0, .000076927452496D0, .000005121667942D0,
     +       .000000477385827D0, .000000057210019D0, .000000008379630D0,
     +       .000000001450535D0, .000000000289721D0, .000000000065583D0,
     +       .000000000016592D0, .144527675642169D0, .001921910580348D0,
     +       .000076671964642D0, .000005097869989D0, .000000474535770D0,
     +       .000000056792845D0, .000000008307464D0, .000000001436131D0,
     +       .000000000286462D0, .000000000064759D0, .000000000016362D0,
     +       .144431675847025D0, .001918083344582D0, .000076417663131D0,
     +       .000005074214019D0, .000000471706483D0, .000000056379261D0,
     +       .000000008236014D0, .000000001421888D0, .000000000283245D0,
     +       .000000000063946D0, .000000000016135D0, .144335867096284D0,
     +       .001914268794380D0, .000076164540890D0, .000005050698998D0,
     +       .000000468897785D0, .000000055969232D0, .000000008165273D0,
     +       .000000001407806D0, .000000000280067D0, .000000000063145D0,
     +       .000000000015912D0, .144240248757141D0, .001910466870956D0,
     +       .000075912590899D0, .000005027323901D0, .000000466109501D0,
     +       .000000055562722D0, .000000008095231D0, .000000001393881D0,
     +       .000000000276930D0, .000000000062355D0, .000000000015692D0,
     +       .144144820199717D0, .001906677515869D0, .000075661806185D0,
     +       .000005004087711D0, .000000463341455D0, .000000055159697D0,
     +       .000000008025882D0, .000000001380112D0, .000000000273832D0,
     +       .000000000061576D0, .000000000015475D0, .144049580797050D0,
     +       .001902900671031D0, .000075412179829D0, .000004980989421D0,
     +       .000000460593474D0, .000000054760122D0, .000000007957217D0,
     +       .000000001366497D0, .000000000270772D0, .000000000060807D0,
     +       .000000000015262D0, .143954529925072D0, .001899136278695D0,
     +       .000075163704962D0, .000004958028032D0, .000000457865386D0,
     +       .000000054363964D0, .000000007889230D0, .000000001353034D0,
     +       .000000000267751D0, .000000000060050D0, .000000000015052D0,
     +       .143859666962595D0, .001895384281457D0, .000074916374761D0,
     +       .000004935202553D0, .000000455157021D0, .000000053971188D0,
     +       .000000007821911D0, .000000001339721D0, .000000000264767D0,
     +       .000000000059302D0, .000000000014845D0/
         DATA  ((FTABLE (I,J),I=0,10),J=760,769)
     +     / .143764991291293D0, .001891644622254D0, .000074670182457D0,
     +       .000004912512004D0, .000000452468211D0, .000000053581762D0,
     +       .000000007755255D0, .000000001326557D0, .000000000261820D0,
     +       .000000000058565D0, .000000000014641D0, .143670502295682D0,
     +       .001887917244358D0, .000074425121328D0, .000004889955409D0,
     +       .000000449798789D0, .000000053195652D0, .000000007689253D0,
     +       .000000001313539D0, .000000000258910D0, .000000000057838D0,
     +       .000000000014441D0, .143576199363108D0, .001884202091379D0,
     +       .000074181184700D0, .000004867531804D0, .000000447148591D0,
     +       .000000052812826D0, .000000007623899D0, .000000001300665D0,
     +       .000000000256036D0, .000000000057121D0, .000000000014243D0,
     +       .143482081883730D0, .001880499107257D0, .000073938365947D0,
     +       .000004845240232D0, .000000444517453D0, .000000052433251D0,
     +       .000000007559184D0, .000000001287934D0, .000000000253198D0,
     +       .000000000056414D0, .000000000014048D0, .143388149250497D0,
     +       .001876808236263D0, .000073696658492D0, .000004823079744D0,
     +       .000000441905212D0, .000000052056897D0, .000000007495103D0,
     +       .000000001275345D0, .000000000250395D0, .000000000055716D0,
     +       .000000000013856D0, .143294400859142D0, .001873129422995D0,
     +       .000073456055804D0, .000004801049399D0, .000000439311710D0,
     +       .000000051683731D0, .000000007431648D0, .000000001262894D0,
     +       .000000000247626D0, .000000000055028D0, .000000000013667D0,
     +       .143200836108154D0, .001869462612378D0, .000073216551399D0,
     +       .000004779148264D0, .000000436736786D0, .000000051313722D0,
     +       .000000007368811D0, .000000001250582D0, .000000000244892D0,
     +       .000000000054349D0, .000000000013481D0, .143107454398772D0,
     +       .001865807749658D0, .000072978138839D0, .000004757375413D0,
     +       .000000434180285D0, .000000050946839D0, .000000007306587D0,
     +       .000000001238405D0, .000000000242191D0, .000000000053680D0,
     +       .000000000013298D0, .143014255134964D0, .001862164780403D0,
     +       .000072740811734D0, .000004735729931D0, .000000431642051D0,
     +       .000000050583053D0, .000000007244969D0, .000000001226362D0,
     +       .000000000239524D0, .000000000053020D0, .000000000013117D0,
     +       .142921237723410D0, .001858533650499D0, .000072504563739D0,
     +       .000004714210906D0, .000000429121929D0, .000000050222332D0,
     +       .000000007183949D0, .000000001214452D0, .000000000236889D0,
     +       .000000000052368D0, .000000000012939D0/
         DATA  ((FTABLE (I,J),I=0,10),J=770,779)
     +     / .142828401573488D0, .001854914306149D0, .000072269388551D0,
     +       .000004692817438D0, .000000426619767D0, .000000049864648D0,
     +       .000000007123521D0, .000000001202672D0, .000000000234287D0,
     +       .000000000051726D0, .000000000012763D0, .142735746097260D0,
     +       .001851306693868D0, .000072035279917D0, .000004671548633D0,
     +       .000000424135414D0, .000000049509971D0, .000000007063679D0,
     +       .000000001191022D0, .000000000231716D0, .000000000051092D0,
     +       .000000000012591D0, .142643270709453D0, .001847710760485D0,
     +       .000071802231625D0, .000004650403603D0, .000000421668720D0,
     +       .000000049158271D0, .000000007004417D0, .000000001179500D0,
     +       .000000000229178D0, .000000000050467D0, .000000000012421D0,
     +       .142550974827445D0, .001844126453136D0, .000071570237509D0,
     +       .000004629381469D0, .000000419219538D0, .000000048809519D0,
     +       .000000006945727D0, .000000001168104D0, .000000000226670D0,
     +       .000000000049850D0, .000000000012253D0, .142458857871248D0,
     +       .001840553719267D0, .000071339291444D0, .000004608481359D0,
     +       .000000416787720D0, .000000048463688D0, .000000006887604D0,
     +       .000000001156833D0, .000000000224192D0, .000000000049241D0,
     +       .000000000012088D0, .142366919263498D0, .001836992506626D0,
     +       .000071109387353D0, .000004587702410D0, .000000414373121D0,
     +       .000000048120750D0, .000000006830042D0, .000000001145684D0,
     +       .000000000221745D0, .000000000048641D0, .000000000011925D0,
     +       .142275158429431D0, .001833442763266D0, .000070880519198D0,
     +       .000004567043763D0, .000000411975597D0, .000000047780675D0,
     +       .000000006773034D0, .000000001134658D0, .000000000219328D0,
     +       .000000000048049D0, .000000000011765D0, .142183574796878D0,
     +       .001829904437540D0, .000070652680986D0, .000004546504568D0,
     +       .000000409595006D0, .000000047443437D0, .000000006716574D0,
     +       .000000001123751D0, .000000000216940D0, .000000000047464D0,
     +       .000000000011606D0, .142092167796239D0, .001826377478101D0,
     +       .000070425866765D0, .000004526083982D0, .000000407231207D0,
     +       .000000047109008D0, .000000006660657D0, .000000001112963D0,
     +       .000000000214582D0, .000000000046888D0, .000000000011451D0,
     +       .142000936860480D0, .001822861833896D0, .000070200070625D0,
     +       .000004505781170D0, .000000404884059D0, .000000046777362D0,
     +       .000000006605276D0, .000000001102292D0, .000000000212251D0,
     +       .000000000046319D0, .000000000011297D0/
         DATA  ((FTABLE (I,J),I=0,10),J=780,789)
     +     / .141909881425109D0, .001819357454168D0, .000069975286699D0,
     +       .000004485595301D0, .000000402553424D0, .000000046448472D0,
     +       .000000006550426D0, .000000001091738D0, .000000000209950D0,
     +       .000000000045758D0, .000000000011146D0, .141819000928164D0,
     +       .001815864288453D0, .000069751509160D0, .000004465525554D0,
     +       .000000400239166D0, .000000046122311D0, .000000006496100D0,
     +       .000000001081297D0, .000000000207675D0, .000000000045205D0,
     +       .000000000010997D0, .141728294810200D0, .001812382286575D0,
     +       .000069528732222D0, .000004445571114D0, .000000397941148D0,
     +       .000000045798853D0, .000000006442294D0, .000000001070970D0,
     +       .000000000205429D0, .000000000044658D0, .000000000010851D0,
     +       .141637762514274D0, .001808911398650D0, .000069306950140D0,
     +       .000004425731171D0, .000000395659236D0, .000000045478073D0,
     +       .000000006389001D0, .000000001060754D0, .000000000203210D0,
     +       .000000000044120D0, .000000000010706D0, .141547403485929D0,
     +       .001805451575076D0, .000069086157210D0, .000004406004924D0,
     +       .000000393393297D0, .000000045159945D0, .000000006336217D0,
     +       .000000001050648D0, .000000000201017D0, .000000000043588D0,
     +       .000000000010563D0, .141457217173182D0, .001802002766537D0,
     +       .000068866347766D0, .000004386391577D0, .000000391143198D0,
     +       .000000044844443D0, .000000006283935D0, .000000001040652D0,
     +       .000000000198851D0, .000000000043063D0, .000000000010423D0,
     +       .141367203026509D0, .001798564924001D0, .000068647516183D0,
     +       .000004366890342D0, .000000388908809D0, .000000044531543D0,
     +       .000000006232150D0, .000000001030763D0, .000000000196710D0,
     +       .000000000042546D0, .000000000010285D0, .141277360498828D0,
     +       .001795137998714D0, .000068429656876D0, .000004347500437D0,
     +       .000000386690001D0, .000000044221220D0, .000000006180857D0,
     +       .000000001020980D0, .000000000194596D0, .000000000042035D0,
     +       .000000000010148D0, .141187689045491D0, .001791721942202D0,
     +       .000068212764297D0, .000004328221085D0, .000000384486645D0,
     +       .000000043913449D0, .000000006130050D0, .000000001011303D0,
     +       .000000000192507D0, .000000000041531D0, .000000000010014D0,
     +       .141098188124265D0, .001788316706264D0, .000067996832938D0,
     +       .000004309051517D0, .000000382298614D0, .000000043608207D0,
     +       .000000006079725D0, .000000001001729D0, .000000000190443D0,
     +       .000000000041033D0, .000000000009881D0/
         DATA  ((FTABLE (I,J),I=0,10),J=790,799)
     +     / .141008857195321D0, .001784922242979D0, .000067781857328D0,
     +       .000004289990970D0, .000000380125782D0, .000000043305469D0,
     +       .000000006029875D0, .000000000992258D0, .000000000188403D0,
     +       .000000000040543D0, .000000000009751D0, .140919695721217D0,
     +       .001781538504693D0, .000067567832036D0, .000004271038688D0,
     +       .000000377968025D0, .000000043005211D0, .000000005980497D0,
     +       .000000000982888D0, .000000000186388D0, .000000000040058D0,
     +       .000000000009622D0, .140830703166891D0, .001778165444026D0,
     +       .000067354751668D0, .000004252193918D0, .000000375825220D0,
     +       .000000042707411D0, .000000005931585D0, .000000000973619D0,
     +       .000000000184397D0, .000000000039580D0, .000000000009495D0,
     +       .140741878999640D0, .001774803013867D0, .000067142610865D0,
     +       .000004233455918D0, .000000373697244D0, .000000042412045D0,
     +       .000000005883134D0, .000000000964448D0, .000000000182430D0,
     +       .000000000039109D0, .000000000009370D0, .140653222689110D0,
     +       .001771451167369D0, .000066931404309D0, .000004214823949D0,
     +       .000000371583975D0, .000000042119090D0, .000000005835138D0,
     +       .000000000955375D0, .000000000180487D0, .000000000038643D0,
     +       .000000000009247D0, .140564733707285D0, .001768109857953D0,
     +       .000066721126715D0, .000004196297278D0, .000000369485295D0,
     +       .000000041828524D0, .000000005787595D0, .000000000946399D0,
     +       .000000000178566D0, .000000000038184D0, .000000000009126D0,
     +       .140476411528469D0, .001764779039302D0, .000066511772838D0,
     +       .000004177875178D0, .000000367401084D0, .000000041540324D0,
     +       .000000005740497D0, .000000000937518D0, .000000000176668D0,
     +       .000000000037731D0, .000000000009006D0, .140388255629276D0,
     +       .001761458665361D0, .000066303337467D0, .000004159556930D0,
     +       .000000365331223D0, .000000041254467D0, .000000005693841D0,
     +       .000000000928732D0, .000000000174793D0, .000000000037283D0,
     +       .000000000008888D0, .140300265488618D0, .001758148690334D0,
     +       .000066095815426D0, .000004141341819D0, .000000363275598D0,
     +       .000000040970932D0, .000000005647622D0, .000000000920039D0,
     +       .000000000172940D0, .000000000036842D0, .000000000008772D0,
     +       .140212440587687D0, .001754849068682D0, .000065889201578D0,
     +       .000004123229135D0, .000000361234092D0, .000000040689697D0,
     +       .000000005601836D0, .000000000911438D0, .000000000171108D0,
     +       .000000000036406D0, .000000000008657D0/
         DATA  ((FTABLE (I,J),I=0,10),J=800,809)
     +     / .140124780409948D0, .001751559755124D0, .000065683490817D0,
     +       .000004105218176D0, .000000359206590D0, .000000040410741D0,
     +       .000000005556477D0, .000000000902928D0, .000000000169299D0,
     +       .000000000035976D0, .000000000008544D0, .140037284441124D0,
     +       .001748280704633D0, .000065478678076D0, .000004087308244D0,
     +       .000000357192980D0, .000000040134043D0, .000000005511541D0,
     +       .000000000894507D0, .000000000167511D0, .000000000035552D0,
     +       .000000000008433D0, .139949952169180D0, .001745011872434D0,
     +       .000065274758320D0, .000004069498648D0, .000000355193149D0,
     +       .000000039859580D0, .000000005467025D0, .000000000886176D0,
     +       .000000000165744D0, .000000000035133D0, .000000000008323D0,
     +       .139862783084318D0, .001741753214001D0, .000065071726550D0,
     +       .000004051788702D0, .000000353206985D0, .000000039587333D0,
     +       .000000005422922D0, .000000000877933D0, .000000000163997D0,
     +       .000000000034719D0, .000000000008215D0, .139775776678955D0,
     +       .001738504685062D0, .000064869577801D0, .000004034177724D0,
     +       .000000351234379D0, .000000039317281D0, .000000005379230D0,
     +       .000000000869776D0, .000000000162272D0, .000000000034311D0,
     +       .000000000008108D0, .139688932447720D0, .001735266241587D0,
     +       .000064668307140D0, .000004016665040D0, .000000349275221D0,
     +       .000000039049404D0, .000000005335943D0, .000000000861705D0,
     +       .000000000160566D0, .000000000033908D0, .000000000008003D0,
     +       .139602249887435D0, .001732037839794D0, .000064467909670D0,
     +       .000003999249980D0, .000000347329403D0, .000000038783680D0,
     +       .000000005293058D0, .000000000853719D0, .000000000158881D0,
     +       .000000000033511D0, .000000000007900D0, .139515728497105D0,
     +       .001728819436148D0, .000064268380526D0, .000003981931879D0,
     +       .000000345396817D0, .000000038520091D0, .000000005250570D0,
     +       .000000000845817D0, .000000000157215D0, .000000000033118D0,
     +       .000000000007797D0, .139429367777907D0, .001725610987350D0,
     +       .000064069714877D0, .000003964710079D0, .000000343477358D0,
     +       .000000038258617D0, .000000005208475D0, .000000000837997D0,
     +       .000000000155569D0, .000000000032731D0, .000000000007697D0,
     +       .139343167233174D0, .001722412450348D0, .000063871907924D0,
     +       .000003947583926D0, .000000341570921D0, .000000037999237D0,
     +       .000000005166769D0, .000000000830260D0, .000000000153942D0,
     +       .000000000032349D0, .000000000007597D0/
         DATA  ((FTABLE (I,J),I=0,10),J=810,819)
     +     / .139257126368389D0, .001719223782326D0, .000063674954901D0,
     +       .000003930552772D0, .000000339677400D0, .000000037741933D0,
     +       .000000005125448D0, .000000000822603D0, .000000000152334D0,
     +       .000000000031971D0, .000000000007499D0, .139171244691168D0,
     +       .001716044940705D0, .000063478851074D0, .000003913615973D0,
     +       .000000337796693D0, .000000037486686D0, .000000005084507D0,
     +       .000000000815026D0, .000000000150745D0, .000000000031599D0,
     +       .000000000007403D0, .139085521711251D0, .001712875883143D0,
     +       .000063283591742D0, .000003896772891D0, .000000335928697D0,
     +       .000000037233476D0, .000000005043944D0, .000000000807528D0,
     +       .000000000149174D0, .000000000031231D0, .000000000007308D0,
     +       .138999956940488D0, .001709716567534D0, .000063089172234D0,
     +       .000003880022893D0, .000000334073312D0, .000000036982285D0,
     +       .000000005003753D0, .000000000800108D0, .000000000147621D0,
     +       .000000000030868D0, .000000000007214D0, .138914549892830D0,
     +       .001706566952000D0, .000062895587912D0, .000003863365351D0,
     +       .000000332230436D0, .000000036733095D0, .000000004963932D0,
     +       .000000000792766D0, .000000000146087D0, .000000000030510D0,
     +       .000000000007121D0, .138829300084314D0, .001703426994900D0,
     +       .000062702834168D0, .000003846799642D0, .000000330399969D0,
     +       .000000036485886D0, .000000004924475D0, .000000000785499D0,
     +       .000000000144570D0, .000000000030156D0, .000000000007030D0,
     +       .138744207033056D0, .001700296654817D0, .000062510906427D0,
     +       .000003830325149D0, .000000328581814D0, .000000036240641D0,
     +       .000000004885381D0, .000000000778308D0, .000000000143071D0,
     +       .000000000029807D0, .000000000006940D0, .138659270259235D0,
     +       .001697175890566D0, .000062319800143D0, .000003813941257D0,
     +       .000000326775873D0, .000000035997342D0, .000000004846643D0,
     +       .000000000771192D0, .000000000141590D0, .000000000029462D0,
     +       .000000000006852D0, .138574489285085D0, .001694064661187D0,
     +       .000062129510801D0, .000003797647360D0, .000000324982048D0,
     +       .000000035755971D0, .000000004808260D0, .000000000764149D0,
     +       .000000000140125D0, .000000000029121D0, .000000000006764D0,
     +       .138489863634881D0, .001690962925945D0, .000061940033917D0,
     +       .000003781442852D0, .000000323200244D0, .000000035516510D0,
     +       .000000004770227D0, .000000000757179D0, .000000000138677D0,
     +       .000000000028785D0, .000000000006678D0/
         DATA  ((FTABLE (I,J),I=0,10),J=820,829)
     +     / .138405392834930D0, .001687870644328D0, .000061751365036D0,
     +       .000003765327136D0, .000000321430365D0, .000000035278943D0,
     +       .000000004732541D0, .000000000750281D0, .000000000137247D0,
     +       .000000000028454D0, .000000000006593D0, .138321076413560D0,
     +       .001684787776048D0, .000061563499734D0, .000003749299618D0,
     +       .000000319672318D0, .000000035043250D0, .000000004695198D0,
     +       .000000000743454D0, .000000000135832D0, .000000000028126D0,
     +       .000000000006509D0, .138236913901105D0, .001681714281035D0,
     +       .000061376433614D0, .000003733359709D0, .000000317926009D0,
     +       .000000034809417D0, .000000004658194D0, .000000000736697D0,
     +       .000000000134434D0, .000000000027803D0, .000000000006426D0,
     +       .138152904829899D0, .001678650119440D0, .000061190162313D0,
     +       .000003717506823D0, .000000316191346D0, .000000034577425D0,
     +       .000000004621527D0, .000000000730010D0, .000000000133052D0,
     +       .000000000027483D0, .000000000006345D0, .138069048734264D0,
     +       .001675595251629D0, .000061004681491D0, .000003701740382D0,
     +       .000000314468236D0, .000000034347259D0, .000000004585192D0,
     +       .000000000723392D0, .000000000131685D0, .000000000027168D0,
     +       .000000000006264D0, .137985345150497D0, .001672549638188D0,
     +       .000060819986843D0, .000003686059809D0, .000000312756590D0,
     +       .000000034118901D0, .000000004549187D0, .000000000716842D0,
     +       .000000000130335D0, .000000000026857D0, .000000000006185D0,
     +       .137901793616860D0, .001669513239914D0, .000060636074089D0,
     +       .000003670464533D0, .000000311056316D0, .000000033892335D0,
     +       .000000004513507D0, .000000000710358D0, .000000000129000D0,
     +       .000000000026550D0, .000000000006107D0, .137818393673569D0,
     +       .001666486017818D0, .000060452938978D0, .000003654953989D0,
     +       .000000309367327D0, .000000033667545D0, .000000004478150D0,
     +       .000000000703941D0, .000000000127680D0, .000000000026246D0,
     +       .000000000006030D0, .137735144862788D0, .001663467933125D0,
     +       .000060270577287D0, .000003639527614D0, .000000307689533D0,
     +       .000000033444514D0, .000000004443112D0, .000000000697590D0,
     +       .000000000126375D0, .000000000025947D0, .000000000005954D0,
     +       .137652046728610D0, .001660458947269D0, .000060088984823D0,
     +       .000003624184851D0, .000000306022846D0, .000000033223228D0,
     +       .000000004408390D0, .000000000691304D0, .000000000125085D0,
     +       .000000000025651D0, .000000000005879D0/
         DATA  ((FTABLE (I,J),I=0,10),J=830,839)
     +     / .137569098817053D0, .001657459021892D0, .000059908157418D0,
     +       .000003608925146D0, .000000304367181D0, .000000033003670D0,
     +       .000000004373980D0, .000000000685081D0, .000000000123810D0,
     +       .000000000025359D0, .000000000005805D0, .137486300676048D0,
     +       .001654468118845D0, .000059728090933D0, .000003593747950D0,
     +       .000000302722451D0, .000000032785825D0, .000000004339881D0,
     +       .000000000678922D0, .000000000122549D0, .000000000025070D0,
     +       .000000000005732D0, .137403651855429D0, .001651486200185D0,
     +       .000059548781257D0, .000003578652720D0, .000000301088570D0,
     +       .000000032569677D0, .000000004306087D0, .000000000672826D0,
     +       .000000000121303D0, .000000000024785D0, .000000000005660D0,
     +       .137321151906919D0, .001648513228174D0, .000059370224304D0,
     +       .000003563638914D0, .000000299465455D0, .000000032355211D0,
     +       .000000004272597D0, .000000000666792D0, .000000000120071D0,
     +       .000000000024504D0, .000000000005589D0, .137238800384126D0,
     +       .001645549165277D0, .000059192416017D0, .000003548705996D0,
     +       .000000297853021D0, .000000032142412D0, .000000004239407D0,
     +       .000000000660819D0, .000000000118852D0, .000000000024226D0,
     +       .000000000005519D0, .137156596842529D0, .001642593974162D0,
     +       .000059015352365D0, .000003533853435D0, .000000296251186D0,
     +       .000000031931266D0, .000000004206514D0, .000000000654906D0,
     +       .000000000117648D0, .000000000023952D0, .000000000005450D0,
     +       .137074540839466D0, .001639647617697D0, .000058839029343D0,
     +       .000003519080702D0, .000000294659867D0, .000000031721756D0,
     +       .000000004173915D0, .000000000649054D0, .000000000116457D0,
     +       .000000000023681D0, .000000000005382D0, .136992631934130D0,
     +       .001636710058950D0, .000058663442973D0, .000003504387274D0,
     +       .000000293078984D0, .000000031513869D0, .000000004141608D0,
     +       .000000000643260D0, .000000000115280D0, .000000000023414D0,
     +       .000000000005315D0, .136910869687555D0, .001633781261188D0,
     +       .000058488589303D0, .000003489772631D0, .000000291508454D0,
     +       .000000031307590D0, .000000004109588D0, .000000000637526D0,
     +       .000000000114116D0, .000000000023150D0, .000000000005249D0,
     +       .136829253662604D0, .001630861187874D0, .000058314464405D0,
     +       .000003475236258D0, .000000289948198D0, .000000031102906D0,
     +       .000000004077854D0, .000000000631849D0, .000000000112965D0,
     +       .000000000022889D0, .000000000005183D0/
         DATA  ((FTABLE (I,J),I=0,10),J=840,849)
     +     / .136747783423966D0, .001627949802666D0, .000058141064381D0,
     +       .000003460777642D0, .000000288398137D0, .000000030899800D0,
     +       .000000004046402D0, .000000000626229D0, .000000000111827D0,
     +       .000000000022632D0, .000000000005119D0, .136666458538138D0,
     +       .001625047069419D0, .000057968385354D0, .000003446396275D0,
     +       .000000286858192D0, .000000030698261D0, .000000004015230D0,
     +       .000000000620666D0, .000000000110701D0, .000000000022377D0,
     +       .000000000005055D0, .136585278573424D0, .001622152952178D0,
     +       .000057796423474D0, .000003432091655D0, .000000285328285D0,
     +       .000000030498273D0, .000000003984335D0, .000000000615159D0,
     +       .000000000109589D0, .000000000022126D0, .000000000004993D0,
     +       .136504243099916D0, .001619267415183D0, .000057625174918D0,
     +       .000003417863281D0, .000000283808339D0, .000000030299823D0,
     +       .000000003953714D0, .000000000609707D0, .000000000108489D0,
     +       .000000000021878D0, .000000000004931D0, .136423351689494D0,
     +       .001616390422861D0, .000057454635884D0, .000003403710657D0,
     +       .000000282298277D0, .000000030102897D0, .000000003923363D0,
     +       .000000000604310D0, .000000000107401D0, .000000000021633D0,
     +       .000000000004870D0, .136342603915809D0, .001613521939832D0,
     +       .000057284802598D0, .000003389633290D0, .000000280798024D0,
     +       .000000029907482D0, .000000003893282D0, .000000000598966D0,
     +       .000000000106325D0, .000000000021391D0, .000000000004810D0,
     +       .136261999354276D0, .001610661930902D0, .000057115671309D0,
     +       .000003375630692D0, .000000279307504D0, .000000029713564D0,
     +       .000000003863466D0, .000000000593677D0, .000000000105262D0,
     +       .000000000021152D0, .000000000004750D0, .136181537582067D0,
     +       .001607810361063D0, .000056947238290D0, .000003361702378D0,
     +       .000000277826643D0, .000000029521131D0, .000000003833913D0,
     +       .000000000588440D0, .000000000104210D0, .000000000020916D0,
     +       .000000000004692D0, .136101218178099D0, .001604967195496D0,
     +       .000056779499841D0, .000003347847868D0, .000000276355366D0,
     +       .000000029330169D0, .000000003804621D0, .000000000583256D0,
     +       .000000000103170D0, .000000000020683D0, .000000000004634D0,
     +       .136021040723024D0, .001602132399564D0, .000056612452281D0,
     +       .000003334066683D0, .000000274893602D0, .000000029140664D0,
     +       .000000003775587D0, .000000000578123D0, .000000000102142D0,
     +       .000000000020452D0, .000000000004577D0/
         DATA  ((FTABLE (I,J),I=0,10),J=850,859)
     +     / .135941004799223D0, .001599305938814D0, .000056446091958D0,
     +       .000003320358350D0, .000000273441276D0, .000000028952606D0,
     +       .000000003746808D0, .000000000573041D0, .000000000101125D0,
     +       .000000000020225D0, .000000000004521D0, .135861109990794D0,
     +       .001596487778975D0, .000056280415240D0, .000003306722400D0,
     +       .000000271998317D0, .000000028765979D0, .000000003718282D0,
     +       .000000000568010D0, .000000000100119D0, .000000000020000D0,
     +       .000000000004465D0, .135781355883545D0, .001593677885957D0,
     +       .000056115418520D0, .000003293158364D0, .000000270564654D0,
     +       .000000028580773D0, .000000003690006D0, .000000000563029D0,
     +       .000000000099125D0, .000000000019778D0, .000000000004411D0,
     +       .135701742064983D0, .001590876225850D0, .000055951098213D0,
     +       .000003279665780D0, .000000269140216D0, .000000028396975D0,
     +       .000000003661978D0, .000000000558097D0, .000000000098141D0,
     +       .000000000019559D0, .000000000004357D0, .135622268124307D0,
     +       .001588082764922D0, .000055787450758D0, .000003266244190D0,
     +       .000000267724934D0, .000000028214571D0, .000000003634195D0,
     +       .000000000553215D0, .000000000097169D0, .000000000019343D0,
     +       .000000000004303D0, .135542933652397D0, .001585297469619D0,
     +       .000055624472618D0, .000003252893136D0, .000000266318736D0,
     +       .000000028033551D0, .000000003606656D0, .000000000548380D0,
     +       .000000000096207D0, .000000000019129D0, .000000000004251D0,
     +       .135463738241808D0, .001582520306563D0, .000055462160277D0,
     +       .000003239612166D0, .000000264921556D0, .000000027853902D0,
     +       .000000003579357D0, .000000000543594D0, .000000000095256D0,
     +       .000000000018918D0, .000000000004199D0, .135384681486757D0,
     +       .001579751242553D0, .000055300510241D0, .000003226400831D0,
     +       .000000263533323D0, .000000027675612D0, .000000003552296D0,
     +       .000000000538855D0, .000000000094315D0, .000000000018709D0,
     +       .000000000004148D0, .135305762983119D0, .001576990244558D0,
     +       .000055139519041D0, .000003213258685D0, .000000262153972D0,
     +       .000000027498668D0, .000000003525470D0, .000000000534162D0,
     +       .000000000093385D0, .000000000018503D0, .000000000004097D0,
     +       .135226982328415D0, .001574237279725D0, .000054979183227D0,
     +       .000003200185287D0, .000000260783434D0, .000000027323061D0,
     +       .000000003498879D0, .000000000529516D0, .000000000092465D0,
     +       .000000000018299D0, .000000000004048D0/
         DATA  ((FTABLE (I,J),I=0,10),J=860,869)
     +     / .135148339121805D0, .001571492315370D0, .000054819499373D0,
     +       .000003187180196D0, .000000259421644D0, .000000027148777D0,
     +       .000000003472518D0, .000000000524916D0, .000000000091555D0,
     +       .000000000018098D0, .000000000003998D0, .135069832964079D0,
     +       .001568755318979D0, .000054660464076D0, .000003174242978D0,
     +       .000000258068535D0, .000000026975805D0, .000000003446386D0,
     +       .000000000520360D0, .000000000090655D0, .000000000017899D0,
     +       .000000000003950D0, .134991463457647D0, .001566026258209D0,
     +       .000054502073952D0, .000003161373199D0, .000000256724042D0,
     +       .000000026804134D0, .000000003420481D0, .000000000515850D0,
     +       .000000000089765D0, .000000000017703D0, .000000000003902D0,
     +       .134913230206534D0, .001563305100887D0, .000054344325639D0,
     +       .000003148570431D0, .000000255388100D0, .000000026633753D0,
     +       .000000003394801D0, .000000000511384D0, .000000000088885D0,
     +       .000000000017509D0, .000000000003855D0, .134835132816368D0,
     +       .001560591815004D0, .000054187215799D0, .000003135834248D0,
     +       .000000254060645D0, .000000026464651D0, .000000003369342D0,
     +       .000000000506961D0, .000000000088014D0, .000000000017318D0,
     +       .000000000003808D0, .134757170894374D0, .001557886368721D0,
     +       .000054030741112D0, .000003123164226D0, .000000252741614D0,
     +       .000000026296815D0, .000000003344104D0, .000000000502582D0,
     +       .000000000087153D0, .000000000017128D0, .000000000003762D0,
     +       .134679344049364D0, .001555188730362D0, .000053874898280D0,
     +       .000003110559947D0, .000000251430943D0, .000000026130237D0,
     +       .000000003319083D0, .000000000498246D0, .000000000086301D0,
     +       .000000000016941D0, .000000000003717D0, .134601651891731D0,
     +       .001552498868417D0, .000053719684028D0, .000003098020994D0,
     +       .000000250128569D0, .000000025964903D0, .000000003294278D0,
     +       .000000000493952D0, .000000000085459D0, .000000000016757D0,
     +       .000000000003672D0, .134524094033438D0, .001549816751537D0,
     +       .000053565095099D0, .000003085546953D0, .000000248834432D0,
     +       .000000025800805D0, .000000003269687D0, .000000000489700D0,
     +       .000000000084626D0, .000000000016574D0, .000000000003628D0,
     +       .134446670088012D0, .001547142348539D0, .000053411128258D0,
     +       .000003073137414D0, .000000247548468D0, .000000025637931D0,
     +       .000000003245308D0, .000000000485489D0, .000000000083801D0,
     +       .000000000016394D0, .000000000003584D0/
         DATA  ((FTABLE (I,J),I=0,10),J=870,879)
     +     / .134369379670537D0, .001544475628397D0, .000053257780290D0,
     +       .000003060791971D0, .000000246270618D0, .000000025476271D0,
     +       .000000003221138D0, .000000000481319D0, .000000000082986D0,
     +       .000000000016216D0, .000000000003541D0, .134292222397640D0,
     +       .001541816560248D0, .000053105047999D0, .000003048510218D0,
     +       .000000245000821D0, .000000025315814D0, .000000003197175D0,
     +       .000000000477190D0, .000000000082180D0, .000000000016040D0,
     +       .000000000003499D0, .134215197887490D0, .001539165113389D0,
     +       .000052952928213D0, .000003036291755D0, .000000243739017D0,
     +       .000000025156550D0, .000000003173418D0, .000000000473101D0,
     +       .000000000081382D0, .000000000015866D0, .000000000003457D0,
     +       .134138305759788D0, .001536521257271D0, .000052801417776D0,
     +       .000003024136184D0, .000000242485146D0, .000000024998469D0,
     +       .000000003149864D0, .000000000469052D0, .000000000080593D0,
     +       .000000000015694D0, .000000000003416D0, .134061545635757D0,
     +       .001533884961508D0, .000052650513553D0, .000003012043109D0,
     +       .000000241239151D0, .000000024841560D0, .000000003126512D0,
     +       .000000000465042D0, .000000000079813D0, .000000000015524D0,
     +       .000000000003375D0, .133984917138136D0, .001531256195864D0,
     +       .000052500212430D0, .000003000012139D0, .000000240000971D0,
     +       .000000024685814D0, .000000003103359D0, .000000000461071D0,
     +       .000000000079041D0, .000000000015356D0, .000000000003335D0,
     +       .133908419891170D0, .001528634930265D0, .000052350511310D0,
     +       .000002988042883D0, .000000238770550D0, .000000024531221D0,
     +       .000000003080404D0, .000000000457138D0, .000000000078277D0,
     +       .000000000015191D0, .000000000003295D0, .133832053520607D0,
     +       .001526021134785D0, .000052201407119D0, .000002976134955D0,
     +       .000000237547830D0, .000000024377770D0, .000000003057645D0,
     +       .000000000453243D0, .000000000077522D0, .000000000015027D0,
     +       .000000000003256D0, .133755817653686D0, .001523414779655D0,
     +       .000052052896799D0, .000002964287973D0, .000000236332754D0,
     +       .000000024225453D0, .000000003035080D0, .000000000449385D0,
     +       .000000000076774D0, .000000000014865D0, .000000000003217D0,
     +       .133679711919130D0, .001520815835257D0, .000051904977313D0,
     +       .000002952501554D0, .000000235125266D0, .000000024074259D0,
     +       .000000003012706D0, .000000000445565D0, .000000000076035D0,
     +       .000000000014705D0, .000000000003179D0/
         DATA  ((FTABLE (I,J),I=0,10),J=880,889)
     +     / .133603735947139D0, .001518224272127D0, .000051757645641D0,
     +       .000002940775320D0, .000000233925310D0, .000000023924179D0,
     +       .000000002990522D0, .000000000441782D0, .000000000075304D0,
     +       .000000000014547D0, .000000000003141D0, .133527889369385D0,
     +       .001515640060946D0, .000051610898784D0, .000002929108898D0,
     +       .000000232732830D0, .000000023775204D0, .000000002968527D0,
     +       .000000000438035D0, .000000000074580D0, .000000000014391D0,
     +       .000000000003104D0, .133452171818998D0, .001513063172551D0,
     +       .000051464733760D0, .000002917501914D0, .000000231547771D0,
     +       .000000023627324D0, .000000002946718D0, .000000000434324D0,
     +       .000000000073865D0, .000000000014237D0, .000000000003067D0,
     +       .133376582930567D0, .001510493577923D0, .000051319147608D0,
     +       .000002905953998D0, .000000230370079D0, .000000023480529D0,
     +       .000000002925094D0, .000000000430648D0, .000000000073157D0,
     +       .000000000014084D0, .000000000003031D0, .133301122340125D0,
     +       .001507931248191D0, .000051174137382D0, .000002894464784D0,
     +       .000000229199700D0, .000000023334811D0, .000000002903653D0,
     +       .000000000427008D0, .000000000072456D0, .000000000013934D0,
     +       .000000000002995D0, .133225789685145D0, .001505376154634D0,
     +       .000051029700157D0, .000002883033907D0, .000000228036580D0,
     +       .000000023190161D0, .000000002882393D0, .000000000423402D0,
     +       .000000000071763D0, .000000000013785D0, .000000000002959D0,
     +       .133150584604535D0, .001502828268674D0, .000050885833025D0,
     +       .000002871661006D0, .000000226880666D0, .000000023046569D0,
     +       .000000002861312D0, .000000000419831D0, .000000000071078D0,
     +       .000000000013638D0, .000000000002925D0, .133075506738625D0,
     +       .001500287561879D0, .000050742533096D0, .000002860345721D0,
     +       .000000225731906D0, .000000022904027D0, .000000002840409D0,
     +       .000000000416294D0, .000000000070399D0, .000000000013493D0,
     +       .000000000002890D0, .133000555729165D0, .001497754005959D0,
     +       .000050599797499D0, .000002849087697D0, .000000224590246D0,
     +       .000000022762525D0, .000000002819682D0, .000000000412791D0,
     +       .000000000069728D0, .000000000013349D0, .000000000002856D0,
     +       .132925731219317D0, .001495227572771D0, .000050457623378D0,
     +       .000002837886579D0, .000000223455636D0, .000000022622055D0,
     +       .000000002799129D0, .000000000409322D0, .000000000069064D0,
     +       .000000000013207D0, .000000000002823D0/
         DATA  ((FTABLE (I,J),I=0,10),J=890,899)
     +     / .132851032853643D0, .001492708234311D0, .000050316007898D0,
     +       .000002826742017D0, .000000222328024D0, .000000022482609D0,
     +       .000000002778749D0, .000000000405885D0, .000000000068408D0,
     +       .000000000013067D0, .000000000002790D0, .132776460278105D0,
     +       .001490195962717D0, .000050174948240D0, .000002815653661D0,
     +       .000000221207358D0, .000000022344178D0, .000000002758540D0,
     +       .000000000402481D0, .000000000067758D0, .000000000012928D0,
     +       .000000000002757D0, .132702013140052D0, .001487690730270D0,
     +       .000050034441601D0, .000002804621166D0, .000000220093589D0,
     +       .000000022206752D0, .000000002738501D0, .000000000399109D0,
     +       .000000000067115D0, .000000000012791D0, .000000000002725D0,
     +       .132627691088218D0, .001485192509387D0, .000049894485198D0,
     +       .000002793644188D0, .000000218986666D0, .000000022070325D0,
     +       .000000002718629D0, .000000000395769D0, .000000000066479D0,
     +       .000000000012655D0, .000000000002693D0, .132553493772712D0,
     +       .001482701272625D0, .000049755076263D0, .000002782722386D0,
     +       .000000217886540D0, .000000021934887D0, .000000002698923D0,
     +       .000000000392461D0, .000000000065849D0, .000000000012522D0,
     +       .000000000002661D0, .132479420845009D0, .001480216992682D0,
     +       .000049616212045D0, .000002771855422D0, .000000216793161D0,
     +       .000000021800430D0, .000000002679382D0, .000000000389184D0,
     +       .000000000065226D0, .000000000012389D0, .000000000002630D0,
     +       .132405471957949D0, .001477739642388D0, .000049477889812D0,
     +       .000002761042958D0, .000000215706481D0, .000000021666946D0,
     +       .000000002660004D0, .000000000385938D0, .000000000064610D0,
     +       .000000000012259D0, .000000000002599D0, .132331646765727D0,
     +       .001475269194713D0, .000049340106847D0, .000002750284663D0,
     +       .000000214626451D0, .000000021534427D0, .000000002640788D0,
     +       .000000000382723D0, .000000000064000D0, .000000000012129D0,
     +       .000000000002569D0, .132257944923883D0, .001472805622760D0,
     +       .000049202860449D0, .000002739580203D0, .000000213553023D0,
     +       .000000021402864D0, .000000002621732D0, .000000000379538D0,
     +       .000000000063397D0, .000000000012002D0, .000000000002539D0,
     +       .132184366089301D0, .001470348899770D0, .000049066147934D0,
     +       .000002728929251D0, .000000212486149D0, .000000021272251D0,
     +       .000000002602834D0, .000000000376383D0, .000000000062800D0,
     +       .000000000011875D0, .000000000002510D0/
         DATA  ((FTABLE (I,J),I=0,10),J=900,909)
     +     / .132110909920200D0, .001467898999113D0, .000048929966637D0,
     +       .000002718331480D0, .000000211425782D0, .000000021142578D0,
     +       .000000002584093D0, .000000000373258D0, .000000000062210D0,
     +       .000000000011751D0, .000000000002481D0, .132037576076126D0,
     +       .001465455894297D0, .000048794313906D0, .000002707786565D0,
     +       .000000210371875D0, .000000021013839D0, .000000002565508D0,
     +       .000000000370162D0, .000000000061625D0, .000000000011627D0,
     +       .000000000002452D0, .131964364217946D0, .001463019558957D0,
     +       .000048659187105D0, .000002697294185D0, .000000209324382D0,
     +       .000000020886025D0, .000000002547076D0, .000000000367095D0,
     +       .000000000061047D0, .000000000011506D0, .000000000002424D0,
     +       .131891274007843D0, .001460589966864D0, .000048524583617D0,
     +       .000002686854021D0, .000000208283257D0, .000000020759129D0,
     +       .000000002528798D0, .000000000364057D0, .000000000060475D0,
     +       .000000000011385D0, .000000000002396D0, .131818305109307D0,
     +       .001458167091917D0, .000048390500838D0, .000002676465754D0,
     +       .000000207248454D0, .000000020633143D0, .000000002510670D0,
     +       .000000000361048D0, .000000000059908D0, .000000000011266D0,
     +       .000000000002368D0, .131745457187132D0, .001455750908145D0,
     +       .000048256936182D0, .000002666129071D0, .000000206219928D0,
     +       .000000020508059D0, .000000002492692D0, .000000000358066D0,
     +       .000000000059348D0, .000000000011148D0, .000000000002341D0,
     +       .131672729907404D0, .001453341389706D0, .000048123887076D0,
     +       .000002655843658D0, .000000205197634D0, .000000020383871D0,
     +       .000000002474863D0, .000000000355113D0, .000000000058794D0,
     +       .000000000011032D0, .000000000002314D0, .131600122937501D0,
     +       .001450938510888D0, .000047991350967D0, .000002645609204D0,
     +       .000000204181526D0, .000000020260570D0, .000000002457181D0,
     +       .000000000352187D0, .000000000058245D0, .000000000010917D0,
     +       .000000000002287D0, .131527635946081D0, .001448542246102D0,
     +       .000047859325312D0, .000002635425403D0, .000000203171562D0,
     +       .000000020138150D0, .000000002439644D0, .000000000349288D0,
     +       .000000000057702D0, .000000000010803D0, .000000000002261D0,
     +       .131455268603081D0, .001446152569891D0, .000047727807587D0,
     +       .000002625291946D0, .000000202167697D0, .000000020016604D0,
     +       .000000002422251D0, .000000000346417D0, .000000000057164D0,
     +       .000000000010691D0, .000000000002235D0/
         DATA  ((FTABLE (I,J),I=0,10),J=910,919)
     +     / .131383020579705D0, .001443769456920D0, .000047596795283D0,
     +       .000002615208532D0, .000000201169887D0, .000000019895923D0,
     +       .000000002405002D0, .000000000343572D0, .000000000056633D0,
     +       .000000000010580D0, .000000000002209D0, .131310891548422D0,
     +       .001441392881980D0, .000047466285905D0, .000002605174858D0,
     +       .000000200178090D0, .000000019776101D0, .000000002387894D0,
     +       .000000000340753D0, .000000000056106D0, .000000000010470D0,
     +       .000000000002184D0, .131238881182958D0, .001439022819989D0,
     +       .000047336276973D0, .000002595190624D0, .000000199192263D0,
     +       .000000019657131D0, .000000002370926D0, .000000000337961D0,
     +       .000000000055586D0, .000000000010361D0, .000000000002159D0,
     +       .131166989158290D0, .001436659245983D0, .000047206766024D0,
     +       .000002585255533D0, .000000198212363D0, .000000019539006D0,
     +       .000000002354097D0, .000000000335195D0, .000000000055070D0,
     +       .000000000010254D0, .000000000002134D0, .131095215150641D0,
     +       .001434302135127D0, .000047077750606D0, .000002575369289D0,
     +       .000000197238348D0, .000000019421719D0, .000000002337406D0,
     +       .000000000332454D0, .000000000054560D0, .000000000010148D0,
     +       .000000000002110D0, .131023558837470D0, .001431951462705D0,
     +       .000046949228285D0, .000002565531600D0, .000000196270177D0,
     +       .000000019305263D0, .000000002320851D0, .000000000329738D0,
     +       .000000000054055D0, .000000000010043D0, .000000000002085D0,
     +       .130952019897473D0, .001429607204121D0, .000046821196642D0,
     +       .000002555742175D0, .000000195307808D0, .000000019189632D0,
     +       .000000002304432D0, .000000000327048D0, .000000000053556D0,
     +       .000000000009939D0, .000000000002062D0, .130880598010569D0,
     +       .001427269334903D0, .000046693653268D0, .000002546000723D0,
     +       .000000194351200D0, .000000019074818D0, .000000002288146D0,
     +       .000000000324383D0, .000000000053062D0, .000000000009837D0,
     +       .000000000002038D0, .130809292857899D0, .001424937830696D0,
     +       .000046566595774D0, .000002536306959D0, .000000193400313D0,
     +       .000000018960815D0, .000000002271993D0, .000000000321742D0,
     +       .000000000052572D0, .000000000009736D0, .000000000002015D0,
     +       .130738104121820D0, .001422612667267D0, .000046440021782D0,
     +       .000002526660598D0, .000000192455105D0, .000000018847616D0,
     +       .000000002255971D0, .000000000319125D0, .000000000052088D0,
     +       .000000000009635D0, .000000000001992D0/
         DATA  ((FTABLE (I,J),I=0,10),J=920,920)
     +     / .130667031485895D0, .001420293820499D0, .000046313928929D0,
     +       .000002517061355D0, .000000191515538D0, .000000018735216D0,
     +       .000000002240080D0, .000000000316533D0, .000000000051609D0,
     +       .000000000009536D0, .000000000001969D0/
