/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.FilterResult;

class CompositeFilter<T>
implements Filter<T> {
    private static final Filter ALWAYS_INCLUDED_FILTER = new Filter(){

        public FilterResult apply(Object obj) {
            return ALWAYS_INCLUDED_RESULT;
        }

        public Predicate toPredicate() {
            return obj -> true;
        }
    };
    private static final FilterResult ALWAYS_INCLUDED_RESULT = FilterResult.included("Always included");
    private static final FilterResult INCLUDED_BY_ALL_FILTERS = FilterResult.included("Element was included by all filters.");
    private final Collection<Filter<T>> filters;

    static <T> Filter<T> alwaysIncluded() {
        return ALWAYS_INCLUDED_FILTER;
    }

    CompositeFilter(Collection<? extends Filter<T>> filters) {
        this.filters = new ArrayList<Filter<T>>(Preconditions.notEmpty(filters, (String)"filters must not be empty"));
    }

    @Override
    public FilterResult apply(T element) {
        return this.filters.stream().map(filter -> filter.apply(element)).filter(FilterResult::excluded).findFirst().orElse(INCLUDED_BY_ALL_FILTERS);
    }

    @Override
    public Predicate<T> toPredicate() {
        return this.filters.stream().map(Filter::toPredicate).reduce(Predicate::and).get();
    }

    public String toString() {
        return this.filters.stream().map(Object::toString).map(value -> String.format("(%s)", value)).collect(Collectors.joining(" and "));
    }
}

