; Java Library
;
; Copyright (C) 2020 Kestrel Institute (http://www.kestrel.edu)
;
; License: A 3-clause BSD license. See the LICENSE file distributed with ACL2.
;
; Author: Alessandro Coglio (coglio@kestrel.edu)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "JAVA")

(include-book "../language/primitive-types")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; This function, which was in shallow-code-generation.lisp,
; is now in a separate file because it is used by post-translation.lisp.
; This way we avoid including the former file into the latter file.

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define atj-primarray-write-method-name ((type primitive-typep))
  :returns (name stringp)
  :parents (atj-shallow-code-generation)
  :short "Name of the method generated by
          @(tsee atj-gen-shallow-primarray-write-method)."
  :long
  (xdoc::topstring-p
   "See that function for details.")
  (primitive-type-case type
                       :boolean "writeBooleanArray"
                       :char "writeCharArray"
                       :byte "writeByteArray"
                       :short "writeShortArray"
                       :int "writeIntArray"
                       :long "writeLongArray"
                       :float "writeFloatArray"
                       :double "writeDoubleArray"))
